"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpRoute = exports.HttpRouteKey = exports.HttpMethod = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
/**
 * (experimental) Supported HTTP methods.
 *
 * @experimental
 */
var HttpMethod;
(function (HttpMethod) {
    HttpMethod["ANY"] = "ANY";
    HttpMethod["DELETE"] = "DELETE";
    HttpMethod["GET"] = "GET";
    HttpMethod["HEAD"] = "HEAD";
    HttpMethod["OPTIONS"] = "OPTIONS";
    HttpMethod["PATCH"] = "PATCH";
    HttpMethod["POST"] = "POST";
    HttpMethod["PUT"] = "PUT";
})(HttpMethod = exports.HttpMethod || (exports.HttpMethod = {}));
/**
 * (experimental) HTTP route in APIGateway is a combination of the HTTP method and the path component.
 *
 * This class models that combination.
 *
 * @experimental
 */
class HttpRouteKey {
    constructor(key, path) {
        this.key = key;
        this.path = path;
    }
    /**
     * (experimental) Create a route key with the combination of the path and the method.
     *
     * @param method default is 'ANY'.
     * @experimental
     */
    static with(path, method) {
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_HttpMethod(method);
        if (path !== '/' && (!path.startsWith('/') || path.endsWith('/'))) {
            throw new Error('A route path must always start with a "/" and not end with a "/"');
        }
        return new HttpRouteKey(`${method !== null && method !== void 0 ? method : HttpMethod.ANY} ${path}`, path);
    }
}
exports.HttpRouteKey = HttpRouteKey;
_a = JSII_RTTI_SYMBOL_1;
HttpRouteKey[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.HttpRouteKey", version: "2.3.0-alpha.0" };
/**
 * (experimental) The catch-all route of the API, i.e., when no other routes match.
 *
 * @experimental
 */
HttpRouteKey.DEFAULT = new HttpRouteKey('$default');
/**
 * Supported Route Authorizer types
 */
var HttpRouteAuthorizationType;
(function (HttpRouteAuthorizationType) {
    /** JSON Web Tokens */
    HttpRouteAuthorizationType["JWT"] = "JWT";
    /** Lambda Authorizer */
    HttpRouteAuthorizationType["CUSTOM"] = "CUSTOM";
    /** No authorizer */
    HttpRouteAuthorizationType["NONE"] = "NONE";
})(HttpRouteAuthorizationType || (HttpRouteAuthorizationType = {}));
/**
 * (experimental) Route class that creates the Route for API Gateway HTTP API.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::Route
 */
class HttpRoute extends aws_cdk_lib_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _c;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_HttpRouteProps(props);
        this.httpApi = props.httpApi;
        this.path = props.routeKey.path;
        const config = props.integration._bindToRoute({
            route: this,
            scope: this,
        });
        const authBindResult = props.authorizer ? props.authorizer.bind({
            route: this,
            scope: this.httpApi instanceof constructs_1.Construct ? this.httpApi : this,
        }) : undefined;
        if (authBindResult && !(authBindResult.authorizationType in HttpRouteAuthorizationType)) {
            throw new Error('authorizationType should either be JWT, CUSTOM, or NONE');
        }
        let authorizationScopes = authBindResult === null || authBindResult === void 0 ? void 0 : authBindResult.authorizationScopes;
        if (authBindResult && props.authorizationScopes) {
            authorizationScopes = Array.from(new Set([
                ...authorizationScopes !== null && authorizationScopes !== void 0 ? authorizationScopes : [],
                ...props.authorizationScopes,
            ]));
        }
        if ((authorizationScopes === null || authorizationScopes === void 0 ? void 0 : authorizationScopes.length) === 0) {
            authorizationScopes = undefined;
        }
        const routeProps = {
            apiId: props.httpApi.apiId,
            routeKey: props.routeKey.key,
            target: `integrations/${config.integrationId}`,
            authorizerId: authBindResult === null || authBindResult === void 0 ? void 0 : authBindResult.authorizerId,
            authorizationType: (_c = authBindResult === null || authBindResult === void 0 ? void 0 : authBindResult.authorizationType) !== null && _c !== void 0 ? _c : 'NONE',
            authorizationScopes,
        };
        const route = new aws_apigatewayv2_1.CfnRoute(this, 'Resource', routeProps);
        this.routeId = route.ref;
    }
}
exports.HttpRoute = HttpRoute;
_b = JSII_RTTI_SYMBOL_1;
HttpRoute[_b] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.HttpRoute", version: "2.3.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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