module.exports =
/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const aws_sdk_1 = __webpack_require__(1);
const get_env_or_die_1 = __webpack_require__(2);
const codeCommit = new aws_sdk_1.CodeCommit();
const handler = async (event) => {
    const { region, detail } = event;
    const shouldUpdateApprovalState = get_env_or_die_1.getBoolEnv('UPDATE_APPROVAL_STATE', false);
    const shouldPostComment = get_env_or_die_1.getBoolEnv('POST_COMMENT', false);
    const { pullRequestId, revisionId, repositoryName, beforeCommitId, afterCommitId } = getPullRequestProps(detail);
    const s3Prefix = region === 'us-east-1' ? 's3' : `s3-${region}`;
    switch (detail['build-status']) {
        case CodeBuildState.IN_PROGRESS:
            if (shouldUpdateApprovalState) {
                await codeCommit
                    .updatePullRequestApprovalState({
                    pullRequestId,
                    revisionId,
                    approvalState: 'REVOKE',
                })
                    .promise();
            }
            if (shouldPostComment) {
                await codeCommit
                    .postCommentForPullRequest({
                    pullRequestId,
                    repositoryName,
                    beforeCommitId,
                    afterCommitId,
                    content: `** Build started at ${'time'} **`,
                })
                    .promise();
            }
            break;
        case CodeBuildState.FAILED:
            if (shouldPostComment) {
                const badge = `https://${s3Prefix}.amazonaws.com/codefactory-${region}-prod-default-build-badges/failing.svg`;
                const content = `![Failing](${badge} "Failing") - See the [Logs](${detail['additional-information'].logs['deep-link']})`;
                await codeCommit
                    .postCommentForPullRequest({
                    pullRequestId,
                    repositoryName,
                    beforeCommitId,
                    afterCommitId,
                    content,
                })
                    .promise();
            }
            break;
        case CodeBuildState.SUCCEEDED:
            if (shouldUpdateApprovalState) {
                await codeCommit
                    .updatePullRequestApprovalState({
                    pullRequestId,
                    revisionId,
                    approvalState: 'APPROVE',
                })
                    .promise();
            }
            if (shouldPostComment) {
                const badge = `https://${s3Prefix}.amazonaws.com/codefactory-${region}-prod-default-build-badges/passing.svg`;
                const content = `![Passing](${badge} "Passing") - See the [Logs](${detail['additional-information'].logs['deep-link']})`;
                await codeCommit
                    .postCommentForPullRequest({
                    pullRequestId,
                    repositoryName,
                    beforeCommitId,
                    afterCommitId,
                    content,
                })
                    .promise();
            }
            break;
        case CodeBuildState.STOPPED:
            console.log('Build stopped!');
            break;
        default:
            throw new Error(`Invalid build status: ${detail['build-status']}`);
    }
};
exports.handler = handler;
const getPullRequestProps = (detail) => {
    let repositoryName = '';
    let pullRequestId = '';
    let beforeCommitId = '';
    let afterCommitId = '';
    let revisionId = '';
    detail['additional-information'].environment['environment-variables'].forEach(({ name, value }) => {
        switch (name) {
            case 'pullRequestId':
                pullRequestId = value;
                break;
            case 'repositoryName':
                repositoryName = value;
                break;
            case 'sourceCommit':
                beforeCommitId = value;
                break;
            case 'destinationCommit':
                afterCommitId = value;
                break;
            case 'revisionId':
                revisionId = value;
                break;
        }
    });
    return {
        repositoryName,
        pullRequestId,
        beforeCommitId,
        afterCommitId,
        revisionId,
    };
};
var CodeBuildState;
(function (CodeBuildState) {
    CodeBuildState["IN_PROGRESS"] = "IN_PROGRESS";
    CodeBuildState["SUCCEEDED"] = "SUCCEEDED";
    CodeBuildState["FAILED"] = "FAILED";
    CodeBuildState["STOPPED"] = "STOPPED";
})(CodeBuildState || (CodeBuildState = {}));


/***/ }),
/* 1 */
/***/ (function(module, exports) {

module.exports = require("aws-sdk");

/***/ }),
/* 2 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.getRegExpEnv = exports.getDateEnv = exports.getUrlEnv = exports.getArrayEnv = exports.getBoolEnv = exports.getIntEnv = exports.getStringEnv = exports.getEnv = void 0;
const url_1 = __webpack_require__(3);
const getEnv = (name, fallback) => {
    return (0, exports.getStringEnv)(name, fallback);
};
exports.getEnv = getEnv;
const getStringEnv = (name, fallback) => {
    return genericGetEnv(name, fallback);
};
exports.getStringEnv = getStringEnv;
const getIntEnv = (name, fallback) => {
    const env = genericGetEnv(name, fallback);
    const int = parseInt(env, 10);
    if (isNaN(int)) {
        throw new Error(`Env ${name} is not an integer.`);
    }
    return int;
};
exports.getIntEnv = getIntEnv;
const getBoolEnv = (name, fallback) => {
    let env = genericGetEnv(name, fallback);
    if (typeof env === 'boolean')
        return env;
    env = env.toLowerCase();
    if (env === '1' || env === 'true')
        return true;
    if (env === '0' || env === 'false')
        return false;
    throw new Error(`Env ${name} is not a boolean.`);
};
exports.getBoolEnv = getBoolEnv;
const getArrayEnv = (name, fallback) => {
    const env = genericGetEnv(name, fallback);
    if (Array.isArray(env))
        return env;
    return env.split(',');
};
exports.getArrayEnv = getArrayEnv;
const getUrlEnv = (name, fallback) => {
    const env = genericGetEnv(name, fallback);
    try {
        return new url_1.URL(env);
    }
    catch (_a) {
        throw new Error(`Env ${name} is not an url.`);
    }
};
exports.getUrlEnv = getUrlEnv;
const getDateEnv = (name, fallback) => {
    const env = genericGetEnv(name, fallback);
    const date = new Date(env);
    if (date.toString() === 'Invalid Date') {
        throw new Error(`Env ${name} is not a date.`);
    }
    return date;
};
exports.getDateEnv = getDateEnv;
const getRegExpEnv = (name, fallback) => {
    const env = genericGetEnv(name, fallback);
    if (env instanceof RegExp)
        return env;
    try {
        const match = env.match(new RegExp('^/(.*?)/([gimy]*)$'));
        return new RegExp(match[1], match[2]);
    }
    catch (_a) {
        throw new Error(`Env ${name} is not a regExp.`);
    }
};
exports.getRegExpEnv = getRegExpEnv;
const genericGetEnv = (name, fallback) => {
    const env = process.env[name];
    if (env)
        return env;
    if (fallback !== undefined)
        return fallback;
    throw new Error(`Env ${name} does not exist and no fallback value provided.`);
};
//# sourceMappingURL=data:application/json;base64,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

/***/ }),
/* 3 */
/***/ (function(module, exports) {

module.exports = require("url");

/***/ })
/******/ ]);
//# sourceMappingURL=index.js.map