# generated by datamodel-codegen:
#   filename:  queue_message.json
#   timestamp: 2022-02-09T13:11:55+00:00

from __future__ import annotations

from typing import Any, Optional, Union

from pydantic import Field
from typing_extensions import Literal
from utf_queue_client.models.base_model import BaseModelWithValidation


class Model(BaseModelWithValidation):
    __root__: Any


class SqaTestResultRecord(BaseModelWithValidation):
    testCaseId: str
    status: Literal['failed', 'passed', 'skipped']
    testResult: Literal['failed', 'passed', 'skipped']
    testResultType: Literal[
        'DURATION',
        'FEATURE',
        'MEASUREMENT',
        'PERFORMANCE',
        'REGRESSION',
        'SMOKE',
        'SOAK',
    ]
    sessionId: str
    testStartTime: int
    testStopTime: int
    testDurationSec: float
    engineerName: Optional[str] = None
    exceptionMsg: Optional[str] = None
    failureReasonCode: Optional[float] = None
    featureName: Optional[str] = None
    moduleName: Optional[str] = None
    notes: Optional[str] = None
    phyName: Optional[str] = None
    portalWatch: Optional[str] = None
    portalWatchNum: Optional[int] = None
    IOTREQDescription: Optional[str] = None
    IOTREQNum: Optional[int] = None
    testSuiteName: Optional[str] = None
    testBedName: Optional[str] = None
    parametricData: Optional[str] = None
    toolChain: Optional[str] = None
    vendorBuild: Optional[str] = None
    vendorName: Optional[str] = None
    vendorResult: Optional[str] = None
    vmName: Optional[str] = None


class SqaTestSessionMetadata(BaseModelWithValidation):
    sessionId: str
    sessionStartTime: float
    sessionStopTime: Optional[float] = None
    sessionDurationSec: Optional[float] = None
    status: str
    stackName: str
    jobType: Optional[str] = None
    releaseName: Optional[str] = None
    SDKBranchName: Optional[str] = None
    SDKBuildNum: Optional[int] = None
    SDKURL: Optional[str] = None
    studioBuildURL: Optional[str] = None
    totalTest: Optional[int] = None
    PASS_cnt: Optional[int] = None
    FAIL_cnt: Optional[int] = None
    SKIP_cnt: Optional[int] = None
    jenkinsServerName: Optional[str] = None
    jenkinsRunNum: Optional[int] = None
    jenkinsJobName: Optional[str] = None
    jenkinsTestResultsUrl: Optional[str] = None
    jobBuildNum: Optional[int] = None
    jobBuildURL: Optional[str] = None
    studioBranchName: Optional[str] = None
    studioBuildNum: Optional[int] = None
    parentBuildNum: Optional[int] = None
    parentBuildURL: Optional[str] = None


class LogEvent(BaseModelWithValidation):
    pass


class ExceptionEvent(BaseModelWithValidation):
    pass


class SqaTestEvent(BaseModelWithValidation):
    eventType: Literal['SESSION_COMPLETE', 'SESSION_START', 'TEST_RESULT']
    testResult: Optional[SqaTestResultRecord] = None
    testSessionMetadata: SqaTestSessionMetadata


class QueueMessage(BaseModelWithValidation):
    recordType: Literal['EXCEPTION_EVENT', 'LOG_EVENT', 'TEST_EVENT'] = Field(
        ..., description='Type of record'
    )
    payload: Union[SqaTestEvent, LogEvent, ExceptionEvent] = Field(
        ..., description='Record Payload'
    )
    timestamp: float = Field(
        ..., description='UTC Timestamp\nGiven in seconds since epoch (unix time)'
    )
