# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetDeviceResult',
    'AwaitableGetDeviceResult',
    'get_device',
    'get_device_output',
]

@pulumi.output_type
class GetDeviceResult:
    def __init__(__self__, device=None, tags=None):
        if device and not isinstance(device, dict):
            raise TypeError("Expected argument 'device' to be a dict")
        pulumi.set(__self__, "device", device)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def device(self) -> Optional['outputs.Device']:
        """
        The Edge Device you want to register against a device fleet
        """
        return pulumi.get(self, "device")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.DeviceTag']]:
        """
        Associate tags with the resource
        """
        return pulumi.get(self, "tags")


class AwaitableGetDeviceResult(GetDeviceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDeviceResult(
            device=self.device,
            tags=self.tags)


def get_device(device_fleet_name: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDeviceResult:
    """
    Resource schema for AWS::SageMaker::Device


    :param str device_fleet_name: The name of the edge device fleet
    """
    __args__ = dict()
    __args__['deviceFleetName'] = device_fleet_name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws-native:sagemaker:getDevice', __args__, opts=opts, typ=GetDeviceResult).value

    return AwaitableGetDeviceResult(
        device=__ret__.device,
        tags=__ret__.tags)


@_utilities.lift_output_func(get_device)
def get_device_output(device_fleet_name: Optional[pulumi.Input[str]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDeviceResult]:
    """
    Resource schema for AWS::SageMaker::Device


    :param str device_fleet_name: The name of the edge device fleet
    """
    ...
