# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RepositoryArgs', 'Repository']

@pulumi.input_type
class RepositoryArgs:
    def __init__(__self__, *,
                 domain_name: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 domain_owner: Optional[pulumi.Input[str]] = None,
                 external_connections: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 permissions_policy_document: Optional[Any] = None,
                 repository_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['RepositoryTagArgs']]]] = None,
                 upstreams: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Repository resource.
        :param pulumi.Input[str] domain_name: The name of the domain that contains the repository.
        :param pulumi.Input[str] description: A text description of the repository.
        :param pulumi.Input[str] domain_owner: The 12-digit account ID of the AWS account that owns the domain.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] external_connections: A list of external connections associated with the repository.
        :param Any permissions_policy_document: The access control resource policy on the provided repository.
        :param pulumi.Input[str] repository_name: The name of the repository.
        :param pulumi.Input[Sequence[pulumi.Input['RepositoryTagArgs']]] tags: An array of key-value pairs to apply to this resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] upstreams: A list of upstream repositories associated with the repository.
        """
        pulumi.set(__self__, "domain_name", domain_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain_owner is not None:
            pulumi.set(__self__, "domain_owner", domain_owner)
        if external_connections is not None:
            pulumi.set(__self__, "external_connections", external_connections)
        if permissions_policy_document is not None:
            pulumi.set(__self__, "permissions_policy_document", permissions_policy_document)
        if repository_name is not None:
            pulumi.set(__self__, "repository_name", repository_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if upstreams is not None:
            pulumi.set(__self__, "upstreams", upstreams)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[str]:
        """
        The name of the domain that contains the repository.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A text description of the repository.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="domainOwner")
    def domain_owner(self) -> Optional[pulumi.Input[str]]:
        """
        The 12-digit account ID of the AWS account that owns the domain.
        """
        return pulumi.get(self, "domain_owner")

    @domain_owner.setter
    def domain_owner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_owner", value)

    @property
    @pulumi.getter(name="externalConnections")
    def external_connections(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of external connections associated with the repository.
        """
        return pulumi.get(self, "external_connections")

    @external_connections.setter
    def external_connections(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "external_connections", value)

    @property
    @pulumi.getter(name="permissionsPolicyDocument")
    def permissions_policy_document(self) -> Optional[Any]:
        """
        The access control resource policy on the provided repository.
        """
        return pulumi.get(self, "permissions_policy_document")

    @permissions_policy_document.setter
    def permissions_policy_document(self, value: Optional[Any]):
        pulumi.set(self, "permissions_policy_document", value)

    @property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the repository.
        """
        return pulumi.get(self, "repository_name")

    @repository_name.setter
    def repository_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repository_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RepositoryTagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RepositoryTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def upstreams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of upstream repositories associated with the repository.
        """
        return pulumi.get(self, "upstreams")

    @upstreams.setter
    def upstreams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "upstreams", value)


class Repository(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 domain_owner: Optional[pulumi.Input[str]] = None,
                 external_connections: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 permissions_policy_document: Optional[Any] = None,
                 repository_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RepositoryTagArgs']]]]] = None,
                 upstreams: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        The resource schema to create a CodeArtifact repository.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A text description of the repository.
        :param pulumi.Input[str] domain_name: The name of the domain that contains the repository.
        :param pulumi.Input[str] domain_owner: The 12-digit account ID of the AWS account that owns the domain.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] external_connections: A list of external connections associated with the repository.
        :param Any permissions_policy_document: The access control resource policy on the provided repository.
        :param pulumi.Input[str] repository_name: The name of the repository.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RepositoryTagArgs']]]] tags: An array of key-value pairs to apply to this resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] upstreams: A list of upstream repositories associated with the repository.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RepositoryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The resource schema to create a CodeArtifact repository.

        :param str resource_name: The name of the resource.
        :param RepositoryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RepositoryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 domain_owner: Optional[pulumi.Input[str]] = None,
                 external_connections: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 permissions_policy_document: Optional[Any] = None,
                 repository_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RepositoryTagArgs']]]]] = None,
                 upstreams: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RepositoryArgs.__new__(RepositoryArgs)

            __props__.__dict__["description"] = description
            if domain_name is None and not opts.urn:
                raise TypeError("Missing required property 'domain_name'")
            __props__.__dict__["domain_name"] = domain_name
            __props__.__dict__["domain_owner"] = domain_owner
            __props__.__dict__["external_connections"] = external_connections
            __props__.__dict__["permissions_policy_document"] = permissions_policy_document
            __props__.__dict__["repository_name"] = repository_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["upstreams"] = upstreams
            __props__.__dict__["arn"] = None
            __props__.__dict__["name"] = None
        super(Repository, __self__).__init__(
            'aws-native:codeartifact:Repository',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Repository':
        """
        Get an existing Repository resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = RepositoryArgs.__new__(RepositoryArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["domain_name"] = None
        __props__.__dict__["domain_owner"] = None
        __props__.__dict__["external_connections"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["permissions_policy_document"] = None
        __props__.__dict__["repository_name"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["upstreams"] = None
        return Repository(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the repository.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A text description of the repository.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[str]:
        """
        The name of the domain that contains the repository.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="domainOwner")
    def domain_owner(self) -> pulumi.Output[str]:
        """
        The 12-digit account ID of the AWS account that owns the domain.
        """
        return pulumi.get(self, "domain_owner")

    @property
    @pulumi.getter(name="externalConnections")
    def external_connections(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of external connections associated with the repository.
        """
        return pulumi.get(self, "external_connections")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the repository. This is used for GetAtt
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="permissionsPolicyDocument")
    def permissions_policy_document(self) -> pulumi.Output[Optional[Any]]:
        """
        The access control resource policy on the provided repository.
        """
        return pulumi.get(self, "permissions_policy_document")

    @property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> pulumi.Output[str]:
        """
        The name of the repository.
        """
        return pulumi.get(self, "repository_name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.RepositoryTag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def upstreams(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of upstream repositories associated with the repository.
        """
        return pulumi.get(self, "upstreams")

