# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class WfmAgentScheduleUpdateTopicWfmAgentScheduleUpdateNotification(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        WfmAgentScheduleUpdateTopicWfmAgentScheduleUpdateNotification - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'user': 'WfmAgentScheduleUpdateTopicUserReference',
            'start_date': 'datetime',
            'end_date': 'datetime',
            'shifts': 'list[WfmAgentScheduleUpdateTopicWfmScheduleShift]',
            'full_day_time_off_markers': 'list[WfmAgentScheduleUpdateTopicWfmFullDayTimeOffMarker]',
            'updates': 'list[WfmAgentScheduleUpdateTopicWfmAgentScheduleUpdate]'
        }

        self.attribute_map = {
            'user': 'user',
            'start_date': 'startDate',
            'end_date': 'endDate',
            'shifts': 'shifts',
            'full_day_time_off_markers': 'fullDayTimeOffMarkers',
            'updates': 'updates'
        }

        self._user = None
        self._start_date = None
        self._end_date = None
        self._shifts = None
        self._full_day_time_off_markers = None
        self._updates = None

    @property
    def user(self):
        """
        Gets the user of this WfmAgentScheduleUpdateTopicWfmAgentScheduleUpdateNotification.


        :return: The user of this WfmAgentScheduleUpdateTopicWfmAgentScheduleUpdateNotification.
        :rtype: WfmAgentScheduleUpdateTopicUserReference
        """
        return self._user

    @user.setter
    def user(self, user):
        """
        Sets the user of this WfmAgentScheduleUpdateTopicWfmAgentScheduleUpdateNotification.


        :param user: The user of this WfmAgentScheduleUpdateTopicWfmAgentScheduleUpdateNotification.
        :type: WfmAgentScheduleUpdateTopicUserReference
        """
        
        self._user = user

    @property
    def start_date(self):
        """
        Gets the start_date of this WfmAgentScheduleUpdateTopicWfmAgentScheduleUpdateNotification.


        :return: The start_date of this WfmAgentScheduleUpdateTopicWfmAgentScheduleUpdateNotification.
        :rtype: datetime
        """
        return self._start_date

    @start_date.setter
    def start_date(self, start_date):
        """
        Sets the start_date of this WfmAgentScheduleUpdateTopicWfmAgentScheduleUpdateNotification.


        :param start_date: The start_date of this WfmAgentScheduleUpdateTopicWfmAgentScheduleUpdateNotification.
        :type: datetime
        """
        
        self._start_date = start_date

    @property
    def end_date(self):
        """
        Gets the end_date of this WfmAgentScheduleUpdateTopicWfmAgentScheduleUpdateNotification.


        :return: The end_date of this WfmAgentScheduleUpdateTopicWfmAgentScheduleUpdateNotification.
        :rtype: datetime
        """
        return self._end_date

    @end_date.setter
    def end_date(self, end_date):
        """
        Sets the end_date of this WfmAgentScheduleUpdateTopicWfmAgentScheduleUpdateNotification.


        :param end_date: The end_date of this WfmAgentScheduleUpdateTopicWfmAgentScheduleUpdateNotification.
        :type: datetime
        """
        
        self._end_date = end_date

    @property
    def shifts(self):
        """
        Gets the shifts of this WfmAgentScheduleUpdateTopicWfmAgentScheduleUpdateNotification.


        :return: The shifts of this WfmAgentScheduleUpdateTopicWfmAgentScheduleUpdateNotification.
        :rtype: list[WfmAgentScheduleUpdateTopicWfmScheduleShift]
        """
        return self._shifts

    @shifts.setter
    def shifts(self, shifts):
        """
        Sets the shifts of this WfmAgentScheduleUpdateTopicWfmAgentScheduleUpdateNotification.


        :param shifts: The shifts of this WfmAgentScheduleUpdateTopicWfmAgentScheduleUpdateNotification.
        :type: list[WfmAgentScheduleUpdateTopicWfmScheduleShift]
        """
        
        self._shifts = shifts

    @property
    def full_day_time_off_markers(self):
        """
        Gets the full_day_time_off_markers of this WfmAgentScheduleUpdateTopicWfmAgentScheduleUpdateNotification.


        :return: The full_day_time_off_markers of this WfmAgentScheduleUpdateTopicWfmAgentScheduleUpdateNotification.
        :rtype: list[WfmAgentScheduleUpdateTopicWfmFullDayTimeOffMarker]
        """
        return self._full_day_time_off_markers

    @full_day_time_off_markers.setter
    def full_day_time_off_markers(self, full_day_time_off_markers):
        """
        Sets the full_day_time_off_markers of this WfmAgentScheduleUpdateTopicWfmAgentScheduleUpdateNotification.


        :param full_day_time_off_markers: The full_day_time_off_markers of this WfmAgentScheduleUpdateTopicWfmAgentScheduleUpdateNotification.
        :type: list[WfmAgentScheduleUpdateTopicWfmFullDayTimeOffMarker]
        """
        
        self._full_day_time_off_markers = full_day_time_off_markers

    @property
    def updates(self):
        """
        Gets the updates of this WfmAgentScheduleUpdateTopicWfmAgentScheduleUpdateNotification.


        :return: The updates of this WfmAgentScheduleUpdateTopicWfmAgentScheduleUpdateNotification.
        :rtype: list[WfmAgentScheduleUpdateTopicWfmAgentScheduleUpdate]
        """
        return self._updates

    @updates.setter
    def updates(self, updates):
        """
        Sets the updates of this WfmAgentScheduleUpdateTopicWfmAgentScheduleUpdateNotification.


        :param updates: The updates of this WfmAgentScheduleUpdateTopicWfmAgentScheduleUpdateNotification.
        :type: list[WfmAgentScheduleUpdateTopicWfmAgentScheduleUpdate]
        """
        
        self._updates = updates

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

