# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class UserSchedule(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        UserSchedule - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'shifts': 'list[UserScheduleShift]',
            'full_day_time_off_markers': 'list[UserScheduleFullDayTimeOffMarker]',
            'delete': 'bool',
            'metadata': 'WfmVersionedEntityMetadata',
            'work_plan_id': 'str'
        }

        self.attribute_map = {
            'shifts': 'shifts',
            'full_day_time_off_markers': 'fullDayTimeOffMarkers',
            'delete': 'delete',
            'metadata': 'metadata',
            'work_plan_id': 'workPlanId'
        }

        self._shifts = None
        self._full_day_time_off_markers = None
        self._delete = None
        self._metadata = None
        self._work_plan_id = None

    @property
    def shifts(self):
        """
        Gets the shifts of this UserSchedule.
        The shifts that belong to this schedule

        :return: The shifts of this UserSchedule.
        :rtype: list[UserScheduleShift]
        """
        return self._shifts

    @shifts.setter
    def shifts(self, shifts):
        """
        Sets the shifts of this UserSchedule.
        The shifts that belong to this schedule

        :param shifts: The shifts of this UserSchedule.
        :type: list[UserScheduleShift]
        """
        
        self._shifts = shifts

    @property
    def full_day_time_off_markers(self):
        """
        Gets the full_day_time_off_markers of this UserSchedule.
        Markers to indicate a full day time off request, relative to the management unit time zone

        :return: The full_day_time_off_markers of this UserSchedule.
        :rtype: list[UserScheduleFullDayTimeOffMarker]
        """
        return self._full_day_time_off_markers

    @full_day_time_off_markers.setter
    def full_day_time_off_markers(self, full_day_time_off_markers):
        """
        Sets the full_day_time_off_markers of this UserSchedule.
        Markers to indicate a full day time off request, relative to the management unit time zone

        :param full_day_time_off_markers: The full_day_time_off_markers of this UserSchedule.
        :type: list[UserScheduleFullDayTimeOffMarker]
        """
        
        self._full_day_time_off_markers = full_day_time_off_markers

    @property
    def delete(self):
        """
        Gets the delete of this UserSchedule.
        If marked true for updating an existing user schedule, it will be deleted

        :return: The delete of this UserSchedule.
        :rtype: bool
        """
        return self._delete

    @delete.setter
    def delete(self, delete):
        """
        Sets the delete of this UserSchedule.
        If marked true for updating an existing user schedule, it will be deleted

        :param delete: The delete of this UserSchedule.
        :type: bool
        """
        
        self._delete = delete

    @property
    def metadata(self):
        """
        Gets the metadata of this UserSchedule.
        Version metadata for this schedule

        :return: The metadata of this UserSchedule.
        :rtype: WfmVersionedEntityMetadata
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """
        Sets the metadata of this UserSchedule.
        Version metadata for this schedule

        :param metadata: The metadata of this UserSchedule.
        :type: WfmVersionedEntityMetadata
        """
        
        self._metadata = metadata

    @property
    def work_plan_id(self):
        """
        Gets the work_plan_id of this UserSchedule.
        ID of the work plan associated with the user during schedule creation

        :return: The work_plan_id of this UserSchedule.
        :rtype: str
        """
        return self._work_plan_id

    @work_plan_id.setter
    def work_plan_id(self, work_plan_id):
        """
        Sets the work_plan_id of this UserSchedule.
        ID of the work plan associated with the user during schedule creation

        :param work_plan_id: The work_plan_id of this UserSchedule.
        :type: str
        """
        
        self._work_plan_id = work_plan_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

