# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class Transcripts(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Transcripts - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'exact_match': 'list[str]',
            'contains': 'list[str]',
            'does_not_contain': 'list[str]'
        }

        self.attribute_map = {
            'exact_match': 'exactMatch',
            'contains': 'contains',
            'does_not_contain': 'doesNotContain'
        }

        self._exact_match = None
        self._contains = None
        self._does_not_contain = None

    @property
    def exact_match(self):
        """
        Gets the exact_match of this Transcripts.
        List of transcript contents which needs to satisfy exact match criteria

        :return: The exact_match of this Transcripts.
        :rtype: list[str]
        """
        return self._exact_match

    @exact_match.setter
    def exact_match(self, exact_match):
        """
        Sets the exact_match of this Transcripts.
        List of transcript contents which needs to satisfy exact match criteria

        :param exact_match: The exact_match of this Transcripts.
        :type: list[str]
        """
        
        self._exact_match = exact_match

    @property
    def contains(self):
        """
        Gets the contains of this Transcripts.
        List of transcript contents which needs to satisfy contains criteria

        :return: The contains of this Transcripts.
        :rtype: list[str]
        """
        return self._contains

    @contains.setter
    def contains(self, contains):
        """
        Sets the contains of this Transcripts.
        List of transcript contents which needs to satisfy contains criteria

        :param contains: The contains of this Transcripts.
        :type: list[str]
        """
        
        self._contains = contains

    @property
    def does_not_contain(self):
        """
        Gets the does_not_contain of this Transcripts.
        List of transcript contents which needs to satisfy does not contain criteria

        :return: The does_not_contain of this Transcripts.
        :rtype: list[str]
        """
        return self._does_not_contain

    @does_not_contain.setter
    def does_not_contain(self, does_not_contain):
        """
        Sets the does_not_contain of this Transcripts.
        List of transcript contents which needs to satisfy does not contain criteria

        :param does_not_contain: The does_not_contain of this Transcripts.
        :type: list[str]
        """
        
        self._does_not_contain = does_not_contain

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

