# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class NluFeedbackRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        NluFeedbackRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'text': 'str',
            'intents': 'list[IntentFeedback]',
            'version_id': 'str'
        }

        self.attribute_map = {
            'text': 'text',
            'intents': 'intents',
            'version_id': 'versionId'
        }

        self._text = None
        self._intents = None
        self._version_id = None

    @property
    def text(self):
        """
        Gets the text of this NluFeedbackRequest.
        The feedback text.

        :return: The text of this NluFeedbackRequest.
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text):
        """
        Sets the text of this NluFeedbackRequest.
        The feedback text.

        :param text: The text of this NluFeedbackRequest.
        :type: str
        """
        
        self._text = text

    @property
    def intents(self):
        """
        Gets the intents of this NluFeedbackRequest.
        Detected intent of the utterance

        :return: The intents of this NluFeedbackRequest.
        :rtype: list[IntentFeedback]
        """
        return self._intents

    @intents.setter
    def intents(self, intents):
        """
        Sets the intents of this NluFeedbackRequest.
        Detected intent of the utterance

        :param intents: The intents of this NluFeedbackRequest.
        :type: list[IntentFeedback]
        """
        
        self._intents = intents

    @property
    def version_id(self):
        """
        Gets the version_id of this NluFeedbackRequest.
        The domain version ID of the feedback.

        :return: The version_id of this NluFeedbackRequest.
        :rtype: str
        """
        return self._version_id

    @version_id.setter
    def version_id(self, version_id):
        """
        Sets the version_id of this NluFeedbackRequest.
        The domain version ID of the feedback.

        :param version_id: The version_id of this NluFeedbackRequest.
        :type: str
        """
        
        self._version_id = version_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

