# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class CoachingSlotsRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        CoachingSlotsRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'interval': 'str',
            'length_in_minutes': 'int',
            'attendee_ids': 'list[str]',
            'facilitator_ids': 'list[str]'
        }

        self.attribute_map = {
            'interval': 'interval',
            'length_in_minutes': 'lengthInMinutes',
            'attendee_ids': 'attendeeIds',
            'facilitator_ids': 'facilitatorIds'
        }

        self._interval = None
        self._length_in_minutes = None
        self._attendee_ids = None
        self._facilitator_ids = None

    @property
    def interval(self):
        """
        Gets the interval of this CoachingSlotsRequest.
        Range of time to get slots for scheduling coaching appointments. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss

        :return: The interval of this CoachingSlotsRequest.
        :rtype: str
        """
        return self._interval

    @interval.setter
    def interval(self, interval):
        """
        Sets the interval of this CoachingSlotsRequest.
        Range of time to get slots for scheduling coaching appointments. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss

        :param interval: The interval of this CoachingSlotsRequest.
        :type: str
        """
        
        self._interval = interval

    @property
    def length_in_minutes(self):
        """
        Gets the length_in_minutes of this CoachingSlotsRequest.
        The duration of coaching appointment to schedule in 15 minutes granularity up to maximum of 60 minutes

        :return: The length_in_minutes of this CoachingSlotsRequest.
        :rtype: int
        """
        return self._length_in_minutes

    @length_in_minutes.setter
    def length_in_minutes(self, length_in_minutes):
        """
        Sets the length_in_minutes of this CoachingSlotsRequest.
        The duration of coaching appointment to schedule in 15 minutes granularity up to maximum of 60 minutes

        :param length_in_minutes: The length_in_minutes of this CoachingSlotsRequest.
        :type: int
        """
        
        self._length_in_minutes = length_in_minutes

    @property
    def attendee_ids(self):
        """
        Gets the attendee_ids of this CoachingSlotsRequest.
        List of attendees to determine coaching appointment slots

        :return: The attendee_ids of this CoachingSlotsRequest.
        :rtype: list[str]
        """
        return self._attendee_ids

    @attendee_ids.setter
    def attendee_ids(self, attendee_ids):
        """
        Sets the attendee_ids of this CoachingSlotsRequest.
        List of attendees to determine coaching appointment slots

        :param attendee_ids: The attendee_ids of this CoachingSlotsRequest.
        :type: list[str]
        """
        
        self._attendee_ids = attendee_ids

    @property
    def facilitator_ids(self):
        """
        Gets the facilitator_ids of this CoachingSlotsRequest.
        List of facilitators to determine coaching appointment slots

        :return: The facilitator_ids of this CoachingSlotsRequest.
        :rtype: list[str]
        """
        return self._facilitator_ids

    @facilitator_ids.setter
    def facilitator_ids(self, facilitator_ids):
        """
        Sets the facilitator_ids of this CoachingSlotsRequest.
        List of facilitators to determine coaching appointment slots

        :param facilitator_ids: The facilitator_ids of this CoachingSlotsRequest.
        :type: list[str]
        """
        
        self._facilitator_ids = facilitator_ids

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

