# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class CampaignInteractions(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        CampaignInteractions - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'campaign': 'DomainEntityRef',
            'pending_interactions': 'list[CampaignInteraction]',
            'proceeding_interactions': 'list[CampaignInteraction]',
            'previewing_interactions': 'list[CampaignInteraction]',
            'interacting_interactions': 'list[CampaignInteraction]',
            'scheduled_interactions': 'list[CampaignInteraction]'
        }

        self.attribute_map = {
            'campaign': 'campaign',
            'pending_interactions': 'pendingInteractions',
            'proceeding_interactions': 'proceedingInteractions',
            'previewing_interactions': 'previewingInteractions',
            'interacting_interactions': 'interactingInteractions',
            'scheduled_interactions': 'scheduledInteractions'
        }

        self._campaign = None
        self._pending_interactions = None
        self._proceeding_interactions = None
        self._previewing_interactions = None
        self._interacting_interactions = None
        self._scheduled_interactions = None

    @property
    def campaign(self):
        """
        Gets the campaign of this CampaignInteractions.


        :return: The campaign of this CampaignInteractions.
        :rtype: DomainEntityRef
        """
        return self._campaign

    @campaign.setter
    def campaign(self, campaign):
        """
        Sets the campaign of this CampaignInteractions.


        :param campaign: The campaign of this CampaignInteractions.
        :type: DomainEntityRef
        """
        
        self._campaign = campaign

    @property
    def pending_interactions(self):
        """
        Gets the pending_interactions of this CampaignInteractions.


        :return: The pending_interactions of this CampaignInteractions.
        :rtype: list[CampaignInteraction]
        """
        return self._pending_interactions

    @pending_interactions.setter
    def pending_interactions(self, pending_interactions):
        """
        Sets the pending_interactions of this CampaignInteractions.


        :param pending_interactions: The pending_interactions of this CampaignInteractions.
        :type: list[CampaignInteraction]
        """
        
        self._pending_interactions = pending_interactions

    @property
    def proceeding_interactions(self):
        """
        Gets the proceeding_interactions of this CampaignInteractions.


        :return: The proceeding_interactions of this CampaignInteractions.
        :rtype: list[CampaignInteraction]
        """
        return self._proceeding_interactions

    @proceeding_interactions.setter
    def proceeding_interactions(self, proceeding_interactions):
        """
        Sets the proceeding_interactions of this CampaignInteractions.


        :param proceeding_interactions: The proceeding_interactions of this CampaignInteractions.
        :type: list[CampaignInteraction]
        """
        
        self._proceeding_interactions = proceeding_interactions

    @property
    def previewing_interactions(self):
        """
        Gets the previewing_interactions of this CampaignInteractions.


        :return: The previewing_interactions of this CampaignInteractions.
        :rtype: list[CampaignInteraction]
        """
        return self._previewing_interactions

    @previewing_interactions.setter
    def previewing_interactions(self, previewing_interactions):
        """
        Sets the previewing_interactions of this CampaignInteractions.


        :param previewing_interactions: The previewing_interactions of this CampaignInteractions.
        :type: list[CampaignInteraction]
        """
        
        self._previewing_interactions = previewing_interactions

    @property
    def interacting_interactions(self):
        """
        Gets the interacting_interactions of this CampaignInteractions.


        :return: The interacting_interactions of this CampaignInteractions.
        :rtype: list[CampaignInteraction]
        """
        return self._interacting_interactions

    @interacting_interactions.setter
    def interacting_interactions(self, interacting_interactions):
        """
        Sets the interacting_interactions of this CampaignInteractions.


        :param interacting_interactions: The interacting_interactions of this CampaignInteractions.
        :type: list[CampaignInteraction]
        """
        
        self._interacting_interactions = interacting_interactions

    @property
    def scheduled_interactions(self):
        """
        Gets the scheduled_interactions of this CampaignInteractions.


        :return: The scheduled_interactions of this CampaignInteractions.
        :rtype: list[CampaignInteraction]
        """
        return self._scheduled_interactions

    @scheduled_interactions.setter
    def scheduled_interactions(self, scheduled_interactions):
        """
        Sets the scheduled_interactions of this CampaignInteractions.


        :param scheduled_interactions: The scheduled_interactions of this CampaignInteractions.
        :type: list[CampaignInteraction]
        """
        
        self._scheduled_interactions = scheduled_interactions

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

