# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/callback.ema.ipynb.

# %% ../../nbs/callback.ema.ipynb 1
from __future__ import annotations

try:
    import timm
except ImportError:
    raise ImportError("timm is required to use EMACallback. Install via `pip install timm`.")

from timm.utils.model_ema import ModelEmaV2

from fastai.callback.core import Callback
from fastai.callback.fp16 import MixedPrecision

from ..imports import *

# %% auto 0
__all__ = ['EMACallback']

# %% ../../nbs/callback.ema.ipynb 4
class EMACallback(Callback):
    "Callback to implement Exponential Moving Average of model weights while training"
    order,run_valid = MixedPrecision.order+1,False
    def __init__(self, 
        decay:float=0.9998, # EMA decay value
        ema_device:torch.device|str|None=None, # Device to store EMA weights. Defaults to model device
        validate_ema:bool=True, # Run validation metrics using EMA weights instead of model weights. If true, `ema_device` must match model device
        replace_weights:bool=True # Replace model weights with EMA weights when finished training. If false, set `Learner.ema_model` to EMA weights
    ):
        store_attr()

    @torch.no_grad()
    def before_fit(self):
        if hasattr(self.learn, 'lr_finder') or hasattr(self.learn, "gather_preds"):
            self.run = False
            return

        self.ema_model = ModelEmaV2(self.learn.model, self.decay, self.ema_device)
        self.validate_ema = self.learn.model.device == self.ema_model.device if self.validate_ema else False

    def after_batch(self):
        self.ema_model.update(self.learn.model)

    def before_validate(self):
        if self.validate_ema:
            self.temp_model = self.learn.model
            self.learn.model = self.ema_model.module

    def after_validate(self):
        if self.validate_ema:
            self.learn.model = self.temp_model

    @torch.no_grad()
    def after_fit(self):
        if self.replace_weights:
            self.learn.model = self.ema_model.module
            self.ema_model = None
        else:
            self.learn.ema_model = self.ema_model.module
        self.remove_cb(EMACallback)
        
