# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/callback.casttotensor.ipynb.

# %% auto 0
__all__ = ['CastToTensorBackport']

# %% ../../nbs/callback.casttotensor.ipynb 2
from packaging.version import parse

from fastcore.dispatch import cast

import fastai
from fastai.callback.core import Callback
from fastai.basics import defaults

from ..imports import *

# %% ../../nbs/callback.casttotensor.ipynb 5
def _cast_tensor(x): 
    if isinstance(x, tuple): return tuple(_cast_tensor(x_) for x_ in x)
    else: return cast(x, Tensor) if isinstance(x,torch.Tensor) else x

# %% ../../nbs/callback.casttotensor.ipynb 6
class CastToTensorBackport(Callback):
    "Cast Subclassed Tensors to `Tensor`"
    order=9 # Right before MixedPrecision

    def before_batch(self):
        self.learn.xb,self.learn.yb = _cast_tensor(self.learn.xb),_cast_tensor(self.learn.yb)

# %% ../../nbs/callback.casttotensor.ipynb 8
if parse(fastai.__version__) < parse('2.7.0') and CastToTensorBackport not in defaults.callbacks: 
    defaults.callbacks.append(CastToTensorBackport)
