import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface UserConfig extends cdktf.TerraformMetaArguments {
    /**
    * Boolean, defaults to false. Whether to allow the user to create groups.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/user#can_create_group User#can_create_group}
    */
    readonly canCreateGroup?: boolean | cdktf.IResolvable;
    /**
    * The e-mail address of the user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/user#email User#email}
    */
    readonly email: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/user#id User#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Boolean, defaults to false.  Whether to enable administrative privileges
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/user#is_admin User#is_admin}
    */
    readonly isAdmin?: boolean | cdktf.IResolvable;
    /**
    * Boolean, defaults to false. Whether a user has access only to some internal or private projects. External users can only access projects to which they are explicitly granted access.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/user#is_external User#is_external}
    */
    readonly isExternal?: boolean | cdktf.IResolvable;
    /**
    * The name of the user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/user#name User#name}
    */
    readonly name: string;
    /**
    * The ID of the user's namespace. Available since GitLab 14.10.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/user#namespace_id User#namespace_id}
    */
    readonly namespaceId?: number;
    /**
    * The note associated to the user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/user#note User#note}
    */
    readonly note?: string;
    /**
    * The password of the user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/user#password User#password}
    */
    readonly password?: string;
    /**
    * Integer, defaults to 0.  Number of projects user can create.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/user#projects_limit User#projects_limit}
    */
    readonly projectsLimit?: number;
    /**
    * Boolean, defaults to false. Send user password reset link.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/user#reset_password User#reset_password}
    */
    readonly resetPassword?: boolean | cdktf.IResolvable;
    /**
    * Boolean, defaults to true. Whether to skip confirmation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/user#skip_confirmation User#skip_confirmation}
    */
    readonly skipConfirmation?: boolean | cdktf.IResolvable;
    /**
    * String, defaults to 'active'. The state of the user account. Valid values are `active`, `deactivated`, `blocked`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/user#state User#state}
    */
    readonly state?: string;
    /**
    * The username of the user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/user#username User#username}
    */
    readonly username: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/user gitlab_user}
*/
export declare class User extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_user";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/user gitlab_user} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options UserConfig
    */
    constructor(scope: Construct, id: string, config: UserConfig);
    private _canCreateGroup?;
    get canCreateGroup(): boolean | cdktf.IResolvable;
    set canCreateGroup(value: boolean | cdktf.IResolvable);
    resetCanCreateGroup(): void;
    get canCreateGroupInput(): boolean | cdktf.IResolvable | undefined;
    private _email?;
    get email(): string;
    set email(value: string);
    get emailInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _isAdmin?;
    get isAdmin(): boolean | cdktf.IResolvable;
    set isAdmin(value: boolean | cdktf.IResolvable);
    resetIsAdmin(): void;
    get isAdminInput(): boolean | cdktf.IResolvable | undefined;
    private _isExternal?;
    get isExternal(): boolean | cdktf.IResolvable;
    set isExternal(value: boolean | cdktf.IResolvable);
    resetIsExternal(): void;
    get isExternalInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespaceId?;
    get namespaceId(): number;
    set namespaceId(value: number);
    resetNamespaceId(): void;
    get namespaceIdInput(): number | undefined;
    private _note?;
    get note(): string;
    set note(value: string);
    resetNote(): void;
    get noteInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetTfPassword(): void;
    get passwordInput(): string | undefined;
    private _projectsLimit?;
    get projectsLimit(): number;
    set projectsLimit(value: number);
    resetProjectsLimit(): void;
    get projectsLimitInput(): number | undefined;
    private _resetPassword?;
    get resetPassword(): boolean | cdktf.IResolvable;
    set resetPassword(value: boolean | cdktf.IResolvable);
    resetResetPassword(): void;
    get resetPasswordInput(): boolean | cdktf.IResolvable | undefined;
    private _skipConfirmation?;
    get skipConfirmation(): boolean | cdktf.IResolvable;
    set skipConfirmation(value: boolean | cdktf.IResolvable);
    resetSkipConfirmation(): void;
    get skipConfirmationInput(): boolean | cdktf.IResolvable | undefined;
    private _state?;
    get state(): string;
    set state(value: string);
    resetState(): void;
    get stateInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
