"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProjectIssue = exports.ProjectIssueTaskCompletionStatusOutputReference = exports.projectIssueTaskCompletionStatusToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function projectIssueTaskCompletionStatusToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        completed_count: cdktf.numberToTerraform(struct.completedCount),
        count: cdktf.numberToTerraform(struct.count),
    };
}
exports.projectIssueTaskCompletionStatusToTerraform = projectIssueTaskCompletionStatusToTerraform;
class ProjectIssueTaskCompletionStatusOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._completedCount !== undefined) {
            hasAnyValues = true;
            internalValueResult.completedCount = this._completedCount;
        }
        if (this._count !== undefined) {
            hasAnyValues = true;
            internalValueResult.count = this._count;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._completedCount = undefined;
            this._count = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._completedCount = value.completedCount;
            this._count = value.count;
        }
    }
    get completedCount() {
        return this.getNumberAttribute('completed_count');
    }
    set completedCount(value) {
        this._completedCount = value;
    }
    resetCompletedCount() {
        this._completedCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get completedCountInput() {
        return this._completedCount;
    }
    get count() {
        return this.getNumberAttribute('count');
    }
    set count(value) {
        this._count = value;
    }
    resetCount() {
        this._count = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get countInput() {
        return this._count;
    }
}
exports.ProjectIssueTaskCompletionStatusOutputReference = ProjectIssueTaskCompletionStatusOutputReference;
_a = JSII_RTTI_SYMBOL_1;
ProjectIssueTaskCompletionStatusOutputReference[_a] = { fqn: "@cdktf/provider-gitlab.ProjectIssueTaskCompletionStatusOutputReference", version: "0.1.48" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue gitlab_project_issue}
*/
class ProjectIssue extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue gitlab_project_issue} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProjectIssueConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'gitlab_project_issue',
            terraformGeneratorMetadata: {
                providerName: 'gitlab',
                providerVersion: '3.14.0',
                providerVersionConstraint: '~> 3.14.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        // task_completion_status - computed: false, optional: true, required: false
        this._taskCompletionStatus = new ProjectIssueTaskCompletionStatusOutputReference(this, "task_completion_status");
        this._assigneeIds = config.assigneeIds;
        this._closedAt = config.closedAt;
        this._closedByUserId = config.closedByUserId;
        this._confidential = config.confidential;
        this._createdAt = config.createdAt;
        this._deleteOnDestroy = config.deleteOnDestroy;
        this._description = config.description;
        this._discussionLocked = config.discussionLocked;
        this._discussionToResolve = config.discussionToResolve;
        this._dueDate = config.dueDate;
        this._epicIssueId = config.epicIssueId;
        this._humanTimeEstimate = config.humanTimeEstimate;
        this._humanTotalTimeSpent = config.humanTotalTimeSpent;
        this._id = config.id;
        this._iid = config.iid;
        this._issueType = config.issueType;
        this._labels = config.labels;
        this._links = config.links;
        this._mergeRequestToResolveDiscussionsOf = config.mergeRequestToResolveDiscussionsOf;
        this._milestoneId = config.milestoneId;
        this._project = config.project;
        this._references = config.references;
        this._state = config.state;
        this._timeEstimate = config.timeEstimate;
        this._title = config.title;
        this._totalTimeSpent = config.totalTimeSpent;
        this._updatedAt = config.updatedAt;
        this._weight = config.weight;
        this._taskCompletionStatus.internalValue = config.taskCompletionStatus;
    }
    get assigneeIds() {
        return cdktf.Token.asNumberList(cdktf.Fn.tolist(this.getNumberListAttribute('assignee_ids')));
    }
    set assigneeIds(value) {
        this._assigneeIds = value;
    }
    resetAssigneeIds() {
        this._assigneeIds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get assigneeIdsInput() {
        return this._assigneeIds;
    }
    // author_id - computed: true, optional: false, required: false
    get authorId() {
        return this.getNumberAttribute('author_id');
    }
    get closedAt() {
        return this.getStringAttribute('closed_at');
    }
    set closedAt(value) {
        this._closedAt = value;
    }
    resetClosedAt() {
        this._closedAt = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get closedAtInput() {
        return this._closedAt;
    }
    get closedByUserId() {
        return this.getNumberAttribute('closed_by_user_id');
    }
    set closedByUserId(value) {
        this._closedByUserId = value;
    }
    resetClosedByUserId() {
        this._closedByUserId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get closedByUserIdInput() {
        return this._closedByUserId;
    }
    get confidential() {
        return this.getBooleanAttribute('confidential');
    }
    set confidential(value) {
        this._confidential = value;
    }
    resetConfidential() {
        this._confidential = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get confidentialInput() {
        return this._confidential;
    }
    get createdAt() {
        return this.getStringAttribute('created_at');
    }
    set createdAt(value) {
        this._createdAt = value;
    }
    resetCreatedAt() {
        this._createdAt = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createdAtInput() {
        return this._createdAt;
    }
    get deleteOnDestroy() {
        return this.getBooleanAttribute('delete_on_destroy');
    }
    set deleteOnDestroy(value) {
        this._deleteOnDestroy = value;
    }
    resetDeleteOnDestroy() {
        this._deleteOnDestroy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteOnDestroyInput() {
        return this._deleteOnDestroy;
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    get discussionLocked() {
        return this.getBooleanAttribute('discussion_locked');
    }
    set discussionLocked(value) {
        this._discussionLocked = value;
    }
    resetDiscussionLocked() {
        this._discussionLocked = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get discussionLockedInput() {
        return this._discussionLocked;
    }
    get discussionToResolve() {
        return this.getStringAttribute('discussion_to_resolve');
    }
    set discussionToResolve(value) {
        this._discussionToResolve = value;
    }
    resetDiscussionToResolve() {
        this._discussionToResolve = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get discussionToResolveInput() {
        return this._discussionToResolve;
    }
    // downvotes - computed: true, optional: false, required: false
    get downvotes() {
        return this.getNumberAttribute('downvotes');
    }
    get dueDate() {
        return this.getStringAttribute('due_date');
    }
    set dueDate(value) {
        this._dueDate = value;
    }
    resetDueDate() {
        this._dueDate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dueDateInput() {
        return this._dueDate;
    }
    // epic_id - computed: true, optional: false, required: false
    get epicId() {
        return this.getNumberAttribute('epic_id');
    }
    get epicIssueId() {
        return this.getNumberAttribute('epic_issue_id');
    }
    set epicIssueId(value) {
        this._epicIssueId = value;
    }
    resetEpicIssueId() {
        this._epicIssueId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get epicIssueIdInput() {
        return this._epicIssueId;
    }
    // external_id - computed: true, optional: false, required: false
    get externalId() {
        return this.getStringAttribute('external_id');
    }
    get humanTimeEstimate() {
        return this.getStringAttribute('human_time_estimate');
    }
    set humanTimeEstimate(value) {
        this._humanTimeEstimate = value;
    }
    resetHumanTimeEstimate() {
        this._humanTimeEstimate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get humanTimeEstimateInput() {
        return this._humanTimeEstimate;
    }
    get humanTotalTimeSpent() {
        return this.getStringAttribute('human_total_time_spent');
    }
    set humanTotalTimeSpent(value) {
        this._humanTotalTimeSpent = value;
    }
    resetHumanTotalTimeSpent() {
        this._humanTotalTimeSpent = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get humanTotalTimeSpentInput() {
        return this._humanTotalTimeSpent;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get iid() {
        return this.getNumberAttribute('iid');
    }
    set iid(value) {
        this._iid = value;
    }
    resetIid() {
        this._iid = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get iidInput() {
        return this._iid;
    }
    // issue_id - computed: true, optional: false, required: false
    get issueId() {
        return this.getNumberAttribute('issue_id');
    }
    // issue_link_id - computed: true, optional: false, required: false
    get issueLinkId() {
        return this.getNumberAttribute('issue_link_id');
    }
    get issueType() {
        return this.getStringAttribute('issue_type');
    }
    set issueType(value) {
        this._issueType = value;
    }
    resetIssueType() {
        this._issueType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get issueTypeInput() {
        return this._issueType;
    }
    get labels() {
        return cdktf.Fn.tolist(this.getListAttribute('labels'));
    }
    set labels(value) {
        this._labels = value;
    }
    resetLabels() {
        this._labels = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get labelsInput() {
        return this._labels;
    }
    get links() {
        return this.getStringMapAttribute('links');
    }
    set links(value) {
        this._links = value;
    }
    resetLinks() {
        this._links = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get linksInput() {
        return this._links;
    }
    get mergeRequestToResolveDiscussionsOf() {
        return this.getNumberAttribute('merge_request_to_resolve_discussions_of');
    }
    set mergeRequestToResolveDiscussionsOf(value) {
        this._mergeRequestToResolveDiscussionsOf = value;
    }
    resetMergeRequestToResolveDiscussionsOf() {
        this._mergeRequestToResolveDiscussionsOf = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergeRequestToResolveDiscussionsOfInput() {
        return this._mergeRequestToResolveDiscussionsOf;
    }
    // merge_requests_count - computed: true, optional: false, required: false
    get mergeRequestsCount() {
        return this.getNumberAttribute('merge_requests_count');
    }
    get milestoneId() {
        return this.getNumberAttribute('milestone_id');
    }
    set milestoneId(value) {
        this._milestoneId = value;
    }
    resetMilestoneId() {
        this._milestoneId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get milestoneIdInput() {
        return this._milestoneId;
    }
    // moved_to_id - computed: true, optional: false, required: false
    get movedToId() {
        return this.getNumberAttribute('moved_to_id');
    }
    get project() {
        return this.getStringAttribute('project');
    }
    set project(value) {
        this._project = value;
    }
    // Temporarily expose input value. Use with caution.
    get projectInput() {
        return this._project;
    }
    get references() {
        return this.getStringMapAttribute('references');
    }
    set references(value) {
        this._references = value;
    }
    resetReferences() {
        this._references = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get referencesInput() {
        return this._references;
    }
    get state() {
        return this.getStringAttribute('state');
    }
    set state(value) {
        this._state = value;
    }
    resetState() {
        this._state = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get stateInput() {
        return this._state;
    }
    // subscribed - computed: true, optional: false, required: false
    get subscribed() {
        return this.getBooleanAttribute('subscribed');
    }
    get timeEstimate() {
        return this.getNumberAttribute('time_estimate');
    }
    set timeEstimate(value) {
        this._timeEstimate = value;
    }
    resetTimeEstimate() {
        this._timeEstimate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeEstimateInput() {
        return this._timeEstimate;
    }
    get title() {
        return this.getStringAttribute('title');
    }
    set title(value) {
        this._title = value;
    }
    // Temporarily expose input value. Use with caution.
    get titleInput() {
        return this._title;
    }
    get totalTimeSpent() {
        return this.getNumberAttribute('total_time_spent');
    }
    set totalTimeSpent(value) {
        this._totalTimeSpent = value;
    }
    resetTotalTimeSpent() {
        this._totalTimeSpent = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get totalTimeSpentInput() {
        return this._totalTimeSpent;
    }
    get updatedAt() {
        return this.getStringAttribute('updated_at');
    }
    set updatedAt(value) {
        this._updatedAt = value;
    }
    resetUpdatedAt() {
        this._updatedAt = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get updatedAtInput() {
        return this._updatedAt;
    }
    // upvotes - computed: true, optional: false, required: false
    get upvotes() {
        return this.getNumberAttribute('upvotes');
    }
    // user_notes_count - computed: true, optional: false, required: false
    get userNotesCount() {
        return this.getNumberAttribute('user_notes_count');
    }
    // web_url - computed: true, optional: false, required: false
    get webUrl() {
        return this.getStringAttribute('web_url');
    }
    get weight() {
        return this.getNumberAttribute('weight');
    }
    set weight(value) {
        this._weight = value;
    }
    resetWeight() {
        this._weight = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get weightInput() {
        return this._weight;
    }
    get taskCompletionStatus() {
        return this._taskCompletionStatus;
    }
    putTaskCompletionStatus(value) {
        this._taskCompletionStatus.internalValue = value;
    }
    resetTaskCompletionStatus() {
        this._taskCompletionStatus.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get taskCompletionStatusInput() {
        return this._taskCompletionStatus.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            assignee_ids: cdktf.listMapper(cdktf.numberToTerraform)(this._assigneeIds),
            closed_at: cdktf.stringToTerraform(this._closedAt),
            closed_by_user_id: cdktf.numberToTerraform(this._closedByUserId),
            confidential: cdktf.booleanToTerraform(this._confidential),
            created_at: cdktf.stringToTerraform(this._createdAt),
            delete_on_destroy: cdktf.booleanToTerraform(this._deleteOnDestroy),
            description: cdktf.stringToTerraform(this._description),
            discussion_locked: cdktf.booleanToTerraform(this._discussionLocked),
            discussion_to_resolve: cdktf.stringToTerraform(this._discussionToResolve),
            due_date: cdktf.stringToTerraform(this._dueDate),
            epic_issue_id: cdktf.numberToTerraform(this._epicIssueId),
            human_time_estimate: cdktf.stringToTerraform(this._humanTimeEstimate),
            human_total_time_spent: cdktf.stringToTerraform(this._humanTotalTimeSpent),
            id: cdktf.stringToTerraform(this._id),
            iid: cdktf.numberToTerraform(this._iid),
            issue_type: cdktf.stringToTerraform(this._issueType),
            labels: cdktf.listMapper(cdktf.stringToTerraform)(this._labels),
            links: cdktf.hashMapper(cdktf.stringToTerraform)(this._links),
            merge_request_to_resolve_discussions_of: cdktf.numberToTerraform(this._mergeRequestToResolveDiscussionsOf),
            milestone_id: cdktf.numberToTerraform(this._milestoneId),
            project: cdktf.stringToTerraform(this._project),
            references: cdktf.hashMapper(cdktf.stringToTerraform)(this._references),
            state: cdktf.stringToTerraform(this._state),
            time_estimate: cdktf.numberToTerraform(this._timeEstimate),
            title: cdktf.stringToTerraform(this._title),
            total_time_spent: cdktf.numberToTerraform(this._totalTimeSpent),
            updated_at: cdktf.stringToTerraform(this._updatedAt),
            weight: cdktf.numberToTerraform(this._weight),
            task_completion_status: projectIssueTaskCompletionStatusToTerraform(this._taskCompletionStatus.internalValue),
        };
    }
}
exports.ProjectIssue = ProjectIssue;
_b = JSII_RTTI_SYMBOL_1;
ProjectIssue[_b] = { fqn: "@cdktf/provider-gitlab.ProjectIssue", version: "0.1.48" };
// =================
// STATIC PROPERTIES
// =================
ProjectIssue.tfResourceType = "gitlab_project_issue";
//# sourceMappingURL=data:application/json;base64,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