import { HttpRouteAuthorizerBindOptions, HttpRouteAuthorizerConfig, IHttpRouteAuthorizer } from '@aws-cdk/aws-apigatewayv2';
/**
 * (experimental) Properties to initialize HttpJwtAuthorizer.
 *
 * @experimental
 */
export interface HttpJwtAuthorizerProps {
    /**
     * (experimental) The name of the authorizer.
     *
     * @default - same value as `id` passed in the constructor
     * @experimental
     */
    readonly authorizerName?: string;
    /**
     * (experimental) The identity source for which authorization is requested.
     *
     * @default ['$request.header.Authorization']
     * @experimental
     */
    readonly identitySource?: string[];
    /**
     * (experimental) A list of the intended recipients of the JWT.
     *
     * A valid JWT must provide an aud that matches at least one entry in this list.
     *
     * @experimental
     */
    readonly jwtAudience: string[];
}
/**
 * (experimental) Authorize Http Api routes on whether the requester is registered as part of an AWS Cognito user pool.
 *
 * @experimental
 */
export declare class HttpJwtAuthorizer implements IHttpRouteAuthorizer {
    private readonly id;
    private readonly jwtIssuer;
    private readonly props;
    private authorizer?;
    /**
     * (experimental) Initialize a JWT authorizer to be bound with HTTP route.
     *
     * @param id The id of the underlying construct.
     * @param jwtIssuer The base domain of the identity provider that issues JWT.
     * @param props Properties to configure the authorizer.
     * @experimental
     */
    constructor(id: string, jwtIssuer: string, props: HttpJwtAuthorizerProps);
    /**
     * (experimental) (experimental) Bind this authorizer to a specified Http route.
     *
     * @experimental
     */
    bind(options: HttpRouteAuthorizerBindOptions): HttpRouteAuthorizerConfig;
}
