import { AddToPrincipalPolicyResult, IPrincipal, IRole, PolicyStatement, PrincipalPolicyFragment } from '@aws-cdk/aws-iam';
import { Construct } from 'constructs';
import { ICluster } from './cluster';
import { Construct as CoreConstruct } from '@aws-cdk/core';
/**
 * Options for `ServiceAccount`.
 *
 * @stability stable
 */
export interface ServiceAccountOptions {
    /**
     * The name of the service account.
     *
     * @default - If no name is given, it will use the id of the resource.
     * @stability stable
     */
    readonly name?: string;
    /**
     * The namespace of the service account.
     *
     * @default "default"
     * @stability stable
     */
    readonly namespace?: string;
}
/**
 * Properties for defining service accounts.
 *
 * @stability stable
 */
export interface ServiceAccountProps extends ServiceAccountOptions {
    /**
     * The cluster to apply the patch to.
     *
     * @stability stable
     */
    readonly cluster: ICluster;
}
/**
 * Service Account.
 *
 * @stability stable
 */
export declare class ServiceAccount extends CoreConstruct implements IPrincipal {
    /**
     * The role which is linked to the service account.
     *
     * @stability stable
     */
    readonly role: IRole;
    /**
     * When this Principal is used in an AssumeRole policy, the action to use.
     *
     * @stability stable
     */
    readonly assumeRoleAction: string;
    /**
     * The principal to grant permissions to.
     *
     * @stability stable
     */
    readonly grantPrincipal: IPrincipal;
    /**
     * Return the policy fragment that identifies this principal in a Policy.
     *
     * @stability stable
     */
    readonly policyFragment: PrincipalPolicyFragment;
    /**
     * The name of the service account.
     *
     * @stability stable
     */
    readonly serviceAccountName: string;
    /**
     * The namespace where the service account is located in.
     *
     * @stability stable
     */
    readonly serviceAccountNamespace: string;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: ServiceAccountProps);
    /**
     * (deprecated) (deprecated) Add to the policy of this principal.
     *
     * @deprecated use `addToPrincipalPolicy()`
     */
    addToPolicy(statement: PolicyStatement): boolean;
    /**
     * Add to the policy of this principal.
     *
     * @stability stable
     */
    addToPrincipalPolicy(statement: PolicyStatement): AddToPrincipalPolicyResult;
}
