# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['yte']

package_data = \
{'': ['*']}

install_requires = \
['plac>=1.3.4,<2.0.0', 'pyyaml>=6.0,<7.0']

entry_points = \
{'console_scripts': ['yte = yte:main']}

setup_kwargs = {
    'name': 'yte',
    'version': '0.2.0',
    'description': 'A YAML template engine with Python expressions',
    'long_description': '# YTE - A YAML template engine with Python expressions\n\n[![test coverage: 100%](https://img.shields.io/badge/test%20coverage-100%25-green)](https://github.com/koesterlab/yte/blob/main/pyproject.toml#L30)\n![GitHub Workflow Status](https://img.shields.io/github/workflow/status/koesterlab/yte/CI)\n![PyPI](https://img.shields.io/pypi/v/yte)\n[![Conda Recipe](https://img.shields.io/badge/recipe-yte-green.svg)](https://anaconda.org/conda-forge/yte)\n[![Conda Downloads](https://img.shields.io/conda/dn/conda-forge/yte.svg)](https://anaconda.org/conda-forge/yte)\n[![Conda Version](https://img.shields.io/conda/vn/conda-forge/yte.svg)](https://anaconda.org/conda-forge/yte)\n\n\nYTE is a template engine for YAML format that utilizes the YAML structure in combination with Python expressions for enabling to dynamically build YAML documents.\n\n## Syntax\n\nThe key idea of YTE is to rely on the YAML structure to enable conditionals, loops and other arbitrary Python expressions to dynamically render YAML files.\nPython expressions are thereby declared by prepending them with a `?` anywhere in the YAML.\nAny such value will be automatically evaluated by YTE, yielding plain YAML as a result.\nImportantly, YTE templates are still valid YAML files (for YAML, the `?` expressions are just strings).\n\n### Examples\n\n```yaml\n?if True:\n  foo: 1\n?elif False:\n  bar: 2\n?else:\n  bar: 1\n```\n\n```yaml\n?for i in range(2):\n  ?f"key{i}": 1\n  ?if i == 1:\n      foo: True\n```\n\n```yaml\n?if True:\n  - a\n  - b\n```\n\n```yaml\n- foo\n- bar\n- ?if True:\n    baz\n  ?else:\n    bar\n```\n\n\n## Usage\n\n### Command line interface\n\nYTE comes with a command line interface.\nTo render any YTE template, just issue\n\n```bash\nyte < the-template.yaml > the-rendered-version.yaml\n```\n\n### Python API\n\nAlternatively, you can invoke YTE via its Python API:\n\n```python\nfrom yte import process_yaml\n\n# set some variables as a Python dictionary\nvariables = ...\n\n# render a string and obtain the result as a Python dict\nresult = process_yaml("""\n?for i in range(10):\n  - ?f"item-{i}"\n""", variables=variables)\n\n# render a file and obtain the result as a Python dict\nwith open("the-template.yaml", "r") as template:\n    result = process_yaml(template, variables=variables)\n\n# render a file and write the result as valid YAML\nwith open("the-template.yaml", "r") as template, open("the-rendered-version.yaml", "w") as outfile:\n    result = process_yaml(template, outfile=outfile, variables=variables)\n```\n',
    'author': 'Johannes Köster',
    'author_email': 'johannes.koester@tu-dortmund.de',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/koesterlab/yte',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7',
}


setup(**setup_kwargs)
