# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['concrete_settings',
 'concrete_settings.behaviors',
 'concrete_settings.contrib',
 'concrete_settings.contrib.behaviors',
 'concrete_settings.contrib.frameworks',
 'concrete_settings.contrib.sources',
 'concrete_settings.contrib.validators',
 'concrete_settings.sources',
 'concrete_settings.validators']

package_data = \
{'': ['*']}

install_requires = \
['sphinx>=3.0,<4.0', 'typeguard>=2.7,<3.0', 'typing_extensions>=3.7.4,<4.0.0']

extras_require = \
{'pyyaml': ['pyyaml>=5.3,<6.0']}

setup_kwargs = {
    'name': 'concrete-settings',
    'version': '0.1',
    'description': 'Concrete Settings facilitates configuration management in big and small projects.',
    'long_description': 'Concrete Settings\n#################\n\n.. image:: https://travis-ci.org/BasicWolf/concrete-settings.svg?branch=master\n    :target: https://travis-ci.org/BasicWolf/concrete-settings\n\n.. image:: https://readthedocs.org/projects/concrete-settings/badge/?version=latest\n   :target: https://concrete-settings.readthedocs.io/en/latest/?badge=latest\n   :alt: Documentation Status\n\n.. image:: https://raw.githubusercontent.com/BasicWolf/concrete-settings/master/docs/src/_static/img/codestyle_black.svg\n    :target: https://github.com/ambv/black\n\n.. image:: https://raw.githubusercontent.com/BasicWolf/concrete-settings/master/docs/src/_static/img/mypy_checked.svg\n   :target: https://github.com/python/mypy\n\n.. image:: https://raw.githubusercontent.com/BasicWolf/concrete-settings/master/docs/src/_static/img/pyup_scanned.svg\n   :target: https://pyup.io\n\n\nWelcome to Concrete Settings\n============================\n\n**Concrete Settings** is a Python library which facilitates\nconfiguration management in big and small projects.\n\nThe library was born out of necessity to manage a huge\ndecade-old Django-based SaaS solution with more than two hundred\ndifferent application settings scattered around ``settings.py``.\n*What does this setting do?*\n*What type is it?*\n*Why does it have such a weird format?*\n*Is this the final value, or it changes somewhere on the way?*\nSometimes developers spent *hours* seeking answers to these\nquestions.\n\nConcrete Settigns tackles these problems altogether.\nIt was designed to be developer and end-user friendly.\nThe settings are defined via normal Python code with few\ntricks which significantly improve readability\nand maintainability.\n\n.. contents:: :depth: 2\n\nA small example\n---------------\n\nTake a look at a small example of Settings class with one\nboolean setting ``DEBUG``. A developer defines the\nsettings in application code, while an end-user\nchooses to store the configuration in a YAML file:\n\n.. code-block:: python\n\n   # settings.py\n\n   from concrete_settings import Settings\n\n   class AppSettings(Settings):\n\n       #: Turns debug mode on/off\n       DEBUG: bool = False\n\n\n   app_settings = AppSettings()\n   app_settings.update(\'/path/to/user/settings.yml\')\n   app_settings.is_valid(raise_exception=True)\n\n.. code-block:: yaml\n\n   # settings.yml\n\n   DEBUG: true\n\n\nAccessing settings:\n\n.. code-block:: pycon\n\n   >>>  print(app_settings.DEBUG)\n   True\n\n   >>> print(AppSettings.DEBUG.__doc__)\n   Turns debug mode on/off\n\nConcrete concepts\n-----------------\n\nSettings are **defined in classes**. Python mechanism\nof inheritance and composition apply here, so settings can be **mixed** (multiple inheritance)\nand be **nested** (settings as class fields).\nSettings are **type-annotated** and are **validated**.\nDocumentation matters! Each settings can be documented in Sphinx-style comments ``#:`` written\nabove its definition.\nAn instance of ``Settings`` can be updated i.e. read from any kind of source:\nYAML, JSON or Python files, environmental variables, Python dicts, and you can add more!\n\nFinally, Concrete Settings comes with batteries like Django 3.0 support out of the box.\n\nConcrete Settings are here to improve configuration handling\nwhether you are starting from scratch, or dealing with an\nold legacy Cthulhu.\nAre you ready to try it out?\n\n``pip install concrete-settings`` and welcome to the `documentation <https://concrete-settings.readthedocs.io/>`__!\n\nWhat\'s inside?\n==============\n\nSo, you are a kind of a developer who expects more show cases in a ``README``?\nLet\'s see!\n\nCatch an invalid value early\n----------------------------\n\nFor example, the default *type validator* works like this:\n\n.. code-block:: python\n\n   from concrete_settings import Settings\n\n   class AppSettings(Settings):\n       SPEED: int = \'abc\'\n\n   app_settings = AppSettings()\n   print(app_settings.is_valid(raise_exception=False))\n   print(app_settings.errors)\n\nOutput:\n\n.. code-block::\n\n   False\n   {\'SPEED\': ["Expected value of type `<class \'int\'>` got value of type `<class \'str\'>`"]}\n\n\nEasily warn about deprecation\n-----------------------------\n\nUse **behaviors** to control settings during their *initialization*, *validation*,\n*reading* and *writing* operations:\n\n.. code-block:: python\n\n   from concrete_settings import Settings, Setting\n   from concrete_settings.contrib.behaviors import deprecated\n\n   class AppSettings(Settings):\n       MAX_SPEED: int = 30 @deprecated\n\n   app_settings = AppSettings()\n   app_settings.is_valid()\n\nRunning this code with ``python -Wdefault`` yields:\n\n.. code-block::\n\n   DeprecationWarning: Setting `MAX_SPEED` in class `<class \'__main__.AppSettings\'>` is deprecated.\n\n\nGroup settings and nest them\n----------------------------\n\nDifferent settings in a huge setting file?\nWhy have those stupid ``GROUP_PREFIXES_...``?\nInstead group and nest settings:\n\n.. code-block:: python\n\n   from concrete_settings import Settings\n\n   class DBSettings(Settings):\n       USER = \'alex\'\n       PASSWORD  = \'secret\'\n       SERVER = \'localhost@5432\'\n\n   class CacheSettings(Settings):\n       ENGINE = \'DatabaseCache\'\n       TIMEOUT = 300\n\n   class LoggingSettings(Settings):\n       LEVEL = \'INFO\'\n       FORMAT = \'%(asctime)s %(levelname)-8s %(name)-15s %(message)s\'\n\n\n   class AppSettings(Settings):\n       DB = DBSettings()\n       CACHE = CacheSettings()\n       LOG = LoggingSettings()\n\n   app_settings = AppSettings()\n   app_settings.is_valid()  # also invokes DB, CACHE and LOG validation\n   print(app_settings.LOG.LEVEL)\n\nThere is even more\n------------------\n\nThere is even more for you to discover in\n`documentation <https://basicwolf.github.io/concrete-settings>`__,\nand there is more to come. **Your** contribution, be it\na *bug report*, *pull request*, *suggested feature*,\n*comments* and *criticism* are very welcome!\n\nAwesome configuration projects\n==============================\n\nConcrete Settings is not the first and surely not the last library to handle\nconfiguration in Python projects.\n\n* `goodconf <https://github.com/lincolnloop/goodconf/>`_\n  - Define configuration variables and load them from environment or\n  JSON/YAML file. Also generates initial configuration files and\n  documentation for your defined configuration.\n\n* `profig <https://profig.readthedocs.io>`_\n  - is a straightforward configuration library for Python.\n  Its objective is to make the most common tasks of configuration\n  handling as simple as possible.\n\n* `everett <https://everett.readthedocs.io/en/latest/>`_\n  - is a Python configuration library with the following goals:\n  flexible configuration from multiple configured environments;\n  easy testing with configuration and easy documentation of configuration\n  for users.\n\n* `python-decouple <https://github.com/henriquebastos/python-decouple>`_\n  - strict separation of settings from code. Decouple helps you to organize\n  your settings so that you can change parameters without having to redeploy\n  your app.\n\nWhy should you trust Concrete Settings instead of picking some other library?\nConcrete Settings tries to make configuration definition, processing and maintenance smooth and transparent for developers. Its implicit definition syntax eliminates extra code and allows you to focus on  what is important.\n\n\nWords of gratitude\n==================\n\nIt is hard to imagine a software project without the infrastructure that supports it.\nConcrete Settings exists as an open source library only thanks to the services and the tools\nthat are used to host, build and maintain it.\n\nMy warmest words of gratitude go to\n`Github <https://github.com>`_ for hosting the project source,\n`Read the Docs <https://readthedocs.org>`_ for hosting the documentation,\n`Travis CI <https://travis-ci.org>`_ for continuous integration process\nand`pyupio <https://pyup.io>`_ for keeping dependencies up-to-date!\n\nMany thanks for the authors and contributors of the libraries used to build the project.\n\nAll these wonderful services and tools have been provided *pro bono*.\n',
    'author': 'Zaur Nasibov',
    'author_email': 'comments@znasibov.info',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/basicwolf/concrete-settings',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
