# Package of functions for manipulating Tensile Test data

## Contents

- [Description](#Description)
- [read_testdata](#read_testdata)
- [to_tension](#to_tension)
- [linearize_diag](#linearize_diag)
- [cut_end](#cut_end)
- [correct_diag](#correct_diag)
- [get_info](#get_info)
- [plot_sample](#plot_sample)
- [plot_group](#plot_group)
- [Author](#Author)
- [Copyright and license](#copyright-and-license)


## Description

The main purpose of this code is to read, manipulate, correct and adequately plot Stress x Strain diagrams, and there is no guarantee that it will work for other types of tests or other universal testing machines.

Furthermore, this is an open source project developed on an individual basis in order to assist students and researchers in their academic/research activities, so if something does not work correctly, updates/bug fixes should not be expected, even though the Feedback is very appreciated through the author's communication channels.

For the code to work properly, it is necessary to pay close attention to the formatting of the original data. The package's functions expect a specific formatting that must be met to avoid errors, further details on the read_testdata topic.

This is expected to be the default formatting output for data from Shimadzu. If the formatting is different, it will be necessary to either change the functions of the package or to alter the data formatting accordingly.  


## read_testdata

The read_testdata function is intended to read the database generated by the universal testing machine in a simplified way, eliminating all the processing steps that are necessary to carry out the loading and reading manually.

The expected arguments are:
- file - database file (mainly a .csv directly from Shimdazu test machine)
- encoding - file encoding (by default: ANSI)

``` code
read_testdata(file, encoding="ANSI")
```
As already said, it is important that the formatting and organization of the database is exactly as shown in the example image below, that is, it is strictly necessary that the columns and rows have the exactly same nomenclature and order of appearance in the example below (including language). Otherwise, it will be necessary to load and read the database (and all the necessary treatment) manually via code or to alter the function algorithm.

<a>
     <img src="https://github.com/GabrielVZanata/pyTensileTest/blob/main/formatodataset.png" alt="Required format for dataset" width=400 height=200>
   </a>


## to_tension

The to_tension function allows obtaining the actual tension applied to the sample, calculating it based on the force applied by the machine and the effective diameter of the sample.

The expected arguments are:
- df - the Dataframe containing the force and displacement data (in the df format returned by the read_testdata function)
- diam - list containing the diameters of each sample, in the order they appear in the Dataframe.

``` code
to_tension(df, diam)
```

## linearize_diag

The linearize_diag function identifies the most linear stretch for correction of the initial stretch (linear elastic) of the diagrams, which is generally imprecisely generated during the tests. This function must be used in conjunction with the correct_diag function.

The expected arguments are:
- df - the Dataframe containing the stress and displacement data (in the format of the df returned by the read_testdata function)
- min_rsq - the minimum value of R² that the algorithm should look for. Note that the value of R² varies from 0 to 1, the measure approaching 1 being more linear. However, if a value is set too high, the function may not find such a linear stretch, which will cause errors.
- int_size - the size of the intervals to be analyzed in number of instants. By default, the function will analyze the data in sections containing 300 instants. The larger this interval, the more intense the linearization will be.
If the algorithm does not find a section with defined R² and interval size, these arguments must be changed (reduced) to avoid errors.

``` code
linearize_diag(df, min_rsq=0.9996, int_size=300)
```

## cut_end

The cut_end function performs the removal of the sections measured and plotted by the testing machine after the sample rupture.

The expected arguments are:
- df - the Dataframe containing the stress and displacement data (in the format of the df returned by the read_testdata function)

``` code
cut_end(df)
```

  
## correct_diag

The correct_diag function applies the to_tension, linearize_diag, cut_end functions to completely correct the diagrams by changing the force measurements to tension, linearizing the initial runs, correcting the deformation and removing the data after the break.

The expected arguments are:
- df - the Dataframe containing the stress and displacement data (in the format of the df returned by the read_testdata function)
- min_rsq - the minimum value of R² that the algorithm should look for. Note that the value of R² varies from 0 to 1, the measure approaching 1 being more linear. However, if a value is set too high, the function may not find such a linear stretch, which will cause errors.
- int_size - the size of the intervals to be analyzed in number of instants. By default, the function will analyze the data in sections containing 300 instants. The larger this interval, the more intense the linearization will be.
If the algorithm does not find a section with defined R² and interval size, these arguments must be changed (reduced) to avoid errors.
- correct_force - If TRUE it will apply the to_tension function to the dataframe and wait to receive the diam parameter.
- diam - list containing the diameters of each sample, in the order they appear in the Dataframe.

``` code
correct_diag(df, cut=False, min_rsq = 0.9996, int_size=300, correct_force=False, diam=[])
```
   <a>
     <img src="https://github.com/GabrielVZanata/pyTensileTest/blob/main/5_1N.png" alt="Uncorrected diagram" width=400 height=300>
   </a>
   <a>
     <img src="https://github.com/GabrielVZanata/pyTensileTest/blob/main/5_1.png" alt="Corrected diagram" width=400 height=300>
   </a>
  
## get_info

The get_info function allows to obtain the maximum stress and strain at maximum stress.
The expected arguments are:
- df - the Dataframe containing the stress and displacement data (in the format of the df returned by the read_testdata function)
- numbar - appearance number of the desired sample (starting at 0), for example: to analyze the 8th sample of the dataframe, use numbar=7.
- parse - True to return the result in Dataframe format, False to return in list format.

``` code
get_info(df, numbar=0, parse=False)
```

## plot_sample

The plot_sample function plots the stress x strain diagram for an individual sample.

The expected arguments are:
- df - the Dataframe containing the stress and displacement data (in the format of the df returned by the read_testdata function)
- numbar - appearance number of the desired sample (starting at 0), for example: to plot the 8th sample of the dataframe, use numbar=7.
- obs - A string with a note to be appended to the title of the plot.
- save - True to save the plot to disk.
- folder - Directory where the plot should be saved.
- info - True to add the maximum stress and displacement at maximum stress to the plot.

``` code
plot_sample(df, numbar=0, obs="", save=False, folder="", info=False)
```
   <a>
     <img src="https://github.com/GabrielVZanata/pyTensileTest/blob/main/5_1.png" alt="Individual plot" width=400 height=300>
   </a>

  
## plot_group

The plot_gorup function plots the stress x strain diagram for a group of selected samples.

The expected arguments are:
- df - the Dataframe containing the stress and displacement data (in the format of the df returned by the read_testdata function)
- list - list with the appearance numbers of the desired samples (starting at 0), for example: to plot the 2nd, 3rd, 8th and 10th samples of the dataframe, use list=[1,2,7,9] .
- obs - A string with a note to be appended to the title of the plot.
- save - True to save the plot to disk.
- folder - Directory where the plot should be saved.
- group_name - String to define the name of the group of samples to be presented in the title of the plot.

``` code
plot_group (df, list, obs="", group_name="", save=False, folder="")
```
   <a>
     <img src="https://github.com/GabrielVZanata/pyTensileTest/blob/main/Amostras%20de%2016mm.png" alt="Group plot" width=400 height=300>
   </a>

## Autor

**Gabriel Valverde Zanata da Silva**

- <https://github.com/GabrielVZanata>
- <https://www.linkedin.com/in/gabriel-valverde-62141a227/>

This code was developed by Gabriel Valverde Zanata da Silva, a former student at the Polytechnic School of the University of Sao Paulo, to facilitate the manipulation and analysis of test data from the Shimadzu universal testing machine.
The communication channels cited above can be used for reporting bugs and giving suggestions. 


## Copyright and license

Code and documentation copyright 2023 Gabriel Valverde Zanata da Silva. Code released under the [MIT License](https://reponame/blob/master/LICENSE).
