from __future__ import annotations
from collections.abc import Callable
from typing import Any
from ...fable_modules.fable_library.list import (of_array, FSharpList)
from ...fable_modules.fable_library.reflection import (TypeInfo, class_type)
from ...fable_modules.fable_library.seq import (map, iterate_indexed)
from ...fable_modules.fable_library.types import Array
from ..data_context import (DataContext, DataContext__get_Explication, DataContext__set_Explication_279AAFF2, DataContext__get_Unit, DataContext__set_Unit_279AAFF2, DataContext__get_ObjectType, DataContext__set_ObjectType_279AAFF2, DataContext__get_Description, DataContext__set_Description_6DFDD678, DataContext__Copy)
from ..Helper.hash_codes import (hash_1, box_hash_seq)
from ..ontology_annotation import OntologyAnnotation
from .composite_cell import CompositeCell
from .composite_header import (IOType, CompositeHeader)

DataMapAux_dataHeader: CompositeHeader = CompositeHeader(11, IOType(2))

DataMapAux_explication: OntologyAnnotation = OntologyAnnotation("Clarification", "NCIT", "http://purl.obolibrary.org/obo/NCIT_C94778")

DataMapAux_explicationHeader: CompositeHeader = CompositeHeader(3, DataMapAux_explication)

DataMapAux_unit: OntologyAnnotation = OntologyAnnotation("Unit", "UO", "http://purl.obolibrary.org/obo/UO_0000000")

DataMapAux_unitHeader: CompositeHeader = CompositeHeader(3, DataMapAux_unit)

DataMapAux_objectType: OntologyAnnotation = OntologyAnnotation("Data Type", "NCIT", "http://purl.obolibrary.org/obo/NCIT_C42645")

DataMapAux_objectTypeHeader: CompositeHeader = CompositeHeader(3, DataMapAux_objectType)

DataMapAux_descriptionHeader: CompositeHeader = CompositeHeader(13, "Description")

DataMapAux_generatedByHeader: CompositeHeader = CompositeHeader(13, "Generated By")

DataMapAux_allowedHeaders: FSharpList[CompositeHeader] = of_array([DataMapAux_dataHeader, DataMapAux_explicationHeader, DataMapAux_unitHeader, DataMapAux_objectTypeHeader, DataMapAux_descriptionHeader, DataMapAux_generatedByHeader])

def DataMapAux_getOntologyColumn(f: Callable[[DataContext], OntologyAnnotation | None], data_contexts: Array[DataContext]) -> Array[CompositeCell]:
    def mapping(dc: DataContext, f: Any=f, data_contexts: Any=data_contexts) -> CompositeCell:
        match_value: OntologyAnnotation | None = f(dc)
        if match_value is None:
            return CompositeCell.empty_term()

        else: 
            return CompositeCell(0, match_value)


    return list(map(mapping, data_contexts))


def DataMapAux_getStringColumn(f: Callable[[DataContext], str | None], data_contexts: Array[DataContext]) -> Array[CompositeCell]:
    def mapping(dc: DataContext, f: Any=f, data_contexts: Any=data_contexts) -> CompositeCell:
        match_value: str | None = f(dc)
        if match_value is None:
            return CompositeCell.empty_free_text()

        else: 
            return CompositeCell(1, match_value)


    return list(map(mapping, data_contexts))


def DataMapAux_setOntologyColumn(f: Callable[[DataContext, OntologyAnnotation | None], None], column: Array[CompositeCell], data_contexts: Array[DataContext]) -> None:
    def action(i: int, cell: CompositeCell, f: Any=f, column: Any=column, data_contexts: Any=data_contexts) -> None:
        if cell.tag == 0:
            f(data_contexts[i], cell.fields[0])


    iterate_indexed(action, column)


def DataMapAux_setStringColumn(f: Callable[[DataContext, str | None], None], column: Array[CompositeCell], data_contexts: Array[DataContext]) -> None:
    def action(i: int, cell: CompositeCell, f: Any=f, column: Any=column, data_contexts: Any=data_contexts) -> None:
        if cell.tag == 1:
            f(data_contexts[i], cell.fields[0])


    iterate_indexed(action, column)


def DataMapAux_SanityChecks_rowIndexInBoundaries(row: int, data_contexts: Array[DataContext]) -> None:
    if row < 0:
        raise Exception("Row index must be greater or equal to 0.")

    if row >= len(data_contexts):
        raise Exception("Row index must be less than the number of rows.")



def DataMapAux_SanityChecks_lengthOfNewColumn(new_column: Array[CompositeCell], data_contexts: Array[DataContext]) -> None:
    if len(new_column) != len(data_contexts):
        raise Exception("Length of new column does not match length of data contexts.")



def _expr483() -> TypeInfo:
    return class_type("ARCtrl.DataMap", None, DataMap)


class DataMap:
    def __init__(self, data_contexts: Array[DataContext]) -> None:
        self.static_hash: int = 0
        self.data_contexts_0040103: Array[DataContext] = data_contexts

    def __eq__(self, obj: Any=None) -> bool:
        this: DataMap = self
        return hash_1(this) == hash_1(obj)

    def __hash__(self, __unit: None=None) -> Any:
        this: DataMap = self
        return box_hash_seq(this.data_contexts_0040103)


DataMap_reflection = _expr483

def DataMap__ctor_4E3220A7(data_contexts: Array[DataContext]) -> DataMap:
    return DataMap(data_contexts)


def DataMap__get_StaticHash(this: DataMap) -> int:
    return this.static_hash


def DataMap__set_StaticHash_Z524259A4(this: DataMap, value: int) -> None:
    this.static_hash = value or 0


def DataMap__get_DataContexts(this: DataMap) -> Array[DataContext]:
    return this.data_contexts_0040103


def DataMap_init(__unit: None=None) -> DataMap:
    return DataMap__ctor_4E3220A7([])


def DataMap__GetExplicationColumn(this: DataMap) -> Array[CompositeCell]:
    def _arrow484(dc: DataContext, this: Any=this) -> OntologyAnnotation | None:
        return DataContext__get_Explication(dc)

    return DataMapAux_getOntologyColumn(_arrow484, this.data_contexts_0040103)


def DataMap__SetExplicationColumn_C98E589(this: DataMap, cells: Array[CompositeCell]) -> None:
    def _arrow485(dc: DataContext, oa: OntologyAnnotation | None=None, this: Any=this, cells: Any=cells) -> None:
        DataContext__set_Explication_279AAFF2(dc, oa)

    DataMapAux_setOntologyColumn(_arrow485, cells, this.data_contexts_0040103)


def DataMap__GetUnitColumn(this: DataMap) -> Array[CompositeCell]:
    def _arrow486(dc: DataContext, this: Any=this) -> OntologyAnnotation | None:
        return DataContext__get_Unit(dc)

    return DataMapAux_getOntologyColumn(_arrow486, this.data_contexts_0040103)


def DataMap__SetUnitColumn_C98E589(this: DataMap, cells: Array[CompositeCell]) -> None:
    def _arrow487(dc: DataContext, oa: OntologyAnnotation | None=None, this: Any=this, cells: Any=cells) -> None:
        DataContext__set_Unit_279AAFF2(dc, oa)

    DataMapAux_setOntologyColumn(_arrow487, cells, this.data_contexts_0040103)


def DataMap__GetObjectTypeColumn(this: DataMap) -> Array[CompositeCell]:
    def _arrow488(dc: DataContext, this: Any=this) -> OntologyAnnotation | None:
        return DataContext__get_ObjectType(dc)

    return DataMapAux_getOntologyColumn(_arrow488, this.data_contexts_0040103)


def DataMap__SetDataTypeColumn_C98E589(this: DataMap, cells: Array[CompositeCell]) -> None:
    def _arrow489(dc: DataContext, oa: OntologyAnnotation | None=None, this: Any=this, cells: Any=cells) -> None:
        DataContext__set_ObjectType_279AAFF2(dc, oa)

    DataMapAux_setOntologyColumn(_arrow489, cells, this.data_contexts_0040103)


def DataMap__GetDescriptionColumn(this: DataMap) -> Array[CompositeCell]:
    def _arrow490(dc: DataContext, this: Any=this) -> str | None:
        return DataContext__get_Description(dc)

    return DataMapAux_getStringColumn(_arrow490, this.data_contexts_0040103)


def DataMap__SetDescriptionColumn_C98E589(this: DataMap, cells: Array[CompositeCell]) -> None:
    def _arrow491(dc: DataContext, s: str | None=None, this: Any=this, cells: Any=cells) -> None:
        DataContext__set_Description_6DFDD678(dc, s)

    DataMapAux_setStringColumn(_arrow491, cells, this.data_contexts_0040103)


def DataMap__GetDataContext_Z58338566(this: DataMap, row: int, SkipValidation: Any | None=None) -> DataContext:
    DataMapAux_SanityChecks_rowIndexInBoundaries(row, this.data_contexts_0040103)
    return this.data_contexts_0040103[row]


def DataMap_getDataContext_Z58338566(row: int, SkipValidation: Any | None=None) -> Callable[[DataMap], DataContext]:
    def _arrow492(dm: DataMap, row: Any=row, SkipValidation: Any=SkipValidation) -> DataContext:
        return DataMap__GetDataContext_Z58338566(dm, row, SkipValidation)

    return _arrow492


def DataMap__Copy(this: DataMap) -> DataMap:
    def mapping(dc: DataContext, this: Any=this) -> DataContext:
        return DataContext__Copy(dc)

    return DataMap__ctor_4E3220A7(list(map(mapping, this.data_contexts_0040103)))


__all__ = ["DataMapAux_dataHeader", "DataMapAux_explication", "DataMapAux_explicationHeader", "DataMapAux_unit", "DataMapAux_unitHeader", "DataMapAux_objectType", "DataMapAux_objectTypeHeader", "DataMapAux_descriptionHeader", "DataMapAux_generatedByHeader", "DataMapAux_allowedHeaders", "DataMapAux_getOntologyColumn", "DataMapAux_getStringColumn", "DataMapAux_setOntologyColumn", "DataMapAux_setStringColumn", "DataMapAux_SanityChecks_rowIndexInBoundaries", "DataMapAux_SanityChecks_lengthOfNewColumn", "DataMap_reflection", "DataMap__get_StaticHash", "DataMap__set_StaticHash_Z524259A4", "DataMap__get_DataContexts", "DataMap_init", "DataMap__GetExplicationColumn", "DataMap__SetExplicationColumn_C98E589", "DataMap__GetUnitColumn", "DataMap__SetUnitColumn_C98E589", "DataMap__GetObjectTypeColumn", "DataMap__SetDataTypeColumn_C98E589", "DataMap__GetDescriptionColumn", "DataMap__SetDescriptionColumn_C98E589", "DataMap__GetDataContext_Z58338566", "DataMap_getDataContext_Z58338566", "DataMap__Copy"]

