# -*- coding: utf-8 -*-

from datetime import datetime

def u(string):
    return unicode(string,
                   encoding='UTF-8',
                   errors="replace").encode('UTF-8',
                                            errors="replace")

header_start_tpl = u("""
///
/// Generated by iod-symbolizer at %s
/// iod-symbolizer by Alexander Bohn -- http://github.com/fish2000/iod-symbolizer
/// IOD library by Matthieu Garrigues -- https://github.com/matt-42/iod
///

#ifndef IOD_SYMBOLYZER_OUTPUT_HEADER_TEMPLATE_
#define IOD_SYMBOLYZER_OUTPUT_HEADER_TEMPLATE_

#include <iod/symbol.hh>

""")

header_end_tpl = u("""
#endif /// IOD_SYMBOLYZER_OUTPUT_HEADER_TEMPLATE_
""")

header_num_symbol_tpl = u("""
#ifndef IOD_SYMBOL_%(symbol)s
    #define IOD_SYMBOL_%(symbol)s
    iod_define_number_symbol(%(symbol)s)
#endif

""")

header_std_symbol_tpl = u("""
#ifndef IOD_SYMBOL_%(symbol)s
    #define IOD_SYMBOL_%(symbol)s
    iod_define_symbol(%(symbol)s)
#endif

""")

def generate_header(symbol_set, when=None):
    if when is None:
        when = datetime.now().isoformat()
    
    header_out = header_start_tpl % when
    
    for symbol in sorted(symbol_set):
        try:
            int(symbol)
        except ValueError:
            # it's not a number
            header_out += header_std_symbol_tpl % dict(symbol=u(symbol))
        else:
            # ok, it's a number
            header_out += header_num_symbol_tpl % dict(symbol=u(symbol))
    
    header_out += header_end_tpl
    
    return header_out