function(enable_sanitizers project_name)
  if(CMAKE_CXX_COMPILER_ID STREQUAL "Clang")
    option(ENABLE_COVERAGE "Enable coverage report for clang" OFF)
    message(STATUS "ENABLE_COVERAGE: ${ENABLE_COVERAGE}")
    if (ENABLE_COVERAGE)
      target_compile_options(${project_name} INTERFACE -fprofile-instr-generate -fcoverage-mapping -O0 -g)
      target_link_libraries(${project_name} INTERFACE -fprofile-instr-generate -fcoverage-mapping)
    endif()
  endif()
endfunction()
