
<p align="center">
  <img src="https://raw.githubusercontent.com/NREL/polyID/master/images/polyID-logo_color-full.svg" alt="PolyID Logo" width="400"/>
</p>

PolyID<sup>TM</sup> provides a framework for building, training, and predicting polymer properities using graph neural networks. The codes leverages [nfp](https://pypi.org/project/nfp/), for building tensorflow-based message-passing neural networ, and [m2p](https://pypi.org/project/m2p/), for building polymer structures.  To understand and use the pipeline, the following examples have been provided:

1. [Building polymer structures](https://github.nrel.gov/InversePolymerDesign/polyID/blob/master/examples/example_generate_polymer_structures.ipynb): `examples/example_generate_polymer_structures.ipynb`
2. [Checking domain of validity](https://github.nrel.gov/InversePolymerDesign/polyID/blob/master/examples/example_determine_domain-of-validity.ipynb): `examples/example_determine_domain-of-validity.ipynb`
3. [Training a graph neural network](https://github.nrel.gov/InversePolymerDesign/polyID/blob/master/examples/example_generate_and_train_models.ipynb): `examples/example_generate_and_train_models.ipynb`
4. [Predicting with the trained model](https://github.nrel.gov/InversePolymerDesign/polyID/blob/master/examples/example_predict_with_trained_models.ipynb): `examples/example_predict_with_trained_models.ipynb` 

Details for the methods are forthcoming in an upcoming manuscript.
