# coding: utf-8

"""
    UniCatDB API

    UniCatDB application API documentation, with examples and live testing.  This API is built in accordance with the **JSON API 1.0 standard**. For general information, see [the documentation](http://jsonapi.org/format/).  **Notes:** * JSON API standard requires use of the JSON API media type (application/vnd.api+json) for exchanging data. Clients must send all JSON API data with the headers `Content-Type: application/vnd.api+json` (POST, PATCH) and `Accept: application/vnd.api+json` (GET, DELETE). * [Relationships](http://jsonapi.org/format/#fetching-relationships) and their [inclusions](http://jsonapi.org/format/#fetching-includes) via the `include` query parameter, as specified by the standard, **are not implemented**, since there are no relationships present in the data model. * The standard does not prescribe any filtering strategies. This API implements two strategies which can be combined: **Basic filtering** based on the used [JSON API library](https://json-api-dotnet.github.io/#/filtering) and **Custom filtering** which allow for any possible query to the MongoDB server and can be extended and customize in the future. For more information about filtering, see the description of the `filter` down bellow. * **Non-standard PATCH behavior:** Sucessfull PATCH reuest always result in HTTP 200 response with the updated resource object, even if the server does not perform any additional modifications. HTTP 204 is never used in PATCH responses.   # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from unicatdb.openapi_client.api_client import ApiClient
from unicatdb.openapi_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class SchemasApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def api_schemas_delete_by_id(self, id, **kwargs):  # noqa: E501
        """Delete a specific schema, if exists  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_schemas_delete_by_id(id, async_req=True)
        >>> result = thread.get()

        :param id: Resource identifier, 24 lowercase hex digit string. (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.api_schemas_delete_by_id_with_http_info(id, **kwargs)  # noqa: E501

    def api_schemas_delete_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """Delete a specific schema, if exists  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_schemas_delete_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: Resource identifier, 24 lowercase hex digit string. (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_schemas_delete_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `api_schemas_delete_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.api+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'JwtAuth']  # noqa: E501
        
        response_types_map = {}

        return self.api_client.call_api(
            '/api/schemas/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def api_schemas_get(self, **kwargs):  # noqa: E501
        """Get paged list of schemas matching optional criteria  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_schemas_get(async_req=True)
        >>> result = thread.get()

        :param sort: **Sort results by specified property name.**  ---------------  Default sorting order is descending. To sort in ascending order, prepend hypen charater (-) before the property name.  Nested object properties CAN be referenced by the dot notation (e.g: *taxonomyTree.root.name*). Entities with missing referenced property are sorted on top of the results (missing propety = smallest value).  Sorting by multiple properties is supported - individual property names can be separated by comma charater (,). Order of the properties does matter. 
        :type sort: str
        :param page: **Specifies page size and page number for paged data responses.**  ---------------  Paging is optional. If not specified, the result will be paged based on the application defaults.  Paging may be turned off by passing page size of -1.  Links to the next, previous, first and last pages are provided in the `meta` property of the response, if applicable.  **Examples:**   * `?page[number]=2&page[size]=15` * `?page[size]=-1` - turns of paging 
        :type page: PageQuery
        :param fields: **Returns sparse field sets for a given resource type.**  ---------------  Since relationships and inclusion are not supported, use only resource type of the main entity (in this case findings).  Only specified fields will be returned, individual fields needs to be separated by comma (,) character.  Field set limiting by the nested properties (e.g. taxonomyTree.something) is NOT SUPPORTED and will result in HTTP 400 error.  **Examples:** * `?fields=name,color` * `?fields=taxonomyTree` - works OK  * `?fields=taxonomyTree.root` - **DOES NOT WORK!** 
        :type fields: FindingSchemaFieldsQuery
        :param filter: **Provides filter to be applied on the result set returned.**  ---------------  Filters are specified as as collection of *key<>value* pairs representing individual filters. If more filters are specifies, they are combined using *AND* logic operator.  Two filtering strategies are suported:  **Basic filter**  * *Key* - property name (nested properties are supported via dot notation)  * *Value* - filter expression prefixed with operation (operation is optional, defaults to **eq:** if not specified). Supprted operations:   * <code>filter[*property*]=<b>eq:</b>*value*</code> - Is equal to   * <code>filter[*property*]=<b>eqi:</b>*value*</code> - Is equal to (case insensitive)   * <code>filter[*property*]=<b>ne:</b>*value*</code> - Is not equal to   * <code>filter[*property*]=<b>lt:</b>*value*</code> - Is less than   * <code>filter[*property*]=<b>gt:</b>*value*</code> - Is greater than   * <code>filter[*property*]=<b>le:</b>*value*</code> - Is less than or equal   * <code>filter[*property*]=<b>ge:</b>*value*</code> - Is greater than or equal   * <code>filter[*property*]=<b>like:</b>*value*</code> - Contains substring   * <code>filter[*property*]=<b>in:</b>*value1*,*value2*,...</code> - Is in list   * <code>filter[*property*]=<b>nin:</b>*value1*,*value2*,...</code> - Is not in list  **Custom filter**  * *Key* - filter name, prefixed by underschore character (_)  * *Value* - filter expression, format depends on the selected filter. *There no custom filters for the schemas yet***: 
        :type filter: dict(str, str)
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FindingSchemaArrayResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.api_schemas_get_with_http_info(**kwargs)  # noqa: E501

    def api_schemas_get_with_http_info(self, **kwargs):  # noqa: E501
        """Get paged list of schemas matching optional criteria  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_schemas_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param sort: **Sort results by specified property name.**  ---------------  Default sorting order is descending. To sort in ascending order, prepend hypen charater (-) before the property name.  Nested object properties CAN be referenced by the dot notation (e.g: *taxonomyTree.root.name*). Entities with missing referenced property are sorted on top of the results (missing propety = smallest value).  Sorting by multiple properties is supported - individual property names can be separated by comma charater (,). Order of the properties does matter. 
        :type sort: str
        :param page: **Specifies page size and page number for paged data responses.**  ---------------  Paging is optional. If not specified, the result will be paged based on the application defaults.  Paging may be turned off by passing page size of -1.  Links to the next, previous, first and last pages are provided in the `meta` property of the response, if applicable.  **Examples:**   * `?page[number]=2&page[size]=15` * `?page[size]=-1` - turns of paging 
        :type page: PageQuery
        :param fields: **Returns sparse field sets for a given resource type.**  ---------------  Since relationships and inclusion are not supported, use only resource type of the main entity (in this case findings).  Only specified fields will be returned, individual fields needs to be separated by comma (,) character.  Field set limiting by the nested properties (e.g. taxonomyTree.something) is NOT SUPPORTED and will result in HTTP 400 error.  **Examples:** * `?fields=name,color` * `?fields=taxonomyTree` - works OK  * `?fields=taxonomyTree.root` - **DOES NOT WORK!** 
        :type fields: FindingSchemaFieldsQuery
        :param filter: **Provides filter to be applied on the result set returned.**  ---------------  Filters are specified as as collection of *key<>value* pairs representing individual filters. If more filters are specifies, they are combined using *AND* logic operator.  Two filtering strategies are suported:  **Basic filter**  * *Key* - property name (nested properties are supported via dot notation)  * *Value* - filter expression prefixed with operation (operation is optional, defaults to **eq:** if not specified). Supprted operations:   * <code>filter[*property*]=<b>eq:</b>*value*</code> - Is equal to   * <code>filter[*property*]=<b>eqi:</b>*value*</code> - Is equal to (case insensitive)   * <code>filter[*property*]=<b>ne:</b>*value*</code> - Is not equal to   * <code>filter[*property*]=<b>lt:</b>*value*</code> - Is less than   * <code>filter[*property*]=<b>gt:</b>*value*</code> - Is greater than   * <code>filter[*property*]=<b>le:</b>*value*</code> - Is less than or equal   * <code>filter[*property*]=<b>ge:</b>*value*</code> - Is greater than or equal   * <code>filter[*property*]=<b>like:</b>*value*</code> - Contains substring   * <code>filter[*property*]=<b>in:</b>*value1*,*value2*,...</code> - Is in list   * <code>filter[*property*]=<b>nin:</b>*value1*,*value2*,...</code> - Is not in list  **Custom filter**  * *Key* - filter name, prefixed by underschore character (_)  * *Value* - filter expression, format depends on the selected filter. *There no custom filters for the schemas yet***: 
        :type filter: dict(str, str)
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FindingSchemaArrayResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'sort',
            'page',
            'fields',
            'filter'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_schemas_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'fields' in local_var_params and local_var_params['fields'] is not None:  # noqa: E501
            query_params.append(('fields', local_var_params['fields']))  # noqa: E501
        if 'filter' in local_var_params and local_var_params['filter'] is not None:  # noqa: E501
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.api+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'JwtAuth']  # noqa: E501
        
        response_types_map = {
            200: "FindingSchemaArrayResponse",
            400: "ErrorResponse",
            401: None,
            415: None,
        }

        return self.api_client.call_api(
            '/api/schemas', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def api_schemas_get_by_id(self, id, **kwargs):  # noqa: E501
        """Get a specific schema, if exists  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_schemas_get_by_id(id, async_req=True)
        >>> result = thread.get()

        :param id: Resource identifier, 24 lowercase hex digit string. (required)
        :type id: str
        :param fields: **Returns sparse field sets for a given resource type.**  ---------------  Since relationships and inclusion are not supported, use only resource type of the main entity (in this case findings).  Only specified fields will be returned, individual fields needs to be separated by comma (,) character.  Field set limiting by the nested properties (e.g. taxonomyTree.something) is NOT SUPPORTED and will result in HTTP 400 error.  **Examples:** * `?fields=name,color` * `?fields=taxonomyTree` - works OK  * `?fields=taxonomyTree.root` - **DOES NOT WORK!** 
        :type fields: FindingSchemaFieldsQuery
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FindingSchemaSingleResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.api_schemas_get_by_id_with_http_info(id, **kwargs)  # noqa: E501

    def api_schemas_get_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get a specific schema, if exists  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_schemas_get_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: Resource identifier, 24 lowercase hex digit string. (required)
        :type id: str
        :param fields: **Returns sparse field sets for a given resource type.**  ---------------  Since relationships and inclusion are not supported, use only resource type of the main entity (in this case findings).  Only specified fields will be returned, individual fields needs to be separated by comma (,) character.  Field set limiting by the nested properties (e.g. taxonomyTree.something) is NOT SUPPORTED and will result in HTTP 400 error.  **Examples:** * `?fields=name,color` * `?fields=taxonomyTree` - works OK  * `?fields=taxonomyTree.root` - **DOES NOT WORK!** 
        :type fields: FindingSchemaFieldsQuery
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FindingSchemaSingleResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id',
            'fields'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_schemas_get_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `api_schemas_get_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'fields' in local_var_params and local_var_params['fields'] is not None:  # noqa: E501
            query_params.append(('fields', local_var_params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.api+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'JwtAuth']  # noqa: E501
        
        response_types_map = {
            200: "FindingSchemaSingleResponse",
            400: "ErrorResponse",
            401: None,
            404: None,
            415: None,
        }

        return self.api_client.call_api(
            '/api/schemas/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def api_schemas_get_by_id_findings(self, id, **kwargs):  # noqa: E501
        """Get findings related to a schema  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_schemas_get_by_id_findings(id, async_req=True)
        >>> result = thread.get()

        :param id: Resource identifier, 24 lowercase hex digit string. (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FindingArrayResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.api_schemas_get_by_id_findings_with_http_info(id, **kwargs)  # noqa: E501

    def api_schemas_get_by_id_findings_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get findings related to a schema  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_schemas_get_by_id_findings_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: Resource identifier, 24 lowercase hex digit string. (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FindingArrayResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_schemas_get_by_id_findings" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `api_schemas_get_by_id_findings`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.api+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'JwtAuth']  # noqa: E501
        
        response_types_map = {
            200: "FindingArrayResponse",
            400: "ErrorResponse",
            401: None,
            404: None,
            415: None,
        }

        return self.api_client.call_api(
            '/api/schemas/{id}/findings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def api_schemas_get_by_id_relationships_findings(self, id, **kwargs):  # noqa: E501
        """Get resource identifiers for a given relationship of a schema  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_schemas_get_by_id_relationships_findings(id, async_req=True)
        >>> result = thread.get()

        :param id: Resource identifier, 24 lowercase hex digit string. (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RelationshipResourceIdentifierArrayResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.api_schemas_get_by_id_relationships_findings_with_http_info(id, **kwargs)  # noqa: E501

    def api_schemas_get_by_id_relationships_findings_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get resource identifiers for a given relationship of a schema  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_schemas_get_by_id_relationships_findings_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: Resource identifier, 24 lowercase hex digit string. (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(RelationshipResourceIdentifierArrayResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_schemas_get_by_id_relationships_findings" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `api_schemas_get_by_id_relationships_findings`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.api+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'JwtAuth']  # noqa: E501
        
        response_types_map = {
            200: "RelationshipResourceIdentifierArrayResponse",
            401: None,
            404: None,
            415: None,
        }

        return self.api_client.call_api(
            '/api/schemas/{id}/relationships/findings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def api_schemas_patch_by_id(self, id, **kwargs):  # noqa: E501
        """Update an existing schema, if exists  # noqa: E501

        Notes concerinig the payload:  * Partial updates are supported. Ommited attributes will not be changed.  * Some attributes are modified by the server:    * Properties *definitions[].name*, if present, are transformed by the server into a more human-readable form by appending the sluggified *definitions[].label*, if present. Allready transformed properties are skipped to prevent unwanted changes (subsequent change in *definitions[].label* does not affect *definitions[].name*).   * **Non-standard PATCH behavior:** Sucessfull PATCH reuest always result in HTTP 200 response with the updated resource object, even if the server does not perform any additional modifications. HTTP 204 is never used in PATCH responses.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_schemas_patch_by_id(id, async_req=True)
        >>> result = thread.get()

        :param id: Resource identifier, 24 lowercase hex digit string. (required)
        :type id: str
        :param existing_finding_schema_request_body:
        :type existing_finding_schema_request_body: ExistingFindingSchemaRequestBody
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FindingSchemaSingleResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.api_schemas_patch_by_id_with_http_info(id, **kwargs)  # noqa: E501

    def api_schemas_patch_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """Update an existing schema, if exists  # noqa: E501

        Notes concerinig the payload:  * Partial updates are supported. Ommited attributes will not be changed.  * Some attributes are modified by the server:    * Properties *definitions[].name*, if present, are transformed by the server into a more human-readable form by appending the sluggified *definitions[].label*, if present. Allready transformed properties are skipped to prevent unwanted changes (subsequent change in *definitions[].label* does not affect *definitions[].name*).   * **Non-standard PATCH behavior:** Sucessfull PATCH reuest always result in HTTP 200 response with the updated resource object, even if the server does not perform any additional modifications. HTTP 204 is never used in PATCH responses.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_schemas_patch_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: Resource identifier, 24 lowercase hex digit string. (required)
        :type id: str
        :param existing_finding_schema_request_body:
        :type existing_finding_schema_request_body: ExistingFindingSchemaRequestBody
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FindingSchemaSingleResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id',
            'existing_finding_schema_request_body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_schemas_patch_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `api_schemas_patch_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'existing_finding_schema_request_body' in local_var_params:
            body_params = local_var_params['existing_finding_schema_request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.api+json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/vnd.api+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'JwtAuth']  # noqa: E501
        
        response_types_map = {
            200: "FindingSchemaSingleResponse",
            400: "ErrorResponse",
            401: None,
            404: None,
            415: None,
            442: None,
        }

        return self.api_client.call_api(
            '/api/schemas/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def api_schemas_post(self, **kwargs):  # noqa: E501
        """Insert new schema to the database  # noqa: E501

        Notes concerinig the payload:  * ID of the inserted entity is created dynamically by the server, **providing client-generated ID in the request will result in HTTP 403 error**  * Some attributes are modified by the server:    * Properties *definitions[].name*, if present, are transformed by the server into a more human-readable form by appending the sluggified *definitions[].label*, if present.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_schemas_post(async_req=True)
        >>> result = thread.get()

        :param new_finding_schema_request_body:
        :type new_finding_schema_request_body: NewFindingSchemaRequestBody
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FindingSchemaSingleResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.api_schemas_post_with_http_info(**kwargs)  # noqa: E501

    def api_schemas_post_with_http_info(self, **kwargs):  # noqa: E501
        """Insert new schema to the database  # noqa: E501

        Notes concerinig the payload:  * ID of the inserted entity is created dynamically by the server, **providing client-generated ID in the request will result in HTTP 403 error**  * Some attributes are modified by the server:    * Properties *definitions[].name*, if present, are transformed by the server into a more human-readable form by appending the sluggified *definitions[].label*, if present.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_schemas_post_with_http_info(async_req=True)
        >>> result = thread.get()

        :param new_finding_schema_request_body:
        :type new_finding_schema_request_body: NewFindingSchemaRequestBody
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FindingSchemaSingleResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'new_finding_schema_request_body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_schemas_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'new_finding_schema_request_body' in local_var_params:
            body_params = local_var_params['new_finding_schema_request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.api+json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/vnd.api+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'JwtAuth']  # noqa: E501
        
        response_types_map = {
            201: "FindingSchemaSingleResponse",
            400: "ErrorResponse",
            401: None,
            403: None,
            409: "ErrorResponse",
            415: None,
            442: None,
        }

        return self.api_client.call_api(
            '/api/schemas', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
