# Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
# with the License. A copy of the License is located at http://aws.amazon.com/apache2.0/
# or in the "LICENSE.txt" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES
# OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions and
# limitations under the License.

# pylint: disable=R0801


from typing import List

from pcluster.api import util
from pcluster.api.models.base_model_ import Model
from pcluster.api.models.cluster_instance import ClusterInstance


class DescribeClusterInstancesResponseContent(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, instances=None, next_token=None):
        """DescribeClusterInstancesResponseContent - a model defined in OpenAPI

        :param instances: The instances of this DescribeClusterInstancesResponseContent.
        :type instances: List[ClusterInstance]
        :param next_token: The next_token of this DescribeClusterInstancesResponseContent.
        :type next_token: str
        """
        self.openapi_types = {"instances": List[ClusterInstance], "next_token": str}

        self.attribute_map = {"instances": "instances", "next_token": "nextToken"}

        self._instances = instances
        self._next_token = next_token

    @classmethod
    def from_dict(cls, dikt) -> "DescribeClusterInstancesResponseContent":
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The DescribeClusterInstancesResponseContent of this DescribeClusterInstancesResponseContent.
        :rtype: DescribeClusterInstancesResponseContent
        """
        return util.deserialize_model(dikt, cls)

    @property
    def instances(self):
        """Gets the instances of this DescribeClusterInstancesResponseContent.


        :return: The instances of this DescribeClusterInstancesResponseContent.
        :rtype: List[ClusterInstance]
        """
        return self._instances

    @instances.setter
    def instances(self, instances):
        """Sets the instances of this DescribeClusterInstancesResponseContent.


        :param instances: The instances of this DescribeClusterInstancesResponseContent.
        :type instances: List[ClusterInstance]
        """
        if instances is None:
            raise ValueError("Invalid value for `instances`, must not be `None`")

        self._instances = instances

    @property
    def next_token(self):
        """Gets the next_token of this DescribeClusterInstancesResponseContent.

        Token to use for paginated requests.

        :return: The next_token of this DescribeClusterInstancesResponseContent.
        :rtype: str
        """
        return self._next_token

    @next_token.setter
    def next_token(self, next_token):
        """Sets the next_token of this DescribeClusterInstancesResponseContent.

        Token to use for paginated requests.

        :param next_token: The next_token of this DescribeClusterInstancesResponseContent.
        :type next_token: str
        """

        self._next_token = next_token
