window.pdocSearch = (function(){
/** elasticlunr - http://weixsong.github.io * Copyright (C) 2017 Oliver Nightingale * Copyright (C) 2017 Wei Song * MIT Licensed */!function(){function e(e){if(null===e||"object"!=typeof e)return e;var t=e.constructor();for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n]);return t}var t=function(e){var n=new t.Index;return n.pipeline.add(t.trimmer,t.stopWordFilter,t.stemmer),e&&e.call(n,n),n};t.version="0.9.5",lunr=t,t.utils={},t.utils.warn=function(e){return function(t){e.console&&console.warn&&console.warn(t)}}(this),t.utils.toString=function(e){return void 0===e||null===e?"":e.toString()},t.EventEmitter=function(){this.events={}},t.EventEmitter.prototype.addListener=function(){var e=Array.prototype.slice.call(arguments),t=e.pop(),n=e;if("function"!=typeof t)throw new TypeError("last argument must be a function");n.forEach(function(e){this.hasHandler(e)||(this.events[e]=[]),this.events[e].push(t)},this)},t.EventEmitter.prototype.removeListener=function(e,t){if(this.hasHandler(e)){var n=this.events[e].indexOf(t);-1!==n&&(this.events[e].splice(n,1),0==this.events[e].length&&delete this.events[e])}},t.EventEmitter.prototype.emit=function(e){if(this.hasHandler(e)){var t=Array.prototype.slice.call(arguments,1);this.events[e].forEach(function(e){e.apply(void 0,t)},this)}},t.EventEmitter.prototype.hasHandler=function(e){return e in this.events},t.tokenizer=function(e){if(!arguments.length||null===e||void 0===e)return[];if(Array.isArray(e)){var n=e.filter(function(e){return null===e||void 0===e?!1:!0});n=n.map(function(e){return t.utils.toString(e).toLowerCase()});var i=[];return n.forEach(function(e){var n=e.split(t.tokenizer.seperator);i=i.concat(n)},this),i}return e.toString().trim().toLowerCase().split(t.tokenizer.seperator)},t.tokenizer.defaultSeperator=/[\s\-]+/,t.tokenizer.seperator=t.tokenizer.defaultSeperator,t.tokenizer.setSeperator=function(e){null!==e&&void 0!==e&&"object"==typeof e&&(t.tokenizer.seperator=e)},t.tokenizer.resetSeperator=function(){t.tokenizer.seperator=t.tokenizer.defaultSeperator},t.tokenizer.getSeperator=function(){return t.tokenizer.seperator},t.Pipeline=function(){this._queue=[]},t.Pipeline.registeredFunctions={},t.Pipeline.registerFunction=function(e,n){n in t.Pipeline.registeredFunctions&&t.utils.warn("Overwriting existing registered function: "+n),e.label=n,t.Pipeline.registeredFunctions[n]=e},t.Pipeline.getRegisteredFunction=function(e){return e in t.Pipeline.registeredFunctions!=!0?null:t.Pipeline.registeredFunctions[e]},t.Pipeline.warnIfFunctionNotRegistered=function(e){var n=e.label&&e.label in this.registeredFunctions;n||t.utils.warn("Function is not registered with pipeline. This may cause problems when serialising the index.\n",e)},t.Pipeline.load=function(e){var n=new t.Pipeline;return e.forEach(function(e){var i=t.Pipeline.getRegisteredFunction(e);if(!i)throw new Error("Cannot load un-registered function: "+e);n.add(i)}),n},t.Pipeline.prototype.add=function(){var e=Array.prototype.slice.call(arguments);e.forEach(function(e){t.Pipeline.warnIfFunctionNotRegistered(e),this._queue.push(e)},this)},t.Pipeline.prototype.after=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i+1,0,n)},t.Pipeline.prototype.before=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i,0,n)},t.Pipeline.prototype.remove=function(e){var t=this._queue.indexOf(e);-1!==t&&this._queue.splice(t,1)},t.Pipeline.prototype.run=function(e){for(var t=[],n=e.length,i=this._queue.length,o=0;n>o;o++){for(var r=e[o],s=0;i>s&&(r=this._queue[s](r,o,e),void 0!==r&&null!==r);s++);void 0!==r&&null!==r&&t.push(r)}return t},t.Pipeline.prototype.reset=function(){this._queue=[]},t.Pipeline.prototype.get=function(){return this._queue},t.Pipeline.prototype.toJSON=function(){return this._queue.map(function(e){return t.Pipeline.warnIfFunctionNotRegistered(e),e.label})},t.Index=function(){this._fields=[],this._ref="id",this.pipeline=new t.Pipeline,this.documentStore=new t.DocumentStore,this.index={},this.eventEmitter=new t.EventEmitter,this._idfCache={},this.on("add","remove","update",function(){this._idfCache={}}.bind(this))},t.Index.prototype.on=function(){var e=Array.prototype.slice.call(arguments);return this.eventEmitter.addListener.apply(this.eventEmitter,e)},t.Index.prototype.off=function(e,t){return this.eventEmitter.removeListener(e,t)},t.Index.load=function(e){e.version!==t.version&&t.utils.warn("version mismatch: current "+t.version+" importing "+e.version);var n=new this;n._fields=e.fields,n._ref=e.ref,n.documentStore=t.DocumentStore.load(e.documentStore),n.pipeline=t.Pipeline.load(e.pipeline),n.index={};for(var i in e.index)n.index[i]=t.InvertedIndex.load(e.index[i]);return n},t.Index.prototype.addField=function(e){return this._fields.push(e),this.index[e]=new t.InvertedIndex,this},t.Index.prototype.setRef=function(e){return this._ref=e,this},t.Index.prototype.saveDocument=function(e){return this.documentStore=new t.DocumentStore(e),this},t.Index.prototype.addDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.addDoc(i,e),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));this.documentStore.addFieldLength(i,n,o.length);var r={};o.forEach(function(e){e in r?r[e]+=1:r[e]=1},this);for(var s in r){var u=r[s];u=Math.sqrt(u),this.index[n].addToken(s,{ref:i,tf:u})}},this),n&&this.eventEmitter.emit("add",e,this)}},t.Index.prototype.removeDocByRef=function(e){if(e&&this.documentStore.isDocStored()!==!1&&this.documentStore.hasDoc(e)){var t=this.documentStore.getDoc(e);this.removeDoc(t,!1)}},t.Index.prototype.removeDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.hasDoc(i)&&(this.documentStore.removeDoc(i),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));o.forEach(function(e){this.index[n].removeToken(e,i)},this)},this),n&&this.eventEmitter.emit("remove",e,this))}},t.Index.prototype.updateDoc=function(e,t){var t=void 0===t?!0:t;this.removeDocByRef(e[this._ref],!1),this.addDoc(e,!1),t&&this.eventEmitter.emit("update",e,this)},t.Index.prototype.idf=function(e,t){var n="@"+t+"/"+e;if(Object.prototype.hasOwnProperty.call(this._idfCache,n))return this._idfCache[n];var i=this.index[t].getDocFreq(e),o=1+Math.log(this.documentStore.length/(i+1));return this._idfCache[n]=o,o},t.Index.prototype.getFields=function(){return this._fields.slice()},t.Index.prototype.search=function(e,n){if(!e)return[];e="string"==typeof e?{any:e}:JSON.parse(JSON.stringify(e));var i=null;null!=n&&(i=JSON.stringify(n));for(var o=new t.Configuration(i,this.getFields()).get(),r={},s=Object.keys(e),u=0;u<s.length;u++){var a=s[u];r[a]=this.pipeline.run(t.tokenizer(e[a]))}var l={};for(var c in o){var d=r[c]||r.any;if(d){var f=this.fieldSearch(d,c,o),h=o[c].boost;for(var p in f)f[p]=f[p]*h;for(var p in f)p in l?l[p]+=f[p]:l[p]=f[p]}}var v,g=[];for(var p in l)v={ref:p,score:l[p]},this.documentStore.hasDoc(p)&&(v.doc=this.documentStore.getDoc(p)),g.push(v);return g.sort(function(e,t){return t.score-e.score}),g},t.Index.prototype.fieldSearch=function(e,t,n){var i=n[t].bool,o=n[t].expand,r=n[t].boost,s=null,u={};return 0!==r?(e.forEach(function(e){var n=[e];1==o&&(n=this.index[t].expandToken(e));var r={};n.forEach(function(n){var o=this.index[t].getDocs(n),a=this.idf(n,t);if(s&&"AND"==i){var l={};for(var c in s)c in o&&(l[c]=o[c]);o=l}n==e&&this.fieldSearchStats(u,n,o);for(var c in o){var d=this.index[t].getTermFrequency(n,c),f=this.documentStore.getFieldLength(c,t),h=1;0!=f&&(h=1/Math.sqrt(f));var p=1;n!=e&&(p=.15*(1-(n.length-e.length)/n.length));var v=d*a*h*p;c in r?r[c]+=v:r[c]=v}},this),s=this.mergeScores(s,r,i)},this),s=this.coordNorm(s,u,e.length)):void 0},t.Index.prototype.mergeScores=function(e,t,n){if(!e)return t;if("AND"==n){var i={};for(var o in t)o in e&&(i[o]=e[o]+t[o]);return i}for(var o in t)o in e?e[o]+=t[o]:e[o]=t[o];return e},t.Index.prototype.fieldSearchStats=function(e,t,n){for(var i in n)i in e?e[i].push(t):e[i]=[t]},t.Index.prototype.coordNorm=function(e,t,n){for(var i in e)if(i in t){var o=t[i].length;e[i]=e[i]*o/n}return e},t.Index.prototype.toJSON=function(){var e={};return this._fields.forEach(function(t){e[t]=this.index[t].toJSON()},this),{version:t.version,fields:this._fields,ref:this._ref,documentStore:this.documentStore.toJSON(),index:e,pipeline:this.pipeline.toJSON()}},t.Index.prototype.use=function(e){var t=Array.prototype.slice.call(arguments,1);t.unshift(this),e.apply(this,t)},t.DocumentStore=function(e){this._save=null===e||void 0===e?!0:e,this.docs={},this.docInfo={},this.length=0},t.DocumentStore.load=function(e){var t=new this;return t.length=e.length,t.docs=e.docs,t.docInfo=e.docInfo,t._save=e.save,t},t.DocumentStore.prototype.isDocStored=function(){return this._save},t.DocumentStore.prototype.addDoc=function(t,n){this.hasDoc(t)||this.length++,this.docs[t]=this._save===!0?e(n):null},t.DocumentStore.prototype.getDoc=function(e){return this.hasDoc(e)===!1?null:this.docs[e]},t.DocumentStore.prototype.hasDoc=function(e){return e in this.docs},t.DocumentStore.prototype.removeDoc=function(e){this.hasDoc(e)&&(delete this.docs[e],delete this.docInfo[e],this.length--)},t.DocumentStore.prototype.addFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&(this.docInfo[e]||(this.docInfo[e]={}),this.docInfo[e][t]=n)},t.DocumentStore.prototype.updateFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&this.addFieldLength(e,t,n)},t.DocumentStore.prototype.getFieldLength=function(e,t){return null===e||void 0===e?0:e in this.docs&&t in this.docInfo[e]?this.docInfo[e][t]:0},t.DocumentStore.prototype.toJSON=function(){return{docs:this.docs,docInfo:this.docInfo,length:this.length,save:this._save}},t.stemmer=function(){var e={ational:"ate",tional:"tion",enci:"ence",anci:"ance",izer:"ize",bli:"ble",alli:"al",entli:"ent",eli:"e",ousli:"ous",ization:"ize",ation:"ate",ator:"ate",alism:"al",iveness:"ive",fulness:"ful",ousness:"ous",aliti:"al",iviti:"ive",biliti:"ble",logi:"log"},t={icate:"ic",ative:"",alize:"al",iciti:"ic",ical:"ic",ful:"",ness:""},n="[^aeiou]",i="[aeiouy]",o=n+"[^aeiouy]*",r=i+"[aeiou]*",s="^("+o+")?"+r+o,u="^("+o+")?"+r+o+"("+r+")?$",a="^("+o+")?"+r+o+r+o,l="^("+o+")?"+i,c=new RegExp(s),d=new RegExp(a),f=new RegExp(u),h=new RegExp(l),p=/^(.+?)(ss|i)es$/,v=/^(.+?)([^s])s$/,g=/^(.+?)eed$/,m=/^(.+?)(ed|ing)$/,y=/.$/,S=/(at|bl|iz)$/,x=new RegExp("([^aeiouylsz])\\1$"),w=new RegExp("^"+o+i+"[^aeiouwxy]$"),I=/^(.+?[^aeiou])y$/,b=/^(.+?)(ational|tional|enci|anci|izer|bli|alli|entli|eli|ousli|ization|ation|ator|alism|iveness|fulness|ousness|aliti|iviti|biliti|logi)$/,E=/^(.+?)(icate|ative|alize|iciti|ical|ful|ness)$/,D=/^(.+?)(al|ance|ence|er|ic|able|ible|ant|ement|ment|ent|ou|ism|ate|iti|ous|ive|ize)$/,F=/^(.+?)(s|t)(ion)$/,_=/^(.+?)e$/,P=/ll$/,k=new RegExp("^"+o+i+"[^aeiouwxy]$"),z=function(n){var i,o,r,s,u,a,l;if(n.length<3)return n;if(r=n.substr(0,1),"y"==r&&(n=r.toUpperCase()+n.substr(1)),s=p,u=v,s.test(n)?n=n.replace(s,"$1$2"):u.test(n)&&(n=n.replace(u,"$1$2")),s=g,u=m,s.test(n)){var z=s.exec(n);s=c,s.test(z[1])&&(s=y,n=n.replace(s,""))}else if(u.test(n)){var z=u.exec(n);i=z[1],u=h,u.test(i)&&(n=i,u=S,a=x,l=w,u.test(n)?n+="e":a.test(n)?(s=y,n=n.replace(s,"")):l.test(n)&&(n+="e"))}if(s=I,s.test(n)){var z=s.exec(n);i=z[1],n=i+"i"}if(s=b,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+e[o])}if(s=E,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+t[o])}if(s=D,u=F,s.test(n)){var z=s.exec(n);i=z[1],s=d,s.test(i)&&(n=i)}else if(u.test(n)){var z=u.exec(n);i=z[1]+z[2],u=d,u.test(i)&&(n=i)}if(s=_,s.test(n)){var z=s.exec(n);i=z[1],s=d,u=f,a=k,(s.test(i)||u.test(i)&&!a.test(i))&&(n=i)}return s=P,u=d,s.test(n)&&u.test(n)&&(s=y,n=n.replace(s,"")),"y"==r&&(n=r.toLowerCase()+n.substr(1)),n};return z}(),t.Pipeline.registerFunction(t.stemmer,"stemmer"),t.stopWordFilter=function(e){return e&&t.stopWordFilter.stopWords[e]!==!0?e:void 0},t.clearStopWords=function(){t.stopWordFilter.stopWords={}},t.addStopWords=function(e){null!=e&&Array.isArray(e)!==!1&&e.forEach(function(e){t.stopWordFilter.stopWords[e]=!0},this)},t.resetStopWords=function(){t.stopWordFilter.stopWords=t.defaultStopWords},t.defaultStopWords={"":!0,a:!0,able:!0,about:!0,across:!0,after:!0,all:!0,almost:!0,also:!0,am:!0,among:!0,an:!0,and:!0,any:!0,are:!0,as:!0,at:!0,be:!0,because:!0,been:!0,but:!0,by:!0,can:!0,cannot:!0,could:!0,dear:!0,did:!0,"do":!0,does:!0,either:!0,"else":!0,ever:!0,every:!0,"for":!0,from:!0,get:!0,got:!0,had:!0,has:!0,have:!0,he:!0,her:!0,hers:!0,him:!0,his:!0,how:!0,however:!0,i:!0,"if":!0,"in":!0,into:!0,is:!0,it:!0,its:!0,just:!0,least:!0,let:!0,like:!0,likely:!0,may:!0,me:!0,might:!0,most:!0,must:!0,my:!0,neither:!0,no:!0,nor:!0,not:!0,of:!0,off:!0,often:!0,on:!0,only:!0,or:!0,other:!0,our:!0,own:!0,rather:!0,said:!0,say:!0,says:!0,she:!0,should:!0,since:!0,so:!0,some:!0,than:!0,that:!0,the:!0,their:!0,them:!0,then:!0,there:!0,these:!0,they:!0,"this":!0,tis:!0,to:!0,too:!0,twas:!0,us:!0,wants:!0,was:!0,we:!0,were:!0,what:!0,when:!0,where:!0,which:!0,"while":!0,who:!0,whom:!0,why:!0,will:!0,"with":!0,would:!0,yet:!0,you:!0,your:!0},t.stopWordFilter.stopWords=t.defaultStopWords,t.Pipeline.registerFunction(t.stopWordFilter,"stopWordFilter"),t.trimmer=function(e){if(null===e||void 0===e)throw new Error("token should not be undefined");return e.replace(/^\W+/,"").replace(/\W+$/,"")},t.Pipeline.registerFunction(t.trimmer,"trimmer"),t.InvertedIndex=function(){this.root={docs:{},df:0}},t.InvertedIndex.load=function(e){var t=new this;return t.root=e.root,t},t.InvertedIndex.prototype.addToken=function(e,t,n){for(var n=n||this.root,i=0;i<=e.length-1;){var o=e[i];o in n||(n[o]={docs:{},df:0}),i+=1,n=n[o]}var r=t.ref;n.docs[r]?n.docs[r]={tf:t.tf}:(n.docs[r]={tf:t.tf},n.df+=1)},t.InvertedIndex.prototype.hasToken=function(e){if(!e)return!1;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return!1;t=t[e[n]]}return!0},t.InvertedIndex.prototype.getNode=function(e){if(!e)return null;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return null;t=t[e[n]]}return t},t.InvertedIndex.prototype.getDocs=function(e){var t=this.getNode(e);return null==t?{}:t.docs},t.InvertedIndex.prototype.getTermFrequency=function(e,t){var n=this.getNode(e);return null==n?0:t in n.docs?n.docs[t].tf:0},t.InvertedIndex.prototype.getDocFreq=function(e){var t=this.getNode(e);return null==t?0:t.df},t.InvertedIndex.prototype.removeToken=function(e,t){if(e){var n=this.getNode(e);null!=n&&t in n.docs&&(delete n.docs[t],n.df-=1)}},t.InvertedIndex.prototype.expandToken=function(e,t,n){if(null==e||""==e)return[];var t=t||[];if(void 0==n&&(n=this.getNode(e),null==n))return t;n.df>0&&t.push(e);for(var i in n)"docs"!==i&&"df"!==i&&this.expandToken(e+i,t,n[i]);return t},t.InvertedIndex.prototype.toJSON=function(){return{root:this.root}},t.Configuration=function(e,n){var e=e||"";if(void 0==n||null==n)throw new Error("fields should not be null");this.config={};var i;try{i=JSON.parse(e),this.buildUserConfig(i,n)}catch(o){t.utils.warn("user configuration parse failed, will use default configuration"),this.buildDefaultConfig(n)}},t.Configuration.prototype.buildDefaultConfig=function(e){this.reset(),e.forEach(function(e){this.config[e]={boost:1,bool:"OR",expand:!1}},this)},t.Configuration.prototype.buildUserConfig=function(e,n){var i="OR",o=!1;if(this.reset(),"bool"in e&&(i=e.bool||i),"expand"in e&&(o=e.expand||o),"fields"in e)for(var r in e.fields)if(n.indexOf(r)>-1){var s=e.fields[r],u=o;void 0!=s.expand&&(u=s.expand),this.config[r]={boost:s.boost||0===s.boost?s.boost:1,bool:s.bool||i,expand:u}}else t.utils.warn("field name in user configuration not found in index instance fields");else this.addAllFields2UserConfig(i,o,n)},t.Configuration.prototype.addAllFields2UserConfig=function(e,t,n){n.forEach(function(n){this.config[n]={boost:1,bool:e,expand:t}},this)},t.Configuration.prototype.get=function(){return this.config},t.Configuration.prototype.reset=function(){this.config={}},lunr.SortedSet=function(){this.length=0,this.elements=[]},lunr.SortedSet.load=function(e){var t=new this;return t.elements=e,t.length=e.length,t},lunr.SortedSet.prototype.add=function(){var e,t;for(e=0;e<arguments.length;e++)t=arguments[e],~this.indexOf(t)||this.elements.splice(this.locationFor(t),0,t);this.length=this.elements.length},lunr.SortedSet.prototype.toArray=function(){return this.elements.slice()},lunr.SortedSet.prototype.map=function(e,t){return this.elements.map(e,t)},lunr.SortedSet.prototype.forEach=function(e,t){return this.elements.forEach(e,t)},lunr.SortedSet.prototype.indexOf=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;){if(r===e)return o;e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o]}return r===e?o:-1},lunr.SortedSet.prototype.locationFor=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;)e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o];return r>e?o:e>r?o+1:void 0},lunr.SortedSet.prototype.intersect=function(e){for(var t=new lunr.SortedSet,n=0,i=0,o=this.length,r=e.length,s=this.elements,u=e.elements;;){if(n>o-1||i>r-1)break;s[n]!==u[i]?s[n]<u[i]?n++:s[n]>u[i]&&i++:(t.add(s[n]),n++,i++)}return t},lunr.SortedSet.prototype.clone=function(){var e=new lunr.SortedSet;return e.elements=this.toArray(),e.length=e.elements.length,e},lunr.SortedSet.prototype.union=function(e){var t,n,i;this.length>=e.length?(t=this,n=e):(t=e,n=this),i=t.clone();for(var o=0,r=n.toArray();o<r.length;o++)i.add(r[o]);return i},lunr.SortedSet.prototype.toJSON=function(){return this.toArray()},function(e,t){"function"==typeof define&&define.amd?define(t):"object"==typeof exports?module.exports=t():e.elasticlunr=t()}(this,function(){return t})}();
    /** pdoc search index */const docs = {"version": "0.9.5", "fields": ["qualname", "fullname", "annotation", "default_value", "signature", "bases", "doc"], "ref": "fullname", "documentStore": {"docs": {"auth0_jwt_validator": {"fullname": "auth0_jwt_validator", "modulename": "auth0_jwt_validator", "type": "module", "doc": "<p>Python Auth0 JWT Validator</p>\n\n<p>A JWT python package to validate tokens, scopes and permissions for Auth0 tokens.</p>\n\n<h6 id=\"examples\">Examples</h6>\n\n<p>Validating ID Token</p>\n\n<div class=\"pdoc-code codehilite\"><pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span> <span class=\"nn\">auth0_jwt_validator</span> <span class=\"kn\">import</span> <span class=\"n\">IdTokenVerifier</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">auth0_jwks_uri</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/.well-known/jwks.json&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">issuer</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">audience</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/api/v2/&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">token_verifier</span> <span class=\"o\">=</span> <span class=\"n\">IdTokenVerifier</span><span class=\"p\">(</span><span class=\"n\">auth0_jwks_uri</span><span class=\"p\">,</span> <span class=\"n\">issuer</span><span class=\"p\">,</span> <span class=\"n\">audience</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">token_verifier</span><span class=\"o\">.</span><span class=\"n\">verify</span><span class=\"p\">(</span><span class=\"s2\">&quot;some-id-token&quot;</span><span class=\"p\">)</span>\n</code></pre></div>\n\n<p>Validating ID Token and nonce</p>\n\n<div class=\"pdoc-code codehilite\"><pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span> <span class=\"nn\">auth0_jwt_validator</span> <span class=\"kn\">import</span> <span class=\"n\">IdTokenVerifier</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">auth0_jwks_uri</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/.well-known/jwks.json&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">issuer</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">audience</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/api/v2/&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">token_verifier</span> <span class=\"o\">=</span> <span class=\"n\">IdTokenVerifier</span><span class=\"p\">(</span><span class=\"n\">auth0_jwks_uri</span><span class=\"p\">,</span> <span class=\"n\">issuer</span><span class=\"p\">,</span> <span class=\"n\">audience</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">token_verifier</span><span class=\"o\">.</span><span class=\"n\">verify</span><span class=\"p\">(</span><span class=\"s2\">&quot;some-id-token&quot;</span><span class=\"p\">,</span> <span class=\"n\">nonce</span><span class=\"o\">=</span><span class=\"s2\">&quot;some-random-string&quot;</span><span class=\"p\">)</span>\n</code></pre></div>\n\n<p>Validating ID Token and max_age</p>\n\n<div class=\"pdoc-code codehilite\"><pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span> <span class=\"nn\">auth0_jwt_validator</span> <span class=\"kn\">import</span> <span class=\"n\">IdTokenVerifier</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">auth0_jwks_uri</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/.well-known/jwks.json&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">issuer</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">audience</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/api/v2/&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">token_verifier</span> <span class=\"o\">=</span> <span class=\"n\">IdTokenVerifier</span><span class=\"p\">(</span><span class=\"n\">auth0_jwks_uri</span><span class=\"p\">,</span> <span class=\"n\">issuer</span><span class=\"p\">,</span> <span class=\"n\">audience</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">token_verifier</span><span class=\"o\">.</span><span class=\"n\">verify</span><span class=\"p\">(</span><span class=\"s2\">&quot;some-id-token&quot;</span><span class=\"p\">,</span> <span class=\"n\">max_age</span><span class=\"o\">=</span><span class=\"mi\">60</span> <span class=\"o\">*</span> <span class=\"mi\">60</span> <span class=\"o\">*</span> <span class=\"mi\">24</span><span class=\"p\">)</span>\n</code></pre></div>\n\n<p>Validating ID Token and organization</p>\n\n<div class=\"pdoc-code codehilite\"><pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span> <span class=\"nn\">auth0_jwt_validator</span> <span class=\"kn\">import</span> <span class=\"n\">IdTokenVerifier</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">auth0_jwks_uri</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/.well-known/jwks.json&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">issuer</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">audience</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/api/v2/&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">token_verifier</span> <span class=\"o\">=</span> <span class=\"n\">IdTokenVerifier</span><span class=\"p\">(</span><span class=\"n\">auth0_jwks_uri</span><span class=\"p\">,</span> <span class=\"n\">issuer</span><span class=\"p\">,</span> <span class=\"n\">audience</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">token_verifier</span><span class=\"o\">.</span><span class=\"n\">verify</span><span class=\"p\">(</span><span class=\"s2\">&quot;some-id-token&quot;</span><span class=\"p\">,</span> <span class=\"n\">organization</span><span class=\"o\">=</span><span class=\"s2\">&quot;some-organization&quot;</span><span class=\"p\">)</span>\n</code></pre></div>\n\n<p>Validating Access Token</p>\n\n<div class=\"pdoc-code codehilite\"><pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span> <span class=\"nn\">auth0_jwt_validator</span> <span class=\"kn\">import</span> <span class=\"n\">AccessTokenVerifier</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">auth0_jwks_uri</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/.well-known/jwks.json&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">issuer</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">audience</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/api/v2/&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">token_verifier</span> <span class=\"o\">=</span> <span class=\"n\">AccessTokenVerifier</span><span class=\"p\">(</span><span class=\"n\">auth0_jwks_uri</span><span class=\"p\">,</span> <span class=\"n\">issuer</span><span class=\"p\">,</span> <span class=\"n\">audience</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">token_verifier</span><span class=\"o\">.</span><span class=\"n\">verify</span><span class=\"p\">(</span><span class=\"s2\">&quot;some-access-token&quot;</span><span class=\"p\">)</span>\n</code></pre></div>\n\n<p>Validating Access Token and organization</p>\n\n<div class=\"pdoc-code codehilite\"><pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span> <span class=\"nn\">auth0_jwt_validator</span> <span class=\"kn\">import</span> <span class=\"n\">AccessTokenVerifier</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">auth0_jwks_uri</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/.well-known/jwks.json&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">issuer</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">audience</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/api/v2/&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">token_verifier</span> <span class=\"o\">=</span> <span class=\"n\">AccessTokenVerifier</span><span class=\"p\">(</span><span class=\"n\">auth0_jwks_uri</span><span class=\"p\">,</span> <span class=\"n\">issuer</span><span class=\"p\">,</span> <span class=\"n\">audience</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">token_verifier</span><span class=\"o\">.</span><span class=\"n\">verify</span><span class=\"p\">(</span><span class=\"s2\">&quot;some-access-token&quot;</span><span class=\"p\">,</span> <span class=\"n\">organization</span><span class=\"o\">=</span><span class=\"s2\">&quot;some-organization&quot;</span><span class=\"p\">)</span>\n</code></pre></div>\n\n<p>Validating Access Token and scopes</p>\n\n<div class=\"pdoc-code codehilite\"><pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span> <span class=\"nn\">auth0_jwt_validator</span> <span class=\"kn\">import</span> <span class=\"n\">AccessTokenVerifier</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">auth0_jwks_uri</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/.well-known/jwks.json&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">issuer</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">audience</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/api/v2/&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">token_verifier</span> <span class=\"o\">=</span> <span class=\"n\">AccessTokenVerifier</span><span class=\"p\">(</span><span class=\"n\">auth0_jwks_uri</span><span class=\"p\">,</span> <span class=\"n\">issuer</span><span class=\"p\">,</span> <span class=\"n\">audience</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">token_verifier</span><span class=\"o\">.</span><span class=\"n\">verify</span><span class=\"p\">(</span><span class=\"s2\">&quot;some-access-token&quot;</span><span class=\"p\">,</span> <span class=\"n\">required_scopes</span><span class=\"o\">=</span><span class=\"p\">[</span><span class=\"s2\">&quot;profile&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;calendar&quot;</span><span class=\"p\">])</span>\n</code></pre></div>\n\n<p>Validating Access Token and permissions</p>\n\n<div class=\"pdoc-code codehilite\"><pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span> <span class=\"nn\">auth0_jwt_validator</span> <span class=\"kn\">import</span> <span class=\"n\">AccessTokenVerifier</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">auth0_jwks_uri</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/.well-known/jwks.json&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">issuer</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">audience</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/api/v2/&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">token_verifier</span> <span class=\"o\">=</span> <span class=\"n\">AccessTokenVerifier</span><span class=\"p\">(</span><span class=\"n\">auth0_jwks_uri</span><span class=\"p\">,</span> <span class=\"n\">issuer</span><span class=\"p\">,</span> <span class=\"n\">audience</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">token_verifier</span><span class=\"o\">.</span><span class=\"n\">verify</span><span class=\"p\">(</span><span class=\"s2\">&quot;some-access-token&quot;</span><span class=\"p\">,</span> <span class=\"n\">required_permissions</span><span class=\"o\">=</span><span class=\"p\">[</span><span class=\"s2\">&quot;read:user&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;delete:user&quot;</span><span class=\"p\">])</span>\n</code></pre></div>\n"}, "auth0_jwt_validator.http_bearer": {"fullname": "auth0_jwt_validator.http_bearer", "modulename": "auth0_jwt_validator.http_bearer", "type": "module", "doc": "<p></p>\n"}, "auth0_jwt_validator.http_bearer.get_token": {"fullname": "auth0_jwt_validator.http_bearer.get_token", "modulename": "auth0_jwt_validator.http_bearer", "qualname": "get_token", "type": "function", "doc": "<p>Get a token from a authorization header with a bearer authentication schema.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>authorization_header</strong> (str):\nThe authorization header which one we want to get the bearer token.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>token</strong> (str or None):\nThe bearer token is <code>None</code> only when the authorization header mismatch\nthe bearer authentication schema for bearer tokens.</li>\n</ul>\n\n<h6 id=\"examples\">Examples</h6>\n\n<div class=\"pdoc-code codehilite\"><pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span> <span class=\"nn\">auth0_jwt_validator</span> <span class=\"kn\">import</span> <span class=\"n\">get_token</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">auth_header</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;Bearer super-secret-token&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">get_token</span><span class=\"p\">(</span><span class=\"n\">auth_header</span><span class=\"p\">)</span>\n<span class=\"go\">&quot;super-secret-token&quot;</span>\n</code></pre></div>\n\n<div class=\"pdoc-code codehilite\"><pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span> <span class=\"nn\">auth0_jwt_validator</span> <span class=\"kn\">import</span> <span class=\"n\">get_token</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">auth_header</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">get_token</span><span class=\"p\">(</span><span class=\"n\">auth_header</span><span class=\"p\">)</span>\n<span class=\"go\">None</span>\n</code></pre></div>\n\n<div class=\"pdoc-code codehilite\"><pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span> <span class=\"nn\">auth0_jwt_validator</span> <span class=\"kn\">import</span> <span class=\"n\">get_token</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">auth_header</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;Token super-secret-token&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">get_token</span><span class=\"p\">(</span><span class=\"n\">auth_header</span><span class=\"p\">)</span>\n<span class=\"go\">None</span>\n</code></pre></div>\n\n<div class=\"pdoc-code codehilite\"><pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span> <span class=\"nn\">auth0_jwt_validator</span> <span class=\"kn\">import</span> <span class=\"n\">get_token</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">auth_header</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;Bearer super-secret-token extra-secret-token&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">get_token</span><span class=\"p\">(</span><span class=\"n\">auth_header</span><span class=\"p\">)</span>\n<span class=\"go\">None</span>\n</code></pre></div>\n\n<div class=\"pdoc-code codehilite\"><pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span> <span class=\"nn\">auth0_jwt_validator</span> <span class=\"kn\">import</span> <span class=\"n\">get_token</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">auth_header</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;Bearer &quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">get_token</span><span class=\"p\">(</span><span class=\"n\">auth_header</span><span class=\"p\">)</span>\n<span class=\"go\">None</span>\n</code></pre></div>\n", "signature": "(authorization_header: str) -> Optional[str]", "funcdef": "def"}, "auth0_jwt_validator.jwt_verifier": {"fullname": "auth0_jwt_validator.jwt_verifier", "modulename": "auth0_jwt_validator.jwt_verifier", "type": "module", "doc": "<p></p>\n"}, "auth0_jwt_validator.jwt_verifier.JwtVerifier": {"fullname": "auth0_jwt_validator.jwt_verifier.JwtVerifier", "modulename": "auth0_jwt_validator.jwt_verifier", "qualname": "JwtVerifier", "type": "class", "doc": "<h6 id=\"attributes\">Attributes</h6>\n\n<ul>\n<li><strong>jwks_uri</strong> (str):\nThe JSON Web Key Set URI where the public keys are located.</li>\n<li><strong>issuer</strong> (str):\nThe client that issued the JWT.</li>\n<li><strong>audience</strong> (str):\nThe recipient that the JWT is intended for.</li>\n</ul>\n\n<h6 id=\"methods\">Methods</h6>\n\n<p>get_token_type()\n    Return the token type used by the verify methods. This method raise an\n    error because this method should be implemented in the  sub-class.</p>\n\n<p>verify(auth0_token)\n    Return the payload from an access token or ID token</p>\n\n<p>get_auth0_signing_keys(jwks_uri)\n    Return the signing keys from a given JSON Web Key Set URI.</p>\n\n<p>verify_payload(<em>args, *</em>kwargs)\n    This method raise an error because this method should be implemented in\n    the sub-class.</p>\n\n<h6 id=\"examples\">Examples</h6>\n\n<p>Custom Token Verifier</p>\n\n<div class=\"pdoc-code codehilite\"><pre><span></span><code><span class=\"k\">class</span> <span class=\"nc\">CustomTokenVerifier</span><span class=\"p\">(</span><span class=\"n\">JwtVerifier</span><span class=\"p\">):</span>\n    <span class=\"k\">def</span> <span class=\"nf\">get_token_type</span><span class=\"p\">():</span>\n        <span class=\"k\">return</span> <span class=\"s2\">&quot;custom token&quot;</span>\n\n    <span class=\"k\">def</span> <span class=\"nf\">verify</span><span class=\"p\">(</span><span class=\"bp\">self</span><span class=\"p\">,</span> <span class=\"n\">auth0_token</span><span class=\"p\">:</span> <span class=\"nb\">str</span><span class=\"p\">)</span> <span class=\"o\">-&gt;</span> <span class=\"nb\">dict</span><span class=\"p\">:</span>\n        <span class=\"n\">payload</span><span class=\"p\">:</span> <span class=\"nb\">dict</span> <span class=\"o\">=</span> <span class=\"nb\">super</span><span class=\"p\">()</span><span class=\"o\">.</span><span class=\"n\">verify</span><span class=\"p\">(</span><span class=\"n\">auth0_token</span><span class=\"p\">)</span>\n        <span class=\"k\">return</span> <span class=\"n\">payload</span>\n\n    <span class=\"k\">def</span> <span class=\"nf\">verify_payload</span><span class=\"p\">(</span><span class=\"bp\">self</span><span class=\"p\">,</span> <span class=\"n\">payload</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">)</span> <span class=\"o\">-&gt;</span> <span class=\"kc\">None</span><span class=\"p\">:</span>\n        <span class=\"c1\"># validate just the issuer</span>\n        <span class=\"bp\">self</span><span class=\"o\">.</span><span class=\"n\">verify_issuer</span><span class=\"p\">(</span><span class=\"n\">payload</span><span class=\"p\">)</span>        \n</code></pre></div>\n"}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__": {"fullname": "auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__", "modulename": "auth0_jwt_validator.jwt_verifier", "qualname": "JwtVerifier.__init__", "type": "function", "doc": "<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>jwks_uri</strong> (str):\nThe JSON Web Key Set URI where the public keys are located.</li>\n<li><strong>issuer</strong> (str):\nThe client that issued the JWT.</li>\n<li><strong>audience</strong> (str):\nThe recipient that the JWT is intended for.</li>\n</ul>\n", "signature": "(self, jwks_uri: str, issuer: str, audience: str, /, leeway: int = 0)", "funcdef": "def"}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_token_type": {"fullname": "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_token_type", "modulename": "auth0_jwt_validator.jwt_verifier", "qualname": "JwtVerifier.get_token_type", "type": "function", "doc": "<h6 id=\"raises\">Raises</h6>\n\n<ul>\n<li><strong>NotImplementedError</strong>: Raise an error because this method should be implemented in a\nsub-class.</li>\n</ul>\n", "signature": "(self) -> None", "funcdef": "def"}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_auth0_signing_keys": {"fullname": "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_auth0_signing_keys", "modulename": "auth0_jwt_validator.jwt_verifier", "qualname": "JwtVerifier.get_auth0_signing_keys", "type": "function", "doc": "<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>jwks_uri</strong> (str):\nThe JSON Web Key Set URI where the public keys are located.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>auth0_signing_keys</strong> (str):\nReturn the auth0 public keys as JSON.</li>\n</ul>\n", "signature": "(self, jwks_uri: str) -> str", "funcdef": "def"}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify": {"fullname": "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify", "modulename": "auth0_jwt_validator.jwt_verifier", "qualname": "JwtVerifier.verify", "type": "function", "doc": "<p></p>\n", "signature": "(self, auth0_token: str) -> dict", "funcdef": "def"}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_payload": {"fullname": "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_payload", "modulename": "auth0_jwt_validator.jwt_verifier", "qualname": "JwtVerifier.verify_payload", "type": "function", "doc": "<h6 id=\"raises\">Raises</h6>\n\n<ul>\n<li><strong>NotImplementedError</strong>: Raise an error because this method should be implemented in a\nsub-class.</li>\n</ul>\n", "signature": "(self, *args, **kwargs) -> None", "funcdef": "def"}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"fullname": "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer", "modulename": "auth0_jwt_validator.jwt_verifier", "qualname": "JwtVerifier.verify_issuer", "type": "function", "doc": "<p>Verify the issuer</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>payload</strong> (dict):\nThe payload which contains the claims. Claims are statements about\nan entity (typically, the user) and additional data.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>None</strong></li>\n</ul>\n\n<h6 id=\"raises\">Raises</h6>\n\n<ul>\n<li><strong>MissingClaimError</strong>: If some field in the claim (payload) is missing this error is\nraised.</li>\n<li><strong>InvalidClaimError</strong>: If some field in the claim (payload) doesn't match what's expected\nthis error is raised.</li>\n</ul>\n", "signature": "(self, payload: <function TypedDict>) -> None", "funcdef": "def"}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"fullname": "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject", "modulename": "auth0_jwt_validator.jwt_verifier", "qualname": "JwtVerifier.verify_subject", "type": "function", "doc": "<p>Verify the subject</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>payload</strong> (dict):\nThe payload which contains the claims. Claims are statements about\nan entity (typically, the user) and additional data.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>None</strong></li>\n</ul>\n\n<h6 id=\"raises\">Raises</h6>\n\n<ul>\n<li><strong>MissingClaimError</strong>: If some field in the claim (payload) is missing this error is\nraised.</li>\n<li><strong>InvalidClaimError</strong>: If some field in the claim (payload) doesn't match what's expected\nthis error is raised.</li>\n</ul>\n", "signature": "(self, payload: <function TypedDict>) -> None", "funcdef": "def"}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"fullname": "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience", "modulename": "auth0_jwt_validator.jwt_verifier", "qualname": "JwtVerifier.verify_audience", "type": "function", "doc": "<p>Verify the audience</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>payload</strong> (dict):\nThe payload which contains the claims. Claims are statements about\nan entity (typically, the user) and additional data.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>None</strong></li>\n</ul>\n\n<h6 id=\"raises\">Raises</h6>\n\n<ul>\n<li><strong>MissingClaimError</strong>: If some field in the claim (payload) is missing this error is\nraised.</li>\n<li><strong>InvalidClaimError</strong>: If some field in the claim (payload) doesn't match what's expected\nthis error is raised.</li>\n</ul>\n", "signature": "(self, payload: <function TypedDict>) -> None", "funcdef": "def"}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"fullname": "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time", "modulename": "auth0_jwt_validator.jwt_verifier", "qualname": "JwtVerifier.verify_expiration_time", "type": "function", "doc": "<p>Verify the expiration time</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>payload</strong> (dict):\nThe payload which contains the claims. Claims are statements about\nan entity (typically, the user) and additional data.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>None</strong></li>\n</ul>\n\n<h6 id=\"raises\">Raises</h6>\n\n<ul>\n<li><strong>MissingClaimError</strong>: If some field in the claim (payload) is missing this error is\nraised.</li>\n<li><strong>InvalidClaimError</strong>: If some field in the claim (payload) doesn't match what's expected\nthis error is raised.</li>\n</ul>\n", "signature": "(self, payload: <function TypedDict>) -> None", "funcdef": "def"}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"fullname": "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time", "modulename": "auth0_jwt_validator.jwt_verifier", "qualname": "JwtVerifier.verify_issued_at_time", "type": "function", "doc": "<p>Verify the issued at time</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>payload</strong> (dict):\nThe payload which contains the claims. Claims are statements about\nan entity (typically, the user) and additional data.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>None</strong></li>\n</ul>\n\n<h6 id=\"raises\">Raises</h6>\n\n<ul>\n<li><strong>MissingClaimError</strong>: If some field in the claim (payload) is missing this error is\nraised.</li>\n<li><strong>InvalidClaimError</strong>: If some field in the claim (payload) doesn't match what's expected\nthis error is raised.</li>\n</ul>\n", "signature": "(self, payload: <function TypedDict>) -> None", "funcdef": "def"}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"fullname": "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp", "modulename": "auth0_jwt_validator.jwt_verifier", "qualname": "JwtVerifier.verify_azp", "type": "function", "doc": "<p>Verify the authorized party</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>payload</strong> (dict):\nThe payload which contains the claims. Claims are statements about\nan entity (typically, the user) and additional data.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>None</strong></li>\n</ul>\n\n<h6 id=\"raises\">Raises</h6>\n\n<ul>\n<li><strong>MissingClaimError</strong>: If some field in the claim (payload) is missing this error is\nraised.</li>\n<li><strong>InvalidClaimError</strong>: If some field in the claim (payload) doesn't match what's expected\nthis error is raised.</li>\n</ul>\n", "signature": "(self, payload: <function TypedDict>) -> None", "funcdef": "def"}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"fullname": "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id", "modulename": "auth0_jwt_validator.jwt_verifier", "qualname": "JwtVerifier.verify_org_id", "type": "function", "doc": "<p>Verify the organization id</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>payload</strong> (dict):\nThe payload which contains the claims. Claims are statements about\nan entity (typically, the user) and additional data.</li>\n<li><strong>organization</strong> (str):\nThe organization that issued the token.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>None</strong></li>\n</ul>\n\n<h6 id=\"raises\">Raises</h6>\n\n<ul>\n<li><strong>MissingClaimError</strong>: If some field in the claim (payload) is missing this error is\nraised.</li>\n<li><strong>InvalidClaimError</strong>: If some field in the claim (payload) doesn't match what's expected\nthis error is raised.</li>\n</ul>\n", "signature": "(self, payload: <function TypedDict>, organization: str) -> None", "funcdef": "def"}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"fullname": "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce", "modulename": "auth0_jwt_validator.jwt_verifier", "qualname": "JwtVerifier.verify_nonce", "type": "function", "doc": "<p>Verify the nonce</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>payload</strong> (dict):\nThe payload which contains the claims. Claims are statements about\nan entity (typically, the user) and additional data.</li>\n<li><strong>nonce</strong> (str):\nThe valued associated to the Client session and the ID token.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>None</strong></li>\n</ul>\n\n<h6 id=\"raises\">Raises</h6>\n\n<ul>\n<li><strong>MissingClaimError</strong>: If some field in the claim (payload) is missing this error is\nraised.</li>\n<li><strong>InvalidClaimError</strong>: If some field in the claim (payload) doesn't match what's expected\nthis error is raised.</li>\n</ul>\n", "signature": "(self, payload: <function TypedDict>, nonce: str)", "funcdef": "def"}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"fullname": "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time", "modulename": "auth0_jwt_validator.jwt_verifier", "qualname": "JwtVerifier.verify_auth_time", "type": "function", "doc": "<p>Verify the authentication time</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>payload</strong> (dict):\nThe payload which contains the claims. Claims are statements about\nan entity (typically, the user) and additional data.</li>\n<li><strong>max_age</strong> (int):\nThe max_age help us to customize when a token should expire.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>None</strong></li>\n</ul>\n\n<h6 id=\"raises\">Raises</h6>\n\n<ul>\n<li><strong>MissingClaimError</strong>: If some field in the claim (payload) is missing this error is\nraised.</li>\n<li><strong>InvalidClaimError</strong>: If some field in the claim (payload) doesn't match what's expected\nthis error is raised.</li>\n</ul>\n", "signature": "(self, payload: <function TypedDict>, max_age: int)", "funcdef": "def"}, "auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"fullname": "auth0_jwt_validator.jwt_verifier.IdTokenPayload", "modulename": "auth0_jwt_validator.jwt_verifier", "qualname": "IdTokenPayload", "type": "class", "doc": "<h6 id=\"attributes\">Attributes</h6>\n\n<ul>\n<li><strong>iss</strong> (str):\nThe \"iss\" (issuer) claim identifies the principal that issued the JWT.\n<a href=\"https://datatracker.ietf.org/doc/html/rfc7519#section-4.1.1\">Read more</a>.</li>\n<li><strong>sub</strong> (str):\nThe \"sub\" (subject) claim identifies the principal that is the subject\nof the JWT. <a href=\"https://datatracker.ietf.org/doc/html/rfc7519#section-4.1.2\">Read more</a>.</li>\n<li><strong>aud</strong> (str, list of str):\nThe \"aud\" (audience) claim identifies the recipients that the JWT is\nintended for. <a href=\"https://datatracker.ietf.org/doc/html/rfc7519#section-4.1.3\">Read more</a>.</li>\n<li><strong>exp</strong> (int):\nThe \"exp\" (expiration time) claim identifies the expiration time on or\nafter which the JWT MUST NOT be accepted for processing. <a href=\"https://datatracker.ietf.org/doc/html/rfc7519#section-4.1.4\">Read more</a>.</li>\n<li><strong>iat</strong> (int):\nThe \"iat\" (issued at) claim identifies the time at which the JWT was\nissued. <a href=\"https://datatracker.ietf.org/doc/html/rfc7519#section-4.1.6\">Read more</a>.</li>\n<li><strong>name</strong> (str):\nThe \"name\" claim identifies the full name. <a href=\"https://www.iana.org/assignments/jwt/jwt.xhtml\">Read more</a>.</li>\n<li><strong>given_name</strong> (str):\nThe \"given_name\" claim identifies the given name(s) or first name(s). <a href=\"https://www.iana.org/assignments/jwt/jwt.xhtml\">Read more</a>.</li>\n<li><strong>family_name</strong> (str):\nThe \"family_name\" claim identifies the surname(s) or last name(s). <a href=\"https://www.iana.org/assignments/jwt/jwt.xhtml\">Read more</a>.</li>\n<li><strong>gender</strong> (str, {'male', 'female'}):\nThe \"gender\" claim identifies the gender. <a href=\"https://www.iana.org/assignments/jwt/jwt.xhtml\">Read more</a>.</li>\n<li><strong>birthdate</strong> (str):\nThe \"birthdate\" claim identifies the birthday. <a href=\"https://www.iana.org/assignments/jwt/jwt.xhtml\">Read more</a>.</li>\n<li><strong>email</strong> (str):\nThe \"email\" claim identifies the preferred e-mail address. <a href=\"https://www.iana.org/assignments/jwt/jwt.xhtml\">Read more</a>.</li>\n<li><strong>picture</strong> (str):\nThe \"picture\" claim identifies the profile picture URL. <a href=\"https://www.iana.org/assignments/jwt/jwt.xhtml\">Read more</a>.</li>\n<li><strong>nonce</strong> (str, optional):\nThe \"nonce\" claim identifies the valued used to associate a Client\nsession with an ID Token, and to mitigate replay attacks. <a href=\"https://www.iana.org/assignments/jwt/jwt.xhtml\">Read more</a>.</li>\n<li><strong>auth_time</strong> (int, optional):\nThe \"auth_time\" (authentication time) claim identifies the time when the\nEnd-User authentication occurred. <a href=\"https://www.iana.org/assignments/jwt/jwt.xhtml\">Read more</a>.</li>\n</ul>\n", "bases": "typing.TypedDict"}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"fullname": "auth0_jwt_validator.jwt_verifier.IdTokenVerifier", "modulename": "auth0_jwt_validator.jwt_verifier", "qualname": "IdTokenVerifier", "type": "class", "doc": "<h6 id=\"attributes\">Attributes</h6>\n\n<ul>\n<li><strong>jwks_uri</strong> (str):\nThe JSON Web Key Set URI where the public keys are located.</li>\n<li><strong>issuer</strong> (str):\nThe client that issued the JWT.</li>\n<li><strong>audience</strong> (str):\nThe recipient that the JWT is intended for.</li>\n</ul>\n\n<h6 id=\"methods\">Methods</h6>\n\n<p>get_token_type()\n    Return the token type used by the verify methods.</p>\n\n<p>get_auth0_signing_keys(jwks_uri)\n    Return the public keys located under the given JSON Web Key Set URI.</p>\n\n<p>verify(auth_token[, nonce, max_age, organization])\n    Return the payload or raise an error when on of the verifications fails.</p>\n\n<p>verify_payload(payload[, nonce, max_age, organization])\n    Raise an error when one of the verification fails.</p>\n\n<h6 id=\"examples\">Examples</h6>\n\n<p>Validating ID Token</p>\n\n<div class=\"pdoc-code codehilite\"><pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span> <span class=\"nn\">auth0_jwt_validator</span> <span class=\"kn\">import</span> <span class=\"n\">IdTokenVerifier</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">auth0_jwks_uri</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/.well-known/jwks.json&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">issuer</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">audience</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/api/v2/&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">token_verifier</span> <span class=\"o\">=</span> <span class=\"n\">IdTokenVerifier</span><span class=\"p\">(</span><span class=\"n\">auth0_jwks_uri</span><span class=\"p\">,</span> <span class=\"n\">issuer</span><span class=\"p\">,</span> <span class=\"n\">audience</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">token_verifier</span><span class=\"o\">.</span><span class=\"n\">verify</span><span class=\"p\">(</span><span class=\"s2\">&quot;some-id-token&quot;</span><span class=\"p\">)</span>\n</code></pre></div>\n\n<p>Validating ID Token and nonce</p>\n\n<div class=\"pdoc-code codehilite\"><pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span> <span class=\"nn\">auth0_jwt_validator</span> <span class=\"kn\">import</span> <span class=\"n\">IdTokenVerifier</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">auth0_jwks_uri</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/.well-known/jwks.json&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">issuer</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">audience</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/api/v2/&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">token_verifier</span> <span class=\"o\">=</span> <span class=\"n\">IdTokenVerifier</span><span class=\"p\">(</span><span class=\"n\">auth0_jwks_uri</span><span class=\"p\">,</span> <span class=\"n\">issuer</span><span class=\"p\">,</span> <span class=\"n\">audience</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">token_verifier</span><span class=\"o\">.</span><span class=\"n\">verify</span><span class=\"p\">(</span><span class=\"s2\">&quot;some-id-token&quot;</span><span class=\"p\">,</span> <span class=\"n\">nonce</span><span class=\"o\">=</span><span class=\"s2\">&quot;some-random-string&quot;</span><span class=\"p\">)</span>\n</code></pre></div>\n\n<p>Validating ID Token and max_age</p>\n\n<div class=\"pdoc-code codehilite\"><pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span> <span class=\"nn\">auth0_jwt_validator</span> <span class=\"kn\">import</span> <span class=\"n\">IdTokenVerifier</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">auth0_jwks_uri</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/.well-known/jwks.json&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">issuer</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">audience</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/api/v2/&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">token_verifier</span> <span class=\"o\">=</span> <span class=\"n\">IdTokenVerifier</span><span class=\"p\">(</span><span class=\"n\">auth0_jwks_uri</span><span class=\"p\">,</span> <span class=\"n\">issuer</span><span class=\"p\">,</span> <span class=\"n\">audience</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">token_verifier</span><span class=\"o\">.</span><span class=\"n\">verify</span><span class=\"p\">(</span><span class=\"s2\">&quot;some-id-token&quot;</span><span class=\"p\">,</span> <span class=\"n\">max_age</span><span class=\"o\">=</span><span class=\"mi\">60</span> <span class=\"o\">*</span> <span class=\"mi\">60</span> <span class=\"o\">*</span> <span class=\"mi\">24</span><span class=\"p\">)</span>\n</code></pre></div>\n\n<p>Validating ID Token and organization</p>\n\n<div class=\"pdoc-code codehilite\"><pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span> <span class=\"nn\">auth0_jwt_validator</span> <span class=\"kn\">import</span> <span class=\"n\">IdTokenVerifier</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">auth0_jwks_uri</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/.well-known/jwks.json&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">issuer</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">audience</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/api/v2/&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">token_verifier</span> <span class=\"o\">=</span> <span class=\"n\">IdTokenVerifier</span><span class=\"p\">(</span><span class=\"n\">auth0_jwks_uri</span><span class=\"p\">,</span> <span class=\"n\">issuer</span><span class=\"p\">,</span> <span class=\"n\">audience</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">token_verifier</span><span class=\"o\">.</span><span class=\"n\">verify</span><span class=\"p\">(</span><span class=\"s2\">&quot;some-id-token&quot;</span><span class=\"p\">,</span> <span class=\"n\">organization</span><span class=\"o\">=</span><span class=\"s2\">&quot;some-organization&quot;</span><span class=\"p\">)</span>\n</code></pre></div>\n", "bases": "JwtVerifier"}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.get_token_type": {"fullname": "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.get_token_type", "modulename": "auth0_jwt_validator.jwt_verifier", "qualname": "IdTokenVerifier.get_token_type", "type": "function", "doc": "<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>token_type</strong> (str):\nReturn the token type (ID token or access token) used by the verify\nmethods.</li>\n</ul>\n", "signature": "(self) -> str", "funcdef": "def"}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"fullname": "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify", "modulename": "auth0_jwt_validator.jwt_verifier", "qualname": "IdTokenVerifier.verify", "type": "function", "doc": "<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>auth0_token</strong> (str):\nThe ID token.</li>\n</ul>\n\n<h6 id=\"other-parameters\">Other Parameters</h6>\n\n<ul>\n<li><strong>nonce</strong> (str, default None):\nLorem.</li>\n<li><strong>max_age</strong> (int, default None):\nLorem.</li>\n<li><strong>organization</strong> (str, default None):\nThe organization that issued the token.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>payload</strong> (<code>IdTokenPayload</code>):\nThe payload which contains the claims. Claims are statements about\nan entity (typically, the user) and additional data.</li>\n</ul>\n\n<h6 id=\"raises\">Raises</h6>\n\n<ul>\n<li><strong>MissingClaimError</strong>: If some field in the claim (payload) is missing this error is\nraised.</li>\n<li><strong>InvalidClaimError</strong>: If some field in the claim (payload) doesn't match what's expected\nthis error is raised.</li>\n</ul>\n\n<h6 id=\"see-also\">See Also</h6>\n\n<p><code>IdTokenPayload</code>  </p>\n", "signature": "(\n    self,\n    auth0_token: str,\n    /,\n    nonce: Optional[str] = None,\n    max_age: Optional[int] = None,\n    organization: Optional[str] = None\n) -> auth0_jwt_validator.jwt_verifier.IdTokenPayload", "funcdef": "def"}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"fullname": "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload", "modulename": "auth0_jwt_validator.jwt_verifier", "qualname": "IdTokenVerifier.verify_payload", "type": "function", "doc": "<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>payload</strong> (<code>IdTokenPayload</code>):\nThe payload which contains the claims. Claims are statements about\nan entity (typically, the user) and additional data.</li>\n</ul>\n\n<h6 id=\"other-parameters\">Other Parameters</h6>\n\n<ul>\n<li><strong>nonce</strong> (str, default None):\nLorem.</li>\n<li><strong>max_age</strong> (int, default None):\nLorem.</li>\n<li><strong>organization</strong> (str, default None):\nThe organization that issued the token.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>None</strong></li>\n</ul>\n\n<h6 id=\"raises\">Raises</h6>\n\n<ul>\n<li><strong>MissingClaimError</strong>: If some field in the claim (payload) is missing this error is\nraised.</li>\n<li><strong>InvalidClaimError</strong>: If some field in the claim (payload) doesn't match what's expected\nthis error is raised.</li>\n</ul>\n\n<h6 id=\"see-also\">See Also</h6>\n\n<p><code>IdTokenPayload</code>  </p>\n", "signature": "(\n    self,\n    payload: auth0_jwt_validator.jwt_verifier.IdTokenPayload,\n    /,\n    nonce: Optional[str] = None,\n    max_age: Optional[int] = None,\n    organization: Optional[str] = None\n) -> None", "funcdef": "def"}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"fullname": "auth0_jwt_validator.jwt_verifier.AccessTokenPayload", "modulename": "auth0_jwt_validator.jwt_verifier", "qualname": "AccessTokenPayload", "type": "class", "doc": "<h6 id=\"attributes\">Attributes</h6>\n\n<ul>\n<li><strong>iss</strong> (str):\nThe \"iss\" (issuer) claim identifies the principal that issued the JWT.\n<a href=\"https://datatracker.ietf.org/doc/html/rfc7519#section-4.1.1\">Read more</a>.</li>\n<li><strong>sub</strong> (str):\nThe \"sub\" (subject) claim identifies the principal that is the subject\nof the JWT. <a href=\"https://datatracker.ietf.org/doc/html/rfc7519#section-4.1.2\">Read more</a>.</li>\n<li><strong>aud</strong> (str, list of str):\nThe \"aud\" (audience) claim identifies the recipients that the JWT is\nintended for. <a href=\"https://datatracker.ietf.org/doc/html/rfc7519#section-4.1.3\">Read more</a>.</li>\n<li><strong>azp</strong> (str):\nThe \"azp\" (authorized party) claim identifies the party to which the ID\nToken was issued. <a href=\"https://www.iana.org/assignments/jwt/jwt.xhtml\">Read more</a>.</li>\n<li><strong>exp</strong> (int):\nThe \"exp\" (expiration time) claim identifies the expiration time on or\nafter which the JWT MUST NOT be accepted for processing. <a href=\"https://datatracker.ietf.org/doc/html/rfc7519#section-4.1.4\">Read more</a>.</li>\n<li><strong>iat</strong> (int):\nThe \"iat\" (issued at) claim identifies the time at which the JWT was\nissued. <a href=\"https://datatracker.ietf.org/doc/html/rfc7519#section-4.1.6\">Read more</a>.</li>\n<li><strong>scope</strong> (str):\nThe \"scope\" claim identifies the space-separated list of scopes\nassociated with the token. <a href=\"https://www.iana.org/assignments/jwt/jwt.xhtml\">Read more</a>.</li>\n<li><strong>gty</strong> (str):\nThe \"gty\" (grant type) claim identifies the grant type used to create\nthe token.</li>\n<li><strong>permissions</strong> (list of str, optional):\nThe \"permissions\" claim identifies the list of permissions associated to\nthe current user.</li>\n<li><strong>org_id</strong> (str, optional):\nThe \"org_id\" (organization id) claim identifies the organization under\nwhich the JWT was issued.</li>\n</ul>\n", "bases": "typing.TypedDict"}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"fullname": "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier", "modulename": "auth0_jwt_validator.jwt_verifier", "qualname": "AccessTokenVerifier", "type": "class", "doc": "<h6 id=\"attributes\">Attributes</h6>\n\n<ul>\n<li><strong>jwks_uri</strong> (str):\nThe JSON Web Key Set URI where the public keys are located.</li>\n<li><strong>issuer</strong> (str):\nThe client that issued the JWT.</li>\n<li><strong>audience</strong> (str):\nThe recipient that the JWT is intended for.</li>\n</ul>\n\n<h6 id=\"methods\">Methods</h6>\n\n<p>get_token_type()\n    Return the token type used by the verify methods.</p>\n\n<p>get_auth0_signing_keys(jwks_uri)\n    Return the public keys located under the given JSON Web Key Set URI.</p>\n\n<p>verify(auth_token[,organization, required_scopes, required_permissions])\n    Return the payload or raise an error.</p>\n\n<p>verify_payload(payload[,organization, required_scopes, required_permissions])\n    Raise an error when one of the verification fails.</p>\n\n<h6 id=\"examples\">Examples</h6>\n\n<p>Validating Access Token</p>\n\n<div class=\"pdoc-code codehilite\"><pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span> <span class=\"nn\">auth0_jwt_validator</span> <span class=\"kn\">import</span> <span class=\"n\">AccessTokenVerifier</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">auth0_jwks_uri</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/.well-known/jwks.json&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">issuer</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">audience</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/api/v2/&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">token_verifier</span> <span class=\"o\">=</span> <span class=\"n\">AccessTokenVerifier</span><span class=\"p\">(</span><span class=\"n\">auth0_jwks_uri</span><span class=\"p\">,</span> <span class=\"n\">issuer</span><span class=\"p\">,</span> <span class=\"n\">audience</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">token_verifier</span><span class=\"o\">.</span><span class=\"n\">verify</span><span class=\"p\">(</span><span class=\"s2\">&quot;some-access-token&quot;</span><span class=\"p\">)</span>\n</code></pre></div>\n\n<p>Validating Access Token and organization</p>\n\n<div class=\"pdoc-code codehilite\"><pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span> <span class=\"nn\">auth0_jwt_validator</span> <span class=\"kn\">import</span> <span class=\"n\">AccessTokenVerifier</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">auth0_jwks_uri</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/.well-known/jwks.json&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">issuer</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">audience</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/api/v2/&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">token_verifier</span> <span class=\"o\">=</span> <span class=\"n\">AccessTokenVerifier</span><span class=\"p\">(</span><span class=\"n\">auth0_jwks_uri</span><span class=\"p\">,</span> <span class=\"n\">issuer</span><span class=\"p\">,</span> <span class=\"n\">audience</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">token_verifier</span><span class=\"o\">.</span><span class=\"n\">verify</span><span class=\"p\">(</span><span class=\"s2\">&quot;some-access-token&quot;</span><span class=\"p\">,</span> <span class=\"n\">organization</span><span class=\"o\">=</span><span class=\"s2\">&quot;some-organization&quot;</span><span class=\"p\">)</span>\n</code></pre></div>\n\n<p>Validating Access Token and scopes</p>\n\n<div class=\"pdoc-code codehilite\"><pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span> <span class=\"nn\">auth0_jwt_validator</span> <span class=\"kn\">import</span> <span class=\"n\">AccessTokenVerifier</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">auth0_jwks_uri</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/.well-known/jwks.json&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">issuer</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">audience</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/api/v2/&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">token_verifier</span> <span class=\"o\">=</span> <span class=\"n\">AccessTokenVerifier</span><span class=\"p\">(</span><span class=\"n\">auth0_jwks_uri</span><span class=\"p\">,</span> <span class=\"n\">issuer</span><span class=\"p\">,</span> <span class=\"n\">audience</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">token_verifier</span><span class=\"o\">.</span><span class=\"n\">verify</span><span class=\"p\">(</span><span class=\"s2\">&quot;some-access-token&quot;</span><span class=\"p\">,</span> <span class=\"n\">required_scopes</span><span class=\"o\">=</span><span class=\"p\">[</span><span class=\"s2\">&quot;profile&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;calendar&quot;</span><span class=\"p\">])</span>\n</code></pre></div>\n\n<p>Validating Access Token and permissions</p>\n\n<div class=\"pdoc-code codehilite\"><pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span> <span class=\"nn\">auth0_jwt_validator</span> <span class=\"kn\">import</span> <span class=\"n\">AccessTokenVerifier</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">auth0_jwks_uri</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/.well-known/jwks.json&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">issuer</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">audience</span> <span class=\"o\">=</span> <span class=\"s2\">&quot;https://&lt;auth0-tenant&gt;.us.auth0.com/api/v2/&quot;</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">token_verifier</span> <span class=\"o\">=</span> <span class=\"n\">AccessTokenVerifier</span><span class=\"p\">(</span><span class=\"n\">auth0_jwks_uri</span><span class=\"p\">,</span> <span class=\"n\">issuer</span><span class=\"p\">,</span> <span class=\"n\">audience</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">token_verifier</span><span class=\"o\">.</span><span class=\"n\">verify</span><span class=\"p\">(</span><span class=\"s2\">&quot;some-access-token&quot;</span><span class=\"p\">,</span> <span class=\"n\">required_permissions</span><span class=\"o\">=</span><span class=\"p\">[</span><span class=\"s2\">&quot;read:user&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;delete:user&quot;</span><span class=\"p\">])</span>\n</code></pre></div>\n", "bases": "JwtVerifier"}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.get_token_type": {"fullname": "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.get_token_type", "modulename": "auth0_jwt_validator.jwt_verifier", "qualname": "AccessTokenVerifier.get_token_type", "type": "function", "doc": "<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>token_type</strong> (str):\nReturn the token type (ID token or access token) used by the verify\nmethods.</li>\n</ul>\n", "signature": "(self) -> str", "funcdef": "def"}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"fullname": "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify", "modulename": "auth0_jwt_validator.jwt_verifier", "qualname": "AccessTokenVerifier.verify", "type": "function", "doc": "<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>auth_token</strong> (str):\nThe access token.</li>\n</ul>\n\n<h6 id=\"other-parameters\">Other Parameters</h6>\n\n<ul>\n<li><strong>organization</strong> (str, default None):\nThe organization that issued the token.</li>\n<li><strong>required_scopes</strong> (list of str, default None):\nThe list of scopes which are required to be in the payload.</li>\n<li><strong>required_permissions</strong> (list of str, default None):\nThe list of permissions which are required to be in the payload.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>payload</strong> (<code>AccessTokenPayload</code>):\nThe payload which contains the claims. Claims are statements about\nan entity (typically, the user) and additional data.</li>\n</ul>\n\n<h6 id=\"raises\">Raises</h6>\n\n<ul>\n<li><strong>MissingClaimError</strong>: If some field in the claim (payload) is missing this error is raised.</li>\n<li><strong>InvalidClaimError</strong>: If some field in the claim (payload) doesn't match what's expected\nthis error is raised.</li>\n</ul>\n\n<h6 id=\"see-also\">See Also</h6>\n\n<p><code>AccessTokenPayload</code>  </p>\n", "signature": "(\n    self,\n    auth0_token: str,\n    /,\n    organization: Optional[str] = None,\n    required_scopes: Optional[List[str]] = None,\n    required_permissions: Optional[List[str]] = None\n) -> auth0_jwt_validator.jwt_verifier.AccessTokenPayload", "funcdef": "def"}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"fullname": "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload", "modulename": "auth0_jwt_validator.jwt_verifier", "qualname": "AccessTokenVerifier.verify_payload", "type": "function", "doc": "<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>payload</strong> (<code>AccessTokenPayload</code>):\nThe payload which contains the claims. Claims are statements about\nan entity (typically, the user) and additional data.</li>\n</ul>\n\n<h6 id=\"other-parameters\">Other Parameters</h6>\n\n<ul>\n<li><strong>organization</strong> (str, default None):\nThe organization that issued the token.</li>\n<li><strong>required_scopes</strong> (list of str, default None):\nThe list of scopes which are required to be in the payload.</li>\n<li><strong>required_permissions</strong> (list of str, default None):\nThe list of permissions which are required to be in the payload.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<ul>\n<li><strong>None</strong></li>\n</ul>\n\n<h6 id=\"raises\">Raises</h6>\n\n<ul>\n<li><strong>MissingClaimError</strong>: If some field in the claim (payload) is missing this error is raised.</li>\n<li><strong>InvalidClaimError</strong>: If some field in the claim (payload) doesn't match what's expected\nthis error is raised.</li>\n</ul>\n\n<h6 id=\"see-also\">See Also</h6>\n\n<p><code>AccessTokenPayload</code>  </p>\n", "signature": "(\n    self,\n    payload: auth0_jwt_validator.jwt_verifier.AccessTokenPayload,\n    /,\n    organization: Optional[str] = None,\n    required_scopes: Optional[List[str]] = None,\n    required_permissions: Optional[List[str]] = None\n) -> None", "funcdef": "def"}}, "docInfo": {"auth0_jwt_validator": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 1671}, "auth0_jwt_validator.http_bearer": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "auth0_jwt_validator.http_bearer.get_token": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 6, "bases": 0, "doc": 462}, "auth0_jwt_validator.jwt_verifier": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "auth0_jwt_validator.jwt_verifier.JwtVerifier": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 338}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 58}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_token_type": {"qualname": 4, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 4, "bases": 0, "doc": 26}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_auth0_signing_keys": {"qualname": 5, "fullname": 10, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 52}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 3}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_payload": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 6, "bases": 0, "doc": 26}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 99}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 99}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 99}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"qualname": 4, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 100}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"qualname": 5, "fullname": 10, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 101}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 100}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"qualname": 4, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 114}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 8, "bases": 0, "doc": 118}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"qualname": 4, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 121}, "auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 357}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 1, "doc": 959}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.get_token_type": {"qualname": 4, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 4, "bases": 0, "doc": 30}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 23, "bases": 0, "doc": 160}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 153}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 267}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 1, "doc": 969}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.get_token_type": {"qualname": 4, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 4, "bases": 0, "doc": 30}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 24, "bases": 0, "doc": 187}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 23, "bases": 0, "doc": 180}}, "length": 29, "save": true}, "index": {"qualname": {"root": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__": {"tf": 1}}, "df": 1, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"auth0_jwt_validator.http_bearer.get_token": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_auth0_signing_keys": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.get_token_type": {"tf": 1}}, "df": 5}}}, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"auth0_jwt_validator.http_bearer.get_token": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.get_token_type": {"tf": 1}}, "df": 4}}}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.get_token_type": {"tf": 1}}, "df": 3}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}}, "df": 3}}}}, "j": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_auth0_signing_keys": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}}, "df": 15}}}}}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__": {"tf": 1}}, "df": 1}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1}}, "df": 1}, "d": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1}}, "df": 1}}}}}, "d": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}}, "df": 1, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}}, "df": 1}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}}, "df": 4}}}}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"0": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.get_auth0_signing_keys": {"tf": 1}}, "df": 1}, "docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}}, "df": 1}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1}}, "df": 1}}}}}}}, "t": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1}}, "df": 1}, "z": {"docs": {}, "df": 0, "p": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1}}, "df": 1}}, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1}}, "df": 1}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1}}, "df": 4}}}}}}}}}}}}}}}}}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.get_auth0_signing_keys": {"tf": 1}}, "df": 1}}}}}}, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1}}, "df": 1}}}}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "s": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.get_auth0_signing_keys": {"tf": 1}}, "df": 1}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "y": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1}}, "df": 15}}}}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1}}, "df": 3}}}}}}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1}}, "df": 1}}}}}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1}}, "df": 1}}}}}}}, "fullname": {"root": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"0": {"docs": {"auth0_jwt_validator": {"tf": 1}, "auth0_jwt_validator.http_bearer": {"tf": 1}, "auth0_jwt_validator.http_bearer.get_token": {"tf": 1}, "auth0_jwt_validator.jwt_verifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_auth0_signing_keys": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1}}, "df": 29}, "docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}}, "df": 1}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1}}, "df": 1}}}}}}}, "t": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1}}, "df": 1}, "z": {"docs": {}, "df": 0, "p": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1}}, "df": 1}}, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1}}, "df": 1}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1}}, "df": 4}}}}}}}}}}}}}}}}}}}, "j": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "t": {"docs": {"auth0_jwt_validator": {"tf": 1}, "auth0_jwt_validator.http_bearer": {"tf": 1}, "auth0_jwt_validator.http_bearer.get_token": {"tf": 1}, "auth0_jwt_validator.jwt_verifier": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_token_type": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_auth0_signing_keys": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_payload": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.get_token_type": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.get_token_type": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1.4142135623730951}}, "df": 29, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_auth0_signing_keys": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}}, "df": 15}}}}}}}}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"auth0_jwt_validator": {"tf": 1}, "auth0_jwt_validator.http_bearer": {"tf": 1}, "auth0_jwt_validator.http_bearer.get_token": {"tf": 1}, "auth0_jwt_validator.jwt_verifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_auth0_signing_keys": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1}}, "df": 29}}}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"auth0_jwt_validator.jwt_verifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_auth0_signing_keys": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1}}, "df": 26}}}, "y": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1}}, "df": 15}}}}}}, "h": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {"auth0_jwt_validator.http_bearer": {"tf": 1}, "auth0_jwt_validator.http_bearer.get_token": {"tf": 1}}, "df": 2}}}}, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"auth0_jwt_validator.http_bearer": {"tf": 1}, "auth0_jwt_validator.http_bearer.get_token": {"tf": 1}}, "df": 2}}}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"auth0_jwt_validator.http_bearer.get_token": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_auth0_signing_keys": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.get_token_type": {"tf": 1}}, "df": 5}}}, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"auth0_jwt_validator.http_bearer.get_token": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.get_token_type": {"tf": 1}}, "df": 4}}}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.get_token_type": {"tf": 1}}, "df": 3}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}}, "df": 3}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__": {"tf": 1}}, "df": 1}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1}}, "df": 1}, "d": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1}}, "df": 1}}}}}, "d": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}}, "df": 1, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}}, "df": 1}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}}, "df": 4}}}}}}}}}}}}}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.get_auth0_signing_keys": {"tf": 1}}, "df": 1}}}}}}, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1}}, "df": 1}}}}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "s": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.get_auth0_signing_keys": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1}}, "df": 3}}}}}}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1}}, "df": 1}}}}}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1}}, "df": 1}}}}}}}, "annotation": {"root": {"docs": {}, "df": 0}}, "default_value": {"root": {"docs": {}, "df": 0}}, "signature": {"root": {"0": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__": {"tf": 1}}, "df": 1}, "docs": {"auth0_jwt_validator.http_bearer.get_token": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_token_type": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_auth0_signing_keys": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_payload": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.get_token_type": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.get_token_type": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1.7320508075688772}}, "df": 21, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"0": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1}}, "df": 5}, "docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"auth0_jwt_validator.http_bearer.get_token": {"tf": 1}}, "df": 1}}}}}}}}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__": {"tf": 1}}, "df": 1}}}}}}}, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_payload": {"tf": 1}}, "df": 1}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}}, "df": 3}}, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"auth0_jwt_validator.http_bearer.get_token": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"auth0_jwt_validator.http_bearer.get_token": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_auth0_signing_keys": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1}}, "df": 10}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "f": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_auth0_signing_keys": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1}}, "df": 20}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1}}, "df": 2}}}}}}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "[": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"auth0_jwt_validator.http_bearer.get_token": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1}}, "df": 5}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}}, "df": 2}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "[": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1.4142135623730951}}, "df": 2}}}}}}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1}}, "df": 5}}}}}}}}}}}}, "j": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "s": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_auth0_signing_keys": {"tf": 1}}, "df": 2}}, "t": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1.4142135623730951}}, "df": 4}}}, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_auth0_signing_keys": {"tf": 1}}, "df": 2}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}}, "df": 2}}, "d": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__": {"tf": 1}}, "df": 1}}}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 2}}, "df": 13}, "c": {"docs": {}, "df": 0, "e": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}}, "df": 3}}}}}, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1}}, "df": 3}}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify": {"tf": 1}}, "df": 1}}}}, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_payload": {"tf": 1}}, "df": 1}}}}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1}}, "df": 11}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1}}, "df": 2}}}}}}}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "x": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}}, "df": 3}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1}}, "df": 4}}}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1}}, "df": 4}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1.4142135623730951}}, "df": 2}}}}}}}}}}, "bases": {"root": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1}}, "df": 2}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1}}, "df": 2}}}}}}}}}, "j": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1}}, "df": 2}}}}}}}}}}}}}, "doc": {"root": {"2": {"4": {"docs": {"auth0_jwt_validator": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1}}, "df": 2}, "docs": {}, "df": 0}, "6": {"0": {"docs": {"auth0_jwt_validator": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1.4142135623730951}}, "df": 2}, "docs": {}, "df": 0}, "docs": {"auth0_jwt_validator": {"tf": 30.903074280724887}, "auth0_jwt_validator.http_bearer": {"tf": 1.7320508075688772}, "auth0_jwt_validator.http_bearer.get_token": {"tf": 16.30950643030009}, "auth0_jwt_validator.jwt_verifier": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 13.341664064126334}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__": {"tf": 4.898979485566356}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_token_type": {"tf": 3.3166247903554}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_auth0_signing_keys": {"tf": 4.898979485566356}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_payload": {"tf": 3.3166247903554}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 6.324555320336759}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 6.324555320336759}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 6.324555320336759}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 6.324555320336759}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 6.324555320336759}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 6.324555320336759}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 6.782329983125268}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 6.782329983125268}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 6.782329983125268}, "auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 10.954451150103322}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 22.561028345356956}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.get_token_type": {"tf": 3.4641016151377544}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 8.54400374531753}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 8.426149773176359}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 8.94427190999916}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 22.781571499789035}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.get_token_type": {"tf": 3.4641016151377544}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 8.54400374531753}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 8.426149773176359}}, "df": 29, "p": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"auth0_jwt_validator": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"auth0_jwt_validator": {"tf": 1}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"auth0_jwt_validator.http_bearer.get_token": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_auth0_signing_keys": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1.4142135623730951}}, "df": 16}}}}}}}, "t": {"docs": {}, "df": 0, "y": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1.4142135623730951}}, "df": 2}}}, "y": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 2.6457513110645907}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 2.449489742783178}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 2.449489742783178}}, "df": 16}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"auth0_jwt_validator": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1.4142135623730951}}, "df": 5}}}}}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"auth0_jwt_validator": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1}}, "df": 3}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1}}, "df": 2}}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1.4142135623730951}}, "df": 2}}}}}}}, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}}, "df": 1}}}}}}}}, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_auth0_signing_keys": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1.4142135623730951}}, "df": 5}}}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1.7320508075688772}}, "df": 1}}}}}}}, "a": {"docs": {"auth0_jwt_validator": {"tf": 1}, "auth0_jwt_validator.http_bearer.get_token": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}}, "df": 7, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"0": {"docs": {"auth0_jwt_validator": {"tf": 8.602325267042627}, "auth0_jwt_validator.http_bearer.get_token": {"tf": 2.23606797749979}, "auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_auth0_signing_keys": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 6.082762530298219}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 6.082762530298219}}, "df": 7}, "docs": {"auth0_jwt_validator.http_bearer.get_token": {"tf": 3.1622776601683795}, "auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1}}, "df": 5, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"auth0_jwt_validator.http_bearer.get_token": {"tf": 2}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1}}, "df": 2}}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"auth0_jwt_validator.http_bearer.get_token": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1.4142135623730951}}, "df": 3}}}}}}}}}}}}, "d": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1.4142135623730951}}, "df": 2, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"auth0_jwt_validator": {"tf": 4}, "auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 3}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 3}}, "df": 8}}}}}}}, "n": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1}}, "df": 19, "d": {"docs": {"auth0_jwt_validator": {"tf": 2.6457513110645907}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1}}, "df": 17}}, "g": {"docs": {}, "df": 0, "e": {"docs": {"auth0_jwt_validator": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}}, "df": 5}}, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"auth0_jwt_validator": {"tf": 2.8284271247461903}, "auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 2.8284271247461903}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1}}, "df": 6, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"auth0_jwt_validator": {"tf": 2.8284271247461903}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 2.8284271247461903}}, "df": 2}}}}}}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1.4142135623730951}}, "df": 2}}}}}}}}}}}}}}, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1}}, "df": 2}}}}}}}, "t": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1.4142135623730951}}, "df": 3, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1}}, "df": 5}}}}}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "s": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}}, "df": 1}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_auth0_signing_keys": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1.7320508075688772}}, "df": 18}, "g": {"docs": {}, "df": 0, "s": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1}}, "df": 1}}}, "s": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.get_auth0_signing_keys": {"tf": 1}}, "df": 1, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}}, "df": 1, "d": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1.4142135623730951}}, "df": 2}}}}}}}}}, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1}}, "df": 13}}}}, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1}}, "df": 13}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}}, "df": 1}}}}}}, "f": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1}}, "df": 2}}}}, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1}}, "df": 4}}}, "z": {"docs": {}, "df": 0, "p": {"docs": {"auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1.4142135623730951}}, "df": 1}}}, "j": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "t": {"docs": {"auth0_jwt_validator": {"tf": 3.1622776601683795}, "auth0_jwt_validator.http_bearer.get_token": {"tf": 2.23606797749979}, "auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 2.23606797749979}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 2.449489742783178}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 2.449489742783178}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 2.449489742783178}}, "df": 8, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1}}, "df": 1}}}}}}}}}, "k": {"docs": {}, "df": 0, "s": {"docs": {"auth0_jwt_validator": {"tf": 4}, "auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_auth0_signing_keys": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 3.1622776601683795}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 3.1622776601683795}}, "df": 6}}}, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"auth0_jwt_validator": {"tf": 2.8284271247461903}, "auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_auth0_signing_keys": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 2.449489742783178}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 2.449489742783178}}, "df": 6}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1}}, "df": 1}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"auth0_jwt_validator": {"tf": 3}, "auth0_jwt_validator.http_bearer.get_token": {"tf": 2.23606797749979}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 2}}, "df": 4}}, "e": {"docs": {"auth0_jwt_validator": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1}}, "df": 2}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"auth0_jwt_validator": {"tf": 2.8284271247461903}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 2}}, "df": 3}}}}}}}, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}}, "df": 2}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"auth0_jwt_validator": {"tf": 4}, "auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 2.8284271247461903}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 2.8284271247461903}}, "df": 4}}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1}}, "df": 2, "s": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1}}, "df": 1}}}}}}}}, "y": {"docs": {"auth0_jwt_validator": {"tf": 2.8284271247461903}, "auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 2.6457513110645907}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 2.6457513110645907}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 2.6457513110645907}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.get_token_type": {"tf": 1}}, "df": 15}}}}}}, "t": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1}}, "df": 13, "o": {"docs": {"auth0_jwt_validator": {"tf": 1}, "auth0_jwt_validator.http_bearer.get_token": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1.4142135623730951}}, "df": 8, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"auth0_jwt_validator": {"tf": 5.656854249492381}, "auth0_jwt_validator.http_bearer.get_token": {"tf": 4.47213595499958}, "auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 3.1622776601683795}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 4.358898943540674}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.get_token_type": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 4.358898943540674}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.get_token_type": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1}}, "df": 16, "s": {"docs": {"auth0_jwt_validator": {"tf": 1.4142135623730951}, "auth0_jwt_validator.http_bearer.get_token": {"tf": 1}}, "df": 2}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"auth0_jwt_validator": {"tf": 4.898979485566356}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 3.4641016151377544}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 3.4641016151377544}}, "df": 3}}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {"auth0_jwt_validator.http_bearer.get_token": {"tf": 2.23606797749979}, "auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 3.605551275463989}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__": {"tf": 2.449489742783178}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_auth0_signing_keys": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 2.449489742783178}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 2.449489742783178}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 2.449489742783178}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 2.449489742783178}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 2.449489742783178}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 2.449489742783178}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 2.8284271247461903}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 3}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 2.6457513110645907}, "auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 5.916079783099616}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 3.605551275463989}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.get_token_type": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 2.8284271247461903}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 2.6457513110645907}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 5.5677643628300215}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 3.4641016151377544}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.get_token_type": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 3.4641016151377544}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 3.3166247903554}}, "df": 23}, "a": {"docs": {}, "df": 0, "t": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1}}, "df": 11}}, "i": {"docs": {}, "df": 0, "s": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1.4142135623730951}}, "df": 16}}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.get_token_type": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.get_token_type": {"tf": 1.4142135623730951}}, "df": 6}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1}}, "df": 13}}}}}}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 2.6457513110645907}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1.7320508075688772}}, "df": 5}}}}, "s": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1}}, "df": 14, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1.4142135623730951}}, "df": 1, "s": {"docs": {"auth0_jwt_validator": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1.4142135623730951}}, "df": 5}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {"auth0_jwt_validator.http_bearer.get_token": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"auth0_jwt_validator": {"tf": 3.3166247903554}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 2.449489742783178}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 2.23606797749979}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1.4142135623730951}}, "df": 16}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {"auth0_jwt_validator.http_bearer.get_token": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_auth0_signing_keys": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 3.4641016151377544}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 3}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1.7320508075688772}}, "df": 16, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"auth0_jwt_validator": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1}}, "df": 2}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1}}, "df": 13}}}}}}}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"auth0_jwt_validator.http_bearer.get_token": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1}}, "df": 2}}}, "b": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1.4142135623730951}}, "df": 5, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1.4142135623730951}}, "df": 3}}}}}, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"auth0_jwt_validator.http_bearer.get_token": {"tf": 2.23606797749979}}, "df": 1}}}}, "t": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_auth0_signing_keys": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1.4142135623730951}}, "df": 5}, "l": {"docs": {}, "df": 0, "f": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1.7320508075688772}}, "df": 1}}, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}}, "df": 2}}}}}, "e": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1}}, "df": 4}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1}}, "df": 1}}}}}}}}, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}}, "df": 4}}}}}, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_auth0_signing_keys": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1}}, "df": 4}}}}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1}}, "df": 1}}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"auth0_jwt_validator": {"tf": 1}, "auth0_jwt_validator.http_bearer.get_token": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1}}, "df": 8}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"auth0_jwt_validator": {"tf": 2.8284271247461903}, "auth0_jwt_validator.http_bearer.get_token": {"tf": 2.449489742783178}, "auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 2}}, "df": 5}}}, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1.4142135623730951}}, "df": 13}}}, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1.4142135623730951}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1}}, "df": 2}}}}, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}}, "df": 1, "x": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"auth0_jwt_validator": {"tf": 1}, "auth0_jwt_validator.http_bearer.get_token": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1}}, "df": 5}}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {"auth0_jwt_validator.http_bearer.get_token": {"tf": 1}}, "df": 1}}}, "p": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1.4142135623730951}}, "df": 2, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1}}, "df": 13}}}}}, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1.4142135623730951}}, "df": 3}}}}}, "e": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1.4142135623730951}}, "df": 18}}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1}}, "df": 13}}}}, "d": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}}, "df": 1}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {"auth0_jwt_validator": {"tf": 2.8284271247461903}, "auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 2.8284271247461903}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.get_token_type": {"tf": 1}}, "df": 10, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"auth0_jwt_validator": {"tf": 2.8284271247461903}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 2.8284271247461903}}, "df": 2}}}}}}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1.4142135623730951}}, "df": 2}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 3.7416573867739413}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 3.1622776601683795}}, "df": 2}}}}}}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"auth0_jwt_validator": {"tf": 2.8284271247461903}, "auth0_jwt_validator.http_bearer.get_token": {"tf": 2.23606797749979}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 2}}, "df": 4}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_payload": {"tf": 1}}, "df": 3}}}}}}}}}}, "s": {"docs": {"auth0_jwt_validator.http_bearer.get_token": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1.7320508075688772}}, "df": 20, "s": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1.4142135623730951}}, "df": 2, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"auth0_jwt_validator": {"tf": 4}, "auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 3}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 3}}, "df": 8}, "d": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 2.23606797749979}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1}}, "df": 12}}}}}, "n": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 2}}, "df": 16, "t": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1.4142135623730951}}, "df": 5, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1}}, "df": 6}}}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1}}, "df": 13}}}}}}}}}}}}}}}}, "f": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1.4142135623730951}}, "df": 13}, "a": {"docs": {}, "df": 0, "t": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1.4142135623730951}}, "df": 2}}}, "g": {"docs": {}, "df": 0, "t": {"docs": {"auth0_jwt_validator": {"tf": 12.96148139681572}, "auth0_jwt_validator.http_bearer.get_token": {"tf": 6.708203932499369}, "auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 9.16515138991168}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 9.16515138991168}}, "df": 5, "y": {"docs": {"auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1.4142135623730951}}, "df": 1}}, "e": {"docs": {}, "df": 0, "t": {"docs": {"auth0_jwt_validator.http_bearer.get_token": {"tf": 3.4641016151377544}, "auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1.4142135623730951}}, "df": 4}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1.7320508075688772}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1}}, "df": 4}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {"auth0_jwt_validator": {"tf": 4}, "auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_auth0_signing_keys": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 3.4641016151377544}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 3.4641016151377544}}, "df": 6}, "l": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}}, "df": 1}}, "s": {"docs": {"auth0_jwt_validator": {"tf": 4.898979485566356}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 3.4641016151377544}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 3.4641016151377544}}, "df": 4, "e": {"docs": {}, "df": 0, "d": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.get_token_type": {"tf": 1}}, "df": 7}, "r": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1}}, "df": 15}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1}}, "df": 3}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"auth0_jwt_validator": {"tf": 8.831760866327848}, "auth0_jwt_validator.http_bearer.get_token": {"tf": 3.1622776601683795}, "auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 6}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 6.48074069840786}}, "df": 5}}}}, "h": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "s": {"docs": {"auth0_jwt_validator": {"tf": 4.898979485566356}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 3.4641016151377544}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 3.4641016151377544}}, "df": 3}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"auth0_jwt_validator.http_bearer.get_token": {"tf": 3.7416573867739413}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "p": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "t": {"docs": {"auth0_jwt_validator": {"tf": 4.898979485566356}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 3.4641016151377544}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 3.4641016151377544}}, "df": 3}, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_auth0_signing_keys": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1.4142135623730951}}, "df": 5}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1.4142135623730951}}, "df": 2}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 2}}, "df": 4}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"auth0_jwt_validator": {"tf": 4}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 2.8284271247461903}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 2.8284271247461903}}, "df": 3, "/": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "v": {"2": {"docs": {"auth0_jwt_validator": {"tf": 2.8284271247461903}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 2}}, "df": 3}, "docs": {}, "df": 0}}}}}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1}}, "df": 13}}}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"auth0_jwt_validator": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1}}, "df": 2}}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1}}, "df": 6}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_payload": {"tf": 1}}, "df": 3}}, "i": {"docs": {}, "df": 0, "m": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 3.7416573867739413}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 3.1622776601683795}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1.4142135623730951}}, "df": 15, "s": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1.4142135623730951}}, "df": 13}}}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1.4142135623730951}}, "df": 1, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1}}, "df": 1}}}}}}}}}}}}}, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}}, "df": 1}}}}}}}, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1}}, "df": 1}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1}}, "df": 1}}}}}}, "w": {"docs": {}, "df": 0, "e": {"docs": {"auth0_jwt_validator.http_bearer.get_token": {"tf": 1}}, "df": 1, "l": {"docs": {}, "df": 0, "l": {"docs": {"auth0_jwt_validator": {"tf": 2.8284271247461903}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 2}}, "df": 3}}, "b": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_auth0_signing_keys": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1.4142135623730951}}, "df": 5}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"auth0_jwt_validator.http_bearer.get_token": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1}}, "df": 3}}}, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"auth0_jwt_validator.http_bearer.get_token": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1.7320508075688772}}, "df": 16}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {"auth0_jwt_validator.http_bearer.get_token": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1}}, "df": 5}, "r": {"docs": {}, "df": 0, "e": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_auth0_signing_keys": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1}}, "df": 5}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1}}, "df": 13}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"auth0_jwt_validator.http_bearer.get_token": {"tf": 1}}, "df": 1}}, "s": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1.7320508075688772}}, "df": 2}}}, "k": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "s": {"docs": {"auth0_jwt_validator": {"tf": 2.8284271247461903}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 2}}, "df": 3}}}}}}}}}, "e": {"docs": {}, "df": 0, "y": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_auth0_signing_keys": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1.4142135623730951}}, "df": 5, "s": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_auth0_signing_keys": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1.7320508075688772}}, "df": 5}}}, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1}}, "df": 1}}}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"auth0_jwt_validator": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}}, "df": 6}}, "e": {"docs": {"auth0_jwt_validator.http_bearer.get_token": {"tf": 2.6457513110645907}, "auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 2}}, "df": 15}}, "t": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1}}, "df": 2, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_payload": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 3.1622776601683795}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"auth0_jwt_validator": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1}}, "df": 2}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1.4142135623730951}}, "df": 5, "s": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1}}, "df": 15}, "d": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1.4142135623730951}}, "df": 13}}}}}, "e": {"docs": {}, "df": 0, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"auth0_jwt_validator": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 2.449489742783178}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 2}}, "df": 4}}}}}}, "a": {"docs": {}, "df": 0, "d": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 3.7416573867739413}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 2.6457513110645907}}, "df": 2, ":": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"auth0_jwt_validator": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1}}, "df": 2}}}}}}}, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 2.23606797749979}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_auth0_signing_keys": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.get_token_type": {"tf": 1}}, "df": 6, "s": {"docs": {"auth0_jwt_validator.http_bearer.get_token": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_auth0_signing_keys": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1}}, "df": 17}}}}}, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.__init__": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1}}, "df": 4, "s": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1}}, "df": 2}}}}}}}}, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}}, "df": 1}}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "x": {"docs": {"auth0_jwt_validator": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}}, "df": 5}, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1}}, "df": 13}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "l": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"auth0_jwt_validator.http_bearer.get_token": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1}}, "df": 13, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1}}, "df": 13}}}}}}}}}}}}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}}, "df": 1}}}}}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_payload": {"tf": 1}}, "df": 3, "s": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.get_token_type": {"tf": 1}}, "df": 5}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 3.7416573867739413}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 2.6457513110645907}}, "df": 2}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1}}, "df": 2}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {"auth0_jwt_validator.http_bearer.get_token": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.get_token_type": {"tf": 1}}, "df": 8, "g": {"docs": {"auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1.4142135623730951}}, "df": 1, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"auth0_jwt_validator": {"tf": 2.449489742783178}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 2.23606797749979}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 2.23606797749979}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1.4142135623730951}}, "df": 9}}}}}}}}}}}, "n": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1}}, "df": 3, "e": {"docs": {"auth0_jwt_validator.http_bearer.get_token": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1}}, "df": 3}, "l": {"docs": {}, "df": 0, "y": {"docs": {"auth0_jwt_validator.http_bearer.get_token": {"tf": 1}}, "df": 1}}}, "f": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 2.23606797749979}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 2}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 2}}, "df": 6}, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1.4142135623730951}}, "df": 2}}}}}}}, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}}, "df": 1}}}}}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1}}, "df": 4}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, ":": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"auth0_jwt_validator": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1}}, "df": 2}}}}}}}}}, "f": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1.7320508075688772}}, "df": 1, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1.7320508075688772}}, "df": 4}}}}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1.7320508075688772}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}}, "df": 10}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1}}, "df": 13}}}, "o": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "n": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issuer": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_subject": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_audience": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_expiration_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_issued_at_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_azp": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_org_id": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_nonce": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_auth_time": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1}}, "df": 13}}}}}, "b": {"docs": {}, "df": 0, "e": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_payload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenPayload": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.verify_payload": {"tf": 1.4142135623730951}}, "df": 7, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"auth0_jwt_validator.http_bearer.get_token": {"tf": 2.8284271247461903}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1.4142135623730951}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.JwtVerifier.verify_payload": {"tf": 1}}, "df": 3}}}}}}, "y": {"docs": {"auth0_jwt_validator.jwt_verifier.JwtVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.IdTokenVerifier.get_token_type": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier": {"tf": 1}, "auth0_jwt_validator.jwt_verifier.AccessTokenVerifier.get_token_type": {"tf": 1}}, "df": 5}, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1.4142135623730951}}, "df": 1}}, "y": {"docs": {"auth0_jwt_validator.jwt_verifier.IdTokenPayload": {"tf": 1}}, "df": 1}}}}}}}}}}}, "pipeline": ["trimmer"], "_isPrebuiltIndex": true};

    // mirrored in build-search-index.js (part 1)
    // Also split on html tags. this is a cheap heuristic, but good enough.
    elasticlunr.tokenizer.setSeperator(/[\s\-.;&_'"=,()]+|<[^>]*>/);

    let searchIndex;
    if (docs._isPrebuiltIndex) {
        console.info("using precompiled search index");
        searchIndex = elasticlunr.Index.load(docs);
    } else {
        console.time("building search index");
        // mirrored in build-search-index.js (part 2)
        searchIndex = elasticlunr(function () {
            this.pipeline.remove(elasticlunr.stemmer);
            this.pipeline.remove(elasticlunr.stopWordFilter);
            this.addField("qualname");
            this.addField("fullname");
            this.addField("annotation");
            this.addField("default_value");
            this.addField("signature");
            this.addField("bases");
            this.addField("doc");
            this.setRef("fullname");
        });
        for (let doc of docs) {
            searchIndex.addDoc(doc);
        }
        console.timeEnd("building search index");
    }

    return (term) => searchIndex.search(term, {
        fields: {
            qualname: {boost: 4},
            fullname: {boost: 2},
            annotation: {boost: 2},
            default_value: {boost: 2},
            signature: {boost: 2},
            bases: {boost: 2},
            doc: {boost: 1},
        },
        expand: true
    });
})();