"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3LogsExtension = exports.Function = void 0;
const path = require("path");
const lambda = require("@aws-cdk/aws-lambda");
const cdk = require("@aws-cdk/core");
/**
 *
 */
class Function extends lambda.Function {
    /**
     *
     */
    constructor(scope, id, props) {
        super(scope, id, props);
    }
    /**
     *
     */
    addExtension(extension) {
        this.addLayers(extension);
    }
}
exports.Function = Function;
/**
 *
 */
class S3LogsExtension extends cdk.Construct {
    /**
     *
     */
    constructor(scope, id) {
        super(scope, id);
        this.extension = new lambda.LayerVersion(scope, `${id}LayerVersion`, {
            code: lambda.Code.fromAsset(path.join(__dirname, '../aws-lambda-extensions/s3-logs-extension-demo/extensionssrc')),
            compatibleRuntimes: [lambda.Runtime.PYTHON_3_8],
        });
    }
}
exports.S3LogsExtension = S3LogsExtension;
//# sourceMappingURL=data:application/json;base64,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