# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['for_runners',
 'for_runners.admin',
 'for_runners.gpx_tools',
 'for_runners.management',
 'for_runners.management.commands',
 'for_runners.managers',
 'for_runners.migrations',
 'for_runners.models',
 'for_runners.selectors',
 'for_runners.services',
 'for_runners.signal_handlers',
 'for_runners.tests',
 'for_runners.tests.fixture_files',
 'for_runners.tests.fixtures',
 'for_runners.views',
 'for_runners_project',
 'for_runners_project.for_runners_helper_app',
 'for_runners_project.for_runners_helper_app.fixtures',
 'for_runners_project.for_runners_helper_app.management',
 'for_runners_project.for_runners_helper_app.management.commands',
 'for_runners_project.settings',
 'for_runners_project.tests']

package_data = \
{'': ['*'],
 'for_runners': ['static/*',
                 'static/chartjs/*',
                 'static/dygraphs/*',
                 'static/leaflet/*',
                 'static/leaflet/images/*',
                 'templates/admin/for_runners/*',
                 'templates/admin/for_runners/eventmodel/*',
                 'templates/admin/for_runners/gpxmodel/*',
                 'templates/admin/for_runners/gpxmodel/include/*',
                 'templates/for_runners/*',
                 'templates/for_runners/includes/*'],
 'for_runners_project': ['templates/*', 'templates/admin/*']}

install_requires = \
['autotask',
 'bx_django_utils',
 'bx_py_utils',
 'click',
 'colorlog',
 'django',
 'django-admin-sortable2',
 'django-axes',
 'django-dbbackup',
 'django-debug-toolbar',
 'django-import-export',
 'django-processinfo',
 'django-tools',
 'geopy',
 'gpxpy',
 'gunicorn',
 'lxml',
 'matplotlib',
 'requests',
 'svgwrite']

extras_require = \
{'docker': ['docker-compose'], 'postgres': ['psycopg2-binary']}

entry_points = \
{'console_scripts': ['manage = for_runners_project.manage:main',
                     'publish = for_runners_project.publish:publish']}

setup_kwargs = {
    'name': 'django-for-runners',
    'version': '0.16.0rc1',
    'description': 'Store your GPX tracks of your running (or other sports activity) in django.',
    'long_description': '# Django-ForRunners\n\n![Logo](https://github.com/jedie/django-for-runners/raw/main/for_runners/static/Django-ForRunners128.png "Logo") Store your GPX tracks of your running (or other sports activity) in django.\n\n[![pytest](https://github.com/jedie/django-for-runners/workflows/test/badge.svg?branch=main)](https://github.com/jedie/django-for-runners/actions)\n[![Coverage Status on codecov.io](https://codecov.io/gh/jedie/django-for-runners/branch/main/graph/badge.svg)](https://codecov.io/gh/jedie/django-for-runners)\n[![django_yunohost_integration @ PyPi](https://img.shields.io/pypi/v/django_yunohost_integration?label=django_yunohost_integration%20%40%20PyPi)](https://pypi.org/project/django_yunohost_integration/)\n[![Python Versions](https://img.shields.io/pypi/pyversions/django_yunohost_integration)](https://github.com/jedie/django-for-runners/blob/main/pyproject.toml)\n[![License GPL](https://img.shields.io/pypi/l/django_yunohost_integration)](https://github.com/jedie/django-for-runners/blob/main/LICENSE)\n\n(The name **Django-ForRunners** has the origin from the great Android tracking app **ForRunners** by Benoît Hervier: [http://rvier.fr/#forrunners](http://rvier.fr/#forrunners) )\n\n\n## Features:\n\n\n* GPX track management:\n  * Upload GPX tracks\n  * Import GPX tracks from commandline\n  * Track analysis:\n    * basics: Track length / Duration / Pace / Hart rate Up-/Downhill\n    * Display route on OpenStreetMap map\n    * Graphs with elevation / heart rate / cadence (if available in GPX data)\n  * Data that is automatically extracted from the web:\n    * Start/finish Address from OpenStreetMap\n    * Start/finish weather information from metaweather.com\n  * Store additional data:\n    * Ideal track distance (for easier grouping/filtering tracks)\n* sports competitions Management:\n  * Create a List of Sport Events\n    * Add participation to a event\n    * link GPX track with a event participation\n    * Store you event participation:\n      * official track length\n      * measured finisher time\n      * Number of participants who have finished in your discipline\n    * Add links to webpages relatet to this event\n    * Record costs (entry fee, T-shirt etc.)\n* common\n  * Multiple user support (However: no rights management and currently only suitable for a handful of users)\n\n\n* Install as [YunoHost](https://yunohost.org) App via [django-for-runners_ynh](https://github.com/YunoHost-Apps/django-for-runners_ynh)\n\n## Developer information\n\n### prepare\n```\n~$ git clone https://github.com/jedie/django-for-runners.git\n~$ cd django-for-runners/\n~/django-for-runners$ make\n_________________________________________________________________\nDjangoForRunners - *dev* Makefile\n\ninstall-poetry         install or update poetry\ninstall                install DjangoForRunners via poetry\nmanage-update          Collectstatic + makemigration + migrate\nupdate                 update the sources and installation\ntox-listenvs           List all tox test environments\ntox                    Run pytest via tox with all environments\ntox-py36               Run pytest via tox with *python v3.6*\ntox-py37               Run pytest via tox with *python v3.7*\ntox-py38               Run pytest via tox with *python v3.8*\npytest                 Run pytest\npublish                Release new version to PyPi\nrun-dev-server         Run the django dev server in endless loop.\ncreatesuperuser        Create super user\nmessages               Make and compile locales message files\ndbbackup               Backup database\ndbrestore              Restore a database backup\nrun-docker-dev-server  Start docker containers with current dev source code\n```\n\n### local development installation\n```\n# install or update Poetry:\n~/django-for-runners$ make install-poetry\n\n# install  Django-ForRunners via poetry:\n~/django-for-runners$ make install\n...\n\n# Collectstatic + makemigration + migrate:\n~/django-for-runners$ make manage-update\n\n# Create a django super user:\n~/django-for-runners$ ./manage.sh createsuperuser\n\n# start local dev. web server:\n~/django-for-runners$ make run-dev-server\n```\n\nThe web page is available in Port 8000, e.g.: `http://127.0.0.1:8000/`\n\n### import GPX files\n\ne.g.:\n```\n~/django-for-runners$ poetry run manage import_gpx --username <django_username> ~/backups/gpx_files\n```\n\n**Note:** It is no problem to start **import_gpx** with the same GPX files: Duplicate entries are avoided. The start/finish (time/latitude/longitude) are compared.\n\n### backup\n\nCreate a backup into `.../backups/<timestamp>/` e.g.:\n```\n~/django-for-runners$ poetry run for_runners backup\n```\n\nThe backup does:\n\n\n* backup the database\n* export all GPX tracks\n* generate .csv files:\n* a complete file with all running tracks\n* one file for every user\n\n### regenerate all SVG files\n```\n~/django-for-runners$ poetry run for_runners recreate-svg\n```\n\n## Screenshots\n\n(All screenshots are here: [github.com/jedie/jedie.github.io/tree/master/screenshots/django-for-runners](https://github.com/jedie/jedie.github.io/tree/master/screenshots/django-for-runners))\n\n## for-runers v0.6.0 2018-07-31 GPX Track.png\n\n![for-runers v0.6.0 2018-07-31 GPX Track.png](https://raw.githubusercontent.com/jedie/jedie.github.io/master/screenshots/django-for-runners/for-runers%20v0.6.0%202018-07-31%20GPX%20Track.png "for-runers v0.6.0 2018-07-31 GPX Track.png")\n\n## for-runners v0.4.0 2018-6-26 GPX info.png\n\n![for-runners v0.4.0 2018-6-26 GPX info.png](https://raw.githubusercontent.com/jedie/jedie.github.io/master/screenshots/django-for-runners/for-runners%20v0.4.0%202018-6-26%20GPX%20info.png "for-runners v0.4.0 2018-6-26 GPX info.png")\n\n## for-runners v0.6.0 2018-07-19 Event Costs.png\n\n![for-runners v0.6.0 2018-07-19 Event Costs.png](https://raw.githubusercontent.com/jedie/jedie.github.io/master/screenshots/django-for-runners/for-runners%20v0.6.0%202018-07-19%20Event%20Costs.png "for-runners v0.6.0 2018-07-19 Event Costs.png")\n\n## print a small overview\n\n![for-runners v0.10.0 2010-06-26 print small overview 1.png](https://raw.githubusercontent.com/jedie/jedie.github.io/master/screenshots/django-for-runners/for-runners%20v0.10.0%202010-06-26%20print%20small%20overview%201.png "for-runners v0.10.0 2010-06-26 print small overview 1.png")\n\n![for-runners v0.10.0 2010-06-26 print small overview 2.png](https://raw.githubusercontent.com/jedie/jedie.github.io/master/screenshots/django-for-runners/for-runners%20v0.10.0%202010-06-26%20print%20small%20overview%202.png "for-runners v0.10.0 2010-06-26 print small overview 2.png")\n\n## run tests\n```\n~/Django-ForRunners$ make test\n\nor:\n\n~/Django-ForRunners$ make tox\n```\n\n**Note:**\n\nTo run all tests, you need:\n\n\n* **Chromium Browser WebDriver** e.g.: `apt install chromium-chromedriver`\n* **Firefox Browser WebDriver** aka **geckodriver**\n\ninstall **geckodriver** e.g.:\n```\n~$ cd /tmp\n/tmp$ wget https://github.com/mozilla/geckodriver/releases/download/v0.20.1/geckodriver-v0.20.1-linux64.tar.gz -O geckodriver.tar.gz\n/tmp$ sudo sh -c \'tar -x geckodriver -zf geckodriver.tar.gz -O > /usr/bin/geckodriver\'\n/tmp$ sudo chmod +x /usr/bin/geckodriver\n/tmp$ rm geckodriver.tar.gz\n/tmp$ geckodriver --version\ngeckodriver 0.20.1\n...\n```\n\n## some notes\n\n### GPX storage\n\nCurrently we store the unchanged GPX data in a TextField.\n\n### static files\n\nWe collect some JavaScript files, for easier startup. These files are:\n\n| Project Homepage                      | License                                                                                   | storage directory                                                                                                   |\n| ------------------------------------- | ----------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------- |\n| [leafletjs.com](http://leafletjs.com) | [Leaflet licensed under BSD](https://github.com/Leaflet/Leaflet/blob/master/LICENSE)      | [for_runners/static/leaflet/](https://github.com/jedie/django-for-runners/tree/master/for_runners/static/leaflet)   |\n| [dygraphs.com](http://dygraphs.com)   | [dygraphs licensed under MIT](https://github.com/danvk/dygraphs/blob/master/LICENSE.txt)  | [for_runners/static/dygraphs/](https://github.com/jedie/django-for-runners/tree/master/for_runners/static/dygraphs) |\n| [chartjs.org](http://www.chartjs.org) | [Chart.js licensed under MIT](https://github.com/chartjs/Chart.js/blob/master/LICENSE.md) | [for_runners/static/chartjs/](https://github.com/jedie/django-for-runners/tree/master/for_runners/static/chartjs)   |\n\n### Precision of coordinates\n\nGPX files from Garmin (can) contain:\n\n\n* latitude with 29 decimal places\n* longitude with 28 decimal places\n* elevation with 19 decimal places\n\nThe route on OpenStreetMap does not look more detailed, with more than 5 decimal places.\n\nSee also: [https://wiki.openstreetmap.org/wiki/Precision_of_coordinates](https://wiki.openstreetmap.org/wiki/Precision_of_coordinates)\n\n## Django compatibility\n\n| django-for-runners | django version | python              |\n| ------------------ | -------------- | ------------------- |\n| >=v0.15.0          | 3.2, 4.0, 4.1  | 3.7, 3.8, 3.9, 3.10 |\n| >=v0.14.0          | 3.2            | 3.7, 3.8, 3.9, 3.10 |\n| >=v0.12.0          | 2.2            | 3.7, 3.8, 3.9, 3.10 |\n| >=v0.11.0          | 2.2            | 3.7, 3.8, 3.9       |\n| >=v0.7.1           | 2.1            | 3.5, 3.6, 3.7       |\n| v0.5.x             | 2.0            | 3.5, 3.6, 3.7       |\n\n(See also combinations in [tox.ini](https://github.com/jedie/django-for-runners/blob/main/tox.ini) and [github actions](https://github.com/jedie/django-for-runners/blob/main/.github/workflows/pythonapp.yml))\n\n## Backwards-incompatible changes\n\nOlder changes, see:\n\n[https://github.com/jedie/django-for-runners/blob/v0.10.1/README.creole#backwards-incompatible-changes](https://github.com/jedie/django-for-runners/blob/v0.10.1/README.creole#backwards-incompatible-changes)\n\n## history\n\n\n* [**dev**](https://github.com/jedie/django-for-runners/compare/v0.15.0...main)\n  * NEW: Attach files and images to "Event Participations"\n  * tbc\n* [29.09.2022 - v0.15.0](https://github.com/jedie/django-for-runners/compare/v0.14.0...v0.15.0):\n  * Update requirements\n  * Activate auto login for local dev. server, for easier developing.\n  * Test against different Django Versions: 3.2, 4.0 and 4.1\n  * Replace creole README with Markdown\n* [16.08.2022 - v0.14.0](https://github.com/jedie/django-for-runners/compare/v0.13.0...v0.14.0):\n  * Update to Django v3.2\n  * Bugfix backup manage command\n* [15.04.2022 - v0.13.0](https://github.com/jedie/django-for-runners/compare/v0.12.1...v0.13.0):\n  * Switch git branch from "master" to "main"\n  * Remove "/development/" and mode "/src/"\n  * update requirements\n* [22.11.2021 - v0.12.1](https://github.com/jedie/django-for-runners/compare/v0.12.0...v0.12.1):\n  * update requirements\n* [17.01.2021 - v0.12.0](https://github.com/jedie/django-for-runners/compare/v0.11.0...v0.12.0):\n  * refactor project structure and add a deployment via docker-compose setup\n  * installation as YunoHost app: [https://github.com/YunoHost-Apps/django-for-runners_ynh](https://github.com/YunoHost-Apps/django-for-runners_ynh)\n  * Add django-axes and django-processinfo\n  * Mock requests in tests\n* [04.07.2020 - v0.11.0](https://github.com/jedie/django-for-runners/compare/v0.10.1...v0.11.0):\n  * refactor gpx import code\n  * update tests\n  * Use poetry and add Makefile\n  * update code style\n* [09.08.2019 - v0.10.1](https://github.com/jedie/django-for-runners/compare/v0.10.0...v0.10.1):\n  * Enhance "Event Participation" admin view: Add start date and costs in table\n* [26.06.2019 - v0.10.0](https://github.com/jedie/django-for-runners/compare/v0.9.0...v0.10.0):\n  * NEW: GPX Admin action to print a small overview from one or a few tracks\n  * Accept optional server bind address, e.g.: `for_runners run-server 127.0.0.1:8080`\n* [02.04.2019 - v0.9.0](https://github.com/jedie/django-for-runners/compare/v0.8.1...v0.9.0):\n  * NEW: Update complete environment installation with: `for_runners update`\n  * Move the SQlite database to virtualenv root dir, e.g.: `~/Django-ForRunners/Django-ForRunners-database.sqlite3`\n  * NEW: save every gpx track to disk\n  * NEW: Backup/export via cli: `$ for_runners backup`\n  * NEW: export GPX Data via `django-import-export`\n  * Create xdg-open desktop starter under linux here: `~/Django-ForRunners/Django-ForRunners`\n  * refactor the startup process:\n    * auto loop the server process\n    * open web browser on first start\n    * enable autotask\n  * rename `for_runners_test_project` to `for_runners_project`\n* [03.09.2018 - v0.8.1](https://github.com/jedie/django-for-runners/compare/v0.8.0...v0.8.1):\n  * Fix "try-out" section in README, again ;(\n* [03.09.2018 - v0.8.0](https://github.com/jedie/django-for-runners/compare/v0.7.1...v0.8.0):\n  * NEW: shell script for easier boot/install, see above\n* [02.09.2018 - v0.7.1](https://github.com/jedie/django-for-runners/compare/v0.7.0...v0.7.1):\n  * Update to Django 2.1\n  * Bugfix Tests\n* [02.09.2018 - v0.7.0](https://github.com/jedie/django-for-runners/compare/v0.6.0...v0.7.0):\n  * Use dygraphs in GPX Track change admin view\n  * Sync mouse over from Elevation/Headrate/Cadence dygraphs to leaflet open streep map\n  * Fix "try-out" section in README ([Thanks adsworth for reporting](https://github.com/jedie/django-for-runners/pull/1))\n  * Add links from gpx tracks to other admin change view\n  * Bugfixes\n  * internals:\n    * refactor stuff around track duration/length\n    * move manipluation of list_display and list_filter [contributed by adsworth](https://github.com/jedie/django-for-runners/pull/2)\n* [19.07.2018 - v0.6.0](https://github.com/jedie/django-for-runners/compare/v0.5.0...v0.6.0):\n  * NEW: event participation\n  * NEW: costs of event participation (e.g.: entry fee for the competition, cost of a T-Shirt etc.)\n  * NEW: Display statistics of events/costs per user and total\n* [04.07.2018 - v0.5.0](https://github.com/jedie/django-for-runners/compare/v0.4.0...v0.5.0):\n  * remove Django-CMS\n  * update to Django v2.0\n  * NOTE: The migrations are simply replaced! So you must delete your database, e.g.: `src/django-for-runners$ rm test_project_db.sqlite3`\n  * Add \'net duration\' field, for the officially measured time and use it for calculations if available.\n  * Create django manage command to fill some base data: `$ ./manage.py fill_basedata`\n  * speedup by deactivating some django debug toolbar panels\n* [26.06.2018 - v0.4.0](https://github.com/jedie/django-for-runners/compare/v0.3.0...v0.4.0):\n  * combine track filters with statistic views\n  * NEW: GPX info (See length, point count and Average distance in meters between the points)\n  * NEW: Display GPX metadata\n  * Add \'creator\' to every track and use it as changelist filter\n  * remove Streetmap image generated via [geotiler](https://pypi.org/project/geotiler/)\n  * Speedup by using a cache for gpxpy instances\n* [23.06.2018 - v0.3.0](https://github.com/jedie/django-for-runners/compare/v0.2.0...v0.3.0):\n  * Start adding statistics (See screenshot above)\n  * add weather information from [metaweather.com](https://www.metaweather.com/) to every track\n* [21.06.2018 - v0.2.0](https://github.com/jedie/django-for-runners/compare/v0.1.1...v0.2.0):\n  * Display elevations, heart_rates and cadence_values if available\n  * Add kilometer markers to OpenStreetMap\n* [15.06.2018 - v0.1.1](https://github.com/jedie/django-for-runners/compare/v0.1.0...v0.1.1):\n  * a few bugfixes\n* [15.06.2018 - v0.1.0](https://github.com/jedie/django-for-runners/compare/v0.0.4...v0.1.0):\n  * Render interactive OpenStreetMap track map with Leaflet JS\n* [12.06.2018 - v0.0.4](https://github.com/jedie/django-for-runners/compare/v0.0.3...v0.0.4):\n  * Better Events model\n  * GPX error handling\n  * more tests\n  * Bugfix for Python 3.5 (Geotiler needs Python 3.6 or later)\n* [12.06.2018 - v0.0.3](https://github.com/jedie/django-for-runners/compare/v0.0.2...v0.0.3):\n  * display min/average/max heart rate\n  * use autotask to generate the MAP in background\n* [31.05.2018 - v0.0.2](https://github.com/jedie/django-for-runners/compare/v0.0.1...v0.0.2):\n  * generate SVG \'icon\' from GPX track\n* v0.0.1 - 30.05.2018\n  * Just create a pre-alpha release to save the PyPi package name ;)\n\n## links\n\n| Homepage | [http://github.com/jedie/django-for-runners](http://github.com/jedie/django-for-runners)     |\n| PyPi     | [https://pypi.org/project/django-for-runners/](https://pypi.org/project/django-for-runners/) |\n\n### activity exporter\n\nIt\'s sometimes hard to find a working project for exporting activities.\nSo here tools that i use currently:\n\n\n* [Garmin-Connect-Export](https://github.com/rsjrny/Garmin-Connect-Export) from rsjrny\n\n### alternatives (OpenSource only)\n\n\n* [https://github.com/pytrainer/pytrainer](https://github.com/pytrainer/pytrainer) (Desktop Program)\n* [https://github.com/GoldenCheetah/GoldenCheetah/](https://github.com/GoldenCheetah/GoldenCheetah/) (Desktop Program)\n\nOnline tools:\n\n\n* [https://www.j-berkemeier.de/ShowGPX.html](https://www.j-berkemeier.de/ShowGPX.html) (de)\n\n## credits\n\nThe whole thing is based on many excellent projects. Especially the following:\n\n\n* [gpxpy](https://pypi.org/project/gpxpy/) GPX file parser\n* [Leaflet JS](https://leafletjs.com) A JS library for interactive maps used to render the track on [OpenStreetMap](https://openstreetmap.org/)\n* [dygraphs](http://dygraphs.com) open source JavaScript charting library\n* [Chart.js](https://www.chartjs.org) HTML5 Charts\n* [geopy](https://pypi.org/project/geopy/) Get geo location names of the GPX track start/end point\n* [matplotlib](https://pypi.org/project/matplotlib/) plotting 2D graphics\n* [autotask](https://pypi.org/project/autotask/) schedule background jobs\n* [svgwrite](https://pypi.org/project/svgwrite/) Generating SVG file\n\n## donation\n\n\n* [paypal.me/JensDiemer](https://www.paypal.me/JensDiemer)\n* [Flattr This!](https://flattr.com/submit/auto?uid=jedie&url=https%3A%2F%2Fgithub.com%2Fjedie%2Fdjango-for-runners%2F)\n* Send [Bitcoins](http://www.bitcoin.org/) to [1823RZ5Md1Q2X5aSXRC5LRPcYdveCiVX6F](https://blockexplorer.com/address/1823RZ5Md1Q2X5aSXRC5LRPcYdveCiVX6F)\n',
    'author': 'JensDiemer',
    'author_email': 'git@jensdiemer.de',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/jedie/django-for-runners',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0.0',
}


setup(**setup_kwargs)
