import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):
    def forwards(self, orm):

        # Adding model 'MessageContact'
        db.create_table(
            "umessages_messagecontact",
            (
                ("id", self.gf("django.db.models.fields.AutoField")(primary_key=True)),
                (
                    "um_from_user",
                    self.gf("django.db.models.fields.related.ForeignKey")(
                        related_name="um_from_users", to=orm["auth.User"]
                    ),
                ),
                (
                    "um_to_user",
                    self.gf("django.db.models.fields.related.ForeignKey")(
                        related_name="um_to_users", to=orm["auth.User"]
                    ),
                ),
                (
                    "latest_message",
                    self.gf("django.db.models.fields.related.ForeignKey")(
                        to=orm["umessages.Message"]
                    ),
                ),
            ),
        )
        db.send_create_signal("umessages", ["MessageContact"])

        # Adding unique constraint on 'MessageContact', fields ['um_from_user', 'um_to_user']
        db.create_unique(
            "umessages_messagecontact", ["um_from_user_id", "um_to_user_id"]
        )

        # Adding model 'MessageRecipient'
        db.create_table(
            "umessages_messagerecipient",
            (
                ("id", self.gf("django.db.models.fields.AutoField")(primary_key=True)),
                (
                    "user",
                    self.gf("django.db.models.fields.related.ForeignKey")(
                        to=orm["auth.User"]
                    ),
                ),
                (
                    "message",
                    self.gf("django.db.models.fields.related.ForeignKey")(
                        to=orm["umessages.Message"]
                    ),
                ),
                (
                    "read_at",
                    self.gf("django.db.models.fields.DateTimeField")(
                        null=True, blank=True
                    ),
                ),
                (
                    "deleted_at",
                    self.gf("django.db.models.fields.DateTimeField")(
                        null=True, blank=True
                    ),
                ),
            ),
        )
        db.send_create_signal("umessages", ["MessageRecipient"])

        # Adding model 'Message'
        db.create_table(
            "umessages_message",
            (
                ("id", self.gf("django.db.models.fields.AutoField")(primary_key=True)),
                ("body", self.gf("django.db.models.fields.TextField")()),
                (
                    "sender",
                    self.gf("django.db.models.fields.related.ForeignKey")(
                        related_name="sent_messages", to=orm["auth.User"]
                    ),
                ),
                (
                    "sent_at",
                    self.gf("django.db.models.fields.DateTimeField")(
                        auto_now_add=True, blank=True
                    ),
                ),
                (
                    "sender_deleted_at",
                    self.gf("django.db.models.fields.DateTimeField")(
                        null=True, blank=True
                    ),
                ),
            ),
        )
        db.send_create_signal("umessages", ["Message"])

    def backwards(self, orm):

        # Removing unique constraint on 'MessageContact', fields ['um_from_user', 'um_to_user']
        db.delete_unique(
            "umessages_messagecontact", ["um_from_user_id", "um_to_user_id"]
        )

        # Deleting model 'MessageContact'
        db.delete_table("umessages_messagecontact")

        # Deleting model 'MessageRecipient'
        db.delete_table("umessages_messagerecipient")

        # Deleting model 'Message'
        db.delete_table("umessages_message")

    models = {
        "auth.group": {
            "Meta": {"object_name": "Group"},
            "id": ("django.db.models.fields.AutoField", [], {"primary_key": "True"}),
            "name": (
                "django.db.models.fields.CharField",
                [],
                {"unique": "True", "max_length": "80"},
            ),
            "permissions": (
                "django.db.models.fields.related.ManyToManyField",
                [],
                {
                    "to": "orm['auth.Permission']",
                    "symmetrical": "False",
                    "blank": "True",
                },
            ),
        },
        "auth.permission": {
            "Meta": {
                "ordering": "('content_type__app_label', 'content_type__model', 'codename')",
                "unique_together": "(('content_type', 'codename'),)",
                "object_name": "Permission",
            },
            "codename": (
                "django.db.models.fields.CharField",
                [],
                {"max_length": "100"},
            ),
            "content_type": (
                "django.db.models.fields.related.ForeignKey",
                [],
                {"to": "orm['contenttypes.ContentType']"},
            ),
            "id": ("django.db.models.fields.AutoField", [], {"primary_key": "True"}),
            "name": ("django.db.models.fields.CharField", [], {"max_length": "50"}),
        },
        "auth.user": {
            "Meta": {"object_name": "User"},
            "date_joined": (
                "django.db.models.fields.DateTimeField",
                [],
                {"default": "datetime.datetime.now"},
            ),
            "email": (
                "django.db.models.fields.EmailField",
                [],
                {"max_length": "75", "blank": "True"},
            ),
            "first_name": (
                "django.db.models.fields.CharField",
                [],
                {"max_length": "30", "blank": "True"},
            ),
            "groups": (
                "django.db.models.fields.related.ManyToManyField",
                [],
                {"to": "orm['auth.Group']", "symmetrical": "False", "blank": "True"},
            ),
            "id": ("django.db.models.fields.AutoField", [], {"primary_key": "True"}),
            "is_active": (
                "django.db.models.fields.BooleanField",
                [],
                {"default": "True"},
            ),
            "is_staff": (
                "django.db.models.fields.BooleanField",
                [],
                {"default": "False"},
            ),
            "is_superuser": (
                "django.db.models.fields.BooleanField",
                [],
                {"default": "False"},
            ),
            "last_login": (
                "django.db.models.fields.DateTimeField",
                [],
                {"default": "datetime.datetime.now"},
            ),
            "last_name": (
                "django.db.models.fields.CharField",
                [],
                {"max_length": "30", "blank": "True"},
            ),
            "password": (
                "django.db.models.fields.CharField",
                [],
                {"max_length": "128"},
            ),
            "user_permissions": (
                "django.db.models.fields.related.ManyToManyField",
                [],
                {
                    "to": "orm['auth.Permission']",
                    "symmetrical": "False",
                    "blank": "True",
                },
            ),
            "username": (
                "django.db.models.fields.CharField",
                [],
                {"unique": "True", "max_length": "30"},
            ),
        },
        "contenttypes.contenttype": {
            "Meta": {
                "ordering": "('name',)",
                "unique_together": "(('app_label', 'model'),)",
                "object_name": "ContentType",
                "db_table": "'django_content_type'",
            },
            "app_label": (
                "django.db.models.fields.CharField",
                [],
                {"max_length": "100"},
            ),
            "id": ("django.db.models.fields.AutoField", [], {"primary_key": "True"}),
            "model": ("django.db.models.fields.CharField", [], {"max_length": "100"}),
            "name": ("django.db.models.fields.CharField", [], {"max_length": "100"}),
        },
        "umessages.message": {
            "Meta": {"ordering": "['-sent_at']", "object_name": "Message"},
            "body": ("django.db.models.fields.TextField", [], {}),
            "id": ("django.db.models.fields.AutoField", [], {"primary_key": "True"}),
            "recipients": (
                "django.db.models.fields.related.ManyToManyField",
                [],
                {
                    "related_name": "'received_messages'",
                    "symmetrical": "False",
                    "through": "orm['umessages.MessageRecipient']",
                    "to": "orm['auth.User']",
                },
            ),
            "sender": (
                "django.db.models.fields.related.ForeignKey",
                [],
                {"related_name": "'sent_messages'", "to": "orm['auth.User']"},
            ),
            "sender_deleted_at": (
                "django.db.models.fields.DateTimeField",
                [],
                {"null": "True", "blank": "True"},
            ),
            "sent_at": (
                "django.db.models.fields.DateTimeField",
                [],
                {"auto_now_add": "True", "blank": "True"},
            ),
        },
        "umessages.messagecontact": {
            "Meta": {
                "ordering": "['latest_message']",
                "unique_together": "(('um_from_user', 'um_to_user'),)",
                "object_name": "MessageContact",
            },
            "um_from_user": (
                "django.db.models.fields.related.ForeignKey",
                [],
                {"related_name": "'um_from_users'", "to": "orm['auth.User']"},
            ),
            "id": ("django.db.models.fields.AutoField", [], {"primary_key": "True"}),
            "latest_message": (
                "django.db.models.fields.related.ForeignKey",
                [],
                {"to": "orm['umessages.Message']"},
            ),
            "um_to_user": (
                "django.db.models.fields.related.ForeignKey",
                [],
                {"related_name": "'um_to_users'", "to": "orm['auth.User']"},
            ),
        },
        "umessages.messagerecipient": {
            "Meta": {"object_name": "MessageRecipient"},
            "deleted_at": (
                "django.db.models.fields.DateTimeField",
                [],
                {"null": "True", "blank": "True"},
            ),
            "id": ("django.db.models.fields.AutoField", [], {"primary_key": "True"}),
            "message": (
                "django.db.models.fields.related.ForeignKey",
                [],
                {"to": "orm['umessages.Message']"},
            ),
            "read_at": (
                "django.db.models.fields.DateTimeField",
                [],
                {"null": "True", "blank": "True"},
            ),
            "user": (
                "django.db.models.fields.related.ForeignKey",
                [],
                {"to": "orm['auth.User']"},
            ),
        },
    }

    complete_apps = ["umessages"]
