"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnSyntheticLocation = exports.CfnSyntheticLocationPropsStatus = exports.CfnSyntheticLocationPropsType = exports.toJson_CfnSyntheticLocationProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnSyntheticLocationProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnSyntheticLocationProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Type': obj.type,
        'Name': obj.name,
        'CountryCode': obj.countryCode,
        'RegionCode': obj.regionCode,
        'City': obj.city,
        'Latitude': obj.latitude,
        'Longitude': obj.longitude,
        'Status': obj.status,
        'Nodes': obj.nodes?.map(y => y),
        'AvailabilityLocationOutage': obj.availabilityLocationOutage,
        'AvailabilityNodeOutage': obj.availabilityNodeOutage,
        'LocationNodeOutageDelayInMinutes': obj.locationNodeOutageDelayInMinutes,
        'AvailabilityNotificationsEnabled': obj.availabilityNotificationsEnabled,
        'AutoUpdateChromium': obj.autoUpdateChromium,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnSyntheticLocationProps = toJson_CfnSyntheticLocationProps;
/* eslint-enable max-len, quote-props */
/**
 * Defines the actual set of fields depending on the value. See one of the following objects:
 *
 * PUBLIC -> PublicSyntheticLocation
 * PRIVATE -> PrivateSyntheticLocation
 * CLUSTER -> PrivateSyntheticLocation
 *
 * @schema CfnSyntheticLocationPropsType
 */
var CfnSyntheticLocationPropsType;
(function (CfnSyntheticLocationPropsType) {
    /** PUBLIC */
    CfnSyntheticLocationPropsType["PUBLIC"] = "PUBLIC";
    /** PRIVATE */
    CfnSyntheticLocationPropsType["PRIVATE"] = "PRIVATE";
    /** CLUSTER */
    CfnSyntheticLocationPropsType["CLUSTER"] = "CLUSTER";
})(CfnSyntheticLocationPropsType = exports.CfnSyntheticLocationPropsType || (exports.CfnSyntheticLocationPropsType = {}));
/**
 * The status of the location:
 *
 * ENABLED: The location is displayed as active in the UI. You can assign monitors to the location.
 * DISABLED: The location is displayed as inactive in the UI. You can't assign monitors to the location. Monitors already assigned to the location will stay there and will be executed from the location.
 * HIDDEN: The location is not displayed in the UI. You can't assign monitors to the location. You can only set location as HIDDEN when no monitor is assigned to it.
 *
 * @schema CfnSyntheticLocationPropsStatus
 */
var CfnSyntheticLocationPropsStatus;
(function (CfnSyntheticLocationPropsStatus) {
    /** ENABLED */
    CfnSyntheticLocationPropsStatus["ENABLED"] = "ENABLED";
    /** DISABLED */
    CfnSyntheticLocationPropsStatus["DISABLED"] = "DISABLED";
    /** HIDDEN */
    CfnSyntheticLocationPropsStatus["HIDDEN"] = "HIDDEN";
})(CfnSyntheticLocationPropsStatus = exports.CfnSyntheticLocationPropsStatus || (exports.CfnSyntheticLocationPropsStatus = {}));
/**
 * A CloudFormation `Dynatrace::Environment::SyntheticLocation`
 *
 * @cloudformationResource Dynatrace::Environment::SyntheticLocation
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-dynatrace-resource-providers.git
 */
class CfnSyntheticLocation extends cdk.CfnResource {
    /**
     * Create a new `Dynatrace::Environment::SyntheticLocation`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnSyntheticLocation.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnSyntheticLocationProps(props) });
        this.props = props;
        this.attrEntityId = cdk.Token.asString(this.getAtt('EntityId'));
    }
}
exports.CfnSyntheticLocation = CfnSyntheticLocation;
_a = JSII_RTTI_SYMBOL_1;
CfnSyntheticLocation[_a] = { fqn: "@cdk-cloudformation/dynatrace-environment-syntheticlocation.CfnSyntheticLocation", version: "1.0.0-alpha.7" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnSyntheticLocation.CFN_RESOURCE_TYPE_NAME = "Dynatrace::Environment::SyntheticLocation";
//# sourceMappingURL=data:application/json;base64,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