import { IResource, Resource } from 'aws-cdk-lib';
import { Construct } from 'constructs';
/**
 * (experimental) A parameter group.
 *
 * @experimental
 */
export interface IClusterParameterGroup extends IResource {
    /**
     * (experimental) The name of this parameter group.
     *
     * @experimental
     * @attribute true
     */
    readonly clusterParameterGroupName: string;
}
/**
 * A new cluster or instance parameter group
 */
declare abstract class ClusterParameterGroupBase extends Resource implements IClusterParameterGroup {
    /**
     * The name of the parameter group
     */
    abstract readonly clusterParameterGroupName: string;
}
/**
 * (experimental) Properties for a parameter group.
 *
 * @experimental
 */
export interface ClusterParameterGroupProps {
    /**
     * (experimental) Description for this parameter group.
     *
     * @default a CDK generated description
     * @experimental
     */
    readonly description?: string;
    /**
     * (experimental) The parameters in this parameter group.
     *
     * @experimental
     */
    readonly parameters: {
        [name: string]: string;
    };
}
/**
 * (experimental) A cluster parameter group.
 *
 * @experimental
 * @resource AWS::Redshift::ClusterParameterGroup
 */
export declare class ClusterParameterGroup extends ClusterParameterGroupBase {
    /**
     * (experimental) Imports a parameter group.
     *
     * @experimental
     */
    static fromClusterParameterGroupName(scope: Construct, id: string, clusterParameterGroupName: string): IClusterParameterGroup;
    /**
     * (experimental) The name of the parameter group.
     *
     * @experimental
     */
    readonly clusterParameterGroupName: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: ClusterParameterGroupProps);
}
export {};
