# Generated by Django 4.2.4 on 2024-03-13 04:24

from django.db import migrations, models
import django.db.models.deletion


def migrate_assigned_object_forward(apps, schema_editor):
    SupportContractAssignment = apps.get_model('netbox_lifecycle', 'SupportContractAssignment')
    LicenseAssignment = apps.get_model('netbox_lifecycle', 'LicenseAssignment')
    Device = apps.get_model('dcim', 'Device')
    ContentType = apps.get_model('contenttypes', 'ContentType')

    for assignment in SupportContractAssignment.objects.all():
        if assignment.assigned_object_type == ContentType.objects.get(app_label='dcim', model='device'):
            device = Device.objects.get(pk=assignment.assigned_object_id)
            assignment.device = device
            assignment.save()
        else:
            license_assignment = LicenseAssignment.objects.get(pk=assignment.assigned_object_id)
            assignment.device = license_assignment.device
            assignment.license = license_assignment
            assignment.save()


def migrate_assigned_object_reverse(apps, schema_editor):
    SupportContractAssignment = apps.get_model('netbox_lifecycle', 'SupportContractAssignment')
    ContentType = apps.get_model('contenttypes', 'ContentType')

    device_type = ContentType.objects.get(app_label='dcim', model='device')
    license_type = ContentType.objects.get(app_label='netbox_lifecycle', model='licenseassignment')

    for assignment in SupportContractAssignment.objects.all():
        if assignment.license is None:
            assignment.assigned_object_type = device_type
            assignment.assigned_object_id = assignment.device.pk
            assignment.save()
        else:
            assignment.assigned_object_id = license_type
            assignment.assigned_object_id = assignment.license.pk
            assignment.save()


class Migration(migrations.Migration):

    dependencies = [
        ('dcim', '0185_gfk_indexes'),
        ('netbox_lifecycle', '0010_licenseassignment_quantity'),
    ]

    operations = [
        migrations.AddField(
            model_name='supportcontractassignment',
            name='device',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='contracts', to='dcim.device'),
        ),
        migrations.AddField(
            model_name='supportcontractassignment',
            name='license',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='contracts', to='netbox_lifecycle.licenseassignment'),
        ),
        migrations.RunPython(migrate_assigned_object_forward, migrate_assigned_object_reverse),
        migrations.AlterModelOptions(
            name='supportcontractassignment',
            options={'ordering': ['contract', 'device', 'license']},
        ),
        migrations.RemoveConstraint(
            model_name='supportcontractassignment',
            name='netbox_lifecycle_supportcontractassignment_unique_assignments',
        ),
        migrations.RemoveConstraint(
            model_name='supportcontractassignment',
            name='netbox_lifecycle_supportcontractassignment_unique_assignment_null_sku',
        ),
        migrations.RemoveField(
            model_name='supportcontractassignment',
            name='assigned_object_id',
        ),
        migrations.RemoveField(
            model_name='supportcontractassignment',
            name='assigned_object_type',
        ),
    ]
