# Generated by Django 4.1.7 on 2023-05-11 01:35

from django.db import migrations, models
import django.db.models.deletion
import taggit.managers
import utilities.json


def migrate_to_assignments(apps, schema_editor):
    SupportContractDeviceAssignment = apps.get_model('netbox_lifecycle', 'SupportContractDeviceAssignment')
    SupportContract = apps.get_model('netbox_lifecycle', 'SupportContract')

    for contract in SupportContract.objects.all():
        for device in contract.devices.all():
            SupportContractDeviceAssignment.objects.create(contract=contract, device=device)


def migrate_from_assignments(apps, schema_editor):
    SupportContractDeviceAssignment = apps.get_model('netbox_lifecycle', 'SupportContractDeviceAssignment')

    for contract in SupportContractDeviceAssignment.objects.all():
        contract.contract.devices.add(contract.device)


class Migration(migrations.Migration):

    dependencies = [
        ('dcim', '0171_cabletermination_change_logging'),
        ('extras', '0092_delete_jobresult'),
        ('netbox_lifecycle', '0002_license_licenseassignment'),
    ]

    operations = [
        migrations.CreateModel(
            name='SupportContractDeviceAssignment',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('custom_field_data', models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder)),
                ('contract', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='netbox_lifecycle.supportcontract')),
                ('device', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dcim.device')),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
            ],
            options={
                'ordering': ['contract', 'device'],
            },
        ),
        migrations.RunPython(migrate_to_assignments, migrate_from_assignments),
        migrations.RemoveField(
            model_name='supportcontract',
            name='devices',
        ),
    ]
