# Generated by Django 4.1.7 on 2023-05-10 14:23

import dcim.models.devices
from django.db import migrations, models
import django.db.models.deletion
import taggit.managers
import utilities.json


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('dcim', '0171_cabletermination_change_logging'),
        ('contenttypes', '0002_remove_content_type_name'),
        ('extras', '0092_delete_jobresult'),
    ]

    operations = [
        migrations.CreateModel(
            name='Vendor',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('custom_field_data', models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder)),
                ('name', models.CharField(max_length=100)),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='SupportContract',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('custom_field_data', models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder)),
                ('contract_id', models.CharField(max_length=100)),
                ('start', models.DateField()),
                ('renewal', models.DateField()),
                ('end', models.DateField()),
                ('devices', models.ManyToManyField(blank=True, related_name='contracts', to='dcim.device')),
                ('manufacturer', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dcim.manufacturer')),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
                ('vendor', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='netbox_lifecycle.vendor')),
            ],
            options={
                'ordering': ['contract_id'],
            },
        ),
        migrations.CreateModel(
            name='HardwareLifecycle',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('custom_field_data', models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder)),
                ('assigned_object_id', models.PositiveBigIntegerField(blank=True, null=True)),
                ('end_of_sale', models.DateField()),
                ('end_of_maintenance', models.DateField(blank=True, null=True)),
                ('end_of_security', models.DateField(blank=True, null=True)),
                ('last_contract_date', models.DateField(blank=True, null=True)),
                ('end_of_support', models.DateField()),
                ('notice', models.CharField(blank=True, max_length=500, null=True)),
                ('documentation', models.CharField(blank=True, max_length=500, null=True)),
                ('assigned_object_type', models.ForeignKey(blank=True, limit_choices_to=(dcim.models.devices.DeviceType, dcim.models.devices.ModuleType), null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='contenttypes.contenttype')),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
