# autogenerated module
from typing import ClassVar

from ..core import resource as res
from ..models import authentication_v1 as m_authentication_v1
from ..models import autoscaling_v1 as m_autoscaling_v1
from ..models import core_v1 as m_core_v1
from ..models import policy_v1 as m_policy_v1


class ComponentStatus(res.GlobalResource, m_core_v1.ComponentStatus):
    """* **Extends**: ``models.core_v1.ComponentStatus``
       * **Type**: Global Resource
       * **Accepted client methods**: `get`, `list`, `watch`
    """
    _api_info = res.ApiInfo(
        resource=res.ResourceDef('', 'v1', 'ComponentStatus'),
        plural='componentstatuses',
        verbs=['get', 'list', 'watch'],
    )


class ConfigMap(res.NamespacedResourceG, m_core_v1.ConfigMap):
    """* **Extends**: ``models.core_v1.ConfigMap``
       * **Type**: Namespaced Resource
       * **Accepted client methods**: `delete`, `deletecollection`, `get`, `list` all, `watch` all, `list`, `patch`, `create`, `replace`, `watch`
    """
    _api_info = res.ApiInfo(
        resource=res.ResourceDef('', 'v1', 'ConfigMap'),
        plural='configmaps',
        verbs=['delete', 'deletecollection', 'get', 'global_list', 'global_watch', 'list', 'patch', 'post', 'put', 'watch'],
    )


class Endpoints(res.NamespacedResourceG, m_core_v1.Endpoints):
    """* **Extends**: ``models.core_v1.Endpoints``
       * **Type**: Namespaced Resource
       * **Accepted client methods**: `delete`, `deletecollection`, `get`, `list` all, `watch` all, `list`, `patch`, `create`, `replace`, `watch`
    """
    _api_info = res.ApiInfo(
        resource=res.ResourceDef('', 'v1', 'Endpoints'),
        plural='endpoints',
        verbs=['delete', 'deletecollection', 'get', 'global_list', 'global_watch', 'list', 'patch', 'post', 'put', 'watch'],
    )


class Event(res.NamespacedResourceG, m_core_v1.Event):
    """* **Extends**: ``models.core_v1.Event``
       * **Type**: Namespaced Resource
       * **Accepted client methods**: `delete`, `deletecollection`, `get`, `list` all, `watch` all, `list`, `patch`, `create`, `replace`, `watch`
    """
    _api_info = res.ApiInfo(
        resource=res.ResourceDef('', 'v1', 'Event'),
        plural='events',
        verbs=['delete', 'deletecollection', 'get', 'global_list', 'global_watch', 'list', 'patch', 'post', 'put', 'watch'],
    )


class LimitRange(res.NamespacedResourceG, m_core_v1.LimitRange):
    """* **Extends**: ``models.core_v1.LimitRange``
       * **Type**: Namespaced Resource
       * **Accepted client methods**: `delete`, `deletecollection`, `get`, `list` all, `watch` all, `list`, `patch`, `create`, `replace`, `watch`
    """
    _api_info = res.ApiInfo(
        resource=res.ResourceDef('', 'v1', 'LimitRange'),
        plural='limitranges',
        verbs=['delete', 'deletecollection', 'get', 'global_list', 'global_watch', 'list', 'patch', 'post', 'put', 'watch'],
    )


class NamespaceFinalize(res.GlobalSubResource, m_core_v1.Namespace):
    """* **Extends**: ``models.core_v1.Namespace``
       * **Type**: Global Resource
       * **Accepted client methods**: `replace`
    """
    _api_info = res.ApiInfo(
        resource=res.ResourceDef('', 'v1', 'Namespace'),
        parent=res.ResourceDef('', 'v1', 'Namespace'),
        plural='namespaces',
        verbs=['put'],
        action='finalize',
    )


class NamespaceStatus(res.GlobalSubResource, m_core_v1.Namespace):
    """* **Extends**: ``models.core_v1.Namespace``
       * **Type**: Global Resource
       * **Accepted client methods**: `get`, `patch`, `replace`
    """
    _api_info = res.ApiInfo(
        resource=res.ResourceDef('', 'v1', 'Namespace'),
        parent=res.ResourceDef('', 'v1', 'Namespace'),
        plural='namespaces',
        verbs=['get', 'patch', 'put'],
        action='status',
    )


class Namespace(res.GlobalResource, m_core_v1.Namespace):
    """* **Extends**: ``models.core_v1.Namespace``
       * **Type**: Global Resource
       * **Accepted client methods**: `delete`, `get`, `list`, `patch`, `create`, `replace`, `watch`

       **Subresources**:

       * **Finalize**: ``NamespaceFinalize``
       * **Status**: ``NamespaceStatus``
    """
    _api_info = res.ApiInfo(
        resource=res.ResourceDef('', 'v1', 'Namespace'),
        plural='namespaces',
        verbs=['delete', 'get', 'list', 'patch', 'post', 'put', 'watch'],
    )

    Finalize: ClassVar = NamespaceFinalize
    Status: ClassVar = NamespaceStatus


class Binding(res.NamespacedResource, m_core_v1.Binding):
    """* **Extends**: ``models.core_v1.Binding``
       * **Type**: Namespaced Resource
       * **Accepted client methods**: `create`
    """
    _api_info = res.ApiInfo(
        resource=res.ResourceDef('', 'v1', 'Binding'),
        plural='bindings',
        verbs=['post'],
    )


class PersistentVolumeClaimStatus(res.NamespacedSubResource, m_core_v1.PersistentVolumeClaim):
    """* **Extends**: ``models.core_v1.PersistentVolumeClaim``
       * **Type**: Namespaced Resource
       * **Accepted client methods**: `get`, `patch`, `replace`
    """
    _api_info = res.ApiInfo(
        resource=res.ResourceDef('', 'v1', 'PersistentVolumeClaim'),
        parent=res.ResourceDef('', 'v1', 'PersistentVolumeClaim'),
        plural='persistentvolumeclaims',
        verbs=['get', 'patch', 'put'],
        action='status',
    )


class PersistentVolumeClaim(res.NamespacedResourceG, m_core_v1.PersistentVolumeClaim):
    """* **Extends**: ``models.core_v1.PersistentVolumeClaim``
       * **Type**: Namespaced Resource
       * **Accepted client methods**: `delete`, `deletecollection`, `get`, `list` all, `watch` all, `list`, `patch`, `create`, `replace`, `watch`

       **Subresources**:

       * **Status**: ``PersistentVolumeClaimStatus``
    """
    _api_info = res.ApiInfo(
        resource=res.ResourceDef('', 'v1', 'PersistentVolumeClaim'),
        plural='persistentvolumeclaims',
        verbs=['delete', 'deletecollection', 'get', 'global_list', 'global_watch', 'list', 'patch', 'post', 'put', 'watch'],
    )

    Status: ClassVar = PersistentVolumeClaimStatus


class PodBinding(res.NamespacedSubResource, m_core_v1.Binding):
    """* **Extends**: ``models.core_v1.Binding``
       * **Type**: Namespaced Resource
       * **Accepted client methods**: `create`
    """
    _api_info = res.ApiInfo(
        resource=res.ResourceDef('', 'v1', 'Binding'),
        parent=res.ResourceDef('', 'v1', 'Pod'),
        plural='pods',
        verbs=['post'],
        action='binding',
    )


class PodEphemeralcontainers(res.NamespacedSubResource, m_core_v1.Pod):
    """* **Extends**: ``models.core_v1.Pod``
       * **Type**: Namespaced Resource
       * **Accepted client methods**: `get`, `patch`, `replace`
    """
    _api_info = res.ApiInfo(
        resource=res.ResourceDef('', 'v1', 'Pod'),
        parent=res.ResourceDef('', 'v1', 'Pod'),
        plural='pods',
        verbs=['get', 'patch', 'put'],
        action='ephemeralcontainers',
    )


class PodEviction(res.NamespacedSubResource, m_policy_v1.Eviction):
    """* **Extends**: ``models.policy_v1.Eviction``
       * **Type**: Namespaced Resource
       * **Accepted client methods**: `create`
    """
    _api_info = res.ApiInfo(
        resource=res.ResourceDef('policy', 'v1', 'Eviction'),
        parent=res.ResourceDef('', 'v1', 'Pod'),
        plural='pods',
        verbs=['post'],
        action='eviction',
    )


class PodLog(res.NamespacedSubResource):
    """* **Extends**: ``models.mespacedSubResource``
       * **Type**: Namespaced Resource
       * **Accepted client methods**: `get`
    """
    _api_info = res.ApiInfo(
        resource=res.ResourceDef('', 'v1', 'Pod'),
        parent=res.ResourceDef('', 'v1', 'Pod'),
        plural='pods',
        verbs=['get'],
        action='log',
    )


class PodStatus(res.NamespacedSubResource, m_core_v1.Pod):
    """* **Extends**: ``models.core_v1.Pod``
       * **Type**: Namespaced Resource
       * **Accepted client methods**: `get`, `patch`, `replace`
    """
    _api_info = res.ApiInfo(
        resource=res.ResourceDef('', 'v1', 'Pod'),
        parent=res.ResourceDef('', 'v1', 'Pod'),
        plural='pods',
        verbs=['get', 'patch', 'put'],
        action='status',
    )


class Pod(res.NamespacedResourceG, m_core_v1.Pod):
    """* **Extends**: ``models.core_v1.Pod``
       * **Type**: Namespaced Resource
       * **Accepted client methods**: `delete`, `deletecollection`, `get`, `list` all, `watch` all, `list`, `patch`, `create`, `replace`, `watch`

       **Subresources**:

       * **Binding**: ``PodBinding``
       * **Ephemeralcontainers**: ``PodEphemeralcontainers``
       * **Eviction**: ``PodEviction``
       * **Log**: ``PodLog``
       * **Status**: ``PodStatus``
    """
    _api_info = res.ApiInfo(
        resource=res.ResourceDef('', 'v1', 'Pod'),
        plural='pods',
        verbs=['delete', 'deletecollection', 'get', 'global_list', 'global_watch', 'list', 'patch', 'post', 'put', 'watch'],
    )

    Binding: ClassVar = PodBinding
    Ephemeralcontainers: ClassVar = PodEphemeralcontainers
    Eviction: ClassVar = PodEviction
    Log: ClassVar = PodLog
    Status: ClassVar = PodStatus


class PodTemplate(res.NamespacedResourceG, m_core_v1.PodTemplate):
    """* **Extends**: ``models.core_v1.PodTemplate``
       * **Type**: Namespaced Resource
       * **Accepted client methods**: `delete`, `deletecollection`, `get`, `list` all, `watch` all, `list`, `patch`, `create`, `replace`, `watch`
    """
    _api_info = res.ApiInfo(
        resource=res.ResourceDef('', 'v1', 'PodTemplate'),
        plural='podtemplates',
        verbs=['delete', 'deletecollection', 'get', 'global_list', 'global_watch', 'list', 'patch', 'post', 'put', 'watch'],
    )


class ReplicationControllerScale(res.NamespacedSubResource, m_autoscaling_v1.Scale):
    """* **Extends**: ``models.autoscaling_v1.Scale``
       * **Type**: Namespaced Resource
       * **Accepted client methods**: `get`, `patch`, `replace`
    """
    _api_info = res.ApiInfo(
        resource=res.ResourceDef('autoscaling', 'v1', 'Scale'),
        parent=res.ResourceDef('', 'v1', 'ReplicationController'),
        plural='replicationcontrollers',
        verbs=['get', 'patch', 'put'],
        action='scale',
    )


class ReplicationControllerStatus(res.NamespacedSubResource, m_core_v1.ReplicationController):
    """* **Extends**: ``models.core_v1.ReplicationController``
       * **Type**: Namespaced Resource
       * **Accepted client methods**: `get`, `patch`, `replace`
    """
    _api_info = res.ApiInfo(
        resource=res.ResourceDef('', 'v1', 'ReplicationController'),
        parent=res.ResourceDef('', 'v1', 'ReplicationController'),
        plural='replicationcontrollers',
        verbs=['get', 'patch', 'put'],
        action='status',
    )


class ReplicationController(res.NamespacedResourceG, m_core_v1.ReplicationController):
    """* **Extends**: ``models.core_v1.ReplicationController``
       * **Type**: Namespaced Resource
       * **Accepted client methods**: `delete`, `deletecollection`, `get`, `list` all, `watch` all, `list`, `patch`, `create`, `replace`, `watch`

       **Subresources**:

       * **Scale**: ``ReplicationControllerScale``
       * **Status**: ``ReplicationControllerStatus``
    """
    _api_info = res.ApiInfo(
        resource=res.ResourceDef('', 'v1', 'ReplicationController'),
        plural='replicationcontrollers',
        verbs=['delete', 'deletecollection', 'get', 'global_list', 'global_watch', 'list', 'patch', 'post', 'put', 'watch'],
    )

    Scale: ClassVar = ReplicationControllerScale
    Status: ClassVar = ReplicationControllerStatus


class ResourceQuotaStatus(res.NamespacedSubResource, m_core_v1.ResourceQuota):
    """* **Extends**: ``models.core_v1.ResourceQuota``
       * **Type**: Namespaced Resource
       * **Accepted client methods**: `get`, `patch`, `replace`
    """
    _api_info = res.ApiInfo(
        resource=res.ResourceDef('', 'v1', 'ResourceQuota'),
        parent=res.ResourceDef('', 'v1', 'ResourceQuota'),
        plural='resourcequotas',
        verbs=['get', 'patch', 'put'],
        action='status',
    )


class ResourceQuota(res.NamespacedResourceG, m_core_v1.ResourceQuota):
    """* **Extends**: ``models.core_v1.ResourceQuota``
       * **Type**: Namespaced Resource
       * **Accepted client methods**: `delete`, `deletecollection`, `get`, `list` all, `watch` all, `list`, `patch`, `create`, `replace`, `watch`

       **Subresources**:

       * **Status**: ``ResourceQuotaStatus``
    """
    _api_info = res.ApiInfo(
        resource=res.ResourceDef('', 'v1', 'ResourceQuota'),
        plural='resourcequotas',
        verbs=['delete', 'deletecollection', 'get', 'global_list', 'global_watch', 'list', 'patch', 'post', 'put', 'watch'],
    )

    Status: ClassVar = ResourceQuotaStatus


class Secret(res.NamespacedResourceG, m_core_v1.Secret):
    """* **Extends**: ``models.core_v1.Secret``
       * **Type**: Namespaced Resource
       * **Accepted client methods**: `delete`, `deletecollection`, `get`, `list` all, `watch` all, `list`, `patch`, `create`, `replace`, `watch`
    """
    _api_info = res.ApiInfo(
        resource=res.ResourceDef('', 'v1', 'Secret'),
        plural='secrets',
        verbs=['delete', 'deletecollection', 'get', 'global_list', 'global_watch', 'list', 'patch', 'post', 'put', 'watch'],
    )


class ServiceAccountToken(res.NamespacedSubResource, m_authentication_v1.TokenRequest):
    """* **Extends**: ``models.authentication_v1.TokenRequest``
       * **Type**: Namespaced Resource
       * **Accepted client methods**: `create`
    """
    _api_info = res.ApiInfo(
        resource=res.ResourceDef('authentication.k8s.io', 'v1', 'TokenRequest'),
        parent=res.ResourceDef('', 'v1', 'ServiceAccount'),
        plural='serviceaccounts',
        verbs=['post'],
        action='token',
    )


class ServiceAccount(res.NamespacedResourceG, m_core_v1.ServiceAccount):
    """* **Extends**: ``models.core_v1.ServiceAccount``
       * **Type**: Namespaced Resource
       * **Accepted client methods**: `delete`, `deletecollection`, `get`, `list` all, `watch` all, `list`, `patch`, `create`, `replace`, `watch`

       **Subresources**:

       * **Token**: ``ServiceAccountToken``
    """
    _api_info = res.ApiInfo(
        resource=res.ResourceDef('', 'v1', 'ServiceAccount'),
        plural='serviceaccounts',
        verbs=['delete', 'deletecollection', 'get', 'global_list', 'global_watch', 'list', 'patch', 'post', 'put', 'watch'],
    )

    Token: ClassVar = ServiceAccountToken


class ServiceStatus(res.NamespacedSubResource, m_core_v1.Service):
    """* **Extends**: ``models.core_v1.Service``
       * **Type**: Namespaced Resource
       * **Accepted client methods**: `get`, `patch`, `replace`
    """
    _api_info = res.ApiInfo(
        resource=res.ResourceDef('', 'v1', 'Service'),
        parent=res.ResourceDef('', 'v1', 'Service'),
        plural='services',
        verbs=['get', 'patch', 'put'],
        action='status',
    )


class Service(res.NamespacedResourceG, m_core_v1.Service):
    """* **Extends**: ``models.core_v1.Service``
       * **Type**: Namespaced Resource
       * **Accepted client methods**: `delete`, `deletecollection`, `get`, `list` all, `watch` all, `list`, `patch`, `create`, `replace`, `watch`

       **Subresources**:

       * **Status**: ``ServiceStatus``
    """
    _api_info = res.ApiInfo(
        resource=res.ResourceDef('', 'v1', 'Service'),
        plural='services',
        verbs=['delete', 'deletecollection', 'get', 'global_list', 'global_watch', 'list', 'patch', 'post', 'put', 'watch'],
    )

    Status: ClassVar = ServiceStatus


class NodeStatus(res.GlobalSubResource, m_core_v1.Node):
    """* **Extends**: ``models.core_v1.Node``
       * **Type**: Global Resource
       * **Accepted client methods**: `get`, `patch`, `replace`
    """
    _api_info = res.ApiInfo(
        resource=res.ResourceDef('', 'v1', 'Node'),
        parent=res.ResourceDef('', 'v1', 'Node'),
        plural='nodes',
        verbs=['get', 'patch', 'put'],
        action='status',
    )


class Node(res.GlobalResource, m_core_v1.Node):
    """* **Extends**: ``models.core_v1.Node``
       * **Type**: Global Resource
       * **Accepted client methods**: `delete`, `deletecollection`, `get`, `list`, `patch`, `create`, `replace`, `watch`

       **Subresources**:

       * **Status**: ``NodeStatus``
    """
    _api_info = res.ApiInfo(
        resource=res.ResourceDef('', 'v1', 'Node'),
        plural='nodes',
        verbs=['delete', 'deletecollection', 'get', 'list', 'patch', 'post', 'put', 'watch'],
    )

    Status: ClassVar = NodeStatus


class PersistentVolumeStatus(res.GlobalSubResource, m_core_v1.PersistentVolume):
    """* **Extends**: ``models.core_v1.PersistentVolume``
       * **Type**: Global Resource
       * **Accepted client methods**: `get`, `patch`, `replace`
    """
    _api_info = res.ApiInfo(
        resource=res.ResourceDef('', 'v1', 'PersistentVolume'),
        parent=res.ResourceDef('', 'v1', 'PersistentVolume'),
        plural='persistentvolumes',
        verbs=['get', 'patch', 'put'],
        action='status',
    )


class PersistentVolume(res.GlobalResource, m_core_v1.PersistentVolume):
    """* **Extends**: ``models.core_v1.PersistentVolume``
       * **Type**: Global Resource
       * **Accepted client methods**: `delete`, `deletecollection`, `get`, `list`, `patch`, `create`, `replace`, `watch`

       **Subresources**:

       * **Status**: ``PersistentVolumeStatus``
    """
    _api_info = res.ApiInfo(
        resource=res.ResourceDef('', 'v1', 'PersistentVolume'),
        plural='persistentvolumes',
        verbs=['delete', 'deletecollection', 'get', 'list', 'patch', 'post', 'put', 'watch'],
    )

    Status: ClassVar = PersistentVolumeStatus

