# autogenerated module
from dataclasses import dataclass, field
from typing import List

from ..core.dataclasses_dict import DataclassDictMixIn

from . import meta_v1
from . import core_v1


@dataclass
class AllocationResult(DataclassDictMixIn):
    """AllocationResult contains attributed of an allocated resource.

      **parameters**

      * **availableOnNodes** ``core_v1.NodeSelector`` - *(optional)* This field will get set by the resource driver after it has allocated the
        resource driver to inform the scheduler where it can schedule Pods using the
        ResourceClaim.
        Setting this field is optional. If null, the resource is available everywhere.
      * **resourceHandle** ``str`` - *(optional)* ResourceHandle contains arbitrary data returned by the driver after a
        successful allocation. This is opaque for Kubernetes. Driver documentation may
        explain to users how to interpret this data if needed.
        The maximum size of this field is 16KiB. This may get increased in the future,
        but not reduced.
      * **shareable** ``bool`` - *(optional)* Shareable determines whether the resource supports more than one consumer at a
        time.
    """
    availableOnNodes: 'core_v1.NodeSelector' = None
    resourceHandle: 'str' = None
    shareable: 'bool' = None


@dataclass
class PodScheduling(DataclassDictMixIn):
    """PodScheduling objects hold information that is needed to schedule a Pod with
      ResourceClaims that use "WaitForFirstConsumer" allocation mode.
      
      This is an alpha type and requires enabling the DynamicResourceAllocation
      feature gate.

      **parameters**

      * **spec** ``PodSchedulingSpec`` - Spec describes where resources for the Pod are needed.
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ObjectMeta`` - *(optional)* Standard object metadata
      * **status** ``PodSchedulingStatus`` - *(optional)* Status describes where resources for the Pod can be allocated.
    """
    spec: 'PodSchedulingSpec'
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ObjectMeta' = None
    status: 'PodSchedulingStatus' = None


@dataclass
class PodSchedulingList(DataclassDictMixIn):
    """PodSchedulingList is a collection of Pod scheduling objects.

      **parameters**

      * **items** ``List[PodScheduling]`` - Items is the list of PodScheduling objects.
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ListMeta`` - *(optional)* Standard list metadata
    """
    items: 'List[PodScheduling]'
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ListMeta' = None


@dataclass
class PodSchedulingSpec(DataclassDictMixIn):
    """PodSchedulingSpec describes where resources for the Pod are needed.

      **parameters**

      * **potentialNodes** ``List[str]`` - *(optional)* PotentialNodes lists nodes where the Pod might be able to run.
        The size of this field is limited to 128. This is large enough for many
        clusters. Larger clusters may need more attempts to find a node that suits all
        pending resources. This may get increased in the future, but not reduced.
      * **selectedNode** ``str`` - *(optional)* SelectedNode is the node for which allocation of ResourceClaims that are
        referenced by the Pod and that use "WaitForFirstConsumer" allocation is to be
        attempted.
    """
    potentialNodes: 'List[str]' = None
    selectedNode: 'str' = None


@dataclass
class PodSchedulingStatus(DataclassDictMixIn):
    """PodSchedulingStatus describes where resources for the Pod can be allocated.

      **parameters**

      * **resourceClaims** ``List[ResourceClaimSchedulingStatus]`` - *(optional)* ResourceClaims describes resource availability for each pod.spec.resourceClaim
        entry where the corresponding ResourceClaim uses "WaitForFirstConsumer"
        allocation mode.
    """
    resourceClaims: 'List[ResourceClaimSchedulingStatus]' = None


@dataclass
class ResourceClaim(DataclassDictMixIn):
    """ResourceClaim describes which resources are needed by a resource consumer. Its
      status tracks whether the resource has been allocated and what the resulting
      attributes are.
      
      This is an alpha type and requires enabling the DynamicResourceAllocation
      feature gate.

      **parameters**

      * **spec** ``ResourceClaimSpec`` - Spec describes the desired attributes of a resource that then needs to be
        allocated. It can only be set once when creating the ResourceClaim.
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ObjectMeta`` - *(optional)* Standard object metadata
      * **status** ``ResourceClaimStatus`` - *(optional)* Status describes whether the resource is available and with which attributes.
    """
    spec: 'ResourceClaimSpec'
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ObjectMeta' = None
    status: 'ResourceClaimStatus' = None


@dataclass
class ResourceClaimConsumerReference(DataclassDictMixIn):
    """ResourceClaimConsumerReference contains enough information to let you locate
      the consumer of a ResourceClaim. The user must be a resource in the same
      namespace as the ResourceClaim.

      **parameters**

      * **name** ``str`` - Name is the name of resource being referenced.
      * **resource** ``str`` - Resource is the type of resource being referenced, for example "pods".
      * **uid** ``str`` - UID identifies exactly one incarnation of the resource.
      * **apiGroup** ``str`` - *(optional)* APIGroup is the group for the resource being referenced. It is empty for the
        core API. This matches the group in the APIVersion that is used when creating
        the resources.
    """
    name: 'str'
    resource: 'str'
    uid: 'str'
    apiGroup: 'str' = None


@dataclass
class ResourceClaimList(DataclassDictMixIn):
    """ResourceClaimList is a collection of claims.

      **parameters**

      * **items** ``List[ResourceClaim]`` - Items is the list of resource claims.
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ListMeta`` - *(optional)* Standard list metadata
    """
    items: 'List[ResourceClaim]'
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ListMeta' = None


@dataclass
class ResourceClaimParametersReference(DataclassDictMixIn):
    """ResourceClaimParametersReference contains enough information to let you locate
      the parameters for a ResourceClaim. The object must be in the same namespace
      as the ResourceClaim.

      **parameters**

      * **kind** ``str`` - Kind is the type of resource being referenced. This is the same value as in
        the parameter object's metadata, for example "ConfigMap".
      * **name** ``str`` - Name is the name of resource being referenced.
      * **apiGroup** ``str`` - *(optional)* APIGroup is the group for the resource being referenced. It is empty for the
        core API. This matches the group in the APIVersion that is used when creating
        the resources.
    """
    kind: 'str'
    name: 'str'
    apiGroup: 'str' = None


@dataclass
class ResourceClaimSchedulingStatus(DataclassDictMixIn):
    """ResourceClaimSchedulingStatus contains information about one particular
      ResourceClaim with "WaitForFirstConsumer" allocation mode.

      **parameters**

      * **name** ``str`` - *(optional)* Name matches the pod.spec.resourceClaims[*].Name field.
      * **unsuitableNodes** ``List[str]`` - *(optional)* UnsuitableNodes lists nodes that the ResourceClaim cannot be allocated for.
        The size of this field is limited to 128, the same as for
        PodSchedulingSpec.PotentialNodes. This may get increased in the future, but
        not reduced.
    """
    name: 'str' = None
    unsuitableNodes: 'List[str]' = None


@dataclass
class ResourceClaimSpec(DataclassDictMixIn):
    """ResourceClaimSpec defines how a resource is to be allocated.

      **parameters**

      * **resourceClassName** ``str`` - ResourceClassName references the driver and additional parameters via the name
        of a ResourceClass that was created as part of the driver deployment.
      * **allocationMode** ``str`` - *(optional)* Allocation can start immediately or when a Pod wants to use the resource.
        "WaitForFirstConsumer" is the default.
      * **parametersRef** ``ResourceClaimParametersReference`` - *(optional)* ParametersRef references a separate object with arbitrary parameters that will
        be used by the driver when allocating a resource for the claim.
        The object must be in the same namespace as the ResourceClaim.
    """
    resourceClassName: 'str'
    allocationMode: 'str' = None
    parametersRef: 'ResourceClaimParametersReference' = None


@dataclass
class ResourceClaimStatus(DataclassDictMixIn):
    """ResourceClaimStatus tracks whether the resource has been allocated and what
      the resulting attributes are.

      **parameters**

      * **allocation** ``AllocationResult`` - *(optional)* Allocation is set by the resource driver once a resource has been allocated
        successfully. If this is not specified, the resource is not yet allocated.
      * **deallocationRequested** ``bool`` - *(optional)* DeallocationRequested indicates that a ResourceClaim is to be deallocated.
        The driver then must deallocate this claim and reset the field together with
        clearing the Allocation field.
        While DeallocationRequested is set, no new consumers may be added to
        ReservedFor.
      * **driverName** ``str`` - *(optional)* DriverName is a copy of the driver name from the ResourceClass at the time
        when allocation started.
      * **reservedFor** ``List[ResourceClaimConsumerReference]`` - *(optional)* ReservedFor indicates which entities are currently allowed to use the claim. A
        Pod which references a ResourceClaim which is not reserved for that Pod will
        not be started.
        There can be at most 32 such reservations. This may get increased in the
        future, but not reduced.
    """
    allocation: 'AllocationResult' = None
    deallocationRequested: 'bool' = None
    driverName: 'str' = None
    reservedFor: 'List[ResourceClaimConsumerReference]' = None


@dataclass
class ResourceClaimTemplate(DataclassDictMixIn):
    """ResourceClaimTemplate is used to produce ResourceClaim objects.

      **parameters**

      * **spec** ``ResourceClaimTemplateSpec`` - Describes the ResourceClaim that is to be generated.
        This field is immutable. A ResourceClaim will get created by the control plane
        for a Pod when needed and then not get updated anymore.
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ObjectMeta`` - *(optional)* Standard object metadata
    """
    spec: 'ResourceClaimTemplateSpec'
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ObjectMeta' = None


@dataclass
class ResourceClaimTemplateList(DataclassDictMixIn):
    """ResourceClaimTemplateList is a collection of claim templates.

      **parameters**

      * **items** ``List[ResourceClaimTemplate]`` - Items is the list of resource claim templates.
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ListMeta`` - *(optional)* Standard list metadata
    """
    items: 'List[ResourceClaimTemplate]'
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ListMeta' = None


@dataclass
class ResourceClaimTemplateSpec(DataclassDictMixIn):
    """ResourceClaimTemplateSpec contains the metadata and fields for a
      ResourceClaim.

      **parameters**

      * **spec** ``ResourceClaimSpec`` - Spec for the ResourceClaim. The entire content is copied unchanged into the
        ResourceClaim that gets created from this template. The same fields as in a
        ResourceClaim are also valid here.
      * **metadata** ``meta_v1.ObjectMeta`` - *(optional)* ObjectMeta may contain labels and annotations that will be copied into the PVC
        when creating it. No other fields are allowed and will be rejected during
        validation.
    """
    spec: 'ResourceClaimSpec'
    metadata: 'meta_v1.ObjectMeta' = None


@dataclass
class ResourceClass(DataclassDictMixIn):
    """ResourceClass is used by administrators to influence how resources are
      allocated.
      
      This is an alpha type and requires enabling the DynamicResourceAllocation
      feature gate.

      **parameters**

      * **driverName** ``str`` - DriverName defines the name of the dynamic resource driver that is used for
        allocation of a ResourceClaim that uses this class.
        Resource drivers have a unique name in forward domain order
        (acme.example.com).
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ObjectMeta`` - *(optional)* Standard object metadata
      * **parametersRef** ``ResourceClassParametersReference`` - *(optional)* ParametersRef references an arbitrary separate object that may hold parameters
        that will be used by the driver when allocating a resource that uses this
        class. A dynamic resource driver can distinguish between parameters stored
        here and and those stored in ResourceClaimSpec.
      * **suitableNodes** ``core_v1.NodeSelector`` - *(optional)* Only nodes matching the selector will be considered by the scheduler when
        trying to find a Node that fits a Pod when that Pod uses a ResourceClaim that
        has not been allocated yet.
        Setting this field is optional. If null, all nodes are candidates.
    """
    driverName: 'str'
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ObjectMeta' = None
    parametersRef: 'ResourceClassParametersReference' = None
    suitableNodes: 'core_v1.NodeSelector' = None


@dataclass
class ResourceClassList(DataclassDictMixIn):
    """ResourceClassList is a collection of classes.

      **parameters**

      * **items** ``List[ResourceClass]`` - Items is the list of resource classes.
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ListMeta`` - *(optional)* Standard list metadata
    """
    items: 'List[ResourceClass]'
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ListMeta' = None


@dataclass
class ResourceClassParametersReference(DataclassDictMixIn):
    """ResourceClassParametersReference contains enough information to let you locate
      the parameters for a ResourceClass.

      **parameters**

      * **kind** ``str`` - Kind is the type of resource being referenced. This is the same value as in
        the parameter object's metadata.
      * **name** ``str`` - Name is the name of resource being referenced.
      * **apiGroup** ``str`` - *(optional)* APIGroup is the group for the resource being referenced. It is empty for the
        core API. This matches the group in the APIVersion that is used when creating
        the resources.
      * **namespace** ``str`` - *(optional)* Namespace that contains the referenced resource. Must be empty for
        cluster-scoped resources and non-empty for namespaced resources.
    """
    kind: 'str'
    name: 'str'
    apiGroup: 'str' = None
    namespace: 'str' = None


