# autogenerated module
from dataclasses import dataclass, field
from typing import List

from ..core.dataclasses_dict import DataclassDictMixIn

from . import util_intstr
from . import meta_v1


@dataclass
class Eviction(DataclassDictMixIn):
    """Eviction evicts a pod from its node subject to certain policies and safety
      constraints. This is a subresource of Pod.  A request to cause such an
      eviction is created by POSTing to .../pods/<pod name>/evictions.

      **parameters**

      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **deleteOptions** ``meta_v1.DeleteOptions`` - *(optional)* DeleteOptions may be provided
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ObjectMeta`` - *(optional)* ObjectMeta describes the pod that is being evicted.
    """
    apiVersion: 'str' = None
    deleteOptions: 'meta_v1.DeleteOptions' = None
    kind: 'str' = None
    metadata: 'meta_v1.ObjectMeta' = None


@dataclass
class PodDisruptionBudget(DataclassDictMixIn):
    """PodDisruptionBudget is an object to define the max disruption that can be
      caused to a collection of pods

      **parameters**

      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ObjectMeta`` - *(optional)* Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **spec** ``PodDisruptionBudgetSpec`` - *(optional)* Specification of the desired behavior of the PodDisruptionBudget.
      * **status** ``PodDisruptionBudgetStatus`` - *(optional)* Most recently observed status of the PodDisruptionBudget.
    """
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ObjectMeta' = None
    spec: 'PodDisruptionBudgetSpec' = None
    status: 'PodDisruptionBudgetStatus' = None


@dataclass
class PodDisruptionBudgetList(DataclassDictMixIn):
    """PodDisruptionBudgetList is a collection of PodDisruptionBudgets.

      **parameters**

      * **items** ``List[PodDisruptionBudget]`` - Items is a list of PodDisruptionBudgets
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ListMeta`` - *(optional)* Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    items: 'List[PodDisruptionBudget]'
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ListMeta' = None


@dataclass
class PodDisruptionBudgetSpec(DataclassDictMixIn):
    """PodDisruptionBudgetSpec is a description of a PodDisruptionBudget.

      **parameters**

      * **maxUnavailable** ``util_intstr.IntOrString`` - *(optional)* An eviction is allowed if at most "maxUnavailable" pods selected by "selector"
        are unavailable after the eviction, i.e. even in absence of the evicted pod.
        For example, one can prevent all voluntary evictions by specifying 0. This is
        a mutually exclusive setting with "minAvailable".
      * **minAvailable** ``util_intstr.IntOrString`` - *(optional)* An eviction is allowed if at least "minAvailable" pods selected by "selector"
        will still be available after the eviction, i.e. even in the absence of the
        evicted pod.  So for example you can prevent all voluntary evictions by
        specifying "100%".
      * **selector** ``meta_v1.LabelSelector`` - *(optional)* Label query over pods whose evictions are managed by the disruption budget. A
        null selector will match no pods, while an empty ({}) selector will select all
        pods within the namespace.
      * **unhealthyPodEvictionPolicy** ``str`` - *(optional)* UnhealthyPodEvictionPolicy defines the criteria for when unhealthy pods should
        be considered for eviction. Current implementation considers healthy pods, as
        pods that have status.conditions item with type="Ready",status="True".
        Valid policies are IfHealthyBudget and AlwaysAllow. If no policy is specified,
        the default behavior will be used, which corresponds to the IfHealthyBudget
        policy.
        IfHealthyBudget policy means that running pods (status.phase="Running"), but
        not yet healthy can be evicted only if the guarded application is not
        disrupted (status.currentHealthy is at least equal to status.desiredHealthy).
        Healthy pods will be subject to the PDB for eviction.
        AlwaysAllow policy means that all running pods (status.phase="Running"), but
        not yet healthy are considered disrupted and can be evicted regardless of
        whether the criteria in a PDB is met. This means perspective running pods of a
        disrupted application might not get a chance to become healthy. Healthy pods
        will be subject to the PDB for eviction.
        Additional policies may be added in the future. Clients making eviction
        decisions should disallow eviction of unhealthy pods if they encounter an
        unrecognized policy in this field.
        This field is alpha-level. The eviction API uses this field when the feature
        gate PDBUnhealthyPodEvictionPolicy is enabled (disabled by default).
    """
    maxUnavailable: 'util_intstr.IntOrString' = None
    minAvailable: 'util_intstr.IntOrString' = None
    selector: 'meta_v1.LabelSelector' = None
    unhealthyPodEvictionPolicy: 'str' = None


@dataclass
class PodDisruptionBudgetStatus(DataclassDictMixIn):
    """PodDisruptionBudgetStatus represents information about the status of a
      PodDisruptionBudget. Status may trail the actual state of a system.

      **parameters**

      * **currentHealthy** ``int`` - current number of healthy pods
      * **desiredHealthy** ``int`` - minimum desired number of healthy pods
      * **disruptionsAllowed** ``int`` - Number of pod disruptions that are currently allowed.
      * **expectedPods** ``int`` - total number of pods counted by this disruption budget
      * **conditions** ``List[meta_v1.Condition]`` - *(optional)* Conditions contain conditions for PDB. The disruption controller sets the
        DisruptionAllowed condition. The following are known values for the reason
        field (additional reasons could be added in the future): - SyncFailed: The
        controller encountered an error and wasn't able to compute
                      the number of allowed disruptions. Therefore no disruptions are
                      allowed and the status of the condition will be False.
        - InsufficientPods: The number of pods are either at or below the number
                            required by the PodDisruptionBudget. No disruptions are
                            allowed and the status of the condition will be False.
        - SufficientPods: There are more pods than required by the
        PodDisruptionBudget.
                          The condition will be True, and the number of allowed
                          disruptions are provided by the disruptionsAllowed property.
      * **disruptedPods** ``dict`` - *(optional)* DisruptedPods contains information about pods whose eviction was processed by
        the API server eviction subresource handler but has not yet been observed by
        the PodDisruptionBudget controller. A pod will be in this map from the time
        when the API server processed the eviction request to the time when the pod is
        seen by PDB controller as having been marked for deletion (or after a
        timeout). The key in the map is the name of the pod and the value is the time
        when the API server processed the eviction request. If the deletion didn't
        occur and a pod is still there it will be removed from the list automatically
        by PodDisruptionBudget controller after some time. If everything goes smooth
        this map should be empty for the most of the time. Large number of entries in
        the map may indicate problems with pod deletions.
      * **observedGeneration** ``int`` - *(optional)* Most recent generation observed when updating this PDB status.
        DisruptionsAllowed and other status information is valid only if
        observedGeneration equals to PDB's object generation.
    """
    currentHealthy: 'int'
    desiredHealthy: 'int'
    disruptionsAllowed: 'int'
    expectedPods: 'int'
    conditions: 'List[meta_v1.Condition]' = None
    disruptedPods: 'dict' = None
    observedGeneration: 'int' = None


