# autogenerated module
from dataclasses import dataclass, field
from typing import List

from ..core.dataclasses_dict import DataclassDictMixIn

from . import core_v1
from . import meta_v1


@dataclass
class Event(DataclassDictMixIn):
    """Event is a report of an event somewhere in the cluster. It generally denotes
      some state change in the system. Events have a limited retention time and
      triggers and messages may evolve with time.  Event consumers should not rely
      on the timing of an event with a given Reason reflecting a consistent
      underlying trigger, or the continued existence of events with that Reason.
      Events should be treated as informative, best-effort, supplemental data.

      **parameters**

      * **eventTime** ``meta_v1.MicroTime`` - eventTime is the time when this Event was first observed. It is required.
      * **action** ``str`` - *(optional)* action is what action was taken/failed regarding to the regarding object. It
        is machine-readable. This field cannot be empty for new Events and it can have
        at most 128 characters.
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **deprecatedCount** ``int`` - *(optional)* deprecatedCount is the deprecated field assuring backward compatibility with
        core.v1 Event type.
      * **deprecatedFirstTimestamp** ``meta_v1.Time`` - *(optional)* deprecatedFirstTimestamp is the deprecated field assuring backward
        compatibility with core.v1 Event type.
      * **deprecatedLastTimestamp** ``meta_v1.Time`` - *(optional)* deprecatedLastTimestamp is the deprecated field assuring backward
        compatibility with core.v1 Event type.
      * **deprecatedSource** ``core_v1.EventSource`` - *(optional)* deprecatedSource is the deprecated field assuring backward compatibility with
        core.v1 Event type.
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ObjectMeta`` - *(optional)* Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **note** ``str`` - *(optional)* note is a human-readable description of the status of this operation. Maximal
        length of the note is 1kB, but libraries should be prepared to handle values
        up to 64kB.
      * **reason** ``str`` - *(optional)* reason is why the action was taken. It is human-readable. This field cannot be
        empty for new Events and it can have at most 128 characters.
      * **regarding** ``core_v1.ObjectReference`` - *(optional)* regarding contains the object this Event is about. In most cases it's an
        Object reporting controller implements, e.g. ReplicaSetController implements
        ReplicaSets and this event is emitted because it acts on some changes in a
        ReplicaSet object.
      * **related** ``core_v1.ObjectReference`` - *(optional)* related is the optional secondary object for more complex actions. E.g. when
        regarding object triggers a creation or deletion of related object.
      * **reportingController** ``str`` - *(optional)* reportingController is the name of the controller that emitted this Event,
        e.g. `kubernetes.io/kubelet`. This field cannot be empty for new Events.
      * **reportingInstance** ``str`` - *(optional)* reportingInstance is the ID of the controller instance, e.g. `kubelet-xyzf`.
        This field cannot be empty for new Events and it can have at most 128
        characters.
      * **series** ``EventSeries`` - *(optional)* series is data about the Event series this event represents or nil if it's a
        singleton Event.
      * **type** ``str`` - *(optional)* type is the type of this event (Normal, Warning), new types could be added in
        the future. It is machine-readable. This field cannot be empty for new Events.
    """
    eventTime: 'meta_v1.MicroTime'
    action: 'str' = None
    apiVersion: 'str' = None
    deprecatedCount: 'int' = None
    deprecatedFirstTimestamp: 'meta_v1.Time' = None
    deprecatedLastTimestamp: 'meta_v1.Time' = None
    deprecatedSource: 'core_v1.EventSource' = None
    kind: 'str' = None
    metadata: 'meta_v1.ObjectMeta' = None
    note: 'str' = None
    reason: 'str' = None
    regarding: 'core_v1.ObjectReference' = None
    related: 'core_v1.ObjectReference' = None
    reportingController: 'str' = None
    reportingInstance: 'str' = None
    series: 'EventSeries' = None
    type: 'str' = None


@dataclass
class EventList(DataclassDictMixIn):
    """EventList is a list of Event objects.

      **parameters**

      * **items** ``List[Event]`` - items is a list of schema objects.
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ListMeta`` - *(optional)* Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    items: 'List[Event]'
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ListMeta' = None


@dataclass
class EventSeries(DataclassDictMixIn):
    """EventSeries contain information on series of events, i.e. thing that was/is
      happening continuously for some time. How often to update the EventSeries is
      up to the event reporters. The default event reporter in
      "k8s.io/client-go/tools/events/event_broadcaster.go" shows how this struct is
      updated on heartbeats and can guide customized reporter implementations.

      **parameters**

      * **count** ``int`` - count is the number of occurrences in this series up to the last heartbeat
        time.
      * **lastObservedTime** ``meta_v1.MicroTime`` - lastObservedTime is the time when last Event from the series was seen before
        last heartbeat.
    """
    count: 'int'
    lastObservedTime: 'meta_v1.MicroTime'


