class GlueModelObject {
    constructor(glue_unique_name) {
        // Needs to be named glue_unique_name to avoid overriding the unique_name property
        this.glue_unique_name = glue_unique_name

        for (let key in window.glue_session_data['context'][glue_unique_name].fields) {
            this[key] = window.glue_session_data['context'][glue_unique_name].fields[key].value
        }

        window.glue_keep_live.add_unique_name(glue_unique_name)
    }

    delete() {
        glue_ajax_request(
            this.glue_unique_name,
            'delete'
        ).then((response) => {
            console.log(response)
            glue_dispatch_response_event(response)
        })
    }

    async get() {
        await glue_ajax_request(
            this.glue_unique_name,
            'get'
        ).then((response) => {
            console.log(response)
            glue_dispatch_response_event(response)
            this.set_properties(response.data.simple_fields)
        })
    }

    async method(method, kwargs = {}) {
        let data = {
            'method': method,
            'kwargs': kwargs,
        }

        return await glue_ajax_request(
            this.glue_unique_name,
            'method',
            data
        ).then((response) => {
            console.log(response)
            glue_dispatch_response_event(response)
            return response.data.method_return
        })
    }

    async update(field = null) {
        await glue_ajax_request(
            this.glue_unique_name,
            'update',
            this.get_properties()
        ).then((response) => {
            glue_dispatch_response_event(response)
            console.log(response)
        })
    }

    get_properties() {
        let properties = {}
        Object.entries(this).forEach(([key, value]) => {
            properties[key] = value
        });
        return properties
    }

    set_properties(properties) {
        for (let key in properties) {
            this[key] = properties[key]
        }
    }

}
