"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _0;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnWorkteam = exports.CfnUserProfile = exports.CfnProject = exports.CfnPipeline = exports.CfnNotebookInstanceLifecycleConfig = exports.CfnNotebookInstance = exports.CfnMonitoringSchedule = exports.CfnModelQualityJobDefinition = exports.CfnModelPackageGroup = exports.CfnModelPackage = exports.CfnModelExplainabilityJobDefinition = exports.CfnModelBiasJobDefinition = exports.CfnModel = exports.CfnImageVersion = exports.CfnImage = exports.CfnFeatureGroup = exports.CfnEndpointConfig = exports.CfnEndpoint = exports.CfnDomain = exports.CfnDeviceFleet = exports.CfnDevice = exports.CfnDataQualityJobDefinition = exports.CfnCodeRepository = exports.CfnAppImageConfig = exports.CfnApp = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright 2012-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2022-12-30T15:36:17.109Z","fingerprint":"VhTHvO9bojhkFZJYYiQNa2/IWxgXRF6/opRjnh6ripk="}
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("@aws-cdk/core");
const cfn_parse = require("@aws-cdk/core/lib/helpers-internal");
/**
 * Determine whether the given properties match those of a `CfnAppProps`
 *
 * @param properties - the TypeScript properties of a `CfnAppProps`
 *
 * @returns the result of the validation.
 */
function CfnAppPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('appName', cdk.requiredValidator)(properties.appName));
    errors.collect(cdk.propertyValidator('appName', cdk.validateString)(properties.appName));
    errors.collect(cdk.propertyValidator('appType', cdk.requiredValidator)(properties.appType));
    errors.collect(cdk.propertyValidator('appType', cdk.validateString)(properties.appType));
    errors.collect(cdk.propertyValidator('domainId', cdk.requiredValidator)(properties.domainId));
    errors.collect(cdk.propertyValidator('domainId', cdk.validateString)(properties.domainId));
    errors.collect(cdk.propertyValidator('resourceSpec', CfnApp_ResourceSpecPropertyValidator)(properties.resourceSpec));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('userProfileName', cdk.requiredValidator)(properties.userProfileName));
    errors.collect(cdk.propertyValidator('userProfileName', cdk.validateString)(properties.userProfileName));
    return errors.wrap('supplied properties not correct for "CfnAppProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::App` resource
 *
 * @param properties - the TypeScript properties of a `CfnAppProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::App` resource.
 */
// @ts-ignore TS6133
function cfnAppPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAppPropsValidator(properties).assertSuccess();
    return {
        AppName: cdk.stringToCloudFormation(properties.appName),
        AppType: cdk.stringToCloudFormation(properties.appType),
        DomainId: cdk.stringToCloudFormation(properties.domainId),
        UserProfileName: cdk.stringToCloudFormation(properties.userProfileName),
        ResourceSpec: cfnAppResourceSpecPropertyToCloudFormation(properties.resourceSpec),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnAppPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('appName', 'AppName', cfn_parse.FromCloudFormation.getString(properties.AppName));
    ret.addPropertyResult('appType', 'AppType', cfn_parse.FromCloudFormation.getString(properties.AppType));
    ret.addPropertyResult('domainId', 'DomainId', cfn_parse.FromCloudFormation.getString(properties.DomainId));
    ret.addPropertyResult('userProfileName', 'UserProfileName', cfn_parse.FromCloudFormation.getString(properties.UserProfileName));
    ret.addPropertyResult('resourceSpec', 'ResourceSpec', properties.ResourceSpec != null ? CfnAppResourceSpecPropertyFromCloudFormation(properties.ResourceSpec) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::SageMaker::App`
 *
 * Creates a running app for the specified UserProfile. This operation is automatically invoked by Amazon SageMaker Studio upon access to the associated Domain, and when new kernel configurations are selected by the user. A user may have multiple Apps active simultaneously.
 *
 * @cloudformationResource AWS::SageMaker::App
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html
 */
class CfnApp extends cdk.CfnResource {
    /**
     * Create a new `AWS::SageMaker::App`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnApp.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_sagemaker_CfnAppProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnApp);
            }
            throw error;
        }
        cdk.requireProperty(props, 'appName', this);
        cdk.requireProperty(props, 'appType', this);
        cdk.requireProperty(props, 'domainId', this);
        cdk.requireProperty(props, 'userProfileName', this);
        this.attrAppArn = cdk.Token.asString(this.getAtt('AppArn'));
        this.appName = props.appName;
        this.appType = props.appType;
        this.domainId = props.domainId;
        this.userProfileName = props.userProfileName;
        this.resourceSpec = props.resourceSpec;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::SageMaker::App", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnAppPropsFromCloudFormation(resourceProperties);
        const ret = new CfnApp(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnApp.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            appName: this.appName,
            appType: this.appType,
            domainId: this.domainId,
            userProfileName: this.userProfileName,
            resourceSpec: this.resourceSpec,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnAppPropsToCloudFormation(props);
    }
}
exports.CfnApp = CfnApp;
_a = JSII_RTTI_SYMBOL_1;
CfnApp[_a] = { fqn: "@aws-cdk/aws-sagemaker.CfnApp", version: "1.186.1" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnApp.CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::App";
/**
 * Determine whether the given properties match those of a `ResourceSpecProperty`
 *
 * @param properties - the TypeScript properties of a `ResourceSpecProperty`
 *
 * @returns the result of the validation.
 */
function CfnApp_ResourceSpecPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('instanceType', cdk.validateString)(properties.instanceType));
    errors.collect(cdk.propertyValidator('sageMakerImageArn', cdk.validateString)(properties.sageMakerImageArn));
    errors.collect(cdk.propertyValidator('sageMakerImageVersionArn', cdk.validateString)(properties.sageMakerImageVersionArn));
    return errors.wrap('supplied properties not correct for "ResourceSpecProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::App.ResourceSpec` resource
 *
 * @param properties - the TypeScript properties of a `ResourceSpecProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::App.ResourceSpec` resource.
 */
// @ts-ignore TS6133
function cfnAppResourceSpecPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnApp_ResourceSpecPropertyValidator(properties).assertSuccess();
    return {
        InstanceType: cdk.stringToCloudFormation(properties.instanceType),
        SageMakerImageArn: cdk.stringToCloudFormation(properties.sageMakerImageArn),
        SageMakerImageVersionArn: cdk.stringToCloudFormation(properties.sageMakerImageVersionArn),
    };
}
// @ts-ignore TS6133
function CfnAppResourceSpecPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('instanceType', 'InstanceType', properties.InstanceType != null ? cfn_parse.FromCloudFormation.getString(properties.InstanceType) : undefined);
    ret.addPropertyResult('sageMakerImageArn', 'SageMakerImageArn', properties.SageMakerImageArn != null ? cfn_parse.FromCloudFormation.getString(properties.SageMakerImageArn) : undefined);
    ret.addPropertyResult('sageMakerImageVersionArn', 'SageMakerImageVersionArn', properties.SageMakerImageVersionArn != null ? cfn_parse.FromCloudFormation.getString(properties.SageMakerImageVersionArn) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnAppImageConfigProps`
 *
 * @param properties - the TypeScript properties of a `CfnAppImageConfigProps`
 *
 * @returns the result of the validation.
 */
function CfnAppImageConfigPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('appImageConfigName', cdk.requiredValidator)(properties.appImageConfigName));
    errors.collect(cdk.propertyValidator('appImageConfigName', cdk.validateString)(properties.appImageConfigName));
    errors.collect(cdk.propertyValidator('kernelGatewayImageConfig', CfnAppImageConfig_KernelGatewayImageConfigPropertyValidator)(properties.kernelGatewayImageConfig));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnAppImageConfigProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::AppImageConfig` resource
 *
 * @param properties - the TypeScript properties of a `CfnAppImageConfigProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::AppImageConfig` resource.
 */
// @ts-ignore TS6133
function cfnAppImageConfigPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAppImageConfigPropsValidator(properties).assertSuccess();
    return {
        AppImageConfigName: cdk.stringToCloudFormation(properties.appImageConfigName),
        KernelGatewayImageConfig: cfnAppImageConfigKernelGatewayImageConfigPropertyToCloudFormation(properties.kernelGatewayImageConfig),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnAppImageConfigPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('appImageConfigName', 'AppImageConfigName', cfn_parse.FromCloudFormation.getString(properties.AppImageConfigName));
    ret.addPropertyResult('kernelGatewayImageConfig', 'KernelGatewayImageConfig', properties.KernelGatewayImageConfig != null ? CfnAppImageConfigKernelGatewayImageConfigPropertyFromCloudFormation(properties.KernelGatewayImageConfig) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::SageMaker::AppImageConfig`
 *
 * Creates a configuration for running a SageMaker image as a KernelGateway app. The configuration specifies the Amazon Elastic File System (EFS) storage volume on the image, and a list of the kernels in the image.
 *
 * @cloudformationResource AWS::SageMaker::AppImageConfig
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html
 */
class CfnAppImageConfig extends cdk.CfnResource {
    /**
     * Create a new `AWS::SageMaker::AppImageConfig`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnAppImageConfig.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_sagemaker_CfnAppImageConfigProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnAppImageConfig);
            }
            throw error;
        }
        cdk.requireProperty(props, 'appImageConfigName', this);
        this.attrAppImageConfigArn = cdk.Token.asString(this.getAtt('AppImageConfigArn'));
        this.appImageConfigName = props.appImageConfigName;
        this.kernelGatewayImageConfig = props.kernelGatewayImageConfig;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::SageMaker::AppImageConfig", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnAppImageConfigPropsFromCloudFormation(resourceProperties);
        const ret = new CfnAppImageConfig(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnAppImageConfig.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            appImageConfigName: this.appImageConfigName,
            kernelGatewayImageConfig: this.kernelGatewayImageConfig,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnAppImageConfigPropsToCloudFormation(props);
    }
}
exports.CfnAppImageConfig = CfnAppImageConfig;
_b = JSII_RTTI_SYMBOL_1;
CfnAppImageConfig[_b] = { fqn: "@aws-cdk/aws-sagemaker.CfnAppImageConfig", version: "1.186.1" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnAppImageConfig.CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::AppImageConfig";
/**
 * Determine whether the given properties match those of a `FileSystemConfigProperty`
 *
 * @param properties - the TypeScript properties of a `FileSystemConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnAppImageConfig_FileSystemConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('defaultGid', cdk.validateNumber)(properties.defaultGid));
    errors.collect(cdk.propertyValidator('defaultUid', cdk.validateNumber)(properties.defaultUid));
    errors.collect(cdk.propertyValidator('mountPath', cdk.validateString)(properties.mountPath));
    return errors.wrap('supplied properties not correct for "FileSystemConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::AppImageConfig.FileSystemConfig` resource
 *
 * @param properties - the TypeScript properties of a `FileSystemConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::AppImageConfig.FileSystemConfig` resource.
 */
// @ts-ignore TS6133
function cfnAppImageConfigFileSystemConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAppImageConfig_FileSystemConfigPropertyValidator(properties).assertSuccess();
    return {
        DefaultGid: cdk.numberToCloudFormation(properties.defaultGid),
        DefaultUid: cdk.numberToCloudFormation(properties.defaultUid),
        MountPath: cdk.stringToCloudFormation(properties.mountPath),
    };
}
// @ts-ignore TS6133
function CfnAppImageConfigFileSystemConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('defaultGid', 'DefaultGid', properties.DefaultGid != null ? cfn_parse.FromCloudFormation.getNumber(properties.DefaultGid) : undefined);
    ret.addPropertyResult('defaultUid', 'DefaultUid', properties.DefaultUid != null ? cfn_parse.FromCloudFormation.getNumber(properties.DefaultUid) : undefined);
    ret.addPropertyResult('mountPath', 'MountPath', properties.MountPath != null ? cfn_parse.FromCloudFormation.getString(properties.MountPath) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `KernelGatewayImageConfigProperty`
 *
 * @param properties - the TypeScript properties of a `KernelGatewayImageConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnAppImageConfig_KernelGatewayImageConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('fileSystemConfig', CfnAppImageConfig_FileSystemConfigPropertyValidator)(properties.fileSystemConfig));
    errors.collect(cdk.propertyValidator('kernelSpecs', cdk.requiredValidator)(properties.kernelSpecs));
    errors.collect(cdk.propertyValidator('kernelSpecs', cdk.listValidator(CfnAppImageConfig_KernelSpecPropertyValidator))(properties.kernelSpecs));
    return errors.wrap('supplied properties not correct for "KernelGatewayImageConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::AppImageConfig.KernelGatewayImageConfig` resource
 *
 * @param properties - the TypeScript properties of a `KernelGatewayImageConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::AppImageConfig.KernelGatewayImageConfig` resource.
 */
// @ts-ignore TS6133
function cfnAppImageConfigKernelGatewayImageConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAppImageConfig_KernelGatewayImageConfigPropertyValidator(properties).assertSuccess();
    return {
        FileSystemConfig: cfnAppImageConfigFileSystemConfigPropertyToCloudFormation(properties.fileSystemConfig),
        KernelSpecs: cdk.listMapper(cfnAppImageConfigKernelSpecPropertyToCloudFormation)(properties.kernelSpecs),
    };
}
// @ts-ignore TS6133
function CfnAppImageConfigKernelGatewayImageConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('fileSystemConfig', 'FileSystemConfig', properties.FileSystemConfig != null ? CfnAppImageConfigFileSystemConfigPropertyFromCloudFormation(properties.FileSystemConfig) : undefined);
    ret.addPropertyResult('kernelSpecs', 'KernelSpecs', cfn_parse.FromCloudFormation.getArray(CfnAppImageConfigKernelSpecPropertyFromCloudFormation)(properties.KernelSpecs));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `KernelSpecProperty`
 *
 * @param properties - the TypeScript properties of a `KernelSpecProperty`
 *
 * @returns the result of the validation.
 */
function CfnAppImageConfig_KernelSpecPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('displayName', cdk.validateString)(properties.displayName));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    return errors.wrap('supplied properties not correct for "KernelSpecProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::AppImageConfig.KernelSpec` resource
 *
 * @param properties - the TypeScript properties of a `KernelSpecProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::AppImageConfig.KernelSpec` resource.
 */
// @ts-ignore TS6133
function cfnAppImageConfigKernelSpecPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAppImageConfig_KernelSpecPropertyValidator(properties).assertSuccess();
    return {
        DisplayName: cdk.stringToCloudFormation(properties.displayName),
        Name: cdk.stringToCloudFormation(properties.name),
    };
}
// @ts-ignore TS6133
function CfnAppImageConfigKernelSpecPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('displayName', 'DisplayName', properties.DisplayName != null ? cfn_parse.FromCloudFormation.getString(properties.DisplayName) : undefined);
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnCodeRepositoryProps`
 *
 * @param properties - the TypeScript properties of a `CfnCodeRepositoryProps`
 *
 * @returns the result of the validation.
 */
function CfnCodeRepositoryPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('codeRepositoryName', cdk.validateString)(properties.codeRepositoryName));
    errors.collect(cdk.propertyValidator('gitConfig', cdk.requiredValidator)(properties.gitConfig));
    errors.collect(cdk.propertyValidator('gitConfig', CfnCodeRepository_GitConfigPropertyValidator)(properties.gitConfig));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnCodeRepositoryProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::CodeRepository` resource
 *
 * @param properties - the TypeScript properties of a `CfnCodeRepositoryProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::CodeRepository` resource.
 */
// @ts-ignore TS6133
function cfnCodeRepositoryPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnCodeRepositoryPropsValidator(properties).assertSuccess();
    return {
        GitConfig: cfnCodeRepositoryGitConfigPropertyToCloudFormation(properties.gitConfig),
        CodeRepositoryName: cdk.stringToCloudFormation(properties.codeRepositoryName),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnCodeRepositoryPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('gitConfig', 'GitConfig', CfnCodeRepositoryGitConfigPropertyFromCloudFormation(properties.GitConfig));
    ret.addPropertyResult('codeRepositoryName', 'CodeRepositoryName', properties.CodeRepositoryName != null ? cfn_parse.FromCloudFormation.getString(properties.CodeRepositoryName) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::SageMaker::CodeRepository`
 *
 * Creates a Git repository as a resource in your SageMaker account. You can associate the repository with notebook instances so that you can use Git source control for the notebooks you create. The Git repository is a resource in your SageMaker account, so it can be associated with more than one notebook instance, and it persists independently from the lifecycle of any notebook instances it is associated with.
 *
 * The repository can be hosted either in [AWS CodeCommit](https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html) or in any other Git repository.
 *
 * @cloudformationResource AWS::SageMaker::CodeRepository
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html
 */
class CfnCodeRepository extends cdk.CfnResource {
    /**
     * Create a new `AWS::SageMaker::CodeRepository`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnCodeRepository.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_sagemaker_CfnCodeRepositoryProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnCodeRepository);
            }
            throw error;
        }
        cdk.requireProperty(props, 'gitConfig', this);
        this.attrCodeRepositoryName = cdk.Token.asString(this.getAtt('CodeRepositoryName'));
        this.gitConfig = props.gitConfig;
        this.codeRepositoryName = props.codeRepositoryName;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::SageMaker::CodeRepository", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnCodeRepositoryPropsFromCloudFormation(resourceProperties);
        const ret = new CfnCodeRepository(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnCodeRepository.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            gitConfig: this.gitConfig,
            codeRepositoryName: this.codeRepositoryName,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnCodeRepositoryPropsToCloudFormation(props);
    }
}
exports.CfnCodeRepository = CfnCodeRepository;
_c = JSII_RTTI_SYMBOL_1;
CfnCodeRepository[_c] = { fqn: "@aws-cdk/aws-sagemaker.CfnCodeRepository", version: "1.186.1" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnCodeRepository.CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::CodeRepository";
/**
 * Determine whether the given properties match those of a `GitConfigProperty`
 *
 * @param properties - the TypeScript properties of a `GitConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnCodeRepository_GitConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('branch', cdk.validateString)(properties.branch));
    errors.collect(cdk.propertyValidator('repositoryUrl', cdk.requiredValidator)(properties.repositoryUrl));
    errors.collect(cdk.propertyValidator('repositoryUrl', cdk.validateString)(properties.repositoryUrl));
    errors.collect(cdk.propertyValidator('secretArn', cdk.validateString)(properties.secretArn));
    return errors.wrap('supplied properties not correct for "GitConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::CodeRepository.GitConfig` resource
 *
 * @param properties - the TypeScript properties of a `GitConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::CodeRepository.GitConfig` resource.
 */
// @ts-ignore TS6133
function cfnCodeRepositoryGitConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnCodeRepository_GitConfigPropertyValidator(properties).assertSuccess();
    return {
        Branch: cdk.stringToCloudFormation(properties.branch),
        RepositoryUrl: cdk.stringToCloudFormation(properties.repositoryUrl),
        SecretArn: cdk.stringToCloudFormation(properties.secretArn),
    };
}
// @ts-ignore TS6133
function CfnCodeRepositoryGitConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('branch', 'Branch', properties.Branch != null ? cfn_parse.FromCloudFormation.getString(properties.Branch) : undefined);
    ret.addPropertyResult('repositoryUrl', 'RepositoryUrl', cfn_parse.FromCloudFormation.getString(properties.RepositoryUrl));
    ret.addPropertyResult('secretArn', 'SecretArn', properties.SecretArn != null ? cfn_parse.FromCloudFormation.getString(properties.SecretArn) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnDataQualityJobDefinitionProps`
 *
 * @param properties - the TypeScript properties of a `CfnDataQualityJobDefinitionProps`
 *
 * @returns the result of the validation.
 */
function CfnDataQualityJobDefinitionPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dataQualityAppSpecification', cdk.requiredValidator)(properties.dataQualityAppSpecification));
    errors.collect(cdk.propertyValidator('dataQualityAppSpecification', CfnDataQualityJobDefinition_DataQualityAppSpecificationPropertyValidator)(properties.dataQualityAppSpecification));
    errors.collect(cdk.propertyValidator('dataQualityBaselineConfig', CfnDataQualityJobDefinition_DataQualityBaselineConfigPropertyValidator)(properties.dataQualityBaselineConfig));
    errors.collect(cdk.propertyValidator('dataQualityJobInput', cdk.requiredValidator)(properties.dataQualityJobInput));
    errors.collect(cdk.propertyValidator('dataQualityJobInput', CfnDataQualityJobDefinition_DataQualityJobInputPropertyValidator)(properties.dataQualityJobInput));
    errors.collect(cdk.propertyValidator('dataQualityJobOutputConfig', cdk.requiredValidator)(properties.dataQualityJobOutputConfig));
    errors.collect(cdk.propertyValidator('dataQualityJobOutputConfig', CfnDataQualityJobDefinition_MonitoringOutputConfigPropertyValidator)(properties.dataQualityJobOutputConfig));
    errors.collect(cdk.propertyValidator('endpointName', cdk.validateString)(properties.endpointName));
    errors.collect(cdk.propertyValidator('jobDefinitionName', cdk.validateString)(properties.jobDefinitionName));
    errors.collect(cdk.propertyValidator('jobResources', cdk.requiredValidator)(properties.jobResources));
    errors.collect(cdk.propertyValidator('jobResources', CfnDataQualityJobDefinition_MonitoringResourcesPropertyValidator)(properties.jobResources));
    errors.collect(cdk.propertyValidator('networkConfig', CfnDataQualityJobDefinition_NetworkConfigPropertyValidator)(properties.networkConfig));
    errors.collect(cdk.propertyValidator('roleArn', cdk.requiredValidator)(properties.roleArn));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    errors.collect(cdk.propertyValidator('stoppingCondition', CfnDataQualityJobDefinition_StoppingConditionPropertyValidator)(properties.stoppingCondition));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnDataQualityJobDefinitionProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::DataQualityJobDefinition` resource
 *
 * @param properties - the TypeScript properties of a `CfnDataQualityJobDefinitionProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::DataQualityJobDefinition` resource.
 */
// @ts-ignore TS6133
function cfnDataQualityJobDefinitionPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDataQualityJobDefinitionPropsValidator(properties).assertSuccess();
    return {
        DataQualityAppSpecification: cfnDataQualityJobDefinitionDataQualityAppSpecificationPropertyToCloudFormation(properties.dataQualityAppSpecification),
        DataQualityJobInput: cfnDataQualityJobDefinitionDataQualityJobInputPropertyToCloudFormation(properties.dataQualityJobInput),
        DataQualityJobOutputConfig: cfnDataQualityJobDefinitionMonitoringOutputConfigPropertyToCloudFormation(properties.dataQualityJobOutputConfig),
        JobResources: cfnDataQualityJobDefinitionMonitoringResourcesPropertyToCloudFormation(properties.jobResources),
        RoleArn: cdk.stringToCloudFormation(properties.roleArn),
        DataQualityBaselineConfig: cfnDataQualityJobDefinitionDataQualityBaselineConfigPropertyToCloudFormation(properties.dataQualityBaselineConfig),
        EndpointName: cdk.stringToCloudFormation(properties.endpointName),
        JobDefinitionName: cdk.stringToCloudFormation(properties.jobDefinitionName),
        NetworkConfig: cfnDataQualityJobDefinitionNetworkConfigPropertyToCloudFormation(properties.networkConfig),
        StoppingCondition: cfnDataQualityJobDefinitionStoppingConditionPropertyToCloudFormation(properties.stoppingCondition),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnDataQualityJobDefinitionPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dataQualityAppSpecification', 'DataQualityAppSpecification', CfnDataQualityJobDefinitionDataQualityAppSpecificationPropertyFromCloudFormation(properties.DataQualityAppSpecification));
    ret.addPropertyResult('dataQualityJobInput', 'DataQualityJobInput', CfnDataQualityJobDefinitionDataQualityJobInputPropertyFromCloudFormation(properties.DataQualityJobInput));
    ret.addPropertyResult('dataQualityJobOutputConfig', 'DataQualityJobOutputConfig', CfnDataQualityJobDefinitionMonitoringOutputConfigPropertyFromCloudFormation(properties.DataQualityJobOutputConfig));
    ret.addPropertyResult('jobResources', 'JobResources', CfnDataQualityJobDefinitionMonitoringResourcesPropertyFromCloudFormation(properties.JobResources));
    ret.addPropertyResult('roleArn', 'RoleArn', cfn_parse.FromCloudFormation.getString(properties.RoleArn));
    ret.addPropertyResult('dataQualityBaselineConfig', 'DataQualityBaselineConfig', properties.DataQualityBaselineConfig != null ? CfnDataQualityJobDefinitionDataQualityBaselineConfigPropertyFromCloudFormation(properties.DataQualityBaselineConfig) : undefined);
    ret.addPropertyResult('endpointName', 'EndpointName', properties.EndpointName != null ? cfn_parse.FromCloudFormation.getString(properties.EndpointName) : undefined);
    ret.addPropertyResult('jobDefinitionName', 'JobDefinitionName', properties.JobDefinitionName != null ? cfn_parse.FromCloudFormation.getString(properties.JobDefinitionName) : undefined);
    ret.addPropertyResult('networkConfig', 'NetworkConfig', properties.NetworkConfig != null ? CfnDataQualityJobDefinitionNetworkConfigPropertyFromCloudFormation(properties.NetworkConfig) : undefined);
    ret.addPropertyResult('stoppingCondition', 'StoppingCondition', properties.StoppingCondition != null ? CfnDataQualityJobDefinitionStoppingConditionPropertyFromCloudFormation(properties.StoppingCondition) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::SageMaker::DataQualityJobDefinition`
 *
 * Creates a definition for a job that monitors data quality and drift. For information about model monitor, see [Amazon SageMaker Model Monitor](https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html) .
 *
 * @cloudformationResource AWS::SageMaker::DataQualityJobDefinition
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html
 */
class CfnDataQualityJobDefinition extends cdk.CfnResource {
    /**
     * Create a new `AWS::SageMaker::DataQualityJobDefinition`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDataQualityJobDefinition.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_sagemaker_CfnDataQualityJobDefinitionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnDataQualityJobDefinition);
            }
            throw error;
        }
        cdk.requireProperty(props, 'dataQualityAppSpecification', this);
        cdk.requireProperty(props, 'dataQualityJobInput', this);
        cdk.requireProperty(props, 'dataQualityJobOutputConfig', this);
        cdk.requireProperty(props, 'jobResources', this);
        cdk.requireProperty(props, 'roleArn', this);
        this.attrCreationTime = cdk.Token.asString(this.getAtt('CreationTime'));
        this.attrJobDefinitionArn = cdk.Token.asString(this.getAtt('JobDefinitionArn'));
        this.dataQualityAppSpecification = props.dataQualityAppSpecification;
        this.dataQualityJobInput = props.dataQualityJobInput;
        this.dataQualityJobOutputConfig = props.dataQualityJobOutputConfig;
        this.jobResources = props.jobResources;
        this.roleArn = props.roleArn;
        this.dataQualityBaselineConfig = props.dataQualityBaselineConfig;
        this.endpointName = props.endpointName;
        this.jobDefinitionName = props.jobDefinitionName;
        this.networkConfig = props.networkConfig;
        this.stoppingCondition = props.stoppingCondition;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::SageMaker::DataQualityJobDefinition", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnDataQualityJobDefinitionPropsFromCloudFormation(resourceProperties);
        const ret = new CfnDataQualityJobDefinition(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDataQualityJobDefinition.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            dataQualityAppSpecification: this.dataQualityAppSpecification,
            dataQualityJobInput: this.dataQualityJobInput,
            dataQualityJobOutputConfig: this.dataQualityJobOutputConfig,
            jobResources: this.jobResources,
            roleArn: this.roleArn,
            dataQualityBaselineConfig: this.dataQualityBaselineConfig,
            endpointName: this.endpointName,
            jobDefinitionName: this.jobDefinitionName,
            networkConfig: this.networkConfig,
            stoppingCondition: this.stoppingCondition,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnDataQualityJobDefinitionPropsToCloudFormation(props);
    }
}
exports.CfnDataQualityJobDefinition = CfnDataQualityJobDefinition;
_d = JSII_RTTI_SYMBOL_1;
CfnDataQualityJobDefinition[_d] = { fqn: "@aws-cdk/aws-sagemaker.CfnDataQualityJobDefinition", version: "1.186.1" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDataQualityJobDefinition.CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::DataQualityJobDefinition";
/**
 * Determine whether the given properties match those of a `BatchTransformInputProperty`
 *
 * @param properties - the TypeScript properties of a `BatchTransformInputProperty`
 *
 * @returns the result of the validation.
 */
function CfnDataQualityJobDefinition_BatchTransformInputPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dataCapturedDestinationS3Uri', cdk.requiredValidator)(properties.dataCapturedDestinationS3Uri));
    errors.collect(cdk.propertyValidator('dataCapturedDestinationS3Uri', cdk.validateString)(properties.dataCapturedDestinationS3Uri));
    errors.collect(cdk.propertyValidator('datasetFormat', cdk.requiredValidator)(properties.datasetFormat));
    errors.collect(cdk.propertyValidator('datasetFormat', CfnDataQualityJobDefinition_DatasetFormatPropertyValidator)(properties.datasetFormat));
    errors.collect(cdk.propertyValidator('localPath', cdk.requiredValidator)(properties.localPath));
    errors.collect(cdk.propertyValidator('localPath', cdk.validateString)(properties.localPath));
    errors.collect(cdk.propertyValidator('s3DataDistributionType', cdk.validateString)(properties.s3DataDistributionType));
    errors.collect(cdk.propertyValidator('s3InputMode', cdk.validateString)(properties.s3InputMode));
    return errors.wrap('supplied properties not correct for "BatchTransformInputProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::DataQualityJobDefinition.BatchTransformInput` resource
 *
 * @param properties - the TypeScript properties of a `BatchTransformInputProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::DataQualityJobDefinition.BatchTransformInput` resource.
 */
// @ts-ignore TS6133
function cfnDataQualityJobDefinitionBatchTransformInputPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDataQualityJobDefinition_BatchTransformInputPropertyValidator(properties).assertSuccess();
    return {
        DataCapturedDestinationS3Uri: cdk.stringToCloudFormation(properties.dataCapturedDestinationS3Uri),
        DatasetFormat: cfnDataQualityJobDefinitionDatasetFormatPropertyToCloudFormation(properties.datasetFormat),
        LocalPath: cdk.stringToCloudFormation(properties.localPath),
        S3DataDistributionType: cdk.stringToCloudFormation(properties.s3DataDistributionType),
        S3InputMode: cdk.stringToCloudFormation(properties.s3InputMode),
    };
}
// @ts-ignore TS6133
function CfnDataQualityJobDefinitionBatchTransformInputPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dataCapturedDestinationS3Uri', 'DataCapturedDestinationS3Uri', cfn_parse.FromCloudFormation.getString(properties.DataCapturedDestinationS3Uri));
    ret.addPropertyResult('datasetFormat', 'DatasetFormat', CfnDataQualityJobDefinitionDatasetFormatPropertyFromCloudFormation(properties.DatasetFormat));
    ret.addPropertyResult('localPath', 'LocalPath', cfn_parse.FromCloudFormation.getString(properties.LocalPath));
    ret.addPropertyResult('s3DataDistributionType', 'S3DataDistributionType', properties.S3DataDistributionType != null ? cfn_parse.FromCloudFormation.getString(properties.S3DataDistributionType) : undefined);
    ret.addPropertyResult('s3InputMode', 'S3InputMode', properties.S3InputMode != null ? cfn_parse.FromCloudFormation.getString(properties.S3InputMode) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ClusterConfigProperty`
 *
 * @param properties - the TypeScript properties of a `ClusterConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnDataQualityJobDefinition_ClusterConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('instanceCount', cdk.requiredValidator)(properties.instanceCount));
    errors.collect(cdk.propertyValidator('instanceCount', cdk.validateNumber)(properties.instanceCount));
    errors.collect(cdk.propertyValidator('instanceType', cdk.requiredValidator)(properties.instanceType));
    errors.collect(cdk.propertyValidator('instanceType', cdk.validateString)(properties.instanceType));
    errors.collect(cdk.propertyValidator('volumeKmsKeyId', cdk.validateString)(properties.volumeKmsKeyId));
    errors.collect(cdk.propertyValidator('volumeSizeInGb', cdk.requiredValidator)(properties.volumeSizeInGb));
    errors.collect(cdk.propertyValidator('volumeSizeInGb', cdk.validateNumber)(properties.volumeSizeInGb));
    return errors.wrap('supplied properties not correct for "ClusterConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::DataQualityJobDefinition.ClusterConfig` resource
 *
 * @param properties - the TypeScript properties of a `ClusterConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::DataQualityJobDefinition.ClusterConfig` resource.
 */
// @ts-ignore TS6133
function cfnDataQualityJobDefinitionClusterConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDataQualityJobDefinition_ClusterConfigPropertyValidator(properties).assertSuccess();
    return {
        InstanceCount: cdk.numberToCloudFormation(properties.instanceCount),
        InstanceType: cdk.stringToCloudFormation(properties.instanceType),
        VolumeKmsKeyId: cdk.stringToCloudFormation(properties.volumeKmsKeyId),
        VolumeSizeInGB: cdk.numberToCloudFormation(properties.volumeSizeInGb),
    };
}
// @ts-ignore TS6133
function CfnDataQualityJobDefinitionClusterConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('instanceCount', 'InstanceCount', cfn_parse.FromCloudFormation.getNumber(properties.InstanceCount));
    ret.addPropertyResult('instanceType', 'InstanceType', cfn_parse.FromCloudFormation.getString(properties.InstanceType));
    ret.addPropertyResult('volumeKmsKeyId', 'VolumeKmsKeyId', properties.VolumeKmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.VolumeKmsKeyId) : undefined);
    ret.addPropertyResult('volumeSizeInGb', 'VolumeSizeInGB', cfn_parse.FromCloudFormation.getNumber(properties.VolumeSizeInGB));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ConstraintsResourceProperty`
 *
 * @param properties - the TypeScript properties of a `ConstraintsResourceProperty`
 *
 * @returns the result of the validation.
 */
function CfnDataQualityJobDefinition_ConstraintsResourcePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('s3Uri', cdk.validateString)(properties.s3Uri));
    return errors.wrap('supplied properties not correct for "ConstraintsResourceProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::DataQualityJobDefinition.ConstraintsResource` resource
 *
 * @param properties - the TypeScript properties of a `ConstraintsResourceProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::DataQualityJobDefinition.ConstraintsResource` resource.
 */
// @ts-ignore TS6133
function cfnDataQualityJobDefinitionConstraintsResourcePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDataQualityJobDefinition_ConstraintsResourcePropertyValidator(properties).assertSuccess();
    return {
        S3Uri: cdk.stringToCloudFormation(properties.s3Uri),
    };
}
// @ts-ignore TS6133
function CfnDataQualityJobDefinitionConstraintsResourcePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('s3Uri', 'S3Uri', properties.S3Uri != null ? cfn_parse.FromCloudFormation.getString(properties.S3Uri) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CsvProperty`
 *
 * @param properties - the TypeScript properties of a `CsvProperty`
 *
 * @returns the result of the validation.
 */
function CfnDataQualityJobDefinition_CsvPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('header', cdk.validateBoolean)(properties.header));
    return errors.wrap('supplied properties not correct for "CsvProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::DataQualityJobDefinition.Csv` resource
 *
 * @param properties - the TypeScript properties of a `CsvProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::DataQualityJobDefinition.Csv` resource.
 */
// @ts-ignore TS6133
function cfnDataQualityJobDefinitionCsvPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDataQualityJobDefinition_CsvPropertyValidator(properties).assertSuccess();
    return {
        Header: cdk.booleanToCloudFormation(properties.header),
    };
}
// @ts-ignore TS6133
function CfnDataQualityJobDefinitionCsvPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('header', 'Header', properties.Header != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Header) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DataQualityAppSpecificationProperty`
 *
 * @param properties - the TypeScript properties of a `DataQualityAppSpecificationProperty`
 *
 * @returns the result of the validation.
 */
function CfnDataQualityJobDefinition_DataQualityAppSpecificationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('containerArguments', cdk.listValidator(cdk.validateString))(properties.containerArguments));
    errors.collect(cdk.propertyValidator('containerEntrypoint', cdk.listValidator(cdk.validateString))(properties.containerEntrypoint));
    errors.collect(cdk.propertyValidator('environment', cdk.hashValidator(cdk.validateString))(properties.environment));
    errors.collect(cdk.propertyValidator('imageUri', cdk.requiredValidator)(properties.imageUri));
    errors.collect(cdk.propertyValidator('imageUri', cdk.validateString)(properties.imageUri));
    errors.collect(cdk.propertyValidator('postAnalyticsProcessorSourceUri', cdk.validateString)(properties.postAnalyticsProcessorSourceUri));
    errors.collect(cdk.propertyValidator('recordPreprocessorSourceUri', cdk.validateString)(properties.recordPreprocessorSourceUri));
    return errors.wrap('supplied properties not correct for "DataQualityAppSpecificationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::DataQualityJobDefinition.DataQualityAppSpecification` resource
 *
 * @param properties - the TypeScript properties of a `DataQualityAppSpecificationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::DataQualityJobDefinition.DataQualityAppSpecification` resource.
 */
// @ts-ignore TS6133
function cfnDataQualityJobDefinitionDataQualityAppSpecificationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDataQualityJobDefinition_DataQualityAppSpecificationPropertyValidator(properties).assertSuccess();
    return {
        ContainerArguments: cdk.listMapper(cdk.stringToCloudFormation)(properties.containerArguments),
        ContainerEntrypoint: cdk.listMapper(cdk.stringToCloudFormation)(properties.containerEntrypoint),
        Environment: cdk.hashMapper(cdk.stringToCloudFormation)(properties.environment),
        ImageUri: cdk.stringToCloudFormation(properties.imageUri),
        PostAnalyticsProcessorSourceUri: cdk.stringToCloudFormation(properties.postAnalyticsProcessorSourceUri),
        RecordPreprocessorSourceUri: cdk.stringToCloudFormation(properties.recordPreprocessorSourceUri),
    };
}
// @ts-ignore TS6133
function CfnDataQualityJobDefinitionDataQualityAppSpecificationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('containerArguments', 'ContainerArguments', properties.ContainerArguments != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ContainerArguments) : undefined);
    ret.addPropertyResult('containerEntrypoint', 'ContainerEntrypoint', properties.ContainerEntrypoint != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ContainerEntrypoint) : undefined);
    ret.addPropertyResult('environment', 'Environment', properties.Environment != null ? cfn_parse.FromCloudFormation.getMap(cfn_parse.FromCloudFormation.getString)(properties.Environment) : undefined);
    ret.addPropertyResult('imageUri', 'ImageUri', cfn_parse.FromCloudFormation.getString(properties.ImageUri));
    ret.addPropertyResult('postAnalyticsProcessorSourceUri', 'PostAnalyticsProcessorSourceUri', properties.PostAnalyticsProcessorSourceUri != null ? cfn_parse.FromCloudFormation.getString(properties.PostAnalyticsProcessorSourceUri) : undefined);
    ret.addPropertyResult('recordPreprocessorSourceUri', 'RecordPreprocessorSourceUri', properties.RecordPreprocessorSourceUri != null ? cfn_parse.FromCloudFormation.getString(properties.RecordPreprocessorSourceUri) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DataQualityBaselineConfigProperty`
 *
 * @param properties - the TypeScript properties of a `DataQualityBaselineConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnDataQualityJobDefinition_DataQualityBaselineConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('baseliningJobName', cdk.validateString)(properties.baseliningJobName));
    errors.collect(cdk.propertyValidator('constraintsResource', CfnDataQualityJobDefinition_ConstraintsResourcePropertyValidator)(properties.constraintsResource));
    errors.collect(cdk.propertyValidator('statisticsResource', CfnDataQualityJobDefinition_StatisticsResourcePropertyValidator)(properties.statisticsResource));
    return errors.wrap('supplied properties not correct for "DataQualityBaselineConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::DataQualityJobDefinition.DataQualityBaselineConfig` resource
 *
 * @param properties - the TypeScript properties of a `DataQualityBaselineConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::DataQualityJobDefinition.DataQualityBaselineConfig` resource.
 */
// @ts-ignore TS6133
function cfnDataQualityJobDefinitionDataQualityBaselineConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDataQualityJobDefinition_DataQualityBaselineConfigPropertyValidator(properties).assertSuccess();
    return {
        BaseliningJobName: cdk.stringToCloudFormation(properties.baseliningJobName),
        ConstraintsResource: cfnDataQualityJobDefinitionConstraintsResourcePropertyToCloudFormation(properties.constraintsResource),
        StatisticsResource: cfnDataQualityJobDefinitionStatisticsResourcePropertyToCloudFormation(properties.statisticsResource),
    };
}
// @ts-ignore TS6133
function CfnDataQualityJobDefinitionDataQualityBaselineConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('baseliningJobName', 'BaseliningJobName', properties.BaseliningJobName != null ? cfn_parse.FromCloudFormation.getString(properties.BaseliningJobName) : undefined);
    ret.addPropertyResult('constraintsResource', 'ConstraintsResource', properties.ConstraintsResource != null ? CfnDataQualityJobDefinitionConstraintsResourcePropertyFromCloudFormation(properties.ConstraintsResource) : undefined);
    ret.addPropertyResult('statisticsResource', 'StatisticsResource', properties.StatisticsResource != null ? CfnDataQualityJobDefinitionStatisticsResourcePropertyFromCloudFormation(properties.StatisticsResource) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DataQualityJobInputProperty`
 *
 * @param properties - the TypeScript properties of a `DataQualityJobInputProperty`
 *
 * @returns the result of the validation.
 */
function CfnDataQualityJobDefinition_DataQualityJobInputPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('batchTransformInput', CfnDataQualityJobDefinition_BatchTransformInputPropertyValidator)(properties.batchTransformInput));
    errors.collect(cdk.propertyValidator('endpointInput', CfnDataQualityJobDefinition_EndpointInputPropertyValidator)(properties.endpointInput));
    return errors.wrap('supplied properties not correct for "DataQualityJobInputProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::DataQualityJobDefinition.DataQualityJobInput` resource
 *
 * @param properties - the TypeScript properties of a `DataQualityJobInputProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::DataQualityJobDefinition.DataQualityJobInput` resource.
 */
// @ts-ignore TS6133
function cfnDataQualityJobDefinitionDataQualityJobInputPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDataQualityJobDefinition_DataQualityJobInputPropertyValidator(properties).assertSuccess();
    return {
        BatchTransformInput: cfnDataQualityJobDefinitionBatchTransformInputPropertyToCloudFormation(properties.batchTransformInput),
        EndpointInput: cfnDataQualityJobDefinitionEndpointInputPropertyToCloudFormation(properties.endpointInput),
    };
}
// @ts-ignore TS6133
function CfnDataQualityJobDefinitionDataQualityJobInputPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('batchTransformInput', 'BatchTransformInput', properties.BatchTransformInput != null ? CfnDataQualityJobDefinitionBatchTransformInputPropertyFromCloudFormation(properties.BatchTransformInput) : undefined);
    ret.addPropertyResult('endpointInput', 'EndpointInput', properties.EndpointInput != null ? CfnDataQualityJobDefinitionEndpointInputPropertyFromCloudFormation(properties.EndpointInput) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DatasetFormatProperty`
 *
 * @param properties - the TypeScript properties of a `DatasetFormatProperty`
 *
 * @returns the result of the validation.
 */
function CfnDataQualityJobDefinition_DatasetFormatPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('csv', CfnDataQualityJobDefinition_CsvPropertyValidator)(properties.csv));
    errors.collect(cdk.propertyValidator('json', cdk.validateObject)(properties.json));
    errors.collect(cdk.propertyValidator('parquet', cdk.validateBoolean)(properties.parquet));
    return errors.wrap('supplied properties not correct for "DatasetFormatProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::DataQualityJobDefinition.DatasetFormat` resource
 *
 * @param properties - the TypeScript properties of a `DatasetFormatProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::DataQualityJobDefinition.DatasetFormat` resource.
 */
// @ts-ignore TS6133
function cfnDataQualityJobDefinitionDatasetFormatPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDataQualityJobDefinition_DatasetFormatPropertyValidator(properties).assertSuccess();
    return {
        Csv: cfnDataQualityJobDefinitionCsvPropertyToCloudFormation(properties.csv),
        Json: cdk.objectToCloudFormation(properties.json),
        Parquet: cdk.booleanToCloudFormation(properties.parquet),
    };
}
// @ts-ignore TS6133
function CfnDataQualityJobDefinitionDatasetFormatPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('csv', 'Csv', properties.Csv != null ? CfnDataQualityJobDefinitionCsvPropertyFromCloudFormation(properties.Csv) : undefined);
    ret.addPropertyResult('json', 'Json', properties.Json != null ? cfn_parse.FromCloudFormation.getAny(properties.Json) : undefined);
    ret.addPropertyResult('parquet', 'Parquet', properties.Parquet != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Parquet) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `EndpointInputProperty`
 *
 * @param properties - the TypeScript properties of a `EndpointInputProperty`
 *
 * @returns the result of the validation.
 */
function CfnDataQualityJobDefinition_EndpointInputPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('endpointName', cdk.requiredValidator)(properties.endpointName));
    errors.collect(cdk.propertyValidator('endpointName', cdk.validateString)(properties.endpointName));
    errors.collect(cdk.propertyValidator('localPath', cdk.requiredValidator)(properties.localPath));
    errors.collect(cdk.propertyValidator('localPath', cdk.validateString)(properties.localPath));
    errors.collect(cdk.propertyValidator('s3DataDistributionType', cdk.validateString)(properties.s3DataDistributionType));
    errors.collect(cdk.propertyValidator('s3InputMode', cdk.validateString)(properties.s3InputMode));
    return errors.wrap('supplied properties not correct for "EndpointInputProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::DataQualityJobDefinition.EndpointInput` resource
 *
 * @param properties - the TypeScript properties of a `EndpointInputProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::DataQualityJobDefinition.EndpointInput` resource.
 */
// @ts-ignore TS6133
function cfnDataQualityJobDefinitionEndpointInputPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDataQualityJobDefinition_EndpointInputPropertyValidator(properties).assertSuccess();
    return {
        EndpointName: cdk.stringToCloudFormation(properties.endpointName),
        LocalPath: cdk.stringToCloudFormation(properties.localPath),
        S3DataDistributionType: cdk.stringToCloudFormation(properties.s3DataDistributionType),
        S3InputMode: cdk.stringToCloudFormation(properties.s3InputMode),
    };
}
// @ts-ignore TS6133
function CfnDataQualityJobDefinitionEndpointInputPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('endpointName', 'EndpointName', cfn_parse.FromCloudFormation.getString(properties.EndpointName));
    ret.addPropertyResult('localPath', 'LocalPath', cfn_parse.FromCloudFormation.getString(properties.LocalPath));
    ret.addPropertyResult('s3DataDistributionType', 'S3DataDistributionType', properties.S3DataDistributionType != null ? cfn_parse.FromCloudFormation.getString(properties.S3DataDistributionType) : undefined);
    ret.addPropertyResult('s3InputMode', 'S3InputMode', properties.S3InputMode != null ? cfn_parse.FromCloudFormation.getString(properties.S3InputMode) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `JsonProperty`
 *
 * @param properties - the TypeScript properties of a `JsonProperty`
 *
 * @returns the result of the validation.
 */
function CfnDataQualityJobDefinition_JsonPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('line', cdk.validateBoolean)(properties.line));
    return errors.wrap('supplied properties not correct for "JsonProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::DataQualityJobDefinition.Json` resource
 *
 * @param properties - the TypeScript properties of a `JsonProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::DataQualityJobDefinition.Json` resource.
 */
// @ts-ignore TS6133
function cfnDataQualityJobDefinitionJsonPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDataQualityJobDefinition_JsonPropertyValidator(properties).assertSuccess();
    return {
        Line: cdk.booleanToCloudFormation(properties.line),
    };
}
// @ts-ignore TS6133
function CfnDataQualityJobDefinitionJsonPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('line', 'Line', properties.Line != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Line) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MonitoringOutputProperty`
 *
 * @param properties - the TypeScript properties of a `MonitoringOutputProperty`
 *
 * @returns the result of the validation.
 */
function CfnDataQualityJobDefinition_MonitoringOutputPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('s3Output', cdk.requiredValidator)(properties.s3Output));
    errors.collect(cdk.propertyValidator('s3Output', CfnDataQualityJobDefinition_S3OutputPropertyValidator)(properties.s3Output));
    return errors.wrap('supplied properties not correct for "MonitoringOutputProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::DataQualityJobDefinition.MonitoringOutput` resource
 *
 * @param properties - the TypeScript properties of a `MonitoringOutputProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::DataQualityJobDefinition.MonitoringOutput` resource.
 */
// @ts-ignore TS6133
function cfnDataQualityJobDefinitionMonitoringOutputPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDataQualityJobDefinition_MonitoringOutputPropertyValidator(properties).assertSuccess();
    return {
        S3Output: cfnDataQualityJobDefinitionS3OutputPropertyToCloudFormation(properties.s3Output),
    };
}
// @ts-ignore TS6133
function CfnDataQualityJobDefinitionMonitoringOutputPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('s3Output', 'S3Output', CfnDataQualityJobDefinitionS3OutputPropertyFromCloudFormation(properties.S3Output));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MonitoringOutputConfigProperty`
 *
 * @param properties - the TypeScript properties of a `MonitoringOutputConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnDataQualityJobDefinition_MonitoringOutputConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('kmsKeyId', cdk.validateString)(properties.kmsKeyId));
    errors.collect(cdk.propertyValidator('monitoringOutputs', cdk.requiredValidator)(properties.monitoringOutputs));
    errors.collect(cdk.propertyValidator('monitoringOutputs', cdk.listValidator(CfnDataQualityJobDefinition_MonitoringOutputPropertyValidator))(properties.monitoringOutputs));
    return errors.wrap('supplied properties not correct for "MonitoringOutputConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::DataQualityJobDefinition.MonitoringOutputConfig` resource
 *
 * @param properties - the TypeScript properties of a `MonitoringOutputConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::DataQualityJobDefinition.MonitoringOutputConfig` resource.
 */
// @ts-ignore TS6133
function cfnDataQualityJobDefinitionMonitoringOutputConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDataQualityJobDefinition_MonitoringOutputConfigPropertyValidator(properties).assertSuccess();
    return {
        KmsKeyId: cdk.stringToCloudFormation(properties.kmsKeyId),
        MonitoringOutputs: cdk.listMapper(cfnDataQualityJobDefinitionMonitoringOutputPropertyToCloudFormation)(properties.monitoringOutputs),
    };
}
// @ts-ignore TS6133
function CfnDataQualityJobDefinitionMonitoringOutputConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('kmsKeyId', 'KmsKeyId', properties.KmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.KmsKeyId) : undefined);
    ret.addPropertyResult('monitoringOutputs', 'MonitoringOutputs', cfn_parse.FromCloudFormation.getArray(CfnDataQualityJobDefinitionMonitoringOutputPropertyFromCloudFormation)(properties.MonitoringOutputs));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MonitoringResourcesProperty`
 *
 * @param properties - the TypeScript properties of a `MonitoringResourcesProperty`
 *
 * @returns the result of the validation.
 */
function CfnDataQualityJobDefinition_MonitoringResourcesPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('clusterConfig', cdk.requiredValidator)(properties.clusterConfig));
    errors.collect(cdk.propertyValidator('clusterConfig', CfnDataQualityJobDefinition_ClusterConfigPropertyValidator)(properties.clusterConfig));
    return errors.wrap('supplied properties not correct for "MonitoringResourcesProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::DataQualityJobDefinition.MonitoringResources` resource
 *
 * @param properties - the TypeScript properties of a `MonitoringResourcesProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::DataQualityJobDefinition.MonitoringResources` resource.
 */
// @ts-ignore TS6133
function cfnDataQualityJobDefinitionMonitoringResourcesPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDataQualityJobDefinition_MonitoringResourcesPropertyValidator(properties).assertSuccess();
    return {
        ClusterConfig: cfnDataQualityJobDefinitionClusterConfigPropertyToCloudFormation(properties.clusterConfig),
    };
}
// @ts-ignore TS6133
function CfnDataQualityJobDefinitionMonitoringResourcesPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('clusterConfig', 'ClusterConfig', CfnDataQualityJobDefinitionClusterConfigPropertyFromCloudFormation(properties.ClusterConfig));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `NetworkConfigProperty`
 *
 * @param properties - the TypeScript properties of a `NetworkConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnDataQualityJobDefinition_NetworkConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('enableInterContainerTrafficEncryption', cdk.validateBoolean)(properties.enableInterContainerTrafficEncryption));
    errors.collect(cdk.propertyValidator('enableNetworkIsolation', cdk.validateBoolean)(properties.enableNetworkIsolation));
    errors.collect(cdk.propertyValidator('vpcConfig', CfnDataQualityJobDefinition_VpcConfigPropertyValidator)(properties.vpcConfig));
    return errors.wrap('supplied properties not correct for "NetworkConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::DataQualityJobDefinition.NetworkConfig` resource
 *
 * @param properties - the TypeScript properties of a `NetworkConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::DataQualityJobDefinition.NetworkConfig` resource.
 */
// @ts-ignore TS6133
function cfnDataQualityJobDefinitionNetworkConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDataQualityJobDefinition_NetworkConfigPropertyValidator(properties).assertSuccess();
    return {
        EnableInterContainerTrafficEncryption: cdk.booleanToCloudFormation(properties.enableInterContainerTrafficEncryption),
        EnableNetworkIsolation: cdk.booleanToCloudFormation(properties.enableNetworkIsolation),
        VpcConfig: cfnDataQualityJobDefinitionVpcConfigPropertyToCloudFormation(properties.vpcConfig),
    };
}
// @ts-ignore TS6133
function CfnDataQualityJobDefinitionNetworkConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('enableInterContainerTrafficEncryption', 'EnableInterContainerTrafficEncryption', properties.EnableInterContainerTrafficEncryption != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EnableInterContainerTrafficEncryption) : undefined);
    ret.addPropertyResult('enableNetworkIsolation', 'EnableNetworkIsolation', properties.EnableNetworkIsolation != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EnableNetworkIsolation) : undefined);
    ret.addPropertyResult('vpcConfig', 'VpcConfig', properties.VpcConfig != null ? CfnDataQualityJobDefinitionVpcConfigPropertyFromCloudFormation(properties.VpcConfig) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `S3OutputProperty`
 *
 * @param properties - the TypeScript properties of a `S3OutputProperty`
 *
 * @returns the result of the validation.
 */
function CfnDataQualityJobDefinition_S3OutputPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('localPath', cdk.requiredValidator)(properties.localPath));
    errors.collect(cdk.propertyValidator('localPath', cdk.validateString)(properties.localPath));
    errors.collect(cdk.propertyValidator('s3UploadMode', cdk.validateString)(properties.s3UploadMode));
    errors.collect(cdk.propertyValidator('s3Uri', cdk.requiredValidator)(properties.s3Uri));
    errors.collect(cdk.propertyValidator('s3Uri', cdk.validateString)(properties.s3Uri));
    return errors.wrap('supplied properties not correct for "S3OutputProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::DataQualityJobDefinition.S3Output` resource
 *
 * @param properties - the TypeScript properties of a `S3OutputProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::DataQualityJobDefinition.S3Output` resource.
 */
// @ts-ignore TS6133
function cfnDataQualityJobDefinitionS3OutputPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDataQualityJobDefinition_S3OutputPropertyValidator(properties).assertSuccess();
    return {
        LocalPath: cdk.stringToCloudFormation(properties.localPath),
        S3UploadMode: cdk.stringToCloudFormation(properties.s3UploadMode),
        S3Uri: cdk.stringToCloudFormation(properties.s3Uri),
    };
}
// @ts-ignore TS6133
function CfnDataQualityJobDefinitionS3OutputPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('localPath', 'LocalPath', cfn_parse.FromCloudFormation.getString(properties.LocalPath));
    ret.addPropertyResult('s3UploadMode', 'S3UploadMode', properties.S3UploadMode != null ? cfn_parse.FromCloudFormation.getString(properties.S3UploadMode) : undefined);
    ret.addPropertyResult('s3Uri', 'S3Uri', cfn_parse.FromCloudFormation.getString(properties.S3Uri));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `StatisticsResourceProperty`
 *
 * @param properties - the TypeScript properties of a `StatisticsResourceProperty`
 *
 * @returns the result of the validation.
 */
function CfnDataQualityJobDefinition_StatisticsResourcePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('s3Uri', cdk.validateString)(properties.s3Uri));
    return errors.wrap('supplied properties not correct for "StatisticsResourceProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::DataQualityJobDefinition.StatisticsResource` resource
 *
 * @param properties - the TypeScript properties of a `StatisticsResourceProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::DataQualityJobDefinition.StatisticsResource` resource.
 */
// @ts-ignore TS6133
function cfnDataQualityJobDefinitionStatisticsResourcePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDataQualityJobDefinition_StatisticsResourcePropertyValidator(properties).assertSuccess();
    return {
        S3Uri: cdk.stringToCloudFormation(properties.s3Uri),
    };
}
// @ts-ignore TS6133
function CfnDataQualityJobDefinitionStatisticsResourcePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('s3Uri', 'S3Uri', properties.S3Uri != null ? cfn_parse.FromCloudFormation.getString(properties.S3Uri) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `StoppingConditionProperty`
 *
 * @param properties - the TypeScript properties of a `StoppingConditionProperty`
 *
 * @returns the result of the validation.
 */
function CfnDataQualityJobDefinition_StoppingConditionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('maxRuntimeInSeconds', cdk.requiredValidator)(properties.maxRuntimeInSeconds));
    errors.collect(cdk.propertyValidator('maxRuntimeInSeconds', cdk.validateNumber)(properties.maxRuntimeInSeconds));
    return errors.wrap('supplied properties not correct for "StoppingConditionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::DataQualityJobDefinition.StoppingCondition` resource
 *
 * @param properties - the TypeScript properties of a `StoppingConditionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::DataQualityJobDefinition.StoppingCondition` resource.
 */
// @ts-ignore TS6133
function cfnDataQualityJobDefinitionStoppingConditionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDataQualityJobDefinition_StoppingConditionPropertyValidator(properties).assertSuccess();
    return {
        MaxRuntimeInSeconds: cdk.numberToCloudFormation(properties.maxRuntimeInSeconds),
    };
}
// @ts-ignore TS6133
function CfnDataQualityJobDefinitionStoppingConditionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('maxRuntimeInSeconds', 'MaxRuntimeInSeconds', cfn_parse.FromCloudFormation.getNumber(properties.MaxRuntimeInSeconds));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `VpcConfigProperty`
 *
 * @param properties - the TypeScript properties of a `VpcConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnDataQualityJobDefinition_VpcConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('securityGroupIds', cdk.requiredValidator)(properties.securityGroupIds));
    errors.collect(cdk.propertyValidator('securityGroupIds', cdk.listValidator(cdk.validateString))(properties.securityGroupIds));
    errors.collect(cdk.propertyValidator('subnets', cdk.requiredValidator)(properties.subnets));
    errors.collect(cdk.propertyValidator('subnets', cdk.listValidator(cdk.validateString))(properties.subnets));
    return errors.wrap('supplied properties not correct for "VpcConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::DataQualityJobDefinition.VpcConfig` resource
 *
 * @param properties - the TypeScript properties of a `VpcConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::DataQualityJobDefinition.VpcConfig` resource.
 */
// @ts-ignore TS6133
function cfnDataQualityJobDefinitionVpcConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDataQualityJobDefinition_VpcConfigPropertyValidator(properties).assertSuccess();
    return {
        SecurityGroupIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.securityGroupIds),
        Subnets: cdk.listMapper(cdk.stringToCloudFormation)(properties.subnets),
    };
}
// @ts-ignore TS6133
function CfnDataQualityJobDefinitionVpcConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('securityGroupIds', 'SecurityGroupIds', cfn_parse.FromCloudFormation.getStringArray(properties.SecurityGroupIds));
    ret.addPropertyResult('subnets', 'Subnets', cfn_parse.FromCloudFormation.getStringArray(properties.Subnets));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnDeviceProps`
 *
 * @param properties - the TypeScript properties of a `CfnDeviceProps`
 *
 * @returns the result of the validation.
 */
function CfnDevicePropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('device', CfnDevice_DevicePropertyValidator)(properties.device));
    errors.collect(cdk.propertyValidator('deviceFleetName', cdk.requiredValidator)(properties.deviceFleetName));
    errors.collect(cdk.propertyValidator('deviceFleetName', cdk.validateString)(properties.deviceFleetName));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnDeviceProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::Device` resource
 *
 * @param properties - the TypeScript properties of a `CfnDeviceProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::Device` resource.
 */
// @ts-ignore TS6133
function cfnDevicePropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDevicePropsValidator(properties).assertSuccess();
    return {
        DeviceFleetName: cdk.stringToCloudFormation(properties.deviceFleetName),
        Device: cfnDeviceDevicePropertyToCloudFormation(properties.device),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnDevicePropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('deviceFleetName', 'DeviceFleetName', cfn_parse.FromCloudFormation.getString(properties.DeviceFleetName));
    ret.addPropertyResult('device', 'Device', properties.Device != null ? CfnDeviceDevicePropertyFromCloudFormation(properties.Device) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::SageMaker::Device`
 *
 * The `AWS::SageMaker::Device` resource is an Amazon SageMaker resource type that allows you to register your Devices against an existing SageMaker Edge Manager DeviceFleet. Each device must be listed individually in the CFN specification.
 *
 * @cloudformationResource AWS::SageMaker::Device
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-device.html
 */
class CfnDevice extends cdk.CfnResource {
    /**
     * Create a new `AWS::SageMaker::Device`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDevice.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_sagemaker_CfnDeviceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnDevice);
            }
            throw error;
        }
        cdk.requireProperty(props, 'deviceFleetName', this);
        this.deviceFleetName = props.deviceFleetName;
        this.device = props.device;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::SageMaker::Device", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnDevicePropsFromCloudFormation(resourceProperties);
        const ret = new CfnDevice(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDevice.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            deviceFleetName: this.deviceFleetName,
            device: this.device,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnDevicePropsToCloudFormation(props);
    }
}
exports.CfnDevice = CfnDevice;
_e = JSII_RTTI_SYMBOL_1;
CfnDevice[_e] = { fqn: "@aws-cdk/aws-sagemaker.CfnDevice", version: "1.186.1" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDevice.CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::Device";
/**
 * Determine whether the given properties match those of a `DeviceProperty`
 *
 * @param properties - the TypeScript properties of a `DeviceProperty`
 *
 * @returns the result of the validation.
 */
function CfnDevice_DevicePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('deviceName', cdk.requiredValidator)(properties.deviceName));
    errors.collect(cdk.propertyValidator('deviceName', cdk.validateString)(properties.deviceName));
    errors.collect(cdk.propertyValidator('iotThingName', cdk.validateString)(properties.iotThingName));
    return errors.wrap('supplied properties not correct for "DeviceProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::Device.Device` resource
 *
 * @param properties - the TypeScript properties of a `DeviceProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::Device.Device` resource.
 */
// @ts-ignore TS6133
function cfnDeviceDevicePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDevice_DevicePropertyValidator(properties).assertSuccess();
    return {
        Description: cdk.stringToCloudFormation(properties.description),
        DeviceName: cdk.stringToCloudFormation(properties.deviceName),
        IotThingName: cdk.stringToCloudFormation(properties.iotThingName),
    };
}
// @ts-ignore TS6133
function CfnDeviceDevicePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('description', 'Description', properties.Description != null ? cfn_parse.FromCloudFormation.getString(properties.Description) : undefined);
    ret.addPropertyResult('deviceName', 'DeviceName', cfn_parse.FromCloudFormation.getString(properties.DeviceName));
    ret.addPropertyResult('iotThingName', 'IotThingName', properties.IotThingName != null ? cfn_parse.FromCloudFormation.getString(properties.IotThingName) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnDeviceFleetProps`
 *
 * @param properties - the TypeScript properties of a `CfnDeviceFleetProps`
 *
 * @returns the result of the validation.
 */
function CfnDeviceFleetPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('deviceFleetName', cdk.requiredValidator)(properties.deviceFleetName));
    errors.collect(cdk.propertyValidator('deviceFleetName', cdk.validateString)(properties.deviceFleetName));
    errors.collect(cdk.propertyValidator('outputConfig', cdk.requiredValidator)(properties.outputConfig));
    errors.collect(cdk.propertyValidator('outputConfig', CfnDeviceFleet_EdgeOutputConfigPropertyValidator)(properties.outputConfig));
    errors.collect(cdk.propertyValidator('roleArn', cdk.requiredValidator)(properties.roleArn));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnDeviceFleetProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::DeviceFleet` resource
 *
 * @param properties - the TypeScript properties of a `CfnDeviceFleetProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::DeviceFleet` resource.
 */
// @ts-ignore TS6133
function cfnDeviceFleetPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDeviceFleetPropsValidator(properties).assertSuccess();
    return {
        DeviceFleetName: cdk.stringToCloudFormation(properties.deviceFleetName),
        OutputConfig: cfnDeviceFleetEdgeOutputConfigPropertyToCloudFormation(properties.outputConfig),
        RoleArn: cdk.stringToCloudFormation(properties.roleArn),
        Description: cdk.stringToCloudFormation(properties.description),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnDeviceFleetPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('deviceFleetName', 'DeviceFleetName', cfn_parse.FromCloudFormation.getString(properties.DeviceFleetName));
    ret.addPropertyResult('outputConfig', 'OutputConfig', CfnDeviceFleetEdgeOutputConfigPropertyFromCloudFormation(properties.OutputConfig));
    ret.addPropertyResult('roleArn', 'RoleArn', cfn_parse.FromCloudFormation.getString(properties.RoleArn));
    ret.addPropertyResult('description', 'Description', properties.Description != null ? cfn_parse.FromCloudFormation.getString(properties.Description) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::SageMaker::DeviceFleet`
 *
 * The `AWS::SageMaker::DeviceFleet` resource is an Amazon SageMaker resource type that allows you to create a DeviceFleet that manages your SageMaker Edge Manager Devices. You must register your devices against the `DeviceFleet` separately.
 *
 * @cloudformationResource AWS::SageMaker::DeviceFleet
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html
 */
class CfnDeviceFleet extends cdk.CfnResource {
    /**
     * Create a new `AWS::SageMaker::DeviceFleet`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDeviceFleet.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_sagemaker_CfnDeviceFleetProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnDeviceFleet);
            }
            throw error;
        }
        cdk.requireProperty(props, 'deviceFleetName', this);
        cdk.requireProperty(props, 'outputConfig', this);
        cdk.requireProperty(props, 'roleArn', this);
        this.deviceFleetName = props.deviceFleetName;
        this.outputConfig = props.outputConfig;
        this.roleArn = props.roleArn;
        this.description = props.description;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::SageMaker::DeviceFleet", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnDeviceFleetPropsFromCloudFormation(resourceProperties);
        const ret = new CfnDeviceFleet(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDeviceFleet.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            deviceFleetName: this.deviceFleetName,
            outputConfig: this.outputConfig,
            roleArn: this.roleArn,
            description: this.description,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnDeviceFleetPropsToCloudFormation(props);
    }
}
exports.CfnDeviceFleet = CfnDeviceFleet;
_f = JSII_RTTI_SYMBOL_1;
CfnDeviceFleet[_f] = { fqn: "@aws-cdk/aws-sagemaker.CfnDeviceFleet", version: "1.186.1" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDeviceFleet.CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::DeviceFleet";
/**
 * Determine whether the given properties match those of a `EdgeOutputConfigProperty`
 *
 * @param properties - the TypeScript properties of a `EdgeOutputConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnDeviceFleet_EdgeOutputConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('kmsKeyId', cdk.validateString)(properties.kmsKeyId));
    errors.collect(cdk.propertyValidator('s3OutputLocation', cdk.requiredValidator)(properties.s3OutputLocation));
    errors.collect(cdk.propertyValidator('s3OutputLocation', cdk.validateString)(properties.s3OutputLocation));
    return errors.wrap('supplied properties not correct for "EdgeOutputConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::DeviceFleet.EdgeOutputConfig` resource
 *
 * @param properties - the TypeScript properties of a `EdgeOutputConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::DeviceFleet.EdgeOutputConfig` resource.
 */
// @ts-ignore TS6133
function cfnDeviceFleetEdgeOutputConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDeviceFleet_EdgeOutputConfigPropertyValidator(properties).assertSuccess();
    return {
        KmsKeyId: cdk.stringToCloudFormation(properties.kmsKeyId),
        S3OutputLocation: cdk.stringToCloudFormation(properties.s3OutputLocation),
    };
}
// @ts-ignore TS6133
function CfnDeviceFleetEdgeOutputConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('kmsKeyId', 'KmsKeyId', properties.KmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.KmsKeyId) : undefined);
    ret.addPropertyResult('s3OutputLocation', 'S3OutputLocation', cfn_parse.FromCloudFormation.getString(properties.S3OutputLocation));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnDomainProps`
 *
 * @param properties - the TypeScript properties of a `CfnDomainProps`
 *
 * @returns the result of the validation.
 */
function CfnDomainPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('appNetworkAccessType', cdk.validateString)(properties.appNetworkAccessType));
    errors.collect(cdk.propertyValidator('appSecurityGroupManagement', cdk.validateString)(properties.appSecurityGroupManagement));
    errors.collect(cdk.propertyValidator('authMode', cdk.requiredValidator)(properties.authMode));
    errors.collect(cdk.propertyValidator('authMode', cdk.validateString)(properties.authMode));
    errors.collect(cdk.propertyValidator('defaultUserSettings', cdk.requiredValidator)(properties.defaultUserSettings));
    errors.collect(cdk.propertyValidator('defaultUserSettings', CfnDomain_UserSettingsPropertyValidator)(properties.defaultUserSettings));
    errors.collect(cdk.propertyValidator('domainName', cdk.requiredValidator)(properties.domainName));
    errors.collect(cdk.propertyValidator('domainName', cdk.validateString)(properties.domainName));
    errors.collect(cdk.propertyValidator('domainSettings', CfnDomain_DomainSettingsPropertyValidator)(properties.domainSettings));
    errors.collect(cdk.propertyValidator('kmsKeyId', cdk.validateString)(properties.kmsKeyId));
    errors.collect(cdk.propertyValidator('subnetIds', cdk.requiredValidator)(properties.subnetIds));
    errors.collect(cdk.propertyValidator('subnetIds', cdk.listValidator(cdk.validateString))(properties.subnetIds));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('vpcId', cdk.requiredValidator)(properties.vpcId));
    errors.collect(cdk.propertyValidator('vpcId', cdk.validateString)(properties.vpcId));
    return errors.wrap('supplied properties not correct for "CfnDomainProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::Domain` resource
 *
 * @param properties - the TypeScript properties of a `CfnDomainProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::Domain` resource.
 */
// @ts-ignore TS6133
function cfnDomainPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDomainPropsValidator(properties).assertSuccess();
    return {
        AuthMode: cdk.stringToCloudFormation(properties.authMode),
        DefaultUserSettings: cfnDomainUserSettingsPropertyToCloudFormation(properties.defaultUserSettings),
        DomainName: cdk.stringToCloudFormation(properties.domainName),
        SubnetIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.subnetIds),
        VpcId: cdk.stringToCloudFormation(properties.vpcId),
        AppNetworkAccessType: cdk.stringToCloudFormation(properties.appNetworkAccessType),
        AppSecurityGroupManagement: cdk.stringToCloudFormation(properties.appSecurityGroupManagement),
        DomainSettings: cfnDomainDomainSettingsPropertyToCloudFormation(properties.domainSettings),
        KmsKeyId: cdk.stringToCloudFormation(properties.kmsKeyId),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnDomainPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('authMode', 'AuthMode', cfn_parse.FromCloudFormation.getString(properties.AuthMode));
    ret.addPropertyResult('defaultUserSettings', 'DefaultUserSettings', CfnDomainUserSettingsPropertyFromCloudFormation(properties.DefaultUserSettings));
    ret.addPropertyResult('domainName', 'DomainName', cfn_parse.FromCloudFormation.getString(properties.DomainName));
    ret.addPropertyResult('subnetIds', 'SubnetIds', cfn_parse.FromCloudFormation.getStringArray(properties.SubnetIds));
    ret.addPropertyResult('vpcId', 'VpcId', cfn_parse.FromCloudFormation.getString(properties.VpcId));
    ret.addPropertyResult('appNetworkAccessType', 'AppNetworkAccessType', properties.AppNetworkAccessType != null ? cfn_parse.FromCloudFormation.getString(properties.AppNetworkAccessType) : undefined);
    ret.addPropertyResult('appSecurityGroupManagement', 'AppSecurityGroupManagement', properties.AppSecurityGroupManagement != null ? cfn_parse.FromCloudFormation.getString(properties.AppSecurityGroupManagement) : undefined);
    ret.addPropertyResult('domainSettings', 'DomainSettings', properties.DomainSettings != null ? CfnDomainDomainSettingsPropertyFromCloudFormation(properties.DomainSettings) : undefined);
    ret.addPropertyResult('kmsKeyId', 'KmsKeyId', properties.KmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.KmsKeyId) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::SageMaker::Domain`
 *
 * Creates a `Domain` used by Amazon SageMaker Studio. A domain consists of an associated Amazon Elastic File System (EFS) volume, a list of authorized users, and a variety of security, application, policy, and Amazon Virtual Private Cloud (VPC) configurations. An AWS account is limited to one domain per region. Users within a domain can share notebook files and other artifacts with each other.
 *
 * *EFS storage*
 *
 * When a domain is created, an EFS volume is created for use by all of the users within the domain. Each user receives a private home directory within the EFS volume for notebooks, Git repositories, and data files.
 *
 * SageMaker uses the AWS Key Management Service ( AWS KMS) to encrypt the EFS volume attached to the domain with an AWS managed key by default. For more control, you can specify a customer managed key. For more information, see [Protect Data at Rest Using Encryption](https://docs.aws.amazon.com/sagemaker/latest/dg/encryption-at-rest.html) .
 *
 * *VPC configuration*
 *
 * All SageMaker Studio traffic between the domain and the EFS volume is through the specified VPC and subnets. For other Studio traffic, you can specify the `AppNetworkAccessType` parameter. `AppNetworkAccessType` corresponds to the network access type that you choose when you onboard to Studio. The following options are available:
 *
 * - `PublicInternetOnly` - Non-EFS traffic goes through a VPC managed by Amazon SageMaker, which allows internet access. This is the default value.
 * - `VpcOnly` - All Studio traffic is through the specified VPC and subnets. Internet access is disabled by default. To allow internet access, you must specify a NAT gateway.
 *
 * When internet access is disabled, you won't be able to run a Studio notebook or to train or host models unless your VPC has an interface endpoint to the SageMaker API and runtime or a NAT gateway and your security groups allow outbound connections.
 *
 * > NFS traffic over TCP on port 2049 needs to be allowed in both inbound and outbound rules in order to launch a SageMaker Studio app successfully.
 *
 * For more information, see [Connect SageMaker Studio Notebooks to Resources in a VPC](https://docs.aws.amazon.com/sagemaker/latest/dg/studio-notebooks-and-internet-access.html) .
 *
 * @cloudformationResource AWS::SageMaker::Domain
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html
 */
class CfnDomain extends cdk.CfnResource {
    /**
     * Create a new `AWS::SageMaker::Domain`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDomain.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_sagemaker_CfnDomainProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnDomain);
            }
            throw error;
        }
        cdk.requireProperty(props, 'authMode', this);
        cdk.requireProperty(props, 'defaultUserSettings', this);
        cdk.requireProperty(props, 'domainName', this);
        cdk.requireProperty(props, 'subnetIds', this);
        cdk.requireProperty(props, 'vpcId', this);
        this.attrDomainArn = cdk.Token.asString(this.getAtt('DomainArn'));
        this.attrDomainId = cdk.Token.asString(this.getAtt('DomainId'));
        this.attrHomeEfsFileSystemId = cdk.Token.asString(this.getAtt('HomeEfsFileSystemId'));
        this.attrSecurityGroupIdForDomainBoundary = cdk.Token.asString(this.getAtt('SecurityGroupIdForDomainBoundary'));
        this.attrSingleSignOnManagedApplicationInstanceId = cdk.Token.asString(this.getAtt('SingleSignOnManagedApplicationInstanceId'));
        this.attrUrl = cdk.Token.asString(this.getAtt('Url'));
        this.authMode = props.authMode;
        this.defaultUserSettings = props.defaultUserSettings;
        this.domainName = props.domainName;
        this.subnetIds = props.subnetIds;
        this.vpcId = props.vpcId;
        this.appNetworkAccessType = props.appNetworkAccessType;
        this.appSecurityGroupManagement = props.appSecurityGroupManagement;
        this.domainSettings = props.domainSettings;
        this.kmsKeyId = props.kmsKeyId;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::SageMaker::Domain", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnDomainPropsFromCloudFormation(resourceProperties);
        const ret = new CfnDomain(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDomain.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            authMode: this.authMode,
            defaultUserSettings: this.defaultUserSettings,
            domainName: this.domainName,
            subnetIds: this.subnetIds,
            vpcId: this.vpcId,
            appNetworkAccessType: this.appNetworkAccessType,
            appSecurityGroupManagement: this.appSecurityGroupManagement,
            domainSettings: this.domainSettings,
            kmsKeyId: this.kmsKeyId,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnDomainPropsToCloudFormation(props);
    }
}
exports.CfnDomain = CfnDomain;
_g = JSII_RTTI_SYMBOL_1;
CfnDomain[_g] = { fqn: "@aws-cdk/aws-sagemaker.CfnDomain", version: "1.186.1" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDomain.CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::Domain";
/**
 * Determine whether the given properties match those of a `CustomImageProperty`
 *
 * @param properties - the TypeScript properties of a `CustomImageProperty`
 *
 * @returns the result of the validation.
 */
function CfnDomain_CustomImagePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('appImageConfigName', cdk.requiredValidator)(properties.appImageConfigName));
    errors.collect(cdk.propertyValidator('appImageConfigName', cdk.validateString)(properties.appImageConfigName));
    errors.collect(cdk.propertyValidator('imageName', cdk.requiredValidator)(properties.imageName));
    errors.collect(cdk.propertyValidator('imageName', cdk.validateString)(properties.imageName));
    errors.collect(cdk.propertyValidator('imageVersionNumber', cdk.validateNumber)(properties.imageVersionNumber));
    return errors.wrap('supplied properties not correct for "CustomImageProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::Domain.CustomImage` resource
 *
 * @param properties - the TypeScript properties of a `CustomImageProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::Domain.CustomImage` resource.
 */
// @ts-ignore TS6133
function cfnDomainCustomImagePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDomain_CustomImagePropertyValidator(properties).assertSuccess();
    return {
        AppImageConfigName: cdk.stringToCloudFormation(properties.appImageConfigName),
        ImageName: cdk.stringToCloudFormation(properties.imageName),
        ImageVersionNumber: cdk.numberToCloudFormation(properties.imageVersionNumber),
    };
}
// @ts-ignore TS6133
function CfnDomainCustomImagePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('appImageConfigName', 'AppImageConfigName', cfn_parse.FromCloudFormation.getString(properties.AppImageConfigName));
    ret.addPropertyResult('imageName', 'ImageName', cfn_parse.FromCloudFormation.getString(properties.ImageName));
    ret.addPropertyResult('imageVersionNumber', 'ImageVersionNumber', properties.ImageVersionNumber != null ? cfn_parse.FromCloudFormation.getNumber(properties.ImageVersionNumber) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DomainSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `DomainSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnDomain_DomainSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('rStudioServerProDomainSettings', CfnDomain_RStudioServerProDomainSettingsPropertyValidator)(properties.rStudioServerProDomainSettings));
    errors.collect(cdk.propertyValidator('securityGroupIds', cdk.listValidator(cdk.validateString))(properties.securityGroupIds));
    return errors.wrap('supplied properties not correct for "DomainSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::Domain.DomainSettings` resource
 *
 * @param properties - the TypeScript properties of a `DomainSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::Domain.DomainSettings` resource.
 */
// @ts-ignore TS6133
function cfnDomainDomainSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDomain_DomainSettingsPropertyValidator(properties).assertSuccess();
    return {
        RStudioServerProDomainSettings: cfnDomainRStudioServerProDomainSettingsPropertyToCloudFormation(properties.rStudioServerProDomainSettings),
        SecurityGroupIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.securityGroupIds),
    };
}
// @ts-ignore TS6133
function CfnDomainDomainSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('rStudioServerProDomainSettings', 'RStudioServerProDomainSettings', properties.RStudioServerProDomainSettings != null ? CfnDomainRStudioServerProDomainSettingsPropertyFromCloudFormation(properties.RStudioServerProDomainSettings) : undefined);
    ret.addPropertyResult('securityGroupIds', 'SecurityGroupIds', properties.SecurityGroupIds != null ? cfn_parse.FromCloudFormation.getStringArray(properties.SecurityGroupIds) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `JupyterServerAppSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `JupyterServerAppSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnDomain_JupyterServerAppSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('defaultResourceSpec', CfnDomain_ResourceSpecPropertyValidator)(properties.defaultResourceSpec));
    return errors.wrap('supplied properties not correct for "JupyterServerAppSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::Domain.JupyterServerAppSettings` resource
 *
 * @param properties - the TypeScript properties of a `JupyterServerAppSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::Domain.JupyterServerAppSettings` resource.
 */
// @ts-ignore TS6133
function cfnDomainJupyterServerAppSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDomain_JupyterServerAppSettingsPropertyValidator(properties).assertSuccess();
    return {
        DefaultResourceSpec: cfnDomainResourceSpecPropertyToCloudFormation(properties.defaultResourceSpec),
    };
}
// @ts-ignore TS6133
function CfnDomainJupyterServerAppSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('defaultResourceSpec', 'DefaultResourceSpec', properties.DefaultResourceSpec != null ? CfnDomainResourceSpecPropertyFromCloudFormation(properties.DefaultResourceSpec) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `KernelGatewayAppSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `KernelGatewayAppSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnDomain_KernelGatewayAppSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('customImages', cdk.listValidator(CfnDomain_CustomImagePropertyValidator))(properties.customImages));
    errors.collect(cdk.propertyValidator('defaultResourceSpec', CfnDomain_ResourceSpecPropertyValidator)(properties.defaultResourceSpec));
    return errors.wrap('supplied properties not correct for "KernelGatewayAppSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::Domain.KernelGatewayAppSettings` resource
 *
 * @param properties - the TypeScript properties of a `KernelGatewayAppSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::Domain.KernelGatewayAppSettings` resource.
 */
// @ts-ignore TS6133
function cfnDomainKernelGatewayAppSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDomain_KernelGatewayAppSettingsPropertyValidator(properties).assertSuccess();
    return {
        CustomImages: cdk.listMapper(cfnDomainCustomImagePropertyToCloudFormation)(properties.customImages),
        DefaultResourceSpec: cfnDomainResourceSpecPropertyToCloudFormation(properties.defaultResourceSpec),
    };
}
// @ts-ignore TS6133
function CfnDomainKernelGatewayAppSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('customImages', 'CustomImages', properties.CustomImages != null ? cfn_parse.FromCloudFormation.getArray(CfnDomainCustomImagePropertyFromCloudFormation)(properties.CustomImages) : undefined);
    ret.addPropertyResult('defaultResourceSpec', 'DefaultResourceSpec', properties.DefaultResourceSpec != null ? CfnDomainResourceSpecPropertyFromCloudFormation(properties.DefaultResourceSpec) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `RSessionAppSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `RSessionAppSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnDomain_RSessionAppSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('customImages', cdk.listValidator(CfnDomain_CustomImagePropertyValidator))(properties.customImages));
    errors.collect(cdk.propertyValidator('defaultResourceSpec', CfnDomain_ResourceSpecPropertyValidator)(properties.defaultResourceSpec));
    return errors.wrap('supplied properties not correct for "RSessionAppSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::Domain.RSessionAppSettings` resource
 *
 * @param properties - the TypeScript properties of a `RSessionAppSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::Domain.RSessionAppSettings` resource.
 */
// @ts-ignore TS6133
function cfnDomainRSessionAppSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDomain_RSessionAppSettingsPropertyValidator(properties).assertSuccess();
    return {
        CustomImages: cdk.listMapper(cfnDomainCustomImagePropertyToCloudFormation)(properties.customImages),
        DefaultResourceSpec: cfnDomainResourceSpecPropertyToCloudFormation(properties.defaultResourceSpec),
    };
}
// @ts-ignore TS6133
function CfnDomainRSessionAppSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('customImages', 'CustomImages', properties.CustomImages != null ? cfn_parse.FromCloudFormation.getArray(CfnDomainCustomImagePropertyFromCloudFormation)(properties.CustomImages) : undefined);
    ret.addPropertyResult('defaultResourceSpec', 'DefaultResourceSpec', properties.DefaultResourceSpec != null ? CfnDomainResourceSpecPropertyFromCloudFormation(properties.DefaultResourceSpec) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `RStudioServerProAppSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `RStudioServerProAppSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnDomain_RStudioServerProAppSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('accessStatus', cdk.validateString)(properties.accessStatus));
    errors.collect(cdk.propertyValidator('userGroup', cdk.validateString)(properties.userGroup));
    return errors.wrap('supplied properties not correct for "RStudioServerProAppSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::Domain.RStudioServerProAppSettings` resource
 *
 * @param properties - the TypeScript properties of a `RStudioServerProAppSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::Domain.RStudioServerProAppSettings` resource.
 */
// @ts-ignore TS6133
function cfnDomainRStudioServerProAppSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDomain_RStudioServerProAppSettingsPropertyValidator(properties).assertSuccess();
    return {
        AccessStatus: cdk.stringToCloudFormation(properties.accessStatus),
        UserGroup: cdk.stringToCloudFormation(properties.userGroup),
    };
}
// @ts-ignore TS6133
function CfnDomainRStudioServerProAppSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('accessStatus', 'AccessStatus', properties.AccessStatus != null ? cfn_parse.FromCloudFormation.getString(properties.AccessStatus) : undefined);
    ret.addPropertyResult('userGroup', 'UserGroup', properties.UserGroup != null ? cfn_parse.FromCloudFormation.getString(properties.UserGroup) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `RStudioServerProDomainSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `RStudioServerProDomainSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnDomain_RStudioServerProDomainSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('defaultResourceSpec', CfnDomain_ResourceSpecPropertyValidator)(properties.defaultResourceSpec));
    errors.collect(cdk.propertyValidator('domainExecutionRoleArn', cdk.requiredValidator)(properties.domainExecutionRoleArn));
    errors.collect(cdk.propertyValidator('domainExecutionRoleArn', cdk.validateString)(properties.domainExecutionRoleArn));
    errors.collect(cdk.propertyValidator('rStudioConnectUrl', cdk.validateString)(properties.rStudioConnectUrl));
    errors.collect(cdk.propertyValidator('rStudioPackageManagerUrl', cdk.validateString)(properties.rStudioPackageManagerUrl));
    return errors.wrap('supplied properties not correct for "RStudioServerProDomainSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::Domain.RStudioServerProDomainSettings` resource
 *
 * @param properties - the TypeScript properties of a `RStudioServerProDomainSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::Domain.RStudioServerProDomainSettings` resource.
 */
// @ts-ignore TS6133
function cfnDomainRStudioServerProDomainSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDomain_RStudioServerProDomainSettingsPropertyValidator(properties).assertSuccess();
    return {
        DefaultResourceSpec: cfnDomainResourceSpecPropertyToCloudFormation(properties.defaultResourceSpec),
        DomainExecutionRoleArn: cdk.stringToCloudFormation(properties.domainExecutionRoleArn),
        RStudioConnectUrl: cdk.stringToCloudFormation(properties.rStudioConnectUrl),
        RStudioPackageManagerUrl: cdk.stringToCloudFormation(properties.rStudioPackageManagerUrl),
    };
}
// @ts-ignore TS6133
function CfnDomainRStudioServerProDomainSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('defaultResourceSpec', 'DefaultResourceSpec', properties.DefaultResourceSpec != null ? CfnDomainResourceSpecPropertyFromCloudFormation(properties.DefaultResourceSpec) : undefined);
    ret.addPropertyResult('domainExecutionRoleArn', 'DomainExecutionRoleArn', cfn_parse.FromCloudFormation.getString(properties.DomainExecutionRoleArn));
    ret.addPropertyResult('rStudioConnectUrl', 'RStudioConnectUrl', properties.RStudioConnectUrl != null ? cfn_parse.FromCloudFormation.getString(properties.RStudioConnectUrl) : undefined);
    ret.addPropertyResult('rStudioPackageManagerUrl', 'RStudioPackageManagerUrl', properties.RStudioPackageManagerUrl != null ? cfn_parse.FromCloudFormation.getString(properties.RStudioPackageManagerUrl) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ResourceSpecProperty`
 *
 * @param properties - the TypeScript properties of a `ResourceSpecProperty`
 *
 * @returns the result of the validation.
 */
function CfnDomain_ResourceSpecPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('instanceType', cdk.validateString)(properties.instanceType));
    errors.collect(cdk.propertyValidator('lifecycleConfigArn', cdk.validateString)(properties.lifecycleConfigArn));
    errors.collect(cdk.propertyValidator('sageMakerImageArn', cdk.validateString)(properties.sageMakerImageArn));
    errors.collect(cdk.propertyValidator('sageMakerImageVersionArn', cdk.validateString)(properties.sageMakerImageVersionArn));
    return errors.wrap('supplied properties not correct for "ResourceSpecProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::Domain.ResourceSpec` resource
 *
 * @param properties - the TypeScript properties of a `ResourceSpecProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::Domain.ResourceSpec` resource.
 */
// @ts-ignore TS6133
function cfnDomainResourceSpecPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDomain_ResourceSpecPropertyValidator(properties).assertSuccess();
    return {
        InstanceType: cdk.stringToCloudFormation(properties.instanceType),
        LifecycleConfigArn: cdk.stringToCloudFormation(properties.lifecycleConfigArn),
        SageMakerImageArn: cdk.stringToCloudFormation(properties.sageMakerImageArn),
        SageMakerImageVersionArn: cdk.stringToCloudFormation(properties.sageMakerImageVersionArn),
    };
}
// @ts-ignore TS6133
function CfnDomainResourceSpecPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('instanceType', 'InstanceType', properties.InstanceType != null ? cfn_parse.FromCloudFormation.getString(properties.InstanceType) : undefined);
    ret.addPropertyResult('lifecycleConfigArn', 'LifecycleConfigArn', properties.LifecycleConfigArn != null ? cfn_parse.FromCloudFormation.getString(properties.LifecycleConfigArn) : undefined);
    ret.addPropertyResult('sageMakerImageArn', 'SageMakerImageArn', properties.SageMakerImageArn != null ? cfn_parse.FromCloudFormation.getString(properties.SageMakerImageArn) : undefined);
    ret.addPropertyResult('sageMakerImageVersionArn', 'SageMakerImageVersionArn', properties.SageMakerImageVersionArn != null ? cfn_parse.FromCloudFormation.getString(properties.SageMakerImageVersionArn) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `SharingSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `SharingSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnDomain_SharingSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('notebookOutputOption', cdk.validateString)(properties.notebookOutputOption));
    errors.collect(cdk.propertyValidator('s3KmsKeyId', cdk.validateString)(properties.s3KmsKeyId));
    errors.collect(cdk.propertyValidator('s3OutputPath', cdk.validateString)(properties.s3OutputPath));
    return errors.wrap('supplied properties not correct for "SharingSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::Domain.SharingSettings` resource
 *
 * @param properties - the TypeScript properties of a `SharingSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::Domain.SharingSettings` resource.
 */
// @ts-ignore TS6133
function cfnDomainSharingSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDomain_SharingSettingsPropertyValidator(properties).assertSuccess();
    return {
        NotebookOutputOption: cdk.stringToCloudFormation(properties.notebookOutputOption),
        S3KmsKeyId: cdk.stringToCloudFormation(properties.s3KmsKeyId),
        S3OutputPath: cdk.stringToCloudFormation(properties.s3OutputPath),
    };
}
// @ts-ignore TS6133
function CfnDomainSharingSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('notebookOutputOption', 'NotebookOutputOption', properties.NotebookOutputOption != null ? cfn_parse.FromCloudFormation.getString(properties.NotebookOutputOption) : undefined);
    ret.addPropertyResult('s3KmsKeyId', 'S3KmsKeyId', properties.S3KmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.S3KmsKeyId) : undefined);
    ret.addPropertyResult('s3OutputPath', 'S3OutputPath', properties.S3OutputPath != null ? cfn_parse.FromCloudFormation.getString(properties.S3OutputPath) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `UserSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `UserSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnDomain_UserSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('executionRole', cdk.validateString)(properties.executionRole));
    errors.collect(cdk.propertyValidator('jupyterServerAppSettings', CfnDomain_JupyterServerAppSettingsPropertyValidator)(properties.jupyterServerAppSettings));
    errors.collect(cdk.propertyValidator('kernelGatewayAppSettings', CfnDomain_KernelGatewayAppSettingsPropertyValidator)(properties.kernelGatewayAppSettings));
    errors.collect(cdk.propertyValidator('rSessionAppSettings', CfnDomain_RSessionAppSettingsPropertyValidator)(properties.rSessionAppSettings));
    errors.collect(cdk.propertyValidator('rStudioServerProAppSettings', CfnDomain_RStudioServerProAppSettingsPropertyValidator)(properties.rStudioServerProAppSettings));
    errors.collect(cdk.propertyValidator('securityGroups', cdk.listValidator(cdk.validateString))(properties.securityGroups));
    errors.collect(cdk.propertyValidator('sharingSettings', CfnDomain_SharingSettingsPropertyValidator)(properties.sharingSettings));
    return errors.wrap('supplied properties not correct for "UserSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::Domain.UserSettings` resource
 *
 * @param properties - the TypeScript properties of a `UserSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::Domain.UserSettings` resource.
 */
// @ts-ignore TS6133
function cfnDomainUserSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDomain_UserSettingsPropertyValidator(properties).assertSuccess();
    return {
        ExecutionRole: cdk.stringToCloudFormation(properties.executionRole),
        JupyterServerAppSettings: cfnDomainJupyterServerAppSettingsPropertyToCloudFormation(properties.jupyterServerAppSettings),
        KernelGatewayAppSettings: cfnDomainKernelGatewayAppSettingsPropertyToCloudFormation(properties.kernelGatewayAppSettings),
        RSessionAppSettings: cfnDomainRSessionAppSettingsPropertyToCloudFormation(properties.rSessionAppSettings),
        RStudioServerProAppSettings: cfnDomainRStudioServerProAppSettingsPropertyToCloudFormation(properties.rStudioServerProAppSettings),
        SecurityGroups: cdk.listMapper(cdk.stringToCloudFormation)(properties.securityGroups),
        SharingSettings: cfnDomainSharingSettingsPropertyToCloudFormation(properties.sharingSettings),
    };
}
// @ts-ignore TS6133
function CfnDomainUserSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('executionRole', 'ExecutionRole', properties.ExecutionRole != null ? cfn_parse.FromCloudFormation.getString(properties.ExecutionRole) : undefined);
    ret.addPropertyResult('jupyterServerAppSettings', 'JupyterServerAppSettings', properties.JupyterServerAppSettings != null ? CfnDomainJupyterServerAppSettingsPropertyFromCloudFormation(properties.JupyterServerAppSettings) : undefined);
    ret.addPropertyResult('kernelGatewayAppSettings', 'KernelGatewayAppSettings', properties.KernelGatewayAppSettings != null ? CfnDomainKernelGatewayAppSettingsPropertyFromCloudFormation(properties.KernelGatewayAppSettings) : undefined);
    ret.addPropertyResult('rSessionAppSettings', 'RSessionAppSettings', properties.RSessionAppSettings != null ? CfnDomainRSessionAppSettingsPropertyFromCloudFormation(properties.RSessionAppSettings) : undefined);
    ret.addPropertyResult('rStudioServerProAppSettings', 'RStudioServerProAppSettings', properties.RStudioServerProAppSettings != null ? CfnDomainRStudioServerProAppSettingsPropertyFromCloudFormation(properties.RStudioServerProAppSettings) : undefined);
    ret.addPropertyResult('securityGroups', 'SecurityGroups', properties.SecurityGroups != null ? cfn_parse.FromCloudFormation.getStringArray(properties.SecurityGroups) : undefined);
    ret.addPropertyResult('sharingSettings', 'SharingSettings', properties.SharingSettings != null ? CfnDomainSharingSettingsPropertyFromCloudFormation(properties.SharingSettings) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnEndpointProps`
 *
 * @param properties - the TypeScript properties of a `CfnEndpointProps`
 *
 * @returns the result of the validation.
 */
function CfnEndpointPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('deploymentConfig', CfnEndpoint_DeploymentConfigPropertyValidator)(properties.deploymentConfig));
    errors.collect(cdk.propertyValidator('endpointConfigName', cdk.requiredValidator)(properties.endpointConfigName));
    errors.collect(cdk.propertyValidator('endpointConfigName', cdk.validateString)(properties.endpointConfigName));
    errors.collect(cdk.propertyValidator('endpointName', cdk.validateString)(properties.endpointName));
    errors.collect(cdk.propertyValidator('excludeRetainedVariantProperties', cdk.listValidator(CfnEndpoint_VariantPropertyPropertyValidator))(properties.excludeRetainedVariantProperties));
    errors.collect(cdk.propertyValidator('retainAllVariantProperties', cdk.validateBoolean)(properties.retainAllVariantProperties));
    errors.collect(cdk.propertyValidator('retainDeploymentConfig', cdk.validateBoolean)(properties.retainDeploymentConfig));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnEndpointProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::Endpoint` resource
 *
 * @param properties - the TypeScript properties of a `CfnEndpointProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::Endpoint` resource.
 */
// @ts-ignore TS6133
function cfnEndpointPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpointPropsValidator(properties).assertSuccess();
    return {
        EndpointConfigName: cdk.stringToCloudFormation(properties.endpointConfigName),
        DeploymentConfig: cfnEndpointDeploymentConfigPropertyToCloudFormation(properties.deploymentConfig),
        EndpointName: cdk.stringToCloudFormation(properties.endpointName),
        ExcludeRetainedVariantProperties: cdk.listMapper(cfnEndpointVariantPropertyPropertyToCloudFormation)(properties.excludeRetainedVariantProperties),
        RetainAllVariantProperties: cdk.booleanToCloudFormation(properties.retainAllVariantProperties),
        RetainDeploymentConfig: cdk.booleanToCloudFormation(properties.retainDeploymentConfig),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnEndpointPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('endpointConfigName', 'EndpointConfigName', cfn_parse.FromCloudFormation.getString(properties.EndpointConfigName));
    ret.addPropertyResult('deploymentConfig', 'DeploymentConfig', properties.DeploymentConfig != null ? CfnEndpointDeploymentConfigPropertyFromCloudFormation(properties.DeploymentConfig) : undefined);
    ret.addPropertyResult('endpointName', 'EndpointName', properties.EndpointName != null ? cfn_parse.FromCloudFormation.getString(properties.EndpointName) : undefined);
    ret.addPropertyResult('excludeRetainedVariantProperties', 'ExcludeRetainedVariantProperties', properties.ExcludeRetainedVariantProperties != null ? cfn_parse.FromCloudFormation.getArray(CfnEndpointVariantPropertyPropertyFromCloudFormation)(properties.ExcludeRetainedVariantProperties) : undefined);
    ret.addPropertyResult('retainAllVariantProperties', 'RetainAllVariantProperties', properties.RetainAllVariantProperties != null ? cfn_parse.FromCloudFormation.getBoolean(properties.RetainAllVariantProperties) : undefined);
    ret.addPropertyResult('retainDeploymentConfig', 'RetainDeploymentConfig', properties.RetainDeploymentConfig != null ? cfn_parse.FromCloudFormation.getBoolean(properties.RetainDeploymentConfig) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::SageMaker::Endpoint`
 *
 * Use the `AWS::SageMaker::Endpoint` resource to create an endpoint using the specified configuration in the request. Amazon SageMaker uses the endpoint to provision resources and deploy models. You create the endpoint configuration with the [AWS::SageMaker::EndpointConfig](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html) resource. For more information, see [Deploy a Model on Amazon SageMaker Hosting Services](https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works-hosting.html) in the *Amazon SageMaker Developer Guide* .
 *
 * @cloudformationResource AWS::SageMaker::Endpoint
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html
 */
class CfnEndpoint extends cdk.CfnResource {
    /**
     * Create a new `AWS::SageMaker::Endpoint`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnEndpoint.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_sagemaker_CfnEndpointProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnEndpoint);
            }
            throw error;
        }
        cdk.requireProperty(props, 'endpointConfigName', this);
        this.attrEndpointName = cdk.Token.asString(this.getAtt('EndpointName'));
        this.endpointConfigName = props.endpointConfigName;
        this.deploymentConfig = props.deploymentConfig;
        this.endpointName = props.endpointName;
        this.excludeRetainedVariantProperties = props.excludeRetainedVariantProperties;
        this.retainAllVariantProperties = props.retainAllVariantProperties;
        this.retainDeploymentConfig = props.retainDeploymentConfig;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::SageMaker::Endpoint", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnEndpointPropsFromCloudFormation(resourceProperties);
        const ret = new CfnEndpoint(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnEndpoint.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            endpointConfigName: this.endpointConfigName,
            deploymentConfig: this.deploymentConfig,
            endpointName: this.endpointName,
            excludeRetainedVariantProperties: this.excludeRetainedVariantProperties,
            retainAllVariantProperties: this.retainAllVariantProperties,
            retainDeploymentConfig: this.retainDeploymentConfig,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnEndpointPropsToCloudFormation(props);
    }
}
exports.CfnEndpoint = CfnEndpoint;
_h = JSII_RTTI_SYMBOL_1;
CfnEndpoint[_h] = { fqn: "@aws-cdk/aws-sagemaker.CfnEndpoint", version: "1.186.1" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnEndpoint.CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::Endpoint";
/**
 * Determine whether the given properties match those of a `AlarmProperty`
 *
 * @param properties - the TypeScript properties of a `AlarmProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpoint_AlarmPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('alarmName', cdk.requiredValidator)(properties.alarmName));
    errors.collect(cdk.propertyValidator('alarmName', cdk.validateString)(properties.alarmName));
    return errors.wrap('supplied properties not correct for "AlarmProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::Endpoint.Alarm` resource
 *
 * @param properties - the TypeScript properties of a `AlarmProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::Endpoint.Alarm` resource.
 */
// @ts-ignore TS6133
function cfnEndpointAlarmPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpoint_AlarmPropertyValidator(properties).assertSuccess();
    return {
        AlarmName: cdk.stringToCloudFormation(properties.alarmName),
    };
}
// @ts-ignore TS6133
function CfnEndpointAlarmPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('alarmName', 'AlarmName', cfn_parse.FromCloudFormation.getString(properties.AlarmName));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `AutoRollbackConfigProperty`
 *
 * @param properties - the TypeScript properties of a `AutoRollbackConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpoint_AutoRollbackConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('alarms', cdk.requiredValidator)(properties.alarms));
    errors.collect(cdk.propertyValidator('alarms', cdk.listValidator(CfnEndpoint_AlarmPropertyValidator))(properties.alarms));
    return errors.wrap('supplied properties not correct for "AutoRollbackConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::Endpoint.AutoRollbackConfig` resource
 *
 * @param properties - the TypeScript properties of a `AutoRollbackConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::Endpoint.AutoRollbackConfig` resource.
 */
// @ts-ignore TS6133
function cfnEndpointAutoRollbackConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpoint_AutoRollbackConfigPropertyValidator(properties).assertSuccess();
    return {
        Alarms: cdk.listMapper(cfnEndpointAlarmPropertyToCloudFormation)(properties.alarms),
    };
}
// @ts-ignore TS6133
function CfnEndpointAutoRollbackConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('alarms', 'Alarms', cfn_parse.FromCloudFormation.getArray(CfnEndpointAlarmPropertyFromCloudFormation)(properties.Alarms));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `BlueGreenUpdatePolicyProperty`
 *
 * @param properties - the TypeScript properties of a `BlueGreenUpdatePolicyProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpoint_BlueGreenUpdatePolicyPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('maximumExecutionTimeoutInSeconds', cdk.validateNumber)(properties.maximumExecutionTimeoutInSeconds));
    errors.collect(cdk.propertyValidator('terminationWaitInSeconds', cdk.validateNumber)(properties.terminationWaitInSeconds));
    errors.collect(cdk.propertyValidator('trafficRoutingConfiguration', cdk.requiredValidator)(properties.trafficRoutingConfiguration));
    errors.collect(cdk.propertyValidator('trafficRoutingConfiguration', CfnEndpoint_TrafficRoutingConfigPropertyValidator)(properties.trafficRoutingConfiguration));
    return errors.wrap('supplied properties not correct for "BlueGreenUpdatePolicyProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::Endpoint.BlueGreenUpdatePolicy` resource
 *
 * @param properties - the TypeScript properties of a `BlueGreenUpdatePolicyProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::Endpoint.BlueGreenUpdatePolicy` resource.
 */
// @ts-ignore TS6133
function cfnEndpointBlueGreenUpdatePolicyPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpoint_BlueGreenUpdatePolicyPropertyValidator(properties).assertSuccess();
    return {
        MaximumExecutionTimeoutInSeconds: cdk.numberToCloudFormation(properties.maximumExecutionTimeoutInSeconds),
        TerminationWaitInSeconds: cdk.numberToCloudFormation(properties.terminationWaitInSeconds),
        TrafficRoutingConfiguration: cfnEndpointTrafficRoutingConfigPropertyToCloudFormation(properties.trafficRoutingConfiguration),
    };
}
// @ts-ignore TS6133
function CfnEndpointBlueGreenUpdatePolicyPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('maximumExecutionTimeoutInSeconds', 'MaximumExecutionTimeoutInSeconds', properties.MaximumExecutionTimeoutInSeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaximumExecutionTimeoutInSeconds) : undefined);
    ret.addPropertyResult('terminationWaitInSeconds', 'TerminationWaitInSeconds', properties.TerminationWaitInSeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.TerminationWaitInSeconds) : undefined);
    ret.addPropertyResult('trafficRoutingConfiguration', 'TrafficRoutingConfiguration', CfnEndpointTrafficRoutingConfigPropertyFromCloudFormation(properties.TrafficRoutingConfiguration));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CapacitySizeProperty`
 *
 * @param properties - the TypeScript properties of a `CapacitySizeProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpoint_CapacitySizePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('type', cdk.requiredValidator)(properties.type));
    errors.collect(cdk.propertyValidator('type', cdk.validateString)(properties.type));
    errors.collect(cdk.propertyValidator('value', cdk.requiredValidator)(properties.value));
    errors.collect(cdk.propertyValidator('value', cdk.validateNumber)(properties.value));
    return errors.wrap('supplied properties not correct for "CapacitySizeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::Endpoint.CapacitySize` resource
 *
 * @param properties - the TypeScript properties of a `CapacitySizeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::Endpoint.CapacitySize` resource.
 */
// @ts-ignore TS6133
function cfnEndpointCapacitySizePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpoint_CapacitySizePropertyValidator(properties).assertSuccess();
    return {
        Type: cdk.stringToCloudFormation(properties.type),
        Value: cdk.numberToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnEndpointCapacitySizePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('type', 'Type', cfn_parse.FromCloudFormation.getString(properties.Type));
    ret.addPropertyResult('value', 'Value', cfn_parse.FromCloudFormation.getNumber(properties.Value));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DeploymentConfigProperty`
 *
 * @param properties - the TypeScript properties of a `DeploymentConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpoint_DeploymentConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('autoRollbackConfiguration', CfnEndpoint_AutoRollbackConfigPropertyValidator)(properties.autoRollbackConfiguration));
    errors.collect(cdk.propertyValidator('blueGreenUpdatePolicy', cdk.requiredValidator)(properties.blueGreenUpdatePolicy));
    errors.collect(cdk.propertyValidator('blueGreenUpdatePolicy', CfnEndpoint_BlueGreenUpdatePolicyPropertyValidator)(properties.blueGreenUpdatePolicy));
    return errors.wrap('supplied properties not correct for "DeploymentConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::Endpoint.DeploymentConfig` resource
 *
 * @param properties - the TypeScript properties of a `DeploymentConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::Endpoint.DeploymentConfig` resource.
 */
// @ts-ignore TS6133
function cfnEndpointDeploymentConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpoint_DeploymentConfigPropertyValidator(properties).assertSuccess();
    return {
        AutoRollbackConfiguration: cfnEndpointAutoRollbackConfigPropertyToCloudFormation(properties.autoRollbackConfiguration),
        BlueGreenUpdatePolicy: cfnEndpointBlueGreenUpdatePolicyPropertyToCloudFormation(properties.blueGreenUpdatePolicy),
    };
}
// @ts-ignore TS6133
function CfnEndpointDeploymentConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('autoRollbackConfiguration', 'AutoRollbackConfiguration', properties.AutoRollbackConfiguration != null ? CfnEndpointAutoRollbackConfigPropertyFromCloudFormation(properties.AutoRollbackConfiguration) : undefined);
    ret.addPropertyResult('blueGreenUpdatePolicy', 'BlueGreenUpdatePolicy', CfnEndpointBlueGreenUpdatePolicyPropertyFromCloudFormation(properties.BlueGreenUpdatePolicy));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `TrafficRoutingConfigProperty`
 *
 * @param properties - the TypeScript properties of a `TrafficRoutingConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpoint_TrafficRoutingConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('canarySize', CfnEndpoint_CapacitySizePropertyValidator)(properties.canarySize));
    errors.collect(cdk.propertyValidator('linearStepSize', CfnEndpoint_CapacitySizePropertyValidator)(properties.linearStepSize));
    errors.collect(cdk.propertyValidator('type', cdk.requiredValidator)(properties.type));
    errors.collect(cdk.propertyValidator('type', cdk.validateString)(properties.type));
    errors.collect(cdk.propertyValidator('waitIntervalInSeconds', cdk.validateNumber)(properties.waitIntervalInSeconds));
    return errors.wrap('supplied properties not correct for "TrafficRoutingConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::Endpoint.TrafficRoutingConfig` resource
 *
 * @param properties - the TypeScript properties of a `TrafficRoutingConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::Endpoint.TrafficRoutingConfig` resource.
 */
// @ts-ignore TS6133
function cfnEndpointTrafficRoutingConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpoint_TrafficRoutingConfigPropertyValidator(properties).assertSuccess();
    return {
        CanarySize: cfnEndpointCapacitySizePropertyToCloudFormation(properties.canarySize),
        LinearStepSize: cfnEndpointCapacitySizePropertyToCloudFormation(properties.linearStepSize),
        Type: cdk.stringToCloudFormation(properties.type),
        WaitIntervalInSeconds: cdk.numberToCloudFormation(properties.waitIntervalInSeconds),
    };
}
// @ts-ignore TS6133
function CfnEndpointTrafficRoutingConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('canarySize', 'CanarySize', properties.CanarySize != null ? CfnEndpointCapacitySizePropertyFromCloudFormation(properties.CanarySize) : undefined);
    ret.addPropertyResult('linearStepSize', 'LinearStepSize', properties.LinearStepSize != null ? CfnEndpointCapacitySizePropertyFromCloudFormation(properties.LinearStepSize) : undefined);
    ret.addPropertyResult('type', 'Type', cfn_parse.FromCloudFormation.getString(properties.Type));
    ret.addPropertyResult('waitIntervalInSeconds', 'WaitIntervalInSeconds', properties.WaitIntervalInSeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.WaitIntervalInSeconds) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `VariantPropertyProperty`
 *
 * @param properties - the TypeScript properties of a `VariantPropertyProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpoint_VariantPropertyPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('variantPropertyType', cdk.validateString)(properties.variantPropertyType));
    return errors.wrap('supplied properties not correct for "VariantPropertyProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::Endpoint.VariantProperty` resource
 *
 * @param properties - the TypeScript properties of a `VariantPropertyProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::Endpoint.VariantProperty` resource.
 */
// @ts-ignore TS6133
function cfnEndpointVariantPropertyPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpoint_VariantPropertyPropertyValidator(properties).assertSuccess();
    return {
        VariantPropertyType: cdk.stringToCloudFormation(properties.variantPropertyType),
    };
}
// @ts-ignore TS6133
function CfnEndpointVariantPropertyPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('variantPropertyType', 'VariantPropertyType', properties.VariantPropertyType != null ? cfn_parse.FromCloudFormation.getString(properties.VariantPropertyType) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnEndpointConfigProps`
 *
 * @param properties - the TypeScript properties of a `CfnEndpointConfigProps`
 *
 * @returns the result of the validation.
 */
function CfnEndpointConfigPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('asyncInferenceConfig', CfnEndpointConfig_AsyncInferenceConfigPropertyValidator)(properties.asyncInferenceConfig));
    errors.collect(cdk.propertyValidator('dataCaptureConfig', CfnEndpointConfig_DataCaptureConfigPropertyValidator)(properties.dataCaptureConfig));
    errors.collect(cdk.propertyValidator('endpointConfigName', cdk.validateString)(properties.endpointConfigName));
    errors.collect(cdk.propertyValidator('explainerConfig', CfnEndpointConfig_ExplainerConfigPropertyValidator)(properties.explainerConfig));
    errors.collect(cdk.propertyValidator('kmsKeyId', cdk.validateString)(properties.kmsKeyId));
    errors.collect(cdk.propertyValidator('productionVariants', cdk.requiredValidator)(properties.productionVariants));
    errors.collect(cdk.propertyValidator('productionVariants', cdk.listValidator(CfnEndpointConfig_ProductionVariantPropertyValidator))(properties.productionVariants));
    errors.collect(cdk.propertyValidator('shadowProductionVariants', cdk.listValidator(CfnEndpointConfig_ProductionVariantPropertyValidator))(properties.shadowProductionVariants));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnEndpointConfigProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::EndpointConfig` resource
 *
 * @param properties - the TypeScript properties of a `CfnEndpointConfigProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::EndpointConfig` resource.
 */
// @ts-ignore TS6133
function cfnEndpointConfigPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpointConfigPropsValidator(properties).assertSuccess();
    return {
        ProductionVariants: cdk.listMapper(cfnEndpointConfigProductionVariantPropertyToCloudFormation)(properties.productionVariants),
        AsyncInferenceConfig: cfnEndpointConfigAsyncInferenceConfigPropertyToCloudFormation(properties.asyncInferenceConfig),
        DataCaptureConfig: cfnEndpointConfigDataCaptureConfigPropertyToCloudFormation(properties.dataCaptureConfig),
        EndpointConfigName: cdk.stringToCloudFormation(properties.endpointConfigName),
        ExplainerConfig: cfnEndpointConfigExplainerConfigPropertyToCloudFormation(properties.explainerConfig),
        KmsKeyId: cdk.stringToCloudFormation(properties.kmsKeyId),
        ShadowProductionVariants: cdk.listMapper(cfnEndpointConfigProductionVariantPropertyToCloudFormation)(properties.shadowProductionVariants),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnEndpointConfigPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('productionVariants', 'ProductionVariants', cfn_parse.FromCloudFormation.getArray(CfnEndpointConfigProductionVariantPropertyFromCloudFormation)(properties.ProductionVariants));
    ret.addPropertyResult('asyncInferenceConfig', 'AsyncInferenceConfig', properties.AsyncInferenceConfig != null ? CfnEndpointConfigAsyncInferenceConfigPropertyFromCloudFormation(properties.AsyncInferenceConfig) : undefined);
    ret.addPropertyResult('dataCaptureConfig', 'DataCaptureConfig', properties.DataCaptureConfig != null ? CfnEndpointConfigDataCaptureConfigPropertyFromCloudFormation(properties.DataCaptureConfig) : undefined);
    ret.addPropertyResult('endpointConfigName', 'EndpointConfigName', properties.EndpointConfigName != null ? cfn_parse.FromCloudFormation.getString(properties.EndpointConfigName) : undefined);
    ret.addPropertyResult('explainerConfig', 'ExplainerConfig', properties.ExplainerConfig != null ? CfnEndpointConfigExplainerConfigPropertyFromCloudFormation(properties.ExplainerConfig) : undefined);
    ret.addPropertyResult('kmsKeyId', 'KmsKeyId', properties.KmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.KmsKeyId) : undefined);
    ret.addPropertyResult('shadowProductionVariants', 'ShadowProductionVariants', properties.ShadowProductionVariants != null ? cfn_parse.FromCloudFormation.getArray(CfnEndpointConfigProductionVariantPropertyFromCloudFormation)(properties.ShadowProductionVariants) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::SageMaker::EndpointConfig`
 *
 * The `AWS::SageMaker::EndpointConfig` resource creates a configuration for an Amazon SageMaker endpoint. For more information, see [CreateEndpointConfig](https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html) in the *SageMaker Developer Guide* .
 *
 * @cloudformationResource AWS::SageMaker::EndpointConfig
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html
 */
class CfnEndpointConfig extends cdk.CfnResource {
    /**
     * Create a new `AWS::SageMaker::EndpointConfig`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnEndpointConfig.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_sagemaker_CfnEndpointConfigProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnEndpointConfig);
            }
            throw error;
        }
        cdk.requireProperty(props, 'productionVariants', this);
        this.attrEndpointConfigName = cdk.Token.asString(this.getAtt('EndpointConfigName'));
        this.productionVariants = props.productionVariants;
        this.asyncInferenceConfig = props.asyncInferenceConfig;
        this.dataCaptureConfig = props.dataCaptureConfig;
        this.endpointConfigName = props.endpointConfigName;
        this.explainerConfig = props.explainerConfig;
        this.kmsKeyId = props.kmsKeyId;
        this.shadowProductionVariants = props.shadowProductionVariants;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::SageMaker::EndpointConfig", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnEndpointConfigPropsFromCloudFormation(resourceProperties);
        const ret = new CfnEndpointConfig(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnEndpointConfig.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            productionVariants: this.productionVariants,
            asyncInferenceConfig: this.asyncInferenceConfig,
            dataCaptureConfig: this.dataCaptureConfig,
            endpointConfigName: this.endpointConfigName,
            explainerConfig: this.explainerConfig,
            kmsKeyId: this.kmsKeyId,
            shadowProductionVariants: this.shadowProductionVariants,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnEndpointConfigPropsToCloudFormation(props);
    }
}
exports.CfnEndpointConfig = CfnEndpointConfig;
_j = JSII_RTTI_SYMBOL_1;
CfnEndpointConfig[_j] = { fqn: "@aws-cdk/aws-sagemaker.CfnEndpointConfig", version: "1.186.1" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnEndpointConfig.CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::EndpointConfig";
/**
 * Determine whether the given properties match those of a `AsyncInferenceClientConfigProperty`
 *
 * @param properties - the TypeScript properties of a `AsyncInferenceClientConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpointConfig_AsyncInferenceClientConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('maxConcurrentInvocationsPerInstance', cdk.validateNumber)(properties.maxConcurrentInvocationsPerInstance));
    return errors.wrap('supplied properties not correct for "AsyncInferenceClientConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::EndpointConfig.AsyncInferenceClientConfig` resource
 *
 * @param properties - the TypeScript properties of a `AsyncInferenceClientConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::EndpointConfig.AsyncInferenceClientConfig` resource.
 */
// @ts-ignore TS6133
function cfnEndpointConfigAsyncInferenceClientConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpointConfig_AsyncInferenceClientConfigPropertyValidator(properties).assertSuccess();
    return {
        MaxConcurrentInvocationsPerInstance: cdk.numberToCloudFormation(properties.maxConcurrentInvocationsPerInstance),
    };
}
// @ts-ignore TS6133
function CfnEndpointConfigAsyncInferenceClientConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('maxConcurrentInvocationsPerInstance', 'MaxConcurrentInvocationsPerInstance', properties.MaxConcurrentInvocationsPerInstance != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxConcurrentInvocationsPerInstance) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `AsyncInferenceConfigProperty`
 *
 * @param properties - the TypeScript properties of a `AsyncInferenceConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpointConfig_AsyncInferenceConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('clientConfig', CfnEndpointConfig_AsyncInferenceClientConfigPropertyValidator)(properties.clientConfig));
    errors.collect(cdk.propertyValidator('outputConfig', cdk.requiredValidator)(properties.outputConfig));
    errors.collect(cdk.propertyValidator('outputConfig', CfnEndpointConfig_AsyncInferenceOutputConfigPropertyValidator)(properties.outputConfig));
    return errors.wrap('supplied properties not correct for "AsyncInferenceConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::EndpointConfig.AsyncInferenceConfig` resource
 *
 * @param properties - the TypeScript properties of a `AsyncInferenceConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::EndpointConfig.AsyncInferenceConfig` resource.
 */
// @ts-ignore TS6133
function cfnEndpointConfigAsyncInferenceConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpointConfig_AsyncInferenceConfigPropertyValidator(properties).assertSuccess();
    return {
        ClientConfig: cfnEndpointConfigAsyncInferenceClientConfigPropertyToCloudFormation(properties.clientConfig),
        OutputConfig: cfnEndpointConfigAsyncInferenceOutputConfigPropertyToCloudFormation(properties.outputConfig),
    };
}
// @ts-ignore TS6133
function CfnEndpointConfigAsyncInferenceConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('clientConfig', 'ClientConfig', properties.ClientConfig != null ? CfnEndpointConfigAsyncInferenceClientConfigPropertyFromCloudFormation(properties.ClientConfig) : undefined);
    ret.addPropertyResult('outputConfig', 'OutputConfig', CfnEndpointConfigAsyncInferenceOutputConfigPropertyFromCloudFormation(properties.OutputConfig));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `AsyncInferenceNotificationConfigProperty`
 *
 * @param properties - the TypeScript properties of a `AsyncInferenceNotificationConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpointConfig_AsyncInferenceNotificationConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('errorTopic', cdk.validateString)(properties.errorTopic));
    errors.collect(cdk.propertyValidator('successTopic', cdk.validateString)(properties.successTopic));
    return errors.wrap('supplied properties not correct for "AsyncInferenceNotificationConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::EndpointConfig.AsyncInferenceNotificationConfig` resource
 *
 * @param properties - the TypeScript properties of a `AsyncInferenceNotificationConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::EndpointConfig.AsyncInferenceNotificationConfig` resource.
 */
// @ts-ignore TS6133
function cfnEndpointConfigAsyncInferenceNotificationConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpointConfig_AsyncInferenceNotificationConfigPropertyValidator(properties).assertSuccess();
    return {
        ErrorTopic: cdk.stringToCloudFormation(properties.errorTopic),
        SuccessTopic: cdk.stringToCloudFormation(properties.successTopic),
    };
}
// @ts-ignore TS6133
function CfnEndpointConfigAsyncInferenceNotificationConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('errorTopic', 'ErrorTopic', properties.ErrorTopic != null ? cfn_parse.FromCloudFormation.getString(properties.ErrorTopic) : undefined);
    ret.addPropertyResult('successTopic', 'SuccessTopic', properties.SuccessTopic != null ? cfn_parse.FromCloudFormation.getString(properties.SuccessTopic) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `AsyncInferenceOutputConfigProperty`
 *
 * @param properties - the TypeScript properties of a `AsyncInferenceOutputConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpointConfig_AsyncInferenceOutputConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('kmsKeyId', cdk.validateString)(properties.kmsKeyId));
    errors.collect(cdk.propertyValidator('notificationConfig', CfnEndpointConfig_AsyncInferenceNotificationConfigPropertyValidator)(properties.notificationConfig));
    errors.collect(cdk.propertyValidator('s3OutputPath', cdk.requiredValidator)(properties.s3OutputPath));
    errors.collect(cdk.propertyValidator('s3OutputPath', cdk.validateString)(properties.s3OutputPath));
    return errors.wrap('supplied properties not correct for "AsyncInferenceOutputConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::EndpointConfig.AsyncInferenceOutputConfig` resource
 *
 * @param properties - the TypeScript properties of a `AsyncInferenceOutputConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::EndpointConfig.AsyncInferenceOutputConfig` resource.
 */
// @ts-ignore TS6133
function cfnEndpointConfigAsyncInferenceOutputConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpointConfig_AsyncInferenceOutputConfigPropertyValidator(properties).assertSuccess();
    return {
        KmsKeyId: cdk.stringToCloudFormation(properties.kmsKeyId),
        NotificationConfig: cfnEndpointConfigAsyncInferenceNotificationConfigPropertyToCloudFormation(properties.notificationConfig),
        S3OutputPath: cdk.stringToCloudFormation(properties.s3OutputPath),
    };
}
// @ts-ignore TS6133
function CfnEndpointConfigAsyncInferenceOutputConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('kmsKeyId', 'KmsKeyId', properties.KmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.KmsKeyId) : undefined);
    ret.addPropertyResult('notificationConfig', 'NotificationConfig', properties.NotificationConfig != null ? CfnEndpointConfigAsyncInferenceNotificationConfigPropertyFromCloudFormation(properties.NotificationConfig) : undefined);
    ret.addPropertyResult('s3OutputPath', 'S3OutputPath', cfn_parse.FromCloudFormation.getString(properties.S3OutputPath));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CaptureContentTypeHeaderProperty`
 *
 * @param properties - the TypeScript properties of a `CaptureContentTypeHeaderProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpointConfig_CaptureContentTypeHeaderPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('csvContentTypes', cdk.listValidator(cdk.validateString))(properties.csvContentTypes));
    errors.collect(cdk.propertyValidator('jsonContentTypes', cdk.listValidator(cdk.validateString))(properties.jsonContentTypes));
    return errors.wrap('supplied properties not correct for "CaptureContentTypeHeaderProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::EndpointConfig.CaptureContentTypeHeader` resource
 *
 * @param properties - the TypeScript properties of a `CaptureContentTypeHeaderProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::EndpointConfig.CaptureContentTypeHeader` resource.
 */
// @ts-ignore TS6133
function cfnEndpointConfigCaptureContentTypeHeaderPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpointConfig_CaptureContentTypeHeaderPropertyValidator(properties).assertSuccess();
    return {
        CsvContentTypes: cdk.listMapper(cdk.stringToCloudFormation)(properties.csvContentTypes),
        JsonContentTypes: cdk.listMapper(cdk.stringToCloudFormation)(properties.jsonContentTypes),
    };
}
// @ts-ignore TS6133
function CfnEndpointConfigCaptureContentTypeHeaderPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('csvContentTypes', 'CsvContentTypes', properties.CsvContentTypes != null ? cfn_parse.FromCloudFormation.getStringArray(properties.CsvContentTypes) : undefined);
    ret.addPropertyResult('jsonContentTypes', 'JsonContentTypes', properties.JsonContentTypes != null ? cfn_parse.FromCloudFormation.getStringArray(properties.JsonContentTypes) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CaptureOptionProperty`
 *
 * @param properties - the TypeScript properties of a `CaptureOptionProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpointConfig_CaptureOptionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('captureMode', cdk.requiredValidator)(properties.captureMode));
    errors.collect(cdk.propertyValidator('captureMode', cdk.validateString)(properties.captureMode));
    return errors.wrap('supplied properties not correct for "CaptureOptionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::EndpointConfig.CaptureOption` resource
 *
 * @param properties - the TypeScript properties of a `CaptureOptionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::EndpointConfig.CaptureOption` resource.
 */
// @ts-ignore TS6133
function cfnEndpointConfigCaptureOptionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpointConfig_CaptureOptionPropertyValidator(properties).assertSuccess();
    return {
        CaptureMode: cdk.stringToCloudFormation(properties.captureMode),
    };
}
// @ts-ignore TS6133
function CfnEndpointConfigCaptureOptionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('captureMode', 'CaptureMode', cfn_parse.FromCloudFormation.getString(properties.CaptureMode));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ClarifyExplainerConfigProperty`
 *
 * @param properties - the TypeScript properties of a `ClarifyExplainerConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpointConfig_ClarifyExplainerConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('enableExplanations', cdk.validateString)(properties.enableExplanations));
    errors.collect(cdk.propertyValidator('inferenceConfig', CfnEndpointConfig_ClarifyInferenceConfigPropertyValidator)(properties.inferenceConfig));
    errors.collect(cdk.propertyValidator('shapConfig', cdk.requiredValidator)(properties.shapConfig));
    errors.collect(cdk.propertyValidator('shapConfig', CfnEndpointConfig_ClarifyShapConfigPropertyValidator)(properties.shapConfig));
    return errors.wrap('supplied properties not correct for "ClarifyExplainerConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::EndpointConfig.ClarifyExplainerConfig` resource
 *
 * @param properties - the TypeScript properties of a `ClarifyExplainerConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::EndpointConfig.ClarifyExplainerConfig` resource.
 */
// @ts-ignore TS6133
function cfnEndpointConfigClarifyExplainerConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpointConfig_ClarifyExplainerConfigPropertyValidator(properties).assertSuccess();
    return {
        EnableExplanations: cdk.stringToCloudFormation(properties.enableExplanations),
        InferenceConfig: cfnEndpointConfigClarifyInferenceConfigPropertyToCloudFormation(properties.inferenceConfig),
        ShapConfig: cfnEndpointConfigClarifyShapConfigPropertyToCloudFormation(properties.shapConfig),
    };
}
// @ts-ignore TS6133
function CfnEndpointConfigClarifyExplainerConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('enableExplanations', 'EnableExplanations', properties.EnableExplanations != null ? cfn_parse.FromCloudFormation.getString(properties.EnableExplanations) : undefined);
    ret.addPropertyResult('inferenceConfig', 'InferenceConfig', properties.InferenceConfig != null ? CfnEndpointConfigClarifyInferenceConfigPropertyFromCloudFormation(properties.InferenceConfig) : undefined);
    ret.addPropertyResult('shapConfig', 'ShapConfig', CfnEndpointConfigClarifyShapConfigPropertyFromCloudFormation(properties.ShapConfig));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ClarifyInferenceConfigProperty`
 *
 * @param properties - the TypeScript properties of a `ClarifyInferenceConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpointConfig_ClarifyInferenceConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('contentTemplate', cdk.validateString)(properties.contentTemplate));
    errors.collect(cdk.propertyValidator('featureHeaders', cdk.listValidator(cdk.validateString))(properties.featureHeaders));
    errors.collect(cdk.propertyValidator('featureTypes', cdk.listValidator(cdk.validateString))(properties.featureTypes));
    errors.collect(cdk.propertyValidator('featuresAttribute', cdk.validateString)(properties.featuresAttribute));
    errors.collect(cdk.propertyValidator('labelAttribute', cdk.validateString)(properties.labelAttribute));
    errors.collect(cdk.propertyValidator('labelHeaders', cdk.listValidator(cdk.validateString))(properties.labelHeaders));
    errors.collect(cdk.propertyValidator('labelIndex', cdk.validateNumber)(properties.labelIndex));
    errors.collect(cdk.propertyValidator('maxPayloadInMb', cdk.validateNumber)(properties.maxPayloadInMb));
    errors.collect(cdk.propertyValidator('maxRecordCount', cdk.validateNumber)(properties.maxRecordCount));
    errors.collect(cdk.propertyValidator('probabilityAttribute', cdk.validateString)(properties.probabilityAttribute));
    errors.collect(cdk.propertyValidator('probabilityIndex', cdk.validateNumber)(properties.probabilityIndex));
    return errors.wrap('supplied properties not correct for "ClarifyInferenceConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::EndpointConfig.ClarifyInferenceConfig` resource
 *
 * @param properties - the TypeScript properties of a `ClarifyInferenceConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::EndpointConfig.ClarifyInferenceConfig` resource.
 */
// @ts-ignore TS6133
function cfnEndpointConfigClarifyInferenceConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpointConfig_ClarifyInferenceConfigPropertyValidator(properties).assertSuccess();
    return {
        ContentTemplate: cdk.stringToCloudFormation(properties.contentTemplate),
        FeatureHeaders: cdk.listMapper(cdk.stringToCloudFormation)(properties.featureHeaders),
        FeatureTypes: cdk.listMapper(cdk.stringToCloudFormation)(properties.featureTypes),
        FeaturesAttribute: cdk.stringToCloudFormation(properties.featuresAttribute),
        LabelAttribute: cdk.stringToCloudFormation(properties.labelAttribute),
        LabelHeaders: cdk.listMapper(cdk.stringToCloudFormation)(properties.labelHeaders),
        LabelIndex: cdk.numberToCloudFormation(properties.labelIndex),
        MaxPayloadInMB: cdk.numberToCloudFormation(properties.maxPayloadInMb),
        MaxRecordCount: cdk.numberToCloudFormation(properties.maxRecordCount),
        ProbabilityAttribute: cdk.stringToCloudFormation(properties.probabilityAttribute),
        ProbabilityIndex: cdk.numberToCloudFormation(properties.probabilityIndex),
    };
}
// @ts-ignore TS6133
function CfnEndpointConfigClarifyInferenceConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('contentTemplate', 'ContentTemplate', properties.ContentTemplate != null ? cfn_parse.FromCloudFormation.getString(properties.ContentTemplate) : undefined);
    ret.addPropertyResult('featureHeaders', 'FeatureHeaders', properties.FeatureHeaders != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getString)(properties.FeatureHeaders) : undefined);
    ret.addPropertyResult('featureTypes', 'FeatureTypes', properties.FeatureTypes != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getString)(properties.FeatureTypes) : undefined);
    ret.addPropertyResult('featuresAttribute', 'FeaturesAttribute', properties.FeaturesAttribute != null ? cfn_parse.FromCloudFormation.getString(properties.FeaturesAttribute) : undefined);
    ret.addPropertyResult('labelAttribute', 'LabelAttribute', properties.LabelAttribute != null ? cfn_parse.FromCloudFormation.getString(properties.LabelAttribute) : undefined);
    ret.addPropertyResult('labelHeaders', 'LabelHeaders', properties.LabelHeaders != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getString)(properties.LabelHeaders) : undefined);
    ret.addPropertyResult('labelIndex', 'LabelIndex', properties.LabelIndex != null ? cfn_parse.FromCloudFormation.getNumber(properties.LabelIndex) : undefined);
    ret.addPropertyResult('maxPayloadInMb', 'MaxPayloadInMB', properties.MaxPayloadInMB != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxPayloadInMB) : undefined);
    ret.addPropertyResult('maxRecordCount', 'MaxRecordCount', properties.MaxRecordCount != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxRecordCount) : undefined);
    ret.addPropertyResult('probabilityAttribute', 'ProbabilityAttribute', properties.ProbabilityAttribute != null ? cfn_parse.FromCloudFormation.getString(properties.ProbabilityAttribute) : undefined);
    ret.addPropertyResult('probabilityIndex', 'ProbabilityIndex', properties.ProbabilityIndex != null ? cfn_parse.FromCloudFormation.getNumber(properties.ProbabilityIndex) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ClarifyShapBaselineConfigProperty`
 *
 * @param properties - the TypeScript properties of a `ClarifyShapBaselineConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpointConfig_ClarifyShapBaselineConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('mimeType', cdk.validateString)(properties.mimeType));
    errors.collect(cdk.propertyValidator('shapBaseline', cdk.validateString)(properties.shapBaseline));
    errors.collect(cdk.propertyValidator('shapBaselineUri', cdk.validateString)(properties.shapBaselineUri));
    return errors.wrap('supplied properties not correct for "ClarifyShapBaselineConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::EndpointConfig.ClarifyShapBaselineConfig` resource
 *
 * @param properties - the TypeScript properties of a `ClarifyShapBaselineConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::EndpointConfig.ClarifyShapBaselineConfig` resource.
 */
// @ts-ignore TS6133
function cfnEndpointConfigClarifyShapBaselineConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpointConfig_ClarifyShapBaselineConfigPropertyValidator(properties).assertSuccess();
    return {
        MimeType: cdk.stringToCloudFormation(properties.mimeType),
        ShapBaseline: cdk.stringToCloudFormation(properties.shapBaseline),
        ShapBaselineUri: cdk.stringToCloudFormation(properties.shapBaselineUri),
    };
}
// @ts-ignore TS6133
function CfnEndpointConfigClarifyShapBaselineConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('mimeType', 'MimeType', properties.MimeType != null ? cfn_parse.FromCloudFormation.getString(properties.MimeType) : undefined);
    ret.addPropertyResult('shapBaseline', 'ShapBaseline', properties.ShapBaseline != null ? cfn_parse.FromCloudFormation.getString(properties.ShapBaseline) : undefined);
    ret.addPropertyResult('shapBaselineUri', 'ShapBaselineUri', properties.ShapBaselineUri != null ? cfn_parse.FromCloudFormation.getString(properties.ShapBaselineUri) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ClarifyShapConfigProperty`
 *
 * @param properties - the TypeScript properties of a `ClarifyShapConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpointConfig_ClarifyShapConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('numberOfSamples', cdk.validateNumber)(properties.numberOfSamples));
    errors.collect(cdk.propertyValidator('seed', cdk.validateNumber)(properties.seed));
    errors.collect(cdk.propertyValidator('shapBaselineConfig', cdk.requiredValidator)(properties.shapBaselineConfig));
    errors.collect(cdk.propertyValidator('shapBaselineConfig', CfnEndpointConfig_ClarifyShapBaselineConfigPropertyValidator)(properties.shapBaselineConfig));
    errors.collect(cdk.propertyValidator('textConfig', CfnEndpointConfig_ClarifyTextConfigPropertyValidator)(properties.textConfig));
    errors.collect(cdk.propertyValidator('useLogit', cdk.validateBoolean)(properties.useLogit));
    return errors.wrap('supplied properties not correct for "ClarifyShapConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::EndpointConfig.ClarifyShapConfig` resource
 *
 * @param properties - the TypeScript properties of a `ClarifyShapConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::EndpointConfig.ClarifyShapConfig` resource.
 */
// @ts-ignore TS6133
function cfnEndpointConfigClarifyShapConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpointConfig_ClarifyShapConfigPropertyValidator(properties).assertSuccess();
    return {
        NumberOfSamples: cdk.numberToCloudFormation(properties.numberOfSamples),
        Seed: cdk.numberToCloudFormation(properties.seed),
        ShapBaselineConfig: cfnEndpointConfigClarifyShapBaselineConfigPropertyToCloudFormation(properties.shapBaselineConfig),
        TextConfig: cfnEndpointConfigClarifyTextConfigPropertyToCloudFormation(properties.textConfig),
        UseLogit: cdk.booleanToCloudFormation(properties.useLogit),
    };
}
// @ts-ignore TS6133
function CfnEndpointConfigClarifyShapConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('numberOfSamples', 'NumberOfSamples', properties.NumberOfSamples != null ? cfn_parse.FromCloudFormation.getNumber(properties.NumberOfSamples) : undefined);
    ret.addPropertyResult('seed', 'Seed', properties.Seed != null ? cfn_parse.FromCloudFormation.getNumber(properties.Seed) : undefined);
    ret.addPropertyResult('shapBaselineConfig', 'ShapBaselineConfig', CfnEndpointConfigClarifyShapBaselineConfigPropertyFromCloudFormation(properties.ShapBaselineConfig));
    ret.addPropertyResult('textConfig', 'TextConfig', properties.TextConfig != null ? CfnEndpointConfigClarifyTextConfigPropertyFromCloudFormation(properties.TextConfig) : undefined);
    ret.addPropertyResult('useLogit', 'UseLogit', properties.UseLogit != null ? cfn_parse.FromCloudFormation.getBoolean(properties.UseLogit) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ClarifyTextConfigProperty`
 *
 * @param properties - the TypeScript properties of a `ClarifyTextConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpointConfig_ClarifyTextConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('granularity', cdk.requiredValidator)(properties.granularity));
    errors.collect(cdk.propertyValidator('granularity', cdk.validateString)(properties.granularity));
    errors.collect(cdk.propertyValidator('language', cdk.requiredValidator)(properties.language));
    errors.collect(cdk.propertyValidator('language', cdk.validateString)(properties.language));
    return errors.wrap('supplied properties not correct for "ClarifyTextConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::EndpointConfig.ClarifyTextConfig` resource
 *
 * @param properties - the TypeScript properties of a `ClarifyTextConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::EndpointConfig.ClarifyTextConfig` resource.
 */
// @ts-ignore TS6133
function cfnEndpointConfigClarifyTextConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpointConfig_ClarifyTextConfigPropertyValidator(properties).assertSuccess();
    return {
        Granularity: cdk.stringToCloudFormation(properties.granularity),
        Language: cdk.stringToCloudFormation(properties.language),
    };
}
// @ts-ignore TS6133
function CfnEndpointConfigClarifyTextConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('granularity', 'Granularity', cfn_parse.FromCloudFormation.getString(properties.Granularity));
    ret.addPropertyResult('language', 'Language', cfn_parse.FromCloudFormation.getString(properties.Language));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DataCaptureConfigProperty`
 *
 * @param properties - the TypeScript properties of a `DataCaptureConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpointConfig_DataCaptureConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('captureContentTypeHeader', CfnEndpointConfig_CaptureContentTypeHeaderPropertyValidator)(properties.captureContentTypeHeader));
    errors.collect(cdk.propertyValidator('captureOptions', cdk.requiredValidator)(properties.captureOptions));
    errors.collect(cdk.propertyValidator('captureOptions', cdk.listValidator(CfnEndpointConfig_CaptureOptionPropertyValidator))(properties.captureOptions));
    errors.collect(cdk.propertyValidator('destinationS3Uri', cdk.requiredValidator)(properties.destinationS3Uri));
    errors.collect(cdk.propertyValidator('destinationS3Uri', cdk.validateString)(properties.destinationS3Uri));
    errors.collect(cdk.propertyValidator('enableCapture', cdk.validateBoolean)(properties.enableCapture));
    errors.collect(cdk.propertyValidator('initialSamplingPercentage', cdk.requiredValidator)(properties.initialSamplingPercentage));
    errors.collect(cdk.propertyValidator('initialSamplingPercentage', cdk.validateNumber)(properties.initialSamplingPercentage));
    errors.collect(cdk.propertyValidator('kmsKeyId', cdk.validateString)(properties.kmsKeyId));
    return errors.wrap('supplied properties not correct for "DataCaptureConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::EndpointConfig.DataCaptureConfig` resource
 *
 * @param properties - the TypeScript properties of a `DataCaptureConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::EndpointConfig.DataCaptureConfig` resource.
 */
// @ts-ignore TS6133
function cfnEndpointConfigDataCaptureConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpointConfig_DataCaptureConfigPropertyValidator(properties).assertSuccess();
    return {
        CaptureContentTypeHeader: cfnEndpointConfigCaptureContentTypeHeaderPropertyToCloudFormation(properties.captureContentTypeHeader),
        CaptureOptions: cdk.listMapper(cfnEndpointConfigCaptureOptionPropertyToCloudFormation)(properties.captureOptions),
        DestinationS3Uri: cdk.stringToCloudFormation(properties.destinationS3Uri),
        EnableCapture: cdk.booleanToCloudFormation(properties.enableCapture),
        InitialSamplingPercentage: cdk.numberToCloudFormation(properties.initialSamplingPercentage),
        KmsKeyId: cdk.stringToCloudFormation(properties.kmsKeyId),
    };
}
// @ts-ignore TS6133
function CfnEndpointConfigDataCaptureConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('captureContentTypeHeader', 'CaptureContentTypeHeader', properties.CaptureContentTypeHeader != null ? CfnEndpointConfigCaptureContentTypeHeaderPropertyFromCloudFormation(properties.CaptureContentTypeHeader) : undefined);
    ret.addPropertyResult('captureOptions', 'CaptureOptions', cfn_parse.FromCloudFormation.getArray(CfnEndpointConfigCaptureOptionPropertyFromCloudFormation)(properties.CaptureOptions));
    ret.addPropertyResult('destinationS3Uri', 'DestinationS3Uri', cfn_parse.FromCloudFormation.getString(properties.DestinationS3Uri));
    ret.addPropertyResult('enableCapture', 'EnableCapture', properties.EnableCapture != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EnableCapture) : undefined);
    ret.addPropertyResult('initialSamplingPercentage', 'InitialSamplingPercentage', cfn_parse.FromCloudFormation.getNumber(properties.InitialSamplingPercentage));
    ret.addPropertyResult('kmsKeyId', 'KmsKeyId', properties.KmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.KmsKeyId) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ExplainerConfigProperty`
 *
 * @param properties - the TypeScript properties of a `ExplainerConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpointConfig_ExplainerConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('clarifyExplainerConfig', CfnEndpointConfig_ClarifyExplainerConfigPropertyValidator)(properties.clarifyExplainerConfig));
    return errors.wrap('supplied properties not correct for "ExplainerConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::EndpointConfig.ExplainerConfig` resource
 *
 * @param properties - the TypeScript properties of a `ExplainerConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::EndpointConfig.ExplainerConfig` resource.
 */
// @ts-ignore TS6133
function cfnEndpointConfigExplainerConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpointConfig_ExplainerConfigPropertyValidator(properties).assertSuccess();
    return {
        ClarifyExplainerConfig: cfnEndpointConfigClarifyExplainerConfigPropertyToCloudFormation(properties.clarifyExplainerConfig),
    };
}
// @ts-ignore TS6133
function CfnEndpointConfigExplainerConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('clarifyExplainerConfig', 'ClarifyExplainerConfig', properties.ClarifyExplainerConfig != null ? CfnEndpointConfigClarifyExplainerConfigPropertyFromCloudFormation(properties.ClarifyExplainerConfig) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ProductionVariantProperty`
 *
 * @param properties - the TypeScript properties of a `ProductionVariantProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpointConfig_ProductionVariantPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('acceleratorType', cdk.validateString)(properties.acceleratorType));
    errors.collect(cdk.propertyValidator('containerStartupHealthCheckTimeoutInSeconds', cdk.validateNumber)(properties.containerStartupHealthCheckTimeoutInSeconds));
    errors.collect(cdk.propertyValidator('initialInstanceCount', cdk.validateNumber)(properties.initialInstanceCount));
    errors.collect(cdk.propertyValidator('initialVariantWeight', cdk.requiredValidator)(properties.initialVariantWeight));
    errors.collect(cdk.propertyValidator('initialVariantWeight', cdk.validateNumber)(properties.initialVariantWeight));
    errors.collect(cdk.propertyValidator('instanceType', cdk.validateString)(properties.instanceType));
    errors.collect(cdk.propertyValidator('modelDataDownloadTimeoutInSeconds', cdk.validateNumber)(properties.modelDataDownloadTimeoutInSeconds));
    errors.collect(cdk.propertyValidator('modelName', cdk.requiredValidator)(properties.modelName));
    errors.collect(cdk.propertyValidator('modelName', cdk.validateString)(properties.modelName));
    errors.collect(cdk.propertyValidator('serverlessConfig', CfnEndpointConfig_ServerlessConfigPropertyValidator)(properties.serverlessConfig));
    errors.collect(cdk.propertyValidator('variantName', cdk.requiredValidator)(properties.variantName));
    errors.collect(cdk.propertyValidator('variantName', cdk.validateString)(properties.variantName));
    errors.collect(cdk.propertyValidator('volumeSizeInGb', cdk.validateNumber)(properties.volumeSizeInGb));
    return errors.wrap('supplied properties not correct for "ProductionVariantProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::EndpointConfig.ProductionVariant` resource
 *
 * @param properties - the TypeScript properties of a `ProductionVariantProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::EndpointConfig.ProductionVariant` resource.
 */
// @ts-ignore TS6133
function cfnEndpointConfigProductionVariantPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpointConfig_ProductionVariantPropertyValidator(properties).assertSuccess();
    return {
        AcceleratorType: cdk.stringToCloudFormation(properties.acceleratorType),
        ContainerStartupHealthCheckTimeoutInSeconds: cdk.numberToCloudFormation(properties.containerStartupHealthCheckTimeoutInSeconds),
        InitialInstanceCount: cdk.numberToCloudFormation(properties.initialInstanceCount),
        InitialVariantWeight: cdk.numberToCloudFormation(properties.initialVariantWeight),
        InstanceType: cdk.stringToCloudFormation(properties.instanceType),
        ModelDataDownloadTimeoutInSeconds: cdk.numberToCloudFormation(properties.modelDataDownloadTimeoutInSeconds),
        ModelName: cdk.stringToCloudFormation(properties.modelName),
        ServerlessConfig: cfnEndpointConfigServerlessConfigPropertyToCloudFormation(properties.serverlessConfig),
        VariantName: cdk.stringToCloudFormation(properties.variantName),
        VolumeSizeInGB: cdk.numberToCloudFormation(properties.volumeSizeInGb),
    };
}
// @ts-ignore TS6133
function CfnEndpointConfigProductionVariantPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('acceleratorType', 'AcceleratorType', properties.AcceleratorType != null ? cfn_parse.FromCloudFormation.getString(properties.AcceleratorType) : undefined);
    ret.addPropertyResult('containerStartupHealthCheckTimeoutInSeconds', 'ContainerStartupHealthCheckTimeoutInSeconds', properties.ContainerStartupHealthCheckTimeoutInSeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.ContainerStartupHealthCheckTimeoutInSeconds) : undefined);
    ret.addPropertyResult('initialInstanceCount', 'InitialInstanceCount', properties.InitialInstanceCount != null ? cfn_parse.FromCloudFormation.getNumber(properties.InitialInstanceCount) : undefined);
    ret.addPropertyResult('initialVariantWeight', 'InitialVariantWeight', cfn_parse.FromCloudFormation.getNumber(properties.InitialVariantWeight));
    ret.addPropertyResult('instanceType', 'InstanceType', properties.InstanceType != null ? cfn_parse.FromCloudFormation.getString(properties.InstanceType) : undefined);
    ret.addPropertyResult('modelDataDownloadTimeoutInSeconds', 'ModelDataDownloadTimeoutInSeconds', properties.ModelDataDownloadTimeoutInSeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.ModelDataDownloadTimeoutInSeconds) : undefined);
    ret.addPropertyResult('modelName', 'ModelName', cfn_parse.FromCloudFormation.getString(properties.ModelName));
    ret.addPropertyResult('serverlessConfig', 'ServerlessConfig', properties.ServerlessConfig != null ? CfnEndpointConfigServerlessConfigPropertyFromCloudFormation(properties.ServerlessConfig) : undefined);
    ret.addPropertyResult('variantName', 'VariantName', cfn_parse.FromCloudFormation.getString(properties.VariantName));
    ret.addPropertyResult('volumeSizeInGb', 'VolumeSizeInGB', properties.VolumeSizeInGB != null ? cfn_parse.FromCloudFormation.getNumber(properties.VolumeSizeInGB) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ServerlessConfigProperty`
 *
 * @param properties - the TypeScript properties of a `ServerlessConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpointConfig_ServerlessConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('maxConcurrency', cdk.requiredValidator)(properties.maxConcurrency));
    errors.collect(cdk.propertyValidator('maxConcurrency', cdk.validateNumber)(properties.maxConcurrency));
    errors.collect(cdk.propertyValidator('memorySizeInMb', cdk.requiredValidator)(properties.memorySizeInMb));
    errors.collect(cdk.propertyValidator('memorySizeInMb', cdk.validateNumber)(properties.memorySizeInMb));
    return errors.wrap('supplied properties not correct for "ServerlessConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::EndpointConfig.ServerlessConfig` resource
 *
 * @param properties - the TypeScript properties of a `ServerlessConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::EndpointConfig.ServerlessConfig` resource.
 */
// @ts-ignore TS6133
function cfnEndpointConfigServerlessConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpointConfig_ServerlessConfigPropertyValidator(properties).assertSuccess();
    return {
        MaxConcurrency: cdk.numberToCloudFormation(properties.maxConcurrency),
        MemorySizeInMB: cdk.numberToCloudFormation(properties.memorySizeInMb),
    };
}
// @ts-ignore TS6133
function CfnEndpointConfigServerlessConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('maxConcurrency', 'MaxConcurrency', cfn_parse.FromCloudFormation.getNumber(properties.MaxConcurrency));
    ret.addPropertyResult('memorySizeInMb', 'MemorySizeInMB', cfn_parse.FromCloudFormation.getNumber(properties.MemorySizeInMB));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnFeatureGroupProps`
 *
 * @param properties - the TypeScript properties of a `CfnFeatureGroupProps`
 *
 * @returns the result of the validation.
 */
function CfnFeatureGroupPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('eventTimeFeatureName', cdk.requiredValidator)(properties.eventTimeFeatureName));
    errors.collect(cdk.propertyValidator('eventTimeFeatureName', cdk.validateString)(properties.eventTimeFeatureName));
    errors.collect(cdk.propertyValidator('featureDefinitions', cdk.requiredValidator)(properties.featureDefinitions));
    errors.collect(cdk.propertyValidator('featureDefinitions', cdk.listValidator(CfnFeatureGroup_FeatureDefinitionPropertyValidator))(properties.featureDefinitions));
    errors.collect(cdk.propertyValidator('featureGroupName', cdk.requiredValidator)(properties.featureGroupName));
    errors.collect(cdk.propertyValidator('featureGroupName', cdk.validateString)(properties.featureGroupName));
    errors.collect(cdk.propertyValidator('offlineStoreConfig', cdk.validateObject)(properties.offlineStoreConfig));
    errors.collect(cdk.propertyValidator('onlineStoreConfig', cdk.validateObject)(properties.onlineStoreConfig));
    errors.collect(cdk.propertyValidator('recordIdentifierFeatureName', cdk.requiredValidator)(properties.recordIdentifierFeatureName));
    errors.collect(cdk.propertyValidator('recordIdentifierFeatureName', cdk.validateString)(properties.recordIdentifierFeatureName));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnFeatureGroupProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::FeatureGroup` resource
 *
 * @param properties - the TypeScript properties of a `CfnFeatureGroupProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::FeatureGroup` resource.
 */
// @ts-ignore TS6133
function cfnFeatureGroupPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFeatureGroupPropsValidator(properties).assertSuccess();
    return {
        EventTimeFeatureName: cdk.stringToCloudFormation(properties.eventTimeFeatureName),
        FeatureDefinitions: cdk.listMapper(cfnFeatureGroupFeatureDefinitionPropertyToCloudFormation)(properties.featureDefinitions),
        FeatureGroupName: cdk.stringToCloudFormation(properties.featureGroupName),
        RecordIdentifierFeatureName: cdk.stringToCloudFormation(properties.recordIdentifierFeatureName),
        Description: cdk.stringToCloudFormation(properties.description),
        OfflineStoreConfig: cdk.objectToCloudFormation(properties.offlineStoreConfig),
        OnlineStoreConfig: cdk.objectToCloudFormation(properties.onlineStoreConfig),
        RoleArn: cdk.stringToCloudFormation(properties.roleArn),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnFeatureGroupPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('eventTimeFeatureName', 'EventTimeFeatureName', cfn_parse.FromCloudFormation.getString(properties.EventTimeFeatureName));
    ret.addPropertyResult('featureDefinitions', 'FeatureDefinitions', cfn_parse.FromCloudFormation.getArray(CfnFeatureGroupFeatureDefinitionPropertyFromCloudFormation)(properties.FeatureDefinitions));
    ret.addPropertyResult('featureGroupName', 'FeatureGroupName', cfn_parse.FromCloudFormation.getString(properties.FeatureGroupName));
    ret.addPropertyResult('recordIdentifierFeatureName', 'RecordIdentifierFeatureName', cfn_parse.FromCloudFormation.getString(properties.RecordIdentifierFeatureName));
    ret.addPropertyResult('description', 'Description', properties.Description != null ? cfn_parse.FromCloudFormation.getString(properties.Description) : undefined);
    ret.addPropertyResult('offlineStoreConfig', 'OfflineStoreConfig', properties.OfflineStoreConfig != null ? cfn_parse.FromCloudFormation.getAny(properties.OfflineStoreConfig) : undefined);
    ret.addPropertyResult('onlineStoreConfig', 'OnlineStoreConfig', properties.OnlineStoreConfig != null ? cfn_parse.FromCloudFormation.getAny(properties.OnlineStoreConfig) : undefined);
    ret.addPropertyResult('roleArn', 'RoleArn', properties.RoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.RoleArn) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::SageMaker::FeatureGroup`
 *
 * Create a new `FeatureGroup` . A `FeatureGroup` is a group of `Features` defined in the `FeatureStore` to describe a `Record` .
 *
 * The `FeatureGroup` defines the schema and features contained in the FeatureGroup. A `FeatureGroup` definition is composed of a list of `Features` , a `RecordIdentifierFeatureName` , an `EventTimeFeatureName` and configurations for its `OnlineStore` and `OfflineStore` . Check [AWS service quotas](https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html) to see the `FeatureGroup` s quota for your AWS account.
 *
 * > You must include at least one of `OnlineStoreConfig` and `OfflineStoreConfig` to create a `FeatureGroup` .
 *
 * @cloudformationResource AWS::SageMaker::FeatureGroup
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html
 */
class CfnFeatureGroup extends cdk.CfnResource {
    /**
     * Create a new `AWS::SageMaker::FeatureGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnFeatureGroup.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_sagemaker_CfnFeatureGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnFeatureGroup);
            }
            throw error;
        }
        cdk.requireProperty(props, 'eventTimeFeatureName', this);
        cdk.requireProperty(props, 'featureDefinitions', this);
        cdk.requireProperty(props, 'featureGroupName', this);
        cdk.requireProperty(props, 'recordIdentifierFeatureName', this);
        this.eventTimeFeatureName = props.eventTimeFeatureName;
        this.featureDefinitions = props.featureDefinitions;
        this.featureGroupName = props.featureGroupName;
        this.recordIdentifierFeatureName = props.recordIdentifierFeatureName;
        this.description = props.description;
        this.offlineStoreConfig = props.offlineStoreConfig;
        this.onlineStoreConfig = props.onlineStoreConfig;
        this.roleArn = props.roleArn;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::SageMaker::FeatureGroup", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnFeatureGroupPropsFromCloudFormation(resourceProperties);
        const ret = new CfnFeatureGroup(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnFeatureGroup.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            eventTimeFeatureName: this.eventTimeFeatureName,
            featureDefinitions: this.featureDefinitions,
            featureGroupName: this.featureGroupName,
            recordIdentifierFeatureName: this.recordIdentifierFeatureName,
            description: this.description,
            offlineStoreConfig: this.offlineStoreConfig,
            onlineStoreConfig: this.onlineStoreConfig,
            roleArn: this.roleArn,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnFeatureGroupPropsToCloudFormation(props);
    }
}
exports.CfnFeatureGroup = CfnFeatureGroup;
_k = JSII_RTTI_SYMBOL_1;
CfnFeatureGroup[_k] = { fqn: "@aws-cdk/aws-sagemaker.CfnFeatureGroup", version: "1.186.1" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnFeatureGroup.CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::FeatureGroup";
/**
 * Determine whether the given properties match those of a `DataCatalogConfigProperty`
 *
 * @param properties - the TypeScript properties of a `DataCatalogConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnFeatureGroup_DataCatalogConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('catalog', cdk.requiredValidator)(properties.catalog));
    errors.collect(cdk.propertyValidator('catalog', cdk.validateString)(properties.catalog));
    errors.collect(cdk.propertyValidator('database', cdk.requiredValidator)(properties.database));
    errors.collect(cdk.propertyValidator('database', cdk.validateString)(properties.database));
    errors.collect(cdk.propertyValidator('tableName', cdk.requiredValidator)(properties.tableName));
    errors.collect(cdk.propertyValidator('tableName', cdk.validateString)(properties.tableName));
    return errors.wrap('supplied properties not correct for "DataCatalogConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::FeatureGroup.DataCatalogConfig` resource
 *
 * @param properties - the TypeScript properties of a `DataCatalogConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::FeatureGroup.DataCatalogConfig` resource.
 */
// @ts-ignore TS6133
function cfnFeatureGroupDataCatalogConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFeatureGroup_DataCatalogConfigPropertyValidator(properties).assertSuccess();
    return {
        Catalog: cdk.stringToCloudFormation(properties.catalog),
        Database: cdk.stringToCloudFormation(properties.database),
        TableName: cdk.stringToCloudFormation(properties.tableName),
    };
}
// @ts-ignore TS6133
function CfnFeatureGroupDataCatalogConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('catalog', 'Catalog', cfn_parse.FromCloudFormation.getString(properties.Catalog));
    ret.addPropertyResult('database', 'Database', cfn_parse.FromCloudFormation.getString(properties.Database));
    ret.addPropertyResult('tableName', 'TableName', cfn_parse.FromCloudFormation.getString(properties.TableName));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FeatureDefinitionProperty`
 *
 * @param properties - the TypeScript properties of a `FeatureDefinitionProperty`
 *
 * @returns the result of the validation.
 */
function CfnFeatureGroup_FeatureDefinitionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('featureName', cdk.requiredValidator)(properties.featureName));
    errors.collect(cdk.propertyValidator('featureName', cdk.validateString)(properties.featureName));
    errors.collect(cdk.propertyValidator('featureType', cdk.requiredValidator)(properties.featureType));
    errors.collect(cdk.propertyValidator('featureType', cdk.validateString)(properties.featureType));
    return errors.wrap('supplied properties not correct for "FeatureDefinitionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::FeatureGroup.FeatureDefinition` resource
 *
 * @param properties - the TypeScript properties of a `FeatureDefinitionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::FeatureGroup.FeatureDefinition` resource.
 */
// @ts-ignore TS6133
function cfnFeatureGroupFeatureDefinitionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFeatureGroup_FeatureDefinitionPropertyValidator(properties).assertSuccess();
    return {
        FeatureName: cdk.stringToCloudFormation(properties.featureName),
        FeatureType: cdk.stringToCloudFormation(properties.featureType),
    };
}
// @ts-ignore TS6133
function CfnFeatureGroupFeatureDefinitionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('featureName', 'FeatureName', cfn_parse.FromCloudFormation.getString(properties.FeatureName));
    ret.addPropertyResult('featureType', 'FeatureType', cfn_parse.FromCloudFormation.getString(properties.FeatureType));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `OfflineStoreConfigProperty`
 *
 * @param properties - the TypeScript properties of a `OfflineStoreConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnFeatureGroup_OfflineStoreConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dataCatalogConfig', CfnFeatureGroup_DataCatalogConfigPropertyValidator)(properties.dataCatalogConfig));
    errors.collect(cdk.propertyValidator('disableGlueTableCreation', cdk.validateBoolean)(properties.disableGlueTableCreation));
    errors.collect(cdk.propertyValidator('s3StorageConfig', cdk.requiredValidator)(properties.s3StorageConfig));
    errors.collect(cdk.propertyValidator('s3StorageConfig', CfnFeatureGroup_S3StorageConfigPropertyValidator)(properties.s3StorageConfig));
    errors.collect(cdk.propertyValidator('tableFormat', cdk.validateString)(properties.tableFormat));
    return errors.wrap('supplied properties not correct for "OfflineStoreConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::FeatureGroup.OfflineStoreConfig` resource
 *
 * @param properties - the TypeScript properties of a `OfflineStoreConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::FeatureGroup.OfflineStoreConfig` resource.
 */
// @ts-ignore TS6133
function cfnFeatureGroupOfflineStoreConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFeatureGroup_OfflineStoreConfigPropertyValidator(properties).assertSuccess();
    return {
        DataCatalogConfig: cfnFeatureGroupDataCatalogConfigPropertyToCloudFormation(properties.dataCatalogConfig),
        DisableGlueTableCreation: cdk.booleanToCloudFormation(properties.disableGlueTableCreation),
        S3StorageConfig: cfnFeatureGroupS3StorageConfigPropertyToCloudFormation(properties.s3StorageConfig),
        TableFormat: cdk.stringToCloudFormation(properties.tableFormat),
    };
}
// @ts-ignore TS6133
function CfnFeatureGroupOfflineStoreConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dataCatalogConfig', 'DataCatalogConfig', properties.DataCatalogConfig != null ? CfnFeatureGroupDataCatalogConfigPropertyFromCloudFormation(properties.DataCatalogConfig) : undefined);
    ret.addPropertyResult('disableGlueTableCreation', 'DisableGlueTableCreation', properties.DisableGlueTableCreation != null ? cfn_parse.FromCloudFormation.getBoolean(properties.DisableGlueTableCreation) : undefined);
    ret.addPropertyResult('s3StorageConfig', 'S3StorageConfig', CfnFeatureGroupS3StorageConfigPropertyFromCloudFormation(properties.S3StorageConfig));
    ret.addPropertyResult('tableFormat', 'TableFormat', properties.TableFormat != null ? cfn_parse.FromCloudFormation.getString(properties.TableFormat) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `OnlineStoreConfigProperty`
 *
 * @param properties - the TypeScript properties of a `OnlineStoreConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnFeatureGroup_OnlineStoreConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('enableOnlineStore', cdk.validateBoolean)(properties.enableOnlineStore));
    errors.collect(cdk.propertyValidator('securityConfig', CfnFeatureGroup_OnlineStoreSecurityConfigPropertyValidator)(properties.securityConfig));
    return errors.wrap('supplied properties not correct for "OnlineStoreConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::FeatureGroup.OnlineStoreConfig` resource
 *
 * @param properties - the TypeScript properties of a `OnlineStoreConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::FeatureGroup.OnlineStoreConfig` resource.
 */
// @ts-ignore TS6133
function cfnFeatureGroupOnlineStoreConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFeatureGroup_OnlineStoreConfigPropertyValidator(properties).assertSuccess();
    return {
        EnableOnlineStore: cdk.booleanToCloudFormation(properties.enableOnlineStore),
        SecurityConfig: cfnFeatureGroupOnlineStoreSecurityConfigPropertyToCloudFormation(properties.securityConfig),
    };
}
// @ts-ignore TS6133
function CfnFeatureGroupOnlineStoreConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('enableOnlineStore', 'EnableOnlineStore', properties.EnableOnlineStore != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EnableOnlineStore) : undefined);
    ret.addPropertyResult('securityConfig', 'SecurityConfig', properties.SecurityConfig != null ? CfnFeatureGroupOnlineStoreSecurityConfigPropertyFromCloudFormation(properties.SecurityConfig) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `OnlineStoreSecurityConfigProperty`
 *
 * @param properties - the TypeScript properties of a `OnlineStoreSecurityConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnFeatureGroup_OnlineStoreSecurityConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('kmsKeyId', cdk.validateString)(properties.kmsKeyId));
    return errors.wrap('supplied properties not correct for "OnlineStoreSecurityConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::FeatureGroup.OnlineStoreSecurityConfig` resource
 *
 * @param properties - the TypeScript properties of a `OnlineStoreSecurityConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::FeatureGroup.OnlineStoreSecurityConfig` resource.
 */
// @ts-ignore TS6133
function cfnFeatureGroupOnlineStoreSecurityConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFeatureGroup_OnlineStoreSecurityConfigPropertyValidator(properties).assertSuccess();
    return {
        KmsKeyId: cdk.stringToCloudFormation(properties.kmsKeyId),
    };
}
// @ts-ignore TS6133
function CfnFeatureGroupOnlineStoreSecurityConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('kmsKeyId', 'KmsKeyId', properties.KmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.KmsKeyId) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `S3StorageConfigProperty`
 *
 * @param properties - the TypeScript properties of a `S3StorageConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnFeatureGroup_S3StorageConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('kmsKeyId', cdk.validateString)(properties.kmsKeyId));
    errors.collect(cdk.propertyValidator('s3Uri', cdk.requiredValidator)(properties.s3Uri));
    errors.collect(cdk.propertyValidator('s3Uri', cdk.validateString)(properties.s3Uri));
    return errors.wrap('supplied properties not correct for "S3StorageConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::FeatureGroup.S3StorageConfig` resource
 *
 * @param properties - the TypeScript properties of a `S3StorageConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::FeatureGroup.S3StorageConfig` resource.
 */
// @ts-ignore TS6133
function cfnFeatureGroupS3StorageConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFeatureGroup_S3StorageConfigPropertyValidator(properties).assertSuccess();
    return {
        KmsKeyId: cdk.stringToCloudFormation(properties.kmsKeyId),
        S3Uri: cdk.stringToCloudFormation(properties.s3Uri),
    };
}
// @ts-ignore TS6133
function CfnFeatureGroupS3StorageConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('kmsKeyId', 'KmsKeyId', properties.KmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.KmsKeyId) : undefined);
    ret.addPropertyResult('s3Uri', 'S3Uri', cfn_parse.FromCloudFormation.getString(properties.S3Uri));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnImageProps`
 *
 * @param properties - the TypeScript properties of a `CfnImageProps`
 *
 * @returns the result of the validation.
 */
function CfnImagePropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('imageDescription', cdk.validateString)(properties.imageDescription));
    errors.collect(cdk.propertyValidator('imageDisplayName', cdk.validateString)(properties.imageDisplayName));
    errors.collect(cdk.propertyValidator('imageName', cdk.requiredValidator)(properties.imageName));
    errors.collect(cdk.propertyValidator('imageName', cdk.validateString)(properties.imageName));
    errors.collect(cdk.propertyValidator('imageRoleArn', cdk.requiredValidator)(properties.imageRoleArn));
    errors.collect(cdk.propertyValidator('imageRoleArn', cdk.validateString)(properties.imageRoleArn));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnImageProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::Image` resource
 *
 * @param properties - the TypeScript properties of a `CfnImageProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::Image` resource.
 */
// @ts-ignore TS6133
function cfnImagePropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnImagePropsValidator(properties).assertSuccess();
    return {
        ImageName: cdk.stringToCloudFormation(properties.imageName),
        ImageRoleArn: cdk.stringToCloudFormation(properties.imageRoleArn),
        ImageDescription: cdk.stringToCloudFormation(properties.imageDescription),
        ImageDisplayName: cdk.stringToCloudFormation(properties.imageDisplayName),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnImagePropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('imageName', 'ImageName', cfn_parse.FromCloudFormation.getString(properties.ImageName));
    ret.addPropertyResult('imageRoleArn', 'ImageRoleArn', cfn_parse.FromCloudFormation.getString(properties.ImageRoleArn));
    ret.addPropertyResult('imageDescription', 'ImageDescription', properties.ImageDescription != null ? cfn_parse.FromCloudFormation.getString(properties.ImageDescription) : undefined);
    ret.addPropertyResult('imageDisplayName', 'ImageDisplayName', properties.ImageDisplayName != null ? cfn_parse.FromCloudFormation.getString(properties.ImageDisplayName) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::SageMaker::Image`
 *
 * Creates a custom SageMaker image. A SageMaker image is a set of image versions. Each image version represents a container image stored in Amazon Elastic Container Registry (ECR). For more information, see [Bring your own SageMaker image](https://docs.aws.amazon.com/sagemaker/latest/dg/studio-byoi.html) .
 *
 * @cloudformationResource AWS::SageMaker::Image
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-image.html
 */
class CfnImage extends cdk.CfnResource {
    /**
     * Create a new `AWS::SageMaker::Image`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnImage.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_sagemaker_CfnImageProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnImage);
            }
            throw error;
        }
        cdk.requireProperty(props, 'imageName', this);
        cdk.requireProperty(props, 'imageRoleArn', this);
        this.attrImageArn = cdk.Token.asString(this.getAtt('ImageArn'));
        this.imageName = props.imageName;
        this.imageRoleArn = props.imageRoleArn;
        this.imageDescription = props.imageDescription;
        this.imageDisplayName = props.imageDisplayName;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::SageMaker::Image", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnImagePropsFromCloudFormation(resourceProperties);
        const ret = new CfnImage(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnImage.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            imageName: this.imageName,
            imageRoleArn: this.imageRoleArn,
            imageDescription: this.imageDescription,
            imageDisplayName: this.imageDisplayName,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnImagePropsToCloudFormation(props);
    }
}
exports.CfnImage = CfnImage;
_l = JSII_RTTI_SYMBOL_1;
CfnImage[_l] = { fqn: "@aws-cdk/aws-sagemaker.CfnImage", version: "1.186.1" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnImage.CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::Image";
/**
 * Determine whether the given properties match those of a `CfnImageVersionProps`
 *
 * @param properties - the TypeScript properties of a `CfnImageVersionProps`
 *
 * @returns the result of the validation.
 */
function CfnImageVersionPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('baseImage', cdk.requiredValidator)(properties.baseImage));
    errors.collect(cdk.propertyValidator('baseImage', cdk.validateString)(properties.baseImage));
    errors.collect(cdk.propertyValidator('imageName', cdk.requiredValidator)(properties.imageName));
    errors.collect(cdk.propertyValidator('imageName', cdk.validateString)(properties.imageName));
    return errors.wrap('supplied properties not correct for "CfnImageVersionProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ImageVersion` resource
 *
 * @param properties - the TypeScript properties of a `CfnImageVersionProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ImageVersion` resource.
 */
// @ts-ignore TS6133
function cfnImageVersionPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnImageVersionPropsValidator(properties).assertSuccess();
    return {
        BaseImage: cdk.stringToCloudFormation(properties.baseImage),
        ImageName: cdk.stringToCloudFormation(properties.imageName),
    };
}
// @ts-ignore TS6133
function CfnImageVersionPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('baseImage', 'BaseImage', cfn_parse.FromCloudFormation.getString(properties.BaseImage));
    ret.addPropertyResult('imageName', 'ImageName', cfn_parse.FromCloudFormation.getString(properties.ImageName));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::SageMaker::ImageVersion`
 *
 * Creates a version of the SageMaker image specified by `ImageName` . The version represents the Amazon Container Registry (ECR) container image specified by `BaseImage` .
 *
 * > You can use the `DependsOn` attribute to specify that the creation of a specific resource follows another. You can use it for the following use cases. For more information, see [`DependsOn` attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html) .
 * >
 * > 1. `DependsOn` can be used to establish a parent/child relationship between `ImageVersion` and `Image` where the `ImageVersion` `DependsOn` the `Image` .
 * >
 * > 2. `DependsOn` can be used to establish order among `ImageVersion` s within the same `Image` namespace. For example, if ImageVersionB `DependsOn` ImageVersionA and both share the same parent `Image` , then ImageVersionA is version N and ImageVersionB is N+1.
 *
 * @cloudformationResource AWS::SageMaker::ImageVersion
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html
 */
class CfnImageVersion extends cdk.CfnResource {
    /**
     * Create a new `AWS::SageMaker::ImageVersion`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnImageVersion.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_sagemaker_CfnImageVersionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnImageVersion);
            }
            throw error;
        }
        cdk.requireProperty(props, 'baseImage', this);
        cdk.requireProperty(props, 'imageName', this);
        this.attrContainerImage = cdk.Token.asString(this.getAtt('ContainerImage'));
        this.attrImageArn = cdk.Token.asString(this.getAtt('ImageArn'));
        this.attrImageVersionArn = cdk.Token.asString(this.getAtt('ImageVersionArn'));
        this.attrVersion = cdk.Token.asNumber(this.getAtt('Version'));
        this.baseImage = props.baseImage;
        this.imageName = props.imageName;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnImageVersionPropsFromCloudFormation(resourceProperties);
        const ret = new CfnImageVersion(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnImageVersion.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            baseImage: this.baseImage,
            imageName: this.imageName,
        };
    }
    renderProperties(props) {
        return cfnImageVersionPropsToCloudFormation(props);
    }
}
exports.CfnImageVersion = CfnImageVersion;
_m = JSII_RTTI_SYMBOL_1;
CfnImageVersion[_m] = { fqn: "@aws-cdk/aws-sagemaker.CfnImageVersion", version: "1.186.1" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnImageVersion.CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::ImageVersion";
/**
 * Determine whether the given properties match those of a `CfnModelProps`
 *
 * @param properties - the TypeScript properties of a `CfnModelProps`
 *
 * @returns the result of the validation.
 */
function CfnModelPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('containers', cdk.listValidator(CfnModel_ContainerDefinitionPropertyValidator))(properties.containers));
    errors.collect(cdk.propertyValidator('enableNetworkIsolation', cdk.validateBoolean)(properties.enableNetworkIsolation));
    errors.collect(cdk.propertyValidator('executionRoleArn', cdk.requiredValidator)(properties.executionRoleArn));
    errors.collect(cdk.propertyValidator('executionRoleArn', cdk.validateString)(properties.executionRoleArn));
    errors.collect(cdk.propertyValidator('inferenceExecutionConfig', CfnModel_InferenceExecutionConfigPropertyValidator)(properties.inferenceExecutionConfig));
    errors.collect(cdk.propertyValidator('modelName', cdk.validateString)(properties.modelName));
    errors.collect(cdk.propertyValidator('primaryContainer', CfnModel_ContainerDefinitionPropertyValidator)(properties.primaryContainer));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('vpcConfig', CfnModel_VpcConfigPropertyValidator)(properties.vpcConfig));
    return errors.wrap('supplied properties not correct for "CfnModelProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::Model` resource
 *
 * @param properties - the TypeScript properties of a `CfnModelProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::Model` resource.
 */
// @ts-ignore TS6133
function cfnModelPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelPropsValidator(properties).assertSuccess();
    return {
        ExecutionRoleArn: cdk.stringToCloudFormation(properties.executionRoleArn),
        Containers: cdk.listMapper(cfnModelContainerDefinitionPropertyToCloudFormation)(properties.containers),
        EnableNetworkIsolation: cdk.booleanToCloudFormation(properties.enableNetworkIsolation),
        InferenceExecutionConfig: cfnModelInferenceExecutionConfigPropertyToCloudFormation(properties.inferenceExecutionConfig),
        ModelName: cdk.stringToCloudFormation(properties.modelName),
        PrimaryContainer: cfnModelContainerDefinitionPropertyToCloudFormation(properties.primaryContainer),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
        VpcConfig: cfnModelVpcConfigPropertyToCloudFormation(properties.vpcConfig),
    };
}
// @ts-ignore TS6133
function CfnModelPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('executionRoleArn', 'ExecutionRoleArn', cfn_parse.FromCloudFormation.getString(properties.ExecutionRoleArn));
    ret.addPropertyResult('containers', 'Containers', properties.Containers != null ? cfn_parse.FromCloudFormation.getArray(CfnModelContainerDefinitionPropertyFromCloudFormation)(properties.Containers) : undefined);
    ret.addPropertyResult('enableNetworkIsolation', 'EnableNetworkIsolation', properties.EnableNetworkIsolation != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EnableNetworkIsolation) : undefined);
    ret.addPropertyResult('inferenceExecutionConfig', 'InferenceExecutionConfig', properties.InferenceExecutionConfig != null ? CfnModelInferenceExecutionConfigPropertyFromCloudFormation(properties.InferenceExecutionConfig) : undefined);
    ret.addPropertyResult('modelName', 'ModelName', properties.ModelName != null ? cfn_parse.FromCloudFormation.getString(properties.ModelName) : undefined);
    ret.addPropertyResult('primaryContainer', 'PrimaryContainer', properties.PrimaryContainer != null ? CfnModelContainerDefinitionPropertyFromCloudFormation(properties.PrimaryContainer) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addPropertyResult('vpcConfig', 'VpcConfig', properties.VpcConfig != null ? CfnModelVpcConfigPropertyFromCloudFormation(properties.VpcConfig) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::SageMaker::Model`
 *
 * The `AWS::SageMaker::Model` resource to create a model to host at an Amazon SageMaker endpoint. For more information, see [Deploying a Model on Amazon SageMaker Hosting Services](https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works-hosting.html) in the *Amazon SageMaker Developer Guide* .
 *
 * @cloudformationResource AWS::SageMaker::Model
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html
 */
class CfnModel extends cdk.CfnResource {
    /**
     * Create a new `AWS::SageMaker::Model`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnModel.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_sagemaker_CfnModelProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnModel);
            }
            throw error;
        }
        cdk.requireProperty(props, 'executionRoleArn', this);
        this.attrModelName = cdk.Token.asString(this.getAtt('ModelName'));
        this.executionRoleArn = props.executionRoleArn;
        this.containers = props.containers;
        this.enableNetworkIsolation = props.enableNetworkIsolation;
        this.inferenceExecutionConfig = props.inferenceExecutionConfig;
        this.modelName = props.modelName;
        this.primaryContainer = props.primaryContainer;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::SageMaker::Model", props.tags, { tagPropertyName: 'tags' });
        this.vpcConfig = props.vpcConfig;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnModelPropsFromCloudFormation(resourceProperties);
        const ret = new CfnModel(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnModel.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            executionRoleArn: this.executionRoleArn,
            containers: this.containers,
            enableNetworkIsolation: this.enableNetworkIsolation,
            inferenceExecutionConfig: this.inferenceExecutionConfig,
            modelName: this.modelName,
            primaryContainer: this.primaryContainer,
            tags: this.tags.renderTags(),
            vpcConfig: this.vpcConfig,
        };
    }
    renderProperties(props) {
        return cfnModelPropsToCloudFormation(props);
    }
}
exports.CfnModel = CfnModel;
_o = JSII_RTTI_SYMBOL_1;
CfnModel[_o] = { fqn: "@aws-cdk/aws-sagemaker.CfnModel", version: "1.186.1" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnModel.CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::Model";
/**
 * Determine whether the given properties match those of a `ContainerDefinitionProperty`
 *
 * @param properties - the TypeScript properties of a `ContainerDefinitionProperty`
 *
 * @returns the result of the validation.
 */
function CfnModel_ContainerDefinitionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('containerHostname', cdk.validateString)(properties.containerHostname));
    errors.collect(cdk.propertyValidator('environment', cdk.validateObject)(properties.environment));
    errors.collect(cdk.propertyValidator('image', cdk.validateString)(properties.image));
    errors.collect(cdk.propertyValidator('imageConfig', CfnModel_ImageConfigPropertyValidator)(properties.imageConfig));
    errors.collect(cdk.propertyValidator('inferenceSpecificationName', cdk.validateString)(properties.inferenceSpecificationName));
    errors.collect(cdk.propertyValidator('mode', cdk.validateString)(properties.mode));
    errors.collect(cdk.propertyValidator('modelDataUrl', cdk.validateString)(properties.modelDataUrl));
    errors.collect(cdk.propertyValidator('modelPackageName', cdk.validateString)(properties.modelPackageName));
    errors.collect(cdk.propertyValidator('multiModelConfig', CfnModel_MultiModelConfigPropertyValidator)(properties.multiModelConfig));
    return errors.wrap('supplied properties not correct for "ContainerDefinitionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::Model.ContainerDefinition` resource
 *
 * @param properties - the TypeScript properties of a `ContainerDefinitionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::Model.ContainerDefinition` resource.
 */
// @ts-ignore TS6133
function cfnModelContainerDefinitionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModel_ContainerDefinitionPropertyValidator(properties).assertSuccess();
    return {
        ContainerHostname: cdk.stringToCloudFormation(properties.containerHostname),
        Environment: cdk.objectToCloudFormation(properties.environment),
        Image: cdk.stringToCloudFormation(properties.image),
        ImageConfig: cfnModelImageConfigPropertyToCloudFormation(properties.imageConfig),
        InferenceSpecificationName: cdk.stringToCloudFormation(properties.inferenceSpecificationName),
        Mode: cdk.stringToCloudFormation(properties.mode),
        ModelDataUrl: cdk.stringToCloudFormation(properties.modelDataUrl),
        ModelPackageName: cdk.stringToCloudFormation(properties.modelPackageName),
        MultiModelConfig: cfnModelMultiModelConfigPropertyToCloudFormation(properties.multiModelConfig),
    };
}
// @ts-ignore TS6133
function CfnModelContainerDefinitionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('containerHostname', 'ContainerHostname', properties.ContainerHostname != null ? cfn_parse.FromCloudFormation.getString(properties.ContainerHostname) : undefined);
    ret.addPropertyResult('environment', 'Environment', properties.Environment != null ? cfn_parse.FromCloudFormation.getAny(properties.Environment) : undefined);
    ret.addPropertyResult('image', 'Image', properties.Image != null ? cfn_parse.FromCloudFormation.getString(properties.Image) : undefined);
    ret.addPropertyResult('imageConfig', 'ImageConfig', properties.ImageConfig != null ? CfnModelImageConfigPropertyFromCloudFormation(properties.ImageConfig) : undefined);
    ret.addPropertyResult('inferenceSpecificationName', 'InferenceSpecificationName', properties.InferenceSpecificationName != null ? cfn_parse.FromCloudFormation.getString(properties.InferenceSpecificationName) : undefined);
    ret.addPropertyResult('mode', 'Mode', properties.Mode != null ? cfn_parse.FromCloudFormation.getString(properties.Mode) : undefined);
    ret.addPropertyResult('modelDataUrl', 'ModelDataUrl', properties.ModelDataUrl != null ? cfn_parse.FromCloudFormation.getString(properties.ModelDataUrl) : undefined);
    ret.addPropertyResult('modelPackageName', 'ModelPackageName', properties.ModelPackageName != null ? cfn_parse.FromCloudFormation.getString(properties.ModelPackageName) : undefined);
    ret.addPropertyResult('multiModelConfig', 'MultiModelConfig', properties.MultiModelConfig != null ? CfnModelMultiModelConfigPropertyFromCloudFormation(properties.MultiModelConfig) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ImageConfigProperty`
 *
 * @param properties - the TypeScript properties of a `ImageConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnModel_ImageConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('repositoryAccessMode', cdk.requiredValidator)(properties.repositoryAccessMode));
    errors.collect(cdk.propertyValidator('repositoryAccessMode', cdk.validateString)(properties.repositoryAccessMode));
    errors.collect(cdk.propertyValidator('repositoryAuthConfig', CfnModel_RepositoryAuthConfigPropertyValidator)(properties.repositoryAuthConfig));
    return errors.wrap('supplied properties not correct for "ImageConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::Model.ImageConfig` resource
 *
 * @param properties - the TypeScript properties of a `ImageConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::Model.ImageConfig` resource.
 */
// @ts-ignore TS6133
function cfnModelImageConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModel_ImageConfigPropertyValidator(properties).assertSuccess();
    return {
        RepositoryAccessMode: cdk.stringToCloudFormation(properties.repositoryAccessMode),
        RepositoryAuthConfig: cfnModelRepositoryAuthConfigPropertyToCloudFormation(properties.repositoryAuthConfig),
    };
}
// @ts-ignore TS6133
function CfnModelImageConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('repositoryAccessMode', 'RepositoryAccessMode', cfn_parse.FromCloudFormation.getString(properties.RepositoryAccessMode));
    ret.addPropertyResult('repositoryAuthConfig', 'RepositoryAuthConfig', properties.RepositoryAuthConfig != null ? CfnModelRepositoryAuthConfigPropertyFromCloudFormation(properties.RepositoryAuthConfig) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `InferenceExecutionConfigProperty`
 *
 * @param properties - the TypeScript properties of a `InferenceExecutionConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnModel_InferenceExecutionConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('mode', cdk.requiredValidator)(properties.mode));
    errors.collect(cdk.propertyValidator('mode', cdk.validateString)(properties.mode));
    return errors.wrap('supplied properties not correct for "InferenceExecutionConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::Model.InferenceExecutionConfig` resource
 *
 * @param properties - the TypeScript properties of a `InferenceExecutionConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::Model.InferenceExecutionConfig` resource.
 */
// @ts-ignore TS6133
function cfnModelInferenceExecutionConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModel_InferenceExecutionConfigPropertyValidator(properties).assertSuccess();
    return {
        Mode: cdk.stringToCloudFormation(properties.mode),
    };
}
// @ts-ignore TS6133
function CfnModelInferenceExecutionConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('mode', 'Mode', cfn_parse.FromCloudFormation.getString(properties.Mode));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MultiModelConfigProperty`
 *
 * @param properties - the TypeScript properties of a `MultiModelConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnModel_MultiModelConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('modelCacheSetting', cdk.validateString)(properties.modelCacheSetting));
    return errors.wrap('supplied properties not correct for "MultiModelConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::Model.MultiModelConfig` resource
 *
 * @param properties - the TypeScript properties of a `MultiModelConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::Model.MultiModelConfig` resource.
 */
// @ts-ignore TS6133
function cfnModelMultiModelConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModel_MultiModelConfigPropertyValidator(properties).assertSuccess();
    return {
        ModelCacheSetting: cdk.stringToCloudFormation(properties.modelCacheSetting),
    };
}
// @ts-ignore TS6133
function CfnModelMultiModelConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('modelCacheSetting', 'ModelCacheSetting', properties.ModelCacheSetting != null ? cfn_parse.FromCloudFormation.getString(properties.ModelCacheSetting) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `RepositoryAuthConfigProperty`
 *
 * @param properties - the TypeScript properties of a `RepositoryAuthConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnModel_RepositoryAuthConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('repositoryCredentialsProviderArn', cdk.requiredValidator)(properties.repositoryCredentialsProviderArn));
    errors.collect(cdk.propertyValidator('repositoryCredentialsProviderArn', cdk.validateString)(properties.repositoryCredentialsProviderArn));
    return errors.wrap('supplied properties not correct for "RepositoryAuthConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::Model.RepositoryAuthConfig` resource
 *
 * @param properties - the TypeScript properties of a `RepositoryAuthConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::Model.RepositoryAuthConfig` resource.
 */
// @ts-ignore TS6133
function cfnModelRepositoryAuthConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModel_RepositoryAuthConfigPropertyValidator(properties).assertSuccess();
    return {
        RepositoryCredentialsProviderArn: cdk.stringToCloudFormation(properties.repositoryCredentialsProviderArn),
    };
}
// @ts-ignore TS6133
function CfnModelRepositoryAuthConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('repositoryCredentialsProviderArn', 'RepositoryCredentialsProviderArn', cfn_parse.FromCloudFormation.getString(properties.RepositoryCredentialsProviderArn));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `VpcConfigProperty`
 *
 * @param properties - the TypeScript properties of a `VpcConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnModel_VpcConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('securityGroupIds', cdk.requiredValidator)(properties.securityGroupIds));
    errors.collect(cdk.propertyValidator('securityGroupIds', cdk.listValidator(cdk.validateString))(properties.securityGroupIds));
    errors.collect(cdk.propertyValidator('subnets', cdk.requiredValidator)(properties.subnets));
    errors.collect(cdk.propertyValidator('subnets', cdk.listValidator(cdk.validateString))(properties.subnets));
    return errors.wrap('supplied properties not correct for "VpcConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::Model.VpcConfig` resource
 *
 * @param properties - the TypeScript properties of a `VpcConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::Model.VpcConfig` resource.
 */
// @ts-ignore TS6133
function cfnModelVpcConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModel_VpcConfigPropertyValidator(properties).assertSuccess();
    return {
        SecurityGroupIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.securityGroupIds),
        Subnets: cdk.listMapper(cdk.stringToCloudFormation)(properties.subnets),
    };
}
// @ts-ignore TS6133
function CfnModelVpcConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('securityGroupIds', 'SecurityGroupIds', cfn_parse.FromCloudFormation.getStringArray(properties.SecurityGroupIds));
    ret.addPropertyResult('subnets', 'Subnets', cfn_parse.FromCloudFormation.getStringArray(properties.Subnets));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnModelBiasJobDefinitionProps`
 *
 * @param properties - the TypeScript properties of a `CfnModelBiasJobDefinitionProps`
 *
 * @returns the result of the validation.
 */
function CfnModelBiasJobDefinitionPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('endpointName', cdk.validateString)(properties.endpointName));
    errors.collect(cdk.propertyValidator('jobDefinitionName', cdk.validateString)(properties.jobDefinitionName));
    errors.collect(cdk.propertyValidator('jobResources', cdk.requiredValidator)(properties.jobResources));
    errors.collect(cdk.propertyValidator('jobResources', CfnModelBiasJobDefinition_MonitoringResourcesPropertyValidator)(properties.jobResources));
    errors.collect(cdk.propertyValidator('modelBiasAppSpecification', cdk.requiredValidator)(properties.modelBiasAppSpecification));
    errors.collect(cdk.propertyValidator('modelBiasAppSpecification', CfnModelBiasJobDefinition_ModelBiasAppSpecificationPropertyValidator)(properties.modelBiasAppSpecification));
    errors.collect(cdk.propertyValidator('modelBiasBaselineConfig', CfnModelBiasJobDefinition_ModelBiasBaselineConfigPropertyValidator)(properties.modelBiasBaselineConfig));
    errors.collect(cdk.propertyValidator('modelBiasJobInput', cdk.requiredValidator)(properties.modelBiasJobInput));
    errors.collect(cdk.propertyValidator('modelBiasJobInput', CfnModelBiasJobDefinition_ModelBiasJobInputPropertyValidator)(properties.modelBiasJobInput));
    errors.collect(cdk.propertyValidator('modelBiasJobOutputConfig', cdk.requiredValidator)(properties.modelBiasJobOutputConfig));
    errors.collect(cdk.propertyValidator('modelBiasJobOutputConfig', CfnModelBiasJobDefinition_MonitoringOutputConfigPropertyValidator)(properties.modelBiasJobOutputConfig));
    errors.collect(cdk.propertyValidator('networkConfig', CfnModelBiasJobDefinition_NetworkConfigPropertyValidator)(properties.networkConfig));
    errors.collect(cdk.propertyValidator('roleArn', cdk.requiredValidator)(properties.roleArn));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    errors.collect(cdk.propertyValidator('stoppingCondition', CfnModelBiasJobDefinition_StoppingConditionPropertyValidator)(properties.stoppingCondition));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnModelBiasJobDefinitionProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelBiasJobDefinition` resource
 *
 * @param properties - the TypeScript properties of a `CfnModelBiasJobDefinitionProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelBiasJobDefinition` resource.
 */
// @ts-ignore TS6133
function cfnModelBiasJobDefinitionPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelBiasJobDefinitionPropsValidator(properties).assertSuccess();
    return {
        JobResources: cfnModelBiasJobDefinitionMonitoringResourcesPropertyToCloudFormation(properties.jobResources),
        ModelBiasAppSpecification: cfnModelBiasJobDefinitionModelBiasAppSpecificationPropertyToCloudFormation(properties.modelBiasAppSpecification),
        ModelBiasJobInput: cfnModelBiasJobDefinitionModelBiasJobInputPropertyToCloudFormation(properties.modelBiasJobInput),
        ModelBiasJobOutputConfig: cfnModelBiasJobDefinitionMonitoringOutputConfigPropertyToCloudFormation(properties.modelBiasJobOutputConfig),
        RoleArn: cdk.stringToCloudFormation(properties.roleArn),
        EndpointName: cdk.stringToCloudFormation(properties.endpointName),
        JobDefinitionName: cdk.stringToCloudFormation(properties.jobDefinitionName),
        ModelBiasBaselineConfig: cfnModelBiasJobDefinitionModelBiasBaselineConfigPropertyToCloudFormation(properties.modelBiasBaselineConfig),
        NetworkConfig: cfnModelBiasJobDefinitionNetworkConfigPropertyToCloudFormation(properties.networkConfig),
        StoppingCondition: cfnModelBiasJobDefinitionStoppingConditionPropertyToCloudFormation(properties.stoppingCondition),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnModelBiasJobDefinitionPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('jobResources', 'JobResources', CfnModelBiasJobDefinitionMonitoringResourcesPropertyFromCloudFormation(properties.JobResources));
    ret.addPropertyResult('modelBiasAppSpecification', 'ModelBiasAppSpecification', CfnModelBiasJobDefinitionModelBiasAppSpecificationPropertyFromCloudFormation(properties.ModelBiasAppSpecification));
    ret.addPropertyResult('modelBiasJobInput', 'ModelBiasJobInput', CfnModelBiasJobDefinitionModelBiasJobInputPropertyFromCloudFormation(properties.ModelBiasJobInput));
    ret.addPropertyResult('modelBiasJobOutputConfig', 'ModelBiasJobOutputConfig', CfnModelBiasJobDefinitionMonitoringOutputConfigPropertyFromCloudFormation(properties.ModelBiasJobOutputConfig));
    ret.addPropertyResult('roleArn', 'RoleArn', cfn_parse.FromCloudFormation.getString(properties.RoleArn));
    ret.addPropertyResult('endpointName', 'EndpointName', properties.EndpointName != null ? cfn_parse.FromCloudFormation.getString(properties.EndpointName) : undefined);
    ret.addPropertyResult('jobDefinitionName', 'JobDefinitionName', properties.JobDefinitionName != null ? cfn_parse.FromCloudFormation.getString(properties.JobDefinitionName) : undefined);
    ret.addPropertyResult('modelBiasBaselineConfig', 'ModelBiasBaselineConfig', properties.ModelBiasBaselineConfig != null ? CfnModelBiasJobDefinitionModelBiasBaselineConfigPropertyFromCloudFormation(properties.ModelBiasBaselineConfig) : undefined);
    ret.addPropertyResult('networkConfig', 'NetworkConfig', properties.NetworkConfig != null ? CfnModelBiasJobDefinitionNetworkConfigPropertyFromCloudFormation(properties.NetworkConfig) : undefined);
    ret.addPropertyResult('stoppingCondition', 'StoppingCondition', properties.StoppingCondition != null ? CfnModelBiasJobDefinitionStoppingConditionPropertyFromCloudFormation(properties.StoppingCondition) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::SageMaker::ModelBiasJobDefinition`
 *
 * Creates the definition for a model bias job.
 *
 * @cloudformationResource AWS::SageMaker::ModelBiasJobDefinition
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html
 */
class CfnModelBiasJobDefinition extends cdk.CfnResource {
    /**
     * Create a new `AWS::SageMaker::ModelBiasJobDefinition`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnModelBiasJobDefinition.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_sagemaker_CfnModelBiasJobDefinitionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnModelBiasJobDefinition);
            }
            throw error;
        }
        cdk.requireProperty(props, 'jobResources', this);
        cdk.requireProperty(props, 'modelBiasAppSpecification', this);
        cdk.requireProperty(props, 'modelBiasJobInput', this);
        cdk.requireProperty(props, 'modelBiasJobOutputConfig', this);
        cdk.requireProperty(props, 'roleArn', this);
        this.attrCreationTime = cdk.Token.asString(this.getAtt('CreationTime'));
        this.attrJobDefinitionArn = cdk.Token.asString(this.getAtt('JobDefinitionArn'));
        this.jobResources = props.jobResources;
        this.modelBiasAppSpecification = props.modelBiasAppSpecification;
        this.modelBiasJobInput = props.modelBiasJobInput;
        this.modelBiasJobOutputConfig = props.modelBiasJobOutputConfig;
        this.roleArn = props.roleArn;
        this.endpointName = props.endpointName;
        this.jobDefinitionName = props.jobDefinitionName;
        this.modelBiasBaselineConfig = props.modelBiasBaselineConfig;
        this.networkConfig = props.networkConfig;
        this.stoppingCondition = props.stoppingCondition;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::SageMaker::ModelBiasJobDefinition", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnModelBiasJobDefinitionPropsFromCloudFormation(resourceProperties);
        const ret = new CfnModelBiasJobDefinition(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnModelBiasJobDefinition.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            jobResources: this.jobResources,
            modelBiasAppSpecification: this.modelBiasAppSpecification,
            modelBiasJobInput: this.modelBiasJobInput,
            modelBiasJobOutputConfig: this.modelBiasJobOutputConfig,
            roleArn: this.roleArn,
            endpointName: this.endpointName,
            jobDefinitionName: this.jobDefinitionName,
            modelBiasBaselineConfig: this.modelBiasBaselineConfig,
            networkConfig: this.networkConfig,
            stoppingCondition: this.stoppingCondition,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnModelBiasJobDefinitionPropsToCloudFormation(props);
    }
}
exports.CfnModelBiasJobDefinition = CfnModelBiasJobDefinition;
_p = JSII_RTTI_SYMBOL_1;
CfnModelBiasJobDefinition[_p] = { fqn: "@aws-cdk/aws-sagemaker.CfnModelBiasJobDefinition", version: "1.186.1" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnModelBiasJobDefinition.CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::ModelBiasJobDefinition";
/**
 * Determine whether the given properties match those of a `BatchTransformInputProperty`
 *
 * @param properties - the TypeScript properties of a `BatchTransformInputProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelBiasJobDefinition_BatchTransformInputPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dataCapturedDestinationS3Uri', cdk.requiredValidator)(properties.dataCapturedDestinationS3Uri));
    errors.collect(cdk.propertyValidator('dataCapturedDestinationS3Uri', cdk.validateString)(properties.dataCapturedDestinationS3Uri));
    errors.collect(cdk.propertyValidator('datasetFormat', cdk.requiredValidator)(properties.datasetFormat));
    errors.collect(cdk.propertyValidator('datasetFormat', CfnModelBiasJobDefinition_DatasetFormatPropertyValidator)(properties.datasetFormat));
    errors.collect(cdk.propertyValidator('endTimeOffset', cdk.validateString)(properties.endTimeOffset));
    errors.collect(cdk.propertyValidator('featuresAttribute', cdk.validateString)(properties.featuresAttribute));
    errors.collect(cdk.propertyValidator('inferenceAttribute', cdk.validateString)(properties.inferenceAttribute));
    errors.collect(cdk.propertyValidator('localPath', cdk.requiredValidator)(properties.localPath));
    errors.collect(cdk.propertyValidator('localPath', cdk.validateString)(properties.localPath));
    errors.collect(cdk.propertyValidator('probabilityAttribute', cdk.validateString)(properties.probabilityAttribute));
    errors.collect(cdk.propertyValidator('probabilityThresholdAttribute', cdk.validateNumber)(properties.probabilityThresholdAttribute));
    errors.collect(cdk.propertyValidator('s3DataDistributionType', cdk.validateString)(properties.s3DataDistributionType));
    errors.collect(cdk.propertyValidator('s3InputMode', cdk.validateString)(properties.s3InputMode));
    errors.collect(cdk.propertyValidator('startTimeOffset', cdk.validateString)(properties.startTimeOffset));
    return errors.wrap('supplied properties not correct for "BatchTransformInputProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelBiasJobDefinition.BatchTransformInput` resource
 *
 * @param properties - the TypeScript properties of a `BatchTransformInputProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelBiasJobDefinition.BatchTransformInput` resource.
 */
// @ts-ignore TS6133
function cfnModelBiasJobDefinitionBatchTransformInputPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelBiasJobDefinition_BatchTransformInputPropertyValidator(properties).assertSuccess();
    return {
        DataCapturedDestinationS3Uri: cdk.stringToCloudFormation(properties.dataCapturedDestinationS3Uri),
        DatasetFormat: cfnModelBiasJobDefinitionDatasetFormatPropertyToCloudFormation(properties.datasetFormat),
        EndTimeOffset: cdk.stringToCloudFormation(properties.endTimeOffset),
        FeaturesAttribute: cdk.stringToCloudFormation(properties.featuresAttribute),
        InferenceAttribute: cdk.stringToCloudFormation(properties.inferenceAttribute),
        LocalPath: cdk.stringToCloudFormation(properties.localPath),
        ProbabilityAttribute: cdk.stringToCloudFormation(properties.probabilityAttribute),
        ProbabilityThresholdAttribute: cdk.numberToCloudFormation(properties.probabilityThresholdAttribute),
        S3DataDistributionType: cdk.stringToCloudFormation(properties.s3DataDistributionType),
        S3InputMode: cdk.stringToCloudFormation(properties.s3InputMode),
        StartTimeOffset: cdk.stringToCloudFormation(properties.startTimeOffset),
    };
}
// @ts-ignore TS6133
function CfnModelBiasJobDefinitionBatchTransformInputPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dataCapturedDestinationS3Uri', 'DataCapturedDestinationS3Uri', cfn_parse.FromCloudFormation.getString(properties.DataCapturedDestinationS3Uri));
    ret.addPropertyResult('datasetFormat', 'DatasetFormat', CfnModelBiasJobDefinitionDatasetFormatPropertyFromCloudFormation(properties.DatasetFormat));
    ret.addPropertyResult('endTimeOffset', 'EndTimeOffset', properties.EndTimeOffset != null ? cfn_parse.FromCloudFormation.getString(properties.EndTimeOffset) : undefined);
    ret.addPropertyResult('featuresAttribute', 'FeaturesAttribute', properties.FeaturesAttribute != null ? cfn_parse.FromCloudFormation.getString(properties.FeaturesAttribute) : undefined);
    ret.addPropertyResult('inferenceAttribute', 'InferenceAttribute', properties.InferenceAttribute != null ? cfn_parse.FromCloudFormation.getString(properties.InferenceAttribute) : undefined);
    ret.addPropertyResult('localPath', 'LocalPath', cfn_parse.FromCloudFormation.getString(properties.LocalPath));
    ret.addPropertyResult('probabilityAttribute', 'ProbabilityAttribute', properties.ProbabilityAttribute != null ? cfn_parse.FromCloudFormation.getString(properties.ProbabilityAttribute) : undefined);
    ret.addPropertyResult('probabilityThresholdAttribute', 'ProbabilityThresholdAttribute', properties.ProbabilityThresholdAttribute != null ? cfn_parse.FromCloudFormation.getNumber(properties.ProbabilityThresholdAttribute) : undefined);
    ret.addPropertyResult('s3DataDistributionType', 'S3DataDistributionType', properties.S3DataDistributionType != null ? cfn_parse.FromCloudFormation.getString(properties.S3DataDistributionType) : undefined);
    ret.addPropertyResult('s3InputMode', 'S3InputMode', properties.S3InputMode != null ? cfn_parse.FromCloudFormation.getString(properties.S3InputMode) : undefined);
    ret.addPropertyResult('startTimeOffset', 'StartTimeOffset', properties.StartTimeOffset != null ? cfn_parse.FromCloudFormation.getString(properties.StartTimeOffset) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ClusterConfigProperty`
 *
 * @param properties - the TypeScript properties of a `ClusterConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelBiasJobDefinition_ClusterConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('instanceCount', cdk.requiredValidator)(properties.instanceCount));
    errors.collect(cdk.propertyValidator('instanceCount', cdk.validateNumber)(properties.instanceCount));
    errors.collect(cdk.propertyValidator('instanceType', cdk.requiredValidator)(properties.instanceType));
    errors.collect(cdk.propertyValidator('instanceType', cdk.validateString)(properties.instanceType));
    errors.collect(cdk.propertyValidator('volumeKmsKeyId', cdk.validateString)(properties.volumeKmsKeyId));
    errors.collect(cdk.propertyValidator('volumeSizeInGb', cdk.requiredValidator)(properties.volumeSizeInGb));
    errors.collect(cdk.propertyValidator('volumeSizeInGb', cdk.validateNumber)(properties.volumeSizeInGb));
    return errors.wrap('supplied properties not correct for "ClusterConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelBiasJobDefinition.ClusterConfig` resource
 *
 * @param properties - the TypeScript properties of a `ClusterConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelBiasJobDefinition.ClusterConfig` resource.
 */
// @ts-ignore TS6133
function cfnModelBiasJobDefinitionClusterConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelBiasJobDefinition_ClusterConfigPropertyValidator(properties).assertSuccess();
    return {
        InstanceCount: cdk.numberToCloudFormation(properties.instanceCount),
        InstanceType: cdk.stringToCloudFormation(properties.instanceType),
        VolumeKmsKeyId: cdk.stringToCloudFormation(properties.volumeKmsKeyId),
        VolumeSizeInGB: cdk.numberToCloudFormation(properties.volumeSizeInGb),
    };
}
// @ts-ignore TS6133
function CfnModelBiasJobDefinitionClusterConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('instanceCount', 'InstanceCount', cfn_parse.FromCloudFormation.getNumber(properties.InstanceCount));
    ret.addPropertyResult('instanceType', 'InstanceType', cfn_parse.FromCloudFormation.getString(properties.InstanceType));
    ret.addPropertyResult('volumeKmsKeyId', 'VolumeKmsKeyId', properties.VolumeKmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.VolumeKmsKeyId) : undefined);
    ret.addPropertyResult('volumeSizeInGb', 'VolumeSizeInGB', cfn_parse.FromCloudFormation.getNumber(properties.VolumeSizeInGB));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ConstraintsResourceProperty`
 *
 * @param properties - the TypeScript properties of a `ConstraintsResourceProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelBiasJobDefinition_ConstraintsResourcePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('s3Uri', cdk.validateString)(properties.s3Uri));
    return errors.wrap('supplied properties not correct for "ConstraintsResourceProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelBiasJobDefinition.ConstraintsResource` resource
 *
 * @param properties - the TypeScript properties of a `ConstraintsResourceProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelBiasJobDefinition.ConstraintsResource` resource.
 */
// @ts-ignore TS6133
function cfnModelBiasJobDefinitionConstraintsResourcePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelBiasJobDefinition_ConstraintsResourcePropertyValidator(properties).assertSuccess();
    return {
        S3Uri: cdk.stringToCloudFormation(properties.s3Uri),
    };
}
// @ts-ignore TS6133
function CfnModelBiasJobDefinitionConstraintsResourcePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('s3Uri', 'S3Uri', properties.S3Uri != null ? cfn_parse.FromCloudFormation.getString(properties.S3Uri) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CsvProperty`
 *
 * @param properties - the TypeScript properties of a `CsvProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelBiasJobDefinition_CsvPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('header', cdk.validateBoolean)(properties.header));
    return errors.wrap('supplied properties not correct for "CsvProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelBiasJobDefinition.Csv` resource
 *
 * @param properties - the TypeScript properties of a `CsvProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelBiasJobDefinition.Csv` resource.
 */
// @ts-ignore TS6133
function cfnModelBiasJobDefinitionCsvPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelBiasJobDefinition_CsvPropertyValidator(properties).assertSuccess();
    return {
        Header: cdk.booleanToCloudFormation(properties.header),
    };
}
// @ts-ignore TS6133
function CfnModelBiasJobDefinitionCsvPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('header', 'Header', properties.Header != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Header) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DatasetFormatProperty`
 *
 * @param properties - the TypeScript properties of a `DatasetFormatProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelBiasJobDefinition_DatasetFormatPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('csv', CfnModelBiasJobDefinition_CsvPropertyValidator)(properties.csv));
    errors.collect(cdk.propertyValidator('json', cdk.validateObject)(properties.json));
    errors.collect(cdk.propertyValidator('parquet', cdk.validateBoolean)(properties.parquet));
    return errors.wrap('supplied properties not correct for "DatasetFormatProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelBiasJobDefinition.DatasetFormat` resource
 *
 * @param properties - the TypeScript properties of a `DatasetFormatProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelBiasJobDefinition.DatasetFormat` resource.
 */
// @ts-ignore TS6133
function cfnModelBiasJobDefinitionDatasetFormatPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelBiasJobDefinition_DatasetFormatPropertyValidator(properties).assertSuccess();
    return {
        Csv: cfnModelBiasJobDefinitionCsvPropertyToCloudFormation(properties.csv),
        Json: cdk.objectToCloudFormation(properties.json),
        Parquet: cdk.booleanToCloudFormation(properties.parquet),
    };
}
// @ts-ignore TS6133
function CfnModelBiasJobDefinitionDatasetFormatPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('csv', 'Csv', properties.Csv != null ? CfnModelBiasJobDefinitionCsvPropertyFromCloudFormation(properties.Csv) : undefined);
    ret.addPropertyResult('json', 'Json', properties.Json != null ? cfn_parse.FromCloudFormation.getAny(properties.Json) : undefined);
    ret.addPropertyResult('parquet', 'Parquet', properties.Parquet != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Parquet) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `EndpointInputProperty`
 *
 * @param properties - the TypeScript properties of a `EndpointInputProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelBiasJobDefinition_EndpointInputPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('endTimeOffset', cdk.validateString)(properties.endTimeOffset));
    errors.collect(cdk.propertyValidator('endpointName', cdk.requiredValidator)(properties.endpointName));
    errors.collect(cdk.propertyValidator('endpointName', cdk.validateString)(properties.endpointName));
    errors.collect(cdk.propertyValidator('featuresAttribute', cdk.validateString)(properties.featuresAttribute));
    errors.collect(cdk.propertyValidator('inferenceAttribute', cdk.validateString)(properties.inferenceAttribute));
    errors.collect(cdk.propertyValidator('localPath', cdk.requiredValidator)(properties.localPath));
    errors.collect(cdk.propertyValidator('localPath', cdk.validateString)(properties.localPath));
    errors.collect(cdk.propertyValidator('probabilityAttribute', cdk.validateString)(properties.probabilityAttribute));
    errors.collect(cdk.propertyValidator('probabilityThresholdAttribute', cdk.validateNumber)(properties.probabilityThresholdAttribute));
    errors.collect(cdk.propertyValidator('s3DataDistributionType', cdk.validateString)(properties.s3DataDistributionType));
    errors.collect(cdk.propertyValidator('s3InputMode', cdk.validateString)(properties.s3InputMode));
    errors.collect(cdk.propertyValidator('startTimeOffset', cdk.validateString)(properties.startTimeOffset));
    return errors.wrap('supplied properties not correct for "EndpointInputProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelBiasJobDefinition.EndpointInput` resource
 *
 * @param properties - the TypeScript properties of a `EndpointInputProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelBiasJobDefinition.EndpointInput` resource.
 */
// @ts-ignore TS6133
function cfnModelBiasJobDefinitionEndpointInputPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelBiasJobDefinition_EndpointInputPropertyValidator(properties).assertSuccess();
    return {
        EndTimeOffset: cdk.stringToCloudFormation(properties.endTimeOffset),
        EndpointName: cdk.stringToCloudFormation(properties.endpointName),
        FeaturesAttribute: cdk.stringToCloudFormation(properties.featuresAttribute),
        InferenceAttribute: cdk.stringToCloudFormation(properties.inferenceAttribute),
        LocalPath: cdk.stringToCloudFormation(properties.localPath),
        ProbabilityAttribute: cdk.stringToCloudFormation(properties.probabilityAttribute),
        ProbabilityThresholdAttribute: cdk.numberToCloudFormation(properties.probabilityThresholdAttribute),
        S3DataDistributionType: cdk.stringToCloudFormation(properties.s3DataDistributionType),
        S3InputMode: cdk.stringToCloudFormation(properties.s3InputMode),
        StartTimeOffset: cdk.stringToCloudFormation(properties.startTimeOffset),
    };
}
// @ts-ignore TS6133
function CfnModelBiasJobDefinitionEndpointInputPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('endTimeOffset', 'EndTimeOffset', properties.EndTimeOffset != null ? cfn_parse.FromCloudFormation.getString(properties.EndTimeOffset) : undefined);
    ret.addPropertyResult('endpointName', 'EndpointName', cfn_parse.FromCloudFormation.getString(properties.EndpointName));
    ret.addPropertyResult('featuresAttribute', 'FeaturesAttribute', properties.FeaturesAttribute != null ? cfn_parse.FromCloudFormation.getString(properties.FeaturesAttribute) : undefined);
    ret.addPropertyResult('inferenceAttribute', 'InferenceAttribute', properties.InferenceAttribute != null ? cfn_parse.FromCloudFormation.getString(properties.InferenceAttribute) : undefined);
    ret.addPropertyResult('localPath', 'LocalPath', cfn_parse.FromCloudFormation.getString(properties.LocalPath));
    ret.addPropertyResult('probabilityAttribute', 'ProbabilityAttribute', properties.ProbabilityAttribute != null ? cfn_parse.FromCloudFormation.getString(properties.ProbabilityAttribute) : undefined);
    ret.addPropertyResult('probabilityThresholdAttribute', 'ProbabilityThresholdAttribute', properties.ProbabilityThresholdAttribute != null ? cfn_parse.FromCloudFormation.getNumber(properties.ProbabilityThresholdAttribute) : undefined);
    ret.addPropertyResult('s3DataDistributionType', 'S3DataDistributionType', properties.S3DataDistributionType != null ? cfn_parse.FromCloudFormation.getString(properties.S3DataDistributionType) : undefined);
    ret.addPropertyResult('s3InputMode', 'S3InputMode', properties.S3InputMode != null ? cfn_parse.FromCloudFormation.getString(properties.S3InputMode) : undefined);
    ret.addPropertyResult('startTimeOffset', 'StartTimeOffset', properties.StartTimeOffset != null ? cfn_parse.FromCloudFormation.getString(properties.StartTimeOffset) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `JsonProperty`
 *
 * @param properties - the TypeScript properties of a `JsonProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelBiasJobDefinition_JsonPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('line', cdk.validateBoolean)(properties.line));
    return errors.wrap('supplied properties not correct for "JsonProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelBiasJobDefinition.Json` resource
 *
 * @param properties - the TypeScript properties of a `JsonProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelBiasJobDefinition.Json` resource.
 */
// @ts-ignore TS6133
function cfnModelBiasJobDefinitionJsonPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelBiasJobDefinition_JsonPropertyValidator(properties).assertSuccess();
    return {
        Line: cdk.booleanToCloudFormation(properties.line),
    };
}
// @ts-ignore TS6133
function CfnModelBiasJobDefinitionJsonPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('line', 'Line', properties.Line != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Line) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ModelBiasAppSpecificationProperty`
 *
 * @param properties - the TypeScript properties of a `ModelBiasAppSpecificationProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelBiasJobDefinition_ModelBiasAppSpecificationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('configUri', cdk.requiredValidator)(properties.configUri));
    errors.collect(cdk.propertyValidator('configUri', cdk.validateString)(properties.configUri));
    errors.collect(cdk.propertyValidator('environment', cdk.hashValidator(cdk.validateString))(properties.environment));
    errors.collect(cdk.propertyValidator('imageUri', cdk.requiredValidator)(properties.imageUri));
    errors.collect(cdk.propertyValidator('imageUri', cdk.validateString)(properties.imageUri));
    return errors.wrap('supplied properties not correct for "ModelBiasAppSpecificationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelBiasJobDefinition.ModelBiasAppSpecification` resource
 *
 * @param properties - the TypeScript properties of a `ModelBiasAppSpecificationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelBiasJobDefinition.ModelBiasAppSpecification` resource.
 */
// @ts-ignore TS6133
function cfnModelBiasJobDefinitionModelBiasAppSpecificationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelBiasJobDefinition_ModelBiasAppSpecificationPropertyValidator(properties).assertSuccess();
    return {
        ConfigUri: cdk.stringToCloudFormation(properties.configUri),
        Environment: cdk.hashMapper(cdk.stringToCloudFormation)(properties.environment),
        ImageUri: cdk.stringToCloudFormation(properties.imageUri),
    };
}
// @ts-ignore TS6133
function CfnModelBiasJobDefinitionModelBiasAppSpecificationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('configUri', 'ConfigUri', cfn_parse.FromCloudFormation.getString(properties.ConfigUri));
    ret.addPropertyResult('environment', 'Environment', properties.Environment != null ? cfn_parse.FromCloudFormation.getMap(cfn_parse.FromCloudFormation.getString)(properties.Environment) : undefined);
    ret.addPropertyResult('imageUri', 'ImageUri', cfn_parse.FromCloudFormation.getString(properties.ImageUri));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ModelBiasBaselineConfigProperty`
 *
 * @param properties - the TypeScript properties of a `ModelBiasBaselineConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelBiasJobDefinition_ModelBiasBaselineConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('baseliningJobName', cdk.validateString)(properties.baseliningJobName));
    errors.collect(cdk.propertyValidator('constraintsResource', CfnModelBiasJobDefinition_ConstraintsResourcePropertyValidator)(properties.constraintsResource));
    return errors.wrap('supplied properties not correct for "ModelBiasBaselineConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelBiasJobDefinition.ModelBiasBaselineConfig` resource
 *
 * @param properties - the TypeScript properties of a `ModelBiasBaselineConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelBiasJobDefinition.ModelBiasBaselineConfig` resource.
 */
// @ts-ignore TS6133
function cfnModelBiasJobDefinitionModelBiasBaselineConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelBiasJobDefinition_ModelBiasBaselineConfigPropertyValidator(properties).assertSuccess();
    return {
        BaseliningJobName: cdk.stringToCloudFormation(properties.baseliningJobName),
        ConstraintsResource: cfnModelBiasJobDefinitionConstraintsResourcePropertyToCloudFormation(properties.constraintsResource),
    };
}
// @ts-ignore TS6133
function CfnModelBiasJobDefinitionModelBiasBaselineConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('baseliningJobName', 'BaseliningJobName', properties.BaseliningJobName != null ? cfn_parse.FromCloudFormation.getString(properties.BaseliningJobName) : undefined);
    ret.addPropertyResult('constraintsResource', 'ConstraintsResource', properties.ConstraintsResource != null ? CfnModelBiasJobDefinitionConstraintsResourcePropertyFromCloudFormation(properties.ConstraintsResource) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ModelBiasJobInputProperty`
 *
 * @param properties - the TypeScript properties of a `ModelBiasJobInputProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelBiasJobDefinition_ModelBiasJobInputPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('batchTransformInput', CfnModelBiasJobDefinition_BatchTransformInputPropertyValidator)(properties.batchTransformInput));
    errors.collect(cdk.propertyValidator('endpointInput', CfnModelBiasJobDefinition_EndpointInputPropertyValidator)(properties.endpointInput));
    errors.collect(cdk.propertyValidator('groundTruthS3Input', cdk.requiredValidator)(properties.groundTruthS3Input));
    errors.collect(cdk.propertyValidator('groundTruthS3Input', CfnModelBiasJobDefinition_MonitoringGroundTruthS3InputPropertyValidator)(properties.groundTruthS3Input));
    return errors.wrap('supplied properties not correct for "ModelBiasJobInputProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelBiasJobDefinition.ModelBiasJobInput` resource
 *
 * @param properties - the TypeScript properties of a `ModelBiasJobInputProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelBiasJobDefinition.ModelBiasJobInput` resource.
 */
// @ts-ignore TS6133
function cfnModelBiasJobDefinitionModelBiasJobInputPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelBiasJobDefinition_ModelBiasJobInputPropertyValidator(properties).assertSuccess();
    return {
        BatchTransformInput: cfnModelBiasJobDefinitionBatchTransformInputPropertyToCloudFormation(properties.batchTransformInput),
        EndpointInput: cfnModelBiasJobDefinitionEndpointInputPropertyToCloudFormation(properties.endpointInput),
        GroundTruthS3Input: cfnModelBiasJobDefinitionMonitoringGroundTruthS3InputPropertyToCloudFormation(properties.groundTruthS3Input),
    };
}
// @ts-ignore TS6133
function CfnModelBiasJobDefinitionModelBiasJobInputPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('batchTransformInput', 'BatchTransformInput', properties.BatchTransformInput != null ? CfnModelBiasJobDefinitionBatchTransformInputPropertyFromCloudFormation(properties.BatchTransformInput) : undefined);
    ret.addPropertyResult('endpointInput', 'EndpointInput', properties.EndpointInput != null ? CfnModelBiasJobDefinitionEndpointInputPropertyFromCloudFormation(properties.EndpointInput) : undefined);
    ret.addPropertyResult('groundTruthS3Input', 'GroundTruthS3Input', CfnModelBiasJobDefinitionMonitoringGroundTruthS3InputPropertyFromCloudFormation(properties.GroundTruthS3Input));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MonitoringGroundTruthS3InputProperty`
 *
 * @param properties - the TypeScript properties of a `MonitoringGroundTruthS3InputProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelBiasJobDefinition_MonitoringGroundTruthS3InputPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('s3Uri', cdk.requiredValidator)(properties.s3Uri));
    errors.collect(cdk.propertyValidator('s3Uri', cdk.validateString)(properties.s3Uri));
    return errors.wrap('supplied properties not correct for "MonitoringGroundTruthS3InputProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelBiasJobDefinition.MonitoringGroundTruthS3Input` resource
 *
 * @param properties - the TypeScript properties of a `MonitoringGroundTruthS3InputProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelBiasJobDefinition.MonitoringGroundTruthS3Input` resource.
 */
// @ts-ignore TS6133
function cfnModelBiasJobDefinitionMonitoringGroundTruthS3InputPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelBiasJobDefinition_MonitoringGroundTruthS3InputPropertyValidator(properties).assertSuccess();
    return {
        S3Uri: cdk.stringToCloudFormation(properties.s3Uri),
    };
}
// @ts-ignore TS6133
function CfnModelBiasJobDefinitionMonitoringGroundTruthS3InputPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('s3Uri', 'S3Uri', cfn_parse.FromCloudFormation.getString(properties.S3Uri));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MonitoringOutputProperty`
 *
 * @param properties - the TypeScript properties of a `MonitoringOutputProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelBiasJobDefinition_MonitoringOutputPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('s3Output', cdk.requiredValidator)(properties.s3Output));
    errors.collect(cdk.propertyValidator('s3Output', CfnModelBiasJobDefinition_S3OutputPropertyValidator)(properties.s3Output));
    return errors.wrap('supplied properties not correct for "MonitoringOutputProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelBiasJobDefinition.MonitoringOutput` resource
 *
 * @param properties - the TypeScript properties of a `MonitoringOutputProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelBiasJobDefinition.MonitoringOutput` resource.
 */
// @ts-ignore TS6133
function cfnModelBiasJobDefinitionMonitoringOutputPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelBiasJobDefinition_MonitoringOutputPropertyValidator(properties).assertSuccess();
    return {
        S3Output: cfnModelBiasJobDefinitionS3OutputPropertyToCloudFormation(properties.s3Output),
    };
}
// @ts-ignore TS6133
function CfnModelBiasJobDefinitionMonitoringOutputPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('s3Output', 'S3Output', CfnModelBiasJobDefinitionS3OutputPropertyFromCloudFormation(properties.S3Output));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MonitoringOutputConfigProperty`
 *
 * @param properties - the TypeScript properties of a `MonitoringOutputConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelBiasJobDefinition_MonitoringOutputConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('kmsKeyId', cdk.validateString)(properties.kmsKeyId));
    errors.collect(cdk.propertyValidator('monitoringOutputs', cdk.requiredValidator)(properties.monitoringOutputs));
    errors.collect(cdk.propertyValidator('monitoringOutputs', cdk.listValidator(CfnModelBiasJobDefinition_MonitoringOutputPropertyValidator))(properties.monitoringOutputs));
    return errors.wrap('supplied properties not correct for "MonitoringOutputConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelBiasJobDefinition.MonitoringOutputConfig` resource
 *
 * @param properties - the TypeScript properties of a `MonitoringOutputConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelBiasJobDefinition.MonitoringOutputConfig` resource.
 */
// @ts-ignore TS6133
function cfnModelBiasJobDefinitionMonitoringOutputConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelBiasJobDefinition_MonitoringOutputConfigPropertyValidator(properties).assertSuccess();
    return {
        KmsKeyId: cdk.stringToCloudFormation(properties.kmsKeyId),
        MonitoringOutputs: cdk.listMapper(cfnModelBiasJobDefinitionMonitoringOutputPropertyToCloudFormation)(properties.monitoringOutputs),
    };
}
// @ts-ignore TS6133
function CfnModelBiasJobDefinitionMonitoringOutputConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('kmsKeyId', 'KmsKeyId', properties.KmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.KmsKeyId) : undefined);
    ret.addPropertyResult('monitoringOutputs', 'MonitoringOutputs', cfn_parse.FromCloudFormation.getArray(CfnModelBiasJobDefinitionMonitoringOutputPropertyFromCloudFormation)(properties.MonitoringOutputs));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MonitoringResourcesProperty`
 *
 * @param properties - the TypeScript properties of a `MonitoringResourcesProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelBiasJobDefinition_MonitoringResourcesPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('clusterConfig', cdk.requiredValidator)(properties.clusterConfig));
    errors.collect(cdk.propertyValidator('clusterConfig', CfnModelBiasJobDefinition_ClusterConfigPropertyValidator)(properties.clusterConfig));
    return errors.wrap('supplied properties not correct for "MonitoringResourcesProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelBiasJobDefinition.MonitoringResources` resource
 *
 * @param properties - the TypeScript properties of a `MonitoringResourcesProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelBiasJobDefinition.MonitoringResources` resource.
 */
// @ts-ignore TS6133
function cfnModelBiasJobDefinitionMonitoringResourcesPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelBiasJobDefinition_MonitoringResourcesPropertyValidator(properties).assertSuccess();
    return {
        ClusterConfig: cfnModelBiasJobDefinitionClusterConfigPropertyToCloudFormation(properties.clusterConfig),
    };
}
// @ts-ignore TS6133
function CfnModelBiasJobDefinitionMonitoringResourcesPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('clusterConfig', 'ClusterConfig', CfnModelBiasJobDefinitionClusterConfigPropertyFromCloudFormation(properties.ClusterConfig));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `NetworkConfigProperty`
 *
 * @param properties - the TypeScript properties of a `NetworkConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelBiasJobDefinition_NetworkConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('enableInterContainerTrafficEncryption', cdk.validateBoolean)(properties.enableInterContainerTrafficEncryption));
    errors.collect(cdk.propertyValidator('enableNetworkIsolation', cdk.validateBoolean)(properties.enableNetworkIsolation));
    errors.collect(cdk.propertyValidator('vpcConfig', CfnModelBiasJobDefinition_VpcConfigPropertyValidator)(properties.vpcConfig));
    return errors.wrap('supplied properties not correct for "NetworkConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelBiasJobDefinition.NetworkConfig` resource
 *
 * @param properties - the TypeScript properties of a `NetworkConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelBiasJobDefinition.NetworkConfig` resource.
 */
// @ts-ignore TS6133
function cfnModelBiasJobDefinitionNetworkConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelBiasJobDefinition_NetworkConfigPropertyValidator(properties).assertSuccess();
    return {
        EnableInterContainerTrafficEncryption: cdk.booleanToCloudFormation(properties.enableInterContainerTrafficEncryption),
        EnableNetworkIsolation: cdk.booleanToCloudFormation(properties.enableNetworkIsolation),
        VpcConfig: cfnModelBiasJobDefinitionVpcConfigPropertyToCloudFormation(properties.vpcConfig),
    };
}
// @ts-ignore TS6133
function CfnModelBiasJobDefinitionNetworkConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('enableInterContainerTrafficEncryption', 'EnableInterContainerTrafficEncryption', properties.EnableInterContainerTrafficEncryption != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EnableInterContainerTrafficEncryption) : undefined);
    ret.addPropertyResult('enableNetworkIsolation', 'EnableNetworkIsolation', properties.EnableNetworkIsolation != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EnableNetworkIsolation) : undefined);
    ret.addPropertyResult('vpcConfig', 'VpcConfig', properties.VpcConfig != null ? CfnModelBiasJobDefinitionVpcConfigPropertyFromCloudFormation(properties.VpcConfig) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `S3OutputProperty`
 *
 * @param properties - the TypeScript properties of a `S3OutputProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelBiasJobDefinition_S3OutputPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('localPath', cdk.requiredValidator)(properties.localPath));
    errors.collect(cdk.propertyValidator('localPath', cdk.validateString)(properties.localPath));
    errors.collect(cdk.propertyValidator('s3UploadMode', cdk.validateString)(properties.s3UploadMode));
    errors.collect(cdk.propertyValidator('s3Uri', cdk.requiredValidator)(properties.s3Uri));
    errors.collect(cdk.propertyValidator('s3Uri', cdk.validateString)(properties.s3Uri));
    return errors.wrap('supplied properties not correct for "S3OutputProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelBiasJobDefinition.S3Output` resource
 *
 * @param properties - the TypeScript properties of a `S3OutputProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelBiasJobDefinition.S3Output` resource.
 */
// @ts-ignore TS6133
function cfnModelBiasJobDefinitionS3OutputPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelBiasJobDefinition_S3OutputPropertyValidator(properties).assertSuccess();
    return {
        LocalPath: cdk.stringToCloudFormation(properties.localPath),
        S3UploadMode: cdk.stringToCloudFormation(properties.s3UploadMode),
        S3Uri: cdk.stringToCloudFormation(properties.s3Uri),
    };
}
// @ts-ignore TS6133
function CfnModelBiasJobDefinitionS3OutputPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('localPath', 'LocalPath', cfn_parse.FromCloudFormation.getString(properties.LocalPath));
    ret.addPropertyResult('s3UploadMode', 'S3UploadMode', properties.S3UploadMode != null ? cfn_parse.FromCloudFormation.getString(properties.S3UploadMode) : undefined);
    ret.addPropertyResult('s3Uri', 'S3Uri', cfn_parse.FromCloudFormation.getString(properties.S3Uri));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `StoppingConditionProperty`
 *
 * @param properties - the TypeScript properties of a `StoppingConditionProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelBiasJobDefinition_StoppingConditionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('maxRuntimeInSeconds', cdk.requiredValidator)(properties.maxRuntimeInSeconds));
    errors.collect(cdk.propertyValidator('maxRuntimeInSeconds', cdk.validateNumber)(properties.maxRuntimeInSeconds));
    return errors.wrap('supplied properties not correct for "StoppingConditionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelBiasJobDefinition.StoppingCondition` resource
 *
 * @param properties - the TypeScript properties of a `StoppingConditionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelBiasJobDefinition.StoppingCondition` resource.
 */
// @ts-ignore TS6133
function cfnModelBiasJobDefinitionStoppingConditionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelBiasJobDefinition_StoppingConditionPropertyValidator(properties).assertSuccess();
    return {
        MaxRuntimeInSeconds: cdk.numberToCloudFormation(properties.maxRuntimeInSeconds),
    };
}
// @ts-ignore TS6133
function CfnModelBiasJobDefinitionStoppingConditionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('maxRuntimeInSeconds', 'MaxRuntimeInSeconds', cfn_parse.FromCloudFormation.getNumber(properties.MaxRuntimeInSeconds));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `VpcConfigProperty`
 *
 * @param properties - the TypeScript properties of a `VpcConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelBiasJobDefinition_VpcConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('securityGroupIds', cdk.requiredValidator)(properties.securityGroupIds));
    errors.collect(cdk.propertyValidator('securityGroupIds', cdk.listValidator(cdk.validateString))(properties.securityGroupIds));
    errors.collect(cdk.propertyValidator('subnets', cdk.requiredValidator)(properties.subnets));
    errors.collect(cdk.propertyValidator('subnets', cdk.listValidator(cdk.validateString))(properties.subnets));
    return errors.wrap('supplied properties not correct for "VpcConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelBiasJobDefinition.VpcConfig` resource
 *
 * @param properties - the TypeScript properties of a `VpcConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelBiasJobDefinition.VpcConfig` resource.
 */
// @ts-ignore TS6133
function cfnModelBiasJobDefinitionVpcConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelBiasJobDefinition_VpcConfigPropertyValidator(properties).assertSuccess();
    return {
        SecurityGroupIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.securityGroupIds),
        Subnets: cdk.listMapper(cdk.stringToCloudFormation)(properties.subnets),
    };
}
// @ts-ignore TS6133
function CfnModelBiasJobDefinitionVpcConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('securityGroupIds', 'SecurityGroupIds', cfn_parse.FromCloudFormation.getStringArray(properties.SecurityGroupIds));
    ret.addPropertyResult('subnets', 'Subnets', cfn_parse.FromCloudFormation.getStringArray(properties.Subnets));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnModelExplainabilityJobDefinitionProps`
 *
 * @param properties - the TypeScript properties of a `CfnModelExplainabilityJobDefinitionProps`
 *
 * @returns the result of the validation.
 */
function CfnModelExplainabilityJobDefinitionPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('endpointName', cdk.validateString)(properties.endpointName));
    errors.collect(cdk.propertyValidator('jobDefinitionName', cdk.validateString)(properties.jobDefinitionName));
    errors.collect(cdk.propertyValidator('jobResources', cdk.requiredValidator)(properties.jobResources));
    errors.collect(cdk.propertyValidator('jobResources', CfnModelExplainabilityJobDefinition_MonitoringResourcesPropertyValidator)(properties.jobResources));
    errors.collect(cdk.propertyValidator('modelExplainabilityAppSpecification', cdk.requiredValidator)(properties.modelExplainabilityAppSpecification));
    errors.collect(cdk.propertyValidator('modelExplainabilityAppSpecification', CfnModelExplainabilityJobDefinition_ModelExplainabilityAppSpecificationPropertyValidator)(properties.modelExplainabilityAppSpecification));
    errors.collect(cdk.propertyValidator('modelExplainabilityBaselineConfig', CfnModelExplainabilityJobDefinition_ModelExplainabilityBaselineConfigPropertyValidator)(properties.modelExplainabilityBaselineConfig));
    errors.collect(cdk.propertyValidator('modelExplainabilityJobInput', cdk.requiredValidator)(properties.modelExplainabilityJobInput));
    errors.collect(cdk.propertyValidator('modelExplainabilityJobInput', CfnModelExplainabilityJobDefinition_ModelExplainabilityJobInputPropertyValidator)(properties.modelExplainabilityJobInput));
    errors.collect(cdk.propertyValidator('modelExplainabilityJobOutputConfig', cdk.requiredValidator)(properties.modelExplainabilityJobOutputConfig));
    errors.collect(cdk.propertyValidator('modelExplainabilityJobOutputConfig', CfnModelExplainabilityJobDefinition_MonitoringOutputConfigPropertyValidator)(properties.modelExplainabilityJobOutputConfig));
    errors.collect(cdk.propertyValidator('networkConfig', CfnModelExplainabilityJobDefinition_NetworkConfigPropertyValidator)(properties.networkConfig));
    errors.collect(cdk.propertyValidator('roleArn', cdk.requiredValidator)(properties.roleArn));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    errors.collect(cdk.propertyValidator('stoppingCondition', CfnModelExplainabilityJobDefinition_StoppingConditionPropertyValidator)(properties.stoppingCondition));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnModelExplainabilityJobDefinitionProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelExplainabilityJobDefinition` resource
 *
 * @param properties - the TypeScript properties of a `CfnModelExplainabilityJobDefinitionProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelExplainabilityJobDefinition` resource.
 */
// @ts-ignore TS6133
function cfnModelExplainabilityJobDefinitionPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelExplainabilityJobDefinitionPropsValidator(properties).assertSuccess();
    return {
        JobResources: cfnModelExplainabilityJobDefinitionMonitoringResourcesPropertyToCloudFormation(properties.jobResources),
        ModelExplainabilityAppSpecification: cfnModelExplainabilityJobDefinitionModelExplainabilityAppSpecificationPropertyToCloudFormation(properties.modelExplainabilityAppSpecification),
        ModelExplainabilityJobInput: cfnModelExplainabilityJobDefinitionModelExplainabilityJobInputPropertyToCloudFormation(properties.modelExplainabilityJobInput),
        ModelExplainabilityJobOutputConfig: cfnModelExplainabilityJobDefinitionMonitoringOutputConfigPropertyToCloudFormation(properties.modelExplainabilityJobOutputConfig),
        RoleArn: cdk.stringToCloudFormation(properties.roleArn),
        EndpointName: cdk.stringToCloudFormation(properties.endpointName),
        JobDefinitionName: cdk.stringToCloudFormation(properties.jobDefinitionName),
        ModelExplainabilityBaselineConfig: cfnModelExplainabilityJobDefinitionModelExplainabilityBaselineConfigPropertyToCloudFormation(properties.modelExplainabilityBaselineConfig),
        NetworkConfig: cfnModelExplainabilityJobDefinitionNetworkConfigPropertyToCloudFormation(properties.networkConfig),
        StoppingCondition: cfnModelExplainabilityJobDefinitionStoppingConditionPropertyToCloudFormation(properties.stoppingCondition),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnModelExplainabilityJobDefinitionPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('jobResources', 'JobResources', CfnModelExplainabilityJobDefinitionMonitoringResourcesPropertyFromCloudFormation(properties.JobResources));
    ret.addPropertyResult('modelExplainabilityAppSpecification', 'ModelExplainabilityAppSpecification', CfnModelExplainabilityJobDefinitionModelExplainabilityAppSpecificationPropertyFromCloudFormation(properties.ModelExplainabilityAppSpecification));
    ret.addPropertyResult('modelExplainabilityJobInput', 'ModelExplainabilityJobInput', CfnModelExplainabilityJobDefinitionModelExplainabilityJobInputPropertyFromCloudFormation(properties.ModelExplainabilityJobInput));
    ret.addPropertyResult('modelExplainabilityJobOutputConfig', 'ModelExplainabilityJobOutputConfig', CfnModelExplainabilityJobDefinitionMonitoringOutputConfigPropertyFromCloudFormation(properties.ModelExplainabilityJobOutputConfig));
    ret.addPropertyResult('roleArn', 'RoleArn', cfn_parse.FromCloudFormation.getString(properties.RoleArn));
    ret.addPropertyResult('endpointName', 'EndpointName', properties.EndpointName != null ? cfn_parse.FromCloudFormation.getString(properties.EndpointName) : undefined);
    ret.addPropertyResult('jobDefinitionName', 'JobDefinitionName', properties.JobDefinitionName != null ? cfn_parse.FromCloudFormation.getString(properties.JobDefinitionName) : undefined);
    ret.addPropertyResult('modelExplainabilityBaselineConfig', 'ModelExplainabilityBaselineConfig', properties.ModelExplainabilityBaselineConfig != null ? CfnModelExplainabilityJobDefinitionModelExplainabilityBaselineConfigPropertyFromCloudFormation(properties.ModelExplainabilityBaselineConfig) : undefined);
    ret.addPropertyResult('networkConfig', 'NetworkConfig', properties.NetworkConfig != null ? CfnModelExplainabilityJobDefinitionNetworkConfigPropertyFromCloudFormation(properties.NetworkConfig) : undefined);
    ret.addPropertyResult('stoppingCondition', 'StoppingCondition', properties.StoppingCondition != null ? CfnModelExplainabilityJobDefinitionStoppingConditionPropertyFromCloudFormation(properties.StoppingCondition) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::SageMaker::ModelExplainabilityJobDefinition`
 *
 * Creates the definition for a model explainability job.
 *
 * @cloudformationResource AWS::SageMaker::ModelExplainabilityJobDefinition
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html
 */
class CfnModelExplainabilityJobDefinition extends cdk.CfnResource {
    /**
     * Create a new `AWS::SageMaker::ModelExplainabilityJobDefinition`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnModelExplainabilityJobDefinition.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_sagemaker_CfnModelExplainabilityJobDefinitionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnModelExplainabilityJobDefinition);
            }
            throw error;
        }
        cdk.requireProperty(props, 'jobResources', this);
        cdk.requireProperty(props, 'modelExplainabilityAppSpecification', this);
        cdk.requireProperty(props, 'modelExplainabilityJobInput', this);
        cdk.requireProperty(props, 'modelExplainabilityJobOutputConfig', this);
        cdk.requireProperty(props, 'roleArn', this);
        this.attrCreationTime = cdk.Token.asString(this.getAtt('CreationTime'));
        this.attrJobDefinitionArn = cdk.Token.asString(this.getAtt('JobDefinitionArn'));
        this.jobResources = props.jobResources;
        this.modelExplainabilityAppSpecification = props.modelExplainabilityAppSpecification;
        this.modelExplainabilityJobInput = props.modelExplainabilityJobInput;
        this.modelExplainabilityJobOutputConfig = props.modelExplainabilityJobOutputConfig;
        this.roleArn = props.roleArn;
        this.endpointName = props.endpointName;
        this.jobDefinitionName = props.jobDefinitionName;
        this.modelExplainabilityBaselineConfig = props.modelExplainabilityBaselineConfig;
        this.networkConfig = props.networkConfig;
        this.stoppingCondition = props.stoppingCondition;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::SageMaker::ModelExplainabilityJobDefinition", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnModelExplainabilityJobDefinitionPropsFromCloudFormation(resourceProperties);
        const ret = new CfnModelExplainabilityJobDefinition(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnModelExplainabilityJobDefinition.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            jobResources: this.jobResources,
            modelExplainabilityAppSpecification: this.modelExplainabilityAppSpecification,
            modelExplainabilityJobInput: this.modelExplainabilityJobInput,
            modelExplainabilityJobOutputConfig: this.modelExplainabilityJobOutputConfig,
            roleArn: this.roleArn,
            endpointName: this.endpointName,
            jobDefinitionName: this.jobDefinitionName,
            modelExplainabilityBaselineConfig: this.modelExplainabilityBaselineConfig,
            networkConfig: this.networkConfig,
            stoppingCondition: this.stoppingCondition,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnModelExplainabilityJobDefinitionPropsToCloudFormation(props);
    }
}
exports.CfnModelExplainabilityJobDefinition = CfnModelExplainabilityJobDefinition;
_q = JSII_RTTI_SYMBOL_1;
CfnModelExplainabilityJobDefinition[_q] = { fqn: "@aws-cdk/aws-sagemaker.CfnModelExplainabilityJobDefinition", version: "1.186.1" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnModelExplainabilityJobDefinition.CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::ModelExplainabilityJobDefinition";
/**
 * Determine whether the given properties match those of a `BatchTransformInputProperty`
 *
 * @param properties - the TypeScript properties of a `BatchTransformInputProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelExplainabilityJobDefinition_BatchTransformInputPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dataCapturedDestinationS3Uri', cdk.requiredValidator)(properties.dataCapturedDestinationS3Uri));
    errors.collect(cdk.propertyValidator('dataCapturedDestinationS3Uri', cdk.validateString)(properties.dataCapturedDestinationS3Uri));
    errors.collect(cdk.propertyValidator('datasetFormat', cdk.requiredValidator)(properties.datasetFormat));
    errors.collect(cdk.propertyValidator('datasetFormat', CfnModelExplainabilityJobDefinition_DatasetFormatPropertyValidator)(properties.datasetFormat));
    errors.collect(cdk.propertyValidator('featuresAttribute', cdk.validateString)(properties.featuresAttribute));
    errors.collect(cdk.propertyValidator('inferenceAttribute', cdk.validateString)(properties.inferenceAttribute));
    errors.collect(cdk.propertyValidator('localPath', cdk.requiredValidator)(properties.localPath));
    errors.collect(cdk.propertyValidator('localPath', cdk.validateString)(properties.localPath));
    errors.collect(cdk.propertyValidator('probabilityAttribute', cdk.validateString)(properties.probabilityAttribute));
    errors.collect(cdk.propertyValidator('s3DataDistributionType', cdk.validateString)(properties.s3DataDistributionType));
    errors.collect(cdk.propertyValidator('s3InputMode', cdk.validateString)(properties.s3InputMode));
    return errors.wrap('supplied properties not correct for "BatchTransformInputProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelExplainabilityJobDefinition.BatchTransformInput` resource
 *
 * @param properties - the TypeScript properties of a `BatchTransformInputProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelExplainabilityJobDefinition.BatchTransformInput` resource.
 */
// @ts-ignore TS6133
function cfnModelExplainabilityJobDefinitionBatchTransformInputPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelExplainabilityJobDefinition_BatchTransformInputPropertyValidator(properties).assertSuccess();
    return {
        DataCapturedDestinationS3Uri: cdk.stringToCloudFormation(properties.dataCapturedDestinationS3Uri),
        DatasetFormat: cfnModelExplainabilityJobDefinitionDatasetFormatPropertyToCloudFormation(properties.datasetFormat),
        FeaturesAttribute: cdk.stringToCloudFormation(properties.featuresAttribute),
        InferenceAttribute: cdk.stringToCloudFormation(properties.inferenceAttribute),
        LocalPath: cdk.stringToCloudFormation(properties.localPath),
        ProbabilityAttribute: cdk.stringToCloudFormation(properties.probabilityAttribute),
        S3DataDistributionType: cdk.stringToCloudFormation(properties.s3DataDistributionType),
        S3InputMode: cdk.stringToCloudFormation(properties.s3InputMode),
    };
}
// @ts-ignore TS6133
function CfnModelExplainabilityJobDefinitionBatchTransformInputPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dataCapturedDestinationS3Uri', 'DataCapturedDestinationS3Uri', cfn_parse.FromCloudFormation.getString(properties.DataCapturedDestinationS3Uri));
    ret.addPropertyResult('datasetFormat', 'DatasetFormat', CfnModelExplainabilityJobDefinitionDatasetFormatPropertyFromCloudFormation(properties.DatasetFormat));
    ret.addPropertyResult('featuresAttribute', 'FeaturesAttribute', properties.FeaturesAttribute != null ? cfn_parse.FromCloudFormation.getString(properties.FeaturesAttribute) : undefined);
    ret.addPropertyResult('inferenceAttribute', 'InferenceAttribute', properties.InferenceAttribute != null ? cfn_parse.FromCloudFormation.getString(properties.InferenceAttribute) : undefined);
    ret.addPropertyResult('localPath', 'LocalPath', cfn_parse.FromCloudFormation.getString(properties.LocalPath));
    ret.addPropertyResult('probabilityAttribute', 'ProbabilityAttribute', properties.ProbabilityAttribute != null ? cfn_parse.FromCloudFormation.getString(properties.ProbabilityAttribute) : undefined);
    ret.addPropertyResult('s3DataDistributionType', 'S3DataDistributionType', properties.S3DataDistributionType != null ? cfn_parse.FromCloudFormation.getString(properties.S3DataDistributionType) : undefined);
    ret.addPropertyResult('s3InputMode', 'S3InputMode', properties.S3InputMode != null ? cfn_parse.FromCloudFormation.getString(properties.S3InputMode) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ClusterConfigProperty`
 *
 * @param properties - the TypeScript properties of a `ClusterConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelExplainabilityJobDefinition_ClusterConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('instanceCount', cdk.requiredValidator)(properties.instanceCount));
    errors.collect(cdk.propertyValidator('instanceCount', cdk.validateNumber)(properties.instanceCount));
    errors.collect(cdk.propertyValidator('instanceType', cdk.requiredValidator)(properties.instanceType));
    errors.collect(cdk.propertyValidator('instanceType', cdk.validateString)(properties.instanceType));
    errors.collect(cdk.propertyValidator('volumeKmsKeyId', cdk.validateString)(properties.volumeKmsKeyId));
    errors.collect(cdk.propertyValidator('volumeSizeInGb', cdk.requiredValidator)(properties.volumeSizeInGb));
    errors.collect(cdk.propertyValidator('volumeSizeInGb', cdk.validateNumber)(properties.volumeSizeInGb));
    return errors.wrap('supplied properties not correct for "ClusterConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelExplainabilityJobDefinition.ClusterConfig` resource
 *
 * @param properties - the TypeScript properties of a `ClusterConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelExplainabilityJobDefinition.ClusterConfig` resource.
 */
// @ts-ignore TS6133
function cfnModelExplainabilityJobDefinitionClusterConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelExplainabilityJobDefinition_ClusterConfigPropertyValidator(properties).assertSuccess();
    return {
        InstanceCount: cdk.numberToCloudFormation(properties.instanceCount),
        InstanceType: cdk.stringToCloudFormation(properties.instanceType),
        VolumeKmsKeyId: cdk.stringToCloudFormation(properties.volumeKmsKeyId),
        VolumeSizeInGB: cdk.numberToCloudFormation(properties.volumeSizeInGb),
    };
}
// @ts-ignore TS6133
function CfnModelExplainabilityJobDefinitionClusterConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('instanceCount', 'InstanceCount', cfn_parse.FromCloudFormation.getNumber(properties.InstanceCount));
    ret.addPropertyResult('instanceType', 'InstanceType', cfn_parse.FromCloudFormation.getString(properties.InstanceType));
    ret.addPropertyResult('volumeKmsKeyId', 'VolumeKmsKeyId', properties.VolumeKmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.VolumeKmsKeyId) : undefined);
    ret.addPropertyResult('volumeSizeInGb', 'VolumeSizeInGB', cfn_parse.FromCloudFormation.getNumber(properties.VolumeSizeInGB));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ConstraintsResourceProperty`
 *
 * @param properties - the TypeScript properties of a `ConstraintsResourceProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelExplainabilityJobDefinition_ConstraintsResourcePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('s3Uri', cdk.validateString)(properties.s3Uri));
    return errors.wrap('supplied properties not correct for "ConstraintsResourceProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelExplainabilityJobDefinition.ConstraintsResource` resource
 *
 * @param properties - the TypeScript properties of a `ConstraintsResourceProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelExplainabilityJobDefinition.ConstraintsResource` resource.
 */
// @ts-ignore TS6133
function cfnModelExplainabilityJobDefinitionConstraintsResourcePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelExplainabilityJobDefinition_ConstraintsResourcePropertyValidator(properties).assertSuccess();
    return {
        S3Uri: cdk.stringToCloudFormation(properties.s3Uri),
    };
}
// @ts-ignore TS6133
function CfnModelExplainabilityJobDefinitionConstraintsResourcePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('s3Uri', 'S3Uri', properties.S3Uri != null ? cfn_parse.FromCloudFormation.getString(properties.S3Uri) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CsvProperty`
 *
 * @param properties - the TypeScript properties of a `CsvProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelExplainabilityJobDefinition_CsvPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('header', cdk.validateBoolean)(properties.header));
    return errors.wrap('supplied properties not correct for "CsvProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelExplainabilityJobDefinition.Csv` resource
 *
 * @param properties - the TypeScript properties of a `CsvProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelExplainabilityJobDefinition.Csv` resource.
 */
// @ts-ignore TS6133
function cfnModelExplainabilityJobDefinitionCsvPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelExplainabilityJobDefinition_CsvPropertyValidator(properties).assertSuccess();
    return {
        Header: cdk.booleanToCloudFormation(properties.header),
    };
}
// @ts-ignore TS6133
function CfnModelExplainabilityJobDefinitionCsvPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('header', 'Header', properties.Header != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Header) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DatasetFormatProperty`
 *
 * @param properties - the TypeScript properties of a `DatasetFormatProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelExplainabilityJobDefinition_DatasetFormatPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('csv', CfnModelExplainabilityJobDefinition_CsvPropertyValidator)(properties.csv));
    errors.collect(cdk.propertyValidator('json', cdk.validateObject)(properties.json));
    errors.collect(cdk.propertyValidator('parquet', cdk.validateBoolean)(properties.parquet));
    return errors.wrap('supplied properties not correct for "DatasetFormatProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelExplainabilityJobDefinition.DatasetFormat` resource
 *
 * @param properties - the TypeScript properties of a `DatasetFormatProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelExplainabilityJobDefinition.DatasetFormat` resource.
 */
// @ts-ignore TS6133
function cfnModelExplainabilityJobDefinitionDatasetFormatPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelExplainabilityJobDefinition_DatasetFormatPropertyValidator(properties).assertSuccess();
    return {
        Csv: cfnModelExplainabilityJobDefinitionCsvPropertyToCloudFormation(properties.csv),
        Json: cdk.objectToCloudFormation(properties.json),
        Parquet: cdk.booleanToCloudFormation(properties.parquet),
    };
}
// @ts-ignore TS6133
function CfnModelExplainabilityJobDefinitionDatasetFormatPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('csv', 'Csv', properties.Csv != null ? CfnModelExplainabilityJobDefinitionCsvPropertyFromCloudFormation(properties.Csv) : undefined);
    ret.addPropertyResult('json', 'Json', properties.Json != null ? cfn_parse.FromCloudFormation.getAny(properties.Json) : undefined);
    ret.addPropertyResult('parquet', 'Parquet', properties.Parquet != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Parquet) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `EndpointInputProperty`
 *
 * @param properties - the TypeScript properties of a `EndpointInputProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelExplainabilityJobDefinition_EndpointInputPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('endpointName', cdk.requiredValidator)(properties.endpointName));
    errors.collect(cdk.propertyValidator('endpointName', cdk.validateString)(properties.endpointName));
    errors.collect(cdk.propertyValidator('featuresAttribute', cdk.validateString)(properties.featuresAttribute));
    errors.collect(cdk.propertyValidator('inferenceAttribute', cdk.validateString)(properties.inferenceAttribute));
    errors.collect(cdk.propertyValidator('localPath', cdk.requiredValidator)(properties.localPath));
    errors.collect(cdk.propertyValidator('localPath', cdk.validateString)(properties.localPath));
    errors.collect(cdk.propertyValidator('probabilityAttribute', cdk.validateString)(properties.probabilityAttribute));
    errors.collect(cdk.propertyValidator('s3DataDistributionType', cdk.validateString)(properties.s3DataDistributionType));
    errors.collect(cdk.propertyValidator('s3InputMode', cdk.validateString)(properties.s3InputMode));
    return errors.wrap('supplied properties not correct for "EndpointInputProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelExplainabilityJobDefinition.EndpointInput` resource
 *
 * @param properties - the TypeScript properties of a `EndpointInputProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelExplainabilityJobDefinition.EndpointInput` resource.
 */
// @ts-ignore TS6133
function cfnModelExplainabilityJobDefinitionEndpointInputPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelExplainabilityJobDefinition_EndpointInputPropertyValidator(properties).assertSuccess();
    return {
        EndpointName: cdk.stringToCloudFormation(properties.endpointName),
        FeaturesAttribute: cdk.stringToCloudFormation(properties.featuresAttribute),
        InferenceAttribute: cdk.stringToCloudFormation(properties.inferenceAttribute),
        LocalPath: cdk.stringToCloudFormation(properties.localPath),
        ProbabilityAttribute: cdk.stringToCloudFormation(properties.probabilityAttribute),
        S3DataDistributionType: cdk.stringToCloudFormation(properties.s3DataDistributionType),
        S3InputMode: cdk.stringToCloudFormation(properties.s3InputMode),
    };
}
// @ts-ignore TS6133
function CfnModelExplainabilityJobDefinitionEndpointInputPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('endpointName', 'EndpointName', cfn_parse.FromCloudFormation.getString(properties.EndpointName));
    ret.addPropertyResult('featuresAttribute', 'FeaturesAttribute', properties.FeaturesAttribute != null ? cfn_parse.FromCloudFormation.getString(properties.FeaturesAttribute) : undefined);
    ret.addPropertyResult('inferenceAttribute', 'InferenceAttribute', properties.InferenceAttribute != null ? cfn_parse.FromCloudFormation.getString(properties.InferenceAttribute) : undefined);
    ret.addPropertyResult('localPath', 'LocalPath', cfn_parse.FromCloudFormation.getString(properties.LocalPath));
    ret.addPropertyResult('probabilityAttribute', 'ProbabilityAttribute', properties.ProbabilityAttribute != null ? cfn_parse.FromCloudFormation.getString(properties.ProbabilityAttribute) : undefined);
    ret.addPropertyResult('s3DataDistributionType', 'S3DataDistributionType', properties.S3DataDistributionType != null ? cfn_parse.FromCloudFormation.getString(properties.S3DataDistributionType) : undefined);
    ret.addPropertyResult('s3InputMode', 'S3InputMode', properties.S3InputMode != null ? cfn_parse.FromCloudFormation.getString(properties.S3InputMode) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `JsonProperty`
 *
 * @param properties - the TypeScript properties of a `JsonProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelExplainabilityJobDefinition_JsonPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('line', cdk.validateBoolean)(properties.line));
    return errors.wrap('supplied properties not correct for "JsonProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelExplainabilityJobDefinition.Json` resource
 *
 * @param properties - the TypeScript properties of a `JsonProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelExplainabilityJobDefinition.Json` resource.
 */
// @ts-ignore TS6133
function cfnModelExplainabilityJobDefinitionJsonPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelExplainabilityJobDefinition_JsonPropertyValidator(properties).assertSuccess();
    return {
        Line: cdk.booleanToCloudFormation(properties.line),
    };
}
// @ts-ignore TS6133
function CfnModelExplainabilityJobDefinitionJsonPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('line', 'Line', properties.Line != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Line) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ModelExplainabilityAppSpecificationProperty`
 *
 * @param properties - the TypeScript properties of a `ModelExplainabilityAppSpecificationProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelExplainabilityJobDefinition_ModelExplainabilityAppSpecificationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('configUri', cdk.requiredValidator)(properties.configUri));
    errors.collect(cdk.propertyValidator('configUri', cdk.validateString)(properties.configUri));
    errors.collect(cdk.propertyValidator('environment', cdk.hashValidator(cdk.validateString))(properties.environment));
    errors.collect(cdk.propertyValidator('imageUri', cdk.requiredValidator)(properties.imageUri));
    errors.collect(cdk.propertyValidator('imageUri', cdk.validateString)(properties.imageUri));
    return errors.wrap('supplied properties not correct for "ModelExplainabilityAppSpecificationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelExplainabilityJobDefinition.ModelExplainabilityAppSpecification` resource
 *
 * @param properties - the TypeScript properties of a `ModelExplainabilityAppSpecificationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelExplainabilityJobDefinition.ModelExplainabilityAppSpecification` resource.
 */
// @ts-ignore TS6133
function cfnModelExplainabilityJobDefinitionModelExplainabilityAppSpecificationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelExplainabilityJobDefinition_ModelExplainabilityAppSpecificationPropertyValidator(properties).assertSuccess();
    return {
        ConfigUri: cdk.stringToCloudFormation(properties.configUri),
        Environment: cdk.hashMapper(cdk.stringToCloudFormation)(properties.environment),
        ImageUri: cdk.stringToCloudFormation(properties.imageUri),
    };
}
// @ts-ignore TS6133
function CfnModelExplainabilityJobDefinitionModelExplainabilityAppSpecificationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('configUri', 'ConfigUri', cfn_parse.FromCloudFormation.getString(properties.ConfigUri));
    ret.addPropertyResult('environment', 'Environment', properties.Environment != null ? cfn_parse.FromCloudFormation.getMap(cfn_parse.FromCloudFormation.getString)(properties.Environment) : undefined);
    ret.addPropertyResult('imageUri', 'ImageUri', cfn_parse.FromCloudFormation.getString(properties.ImageUri));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ModelExplainabilityBaselineConfigProperty`
 *
 * @param properties - the TypeScript properties of a `ModelExplainabilityBaselineConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelExplainabilityJobDefinition_ModelExplainabilityBaselineConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('baseliningJobName', cdk.validateString)(properties.baseliningJobName));
    errors.collect(cdk.propertyValidator('constraintsResource', CfnModelExplainabilityJobDefinition_ConstraintsResourcePropertyValidator)(properties.constraintsResource));
    return errors.wrap('supplied properties not correct for "ModelExplainabilityBaselineConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelExplainabilityJobDefinition.ModelExplainabilityBaselineConfig` resource
 *
 * @param properties - the TypeScript properties of a `ModelExplainabilityBaselineConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelExplainabilityJobDefinition.ModelExplainabilityBaselineConfig` resource.
 */
// @ts-ignore TS6133
function cfnModelExplainabilityJobDefinitionModelExplainabilityBaselineConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelExplainabilityJobDefinition_ModelExplainabilityBaselineConfigPropertyValidator(properties).assertSuccess();
    return {
        BaseliningJobName: cdk.stringToCloudFormation(properties.baseliningJobName),
        ConstraintsResource: cfnModelExplainabilityJobDefinitionConstraintsResourcePropertyToCloudFormation(properties.constraintsResource),
    };
}
// @ts-ignore TS6133
function CfnModelExplainabilityJobDefinitionModelExplainabilityBaselineConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('baseliningJobName', 'BaseliningJobName', properties.BaseliningJobName != null ? cfn_parse.FromCloudFormation.getString(properties.BaseliningJobName) : undefined);
    ret.addPropertyResult('constraintsResource', 'ConstraintsResource', properties.ConstraintsResource != null ? CfnModelExplainabilityJobDefinitionConstraintsResourcePropertyFromCloudFormation(properties.ConstraintsResource) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ModelExplainabilityJobInputProperty`
 *
 * @param properties - the TypeScript properties of a `ModelExplainabilityJobInputProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelExplainabilityJobDefinition_ModelExplainabilityJobInputPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('batchTransformInput', CfnModelExplainabilityJobDefinition_BatchTransformInputPropertyValidator)(properties.batchTransformInput));
    errors.collect(cdk.propertyValidator('endpointInput', CfnModelExplainabilityJobDefinition_EndpointInputPropertyValidator)(properties.endpointInput));
    return errors.wrap('supplied properties not correct for "ModelExplainabilityJobInputProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelExplainabilityJobDefinition.ModelExplainabilityJobInput` resource
 *
 * @param properties - the TypeScript properties of a `ModelExplainabilityJobInputProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelExplainabilityJobDefinition.ModelExplainabilityJobInput` resource.
 */
// @ts-ignore TS6133
function cfnModelExplainabilityJobDefinitionModelExplainabilityJobInputPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelExplainabilityJobDefinition_ModelExplainabilityJobInputPropertyValidator(properties).assertSuccess();
    return {
        BatchTransformInput: cfnModelExplainabilityJobDefinitionBatchTransformInputPropertyToCloudFormation(properties.batchTransformInput),
        EndpointInput: cfnModelExplainabilityJobDefinitionEndpointInputPropertyToCloudFormation(properties.endpointInput),
    };
}
// @ts-ignore TS6133
function CfnModelExplainabilityJobDefinitionModelExplainabilityJobInputPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('batchTransformInput', 'BatchTransformInput', properties.BatchTransformInput != null ? CfnModelExplainabilityJobDefinitionBatchTransformInputPropertyFromCloudFormation(properties.BatchTransformInput) : undefined);
    ret.addPropertyResult('endpointInput', 'EndpointInput', properties.EndpointInput != null ? CfnModelExplainabilityJobDefinitionEndpointInputPropertyFromCloudFormation(properties.EndpointInput) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MonitoringOutputProperty`
 *
 * @param properties - the TypeScript properties of a `MonitoringOutputProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelExplainabilityJobDefinition_MonitoringOutputPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('s3Output', cdk.requiredValidator)(properties.s3Output));
    errors.collect(cdk.propertyValidator('s3Output', CfnModelExplainabilityJobDefinition_S3OutputPropertyValidator)(properties.s3Output));
    return errors.wrap('supplied properties not correct for "MonitoringOutputProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelExplainabilityJobDefinition.MonitoringOutput` resource
 *
 * @param properties - the TypeScript properties of a `MonitoringOutputProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelExplainabilityJobDefinition.MonitoringOutput` resource.
 */
// @ts-ignore TS6133
function cfnModelExplainabilityJobDefinitionMonitoringOutputPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelExplainabilityJobDefinition_MonitoringOutputPropertyValidator(properties).assertSuccess();
    return {
        S3Output: cfnModelExplainabilityJobDefinitionS3OutputPropertyToCloudFormation(properties.s3Output),
    };
}
// @ts-ignore TS6133
function CfnModelExplainabilityJobDefinitionMonitoringOutputPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('s3Output', 'S3Output', CfnModelExplainabilityJobDefinitionS3OutputPropertyFromCloudFormation(properties.S3Output));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MonitoringOutputConfigProperty`
 *
 * @param properties - the TypeScript properties of a `MonitoringOutputConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelExplainabilityJobDefinition_MonitoringOutputConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('kmsKeyId', cdk.validateString)(properties.kmsKeyId));
    errors.collect(cdk.propertyValidator('monitoringOutputs', cdk.requiredValidator)(properties.monitoringOutputs));
    errors.collect(cdk.propertyValidator('monitoringOutputs', cdk.listValidator(CfnModelExplainabilityJobDefinition_MonitoringOutputPropertyValidator))(properties.monitoringOutputs));
    return errors.wrap('supplied properties not correct for "MonitoringOutputConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelExplainabilityJobDefinition.MonitoringOutputConfig` resource
 *
 * @param properties - the TypeScript properties of a `MonitoringOutputConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelExplainabilityJobDefinition.MonitoringOutputConfig` resource.
 */
// @ts-ignore TS6133
function cfnModelExplainabilityJobDefinitionMonitoringOutputConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelExplainabilityJobDefinition_MonitoringOutputConfigPropertyValidator(properties).assertSuccess();
    return {
        KmsKeyId: cdk.stringToCloudFormation(properties.kmsKeyId),
        MonitoringOutputs: cdk.listMapper(cfnModelExplainabilityJobDefinitionMonitoringOutputPropertyToCloudFormation)(properties.monitoringOutputs),
    };
}
// @ts-ignore TS6133
function CfnModelExplainabilityJobDefinitionMonitoringOutputConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('kmsKeyId', 'KmsKeyId', properties.KmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.KmsKeyId) : undefined);
    ret.addPropertyResult('monitoringOutputs', 'MonitoringOutputs', cfn_parse.FromCloudFormation.getArray(CfnModelExplainabilityJobDefinitionMonitoringOutputPropertyFromCloudFormation)(properties.MonitoringOutputs));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MonitoringResourcesProperty`
 *
 * @param properties - the TypeScript properties of a `MonitoringResourcesProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelExplainabilityJobDefinition_MonitoringResourcesPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('clusterConfig', cdk.requiredValidator)(properties.clusterConfig));
    errors.collect(cdk.propertyValidator('clusterConfig', CfnModelExplainabilityJobDefinition_ClusterConfigPropertyValidator)(properties.clusterConfig));
    return errors.wrap('supplied properties not correct for "MonitoringResourcesProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelExplainabilityJobDefinition.MonitoringResources` resource
 *
 * @param properties - the TypeScript properties of a `MonitoringResourcesProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelExplainabilityJobDefinition.MonitoringResources` resource.
 */
// @ts-ignore TS6133
function cfnModelExplainabilityJobDefinitionMonitoringResourcesPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelExplainabilityJobDefinition_MonitoringResourcesPropertyValidator(properties).assertSuccess();
    return {
        ClusterConfig: cfnModelExplainabilityJobDefinitionClusterConfigPropertyToCloudFormation(properties.clusterConfig),
    };
}
// @ts-ignore TS6133
function CfnModelExplainabilityJobDefinitionMonitoringResourcesPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('clusterConfig', 'ClusterConfig', CfnModelExplainabilityJobDefinitionClusterConfigPropertyFromCloudFormation(properties.ClusterConfig));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `NetworkConfigProperty`
 *
 * @param properties - the TypeScript properties of a `NetworkConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelExplainabilityJobDefinition_NetworkConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('enableInterContainerTrafficEncryption', cdk.validateBoolean)(properties.enableInterContainerTrafficEncryption));
    errors.collect(cdk.propertyValidator('enableNetworkIsolation', cdk.validateBoolean)(properties.enableNetworkIsolation));
    errors.collect(cdk.propertyValidator('vpcConfig', CfnModelExplainabilityJobDefinition_VpcConfigPropertyValidator)(properties.vpcConfig));
    return errors.wrap('supplied properties not correct for "NetworkConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelExplainabilityJobDefinition.NetworkConfig` resource
 *
 * @param properties - the TypeScript properties of a `NetworkConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelExplainabilityJobDefinition.NetworkConfig` resource.
 */
// @ts-ignore TS6133
function cfnModelExplainabilityJobDefinitionNetworkConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelExplainabilityJobDefinition_NetworkConfigPropertyValidator(properties).assertSuccess();
    return {
        EnableInterContainerTrafficEncryption: cdk.booleanToCloudFormation(properties.enableInterContainerTrafficEncryption),
        EnableNetworkIsolation: cdk.booleanToCloudFormation(properties.enableNetworkIsolation),
        VpcConfig: cfnModelExplainabilityJobDefinitionVpcConfigPropertyToCloudFormation(properties.vpcConfig),
    };
}
// @ts-ignore TS6133
function CfnModelExplainabilityJobDefinitionNetworkConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('enableInterContainerTrafficEncryption', 'EnableInterContainerTrafficEncryption', properties.EnableInterContainerTrafficEncryption != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EnableInterContainerTrafficEncryption) : undefined);
    ret.addPropertyResult('enableNetworkIsolation', 'EnableNetworkIsolation', properties.EnableNetworkIsolation != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EnableNetworkIsolation) : undefined);
    ret.addPropertyResult('vpcConfig', 'VpcConfig', properties.VpcConfig != null ? CfnModelExplainabilityJobDefinitionVpcConfigPropertyFromCloudFormation(properties.VpcConfig) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `S3OutputProperty`
 *
 * @param properties - the TypeScript properties of a `S3OutputProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelExplainabilityJobDefinition_S3OutputPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('localPath', cdk.requiredValidator)(properties.localPath));
    errors.collect(cdk.propertyValidator('localPath', cdk.validateString)(properties.localPath));
    errors.collect(cdk.propertyValidator('s3UploadMode', cdk.validateString)(properties.s3UploadMode));
    errors.collect(cdk.propertyValidator('s3Uri', cdk.requiredValidator)(properties.s3Uri));
    errors.collect(cdk.propertyValidator('s3Uri', cdk.validateString)(properties.s3Uri));
    return errors.wrap('supplied properties not correct for "S3OutputProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelExplainabilityJobDefinition.S3Output` resource
 *
 * @param properties - the TypeScript properties of a `S3OutputProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelExplainabilityJobDefinition.S3Output` resource.
 */
// @ts-ignore TS6133
function cfnModelExplainabilityJobDefinitionS3OutputPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelExplainabilityJobDefinition_S3OutputPropertyValidator(properties).assertSuccess();
    return {
        LocalPath: cdk.stringToCloudFormation(properties.localPath),
        S3UploadMode: cdk.stringToCloudFormation(properties.s3UploadMode),
        S3Uri: cdk.stringToCloudFormation(properties.s3Uri),
    };
}
// @ts-ignore TS6133
function CfnModelExplainabilityJobDefinitionS3OutputPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('localPath', 'LocalPath', cfn_parse.FromCloudFormation.getString(properties.LocalPath));
    ret.addPropertyResult('s3UploadMode', 'S3UploadMode', properties.S3UploadMode != null ? cfn_parse.FromCloudFormation.getString(properties.S3UploadMode) : undefined);
    ret.addPropertyResult('s3Uri', 'S3Uri', cfn_parse.FromCloudFormation.getString(properties.S3Uri));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `StoppingConditionProperty`
 *
 * @param properties - the TypeScript properties of a `StoppingConditionProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelExplainabilityJobDefinition_StoppingConditionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('maxRuntimeInSeconds', cdk.requiredValidator)(properties.maxRuntimeInSeconds));
    errors.collect(cdk.propertyValidator('maxRuntimeInSeconds', cdk.validateNumber)(properties.maxRuntimeInSeconds));
    return errors.wrap('supplied properties not correct for "StoppingConditionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelExplainabilityJobDefinition.StoppingCondition` resource
 *
 * @param properties - the TypeScript properties of a `StoppingConditionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelExplainabilityJobDefinition.StoppingCondition` resource.
 */
// @ts-ignore TS6133
function cfnModelExplainabilityJobDefinitionStoppingConditionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelExplainabilityJobDefinition_StoppingConditionPropertyValidator(properties).assertSuccess();
    return {
        MaxRuntimeInSeconds: cdk.numberToCloudFormation(properties.maxRuntimeInSeconds),
    };
}
// @ts-ignore TS6133
function CfnModelExplainabilityJobDefinitionStoppingConditionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('maxRuntimeInSeconds', 'MaxRuntimeInSeconds', cfn_parse.FromCloudFormation.getNumber(properties.MaxRuntimeInSeconds));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `VpcConfigProperty`
 *
 * @param properties - the TypeScript properties of a `VpcConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelExplainabilityJobDefinition_VpcConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('securityGroupIds', cdk.requiredValidator)(properties.securityGroupIds));
    errors.collect(cdk.propertyValidator('securityGroupIds', cdk.listValidator(cdk.validateString))(properties.securityGroupIds));
    errors.collect(cdk.propertyValidator('subnets', cdk.requiredValidator)(properties.subnets));
    errors.collect(cdk.propertyValidator('subnets', cdk.listValidator(cdk.validateString))(properties.subnets));
    return errors.wrap('supplied properties not correct for "VpcConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelExplainabilityJobDefinition.VpcConfig` resource
 *
 * @param properties - the TypeScript properties of a `VpcConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelExplainabilityJobDefinition.VpcConfig` resource.
 */
// @ts-ignore TS6133
function cfnModelExplainabilityJobDefinitionVpcConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelExplainabilityJobDefinition_VpcConfigPropertyValidator(properties).assertSuccess();
    return {
        SecurityGroupIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.securityGroupIds),
        Subnets: cdk.listMapper(cdk.stringToCloudFormation)(properties.subnets),
    };
}
// @ts-ignore TS6133
function CfnModelExplainabilityJobDefinitionVpcConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('securityGroupIds', 'SecurityGroupIds', cfn_parse.FromCloudFormation.getStringArray(properties.SecurityGroupIds));
    ret.addPropertyResult('subnets', 'Subnets', cfn_parse.FromCloudFormation.getStringArray(properties.Subnets));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnModelPackageProps`
 *
 * @param properties - the TypeScript properties of a `CfnModelPackageProps`
 *
 * @returns the result of the validation.
 */
function CfnModelPackagePropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('additionalInferenceSpecificationDefinition', CfnModelPackage_AdditionalInferenceSpecificationDefinitionPropertyValidator)(properties.additionalInferenceSpecificationDefinition));
    errors.collect(cdk.propertyValidator('additionalInferenceSpecifications', cdk.listValidator(CfnModelPackage_AdditionalInferenceSpecificationDefinitionPropertyValidator))(properties.additionalInferenceSpecifications));
    errors.collect(cdk.propertyValidator('additionalInferenceSpecificationsToAdd', cdk.listValidator(CfnModelPackage_AdditionalInferenceSpecificationDefinitionPropertyValidator))(properties.additionalInferenceSpecificationsToAdd));
    errors.collect(cdk.propertyValidator('approvalDescription', cdk.validateString)(properties.approvalDescription));
    errors.collect(cdk.propertyValidator('certifyForMarketplace', cdk.validateBoolean)(properties.certifyForMarketplace));
    errors.collect(cdk.propertyValidator('clientToken', cdk.validateString)(properties.clientToken));
    errors.collect(cdk.propertyValidator('createdBy', CfnModelPackage_UserContextPropertyValidator)(properties.createdBy));
    errors.collect(cdk.propertyValidator('customerMetadataProperties', cdk.hashValidator(cdk.validateString))(properties.customerMetadataProperties));
    errors.collect(cdk.propertyValidator('domain', cdk.validateString)(properties.domain));
    errors.collect(cdk.propertyValidator('driftCheckBaselines', CfnModelPackage_DriftCheckBaselinesPropertyValidator)(properties.driftCheckBaselines));
    errors.collect(cdk.propertyValidator('environment', cdk.hashValidator(cdk.validateString))(properties.environment));
    errors.collect(cdk.propertyValidator('inferenceSpecification', CfnModelPackage_InferenceSpecificationPropertyValidator)(properties.inferenceSpecification));
    errors.collect(cdk.propertyValidator('lastModifiedBy', CfnModelPackage_UserContextPropertyValidator)(properties.lastModifiedBy));
    errors.collect(cdk.propertyValidator('lastModifiedTime', cdk.validateString)(properties.lastModifiedTime));
    errors.collect(cdk.propertyValidator('metadataProperties', CfnModelPackage_MetadataPropertiesPropertyValidator)(properties.metadataProperties));
    errors.collect(cdk.propertyValidator('modelApprovalStatus', cdk.validateString)(properties.modelApprovalStatus));
    errors.collect(cdk.propertyValidator('modelMetrics', CfnModelPackage_ModelMetricsPropertyValidator)(properties.modelMetrics));
    errors.collect(cdk.propertyValidator('modelPackageDescription', cdk.validateString)(properties.modelPackageDescription));
    errors.collect(cdk.propertyValidator('modelPackageGroupName', cdk.validateString)(properties.modelPackageGroupName));
    errors.collect(cdk.propertyValidator('modelPackageName', cdk.validateString)(properties.modelPackageName));
    errors.collect(cdk.propertyValidator('modelPackageStatusDetails', CfnModelPackage_ModelPackageStatusDetailsPropertyValidator)(properties.modelPackageStatusDetails));
    errors.collect(cdk.propertyValidator('modelPackageStatusItem', CfnModelPackage_ModelPackageStatusItemPropertyValidator)(properties.modelPackageStatusItem));
    errors.collect(cdk.propertyValidator('modelPackageVersion', cdk.validateNumber)(properties.modelPackageVersion));
    errors.collect(cdk.propertyValidator('samplePayloadUrl', cdk.validateString)(properties.samplePayloadUrl));
    errors.collect(cdk.propertyValidator('sourceAlgorithmSpecification', CfnModelPackage_SourceAlgorithmSpecificationPropertyValidator)(properties.sourceAlgorithmSpecification));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('task', cdk.validateString)(properties.task));
    errors.collect(cdk.propertyValidator('validationSpecification', CfnModelPackage_ValidationSpecificationPropertyValidator)(properties.validationSpecification));
    return errors.wrap('supplied properties not correct for "CfnModelPackageProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage` resource
 *
 * @param properties - the TypeScript properties of a `CfnModelPackageProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage` resource.
 */
// @ts-ignore TS6133
function cfnModelPackagePropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelPackagePropsValidator(properties).assertSuccess();
    return {
        AdditionalInferenceSpecificationDefinition: cfnModelPackageAdditionalInferenceSpecificationDefinitionPropertyToCloudFormation(properties.additionalInferenceSpecificationDefinition),
        AdditionalInferenceSpecifications: cdk.listMapper(cfnModelPackageAdditionalInferenceSpecificationDefinitionPropertyToCloudFormation)(properties.additionalInferenceSpecifications),
        AdditionalInferenceSpecificationsToAdd: cdk.listMapper(cfnModelPackageAdditionalInferenceSpecificationDefinitionPropertyToCloudFormation)(properties.additionalInferenceSpecificationsToAdd),
        ApprovalDescription: cdk.stringToCloudFormation(properties.approvalDescription),
        CertifyForMarketplace: cdk.booleanToCloudFormation(properties.certifyForMarketplace),
        ClientToken: cdk.stringToCloudFormation(properties.clientToken),
        CreatedBy: cfnModelPackageUserContextPropertyToCloudFormation(properties.createdBy),
        CustomerMetadataProperties: cdk.hashMapper(cdk.stringToCloudFormation)(properties.customerMetadataProperties),
        Domain: cdk.stringToCloudFormation(properties.domain),
        DriftCheckBaselines: cfnModelPackageDriftCheckBaselinesPropertyToCloudFormation(properties.driftCheckBaselines),
        Environment: cdk.hashMapper(cdk.stringToCloudFormation)(properties.environment),
        InferenceSpecification: cfnModelPackageInferenceSpecificationPropertyToCloudFormation(properties.inferenceSpecification),
        LastModifiedBy: cfnModelPackageUserContextPropertyToCloudFormation(properties.lastModifiedBy),
        LastModifiedTime: cdk.stringToCloudFormation(properties.lastModifiedTime),
        MetadataProperties: cfnModelPackageMetadataPropertiesPropertyToCloudFormation(properties.metadataProperties),
        ModelApprovalStatus: cdk.stringToCloudFormation(properties.modelApprovalStatus),
        ModelMetrics: cfnModelPackageModelMetricsPropertyToCloudFormation(properties.modelMetrics),
        ModelPackageDescription: cdk.stringToCloudFormation(properties.modelPackageDescription),
        ModelPackageGroupName: cdk.stringToCloudFormation(properties.modelPackageGroupName),
        ModelPackageName: cdk.stringToCloudFormation(properties.modelPackageName),
        ModelPackageStatusDetails: cfnModelPackageModelPackageStatusDetailsPropertyToCloudFormation(properties.modelPackageStatusDetails),
        ModelPackageStatusItem: cfnModelPackageModelPackageStatusItemPropertyToCloudFormation(properties.modelPackageStatusItem),
        ModelPackageVersion: cdk.numberToCloudFormation(properties.modelPackageVersion),
        SamplePayloadUrl: cdk.stringToCloudFormation(properties.samplePayloadUrl),
        SourceAlgorithmSpecification: cfnModelPackageSourceAlgorithmSpecificationPropertyToCloudFormation(properties.sourceAlgorithmSpecification),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
        Task: cdk.stringToCloudFormation(properties.task),
        ValidationSpecification: cfnModelPackageValidationSpecificationPropertyToCloudFormation(properties.validationSpecification),
    };
}
// @ts-ignore TS6133
function CfnModelPackagePropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('additionalInferenceSpecificationDefinition', 'AdditionalInferenceSpecificationDefinition', properties.AdditionalInferenceSpecificationDefinition != null ? CfnModelPackageAdditionalInferenceSpecificationDefinitionPropertyFromCloudFormation(properties.AdditionalInferenceSpecificationDefinition) : undefined);
    ret.addPropertyResult('additionalInferenceSpecifications', 'AdditionalInferenceSpecifications', properties.AdditionalInferenceSpecifications != null ? cfn_parse.FromCloudFormation.getArray(CfnModelPackageAdditionalInferenceSpecificationDefinitionPropertyFromCloudFormation)(properties.AdditionalInferenceSpecifications) : undefined);
    ret.addPropertyResult('additionalInferenceSpecificationsToAdd', 'AdditionalInferenceSpecificationsToAdd', properties.AdditionalInferenceSpecificationsToAdd != null ? cfn_parse.FromCloudFormation.getArray(CfnModelPackageAdditionalInferenceSpecificationDefinitionPropertyFromCloudFormation)(properties.AdditionalInferenceSpecificationsToAdd) : undefined);
    ret.addPropertyResult('approvalDescription', 'ApprovalDescription', properties.ApprovalDescription != null ? cfn_parse.FromCloudFormation.getString(properties.ApprovalDescription) : undefined);
    ret.addPropertyResult('certifyForMarketplace', 'CertifyForMarketplace', properties.CertifyForMarketplace != null ? cfn_parse.FromCloudFormation.getBoolean(properties.CertifyForMarketplace) : undefined);
    ret.addPropertyResult('clientToken', 'ClientToken', properties.ClientToken != null ? cfn_parse.FromCloudFormation.getString(properties.ClientToken) : undefined);
    ret.addPropertyResult('createdBy', 'CreatedBy', properties.CreatedBy != null ? CfnModelPackageUserContextPropertyFromCloudFormation(properties.CreatedBy) : undefined);
    ret.addPropertyResult('customerMetadataProperties', 'CustomerMetadataProperties', properties.CustomerMetadataProperties != null ? cfn_parse.FromCloudFormation.getMap(cfn_parse.FromCloudFormation.getString)(properties.CustomerMetadataProperties) : undefined);
    ret.addPropertyResult('domain', 'Domain', properties.Domain != null ? cfn_parse.FromCloudFormation.getString(properties.Domain) : undefined);
    ret.addPropertyResult('driftCheckBaselines', 'DriftCheckBaselines', properties.DriftCheckBaselines != null ? CfnModelPackageDriftCheckBaselinesPropertyFromCloudFormation(properties.DriftCheckBaselines) : undefined);
    ret.addPropertyResult('environment', 'Environment', properties.Environment != null ? cfn_parse.FromCloudFormation.getMap(cfn_parse.FromCloudFormation.getString)(properties.Environment) : undefined);
    ret.addPropertyResult('inferenceSpecification', 'InferenceSpecification', properties.InferenceSpecification != null ? CfnModelPackageInferenceSpecificationPropertyFromCloudFormation(properties.InferenceSpecification) : undefined);
    ret.addPropertyResult('lastModifiedBy', 'LastModifiedBy', properties.LastModifiedBy != null ? CfnModelPackageUserContextPropertyFromCloudFormation(properties.LastModifiedBy) : undefined);
    ret.addPropertyResult('lastModifiedTime', 'LastModifiedTime', properties.LastModifiedTime != null ? cfn_parse.FromCloudFormation.getString(properties.LastModifiedTime) : undefined);
    ret.addPropertyResult('metadataProperties', 'MetadataProperties', properties.MetadataProperties != null ? CfnModelPackageMetadataPropertiesPropertyFromCloudFormation(properties.MetadataProperties) : undefined);
    ret.addPropertyResult('modelApprovalStatus', 'ModelApprovalStatus', properties.ModelApprovalStatus != null ? cfn_parse.FromCloudFormation.getString(properties.ModelApprovalStatus) : undefined);
    ret.addPropertyResult('modelMetrics', 'ModelMetrics', properties.ModelMetrics != null ? CfnModelPackageModelMetricsPropertyFromCloudFormation(properties.ModelMetrics) : undefined);
    ret.addPropertyResult('modelPackageDescription', 'ModelPackageDescription', properties.ModelPackageDescription != null ? cfn_parse.FromCloudFormation.getString(properties.ModelPackageDescription) : undefined);
    ret.addPropertyResult('modelPackageGroupName', 'ModelPackageGroupName', properties.ModelPackageGroupName != null ? cfn_parse.FromCloudFormation.getString(properties.ModelPackageGroupName) : undefined);
    ret.addPropertyResult('modelPackageName', 'ModelPackageName', properties.ModelPackageName != null ? cfn_parse.FromCloudFormation.getString(properties.ModelPackageName) : undefined);
    ret.addPropertyResult('modelPackageStatusDetails', 'ModelPackageStatusDetails', properties.ModelPackageStatusDetails != null ? CfnModelPackageModelPackageStatusDetailsPropertyFromCloudFormation(properties.ModelPackageStatusDetails) : undefined);
    ret.addPropertyResult('modelPackageStatusItem', 'ModelPackageStatusItem', properties.ModelPackageStatusItem != null ? CfnModelPackageModelPackageStatusItemPropertyFromCloudFormation(properties.ModelPackageStatusItem) : undefined);
    ret.addPropertyResult('modelPackageVersion', 'ModelPackageVersion', properties.ModelPackageVersion != null ? cfn_parse.FromCloudFormation.getNumber(properties.ModelPackageVersion) : undefined);
    ret.addPropertyResult('samplePayloadUrl', 'SamplePayloadUrl', properties.SamplePayloadUrl != null ? cfn_parse.FromCloudFormation.getString(properties.SamplePayloadUrl) : undefined);
    ret.addPropertyResult('sourceAlgorithmSpecification', 'SourceAlgorithmSpecification', properties.SourceAlgorithmSpecification != null ? CfnModelPackageSourceAlgorithmSpecificationPropertyFromCloudFormation(properties.SourceAlgorithmSpecification) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addPropertyResult('task', 'Task', properties.Task != null ? cfn_parse.FromCloudFormation.getString(properties.Task) : undefined);
    ret.addPropertyResult('validationSpecification', 'ValidationSpecification', properties.ValidationSpecification != null ? CfnModelPackageValidationSpecificationPropertyFromCloudFormation(properties.ValidationSpecification) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::SageMaker::ModelPackage`
 *
 * A versioned model that can be deployed for SageMaker inference.
 *
 * @cloudformationResource AWS::SageMaker::ModelPackage
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html
 */
class CfnModelPackage extends cdk.CfnResource {
    /**
     * Create a new `AWS::SageMaker::ModelPackage`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}) {
        super(scope, id, { type: CfnModelPackage.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_sagemaker_CfnModelPackageProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnModelPackage);
            }
            throw error;
        }
        this.attrCreationTime = cdk.Token.asString(this.getAtt('CreationTime'));
        this.attrModelPackageArn = cdk.Token.asString(this.getAtt('ModelPackageArn'));
        this.attrModelPackageStatus = cdk.Token.asString(this.getAtt('ModelPackageStatus'));
        this.additionalInferenceSpecificationDefinition = props.additionalInferenceSpecificationDefinition;
        this.additionalInferenceSpecifications = props.additionalInferenceSpecifications;
        this.additionalInferenceSpecificationsToAdd = props.additionalInferenceSpecificationsToAdd;
        this.approvalDescription = props.approvalDescription;
        this.certifyForMarketplace = props.certifyForMarketplace;
        this.clientToken = props.clientToken;
        this.createdBy = props.createdBy;
        this.customerMetadataProperties = props.customerMetadataProperties;
        this.domain = props.domain;
        this.driftCheckBaselines = props.driftCheckBaselines;
        this.environment = props.environment;
        this.inferenceSpecification = props.inferenceSpecification;
        this.lastModifiedBy = props.lastModifiedBy;
        this.lastModifiedTime = props.lastModifiedTime;
        this.metadataProperties = props.metadataProperties;
        this.modelApprovalStatus = props.modelApprovalStatus;
        this.modelMetrics = props.modelMetrics;
        this.modelPackageDescription = props.modelPackageDescription;
        this.modelPackageGroupName = props.modelPackageGroupName;
        this.modelPackageName = props.modelPackageName;
        this.modelPackageStatusDetails = props.modelPackageStatusDetails;
        this.modelPackageStatusItem = props.modelPackageStatusItem;
        this.modelPackageVersion = props.modelPackageVersion;
        this.samplePayloadUrl = props.samplePayloadUrl;
        this.sourceAlgorithmSpecification = props.sourceAlgorithmSpecification;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::SageMaker::ModelPackage", props.tags, { tagPropertyName: 'tags' });
        this.task = props.task;
        this.validationSpecification = props.validationSpecification;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnModelPackagePropsFromCloudFormation(resourceProperties);
        const ret = new CfnModelPackage(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnModelPackage.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            additionalInferenceSpecificationDefinition: this.additionalInferenceSpecificationDefinition,
            additionalInferenceSpecifications: this.additionalInferenceSpecifications,
            additionalInferenceSpecificationsToAdd: this.additionalInferenceSpecificationsToAdd,
            approvalDescription: this.approvalDescription,
            certifyForMarketplace: this.certifyForMarketplace,
            clientToken: this.clientToken,
            createdBy: this.createdBy,
            customerMetadataProperties: this.customerMetadataProperties,
            domain: this.domain,
            driftCheckBaselines: this.driftCheckBaselines,
            environment: this.environment,
            inferenceSpecification: this.inferenceSpecification,
            lastModifiedBy: this.lastModifiedBy,
            lastModifiedTime: this.lastModifiedTime,
            metadataProperties: this.metadataProperties,
            modelApprovalStatus: this.modelApprovalStatus,
            modelMetrics: this.modelMetrics,
            modelPackageDescription: this.modelPackageDescription,
            modelPackageGroupName: this.modelPackageGroupName,
            modelPackageName: this.modelPackageName,
            modelPackageStatusDetails: this.modelPackageStatusDetails,
            modelPackageStatusItem: this.modelPackageStatusItem,
            modelPackageVersion: this.modelPackageVersion,
            samplePayloadUrl: this.samplePayloadUrl,
            sourceAlgorithmSpecification: this.sourceAlgorithmSpecification,
            tags: this.tags.renderTags(),
            task: this.task,
            validationSpecification: this.validationSpecification,
        };
    }
    renderProperties(props) {
        return cfnModelPackagePropsToCloudFormation(props);
    }
}
exports.CfnModelPackage = CfnModelPackage;
_r = JSII_RTTI_SYMBOL_1;
CfnModelPackage[_r] = { fqn: "@aws-cdk/aws-sagemaker.CfnModelPackage", version: "1.186.1" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnModelPackage.CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::ModelPackage";
/**
 * Determine whether the given properties match those of a `AdditionalInferenceSpecificationDefinitionProperty`
 *
 * @param properties - the TypeScript properties of a `AdditionalInferenceSpecificationDefinitionProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelPackage_AdditionalInferenceSpecificationDefinitionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('containers', cdk.requiredValidator)(properties.containers));
    errors.collect(cdk.propertyValidator('containers', cdk.listValidator(CfnModelPackage_ModelPackageContainerDefinitionPropertyValidator))(properties.containers));
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('supportedContentTypes', cdk.listValidator(cdk.validateString))(properties.supportedContentTypes));
    errors.collect(cdk.propertyValidator('supportedRealtimeInferenceInstanceTypes', cdk.listValidator(cdk.validateString))(properties.supportedRealtimeInferenceInstanceTypes));
    errors.collect(cdk.propertyValidator('supportedResponseMimeTypes', cdk.listValidator(cdk.validateString))(properties.supportedResponseMimeTypes));
    errors.collect(cdk.propertyValidator('supportedTransformInstanceTypes', cdk.listValidator(cdk.validateString))(properties.supportedTransformInstanceTypes));
    return errors.wrap('supplied properties not correct for "AdditionalInferenceSpecificationDefinitionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.AdditionalInferenceSpecificationDefinition` resource
 *
 * @param properties - the TypeScript properties of a `AdditionalInferenceSpecificationDefinitionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.AdditionalInferenceSpecificationDefinition` resource.
 */
// @ts-ignore TS6133
function cfnModelPackageAdditionalInferenceSpecificationDefinitionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelPackage_AdditionalInferenceSpecificationDefinitionPropertyValidator(properties).assertSuccess();
    return {
        Containers: cdk.listMapper(cfnModelPackageModelPackageContainerDefinitionPropertyToCloudFormation)(properties.containers),
        Description: cdk.stringToCloudFormation(properties.description),
        Name: cdk.stringToCloudFormation(properties.name),
        SupportedContentTypes: cdk.listMapper(cdk.stringToCloudFormation)(properties.supportedContentTypes),
        SupportedRealtimeInferenceInstanceTypes: cdk.listMapper(cdk.stringToCloudFormation)(properties.supportedRealtimeInferenceInstanceTypes),
        SupportedResponseMIMETypes: cdk.listMapper(cdk.stringToCloudFormation)(properties.supportedResponseMimeTypes),
        SupportedTransformInstanceTypes: cdk.listMapper(cdk.stringToCloudFormation)(properties.supportedTransformInstanceTypes),
    };
}
// @ts-ignore TS6133
function CfnModelPackageAdditionalInferenceSpecificationDefinitionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('containers', 'Containers', cfn_parse.FromCloudFormation.getArray(CfnModelPackageModelPackageContainerDefinitionPropertyFromCloudFormation)(properties.Containers));
    ret.addPropertyResult('description', 'Description', properties.Description != null ? cfn_parse.FromCloudFormation.getString(properties.Description) : undefined);
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('supportedContentTypes', 'SupportedContentTypes', properties.SupportedContentTypes != null ? cfn_parse.FromCloudFormation.getStringArray(properties.SupportedContentTypes) : undefined);
    ret.addPropertyResult('supportedRealtimeInferenceInstanceTypes', 'SupportedRealtimeInferenceInstanceTypes', properties.SupportedRealtimeInferenceInstanceTypes != null ? cfn_parse.FromCloudFormation.getStringArray(properties.SupportedRealtimeInferenceInstanceTypes) : undefined);
    ret.addPropertyResult('supportedResponseMimeTypes', 'SupportedResponseMIMETypes', properties.SupportedResponseMIMETypes != null ? cfn_parse.FromCloudFormation.getStringArray(properties.SupportedResponseMIMETypes) : undefined);
    ret.addPropertyResult('supportedTransformInstanceTypes', 'SupportedTransformInstanceTypes', properties.SupportedTransformInstanceTypes != null ? cfn_parse.FromCloudFormation.getStringArray(properties.SupportedTransformInstanceTypes) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `BiasProperty`
 *
 * @param properties - the TypeScript properties of a `BiasProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelPackage_BiasPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('postTrainingReport', CfnModelPackage_MetricsSourcePropertyValidator)(properties.postTrainingReport));
    errors.collect(cdk.propertyValidator('preTrainingReport', CfnModelPackage_MetricsSourcePropertyValidator)(properties.preTrainingReport));
    errors.collect(cdk.propertyValidator('report', CfnModelPackage_MetricsSourcePropertyValidator)(properties.report));
    return errors.wrap('supplied properties not correct for "BiasProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.Bias` resource
 *
 * @param properties - the TypeScript properties of a `BiasProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.Bias` resource.
 */
// @ts-ignore TS6133
function cfnModelPackageBiasPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelPackage_BiasPropertyValidator(properties).assertSuccess();
    return {
        PostTrainingReport: cfnModelPackageMetricsSourcePropertyToCloudFormation(properties.postTrainingReport),
        PreTrainingReport: cfnModelPackageMetricsSourcePropertyToCloudFormation(properties.preTrainingReport),
        Report: cfnModelPackageMetricsSourcePropertyToCloudFormation(properties.report),
    };
}
// @ts-ignore TS6133
function CfnModelPackageBiasPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('postTrainingReport', 'PostTrainingReport', properties.PostTrainingReport != null ? CfnModelPackageMetricsSourcePropertyFromCloudFormation(properties.PostTrainingReport) : undefined);
    ret.addPropertyResult('preTrainingReport', 'PreTrainingReport', properties.PreTrainingReport != null ? CfnModelPackageMetricsSourcePropertyFromCloudFormation(properties.PreTrainingReport) : undefined);
    ret.addPropertyResult('report', 'Report', properties.Report != null ? CfnModelPackageMetricsSourcePropertyFromCloudFormation(properties.Report) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DataSourceProperty`
 *
 * @param properties - the TypeScript properties of a `DataSourceProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelPackage_DataSourcePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('s3DataSource', cdk.requiredValidator)(properties.s3DataSource));
    errors.collect(cdk.propertyValidator('s3DataSource', CfnModelPackage_S3DataSourcePropertyValidator)(properties.s3DataSource));
    return errors.wrap('supplied properties not correct for "DataSourceProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.DataSource` resource
 *
 * @param properties - the TypeScript properties of a `DataSourceProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.DataSource` resource.
 */
// @ts-ignore TS6133
function cfnModelPackageDataSourcePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelPackage_DataSourcePropertyValidator(properties).assertSuccess();
    return {
        S3DataSource: cfnModelPackageS3DataSourcePropertyToCloudFormation(properties.s3DataSource),
    };
}
// @ts-ignore TS6133
function CfnModelPackageDataSourcePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('s3DataSource', 'S3DataSource', CfnModelPackageS3DataSourcePropertyFromCloudFormation(properties.S3DataSource));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DriftCheckBaselinesProperty`
 *
 * @param properties - the TypeScript properties of a `DriftCheckBaselinesProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelPackage_DriftCheckBaselinesPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('bias', CfnModelPackage_DriftCheckBiasPropertyValidator)(properties.bias));
    errors.collect(cdk.propertyValidator('explainability', CfnModelPackage_DriftCheckExplainabilityPropertyValidator)(properties.explainability));
    errors.collect(cdk.propertyValidator('modelDataQuality', CfnModelPackage_DriftCheckModelDataQualityPropertyValidator)(properties.modelDataQuality));
    errors.collect(cdk.propertyValidator('modelQuality', CfnModelPackage_DriftCheckModelQualityPropertyValidator)(properties.modelQuality));
    return errors.wrap('supplied properties not correct for "DriftCheckBaselinesProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.DriftCheckBaselines` resource
 *
 * @param properties - the TypeScript properties of a `DriftCheckBaselinesProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.DriftCheckBaselines` resource.
 */
// @ts-ignore TS6133
function cfnModelPackageDriftCheckBaselinesPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelPackage_DriftCheckBaselinesPropertyValidator(properties).assertSuccess();
    return {
        Bias: cfnModelPackageDriftCheckBiasPropertyToCloudFormation(properties.bias),
        Explainability: cfnModelPackageDriftCheckExplainabilityPropertyToCloudFormation(properties.explainability),
        ModelDataQuality: cfnModelPackageDriftCheckModelDataQualityPropertyToCloudFormation(properties.modelDataQuality),
        ModelQuality: cfnModelPackageDriftCheckModelQualityPropertyToCloudFormation(properties.modelQuality),
    };
}
// @ts-ignore TS6133
function CfnModelPackageDriftCheckBaselinesPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('bias', 'Bias', properties.Bias != null ? CfnModelPackageDriftCheckBiasPropertyFromCloudFormation(properties.Bias) : undefined);
    ret.addPropertyResult('explainability', 'Explainability', properties.Explainability != null ? CfnModelPackageDriftCheckExplainabilityPropertyFromCloudFormation(properties.Explainability) : undefined);
    ret.addPropertyResult('modelDataQuality', 'ModelDataQuality', properties.ModelDataQuality != null ? CfnModelPackageDriftCheckModelDataQualityPropertyFromCloudFormation(properties.ModelDataQuality) : undefined);
    ret.addPropertyResult('modelQuality', 'ModelQuality', properties.ModelQuality != null ? CfnModelPackageDriftCheckModelQualityPropertyFromCloudFormation(properties.ModelQuality) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DriftCheckBiasProperty`
 *
 * @param properties - the TypeScript properties of a `DriftCheckBiasProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelPackage_DriftCheckBiasPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('configFile', CfnModelPackage_FileSourcePropertyValidator)(properties.configFile));
    errors.collect(cdk.propertyValidator('postTrainingConstraints', CfnModelPackage_MetricsSourcePropertyValidator)(properties.postTrainingConstraints));
    errors.collect(cdk.propertyValidator('preTrainingConstraints', CfnModelPackage_MetricsSourcePropertyValidator)(properties.preTrainingConstraints));
    return errors.wrap('supplied properties not correct for "DriftCheckBiasProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.DriftCheckBias` resource
 *
 * @param properties - the TypeScript properties of a `DriftCheckBiasProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.DriftCheckBias` resource.
 */
// @ts-ignore TS6133
function cfnModelPackageDriftCheckBiasPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelPackage_DriftCheckBiasPropertyValidator(properties).assertSuccess();
    return {
        ConfigFile: cfnModelPackageFileSourcePropertyToCloudFormation(properties.configFile),
        PostTrainingConstraints: cfnModelPackageMetricsSourcePropertyToCloudFormation(properties.postTrainingConstraints),
        PreTrainingConstraints: cfnModelPackageMetricsSourcePropertyToCloudFormation(properties.preTrainingConstraints),
    };
}
// @ts-ignore TS6133
function CfnModelPackageDriftCheckBiasPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('configFile', 'ConfigFile', properties.ConfigFile != null ? CfnModelPackageFileSourcePropertyFromCloudFormation(properties.ConfigFile) : undefined);
    ret.addPropertyResult('postTrainingConstraints', 'PostTrainingConstraints', properties.PostTrainingConstraints != null ? CfnModelPackageMetricsSourcePropertyFromCloudFormation(properties.PostTrainingConstraints) : undefined);
    ret.addPropertyResult('preTrainingConstraints', 'PreTrainingConstraints', properties.PreTrainingConstraints != null ? CfnModelPackageMetricsSourcePropertyFromCloudFormation(properties.PreTrainingConstraints) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DriftCheckExplainabilityProperty`
 *
 * @param properties - the TypeScript properties of a `DriftCheckExplainabilityProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelPackage_DriftCheckExplainabilityPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('configFile', CfnModelPackage_FileSourcePropertyValidator)(properties.configFile));
    errors.collect(cdk.propertyValidator('constraints', CfnModelPackage_MetricsSourcePropertyValidator)(properties.constraints));
    return errors.wrap('supplied properties not correct for "DriftCheckExplainabilityProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.DriftCheckExplainability` resource
 *
 * @param properties - the TypeScript properties of a `DriftCheckExplainabilityProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.DriftCheckExplainability` resource.
 */
// @ts-ignore TS6133
function cfnModelPackageDriftCheckExplainabilityPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelPackage_DriftCheckExplainabilityPropertyValidator(properties).assertSuccess();
    return {
        ConfigFile: cfnModelPackageFileSourcePropertyToCloudFormation(properties.configFile),
        Constraints: cfnModelPackageMetricsSourcePropertyToCloudFormation(properties.constraints),
    };
}
// @ts-ignore TS6133
function CfnModelPackageDriftCheckExplainabilityPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('configFile', 'ConfigFile', properties.ConfigFile != null ? CfnModelPackageFileSourcePropertyFromCloudFormation(properties.ConfigFile) : undefined);
    ret.addPropertyResult('constraints', 'Constraints', properties.Constraints != null ? CfnModelPackageMetricsSourcePropertyFromCloudFormation(properties.Constraints) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DriftCheckModelDataQualityProperty`
 *
 * @param properties - the TypeScript properties of a `DriftCheckModelDataQualityProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelPackage_DriftCheckModelDataQualityPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('constraints', CfnModelPackage_MetricsSourcePropertyValidator)(properties.constraints));
    errors.collect(cdk.propertyValidator('statistics', CfnModelPackage_MetricsSourcePropertyValidator)(properties.statistics));
    return errors.wrap('supplied properties not correct for "DriftCheckModelDataQualityProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.DriftCheckModelDataQuality` resource
 *
 * @param properties - the TypeScript properties of a `DriftCheckModelDataQualityProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.DriftCheckModelDataQuality` resource.
 */
// @ts-ignore TS6133
function cfnModelPackageDriftCheckModelDataQualityPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelPackage_DriftCheckModelDataQualityPropertyValidator(properties).assertSuccess();
    return {
        Constraints: cfnModelPackageMetricsSourcePropertyToCloudFormation(properties.constraints),
        Statistics: cfnModelPackageMetricsSourcePropertyToCloudFormation(properties.statistics),
    };
}
// @ts-ignore TS6133
function CfnModelPackageDriftCheckModelDataQualityPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('constraints', 'Constraints', properties.Constraints != null ? CfnModelPackageMetricsSourcePropertyFromCloudFormation(properties.Constraints) : undefined);
    ret.addPropertyResult('statistics', 'Statistics', properties.Statistics != null ? CfnModelPackageMetricsSourcePropertyFromCloudFormation(properties.Statistics) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DriftCheckModelQualityProperty`
 *
 * @param properties - the TypeScript properties of a `DriftCheckModelQualityProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelPackage_DriftCheckModelQualityPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('constraints', CfnModelPackage_MetricsSourcePropertyValidator)(properties.constraints));
    errors.collect(cdk.propertyValidator('statistics', CfnModelPackage_MetricsSourcePropertyValidator)(properties.statistics));
    return errors.wrap('supplied properties not correct for "DriftCheckModelQualityProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.DriftCheckModelQuality` resource
 *
 * @param properties - the TypeScript properties of a `DriftCheckModelQualityProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.DriftCheckModelQuality` resource.
 */
// @ts-ignore TS6133
function cfnModelPackageDriftCheckModelQualityPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelPackage_DriftCheckModelQualityPropertyValidator(properties).assertSuccess();
    return {
        Constraints: cfnModelPackageMetricsSourcePropertyToCloudFormation(properties.constraints),
        Statistics: cfnModelPackageMetricsSourcePropertyToCloudFormation(properties.statistics),
    };
}
// @ts-ignore TS6133
function CfnModelPackageDriftCheckModelQualityPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('constraints', 'Constraints', properties.Constraints != null ? CfnModelPackageMetricsSourcePropertyFromCloudFormation(properties.Constraints) : undefined);
    ret.addPropertyResult('statistics', 'Statistics', properties.Statistics != null ? CfnModelPackageMetricsSourcePropertyFromCloudFormation(properties.Statistics) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ExplainabilityProperty`
 *
 * @param properties - the TypeScript properties of a `ExplainabilityProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelPackage_ExplainabilityPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('report', CfnModelPackage_MetricsSourcePropertyValidator)(properties.report));
    return errors.wrap('supplied properties not correct for "ExplainabilityProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.Explainability` resource
 *
 * @param properties - the TypeScript properties of a `ExplainabilityProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.Explainability` resource.
 */
// @ts-ignore TS6133
function cfnModelPackageExplainabilityPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelPackage_ExplainabilityPropertyValidator(properties).assertSuccess();
    return {
        Report: cfnModelPackageMetricsSourcePropertyToCloudFormation(properties.report),
    };
}
// @ts-ignore TS6133
function CfnModelPackageExplainabilityPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('report', 'Report', properties.Report != null ? CfnModelPackageMetricsSourcePropertyFromCloudFormation(properties.Report) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FileSourceProperty`
 *
 * @param properties - the TypeScript properties of a `FileSourceProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelPackage_FileSourcePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('contentDigest', cdk.validateString)(properties.contentDigest));
    errors.collect(cdk.propertyValidator('contentType', cdk.validateString)(properties.contentType));
    errors.collect(cdk.propertyValidator('s3Uri', cdk.requiredValidator)(properties.s3Uri));
    errors.collect(cdk.propertyValidator('s3Uri', cdk.validateString)(properties.s3Uri));
    return errors.wrap('supplied properties not correct for "FileSourceProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.FileSource` resource
 *
 * @param properties - the TypeScript properties of a `FileSourceProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.FileSource` resource.
 */
// @ts-ignore TS6133
function cfnModelPackageFileSourcePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelPackage_FileSourcePropertyValidator(properties).assertSuccess();
    return {
        ContentDigest: cdk.stringToCloudFormation(properties.contentDigest),
        ContentType: cdk.stringToCloudFormation(properties.contentType),
        S3Uri: cdk.stringToCloudFormation(properties.s3Uri),
    };
}
// @ts-ignore TS6133
function CfnModelPackageFileSourcePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('contentDigest', 'ContentDigest', properties.ContentDigest != null ? cfn_parse.FromCloudFormation.getString(properties.ContentDigest) : undefined);
    ret.addPropertyResult('contentType', 'ContentType', properties.ContentType != null ? cfn_parse.FromCloudFormation.getString(properties.ContentType) : undefined);
    ret.addPropertyResult('s3Uri', 'S3Uri', cfn_parse.FromCloudFormation.getString(properties.S3Uri));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `InferenceSpecificationProperty`
 *
 * @param properties - the TypeScript properties of a `InferenceSpecificationProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelPackage_InferenceSpecificationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('containers', cdk.requiredValidator)(properties.containers));
    errors.collect(cdk.propertyValidator('containers', cdk.listValidator(CfnModelPackage_ModelPackageContainerDefinitionPropertyValidator))(properties.containers));
    errors.collect(cdk.propertyValidator('supportedContentTypes', cdk.requiredValidator)(properties.supportedContentTypes));
    errors.collect(cdk.propertyValidator('supportedContentTypes', cdk.listValidator(cdk.validateString))(properties.supportedContentTypes));
    errors.collect(cdk.propertyValidator('supportedRealtimeInferenceInstanceTypes', cdk.listValidator(cdk.validateString))(properties.supportedRealtimeInferenceInstanceTypes));
    errors.collect(cdk.propertyValidator('supportedResponseMimeTypes', cdk.requiredValidator)(properties.supportedResponseMimeTypes));
    errors.collect(cdk.propertyValidator('supportedResponseMimeTypes', cdk.listValidator(cdk.validateString))(properties.supportedResponseMimeTypes));
    errors.collect(cdk.propertyValidator('supportedTransformInstanceTypes', cdk.listValidator(cdk.validateString))(properties.supportedTransformInstanceTypes));
    return errors.wrap('supplied properties not correct for "InferenceSpecificationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.InferenceSpecification` resource
 *
 * @param properties - the TypeScript properties of a `InferenceSpecificationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.InferenceSpecification` resource.
 */
// @ts-ignore TS6133
function cfnModelPackageInferenceSpecificationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelPackage_InferenceSpecificationPropertyValidator(properties).assertSuccess();
    return {
        Containers: cdk.listMapper(cfnModelPackageModelPackageContainerDefinitionPropertyToCloudFormation)(properties.containers),
        SupportedContentTypes: cdk.listMapper(cdk.stringToCloudFormation)(properties.supportedContentTypes),
        SupportedRealtimeInferenceInstanceTypes: cdk.listMapper(cdk.stringToCloudFormation)(properties.supportedRealtimeInferenceInstanceTypes),
        SupportedResponseMIMETypes: cdk.listMapper(cdk.stringToCloudFormation)(properties.supportedResponseMimeTypes),
        SupportedTransformInstanceTypes: cdk.listMapper(cdk.stringToCloudFormation)(properties.supportedTransformInstanceTypes),
    };
}
// @ts-ignore TS6133
function CfnModelPackageInferenceSpecificationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('containers', 'Containers', cfn_parse.FromCloudFormation.getArray(CfnModelPackageModelPackageContainerDefinitionPropertyFromCloudFormation)(properties.Containers));
    ret.addPropertyResult('supportedContentTypes', 'SupportedContentTypes', cfn_parse.FromCloudFormation.getStringArray(properties.SupportedContentTypes));
    ret.addPropertyResult('supportedRealtimeInferenceInstanceTypes', 'SupportedRealtimeInferenceInstanceTypes', properties.SupportedRealtimeInferenceInstanceTypes != null ? cfn_parse.FromCloudFormation.getStringArray(properties.SupportedRealtimeInferenceInstanceTypes) : undefined);
    ret.addPropertyResult('supportedResponseMimeTypes', 'SupportedResponseMIMETypes', cfn_parse.FromCloudFormation.getStringArray(properties.SupportedResponseMIMETypes));
    ret.addPropertyResult('supportedTransformInstanceTypes', 'SupportedTransformInstanceTypes', properties.SupportedTransformInstanceTypes != null ? cfn_parse.FromCloudFormation.getStringArray(properties.SupportedTransformInstanceTypes) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MetadataPropertiesProperty`
 *
 * @param properties - the TypeScript properties of a `MetadataPropertiesProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelPackage_MetadataPropertiesPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('commitId', cdk.validateString)(properties.commitId));
    errors.collect(cdk.propertyValidator('generatedBy', cdk.validateString)(properties.generatedBy));
    errors.collect(cdk.propertyValidator('projectId', cdk.validateString)(properties.projectId));
    errors.collect(cdk.propertyValidator('repository', cdk.validateString)(properties.repository));
    return errors.wrap('supplied properties not correct for "MetadataPropertiesProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.MetadataProperties` resource
 *
 * @param properties - the TypeScript properties of a `MetadataPropertiesProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.MetadataProperties` resource.
 */
// @ts-ignore TS6133
function cfnModelPackageMetadataPropertiesPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelPackage_MetadataPropertiesPropertyValidator(properties).assertSuccess();
    return {
        CommitId: cdk.stringToCloudFormation(properties.commitId),
        GeneratedBy: cdk.stringToCloudFormation(properties.generatedBy),
        ProjectId: cdk.stringToCloudFormation(properties.projectId),
        Repository: cdk.stringToCloudFormation(properties.repository),
    };
}
// @ts-ignore TS6133
function CfnModelPackageMetadataPropertiesPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('commitId', 'CommitId', properties.CommitId != null ? cfn_parse.FromCloudFormation.getString(properties.CommitId) : undefined);
    ret.addPropertyResult('generatedBy', 'GeneratedBy', properties.GeneratedBy != null ? cfn_parse.FromCloudFormation.getString(properties.GeneratedBy) : undefined);
    ret.addPropertyResult('projectId', 'ProjectId', properties.ProjectId != null ? cfn_parse.FromCloudFormation.getString(properties.ProjectId) : undefined);
    ret.addPropertyResult('repository', 'Repository', properties.Repository != null ? cfn_parse.FromCloudFormation.getString(properties.Repository) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MetricsSourceProperty`
 *
 * @param properties - the TypeScript properties of a `MetricsSourceProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelPackage_MetricsSourcePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('contentDigest', cdk.validateString)(properties.contentDigest));
    errors.collect(cdk.propertyValidator('contentType', cdk.requiredValidator)(properties.contentType));
    errors.collect(cdk.propertyValidator('contentType', cdk.validateString)(properties.contentType));
    errors.collect(cdk.propertyValidator('s3Uri', cdk.requiredValidator)(properties.s3Uri));
    errors.collect(cdk.propertyValidator('s3Uri', cdk.validateString)(properties.s3Uri));
    return errors.wrap('supplied properties not correct for "MetricsSourceProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.MetricsSource` resource
 *
 * @param properties - the TypeScript properties of a `MetricsSourceProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.MetricsSource` resource.
 */
// @ts-ignore TS6133
function cfnModelPackageMetricsSourcePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelPackage_MetricsSourcePropertyValidator(properties).assertSuccess();
    return {
        ContentDigest: cdk.stringToCloudFormation(properties.contentDigest),
        ContentType: cdk.stringToCloudFormation(properties.contentType),
        S3Uri: cdk.stringToCloudFormation(properties.s3Uri),
    };
}
// @ts-ignore TS6133
function CfnModelPackageMetricsSourcePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('contentDigest', 'ContentDigest', properties.ContentDigest != null ? cfn_parse.FromCloudFormation.getString(properties.ContentDigest) : undefined);
    ret.addPropertyResult('contentType', 'ContentType', cfn_parse.FromCloudFormation.getString(properties.ContentType));
    ret.addPropertyResult('s3Uri', 'S3Uri', cfn_parse.FromCloudFormation.getString(properties.S3Uri));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ModelDataQualityProperty`
 *
 * @param properties - the TypeScript properties of a `ModelDataQualityProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelPackage_ModelDataQualityPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('constraints', CfnModelPackage_MetricsSourcePropertyValidator)(properties.constraints));
    errors.collect(cdk.propertyValidator('statistics', CfnModelPackage_MetricsSourcePropertyValidator)(properties.statistics));
    return errors.wrap('supplied properties not correct for "ModelDataQualityProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.ModelDataQuality` resource
 *
 * @param properties - the TypeScript properties of a `ModelDataQualityProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.ModelDataQuality` resource.
 */
// @ts-ignore TS6133
function cfnModelPackageModelDataQualityPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelPackage_ModelDataQualityPropertyValidator(properties).assertSuccess();
    return {
        Constraints: cfnModelPackageMetricsSourcePropertyToCloudFormation(properties.constraints),
        Statistics: cfnModelPackageMetricsSourcePropertyToCloudFormation(properties.statistics),
    };
}
// @ts-ignore TS6133
function CfnModelPackageModelDataQualityPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('constraints', 'Constraints', properties.Constraints != null ? CfnModelPackageMetricsSourcePropertyFromCloudFormation(properties.Constraints) : undefined);
    ret.addPropertyResult('statistics', 'Statistics', properties.Statistics != null ? CfnModelPackageMetricsSourcePropertyFromCloudFormation(properties.Statistics) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ModelInputProperty`
 *
 * @param properties - the TypeScript properties of a `ModelInputProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelPackage_ModelInputPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dataInputConfig', cdk.requiredValidator)(properties.dataInputConfig));
    errors.collect(cdk.propertyValidator('dataInputConfig', cdk.validateString)(properties.dataInputConfig));
    return errors.wrap('supplied properties not correct for "ModelInputProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.ModelInput` resource
 *
 * @param properties - the TypeScript properties of a `ModelInputProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.ModelInput` resource.
 */
// @ts-ignore TS6133
function cfnModelPackageModelInputPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelPackage_ModelInputPropertyValidator(properties).assertSuccess();
    return {
        DataInputConfig: cdk.stringToCloudFormation(properties.dataInputConfig),
    };
}
// @ts-ignore TS6133
function CfnModelPackageModelInputPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dataInputConfig', 'DataInputConfig', cfn_parse.FromCloudFormation.getString(properties.DataInputConfig));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ModelMetricsProperty`
 *
 * @param properties - the TypeScript properties of a `ModelMetricsProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelPackage_ModelMetricsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('bias', CfnModelPackage_BiasPropertyValidator)(properties.bias));
    errors.collect(cdk.propertyValidator('explainability', CfnModelPackage_ExplainabilityPropertyValidator)(properties.explainability));
    errors.collect(cdk.propertyValidator('modelDataQuality', CfnModelPackage_ModelDataQualityPropertyValidator)(properties.modelDataQuality));
    errors.collect(cdk.propertyValidator('modelQuality', CfnModelPackage_ModelQualityPropertyValidator)(properties.modelQuality));
    return errors.wrap('supplied properties not correct for "ModelMetricsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.ModelMetrics` resource
 *
 * @param properties - the TypeScript properties of a `ModelMetricsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.ModelMetrics` resource.
 */
// @ts-ignore TS6133
function cfnModelPackageModelMetricsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelPackage_ModelMetricsPropertyValidator(properties).assertSuccess();
    return {
        Bias: cfnModelPackageBiasPropertyToCloudFormation(properties.bias),
        Explainability: cfnModelPackageExplainabilityPropertyToCloudFormation(properties.explainability),
        ModelDataQuality: cfnModelPackageModelDataQualityPropertyToCloudFormation(properties.modelDataQuality),
        ModelQuality: cfnModelPackageModelQualityPropertyToCloudFormation(properties.modelQuality),
    };
}
// @ts-ignore TS6133
function CfnModelPackageModelMetricsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('bias', 'Bias', properties.Bias != null ? CfnModelPackageBiasPropertyFromCloudFormation(properties.Bias) : undefined);
    ret.addPropertyResult('explainability', 'Explainability', properties.Explainability != null ? CfnModelPackageExplainabilityPropertyFromCloudFormation(properties.Explainability) : undefined);
    ret.addPropertyResult('modelDataQuality', 'ModelDataQuality', properties.ModelDataQuality != null ? CfnModelPackageModelDataQualityPropertyFromCloudFormation(properties.ModelDataQuality) : undefined);
    ret.addPropertyResult('modelQuality', 'ModelQuality', properties.ModelQuality != null ? CfnModelPackageModelQualityPropertyFromCloudFormation(properties.ModelQuality) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ModelPackageContainerDefinitionProperty`
 *
 * @param properties - the TypeScript properties of a `ModelPackageContainerDefinitionProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelPackage_ModelPackageContainerDefinitionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('containerHostname', cdk.validateString)(properties.containerHostname));
    errors.collect(cdk.propertyValidator('environment', cdk.hashValidator(cdk.validateString))(properties.environment));
    errors.collect(cdk.propertyValidator('framework', cdk.validateString)(properties.framework));
    errors.collect(cdk.propertyValidator('frameworkVersion', cdk.validateString)(properties.frameworkVersion));
    errors.collect(cdk.propertyValidator('image', cdk.requiredValidator)(properties.image));
    errors.collect(cdk.propertyValidator('image', cdk.validateString)(properties.image));
    errors.collect(cdk.propertyValidator('imageDigest', cdk.validateString)(properties.imageDigest));
    errors.collect(cdk.propertyValidator('modelDataUrl', cdk.validateString)(properties.modelDataUrl));
    errors.collect(cdk.propertyValidator('modelInput', cdk.validateObject)(properties.modelInput));
    errors.collect(cdk.propertyValidator('nearestModelName', cdk.validateString)(properties.nearestModelName));
    errors.collect(cdk.propertyValidator('productId', cdk.validateString)(properties.productId));
    return errors.wrap('supplied properties not correct for "ModelPackageContainerDefinitionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.ModelPackageContainerDefinition` resource
 *
 * @param properties - the TypeScript properties of a `ModelPackageContainerDefinitionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.ModelPackageContainerDefinition` resource.
 */
// @ts-ignore TS6133
function cfnModelPackageModelPackageContainerDefinitionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelPackage_ModelPackageContainerDefinitionPropertyValidator(properties).assertSuccess();
    return {
        ContainerHostname: cdk.stringToCloudFormation(properties.containerHostname),
        Environment: cdk.hashMapper(cdk.stringToCloudFormation)(properties.environment),
        Framework: cdk.stringToCloudFormation(properties.framework),
        FrameworkVersion: cdk.stringToCloudFormation(properties.frameworkVersion),
        Image: cdk.stringToCloudFormation(properties.image),
        ImageDigest: cdk.stringToCloudFormation(properties.imageDigest),
        ModelDataUrl: cdk.stringToCloudFormation(properties.modelDataUrl),
        ModelInput: cdk.objectToCloudFormation(properties.modelInput),
        NearestModelName: cdk.stringToCloudFormation(properties.nearestModelName),
        ProductId: cdk.stringToCloudFormation(properties.productId),
    };
}
// @ts-ignore TS6133
function CfnModelPackageModelPackageContainerDefinitionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('containerHostname', 'ContainerHostname', properties.ContainerHostname != null ? cfn_parse.FromCloudFormation.getString(properties.ContainerHostname) : undefined);
    ret.addPropertyResult('environment', 'Environment', properties.Environment != null ? cfn_parse.FromCloudFormation.getMap(cfn_parse.FromCloudFormation.getString)(properties.Environment) : undefined);
    ret.addPropertyResult('framework', 'Framework', properties.Framework != null ? cfn_parse.FromCloudFormation.getString(properties.Framework) : undefined);
    ret.addPropertyResult('frameworkVersion', 'FrameworkVersion', properties.FrameworkVersion != null ? cfn_parse.FromCloudFormation.getString(properties.FrameworkVersion) : undefined);
    ret.addPropertyResult('image', 'Image', cfn_parse.FromCloudFormation.getString(properties.Image));
    ret.addPropertyResult('imageDigest', 'ImageDigest', properties.ImageDigest != null ? cfn_parse.FromCloudFormation.getString(properties.ImageDigest) : undefined);
    ret.addPropertyResult('modelDataUrl', 'ModelDataUrl', properties.ModelDataUrl != null ? cfn_parse.FromCloudFormation.getString(properties.ModelDataUrl) : undefined);
    ret.addPropertyResult('modelInput', 'ModelInput', properties.ModelInput != null ? cfn_parse.FromCloudFormation.getAny(properties.ModelInput) : undefined);
    ret.addPropertyResult('nearestModelName', 'NearestModelName', properties.NearestModelName != null ? cfn_parse.FromCloudFormation.getString(properties.NearestModelName) : undefined);
    ret.addPropertyResult('productId', 'ProductId', properties.ProductId != null ? cfn_parse.FromCloudFormation.getString(properties.ProductId) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ModelPackageStatusDetailsProperty`
 *
 * @param properties - the TypeScript properties of a `ModelPackageStatusDetailsProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelPackage_ModelPackageStatusDetailsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('imageScanStatuses', cdk.listValidator(CfnModelPackage_ModelPackageStatusItemPropertyValidator))(properties.imageScanStatuses));
    errors.collect(cdk.propertyValidator('validationStatuses', cdk.requiredValidator)(properties.validationStatuses));
    errors.collect(cdk.propertyValidator('validationStatuses', cdk.listValidator(CfnModelPackage_ModelPackageStatusItemPropertyValidator))(properties.validationStatuses));
    return errors.wrap('supplied properties not correct for "ModelPackageStatusDetailsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.ModelPackageStatusDetails` resource
 *
 * @param properties - the TypeScript properties of a `ModelPackageStatusDetailsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.ModelPackageStatusDetails` resource.
 */
// @ts-ignore TS6133
function cfnModelPackageModelPackageStatusDetailsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelPackage_ModelPackageStatusDetailsPropertyValidator(properties).assertSuccess();
    return {
        ImageScanStatuses: cdk.listMapper(cfnModelPackageModelPackageStatusItemPropertyToCloudFormation)(properties.imageScanStatuses),
        ValidationStatuses: cdk.listMapper(cfnModelPackageModelPackageStatusItemPropertyToCloudFormation)(properties.validationStatuses),
    };
}
// @ts-ignore TS6133
function CfnModelPackageModelPackageStatusDetailsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('imageScanStatuses', 'ImageScanStatuses', properties.ImageScanStatuses != null ? cfn_parse.FromCloudFormation.getArray(CfnModelPackageModelPackageStatusItemPropertyFromCloudFormation)(properties.ImageScanStatuses) : undefined);
    ret.addPropertyResult('validationStatuses', 'ValidationStatuses', cfn_parse.FromCloudFormation.getArray(CfnModelPackageModelPackageStatusItemPropertyFromCloudFormation)(properties.ValidationStatuses));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ModelPackageStatusItemProperty`
 *
 * @param properties - the TypeScript properties of a `ModelPackageStatusItemProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelPackage_ModelPackageStatusItemPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('failureReason', cdk.validateString)(properties.failureReason));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('status', cdk.requiredValidator)(properties.status));
    errors.collect(cdk.propertyValidator('status', cdk.validateString)(properties.status));
    return errors.wrap('supplied properties not correct for "ModelPackageStatusItemProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.ModelPackageStatusItem` resource
 *
 * @param properties - the TypeScript properties of a `ModelPackageStatusItemProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.ModelPackageStatusItem` resource.
 */
// @ts-ignore TS6133
function cfnModelPackageModelPackageStatusItemPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelPackage_ModelPackageStatusItemPropertyValidator(properties).assertSuccess();
    return {
        FailureReason: cdk.stringToCloudFormation(properties.failureReason),
        Name: cdk.stringToCloudFormation(properties.name),
        Status: cdk.stringToCloudFormation(properties.status),
    };
}
// @ts-ignore TS6133
function CfnModelPackageModelPackageStatusItemPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('failureReason', 'FailureReason', properties.FailureReason != null ? cfn_parse.FromCloudFormation.getString(properties.FailureReason) : undefined);
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('status', 'Status', cfn_parse.FromCloudFormation.getString(properties.Status));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ModelQualityProperty`
 *
 * @param properties - the TypeScript properties of a `ModelQualityProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelPackage_ModelQualityPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('constraints', CfnModelPackage_MetricsSourcePropertyValidator)(properties.constraints));
    errors.collect(cdk.propertyValidator('statistics', CfnModelPackage_MetricsSourcePropertyValidator)(properties.statistics));
    return errors.wrap('supplied properties not correct for "ModelQualityProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.ModelQuality` resource
 *
 * @param properties - the TypeScript properties of a `ModelQualityProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.ModelQuality` resource.
 */
// @ts-ignore TS6133
function cfnModelPackageModelQualityPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelPackage_ModelQualityPropertyValidator(properties).assertSuccess();
    return {
        Constraints: cfnModelPackageMetricsSourcePropertyToCloudFormation(properties.constraints),
        Statistics: cfnModelPackageMetricsSourcePropertyToCloudFormation(properties.statistics),
    };
}
// @ts-ignore TS6133
function CfnModelPackageModelQualityPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('constraints', 'Constraints', properties.Constraints != null ? CfnModelPackageMetricsSourcePropertyFromCloudFormation(properties.Constraints) : undefined);
    ret.addPropertyResult('statistics', 'Statistics', properties.Statistics != null ? CfnModelPackageMetricsSourcePropertyFromCloudFormation(properties.Statistics) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `S3DataSourceProperty`
 *
 * @param properties - the TypeScript properties of a `S3DataSourceProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelPackage_S3DataSourcePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('s3DataType', cdk.requiredValidator)(properties.s3DataType));
    errors.collect(cdk.propertyValidator('s3DataType', cdk.validateString)(properties.s3DataType));
    errors.collect(cdk.propertyValidator('s3Uri', cdk.requiredValidator)(properties.s3Uri));
    errors.collect(cdk.propertyValidator('s3Uri', cdk.validateString)(properties.s3Uri));
    return errors.wrap('supplied properties not correct for "S3DataSourceProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.S3DataSource` resource
 *
 * @param properties - the TypeScript properties of a `S3DataSourceProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.S3DataSource` resource.
 */
// @ts-ignore TS6133
function cfnModelPackageS3DataSourcePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelPackage_S3DataSourcePropertyValidator(properties).assertSuccess();
    return {
        S3DataType: cdk.stringToCloudFormation(properties.s3DataType),
        S3Uri: cdk.stringToCloudFormation(properties.s3Uri),
    };
}
// @ts-ignore TS6133
function CfnModelPackageS3DataSourcePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('s3DataType', 'S3DataType', cfn_parse.FromCloudFormation.getString(properties.S3DataType));
    ret.addPropertyResult('s3Uri', 'S3Uri', cfn_parse.FromCloudFormation.getString(properties.S3Uri));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `SourceAlgorithmProperty`
 *
 * @param properties - the TypeScript properties of a `SourceAlgorithmProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelPackage_SourceAlgorithmPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('algorithmName', cdk.requiredValidator)(properties.algorithmName));
    errors.collect(cdk.propertyValidator('algorithmName', cdk.validateString)(properties.algorithmName));
    errors.collect(cdk.propertyValidator('modelDataUrl', cdk.validateString)(properties.modelDataUrl));
    return errors.wrap('supplied properties not correct for "SourceAlgorithmProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.SourceAlgorithm` resource
 *
 * @param properties - the TypeScript properties of a `SourceAlgorithmProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.SourceAlgorithm` resource.
 */
// @ts-ignore TS6133
function cfnModelPackageSourceAlgorithmPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelPackage_SourceAlgorithmPropertyValidator(properties).assertSuccess();
    return {
        AlgorithmName: cdk.stringToCloudFormation(properties.algorithmName),
        ModelDataUrl: cdk.stringToCloudFormation(properties.modelDataUrl),
    };
}
// @ts-ignore TS6133
function CfnModelPackageSourceAlgorithmPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('algorithmName', 'AlgorithmName', cfn_parse.FromCloudFormation.getString(properties.AlgorithmName));
    ret.addPropertyResult('modelDataUrl', 'ModelDataUrl', properties.ModelDataUrl != null ? cfn_parse.FromCloudFormation.getString(properties.ModelDataUrl) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `SourceAlgorithmSpecificationProperty`
 *
 * @param properties - the TypeScript properties of a `SourceAlgorithmSpecificationProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelPackage_SourceAlgorithmSpecificationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('sourceAlgorithms', cdk.requiredValidator)(properties.sourceAlgorithms));
    errors.collect(cdk.propertyValidator('sourceAlgorithms', cdk.listValidator(CfnModelPackage_SourceAlgorithmPropertyValidator))(properties.sourceAlgorithms));
    return errors.wrap('supplied properties not correct for "SourceAlgorithmSpecificationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.SourceAlgorithmSpecification` resource
 *
 * @param properties - the TypeScript properties of a `SourceAlgorithmSpecificationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.SourceAlgorithmSpecification` resource.
 */
// @ts-ignore TS6133
function cfnModelPackageSourceAlgorithmSpecificationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelPackage_SourceAlgorithmSpecificationPropertyValidator(properties).assertSuccess();
    return {
        SourceAlgorithms: cdk.listMapper(cfnModelPackageSourceAlgorithmPropertyToCloudFormation)(properties.sourceAlgorithms),
    };
}
// @ts-ignore TS6133
function CfnModelPackageSourceAlgorithmSpecificationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('sourceAlgorithms', 'SourceAlgorithms', cfn_parse.FromCloudFormation.getArray(CfnModelPackageSourceAlgorithmPropertyFromCloudFormation)(properties.SourceAlgorithms));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `TransformInputProperty`
 *
 * @param properties - the TypeScript properties of a `TransformInputProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelPackage_TransformInputPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('compressionType', cdk.validateString)(properties.compressionType));
    errors.collect(cdk.propertyValidator('contentType', cdk.validateString)(properties.contentType));
    errors.collect(cdk.propertyValidator('dataSource', cdk.requiredValidator)(properties.dataSource));
    errors.collect(cdk.propertyValidator('dataSource', CfnModelPackage_DataSourcePropertyValidator)(properties.dataSource));
    errors.collect(cdk.propertyValidator('splitType', cdk.validateString)(properties.splitType));
    return errors.wrap('supplied properties not correct for "TransformInputProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.TransformInput` resource
 *
 * @param properties - the TypeScript properties of a `TransformInputProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.TransformInput` resource.
 */
// @ts-ignore TS6133
function cfnModelPackageTransformInputPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelPackage_TransformInputPropertyValidator(properties).assertSuccess();
    return {
        CompressionType: cdk.stringToCloudFormation(properties.compressionType),
        ContentType: cdk.stringToCloudFormation(properties.contentType),
        DataSource: cfnModelPackageDataSourcePropertyToCloudFormation(properties.dataSource),
        SplitType: cdk.stringToCloudFormation(properties.splitType),
    };
}
// @ts-ignore TS6133
function CfnModelPackageTransformInputPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('compressionType', 'CompressionType', properties.CompressionType != null ? cfn_parse.FromCloudFormation.getString(properties.CompressionType) : undefined);
    ret.addPropertyResult('contentType', 'ContentType', properties.ContentType != null ? cfn_parse.FromCloudFormation.getString(properties.ContentType) : undefined);
    ret.addPropertyResult('dataSource', 'DataSource', CfnModelPackageDataSourcePropertyFromCloudFormation(properties.DataSource));
    ret.addPropertyResult('splitType', 'SplitType', properties.SplitType != null ? cfn_parse.FromCloudFormation.getString(properties.SplitType) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `TransformJobDefinitionProperty`
 *
 * @param properties - the TypeScript properties of a `TransformJobDefinitionProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelPackage_TransformJobDefinitionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('batchStrategy', cdk.validateString)(properties.batchStrategy));
    errors.collect(cdk.propertyValidator('environment', cdk.hashValidator(cdk.validateString))(properties.environment));
    errors.collect(cdk.propertyValidator('maxConcurrentTransforms', cdk.validateNumber)(properties.maxConcurrentTransforms));
    errors.collect(cdk.propertyValidator('maxPayloadInMb', cdk.validateNumber)(properties.maxPayloadInMb));
    errors.collect(cdk.propertyValidator('transformInput', cdk.requiredValidator)(properties.transformInput));
    errors.collect(cdk.propertyValidator('transformInput', CfnModelPackage_TransformInputPropertyValidator)(properties.transformInput));
    errors.collect(cdk.propertyValidator('transformOutput', cdk.requiredValidator)(properties.transformOutput));
    errors.collect(cdk.propertyValidator('transformOutput', CfnModelPackage_TransformOutputPropertyValidator)(properties.transformOutput));
    errors.collect(cdk.propertyValidator('transformResources', cdk.requiredValidator)(properties.transformResources));
    errors.collect(cdk.propertyValidator('transformResources', CfnModelPackage_TransformResourcesPropertyValidator)(properties.transformResources));
    return errors.wrap('supplied properties not correct for "TransformJobDefinitionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.TransformJobDefinition` resource
 *
 * @param properties - the TypeScript properties of a `TransformJobDefinitionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.TransformJobDefinition` resource.
 */
// @ts-ignore TS6133
function cfnModelPackageTransformJobDefinitionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelPackage_TransformJobDefinitionPropertyValidator(properties).assertSuccess();
    return {
        BatchStrategy: cdk.stringToCloudFormation(properties.batchStrategy),
        Environment: cdk.hashMapper(cdk.stringToCloudFormation)(properties.environment),
        MaxConcurrentTransforms: cdk.numberToCloudFormation(properties.maxConcurrentTransforms),
        MaxPayloadInMB: cdk.numberToCloudFormation(properties.maxPayloadInMb),
        TransformInput: cfnModelPackageTransformInputPropertyToCloudFormation(properties.transformInput),
        TransformOutput: cfnModelPackageTransformOutputPropertyToCloudFormation(properties.transformOutput),
        TransformResources: cfnModelPackageTransformResourcesPropertyToCloudFormation(properties.transformResources),
    };
}
// @ts-ignore TS6133
function CfnModelPackageTransformJobDefinitionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('batchStrategy', 'BatchStrategy', properties.BatchStrategy != null ? cfn_parse.FromCloudFormation.getString(properties.BatchStrategy) : undefined);
    ret.addPropertyResult('environment', 'Environment', properties.Environment != null ? cfn_parse.FromCloudFormation.getMap(cfn_parse.FromCloudFormation.getString)(properties.Environment) : undefined);
    ret.addPropertyResult('maxConcurrentTransforms', 'MaxConcurrentTransforms', properties.MaxConcurrentTransforms != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxConcurrentTransforms) : undefined);
    ret.addPropertyResult('maxPayloadInMb', 'MaxPayloadInMB', properties.MaxPayloadInMB != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxPayloadInMB) : undefined);
    ret.addPropertyResult('transformInput', 'TransformInput', CfnModelPackageTransformInputPropertyFromCloudFormation(properties.TransformInput));
    ret.addPropertyResult('transformOutput', 'TransformOutput', CfnModelPackageTransformOutputPropertyFromCloudFormation(properties.TransformOutput));
    ret.addPropertyResult('transformResources', 'TransformResources', CfnModelPackageTransformResourcesPropertyFromCloudFormation(properties.TransformResources));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `TransformOutputProperty`
 *
 * @param properties - the TypeScript properties of a `TransformOutputProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelPackage_TransformOutputPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('accept', cdk.validateString)(properties.accept));
    errors.collect(cdk.propertyValidator('assembleWith', cdk.validateString)(properties.assembleWith));
    errors.collect(cdk.propertyValidator('kmsKeyId', cdk.validateString)(properties.kmsKeyId));
    errors.collect(cdk.propertyValidator('s3OutputPath', cdk.requiredValidator)(properties.s3OutputPath));
    errors.collect(cdk.propertyValidator('s3OutputPath', cdk.validateString)(properties.s3OutputPath));
    return errors.wrap('supplied properties not correct for "TransformOutputProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.TransformOutput` resource
 *
 * @param properties - the TypeScript properties of a `TransformOutputProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.TransformOutput` resource.
 */
// @ts-ignore TS6133
function cfnModelPackageTransformOutputPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelPackage_TransformOutputPropertyValidator(properties).assertSuccess();
    return {
        Accept: cdk.stringToCloudFormation(properties.accept),
        AssembleWith: cdk.stringToCloudFormation(properties.assembleWith),
        KmsKeyId: cdk.stringToCloudFormation(properties.kmsKeyId),
        S3OutputPath: cdk.stringToCloudFormation(properties.s3OutputPath),
    };
}
// @ts-ignore TS6133
function CfnModelPackageTransformOutputPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('accept', 'Accept', properties.Accept != null ? cfn_parse.FromCloudFormation.getString(properties.Accept) : undefined);
    ret.addPropertyResult('assembleWith', 'AssembleWith', properties.AssembleWith != null ? cfn_parse.FromCloudFormation.getString(properties.AssembleWith) : undefined);
    ret.addPropertyResult('kmsKeyId', 'KmsKeyId', properties.KmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.KmsKeyId) : undefined);
    ret.addPropertyResult('s3OutputPath', 'S3OutputPath', cfn_parse.FromCloudFormation.getString(properties.S3OutputPath));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `TransformResourcesProperty`
 *
 * @param properties - the TypeScript properties of a `TransformResourcesProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelPackage_TransformResourcesPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('instanceCount', cdk.requiredValidator)(properties.instanceCount));
    errors.collect(cdk.propertyValidator('instanceCount', cdk.validateNumber)(properties.instanceCount));
    errors.collect(cdk.propertyValidator('instanceType', cdk.requiredValidator)(properties.instanceType));
    errors.collect(cdk.propertyValidator('instanceType', cdk.validateString)(properties.instanceType));
    errors.collect(cdk.propertyValidator('volumeKmsKeyId', cdk.validateString)(properties.volumeKmsKeyId));
    return errors.wrap('supplied properties not correct for "TransformResourcesProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.TransformResources` resource
 *
 * @param properties - the TypeScript properties of a `TransformResourcesProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.TransformResources` resource.
 */
// @ts-ignore TS6133
function cfnModelPackageTransformResourcesPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelPackage_TransformResourcesPropertyValidator(properties).assertSuccess();
    return {
        InstanceCount: cdk.numberToCloudFormation(properties.instanceCount),
        InstanceType: cdk.stringToCloudFormation(properties.instanceType),
        VolumeKmsKeyId: cdk.stringToCloudFormation(properties.volumeKmsKeyId),
    };
}
// @ts-ignore TS6133
function CfnModelPackageTransformResourcesPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('instanceCount', 'InstanceCount', cfn_parse.FromCloudFormation.getNumber(properties.InstanceCount));
    ret.addPropertyResult('instanceType', 'InstanceType', cfn_parse.FromCloudFormation.getString(properties.InstanceType));
    ret.addPropertyResult('volumeKmsKeyId', 'VolumeKmsKeyId', properties.VolumeKmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.VolumeKmsKeyId) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `UserContextProperty`
 *
 * @param properties - the TypeScript properties of a `UserContextProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelPackage_UserContextPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('domainId', cdk.validateString)(properties.domainId));
    errors.collect(cdk.propertyValidator('userProfileArn', cdk.validateString)(properties.userProfileArn));
    errors.collect(cdk.propertyValidator('userProfileName', cdk.validateString)(properties.userProfileName));
    return errors.wrap('supplied properties not correct for "UserContextProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.UserContext` resource
 *
 * @param properties - the TypeScript properties of a `UserContextProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.UserContext` resource.
 */
// @ts-ignore TS6133
function cfnModelPackageUserContextPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelPackage_UserContextPropertyValidator(properties).assertSuccess();
    return {
        DomainId: cdk.stringToCloudFormation(properties.domainId),
        UserProfileArn: cdk.stringToCloudFormation(properties.userProfileArn),
        UserProfileName: cdk.stringToCloudFormation(properties.userProfileName),
    };
}
// @ts-ignore TS6133
function CfnModelPackageUserContextPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('domainId', 'DomainId', properties.DomainId != null ? cfn_parse.FromCloudFormation.getString(properties.DomainId) : undefined);
    ret.addPropertyResult('userProfileArn', 'UserProfileArn', properties.UserProfileArn != null ? cfn_parse.FromCloudFormation.getString(properties.UserProfileArn) : undefined);
    ret.addPropertyResult('userProfileName', 'UserProfileName', properties.UserProfileName != null ? cfn_parse.FromCloudFormation.getString(properties.UserProfileName) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ValidationProfileProperty`
 *
 * @param properties - the TypeScript properties of a `ValidationProfileProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelPackage_ValidationProfilePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('profileName', cdk.requiredValidator)(properties.profileName));
    errors.collect(cdk.propertyValidator('profileName', cdk.validateString)(properties.profileName));
    errors.collect(cdk.propertyValidator('transformJobDefinition', cdk.requiredValidator)(properties.transformJobDefinition));
    errors.collect(cdk.propertyValidator('transformJobDefinition', CfnModelPackage_TransformJobDefinitionPropertyValidator)(properties.transformJobDefinition));
    return errors.wrap('supplied properties not correct for "ValidationProfileProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.ValidationProfile` resource
 *
 * @param properties - the TypeScript properties of a `ValidationProfileProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.ValidationProfile` resource.
 */
// @ts-ignore TS6133
function cfnModelPackageValidationProfilePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelPackage_ValidationProfilePropertyValidator(properties).assertSuccess();
    return {
        ProfileName: cdk.stringToCloudFormation(properties.profileName),
        TransformJobDefinition: cfnModelPackageTransformJobDefinitionPropertyToCloudFormation(properties.transformJobDefinition),
    };
}
// @ts-ignore TS6133
function CfnModelPackageValidationProfilePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('profileName', 'ProfileName', cfn_parse.FromCloudFormation.getString(properties.ProfileName));
    ret.addPropertyResult('transformJobDefinition', 'TransformJobDefinition', CfnModelPackageTransformJobDefinitionPropertyFromCloudFormation(properties.TransformJobDefinition));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ValidationSpecificationProperty`
 *
 * @param properties - the TypeScript properties of a `ValidationSpecificationProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelPackage_ValidationSpecificationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('validationProfiles', cdk.requiredValidator)(properties.validationProfiles));
    errors.collect(cdk.propertyValidator('validationProfiles', cdk.listValidator(CfnModelPackage_ValidationProfilePropertyValidator))(properties.validationProfiles));
    errors.collect(cdk.propertyValidator('validationRole', cdk.requiredValidator)(properties.validationRole));
    errors.collect(cdk.propertyValidator('validationRole', cdk.validateString)(properties.validationRole));
    return errors.wrap('supplied properties not correct for "ValidationSpecificationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.ValidationSpecification` resource
 *
 * @param properties - the TypeScript properties of a `ValidationSpecificationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackage.ValidationSpecification` resource.
 */
// @ts-ignore TS6133
function cfnModelPackageValidationSpecificationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelPackage_ValidationSpecificationPropertyValidator(properties).assertSuccess();
    return {
        ValidationProfiles: cdk.listMapper(cfnModelPackageValidationProfilePropertyToCloudFormation)(properties.validationProfiles),
        ValidationRole: cdk.stringToCloudFormation(properties.validationRole),
    };
}
// @ts-ignore TS6133
function CfnModelPackageValidationSpecificationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('validationProfiles', 'ValidationProfiles', cfn_parse.FromCloudFormation.getArray(CfnModelPackageValidationProfilePropertyFromCloudFormation)(properties.ValidationProfiles));
    ret.addPropertyResult('validationRole', 'ValidationRole', cfn_parse.FromCloudFormation.getString(properties.ValidationRole));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnModelPackageGroupProps`
 *
 * @param properties - the TypeScript properties of a `CfnModelPackageGroupProps`
 *
 * @returns the result of the validation.
 */
function CfnModelPackageGroupPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('modelPackageGroupDescription', cdk.validateString)(properties.modelPackageGroupDescription));
    errors.collect(cdk.propertyValidator('modelPackageGroupName', cdk.requiredValidator)(properties.modelPackageGroupName));
    errors.collect(cdk.propertyValidator('modelPackageGroupName', cdk.validateString)(properties.modelPackageGroupName));
    errors.collect(cdk.propertyValidator('modelPackageGroupPolicy', cdk.validateObject)(properties.modelPackageGroupPolicy));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnModelPackageGroupProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackageGroup` resource
 *
 * @param properties - the TypeScript properties of a `CfnModelPackageGroupProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelPackageGroup` resource.
 */
// @ts-ignore TS6133
function cfnModelPackageGroupPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelPackageGroupPropsValidator(properties).assertSuccess();
    return {
        ModelPackageGroupName: cdk.stringToCloudFormation(properties.modelPackageGroupName),
        ModelPackageGroupDescription: cdk.stringToCloudFormation(properties.modelPackageGroupDescription),
        ModelPackageGroupPolicy: cdk.objectToCloudFormation(properties.modelPackageGroupPolicy),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnModelPackageGroupPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('modelPackageGroupName', 'ModelPackageGroupName', cfn_parse.FromCloudFormation.getString(properties.ModelPackageGroupName));
    ret.addPropertyResult('modelPackageGroupDescription', 'ModelPackageGroupDescription', properties.ModelPackageGroupDescription != null ? cfn_parse.FromCloudFormation.getString(properties.ModelPackageGroupDescription) : undefined);
    ret.addPropertyResult('modelPackageGroupPolicy', 'ModelPackageGroupPolicy', properties.ModelPackageGroupPolicy != null ? cfn_parse.FromCloudFormation.getAny(properties.ModelPackageGroupPolicy) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::SageMaker::ModelPackageGroup`
 *
 * A group of versioned models in the model registry.
 *
 * @cloudformationResource AWS::SageMaker::ModelPackageGroup
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackagegroup.html
 */
class CfnModelPackageGroup extends cdk.CfnResource {
    /**
     * Create a new `AWS::SageMaker::ModelPackageGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnModelPackageGroup.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_sagemaker_CfnModelPackageGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnModelPackageGroup);
            }
            throw error;
        }
        cdk.requireProperty(props, 'modelPackageGroupName', this);
        this.attrCreationTime = cdk.Token.asString(this.getAtt('CreationTime'));
        this.attrModelPackageGroupArn = cdk.Token.asString(this.getAtt('ModelPackageGroupArn'));
        this.attrModelPackageGroupStatus = cdk.Token.asString(this.getAtt('ModelPackageGroupStatus'));
        this.modelPackageGroupName = props.modelPackageGroupName;
        this.modelPackageGroupDescription = props.modelPackageGroupDescription;
        this.modelPackageGroupPolicy = props.modelPackageGroupPolicy;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::SageMaker::ModelPackageGroup", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnModelPackageGroupPropsFromCloudFormation(resourceProperties);
        const ret = new CfnModelPackageGroup(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnModelPackageGroup.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            modelPackageGroupName: this.modelPackageGroupName,
            modelPackageGroupDescription: this.modelPackageGroupDescription,
            modelPackageGroupPolicy: this.modelPackageGroupPolicy,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnModelPackageGroupPropsToCloudFormation(props);
    }
}
exports.CfnModelPackageGroup = CfnModelPackageGroup;
_s = JSII_RTTI_SYMBOL_1;
CfnModelPackageGroup[_s] = { fqn: "@aws-cdk/aws-sagemaker.CfnModelPackageGroup", version: "1.186.1" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnModelPackageGroup.CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::ModelPackageGroup";
/**
 * Determine whether the given properties match those of a `CfnModelQualityJobDefinitionProps`
 *
 * @param properties - the TypeScript properties of a `CfnModelQualityJobDefinitionProps`
 *
 * @returns the result of the validation.
 */
function CfnModelQualityJobDefinitionPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('endpointName', cdk.validateString)(properties.endpointName));
    errors.collect(cdk.propertyValidator('jobDefinitionName', cdk.validateString)(properties.jobDefinitionName));
    errors.collect(cdk.propertyValidator('jobResources', cdk.requiredValidator)(properties.jobResources));
    errors.collect(cdk.propertyValidator('jobResources', CfnModelQualityJobDefinition_MonitoringResourcesPropertyValidator)(properties.jobResources));
    errors.collect(cdk.propertyValidator('modelQualityAppSpecification', cdk.requiredValidator)(properties.modelQualityAppSpecification));
    errors.collect(cdk.propertyValidator('modelQualityAppSpecification', CfnModelQualityJobDefinition_ModelQualityAppSpecificationPropertyValidator)(properties.modelQualityAppSpecification));
    errors.collect(cdk.propertyValidator('modelQualityBaselineConfig', CfnModelQualityJobDefinition_ModelQualityBaselineConfigPropertyValidator)(properties.modelQualityBaselineConfig));
    errors.collect(cdk.propertyValidator('modelQualityJobInput', cdk.requiredValidator)(properties.modelQualityJobInput));
    errors.collect(cdk.propertyValidator('modelQualityJobInput', CfnModelQualityJobDefinition_ModelQualityJobInputPropertyValidator)(properties.modelQualityJobInput));
    errors.collect(cdk.propertyValidator('modelQualityJobOutputConfig', cdk.requiredValidator)(properties.modelQualityJobOutputConfig));
    errors.collect(cdk.propertyValidator('modelQualityJobOutputConfig', CfnModelQualityJobDefinition_MonitoringOutputConfigPropertyValidator)(properties.modelQualityJobOutputConfig));
    errors.collect(cdk.propertyValidator('networkConfig', CfnModelQualityJobDefinition_NetworkConfigPropertyValidator)(properties.networkConfig));
    errors.collect(cdk.propertyValidator('roleArn', cdk.requiredValidator)(properties.roleArn));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    errors.collect(cdk.propertyValidator('stoppingCondition', CfnModelQualityJobDefinition_StoppingConditionPropertyValidator)(properties.stoppingCondition));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnModelQualityJobDefinitionProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelQualityJobDefinition` resource
 *
 * @param properties - the TypeScript properties of a `CfnModelQualityJobDefinitionProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelQualityJobDefinition` resource.
 */
// @ts-ignore TS6133
function cfnModelQualityJobDefinitionPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelQualityJobDefinitionPropsValidator(properties).assertSuccess();
    return {
        JobResources: cfnModelQualityJobDefinitionMonitoringResourcesPropertyToCloudFormation(properties.jobResources),
        ModelQualityAppSpecification: cfnModelQualityJobDefinitionModelQualityAppSpecificationPropertyToCloudFormation(properties.modelQualityAppSpecification),
        ModelQualityJobInput: cfnModelQualityJobDefinitionModelQualityJobInputPropertyToCloudFormation(properties.modelQualityJobInput),
        ModelQualityJobOutputConfig: cfnModelQualityJobDefinitionMonitoringOutputConfigPropertyToCloudFormation(properties.modelQualityJobOutputConfig),
        RoleArn: cdk.stringToCloudFormation(properties.roleArn),
        EndpointName: cdk.stringToCloudFormation(properties.endpointName),
        JobDefinitionName: cdk.stringToCloudFormation(properties.jobDefinitionName),
        ModelQualityBaselineConfig: cfnModelQualityJobDefinitionModelQualityBaselineConfigPropertyToCloudFormation(properties.modelQualityBaselineConfig),
        NetworkConfig: cfnModelQualityJobDefinitionNetworkConfigPropertyToCloudFormation(properties.networkConfig),
        StoppingCondition: cfnModelQualityJobDefinitionStoppingConditionPropertyToCloudFormation(properties.stoppingCondition),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnModelQualityJobDefinitionPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('jobResources', 'JobResources', CfnModelQualityJobDefinitionMonitoringResourcesPropertyFromCloudFormation(properties.JobResources));
    ret.addPropertyResult('modelQualityAppSpecification', 'ModelQualityAppSpecification', CfnModelQualityJobDefinitionModelQualityAppSpecificationPropertyFromCloudFormation(properties.ModelQualityAppSpecification));
    ret.addPropertyResult('modelQualityJobInput', 'ModelQualityJobInput', CfnModelQualityJobDefinitionModelQualityJobInputPropertyFromCloudFormation(properties.ModelQualityJobInput));
    ret.addPropertyResult('modelQualityJobOutputConfig', 'ModelQualityJobOutputConfig', CfnModelQualityJobDefinitionMonitoringOutputConfigPropertyFromCloudFormation(properties.ModelQualityJobOutputConfig));
    ret.addPropertyResult('roleArn', 'RoleArn', cfn_parse.FromCloudFormation.getString(properties.RoleArn));
    ret.addPropertyResult('endpointName', 'EndpointName', properties.EndpointName != null ? cfn_parse.FromCloudFormation.getString(properties.EndpointName) : undefined);
    ret.addPropertyResult('jobDefinitionName', 'JobDefinitionName', properties.JobDefinitionName != null ? cfn_parse.FromCloudFormation.getString(properties.JobDefinitionName) : undefined);
    ret.addPropertyResult('modelQualityBaselineConfig', 'ModelQualityBaselineConfig', properties.ModelQualityBaselineConfig != null ? CfnModelQualityJobDefinitionModelQualityBaselineConfigPropertyFromCloudFormation(properties.ModelQualityBaselineConfig) : undefined);
    ret.addPropertyResult('networkConfig', 'NetworkConfig', properties.NetworkConfig != null ? CfnModelQualityJobDefinitionNetworkConfigPropertyFromCloudFormation(properties.NetworkConfig) : undefined);
    ret.addPropertyResult('stoppingCondition', 'StoppingCondition', properties.StoppingCondition != null ? CfnModelQualityJobDefinitionStoppingConditionPropertyFromCloudFormation(properties.StoppingCondition) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::SageMaker::ModelQualityJobDefinition`
 *
 * Creates a definition for a job that monitors model quality and drift. For information about model monitor, see [Amazon SageMaker Model Monitor](https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html) .
 *
 * @cloudformationResource AWS::SageMaker::ModelQualityJobDefinition
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html
 */
class CfnModelQualityJobDefinition extends cdk.CfnResource {
    /**
     * Create a new `AWS::SageMaker::ModelQualityJobDefinition`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnModelQualityJobDefinition.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_sagemaker_CfnModelQualityJobDefinitionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnModelQualityJobDefinition);
            }
            throw error;
        }
        cdk.requireProperty(props, 'jobResources', this);
        cdk.requireProperty(props, 'modelQualityAppSpecification', this);
        cdk.requireProperty(props, 'modelQualityJobInput', this);
        cdk.requireProperty(props, 'modelQualityJobOutputConfig', this);
        cdk.requireProperty(props, 'roleArn', this);
        this.attrCreationTime = cdk.Token.asString(this.getAtt('CreationTime'));
        this.attrJobDefinitionArn = cdk.Token.asString(this.getAtt('JobDefinitionArn'));
        this.jobResources = props.jobResources;
        this.modelQualityAppSpecification = props.modelQualityAppSpecification;
        this.modelQualityJobInput = props.modelQualityJobInput;
        this.modelQualityJobOutputConfig = props.modelQualityJobOutputConfig;
        this.roleArn = props.roleArn;
        this.endpointName = props.endpointName;
        this.jobDefinitionName = props.jobDefinitionName;
        this.modelQualityBaselineConfig = props.modelQualityBaselineConfig;
        this.networkConfig = props.networkConfig;
        this.stoppingCondition = props.stoppingCondition;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::SageMaker::ModelQualityJobDefinition", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnModelQualityJobDefinitionPropsFromCloudFormation(resourceProperties);
        const ret = new CfnModelQualityJobDefinition(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnModelQualityJobDefinition.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            jobResources: this.jobResources,
            modelQualityAppSpecification: this.modelQualityAppSpecification,
            modelQualityJobInput: this.modelQualityJobInput,
            modelQualityJobOutputConfig: this.modelQualityJobOutputConfig,
            roleArn: this.roleArn,
            endpointName: this.endpointName,
            jobDefinitionName: this.jobDefinitionName,
            modelQualityBaselineConfig: this.modelQualityBaselineConfig,
            networkConfig: this.networkConfig,
            stoppingCondition: this.stoppingCondition,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnModelQualityJobDefinitionPropsToCloudFormation(props);
    }
}
exports.CfnModelQualityJobDefinition = CfnModelQualityJobDefinition;
_t = JSII_RTTI_SYMBOL_1;
CfnModelQualityJobDefinition[_t] = { fqn: "@aws-cdk/aws-sagemaker.CfnModelQualityJobDefinition", version: "1.186.1" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnModelQualityJobDefinition.CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::ModelQualityJobDefinition";
/**
 * Determine whether the given properties match those of a `BatchTransformInputProperty`
 *
 * @param properties - the TypeScript properties of a `BatchTransformInputProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelQualityJobDefinition_BatchTransformInputPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dataCapturedDestinationS3Uri', cdk.requiredValidator)(properties.dataCapturedDestinationS3Uri));
    errors.collect(cdk.propertyValidator('dataCapturedDestinationS3Uri', cdk.validateString)(properties.dataCapturedDestinationS3Uri));
    errors.collect(cdk.propertyValidator('datasetFormat', cdk.requiredValidator)(properties.datasetFormat));
    errors.collect(cdk.propertyValidator('datasetFormat', CfnModelQualityJobDefinition_DatasetFormatPropertyValidator)(properties.datasetFormat));
    errors.collect(cdk.propertyValidator('endTimeOffset', cdk.validateString)(properties.endTimeOffset));
    errors.collect(cdk.propertyValidator('inferenceAttribute', cdk.validateString)(properties.inferenceAttribute));
    errors.collect(cdk.propertyValidator('localPath', cdk.requiredValidator)(properties.localPath));
    errors.collect(cdk.propertyValidator('localPath', cdk.validateString)(properties.localPath));
    errors.collect(cdk.propertyValidator('probabilityAttribute', cdk.validateString)(properties.probabilityAttribute));
    errors.collect(cdk.propertyValidator('probabilityThresholdAttribute', cdk.validateNumber)(properties.probabilityThresholdAttribute));
    errors.collect(cdk.propertyValidator('s3DataDistributionType', cdk.validateString)(properties.s3DataDistributionType));
    errors.collect(cdk.propertyValidator('s3InputMode', cdk.validateString)(properties.s3InputMode));
    errors.collect(cdk.propertyValidator('startTimeOffset', cdk.validateString)(properties.startTimeOffset));
    return errors.wrap('supplied properties not correct for "BatchTransformInputProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelQualityJobDefinition.BatchTransformInput` resource
 *
 * @param properties - the TypeScript properties of a `BatchTransformInputProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelQualityJobDefinition.BatchTransformInput` resource.
 */
// @ts-ignore TS6133
function cfnModelQualityJobDefinitionBatchTransformInputPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelQualityJobDefinition_BatchTransformInputPropertyValidator(properties).assertSuccess();
    return {
        DataCapturedDestinationS3Uri: cdk.stringToCloudFormation(properties.dataCapturedDestinationS3Uri),
        DatasetFormat: cfnModelQualityJobDefinitionDatasetFormatPropertyToCloudFormation(properties.datasetFormat),
        EndTimeOffset: cdk.stringToCloudFormation(properties.endTimeOffset),
        InferenceAttribute: cdk.stringToCloudFormation(properties.inferenceAttribute),
        LocalPath: cdk.stringToCloudFormation(properties.localPath),
        ProbabilityAttribute: cdk.stringToCloudFormation(properties.probabilityAttribute),
        ProbabilityThresholdAttribute: cdk.numberToCloudFormation(properties.probabilityThresholdAttribute),
        S3DataDistributionType: cdk.stringToCloudFormation(properties.s3DataDistributionType),
        S3InputMode: cdk.stringToCloudFormation(properties.s3InputMode),
        StartTimeOffset: cdk.stringToCloudFormation(properties.startTimeOffset),
    };
}
// @ts-ignore TS6133
function CfnModelQualityJobDefinitionBatchTransformInputPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dataCapturedDestinationS3Uri', 'DataCapturedDestinationS3Uri', cfn_parse.FromCloudFormation.getString(properties.DataCapturedDestinationS3Uri));
    ret.addPropertyResult('datasetFormat', 'DatasetFormat', CfnModelQualityJobDefinitionDatasetFormatPropertyFromCloudFormation(properties.DatasetFormat));
    ret.addPropertyResult('endTimeOffset', 'EndTimeOffset', properties.EndTimeOffset != null ? cfn_parse.FromCloudFormation.getString(properties.EndTimeOffset) : undefined);
    ret.addPropertyResult('inferenceAttribute', 'InferenceAttribute', properties.InferenceAttribute != null ? cfn_parse.FromCloudFormation.getString(properties.InferenceAttribute) : undefined);
    ret.addPropertyResult('localPath', 'LocalPath', cfn_parse.FromCloudFormation.getString(properties.LocalPath));
    ret.addPropertyResult('probabilityAttribute', 'ProbabilityAttribute', properties.ProbabilityAttribute != null ? cfn_parse.FromCloudFormation.getString(properties.ProbabilityAttribute) : undefined);
    ret.addPropertyResult('probabilityThresholdAttribute', 'ProbabilityThresholdAttribute', properties.ProbabilityThresholdAttribute != null ? cfn_parse.FromCloudFormation.getNumber(properties.ProbabilityThresholdAttribute) : undefined);
    ret.addPropertyResult('s3DataDistributionType', 'S3DataDistributionType', properties.S3DataDistributionType != null ? cfn_parse.FromCloudFormation.getString(properties.S3DataDistributionType) : undefined);
    ret.addPropertyResult('s3InputMode', 'S3InputMode', properties.S3InputMode != null ? cfn_parse.FromCloudFormation.getString(properties.S3InputMode) : undefined);
    ret.addPropertyResult('startTimeOffset', 'StartTimeOffset', properties.StartTimeOffset != null ? cfn_parse.FromCloudFormation.getString(properties.StartTimeOffset) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ClusterConfigProperty`
 *
 * @param properties - the TypeScript properties of a `ClusterConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelQualityJobDefinition_ClusterConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('instanceCount', cdk.requiredValidator)(properties.instanceCount));
    errors.collect(cdk.propertyValidator('instanceCount', cdk.validateNumber)(properties.instanceCount));
    errors.collect(cdk.propertyValidator('instanceType', cdk.requiredValidator)(properties.instanceType));
    errors.collect(cdk.propertyValidator('instanceType', cdk.validateString)(properties.instanceType));
    errors.collect(cdk.propertyValidator('volumeKmsKeyId', cdk.validateString)(properties.volumeKmsKeyId));
    errors.collect(cdk.propertyValidator('volumeSizeInGb', cdk.requiredValidator)(properties.volumeSizeInGb));
    errors.collect(cdk.propertyValidator('volumeSizeInGb', cdk.validateNumber)(properties.volumeSizeInGb));
    return errors.wrap('supplied properties not correct for "ClusterConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelQualityJobDefinition.ClusterConfig` resource
 *
 * @param properties - the TypeScript properties of a `ClusterConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelQualityJobDefinition.ClusterConfig` resource.
 */
// @ts-ignore TS6133
function cfnModelQualityJobDefinitionClusterConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelQualityJobDefinition_ClusterConfigPropertyValidator(properties).assertSuccess();
    return {
        InstanceCount: cdk.numberToCloudFormation(properties.instanceCount),
        InstanceType: cdk.stringToCloudFormation(properties.instanceType),
        VolumeKmsKeyId: cdk.stringToCloudFormation(properties.volumeKmsKeyId),
        VolumeSizeInGB: cdk.numberToCloudFormation(properties.volumeSizeInGb),
    };
}
// @ts-ignore TS6133
function CfnModelQualityJobDefinitionClusterConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('instanceCount', 'InstanceCount', cfn_parse.FromCloudFormation.getNumber(properties.InstanceCount));
    ret.addPropertyResult('instanceType', 'InstanceType', cfn_parse.FromCloudFormation.getString(properties.InstanceType));
    ret.addPropertyResult('volumeKmsKeyId', 'VolumeKmsKeyId', properties.VolumeKmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.VolumeKmsKeyId) : undefined);
    ret.addPropertyResult('volumeSizeInGb', 'VolumeSizeInGB', cfn_parse.FromCloudFormation.getNumber(properties.VolumeSizeInGB));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ConstraintsResourceProperty`
 *
 * @param properties - the TypeScript properties of a `ConstraintsResourceProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelQualityJobDefinition_ConstraintsResourcePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('s3Uri', cdk.validateString)(properties.s3Uri));
    return errors.wrap('supplied properties not correct for "ConstraintsResourceProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelQualityJobDefinition.ConstraintsResource` resource
 *
 * @param properties - the TypeScript properties of a `ConstraintsResourceProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelQualityJobDefinition.ConstraintsResource` resource.
 */
// @ts-ignore TS6133
function cfnModelQualityJobDefinitionConstraintsResourcePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelQualityJobDefinition_ConstraintsResourcePropertyValidator(properties).assertSuccess();
    return {
        S3Uri: cdk.stringToCloudFormation(properties.s3Uri),
    };
}
// @ts-ignore TS6133
function CfnModelQualityJobDefinitionConstraintsResourcePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('s3Uri', 'S3Uri', properties.S3Uri != null ? cfn_parse.FromCloudFormation.getString(properties.S3Uri) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CsvProperty`
 *
 * @param properties - the TypeScript properties of a `CsvProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelQualityJobDefinition_CsvPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('header', cdk.validateBoolean)(properties.header));
    return errors.wrap('supplied properties not correct for "CsvProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelQualityJobDefinition.Csv` resource
 *
 * @param properties - the TypeScript properties of a `CsvProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelQualityJobDefinition.Csv` resource.
 */
// @ts-ignore TS6133
function cfnModelQualityJobDefinitionCsvPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelQualityJobDefinition_CsvPropertyValidator(properties).assertSuccess();
    return {
        Header: cdk.booleanToCloudFormation(properties.header),
    };
}
// @ts-ignore TS6133
function CfnModelQualityJobDefinitionCsvPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('header', 'Header', properties.Header != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Header) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DatasetFormatProperty`
 *
 * @param properties - the TypeScript properties of a `DatasetFormatProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelQualityJobDefinition_DatasetFormatPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('csv', CfnModelQualityJobDefinition_CsvPropertyValidator)(properties.csv));
    errors.collect(cdk.propertyValidator('json', cdk.validateObject)(properties.json));
    errors.collect(cdk.propertyValidator('parquet', cdk.validateBoolean)(properties.parquet));
    return errors.wrap('supplied properties not correct for "DatasetFormatProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelQualityJobDefinition.DatasetFormat` resource
 *
 * @param properties - the TypeScript properties of a `DatasetFormatProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelQualityJobDefinition.DatasetFormat` resource.
 */
// @ts-ignore TS6133
function cfnModelQualityJobDefinitionDatasetFormatPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelQualityJobDefinition_DatasetFormatPropertyValidator(properties).assertSuccess();
    return {
        Csv: cfnModelQualityJobDefinitionCsvPropertyToCloudFormation(properties.csv),
        Json: cdk.objectToCloudFormation(properties.json),
        Parquet: cdk.booleanToCloudFormation(properties.parquet),
    };
}
// @ts-ignore TS6133
function CfnModelQualityJobDefinitionDatasetFormatPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('csv', 'Csv', properties.Csv != null ? CfnModelQualityJobDefinitionCsvPropertyFromCloudFormation(properties.Csv) : undefined);
    ret.addPropertyResult('json', 'Json', properties.Json != null ? cfn_parse.FromCloudFormation.getAny(properties.Json) : undefined);
    ret.addPropertyResult('parquet', 'Parquet', properties.Parquet != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Parquet) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `EndpointInputProperty`
 *
 * @param properties - the TypeScript properties of a `EndpointInputProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelQualityJobDefinition_EndpointInputPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('endTimeOffset', cdk.validateString)(properties.endTimeOffset));
    errors.collect(cdk.propertyValidator('endpointName', cdk.requiredValidator)(properties.endpointName));
    errors.collect(cdk.propertyValidator('endpointName', cdk.validateString)(properties.endpointName));
    errors.collect(cdk.propertyValidator('inferenceAttribute', cdk.validateString)(properties.inferenceAttribute));
    errors.collect(cdk.propertyValidator('localPath', cdk.requiredValidator)(properties.localPath));
    errors.collect(cdk.propertyValidator('localPath', cdk.validateString)(properties.localPath));
    errors.collect(cdk.propertyValidator('probabilityAttribute', cdk.validateString)(properties.probabilityAttribute));
    errors.collect(cdk.propertyValidator('probabilityThresholdAttribute', cdk.validateNumber)(properties.probabilityThresholdAttribute));
    errors.collect(cdk.propertyValidator('s3DataDistributionType', cdk.validateString)(properties.s3DataDistributionType));
    errors.collect(cdk.propertyValidator('s3InputMode', cdk.validateString)(properties.s3InputMode));
    errors.collect(cdk.propertyValidator('startTimeOffset', cdk.validateString)(properties.startTimeOffset));
    return errors.wrap('supplied properties not correct for "EndpointInputProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelQualityJobDefinition.EndpointInput` resource
 *
 * @param properties - the TypeScript properties of a `EndpointInputProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelQualityJobDefinition.EndpointInput` resource.
 */
// @ts-ignore TS6133
function cfnModelQualityJobDefinitionEndpointInputPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelQualityJobDefinition_EndpointInputPropertyValidator(properties).assertSuccess();
    return {
        EndTimeOffset: cdk.stringToCloudFormation(properties.endTimeOffset),
        EndpointName: cdk.stringToCloudFormation(properties.endpointName),
        InferenceAttribute: cdk.stringToCloudFormation(properties.inferenceAttribute),
        LocalPath: cdk.stringToCloudFormation(properties.localPath),
        ProbabilityAttribute: cdk.stringToCloudFormation(properties.probabilityAttribute),
        ProbabilityThresholdAttribute: cdk.numberToCloudFormation(properties.probabilityThresholdAttribute),
        S3DataDistributionType: cdk.stringToCloudFormation(properties.s3DataDistributionType),
        S3InputMode: cdk.stringToCloudFormation(properties.s3InputMode),
        StartTimeOffset: cdk.stringToCloudFormation(properties.startTimeOffset),
    };
}
// @ts-ignore TS6133
function CfnModelQualityJobDefinitionEndpointInputPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('endTimeOffset', 'EndTimeOffset', properties.EndTimeOffset != null ? cfn_parse.FromCloudFormation.getString(properties.EndTimeOffset) : undefined);
    ret.addPropertyResult('endpointName', 'EndpointName', cfn_parse.FromCloudFormation.getString(properties.EndpointName));
    ret.addPropertyResult('inferenceAttribute', 'InferenceAttribute', properties.InferenceAttribute != null ? cfn_parse.FromCloudFormation.getString(properties.InferenceAttribute) : undefined);
    ret.addPropertyResult('localPath', 'LocalPath', cfn_parse.FromCloudFormation.getString(properties.LocalPath));
    ret.addPropertyResult('probabilityAttribute', 'ProbabilityAttribute', properties.ProbabilityAttribute != null ? cfn_parse.FromCloudFormation.getString(properties.ProbabilityAttribute) : undefined);
    ret.addPropertyResult('probabilityThresholdAttribute', 'ProbabilityThresholdAttribute', properties.ProbabilityThresholdAttribute != null ? cfn_parse.FromCloudFormation.getNumber(properties.ProbabilityThresholdAttribute) : undefined);
    ret.addPropertyResult('s3DataDistributionType', 'S3DataDistributionType', properties.S3DataDistributionType != null ? cfn_parse.FromCloudFormation.getString(properties.S3DataDistributionType) : undefined);
    ret.addPropertyResult('s3InputMode', 'S3InputMode', properties.S3InputMode != null ? cfn_parse.FromCloudFormation.getString(properties.S3InputMode) : undefined);
    ret.addPropertyResult('startTimeOffset', 'StartTimeOffset', properties.StartTimeOffset != null ? cfn_parse.FromCloudFormation.getString(properties.StartTimeOffset) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `JsonProperty`
 *
 * @param properties - the TypeScript properties of a `JsonProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelQualityJobDefinition_JsonPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('line', cdk.validateBoolean)(properties.line));
    return errors.wrap('supplied properties not correct for "JsonProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelQualityJobDefinition.Json` resource
 *
 * @param properties - the TypeScript properties of a `JsonProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelQualityJobDefinition.Json` resource.
 */
// @ts-ignore TS6133
function cfnModelQualityJobDefinitionJsonPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelQualityJobDefinition_JsonPropertyValidator(properties).assertSuccess();
    return {
        Line: cdk.booleanToCloudFormation(properties.line),
    };
}
// @ts-ignore TS6133
function CfnModelQualityJobDefinitionJsonPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('line', 'Line', properties.Line != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Line) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ModelQualityAppSpecificationProperty`
 *
 * @param properties - the TypeScript properties of a `ModelQualityAppSpecificationProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelQualityJobDefinition_ModelQualityAppSpecificationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('containerArguments', cdk.listValidator(cdk.validateString))(properties.containerArguments));
    errors.collect(cdk.propertyValidator('containerEntrypoint', cdk.listValidator(cdk.validateString))(properties.containerEntrypoint));
    errors.collect(cdk.propertyValidator('environment', cdk.hashValidator(cdk.validateString))(properties.environment));
    errors.collect(cdk.propertyValidator('imageUri', cdk.requiredValidator)(properties.imageUri));
    errors.collect(cdk.propertyValidator('imageUri', cdk.validateString)(properties.imageUri));
    errors.collect(cdk.propertyValidator('postAnalyticsProcessorSourceUri', cdk.validateString)(properties.postAnalyticsProcessorSourceUri));
    errors.collect(cdk.propertyValidator('problemType', cdk.requiredValidator)(properties.problemType));
    errors.collect(cdk.propertyValidator('problemType', cdk.validateString)(properties.problemType));
    errors.collect(cdk.propertyValidator('recordPreprocessorSourceUri', cdk.validateString)(properties.recordPreprocessorSourceUri));
    return errors.wrap('supplied properties not correct for "ModelQualityAppSpecificationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelQualityJobDefinition.ModelQualityAppSpecification` resource
 *
 * @param properties - the TypeScript properties of a `ModelQualityAppSpecificationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelQualityJobDefinition.ModelQualityAppSpecification` resource.
 */
// @ts-ignore TS6133
function cfnModelQualityJobDefinitionModelQualityAppSpecificationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelQualityJobDefinition_ModelQualityAppSpecificationPropertyValidator(properties).assertSuccess();
    return {
        ContainerArguments: cdk.listMapper(cdk.stringToCloudFormation)(properties.containerArguments),
        ContainerEntrypoint: cdk.listMapper(cdk.stringToCloudFormation)(properties.containerEntrypoint),
        Environment: cdk.hashMapper(cdk.stringToCloudFormation)(properties.environment),
        ImageUri: cdk.stringToCloudFormation(properties.imageUri),
        PostAnalyticsProcessorSourceUri: cdk.stringToCloudFormation(properties.postAnalyticsProcessorSourceUri),
        ProblemType: cdk.stringToCloudFormation(properties.problemType),
        RecordPreprocessorSourceUri: cdk.stringToCloudFormation(properties.recordPreprocessorSourceUri),
    };
}
// @ts-ignore TS6133
function CfnModelQualityJobDefinitionModelQualityAppSpecificationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('containerArguments', 'ContainerArguments', properties.ContainerArguments != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ContainerArguments) : undefined);
    ret.addPropertyResult('containerEntrypoint', 'ContainerEntrypoint', properties.ContainerEntrypoint != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ContainerEntrypoint) : undefined);
    ret.addPropertyResult('environment', 'Environment', properties.Environment != null ? cfn_parse.FromCloudFormation.getMap(cfn_parse.FromCloudFormation.getString)(properties.Environment) : undefined);
    ret.addPropertyResult('imageUri', 'ImageUri', cfn_parse.FromCloudFormation.getString(properties.ImageUri));
    ret.addPropertyResult('postAnalyticsProcessorSourceUri', 'PostAnalyticsProcessorSourceUri', properties.PostAnalyticsProcessorSourceUri != null ? cfn_parse.FromCloudFormation.getString(properties.PostAnalyticsProcessorSourceUri) : undefined);
    ret.addPropertyResult('problemType', 'ProblemType', cfn_parse.FromCloudFormation.getString(properties.ProblemType));
    ret.addPropertyResult('recordPreprocessorSourceUri', 'RecordPreprocessorSourceUri', properties.RecordPreprocessorSourceUri != null ? cfn_parse.FromCloudFormation.getString(properties.RecordPreprocessorSourceUri) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ModelQualityBaselineConfigProperty`
 *
 * @param properties - the TypeScript properties of a `ModelQualityBaselineConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelQualityJobDefinition_ModelQualityBaselineConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('baseliningJobName', cdk.validateString)(properties.baseliningJobName));
    errors.collect(cdk.propertyValidator('constraintsResource', CfnModelQualityJobDefinition_ConstraintsResourcePropertyValidator)(properties.constraintsResource));
    return errors.wrap('supplied properties not correct for "ModelQualityBaselineConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelQualityJobDefinition.ModelQualityBaselineConfig` resource
 *
 * @param properties - the TypeScript properties of a `ModelQualityBaselineConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelQualityJobDefinition.ModelQualityBaselineConfig` resource.
 */
// @ts-ignore TS6133
function cfnModelQualityJobDefinitionModelQualityBaselineConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelQualityJobDefinition_ModelQualityBaselineConfigPropertyValidator(properties).assertSuccess();
    return {
        BaseliningJobName: cdk.stringToCloudFormation(properties.baseliningJobName),
        ConstraintsResource: cfnModelQualityJobDefinitionConstraintsResourcePropertyToCloudFormation(properties.constraintsResource),
    };
}
// @ts-ignore TS6133
function CfnModelQualityJobDefinitionModelQualityBaselineConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('baseliningJobName', 'BaseliningJobName', properties.BaseliningJobName != null ? cfn_parse.FromCloudFormation.getString(properties.BaseliningJobName) : undefined);
    ret.addPropertyResult('constraintsResource', 'ConstraintsResource', properties.ConstraintsResource != null ? CfnModelQualityJobDefinitionConstraintsResourcePropertyFromCloudFormation(properties.ConstraintsResource) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ModelQualityJobInputProperty`
 *
 * @param properties - the TypeScript properties of a `ModelQualityJobInputProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelQualityJobDefinition_ModelQualityJobInputPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('batchTransformInput', CfnModelQualityJobDefinition_BatchTransformInputPropertyValidator)(properties.batchTransformInput));
    errors.collect(cdk.propertyValidator('endpointInput', CfnModelQualityJobDefinition_EndpointInputPropertyValidator)(properties.endpointInput));
    errors.collect(cdk.propertyValidator('groundTruthS3Input', cdk.requiredValidator)(properties.groundTruthS3Input));
    errors.collect(cdk.propertyValidator('groundTruthS3Input', CfnModelQualityJobDefinition_MonitoringGroundTruthS3InputPropertyValidator)(properties.groundTruthS3Input));
    return errors.wrap('supplied properties not correct for "ModelQualityJobInputProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelQualityJobDefinition.ModelQualityJobInput` resource
 *
 * @param properties - the TypeScript properties of a `ModelQualityJobInputProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelQualityJobDefinition.ModelQualityJobInput` resource.
 */
// @ts-ignore TS6133
function cfnModelQualityJobDefinitionModelQualityJobInputPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelQualityJobDefinition_ModelQualityJobInputPropertyValidator(properties).assertSuccess();
    return {
        BatchTransformInput: cfnModelQualityJobDefinitionBatchTransformInputPropertyToCloudFormation(properties.batchTransformInput),
        EndpointInput: cfnModelQualityJobDefinitionEndpointInputPropertyToCloudFormation(properties.endpointInput),
        GroundTruthS3Input: cfnModelQualityJobDefinitionMonitoringGroundTruthS3InputPropertyToCloudFormation(properties.groundTruthS3Input),
    };
}
// @ts-ignore TS6133
function CfnModelQualityJobDefinitionModelQualityJobInputPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('batchTransformInput', 'BatchTransformInput', properties.BatchTransformInput != null ? CfnModelQualityJobDefinitionBatchTransformInputPropertyFromCloudFormation(properties.BatchTransformInput) : undefined);
    ret.addPropertyResult('endpointInput', 'EndpointInput', properties.EndpointInput != null ? CfnModelQualityJobDefinitionEndpointInputPropertyFromCloudFormation(properties.EndpointInput) : undefined);
    ret.addPropertyResult('groundTruthS3Input', 'GroundTruthS3Input', CfnModelQualityJobDefinitionMonitoringGroundTruthS3InputPropertyFromCloudFormation(properties.GroundTruthS3Input));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MonitoringGroundTruthS3InputProperty`
 *
 * @param properties - the TypeScript properties of a `MonitoringGroundTruthS3InputProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelQualityJobDefinition_MonitoringGroundTruthS3InputPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('s3Uri', cdk.requiredValidator)(properties.s3Uri));
    errors.collect(cdk.propertyValidator('s3Uri', cdk.validateString)(properties.s3Uri));
    return errors.wrap('supplied properties not correct for "MonitoringGroundTruthS3InputProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelQualityJobDefinition.MonitoringGroundTruthS3Input` resource
 *
 * @param properties - the TypeScript properties of a `MonitoringGroundTruthS3InputProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelQualityJobDefinition.MonitoringGroundTruthS3Input` resource.
 */
// @ts-ignore TS6133
function cfnModelQualityJobDefinitionMonitoringGroundTruthS3InputPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelQualityJobDefinition_MonitoringGroundTruthS3InputPropertyValidator(properties).assertSuccess();
    return {
        S3Uri: cdk.stringToCloudFormation(properties.s3Uri),
    };
}
// @ts-ignore TS6133
function CfnModelQualityJobDefinitionMonitoringGroundTruthS3InputPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('s3Uri', 'S3Uri', cfn_parse.FromCloudFormation.getString(properties.S3Uri));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MonitoringOutputProperty`
 *
 * @param properties - the TypeScript properties of a `MonitoringOutputProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelQualityJobDefinition_MonitoringOutputPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('s3Output', cdk.requiredValidator)(properties.s3Output));
    errors.collect(cdk.propertyValidator('s3Output', CfnModelQualityJobDefinition_S3OutputPropertyValidator)(properties.s3Output));
    return errors.wrap('supplied properties not correct for "MonitoringOutputProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelQualityJobDefinition.MonitoringOutput` resource
 *
 * @param properties - the TypeScript properties of a `MonitoringOutputProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelQualityJobDefinition.MonitoringOutput` resource.
 */
// @ts-ignore TS6133
function cfnModelQualityJobDefinitionMonitoringOutputPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelQualityJobDefinition_MonitoringOutputPropertyValidator(properties).assertSuccess();
    return {
        S3Output: cfnModelQualityJobDefinitionS3OutputPropertyToCloudFormation(properties.s3Output),
    };
}
// @ts-ignore TS6133
function CfnModelQualityJobDefinitionMonitoringOutputPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('s3Output', 'S3Output', CfnModelQualityJobDefinitionS3OutputPropertyFromCloudFormation(properties.S3Output));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MonitoringOutputConfigProperty`
 *
 * @param properties - the TypeScript properties of a `MonitoringOutputConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelQualityJobDefinition_MonitoringOutputConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('kmsKeyId', cdk.validateString)(properties.kmsKeyId));
    errors.collect(cdk.propertyValidator('monitoringOutputs', cdk.requiredValidator)(properties.monitoringOutputs));
    errors.collect(cdk.propertyValidator('monitoringOutputs', cdk.listValidator(CfnModelQualityJobDefinition_MonitoringOutputPropertyValidator))(properties.monitoringOutputs));
    return errors.wrap('supplied properties not correct for "MonitoringOutputConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelQualityJobDefinition.MonitoringOutputConfig` resource
 *
 * @param properties - the TypeScript properties of a `MonitoringOutputConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelQualityJobDefinition.MonitoringOutputConfig` resource.
 */
// @ts-ignore TS6133
function cfnModelQualityJobDefinitionMonitoringOutputConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelQualityJobDefinition_MonitoringOutputConfigPropertyValidator(properties).assertSuccess();
    return {
        KmsKeyId: cdk.stringToCloudFormation(properties.kmsKeyId),
        MonitoringOutputs: cdk.listMapper(cfnModelQualityJobDefinitionMonitoringOutputPropertyToCloudFormation)(properties.monitoringOutputs),
    };
}
// @ts-ignore TS6133
function CfnModelQualityJobDefinitionMonitoringOutputConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('kmsKeyId', 'KmsKeyId', properties.KmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.KmsKeyId) : undefined);
    ret.addPropertyResult('monitoringOutputs', 'MonitoringOutputs', cfn_parse.FromCloudFormation.getArray(CfnModelQualityJobDefinitionMonitoringOutputPropertyFromCloudFormation)(properties.MonitoringOutputs));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MonitoringResourcesProperty`
 *
 * @param properties - the TypeScript properties of a `MonitoringResourcesProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelQualityJobDefinition_MonitoringResourcesPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('clusterConfig', cdk.requiredValidator)(properties.clusterConfig));
    errors.collect(cdk.propertyValidator('clusterConfig', CfnModelQualityJobDefinition_ClusterConfigPropertyValidator)(properties.clusterConfig));
    return errors.wrap('supplied properties not correct for "MonitoringResourcesProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelQualityJobDefinition.MonitoringResources` resource
 *
 * @param properties - the TypeScript properties of a `MonitoringResourcesProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelQualityJobDefinition.MonitoringResources` resource.
 */
// @ts-ignore TS6133
function cfnModelQualityJobDefinitionMonitoringResourcesPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelQualityJobDefinition_MonitoringResourcesPropertyValidator(properties).assertSuccess();
    return {
        ClusterConfig: cfnModelQualityJobDefinitionClusterConfigPropertyToCloudFormation(properties.clusterConfig),
    };
}
// @ts-ignore TS6133
function CfnModelQualityJobDefinitionMonitoringResourcesPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('clusterConfig', 'ClusterConfig', CfnModelQualityJobDefinitionClusterConfigPropertyFromCloudFormation(properties.ClusterConfig));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `NetworkConfigProperty`
 *
 * @param properties - the TypeScript properties of a `NetworkConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelQualityJobDefinition_NetworkConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('enableInterContainerTrafficEncryption', cdk.validateBoolean)(properties.enableInterContainerTrafficEncryption));
    errors.collect(cdk.propertyValidator('enableNetworkIsolation', cdk.validateBoolean)(properties.enableNetworkIsolation));
    errors.collect(cdk.propertyValidator('vpcConfig', CfnModelQualityJobDefinition_VpcConfigPropertyValidator)(properties.vpcConfig));
    return errors.wrap('supplied properties not correct for "NetworkConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelQualityJobDefinition.NetworkConfig` resource
 *
 * @param properties - the TypeScript properties of a `NetworkConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelQualityJobDefinition.NetworkConfig` resource.
 */
// @ts-ignore TS6133
function cfnModelQualityJobDefinitionNetworkConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelQualityJobDefinition_NetworkConfigPropertyValidator(properties).assertSuccess();
    return {
        EnableInterContainerTrafficEncryption: cdk.booleanToCloudFormation(properties.enableInterContainerTrafficEncryption),
        EnableNetworkIsolation: cdk.booleanToCloudFormation(properties.enableNetworkIsolation),
        VpcConfig: cfnModelQualityJobDefinitionVpcConfigPropertyToCloudFormation(properties.vpcConfig),
    };
}
// @ts-ignore TS6133
function CfnModelQualityJobDefinitionNetworkConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('enableInterContainerTrafficEncryption', 'EnableInterContainerTrafficEncryption', properties.EnableInterContainerTrafficEncryption != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EnableInterContainerTrafficEncryption) : undefined);
    ret.addPropertyResult('enableNetworkIsolation', 'EnableNetworkIsolation', properties.EnableNetworkIsolation != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EnableNetworkIsolation) : undefined);
    ret.addPropertyResult('vpcConfig', 'VpcConfig', properties.VpcConfig != null ? CfnModelQualityJobDefinitionVpcConfigPropertyFromCloudFormation(properties.VpcConfig) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `S3OutputProperty`
 *
 * @param properties - the TypeScript properties of a `S3OutputProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelQualityJobDefinition_S3OutputPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('localPath', cdk.requiredValidator)(properties.localPath));
    errors.collect(cdk.propertyValidator('localPath', cdk.validateString)(properties.localPath));
    errors.collect(cdk.propertyValidator('s3UploadMode', cdk.validateString)(properties.s3UploadMode));
    errors.collect(cdk.propertyValidator('s3Uri', cdk.requiredValidator)(properties.s3Uri));
    errors.collect(cdk.propertyValidator('s3Uri', cdk.validateString)(properties.s3Uri));
    return errors.wrap('supplied properties not correct for "S3OutputProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelQualityJobDefinition.S3Output` resource
 *
 * @param properties - the TypeScript properties of a `S3OutputProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelQualityJobDefinition.S3Output` resource.
 */
// @ts-ignore TS6133
function cfnModelQualityJobDefinitionS3OutputPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelQualityJobDefinition_S3OutputPropertyValidator(properties).assertSuccess();
    return {
        LocalPath: cdk.stringToCloudFormation(properties.localPath),
        S3UploadMode: cdk.stringToCloudFormation(properties.s3UploadMode),
        S3Uri: cdk.stringToCloudFormation(properties.s3Uri),
    };
}
// @ts-ignore TS6133
function CfnModelQualityJobDefinitionS3OutputPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('localPath', 'LocalPath', cfn_parse.FromCloudFormation.getString(properties.LocalPath));
    ret.addPropertyResult('s3UploadMode', 'S3UploadMode', properties.S3UploadMode != null ? cfn_parse.FromCloudFormation.getString(properties.S3UploadMode) : undefined);
    ret.addPropertyResult('s3Uri', 'S3Uri', cfn_parse.FromCloudFormation.getString(properties.S3Uri));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `StoppingConditionProperty`
 *
 * @param properties - the TypeScript properties of a `StoppingConditionProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelQualityJobDefinition_StoppingConditionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('maxRuntimeInSeconds', cdk.requiredValidator)(properties.maxRuntimeInSeconds));
    errors.collect(cdk.propertyValidator('maxRuntimeInSeconds', cdk.validateNumber)(properties.maxRuntimeInSeconds));
    return errors.wrap('supplied properties not correct for "StoppingConditionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelQualityJobDefinition.StoppingCondition` resource
 *
 * @param properties - the TypeScript properties of a `StoppingConditionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelQualityJobDefinition.StoppingCondition` resource.
 */
// @ts-ignore TS6133
function cfnModelQualityJobDefinitionStoppingConditionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelQualityJobDefinition_StoppingConditionPropertyValidator(properties).assertSuccess();
    return {
        MaxRuntimeInSeconds: cdk.numberToCloudFormation(properties.maxRuntimeInSeconds),
    };
}
// @ts-ignore TS6133
function CfnModelQualityJobDefinitionStoppingConditionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('maxRuntimeInSeconds', 'MaxRuntimeInSeconds', cfn_parse.FromCloudFormation.getNumber(properties.MaxRuntimeInSeconds));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `VpcConfigProperty`
 *
 * @param properties - the TypeScript properties of a `VpcConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnModelQualityJobDefinition_VpcConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('securityGroupIds', cdk.requiredValidator)(properties.securityGroupIds));
    errors.collect(cdk.propertyValidator('securityGroupIds', cdk.listValidator(cdk.validateString))(properties.securityGroupIds));
    errors.collect(cdk.propertyValidator('subnets', cdk.requiredValidator)(properties.subnets));
    errors.collect(cdk.propertyValidator('subnets', cdk.listValidator(cdk.validateString))(properties.subnets));
    return errors.wrap('supplied properties not correct for "VpcConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::ModelQualityJobDefinition.VpcConfig` resource
 *
 * @param properties - the TypeScript properties of a `VpcConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::ModelQualityJobDefinition.VpcConfig` resource.
 */
// @ts-ignore TS6133
function cfnModelQualityJobDefinitionVpcConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnModelQualityJobDefinition_VpcConfigPropertyValidator(properties).assertSuccess();
    return {
        SecurityGroupIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.securityGroupIds),
        Subnets: cdk.listMapper(cdk.stringToCloudFormation)(properties.subnets),
    };
}
// @ts-ignore TS6133
function CfnModelQualityJobDefinitionVpcConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('securityGroupIds', 'SecurityGroupIds', cfn_parse.FromCloudFormation.getStringArray(properties.SecurityGroupIds));
    ret.addPropertyResult('subnets', 'Subnets', cfn_parse.FromCloudFormation.getStringArray(properties.Subnets));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnMonitoringScheduleProps`
 *
 * @param properties - the TypeScript properties of a `CfnMonitoringScheduleProps`
 *
 * @returns the result of the validation.
 */
function CfnMonitoringSchedulePropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('endpointName', cdk.validateString)(properties.endpointName));
    errors.collect(cdk.propertyValidator('failureReason', cdk.validateString)(properties.failureReason));
    errors.collect(cdk.propertyValidator('lastMonitoringExecutionSummary', CfnMonitoringSchedule_MonitoringExecutionSummaryPropertyValidator)(properties.lastMonitoringExecutionSummary));
    errors.collect(cdk.propertyValidator('monitoringScheduleConfig', cdk.requiredValidator)(properties.monitoringScheduleConfig));
    errors.collect(cdk.propertyValidator('monitoringScheduleConfig', CfnMonitoringSchedule_MonitoringScheduleConfigPropertyValidator)(properties.monitoringScheduleConfig));
    errors.collect(cdk.propertyValidator('monitoringScheduleName', cdk.requiredValidator)(properties.monitoringScheduleName));
    errors.collect(cdk.propertyValidator('monitoringScheduleName', cdk.validateString)(properties.monitoringScheduleName));
    errors.collect(cdk.propertyValidator('monitoringScheduleStatus', cdk.validateString)(properties.monitoringScheduleStatus));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnMonitoringScheduleProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::MonitoringSchedule` resource
 *
 * @param properties - the TypeScript properties of a `CfnMonitoringScheduleProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::MonitoringSchedule` resource.
 */
// @ts-ignore TS6133
function cfnMonitoringSchedulePropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMonitoringSchedulePropsValidator(properties).assertSuccess();
    return {
        MonitoringScheduleConfig: cfnMonitoringScheduleMonitoringScheduleConfigPropertyToCloudFormation(properties.monitoringScheduleConfig),
        MonitoringScheduleName: cdk.stringToCloudFormation(properties.monitoringScheduleName),
        EndpointName: cdk.stringToCloudFormation(properties.endpointName),
        FailureReason: cdk.stringToCloudFormation(properties.failureReason),
        LastMonitoringExecutionSummary: cfnMonitoringScheduleMonitoringExecutionSummaryPropertyToCloudFormation(properties.lastMonitoringExecutionSummary),
        MonitoringScheduleStatus: cdk.stringToCloudFormation(properties.monitoringScheduleStatus),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnMonitoringSchedulePropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('monitoringScheduleConfig', 'MonitoringScheduleConfig', CfnMonitoringScheduleMonitoringScheduleConfigPropertyFromCloudFormation(properties.MonitoringScheduleConfig));
    ret.addPropertyResult('monitoringScheduleName', 'MonitoringScheduleName', cfn_parse.FromCloudFormation.getString(properties.MonitoringScheduleName));
    ret.addPropertyResult('endpointName', 'EndpointName', properties.EndpointName != null ? cfn_parse.FromCloudFormation.getString(properties.EndpointName) : undefined);
    ret.addPropertyResult('failureReason', 'FailureReason', properties.FailureReason != null ? cfn_parse.FromCloudFormation.getString(properties.FailureReason) : undefined);
    ret.addPropertyResult('lastMonitoringExecutionSummary', 'LastMonitoringExecutionSummary', properties.LastMonitoringExecutionSummary != null ? CfnMonitoringScheduleMonitoringExecutionSummaryPropertyFromCloudFormation(properties.LastMonitoringExecutionSummary) : undefined);
    ret.addPropertyResult('monitoringScheduleStatus', 'MonitoringScheduleStatus', properties.MonitoringScheduleStatus != null ? cfn_parse.FromCloudFormation.getString(properties.MonitoringScheduleStatus) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`
 *
 * The `AWS::SageMaker::MonitoringSchedule` resource is an Amazon SageMaker resource type that regularly starts SageMaker processing Jobs to monitor the data captured for a SageMaker endpoint.
 *
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 */
class CfnMonitoringSchedule extends cdk.CfnResource {
    /**
     * Create a new `AWS::SageMaker::MonitoringSchedule`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnMonitoringSchedule.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_sagemaker_CfnMonitoringScheduleProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnMonitoringSchedule);
            }
            throw error;
        }
        cdk.requireProperty(props, 'monitoringScheduleConfig', this);
        cdk.requireProperty(props, 'monitoringScheduleName', this);
        this.attrCreationTime = cdk.Token.asString(this.getAtt('CreationTime'));
        this.attrLastModifiedTime = cdk.Token.asString(this.getAtt('LastModifiedTime'));
        this.attrMonitoringScheduleArn = cdk.Token.asString(this.getAtt('MonitoringScheduleArn'));
        this.monitoringScheduleConfig = props.monitoringScheduleConfig;
        this.monitoringScheduleName = props.monitoringScheduleName;
        this.endpointName = props.endpointName;
        this.failureReason = props.failureReason;
        this.lastMonitoringExecutionSummary = props.lastMonitoringExecutionSummary;
        this.monitoringScheduleStatus = props.monitoringScheduleStatus;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::SageMaker::MonitoringSchedule", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnMonitoringSchedulePropsFromCloudFormation(resourceProperties);
        const ret = new CfnMonitoringSchedule(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnMonitoringSchedule.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            monitoringScheduleConfig: this.monitoringScheduleConfig,
            monitoringScheduleName: this.monitoringScheduleName,
            endpointName: this.endpointName,
            failureReason: this.failureReason,
            lastMonitoringExecutionSummary: this.lastMonitoringExecutionSummary,
            monitoringScheduleStatus: this.monitoringScheduleStatus,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnMonitoringSchedulePropsToCloudFormation(props);
    }
}
exports.CfnMonitoringSchedule = CfnMonitoringSchedule;
_u = JSII_RTTI_SYMBOL_1;
CfnMonitoringSchedule[_u] = { fqn: "@aws-cdk/aws-sagemaker.CfnMonitoringSchedule", version: "1.186.1" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnMonitoringSchedule.CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::MonitoringSchedule";
/**
 * Determine whether the given properties match those of a `BaselineConfigProperty`
 *
 * @param properties - the TypeScript properties of a `BaselineConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnMonitoringSchedule_BaselineConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('constraintsResource', CfnMonitoringSchedule_ConstraintsResourcePropertyValidator)(properties.constraintsResource));
    errors.collect(cdk.propertyValidator('statisticsResource', CfnMonitoringSchedule_StatisticsResourcePropertyValidator)(properties.statisticsResource));
    return errors.wrap('supplied properties not correct for "BaselineConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::MonitoringSchedule.BaselineConfig` resource
 *
 * @param properties - the TypeScript properties of a `BaselineConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::MonitoringSchedule.BaselineConfig` resource.
 */
// @ts-ignore TS6133
function cfnMonitoringScheduleBaselineConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMonitoringSchedule_BaselineConfigPropertyValidator(properties).assertSuccess();
    return {
        ConstraintsResource: cfnMonitoringScheduleConstraintsResourcePropertyToCloudFormation(properties.constraintsResource),
        StatisticsResource: cfnMonitoringScheduleStatisticsResourcePropertyToCloudFormation(properties.statisticsResource),
    };
}
// @ts-ignore TS6133
function CfnMonitoringScheduleBaselineConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('constraintsResource', 'ConstraintsResource', properties.ConstraintsResource != null ? CfnMonitoringScheduleConstraintsResourcePropertyFromCloudFormation(properties.ConstraintsResource) : undefined);
    ret.addPropertyResult('statisticsResource', 'StatisticsResource', properties.StatisticsResource != null ? CfnMonitoringScheduleStatisticsResourcePropertyFromCloudFormation(properties.StatisticsResource) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `BatchTransformInputProperty`
 *
 * @param properties - the TypeScript properties of a `BatchTransformInputProperty`
 *
 * @returns the result of the validation.
 */
function CfnMonitoringSchedule_BatchTransformInputPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dataCapturedDestinationS3Uri', cdk.requiredValidator)(properties.dataCapturedDestinationS3Uri));
    errors.collect(cdk.propertyValidator('dataCapturedDestinationS3Uri', cdk.validateString)(properties.dataCapturedDestinationS3Uri));
    errors.collect(cdk.propertyValidator('datasetFormat', cdk.requiredValidator)(properties.datasetFormat));
    errors.collect(cdk.propertyValidator('datasetFormat', CfnMonitoringSchedule_DatasetFormatPropertyValidator)(properties.datasetFormat));
    errors.collect(cdk.propertyValidator('localPath', cdk.requiredValidator)(properties.localPath));
    errors.collect(cdk.propertyValidator('localPath', cdk.validateString)(properties.localPath));
    errors.collect(cdk.propertyValidator('s3DataDistributionType', cdk.validateString)(properties.s3DataDistributionType));
    errors.collect(cdk.propertyValidator('s3InputMode', cdk.validateString)(properties.s3InputMode));
    return errors.wrap('supplied properties not correct for "BatchTransformInputProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::MonitoringSchedule.BatchTransformInput` resource
 *
 * @param properties - the TypeScript properties of a `BatchTransformInputProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::MonitoringSchedule.BatchTransformInput` resource.
 */
// @ts-ignore TS6133
function cfnMonitoringScheduleBatchTransformInputPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMonitoringSchedule_BatchTransformInputPropertyValidator(properties).assertSuccess();
    return {
        DataCapturedDestinationS3Uri: cdk.stringToCloudFormation(properties.dataCapturedDestinationS3Uri),
        DatasetFormat: cfnMonitoringScheduleDatasetFormatPropertyToCloudFormation(properties.datasetFormat),
        LocalPath: cdk.stringToCloudFormation(properties.localPath),
        S3DataDistributionType: cdk.stringToCloudFormation(properties.s3DataDistributionType),
        S3InputMode: cdk.stringToCloudFormation(properties.s3InputMode),
    };
}
// @ts-ignore TS6133
function CfnMonitoringScheduleBatchTransformInputPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dataCapturedDestinationS3Uri', 'DataCapturedDestinationS3Uri', cfn_parse.FromCloudFormation.getString(properties.DataCapturedDestinationS3Uri));
    ret.addPropertyResult('datasetFormat', 'DatasetFormat', CfnMonitoringScheduleDatasetFormatPropertyFromCloudFormation(properties.DatasetFormat));
    ret.addPropertyResult('localPath', 'LocalPath', cfn_parse.FromCloudFormation.getString(properties.LocalPath));
    ret.addPropertyResult('s3DataDistributionType', 'S3DataDistributionType', properties.S3DataDistributionType != null ? cfn_parse.FromCloudFormation.getString(properties.S3DataDistributionType) : undefined);
    ret.addPropertyResult('s3InputMode', 'S3InputMode', properties.S3InputMode != null ? cfn_parse.FromCloudFormation.getString(properties.S3InputMode) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ClusterConfigProperty`
 *
 * @param properties - the TypeScript properties of a `ClusterConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnMonitoringSchedule_ClusterConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('instanceCount', cdk.requiredValidator)(properties.instanceCount));
    errors.collect(cdk.propertyValidator('instanceCount', cdk.validateNumber)(properties.instanceCount));
    errors.collect(cdk.propertyValidator('instanceType', cdk.requiredValidator)(properties.instanceType));
    errors.collect(cdk.propertyValidator('instanceType', cdk.validateString)(properties.instanceType));
    errors.collect(cdk.propertyValidator('volumeKmsKeyId', cdk.validateString)(properties.volumeKmsKeyId));
    errors.collect(cdk.propertyValidator('volumeSizeInGb', cdk.requiredValidator)(properties.volumeSizeInGb));
    errors.collect(cdk.propertyValidator('volumeSizeInGb', cdk.validateNumber)(properties.volumeSizeInGb));
    return errors.wrap('supplied properties not correct for "ClusterConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::MonitoringSchedule.ClusterConfig` resource
 *
 * @param properties - the TypeScript properties of a `ClusterConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::MonitoringSchedule.ClusterConfig` resource.
 */
// @ts-ignore TS6133
function cfnMonitoringScheduleClusterConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMonitoringSchedule_ClusterConfigPropertyValidator(properties).assertSuccess();
    return {
        InstanceCount: cdk.numberToCloudFormation(properties.instanceCount),
        InstanceType: cdk.stringToCloudFormation(properties.instanceType),
        VolumeKmsKeyId: cdk.stringToCloudFormation(properties.volumeKmsKeyId),
        VolumeSizeInGB: cdk.numberToCloudFormation(properties.volumeSizeInGb),
    };
}
// @ts-ignore TS6133
function CfnMonitoringScheduleClusterConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('instanceCount', 'InstanceCount', cfn_parse.FromCloudFormation.getNumber(properties.InstanceCount));
    ret.addPropertyResult('instanceType', 'InstanceType', cfn_parse.FromCloudFormation.getString(properties.InstanceType));
    ret.addPropertyResult('volumeKmsKeyId', 'VolumeKmsKeyId', properties.VolumeKmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.VolumeKmsKeyId) : undefined);
    ret.addPropertyResult('volumeSizeInGb', 'VolumeSizeInGB', cfn_parse.FromCloudFormation.getNumber(properties.VolumeSizeInGB));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ConstraintsResourceProperty`
 *
 * @param properties - the TypeScript properties of a `ConstraintsResourceProperty`
 *
 * @returns the result of the validation.
 */
function CfnMonitoringSchedule_ConstraintsResourcePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('s3Uri', cdk.validateString)(properties.s3Uri));
    return errors.wrap('supplied properties not correct for "ConstraintsResourceProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::MonitoringSchedule.ConstraintsResource` resource
 *
 * @param properties - the TypeScript properties of a `ConstraintsResourceProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::MonitoringSchedule.ConstraintsResource` resource.
 */
// @ts-ignore TS6133
function cfnMonitoringScheduleConstraintsResourcePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMonitoringSchedule_ConstraintsResourcePropertyValidator(properties).assertSuccess();
    return {
        S3Uri: cdk.stringToCloudFormation(properties.s3Uri),
    };
}
// @ts-ignore TS6133
function CfnMonitoringScheduleConstraintsResourcePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('s3Uri', 'S3Uri', properties.S3Uri != null ? cfn_parse.FromCloudFormation.getString(properties.S3Uri) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CsvProperty`
 *
 * @param properties - the TypeScript properties of a `CsvProperty`
 *
 * @returns the result of the validation.
 */
function CfnMonitoringSchedule_CsvPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('header', cdk.validateBoolean)(properties.header));
    return errors.wrap('supplied properties not correct for "CsvProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::MonitoringSchedule.Csv` resource
 *
 * @param properties - the TypeScript properties of a `CsvProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::MonitoringSchedule.Csv` resource.
 */
// @ts-ignore TS6133
function cfnMonitoringScheduleCsvPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMonitoringSchedule_CsvPropertyValidator(properties).assertSuccess();
    return {
        Header: cdk.booleanToCloudFormation(properties.header),
    };
}
// @ts-ignore TS6133
function CfnMonitoringScheduleCsvPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('header', 'Header', properties.Header != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Header) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DatasetFormatProperty`
 *
 * @param properties - the TypeScript properties of a `DatasetFormatProperty`
 *
 * @returns the result of the validation.
 */
function CfnMonitoringSchedule_DatasetFormatPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('csv', CfnMonitoringSchedule_CsvPropertyValidator)(properties.csv));
    errors.collect(cdk.propertyValidator('json', cdk.validateObject)(properties.json));
    errors.collect(cdk.propertyValidator('parquet', cdk.validateBoolean)(properties.parquet));
    return errors.wrap('supplied properties not correct for "DatasetFormatProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::MonitoringSchedule.DatasetFormat` resource
 *
 * @param properties - the TypeScript properties of a `DatasetFormatProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::MonitoringSchedule.DatasetFormat` resource.
 */
// @ts-ignore TS6133
function cfnMonitoringScheduleDatasetFormatPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMonitoringSchedule_DatasetFormatPropertyValidator(properties).assertSuccess();
    return {
        Csv: cfnMonitoringScheduleCsvPropertyToCloudFormation(properties.csv),
        Json: cdk.objectToCloudFormation(properties.json),
        Parquet: cdk.booleanToCloudFormation(properties.parquet),
    };
}
// @ts-ignore TS6133
function CfnMonitoringScheduleDatasetFormatPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('csv', 'Csv', properties.Csv != null ? CfnMonitoringScheduleCsvPropertyFromCloudFormation(properties.Csv) : undefined);
    ret.addPropertyResult('json', 'Json', properties.Json != null ? cfn_parse.FromCloudFormation.getAny(properties.Json) : undefined);
    ret.addPropertyResult('parquet', 'Parquet', properties.Parquet != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Parquet) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `EndpointInputProperty`
 *
 * @param properties - the TypeScript properties of a `EndpointInputProperty`
 *
 * @returns the result of the validation.
 */
function CfnMonitoringSchedule_EndpointInputPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('endpointName', cdk.requiredValidator)(properties.endpointName));
    errors.collect(cdk.propertyValidator('endpointName', cdk.validateString)(properties.endpointName));
    errors.collect(cdk.propertyValidator('localPath', cdk.requiredValidator)(properties.localPath));
    errors.collect(cdk.propertyValidator('localPath', cdk.validateString)(properties.localPath));
    errors.collect(cdk.propertyValidator('s3DataDistributionType', cdk.validateString)(properties.s3DataDistributionType));
    errors.collect(cdk.propertyValidator('s3InputMode', cdk.validateString)(properties.s3InputMode));
    return errors.wrap('supplied properties not correct for "EndpointInputProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::MonitoringSchedule.EndpointInput` resource
 *
 * @param properties - the TypeScript properties of a `EndpointInputProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::MonitoringSchedule.EndpointInput` resource.
 */
// @ts-ignore TS6133
function cfnMonitoringScheduleEndpointInputPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMonitoringSchedule_EndpointInputPropertyValidator(properties).assertSuccess();
    return {
        EndpointName: cdk.stringToCloudFormation(properties.endpointName),
        LocalPath: cdk.stringToCloudFormation(properties.localPath),
        S3DataDistributionType: cdk.stringToCloudFormation(properties.s3DataDistributionType),
        S3InputMode: cdk.stringToCloudFormation(properties.s3InputMode),
    };
}
// @ts-ignore TS6133
function CfnMonitoringScheduleEndpointInputPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('endpointName', 'EndpointName', cfn_parse.FromCloudFormation.getString(properties.EndpointName));
    ret.addPropertyResult('localPath', 'LocalPath', cfn_parse.FromCloudFormation.getString(properties.LocalPath));
    ret.addPropertyResult('s3DataDistributionType', 'S3DataDistributionType', properties.S3DataDistributionType != null ? cfn_parse.FromCloudFormation.getString(properties.S3DataDistributionType) : undefined);
    ret.addPropertyResult('s3InputMode', 'S3InputMode', properties.S3InputMode != null ? cfn_parse.FromCloudFormation.getString(properties.S3InputMode) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `JsonProperty`
 *
 * @param properties - the TypeScript properties of a `JsonProperty`
 *
 * @returns the result of the validation.
 */
function CfnMonitoringSchedule_JsonPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('line', cdk.validateBoolean)(properties.line));
    return errors.wrap('supplied properties not correct for "JsonProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::MonitoringSchedule.Json` resource
 *
 * @param properties - the TypeScript properties of a `JsonProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::MonitoringSchedule.Json` resource.
 */
// @ts-ignore TS6133
function cfnMonitoringScheduleJsonPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMonitoringSchedule_JsonPropertyValidator(properties).assertSuccess();
    return {
        Line: cdk.booleanToCloudFormation(properties.line),
    };
}
// @ts-ignore TS6133
function CfnMonitoringScheduleJsonPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('line', 'Line', properties.Line != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Line) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MonitoringAppSpecificationProperty`
 *
 * @param properties - the TypeScript properties of a `MonitoringAppSpecificationProperty`
 *
 * @returns the result of the validation.
 */
function CfnMonitoringSchedule_MonitoringAppSpecificationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('containerArguments', cdk.listValidator(cdk.validateString))(properties.containerArguments));
    errors.collect(cdk.propertyValidator('containerEntrypoint', cdk.listValidator(cdk.validateString))(properties.containerEntrypoint));
    errors.collect(cdk.propertyValidator('imageUri', cdk.requiredValidator)(properties.imageUri));
    errors.collect(cdk.propertyValidator('imageUri', cdk.validateString)(properties.imageUri));
    errors.collect(cdk.propertyValidator('postAnalyticsProcessorSourceUri', cdk.validateString)(properties.postAnalyticsProcessorSourceUri));
    errors.collect(cdk.propertyValidator('recordPreprocessorSourceUri', cdk.validateString)(properties.recordPreprocessorSourceUri));
    return errors.wrap('supplied properties not correct for "MonitoringAppSpecificationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::MonitoringSchedule.MonitoringAppSpecification` resource
 *
 * @param properties - the TypeScript properties of a `MonitoringAppSpecificationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::MonitoringSchedule.MonitoringAppSpecification` resource.
 */
// @ts-ignore TS6133
function cfnMonitoringScheduleMonitoringAppSpecificationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMonitoringSchedule_MonitoringAppSpecificationPropertyValidator(properties).assertSuccess();
    return {
        ContainerArguments: cdk.listMapper(cdk.stringToCloudFormation)(properties.containerArguments),
        ContainerEntrypoint: cdk.listMapper(cdk.stringToCloudFormation)(properties.containerEntrypoint),
        ImageUri: cdk.stringToCloudFormation(properties.imageUri),
        PostAnalyticsProcessorSourceUri: cdk.stringToCloudFormation(properties.postAnalyticsProcessorSourceUri),
        RecordPreprocessorSourceUri: cdk.stringToCloudFormation(properties.recordPreprocessorSourceUri),
    };
}
// @ts-ignore TS6133
function CfnMonitoringScheduleMonitoringAppSpecificationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('containerArguments', 'ContainerArguments', properties.ContainerArguments != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ContainerArguments) : undefined);
    ret.addPropertyResult('containerEntrypoint', 'ContainerEntrypoint', properties.ContainerEntrypoint != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ContainerEntrypoint) : undefined);
    ret.addPropertyResult('imageUri', 'ImageUri', cfn_parse.FromCloudFormation.getString(properties.ImageUri));
    ret.addPropertyResult('postAnalyticsProcessorSourceUri', 'PostAnalyticsProcessorSourceUri', properties.PostAnalyticsProcessorSourceUri != null ? cfn_parse.FromCloudFormation.getString(properties.PostAnalyticsProcessorSourceUri) : undefined);
    ret.addPropertyResult('recordPreprocessorSourceUri', 'RecordPreprocessorSourceUri', properties.RecordPreprocessorSourceUri != null ? cfn_parse.FromCloudFormation.getString(properties.RecordPreprocessorSourceUri) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MonitoringExecutionSummaryProperty`
 *
 * @param properties - the TypeScript properties of a `MonitoringExecutionSummaryProperty`
 *
 * @returns the result of the validation.
 */
function CfnMonitoringSchedule_MonitoringExecutionSummaryPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('creationTime', cdk.requiredValidator)(properties.creationTime));
    errors.collect(cdk.propertyValidator('creationTime', cdk.validateString)(properties.creationTime));
    errors.collect(cdk.propertyValidator('endpointName', cdk.validateString)(properties.endpointName));
    errors.collect(cdk.propertyValidator('failureReason', cdk.validateString)(properties.failureReason));
    errors.collect(cdk.propertyValidator('lastModifiedTime', cdk.requiredValidator)(properties.lastModifiedTime));
    errors.collect(cdk.propertyValidator('lastModifiedTime', cdk.validateString)(properties.lastModifiedTime));
    errors.collect(cdk.propertyValidator('monitoringExecutionStatus', cdk.requiredValidator)(properties.monitoringExecutionStatus));
    errors.collect(cdk.propertyValidator('monitoringExecutionStatus', cdk.validateString)(properties.monitoringExecutionStatus));
    errors.collect(cdk.propertyValidator('monitoringScheduleName', cdk.requiredValidator)(properties.monitoringScheduleName));
    errors.collect(cdk.propertyValidator('monitoringScheduleName', cdk.validateString)(properties.monitoringScheduleName));
    errors.collect(cdk.propertyValidator('processingJobArn', cdk.validateString)(properties.processingJobArn));
    errors.collect(cdk.propertyValidator('scheduledTime', cdk.requiredValidator)(properties.scheduledTime));
    errors.collect(cdk.propertyValidator('scheduledTime', cdk.validateString)(properties.scheduledTime));
    return errors.wrap('supplied properties not correct for "MonitoringExecutionSummaryProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::MonitoringSchedule.MonitoringExecutionSummary` resource
 *
 * @param properties - the TypeScript properties of a `MonitoringExecutionSummaryProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::MonitoringSchedule.MonitoringExecutionSummary` resource.
 */
// @ts-ignore TS6133
function cfnMonitoringScheduleMonitoringExecutionSummaryPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMonitoringSchedule_MonitoringExecutionSummaryPropertyValidator(properties).assertSuccess();
    return {
        CreationTime: cdk.stringToCloudFormation(properties.creationTime),
        EndpointName: cdk.stringToCloudFormation(properties.endpointName),
        FailureReason: cdk.stringToCloudFormation(properties.failureReason),
        LastModifiedTime: cdk.stringToCloudFormation(properties.lastModifiedTime),
        MonitoringExecutionStatus: cdk.stringToCloudFormation(properties.monitoringExecutionStatus),
        MonitoringScheduleName: cdk.stringToCloudFormation(properties.monitoringScheduleName),
        ProcessingJobArn: cdk.stringToCloudFormation(properties.processingJobArn),
        ScheduledTime: cdk.stringToCloudFormation(properties.scheduledTime),
    };
}
// @ts-ignore TS6133
function CfnMonitoringScheduleMonitoringExecutionSummaryPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('creationTime', 'CreationTime', cfn_parse.FromCloudFormation.getString(properties.CreationTime));
    ret.addPropertyResult('endpointName', 'EndpointName', properties.EndpointName != null ? cfn_parse.FromCloudFormation.getString(properties.EndpointName) : undefined);
    ret.addPropertyResult('failureReason', 'FailureReason', properties.FailureReason != null ? cfn_parse.FromCloudFormation.getString(properties.FailureReason) : undefined);
    ret.addPropertyResult('lastModifiedTime', 'LastModifiedTime', cfn_parse.FromCloudFormation.getString(properties.LastModifiedTime));
    ret.addPropertyResult('monitoringExecutionStatus', 'MonitoringExecutionStatus', cfn_parse.FromCloudFormation.getString(properties.MonitoringExecutionStatus));
    ret.addPropertyResult('monitoringScheduleName', 'MonitoringScheduleName', cfn_parse.FromCloudFormation.getString(properties.MonitoringScheduleName));
    ret.addPropertyResult('processingJobArn', 'ProcessingJobArn', properties.ProcessingJobArn != null ? cfn_parse.FromCloudFormation.getString(properties.ProcessingJobArn) : undefined);
    ret.addPropertyResult('scheduledTime', 'ScheduledTime', cfn_parse.FromCloudFormation.getString(properties.ScheduledTime));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MonitoringInputProperty`
 *
 * @param properties - the TypeScript properties of a `MonitoringInputProperty`
 *
 * @returns the result of the validation.
 */
function CfnMonitoringSchedule_MonitoringInputPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('batchTransformInput', CfnMonitoringSchedule_BatchTransformInputPropertyValidator)(properties.batchTransformInput));
    errors.collect(cdk.propertyValidator('endpointInput', CfnMonitoringSchedule_EndpointInputPropertyValidator)(properties.endpointInput));
    return errors.wrap('supplied properties not correct for "MonitoringInputProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::MonitoringSchedule.MonitoringInput` resource
 *
 * @param properties - the TypeScript properties of a `MonitoringInputProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::MonitoringSchedule.MonitoringInput` resource.
 */
// @ts-ignore TS6133
function cfnMonitoringScheduleMonitoringInputPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMonitoringSchedule_MonitoringInputPropertyValidator(properties).assertSuccess();
    return {
        BatchTransformInput: cfnMonitoringScheduleBatchTransformInputPropertyToCloudFormation(properties.batchTransformInput),
        EndpointInput: cfnMonitoringScheduleEndpointInputPropertyToCloudFormation(properties.endpointInput),
    };
}
// @ts-ignore TS6133
function CfnMonitoringScheduleMonitoringInputPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('batchTransformInput', 'BatchTransformInput', properties.BatchTransformInput != null ? CfnMonitoringScheduleBatchTransformInputPropertyFromCloudFormation(properties.BatchTransformInput) : undefined);
    ret.addPropertyResult('endpointInput', 'EndpointInput', properties.EndpointInput != null ? CfnMonitoringScheduleEndpointInputPropertyFromCloudFormation(properties.EndpointInput) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MonitoringJobDefinitionProperty`
 *
 * @param properties - the TypeScript properties of a `MonitoringJobDefinitionProperty`
 *
 * @returns the result of the validation.
 */
function CfnMonitoringSchedule_MonitoringJobDefinitionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('baselineConfig', CfnMonitoringSchedule_BaselineConfigPropertyValidator)(properties.baselineConfig));
    errors.collect(cdk.propertyValidator('environment', cdk.hashValidator(cdk.validateString))(properties.environment));
    errors.collect(cdk.propertyValidator('monitoringAppSpecification', cdk.requiredValidator)(properties.monitoringAppSpecification));
    errors.collect(cdk.propertyValidator('monitoringAppSpecification', CfnMonitoringSchedule_MonitoringAppSpecificationPropertyValidator)(properties.monitoringAppSpecification));
    errors.collect(cdk.propertyValidator('monitoringInputs', cdk.requiredValidator)(properties.monitoringInputs));
    errors.collect(cdk.propertyValidator('monitoringInputs', cdk.listValidator(CfnMonitoringSchedule_MonitoringInputPropertyValidator))(properties.monitoringInputs));
    errors.collect(cdk.propertyValidator('monitoringOutputConfig', cdk.requiredValidator)(properties.monitoringOutputConfig));
    errors.collect(cdk.propertyValidator('monitoringOutputConfig', CfnMonitoringSchedule_MonitoringOutputConfigPropertyValidator)(properties.monitoringOutputConfig));
    errors.collect(cdk.propertyValidator('monitoringResources', cdk.requiredValidator)(properties.monitoringResources));
    errors.collect(cdk.propertyValidator('monitoringResources', CfnMonitoringSchedule_MonitoringResourcesPropertyValidator)(properties.monitoringResources));
    errors.collect(cdk.propertyValidator('networkConfig', CfnMonitoringSchedule_NetworkConfigPropertyValidator)(properties.networkConfig));
    errors.collect(cdk.propertyValidator('roleArn', cdk.requiredValidator)(properties.roleArn));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    errors.collect(cdk.propertyValidator('stoppingCondition', CfnMonitoringSchedule_StoppingConditionPropertyValidator)(properties.stoppingCondition));
    return errors.wrap('supplied properties not correct for "MonitoringJobDefinitionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::MonitoringSchedule.MonitoringJobDefinition` resource
 *
 * @param properties - the TypeScript properties of a `MonitoringJobDefinitionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::MonitoringSchedule.MonitoringJobDefinition` resource.
 */
// @ts-ignore TS6133
function cfnMonitoringScheduleMonitoringJobDefinitionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMonitoringSchedule_MonitoringJobDefinitionPropertyValidator(properties).assertSuccess();
    return {
        BaselineConfig: cfnMonitoringScheduleBaselineConfigPropertyToCloudFormation(properties.baselineConfig),
        Environment: cdk.hashMapper(cdk.stringToCloudFormation)(properties.environment),
        MonitoringAppSpecification: cfnMonitoringScheduleMonitoringAppSpecificationPropertyToCloudFormation(properties.monitoringAppSpecification),
        MonitoringInputs: cdk.listMapper(cfnMonitoringScheduleMonitoringInputPropertyToCloudFormation)(properties.monitoringInputs),
        MonitoringOutputConfig: cfnMonitoringScheduleMonitoringOutputConfigPropertyToCloudFormation(properties.monitoringOutputConfig),
        MonitoringResources: cfnMonitoringScheduleMonitoringResourcesPropertyToCloudFormation(properties.monitoringResources),
        NetworkConfig: cfnMonitoringScheduleNetworkConfigPropertyToCloudFormation(properties.networkConfig),
        RoleArn: cdk.stringToCloudFormation(properties.roleArn),
        StoppingCondition: cfnMonitoringScheduleStoppingConditionPropertyToCloudFormation(properties.stoppingCondition),
    };
}
// @ts-ignore TS6133
function CfnMonitoringScheduleMonitoringJobDefinitionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('baselineConfig', 'BaselineConfig', properties.BaselineConfig != null ? CfnMonitoringScheduleBaselineConfigPropertyFromCloudFormation(properties.BaselineConfig) : undefined);
    ret.addPropertyResult('environment', 'Environment', properties.Environment != null ? cfn_parse.FromCloudFormation.getMap(cfn_parse.FromCloudFormation.getString)(properties.Environment) : undefined);
    ret.addPropertyResult('monitoringAppSpecification', 'MonitoringAppSpecification', CfnMonitoringScheduleMonitoringAppSpecificationPropertyFromCloudFormation(properties.MonitoringAppSpecification));
    ret.addPropertyResult('monitoringInputs', 'MonitoringInputs', cfn_parse.FromCloudFormation.getArray(CfnMonitoringScheduleMonitoringInputPropertyFromCloudFormation)(properties.MonitoringInputs));
    ret.addPropertyResult('monitoringOutputConfig', 'MonitoringOutputConfig', CfnMonitoringScheduleMonitoringOutputConfigPropertyFromCloudFormation(properties.MonitoringOutputConfig));
    ret.addPropertyResult('monitoringResources', 'MonitoringResources', CfnMonitoringScheduleMonitoringResourcesPropertyFromCloudFormation(properties.MonitoringResources));
    ret.addPropertyResult('networkConfig', 'NetworkConfig', properties.NetworkConfig != null ? CfnMonitoringScheduleNetworkConfigPropertyFromCloudFormation(properties.NetworkConfig) : undefined);
    ret.addPropertyResult('roleArn', 'RoleArn', cfn_parse.FromCloudFormation.getString(properties.RoleArn));
    ret.addPropertyResult('stoppingCondition', 'StoppingCondition', properties.StoppingCondition != null ? CfnMonitoringScheduleStoppingConditionPropertyFromCloudFormation(properties.StoppingCondition) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MonitoringOutputProperty`
 *
 * @param properties - the TypeScript properties of a `MonitoringOutputProperty`
 *
 * @returns the result of the validation.
 */
function CfnMonitoringSchedule_MonitoringOutputPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('s3Output', cdk.requiredValidator)(properties.s3Output));
    errors.collect(cdk.propertyValidator('s3Output', CfnMonitoringSchedule_S3OutputPropertyValidator)(properties.s3Output));
    return errors.wrap('supplied properties not correct for "MonitoringOutputProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::MonitoringSchedule.MonitoringOutput` resource
 *
 * @param properties - the TypeScript properties of a `MonitoringOutputProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::MonitoringSchedule.MonitoringOutput` resource.
 */
// @ts-ignore TS6133
function cfnMonitoringScheduleMonitoringOutputPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMonitoringSchedule_MonitoringOutputPropertyValidator(properties).assertSuccess();
    return {
        S3Output: cfnMonitoringScheduleS3OutputPropertyToCloudFormation(properties.s3Output),
    };
}
// @ts-ignore TS6133
function CfnMonitoringScheduleMonitoringOutputPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('s3Output', 'S3Output', CfnMonitoringScheduleS3OutputPropertyFromCloudFormation(properties.S3Output));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MonitoringOutputConfigProperty`
 *
 * @param properties - the TypeScript properties of a `MonitoringOutputConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnMonitoringSchedule_MonitoringOutputConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('kmsKeyId', cdk.validateString)(properties.kmsKeyId));
    errors.collect(cdk.propertyValidator('monitoringOutputs', cdk.requiredValidator)(properties.monitoringOutputs));
    errors.collect(cdk.propertyValidator('monitoringOutputs', cdk.listValidator(CfnMonitoringSchedule_MonitoringOutputPropertyValidator))(properties.monitoringOutputs));
    return errors.wrap('supplied properties not correct for "MonitoringOutputConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::MonitoringSchedule.MonitoringOutputConfig` resource
 *
 * @param properties - the TypeScript properties of a `MonitoringOutputConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::MonitoringSchedule.MonitoringOutputConfig` resource.
 */
// @ts-ignore TS6133
function cfnMonitoringScheduleMonitoringOutputConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMonitoringSchedule_MonitoringOutputConfigPropertyValidator(properties).assertSuccess();
    return {
        KmsKeyId: cdk.stringToCloudFormation(properties.kmsKeyId),
        MonitoringOutputs: cdk.listMapper(cfnMonitoringScheduleMonitoringOutputPropertyToCloudFormation)(properties.monitoringOutputs),
    };
}
// @ts-ignore TS6133
function CfnMonitoringScheduleMonitoringOutputConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('kmsKeyId', 'KmsKeyId', properties.KmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.KmsKeyId) : undefined);
    ret.addPropertyResult('monitoringOutputs', 'MonitoringOutputs', cfn_parse.FromCloudFormation.getArray(CfnMonitoringScheduleMonitoringOutputPropertyFromCloudFormation)(properties.MonitoringOutputs));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MonitoringResourcesProperty`
 *
 * @param properties - the TypeScript properties of a `MonitoringResourcesProperty`
 *
 * @returns the result of the validation.
 */
function CfnMonitoringSchedule_MonitoringResourcesPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('clusterConfig', cdk.requiredValidator)(properties.clusterConfig));
    errors.collect(cdk.propertyValidator('clusterConfig', CfnMonitoringSchedule_ClusterConfigPropertyValidator)(properties.clusterConfig));
    return errors.wrap('supplied properties not correct for "MonitoringResourcesProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::MonitoringSchedule.MonitoringResources` resource
 *
 * @param properties - the TypeScript properties of a `MonitoringResourcesProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::MonitoringSchedule.MonitoringResources` resource.
 */
// @ts-ignore TS6133
function cfnMonitoringScheduleMonitoringResourcesPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMonitoringSchedule_MonitoringResourcesPropertyValidator(properties).assertSuccess();
    return {
        ClusterConfig: cfnMonitoringScheduleClusterConfigPropertyToCloudFormation(properties.clusterConfig),
    };
}
// @ts-ignore TS6133
function CfnMonitoringScheduleMonitoringResourcesPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('clusterConfig', 'ClusterConfig', CfnMonitoringScheduleClusterConfigPropertyFromCloudFormation(properties.ClusterConfig));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MonitoringScheduleConfigProperty`
 *
 * @param properties - the TypeScript properties of a `MonitoringScheduleConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnMonitoringSchedule_MonitoringScheduleConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('monitoringJobDefinition', CfnMonitoringSchedule_MonitoringJobDefinitionPropertyValidator)(properties.monitoringJobDefinition));
    errors.collect(cdk.propertyValidator('monitoringJobDefinitionName', cdk.validateString)(properties.monitoringJobDefinitionName));
    errors.collect(cdk.propertyValidator('monitoringType', cdk.validateString)(properties.monitoringType));
    errors.collect(cdk.propertyValidator('scheduleConfig', CfnMonitoringSchedule_ScheduleConfigPropertyValidator)(properties.scheduleConfig));
    return errors.wrap('supplied properties not correct for "MonitoringScheduleConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleConfig` resource
 *
 * @param properties - the TypeScript properties of a `MonitoringScheduleConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleConfig` resource.
 */
// @ts-ignore TS6133
function cfnMonitoringScheduleMonitoringScheduleConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMonitoringSchedule_MonitoringScheduleConfigPropertyValidator(properties).assertSuccess();
    return {
        MonitoringJobDefinition: cfnMonitoringScheduleMonitoringJobDefinitionPropertyToCloudFormation(properties.monitoringJobDefinition),
        MonitoringJobDefinitionName: cdk.stringToCloudFormation(properties.monitoringJobDefinitionName),
        MonitoringType: cdk.stringToCloudFormation(properties.monitoringType),
        ScheduleConfig: cfnMonitoringScheduleScheduleConfigPropertyToCloudFormation(properties.scheduleConfig),
    };
}
// @ts-ignore TS6133
function CfnMonitoringScheduleMonitoringScheduleConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('monitoringJobDefinition', 'MonitoringJobDefinition', properties.MonitoringJobDefinition != null ? CfnMonitoringScheduleMonitoringJobDefinitionPropertyFromCloudFormation(properties.MonitoringJobDefinition) : undefined);
    ret.addPropertyResult('monitoringJobDefinitionName', 'MonitoringJobDefinitionName', properties.MonitoringJobDefinitionName != null ? cfn_parse.FromCloudFormation.getString(properties.MonitoringJobDefinitionName) : undefined);
    ret.addPropertyResult('monitoringType', 'MonitoringType', properties.MonitoringType != null ? cfn_parse.FromCloudFormation.getString(properties.MonitoringType) : undefined);
    ret.addPropertyResult('scheduleConfig', 'ScheduleConfig', properties.ScheduleConfig != null ? CfnMonitoringScheduleScheduleConfigPropertyFromCloudFormation(properties.ScheduleConfig) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `NetworkConfigProperty`
 *
 * @param properties - the TypeScript properties of a `NetworkConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnMonitoringSchedule_NetworkConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('enableInterContainerTrafficEncryption', cdk.validateBoolean)(properties.enableInterContainerTrafficEncryption));
    errors.collect(cdk.propertyValidator('enableNetworkIsolation', cdk.validateBoolean)(properties.enableNetworkIsolation));
    errors.collect(cdk.propertyValidator('vpcConfig', CfnMonitoringSchedule_VpcConfigPropertyValidator)(properties.vpcConfig));
    return errors.wrap('supplied properties not correct for "NetworkConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::MonitoringSchedule.NetworkConfig` resource
 *
 * @param properties - the TypeScript properties of a `NetworkConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::MonitoringSchedule.NetworkConfig` resource.
 */
// @ts-ignore TS6133
function cfnMonitoringScheduleNetworkConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMonitoringSchedule_NetworkConfigPropertyValidator(properties).assertSuccess();
    return {
        EnableInterContainerTrafficEncryption: cdk.booleanToCloudFormation(properties.enableInterContainerTrafficEncryption),
        EnableNetworkIsolation: cdk.booleanToCloudFormation(properties.enableNetworkIsolation),
        VpcConfig: cfnMonitoringScheduleVpcConfigPropertyToCloudFormation(properties.vpcConfig),
    };
}
// @ts-ignore TS6133
function CfnMonitoringScheduleNetworkConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('enableInterContainerTrafficEncryption', 'EnableInterContainerTrafficEncryption', properties.EnableInterContainerTrafficEncryption != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EnableInterContainerTrafficEncryption) : undefined);
    ret.addPropertyResult('enableNetworkIsolation', 'EnableNetworkIsolation', properties.EnableNetworkIsolation != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EnableNetworkIsolation) : undefined);
    ret.addPropertyResult('vpcConfig', 'VpcConfig', properties.VpcConfig != null ? CfnMonitoringScheduleVpcConfigPropertyFromCloudFormation(properties.VpcConfig) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `S3OutputProperty`
 *
 * @param properties - the TypeScript properties of a `S3OutputProperty`
 *
 * @returns the result of the validation.
 */
function CfnMonitoringSchedule_S3OutputPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('localPath', cdk.requiredValidator)(properties.localPath));
    errors.collect(cdk.propertyValidator('localPath', cdk.validateString)(properties.localPath));
    errors.collect(cdk.propertyValidator('s3UploadMode', cdk.validateString)(properties.s3UploadMode));
    errors.collect(cdk.propertyValidator('s3Uri', cdk.requiredValidator)(properties.s3Uri));
    errors.collect(cdk.propertyValidator('s3Uri', cdk.validateString)(properties.s3Uri));
    return errors.wrap('supplied properties not correct for "S3OutputProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::MonitoringSchedule.S3Output` resource
 *
 * @param properties - the TypeScript properties of a `S3OutputProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::MonitoringSchedule.S3Output` resource.
 */
// @ts-ignore TS6133
function cfnMonitoringScheduleS3OutputPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMonitoringSchedule_S3OutputPropertyValidator(properties).assertSuccess();
    return {
        LocalPath: cdk.stringToCloudFormation(properties.localPath),
        S3UploadMode: cdk.stringToCloudFormation(properties.s3UploadMode),
        S3Uri: cdk.stringToCloudFormation(properties.s3Uri),
    };
}
// @ts-ignore TS6133
function CfnMonitoringScheduleS3OutputPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('localPath', 'LocalPath', cfn_parse.FromCloudFormation.getString(properties.LocalPath));
    ret.addPropertyResult('s3UploadMode', 'S3UploadMode', properties.S3UploadMode != null ? cfn_parse.FromCloudFormation.getString(properties.S3UploadMode) : undefined);
    ret.addPropertyResult('s3Uri', 'S3Uri', cfn_parse.FromCloudFormation.getString(properties.S3Uri));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ScheduleConfigProperty`
 *
 * @param properties - the TypeScript properties of a `ScheduleConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnMonitoringSchedule_ScheduleConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('scheduleExpression', cdk.requiredValidator)(properties.scheduleExpression));
    errors.collect(cdk.propertyValidator('scheduleExpression', cdk.validateString)(properties.scheduleExpression));
    return errors.wrap('supplied properties not correct for "ScheduleConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::MonitoringSchedule.ScheduleConfig` resource
 *
 * @param properties - the TypeScript properties of a `ScheduleConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::MonitoringSchedule.ScheduleConfig` resource.
 */
// @ts-ignore TS6133
function cfnMonitoringScheduleScheduleConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMonitoringSchedule_ScheduleConfigPropertyValidator(properties).assertSuccess();
    return {
        ScheduleExpression: cdk.stringToCloudFormation(properties.scheduleExpression),
    };
}
// @ts-ignore TS6133
function CfnMonitoringScheduleScheduleConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('scheduleExpression', 'ScheduleExpression', cfn_parse.FromCloudFormation.getString(properties.ScheduleExpression));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `StatisticsResourceProperty`
 *
 * @param properties - the TypeScript properties of a `StatisticsResourceProperty`
 *
 * @returns the result of the validation.
 */
function CfnMonitoringSchedule_StatisticsResourcePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('s3Uri', cdk.validateString)(properties.s3Uri));
    return errors.wrap('supplied properties not correct for "StatisticsResourceProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::MonitoringSchedule.StatisticsResource` resource
 *
 * @param properties - the TypeScript properties of a `StatisticsResourceProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::MonitoringSchedule.StatisticsResource` resource.
 */
// @ts-ignore TS6133
function cfnMonitoringScheduleStatisticsResourcePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMonitoringSchedule_StatisticsResourcePropertyValidator(properties).assertSuccess();
    return {
        S3Uri: cdk.stringToCloudFormation(properties.s3Uri),
    };
}
// @ts-ignore TS6133
function CfnMonitoringScheduleStatisticsResourcePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('s3Uri', 'S3Uri', properties.S3Uri != null ? cfn_parse.FromCloudFormation.getString(properties.S3Uri) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `StoppingConditionProperty`
 *
 * @param properties - the TypeScript properties of a `StoppingConditionProperty`
 *
 * @returns the result of the validation.
 */
function CfnMonitoringSchedule_StoppingConditionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('maxRuntimeInSeconds', cdk.requiredValidator)(properties.maxRuntimeInSeconds));
    errors.collect(cdk.propertyValidator('maxRuntimeInSeconds', cdk.validateNumber)(properties.maxRuntimeInSeconds));
    return errors.wrap('supplied properties not correct for "StoppingConditionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::MonitoringSchedule.StoppingCondition` resource
 *
 * @param properties - the TypeScript properties of a `StoppingConditionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::MonitoringSchedule.StoppingCondition` resource.
 */
// @ts-ignore TS6133
function cfnMonitoringScheduleStoppingConditionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMonitoringSchedule_StoppingConditionPropertyValidator(properties).assertSuccess();
    return {
        MaxRuntimeInSeconds: cdk.numberToCloudFormation(properties.maxRuntimeInSeconds),
    };
}
// @ts-ignore TS6133
function CfnMonitoringScheduleStoppingConditionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('maxRuntimeInSeconds', 'MaxRuntimeInSeconds', cfn_parse.FromCloudFormation.getNumber(properties.MaxRuntimeInSeconds));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `VpcConfigProperty`
 *
 * @param properties - the TypeScript properties of a `VpcConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnMonitoringSchedule_VpcConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('securityGroupIds', cdk.requiredValidator)(properties.securityGroupIds));
    errors.collect(cdk.propertyValidator('securityGroupIds', cdk.listValidator(cdk.validateString))(properties.securityGroupIds));
    errors.collect(cdk.propertyValidator('subnets', cdk.requiredValidator)(properties.subnets));
    errors.collect(cdk.propertyValidator('subnets', cdk.listValidator(cdk.validateString))(properties.subnets));
    return errors.wrap('supplied properties not correct for "VpcConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::MonitoringSchedule.VpcConfig` resource
 *
 * @param properties - the TypeScript properties of a `VpcConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::MonitoringSchedule.VpcConfig` resource.
 */
// @ts-ignore TS6133
function cfnMonitoringScheduleVpcConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnMonitoringSchedule_VpcConfigPropertyValidator(properties).assertSuccess();
    return {
        SecurityGroupIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.securityGroupIds),
        Subnets: cdk.listMapper(cdk.stringToCloudFormation)(properties.subnets),
    };
}
// @ts-ignore TS6133
function CfnMonitoringScheduleVpcConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('securityGroupIds', 'SecurityGroupIds', cfn_parse.FromCloudFormation.getStringArray(properties.SecurityGroupIds));
    ret.addPropertyResult('subnets', 'Subnets', cfn_parse.FromCloudFormation.getStringArray(properties.Subnets));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnNotebookInstanceProps`
 *
 * @param properties - the TypeScript properties of a `CfnNotebookInstanceProps`
 *
 * @returns the result of the validation.
 */
function CfnNotebookInstancePropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('acceleratorTypes', cdk.listValidator(cdk.validateString))(properties.acceleratorTypes));
    errors.collect(cdk.propertyValidator('additionalCodeRepositories', cdk.listValidator(cdk.validateString))(properties.additionalCodeRepositories));
    errors.collect(cdk.propertyValidator('defaultCodeRepository', cdk.validateString)(properties.defaultCodeRepository));
    errors.collect(cdk.propertyValidator('directInternetAccess', cdk.validateString)(properties.directInternetAccess));
    errors.collect(cdk.propertyValidator('instanceMetadataServiceConfiguration', CfnNotebookInstance_InstanceMetadataServiceConfigurationPropertyValidator)(properties.instanceMetadataServiceConfiguration));
    errors.collect(cdk.propertyValidator('instanceType', cdk.requiredValidator)(properties.instanceType));
    errors.collect(cdk.propertyValidator('instanceType', cdk.validateString)(properties.instanceType));
    errors.collect(cdk.propertyValidator('kmsKeyId', cdk.validateString)(properties.kmsKeyId));
    errors.collect(cdk.propertyValidator('lifecycleConfigName', cdk.validateString)(properties.lifecycleConfigName));
    errors.collect(cdk.propertyValidator('notebookInstanceName', cdk.validateString)(properties.notebookInstanceName));
    errors.collect(cdk.propertyValidator('platformIdentifier', cdk.validateString)(properties.platformIdentifier));
    errors.collect(cdk.propertyValidator('roleArn', cdk.requiredValidator)(properties.roleArn));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    errors.collect(cdk.propertyValidator('rootAccess', cdk.validateString)(properties.rootAccess));
    errors.collect(cdk.propertyValidator('securityGroupIds', cdk.listValidator(cdk.validateString))(properties.securityGroupIds));
    errors.collect(cdk.propertyValidator('subnetId', cdk.validateString)(properties.subnetId));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('volumeSizeInGb', cdk.validateNumber)(properties.volumeSizeInGb));
    return errors.wrap('supplied properties not correct for "CfnNotebookInstanceProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::NotebookInstance` resource
 *
 * @param properties - the TypeScript properties of a `CfnNotebookInstanceProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::NotebookInstance` resource.
 */
// @ts-ignore TS6133
function cfnNotebookInstancePropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnNotebookInstancePropsValidator(properties).assertSuccess();
    return {
        InstanceType: cdk.stringToCloudFormation(properties.instanceType),
        RoleArn: cdk.stringToCloudFormation(properties.roleArn),
        AcceleratorTypes: cdk.listMapper(cdk.stringToCloudFormation)(properties.acceleratorTypes),
        AdditionalCodeRepositories: cdk.listMapper(cdk.stringToCloudFormation)(properties.additionalCodeRepositories),
        DefaultCodeRepository: cdk.stringToCloudFormation(properties.defaultCodeRepository),
        DirectInternetAccess: cdk.stringToCloudFormation(properties.directInternetAccess),
        InstanceMetadataServiceConfiguration: cfnNotebookInstanceInstanceMetadataServiceConfigurationPropertyToCloudFormation(properties.instanceMetadataServiceConfiguration),
        KmsKeyId: cdk.stringToCloudFormation(properties.kmsKeyId),
        LifecycleConfigName: cdk.stringToCloudFormation(properties.lifecycleConfigName),
        NotebookInstanceName: cdk.stringToCloudFormation(properties.notebookInstanceName),
        PlatformIdentifier: cdk.stringToCloudFormation(properties.platformIdentifier),
        RootAccess: cdk.stringToCloudFormation(properties.rootAccess),
        SecurityGroupIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.securityGroupIds),
        SubnetId: cdk.stringToCloudFormation(properties.subnetId),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
        VolumeSizeInGB: cdk.numberToCloudFormation(properties.volumeSizeInGb),
    };
}
// @ts-ignore TS6133
function CfnNotebookInstancePropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('instanceType', 'InstanceType', cfn_parse.FromCloudFormation.getString(properties.InstanceType));
    ret.addPropertyResult('roleArn', 'RoleArn', cfn_parse.FromCloudFormation.getString(properties.RoleArn));
    ret.addPropertyResult('acceleratorTypes', 'AcceleratorTypes', properties.AcceleratorTypes != null ? cfn_parse.FromCloudFormation.getStringArray(properties.AcceleratorTypes) : undefined);
    ret.addPropertyResult('additionalCodeRepositories', 'AdditionalCodeRepositories', properties.AdditionalCodeRepositories != null ? cfn_parse.FromCloudFormation.getStringArray(properties.AdditionalCodeRepositories) : undefined);
    ret.addPropertyResult('defaultCodeRepository', 'DefaultCodeRepository', properties.DefaultCodeRepository != null ? cfn_parse.FromCloudFormation.getString(properties.DefaultCodeRepository) : undefined);
    ret.addPropertyResult('directInternetAccess', 'DirectInternetAccess', properties.DirectInternetAccess != null ? cfn_parse.FromCloudFormation.getString(properties.DirectInternetAccess) : undefined);
    ret.addPropertyResult('instanceMetadataServiceConfiguration', 'InstanceMetadataServiceConfiguration', properties.InstanceMetadataServiceConfiguration != null ? CfnNotebookInstanceInstanceMetadataServiceConfigurationPropertyFromCloudFormation(properties.InstanceMetadataServiceConfiguration) : undefined);
    ret.addPropertyResult('kmsKeyId', 'KmsKeyId', properties.KmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.KmsKeyId) : undefined);
    ret.addPropertyResult('lifecycleConfigName', 'LifecycleConfigName', properties.LifecycleConfigName != null ? cfn_parse.FromCloudFormation.getString(properties.LifecycleConfigName) : undefined);
    ret.addPropertyResult('notebookInstanceName', 'NotebookInstanceName', properties.NotebookInstanceName != null ? cfn_parse.FromCloudFormation.getString(properties.NotebookInstanceName) : undefined);
    ret.addPropertyResult('platformIdentifier', 'PlatformIdentifier', properties.PlatformIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.PlatformIdentifier) : undefined);
    ret.addPropertyResult('rootAccess', 'RootAccess', properties.RootAccess != null ? cfn_parse.FromCloudFormation.getString(properties.RootAccess) : undefined);
    ret.addPropertyResult('securityGroupIds', 'SecurityGroupIds', properties.SecurityGroupIds != null ? cfn_parse.FromCloudFormation.getStringArray(properties.SecurityGroupIds) : undefined);
    ret.addPropertyResult('subnetId', 'SubnetId', properties.SubnetId != null ? cfn_parse.FromCloudFormation.getString(properties.SubnetId) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addPropertyResult('volumeSizeInGb', 'VolumeSizeInGB', properties.VolumeSizeInGB != null ? cfn_parse.FromCloudFormation.getNumber(properties.VolumeSizeInGB) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::SageMaker::NotebookInstance`
 *
 * The `AWS::SageMaker::NotebookInstance` resource creates an Amazon SageMaker notebook instance. A notebook instance is a machine learning (ML) compute instance running on a Jupyter notebook. For more information, see [Use Notebook Instances](https://docs.aws.amazon.com/sagemaker/latest/dg/nbi.html) .
 *
 * @cloudformationResource AWS::SageMaker::NotebookInstance
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html
 */
class CfnNotebookInstance extends cdk.CfnResource {
    /**
     * Create a new `AWS::SageMaker::NotebookInstance`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnNotebookInstance.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_sagemaker_CfnNotebookInstanceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnNotebookInstance);
            }
            throw error;
        }
        cdk.requireProperty(props, 'instanceType', this);
        cdk.requireProperty(props, 'roleArn', this);
        this.attrNotebookInstanceName = cdk.Token.asString(this.getAtt('NotebookInstanceName'));
        this.instanceType = props.instanceType;
        this.roleArn = props.roleArn;
        this.acceleratorTypes = props.acceleratorTypes;
        this.additionalCodeRepositories = props.additionalCodeRepositories;
        this.defaultCodeRepository = props.defaultCodeRepository;
        this.directInternetAccess = props.directInternetAccess;
        this.instanceMetadataServiceConfiguration = props.instanceMetadataServiceConfiguration;
        this.kmsKeyId = props.kmsKeyId;
        this.lifecycleConfigName = props.lifecycleConfigName;
        this.notebookInstanceName = props.notebookInstanceName;
        this.platformIdentifier = props.platformIdentifier;
        this.rootAccess = props.rootAccess;
        this.securityGroupIds = props.securityGroupIds;
        this.subnetId = props.subnetId;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::SageMaker::NotebookInstance", props.tags, { tagPropertyName: 'tags' });
        this.volumeSizeInGb = props.volumeSizeInGb;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnNotebookInstancePropsFromCloudFormation(resourceProperties);
        const ret = new CfnNotebookInstance(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnNotebookInstance.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            instanceType: this.instanceType,
            roleArn: this.roleArn,
            acceleratorTypes: this.acceleratorTypes,
            additionalCodeRepositories: this.additionalCodeRepositories,
            defaultCodeRepository: this.defaultCodeRepository,
            directInternetAccess: this.directInternetAccess,
            instanceMetadataServiceConfiguration: this.instanceMetadataServiceConfiguration,
            kmsKeyId: this.kmsKeyId,
            lifecycleConfigName: this.lifecycleConfigName,
            notebookInstanceName: this.notebookInstanceName,
            platformIdentifier: this.platformIdentifier,
            rootAccess: this.rootAccess,
            securityGroupIds: this.securityGroupIds,
            subnetId: this.subnetId,
            tags: this.tags.renderTags(),
            volumeSizeInGb: this.volumeSizeInGb,
        };
    }
    renderProperties(props) {
        return cfnNotebookInstancePropsToCloudFormation(props);
    }
}
exports.CfnNotebookInstance = CfnNotebookInstance;
_v = JSII_RTTI_SYMBOL_1;
CfnNotebookInstance[_v] = { fqn: "@aws-cdk/aws-sagemaker.CfnNotebookInstance", version: "1.186.1" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnNotebookInstance.CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::NotebookInstance";
/**
 * Determine whether the given properties match those of a `InstanceMetadataServiceConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `InstanceMetadataServiceConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnNotebookInstance_InstanceMetadataServiceConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('minimumInstanceMetadataServiceVersion', cdk.requiredValidator)(properties.minimumInstanceMetadataServiceVersion));
    errors.collect(cdk.propertyValidator('minimumInstanceMetadataServiceVersion', cdk.validateString)(properties.minimumInstanceMetadataServiceVersion));
    return errors.wrap('supplied properties not correct for "InstanceMetadataServiceConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::NotebookInstance.InstanceMetadataServiceConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `InstanceMetadataServiceConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::NotebookInstance.InstanceMetadataServiceConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnNotebookInstanceInstanceMetadataServiceConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnNotebookInstance_InstanceMetadataServiceConfigurationPropertyValidator(properties).assertSuccess();
    return {
        MinimumInstanceMetadataServiceVersion: cdk.stringToCloudFormation(properties.minimumInstanceMetadataServiceVersion),
    };
}
// @ts-ignore TS6133
function CfnNotebookInstanceInstanceMetadataServiceConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('minimumInstanceMetadataServiceVersion', 'MinimumInstanceMetadataServiceVersion', cfn_parse.FromCloudFormation.getString(properties.MinimumInstanceMetadataServiceVersion));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnNotebookInstanceLifecycleConfigProps`
 *
 * @param properties - the TypeScript properties of a `CfnNotebookInstanceLifecycleConfigProps`
 *
 * @returns the result of the validation.
 */
function CfnNotebookInstanceLifecycleConfigPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('notebookInstanceLifecycleConfigName', cdk.validateString)(properties.notebookInstanceLifecycleConfigName));
    errors.collect(cdk.propertyValidator('onCreate', cdk.listValidator(CfnNotebookInstanceLifecycleConfig_NotebookInstanceLifecycleHookPropertyValidator))(properties.onCreate));
    errors.collect(cdk.propertyValidator('onStart', cdk.listValidator(CfnNotebookInstanceLifecycleConfig_NotebookInstanceLifecycleHookPropertyValidator))(properties.onStart));
    return errors.wrap('supplied properties not correct for "CfnNotebookInstanceLifecycleConfigProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::NotebookInstanceLifecycleConfig` resource
 *
 * @param properties - the TypeScript properties of a `CfnNotebookInstanceLifecycleConfigProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::NotebookInstanceLifecycleConfig` resource.
 */
// @ts-ignore TS6133
function cfnNotebookInstanceLifecycleConfigPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnNotebookInstanceLifecycleConfigPropsValidator(properties).assertSuccess();
    return {
        NotebookInstanceLifecycleConfigName: cdk.stringToCloudFormation(properties.notebookInstanceLifecycleConfigName),
        OnCreate: cdk.listMapper(cfnNotebookInstanceLifecycleConfigNotebookInstanceLifecycleHookPropertyToCloudFormation)(properties.onCreate),
        OnStart: cdk.listMapper(cfnNotebookInstanceLifecycleConfigNotebookInstanceLifecycleHookPropertyToCloudFormation)(properties.onStart),
    };
}
// @ts-ignore TS6133
function CfnNotebookInstanceLifecycleConfigPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('notebookInstanceLifecycleConfigName', 'NotebookInstanceLifecycleConfigName', properties.NotebookInstanceLifecycleConfigName != null ? cfn_parse.FromCloudFormation.getString(properties.NotebookInstanceLifecycleConfigName) : undefined);
    ret.addPropertyResult('onCreate', 'OnCreate', properties.OnCreate != null ? cfn_parse.FromCloudFormation.getArray(CfnNotebookInstanceLifecycleConfigNotebookInstanceLifecycleHookPropertyFromCloudFormation)(properties.OnCreate) : undefined);
    ret.addPropertyResult('onStart', 'OnStart', properties.OnStart != null ? cfn_parse.FromCloudFormation.getArray(CfnNotebookInstanceLifecycleConfigNotebookInstanceLifecycleHookPropertyFromCloudFormation)(properties.OnStart) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::SageMaker::NotebookInstanceLifecycleConfig`
 *
 * The `AWS::SageMaker::NotebookInstanceLifecycleConfig` resource creates shell scripts that run when you create and/or start a notebook instance. For information about notebook instance lifecycle configurations, see [Customize a Notebook Instance](https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html) in the *Amazon SageMaker Developer Guide* .
 *
 * @cloudformationResource AWS::SageMaker::NotebookInstanceLifecycleConfig
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstancelifecycleconfig.html
 */
class CfnNotebookInstanceLifecycleConfig extends cdk.CfnResource {
    /**
     * Create a new `AWS::SageMaker::NotebookInstanceLifecycleConfig`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}) {
        super(scope, id, { type: CfnNotebookInstanceLifecycleConfig.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_sagemaker_CfnNotebookInstanceLifecycleConfigProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnNotebookInstanceLifecycleConfig);
            }
            throw error;
        }
        this.attrNotebookInstanceLifecycleConfigName = cdk.Token.asString(this.getAtt('NotebookInstanceLifecycleConfigName'));
        this.notebookInstanceLifecycleConfigName = props.notebookInstanceLifecycleConfigName;
        this.onCreate = props.onCreate;
        this.onStart = props.onStart;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnNotebookInstanceLifecycleConfigPropsFromCloudFormation(resourceProperties);
        const ret = new CfnNotebookInstanceLifecycleConfig(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnNotebookInstanceLifecycleConfig.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            notebookInstanceLifecycleConfigName: this.notebookInstanceLifecycleConfigName,
            onCreate: this.onCreate,
            onStart: this.onStart,
        };
    }
    renderProperties(props) {
        return cfnNotebookInstanceLifecycleConfigPropsToCloudFormation(props);
    }
}
exports.CfnNotebookInstanceLifecycleConfig = CfnNotebookInstanceLifecycleConfig;
_w = JSII_RTTI_SYMBOL_1;
CfnNotebookInstanceLifecycleConfig[_w] = { fqn: "@aws-cdk/aws-sagemaker.CfnNotebookInstanceLifecycleConfig", version: "1.186.1" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnNotebookInstanceLifecycleConfig.CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::NotebookInstanceLifecycleConfig";
/**
 * Determine whether the given properties match those of a `NotebookInstanceLifecycleHookProperty`
 *
 * @param properties - the TypeScript properties of a `NotebookInstanceLifecycleHookProperty`
 *
 * @returns the result of the validation.
 */
function CfnNotebookInstanceLifecycleConfig_NotebookInstanceLifecycleHookPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('content', cdk.validateString)(properties.content));
    return errors.wrap('supplied properties not correct for "NotebookInstanceLifecycleHookProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::NotebookInstanceLifecycleConfig.NotebookInstanceLifecycleHook` resource
 *
 * @param properties - the TypeScript properties of a `NotebookInstanceLifecycleHookProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::NotebookInstanceLifecycleConfig.NotebookInstanceLifecycleHook` resource.
 */
// @ts-ignore TS6133
function cfnNotebookInstanceLifecycleConfigNotebookInstanceLifecycleHookPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnNotebookInstanceLifecycleConfig_NotebookInstanceLifecycleHookPropertyValidator(properties).assertSuccess();
    return {
        Content: cdk.stringToCloudFormation(properties.content),
    };
}
// @ts-ignore TS6133
function CfnNotebookInstanceLifecycleConfigNotebookInstanceLifecycleHookPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('content', 'Content', properties.Content != null ? cfn_parse.FromCloudFormation.getString(properties.Content) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnPipelineProps`
 *
 * @param properties - the TypeScript properties of a `CfnPipelineProps`
 *
 * @returns the result of the validation.
 */
function CfnPipelinePropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('parallelismConfiguration', cdk.validateObject)(properties.parallelismConfiguration));
    errors.collect(cdk.propertyValidator('pipelineDefinition', cdk.requiredValidator)(properties.pipelineDefinition));
    errors.collect(cdk.propertyValidator('pipelineDefinition', cdk.validateObject)(properties.pipelineDefinition));
    errors.collect(cdk.propertyValidator('pipelineDescription', cdk.validateString)(properties.pipelineDescription));
    errors.collect(cdk.propertyValidator('pipelineDisplayName', cdk.validateString)(properties.pipelineDisplayName));
    errors.collect(cdk.propertyValidator('pipelineName', cdk.requiredValidator)(properties.pipelineName));
    errors.collect(cdk.propertyValidator('pipelineName', cdk.validateString)(properties.pipelineName));
    errors.collect(cdk.propertyValidator('roleArn', cdk.requiredValidator)(properties.roleArn));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnPipelineProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::Pipeline` resource
 *
 * @param properties - the TypeScript properties of a `CfnPipelineProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::Pipeline` resource.
 */
// @ts-ignore TS6133
function cfnPipelinePropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPipelinePropsValidator(properties).assertSuccess();
    return {
        PipelineDefinition: cdk.objectToCloudFormation(properties.pipelineDefinition),
        PipelineName: cdk.stringToCloudFormation(properties.pipelineName),
        RoleArn: cdk.stringToCloudFormation(properties.roleArn),
        ParallelismConfiguration: cdk.objectToCloudFormation(properties.parallelismConfiguration),
        PipelineDescription: cdk.stringToCloudFormation(properties.pipelineDescription),
        PipelineDisplayName: cdk.stringToCloudFormation(properties.pipelineDisplayName),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnPipelinePropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('pipelineDefinition', 'PipelineDefinition', cfn_parse.FromCloudFormation.getAny(properties.PipelineDefinition));
    ret.addPropertyResult('pipelineName', 'PipelineName', cfn_parse.FromCloudFormation.getString(properties.PipelineName));
    ret.addPropertyResult('roleArn', 'RoleArn', cfn_parse.FromCloudFormation.getString(properties.RoleArn));
    ret.addPropertyResult('parallelismConfiguration', 'ParallelismConfiguration', properties.ParallelismConfiguration != null ? cfn_parse.FromCloudFormation.getAny(properties.ParallelismConfiguration) : undefined);
    ret.addPropertyResult('pipelineDescription', 'PipelineDescription', properties.PipelineDescription != null ? cfn_parse.FromCloudFormation.getString(properties.PipelineDescription) : undefined);
    ret.addPropertyResult('pipelineDisplayName', 'PipelineDisplayName', properties.PipelineDisplayName != null ? cfn_parse.FromCloudFormation.getString(properties.PipelineDisplayName) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::SageMaker::Pipeline`
 *
 * The `AWS::SageMaker::Pipeline` resource creates shell scripts that run when you create and/or start a SageMaker Pipeline. For information about SageMaker Pipelines, see [SageMaker Pipelines](https://docs.aws.amazon.com/sagemaker/latest/dg/pipelines.html) in the *Amazon SageMaker Developer Guide* .
 *
 * @cloudformationResource AWS::SageMaker::Pipeline
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-pipeline.html
 */
class CfnPipeline extends cdk.CfnResource {
    /**
     * Create a new `AWS::SageMaker::Pipeline`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnPipeline.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_sagemaker_CfnPipelineProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnPipeline);
            }
            throw error;
        }
        cdk.requireProperty(props, 'pipelineDefinition', this);
        cdk.requireProperty(props, 'pipelineName', this);
        cdk.requireProperty(props, 'roleArn', this);
        this.pipelineDefinition = props.pipelineDefinition;
        this.pipelineName = props.pipelineName;
        this.roleArn = props.roleArn;
        this.parallelismConfiguration = props.parallelismConfiguration;
        this.pipelineDescription = props.pipelineDescription;
        this.pipelineDisplayName = props.pipelineDisplayName;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::SageMaker::Pipeline", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnPipelinePropsFromCloudFormation(resourceProperties);
        const ret = new CfnPipeline(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnPipeline.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            pipelineDefinition: this.pipelineDefinition,
            pipelineName: this.pipelineName,
            roleArn: this.roleArn,
            parallelismConfiguration: this.parallelismConfiguration,
            pipelineDescription: this.pipelineDescription,
            pipelineDisplayName: this.pipelineDisplayName,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnPipelinePropsToCloudFormation(props);
    }
}
exports.CfnPipeline = CfnPipeline;
_x = JSII_RTTI_SYMBOL_1;
CfnPipeline[_x] = { fqn: "@aws-cdk/aws-sagemaker.CfnPipeline", version: "1.186.1" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnPipeline.CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::Pipeline";
/**
 * Determine whether the given properties match those of a `ParallelismConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `ParallelismConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnPipeline_ParallelismConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('maxParallelExecutionSteps', cdk.requiredValidator)(properties.maxParallelExecutionSteps));
    errors.collect(cdk.propertyValidator('maxParallelExecutionSteps', cdk.validateNumber)(properties.maxParallelExecutionSteps));
    return errors.wrap('supplied properties not correct for "ParallelismConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::Pipeline.ParallelismConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `ParallelismConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::Pipeline.ParallelismConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnPipelineParallelismConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPipeline_ParallelismConfigurationPropertyValidator(properties).assertSuccess();
    return {
        MaxParallelExecutionSteps: cdk.numberToCloudFormation(properties.maxParallelExecutionSteps),
    };
}
// @ts-ignore TS6133
function CfnPipelineParallelismConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('maxParallelExecutionSteps', 'MaxParallelExecutionSteps', cfn_parse.FromCloudFormation.getNumber(properties.MaxParallelExecutionSteps));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PipelineDefinitionProperty`
 *
 * @param properties - the TypeScript properties of a `PipelineDefinitionProperty`
 *
 * @returns the result of the validation.
 */
function CfnPipeline_PipelineDefinitionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('pipelineDefinitionBody', cdk.validateString)(properties.pipelineDefinitionBody));
    errors.collect(cdk.propertyValidator('pipelineDefinitionS3Location', CfnPipeline_S3LocationPropertyValidator)(properties.pipelineDefinitionS3Location));
    return errors.wrap('supplied properties not correct for "PipelineDefinitionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::Pipeline.PipelineDefinition` resource
 *
 * @param properties - the TypeScript properties of a `PipelineDefinitionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::Pipeline.PipelineDefinition` resource.
 */
// @ts-ignore TS6133
function cfnPipelinePipelineDefinitionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPipeline_PipelineDefinitionPropertyValidator(properties).assertSuccess();
    return {
        PipelineDefinitionBody: cdk.stringToCloudFormation(properties.pipelineDefinitionBody),
        PipelineDefinitionS3Location: cfnPipelineS3LocationPropertyToCloudFormation(properties.pipelineDefinitionS3Location),
    };
}
// @ts-ignore TS6133
function CfnPipelinePipelineDefinitionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('pipelineDefinitionBody', 'PipelineDefinitionBody', properties.PipelineDefinitionBody != null ? cfn_parse.FromCloudFormation.getString(properties.PipelineDefinitionBody) : undefined);
    ret.addPropertyResult('pipelineDefinitionS3Location', 'PipelineDefinitionS3Location', properties.PipelineDefinitionS3Location != null ? CfnPipelineS3LocationPropertyFromCloudFormation(properties.PipelineDefinitionS3Location) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `S3LocationProperty`
 *
 * @param properties - the TypeScript properties of a `S3LocationProperty`
 *
 * @returns the result of the validation.
 */
function CfnPipeline_S3LocationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('bucket', cdk.requiredValidator)(properties.bucket));
    errors.collect(cdk.propertyValidator('bucket', cdk.validateString)(properties.bucket));
    errors.collect(cdk.propertyValidator('eTag', cdk.validateString)(properties.eTag));
    errors.collect(cdk.propertyValidator('key', cdk.requiredValidator)(properties.key));
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('version', cdk.validateString)(properties.version));
    return errors.wrap('supplied properties not correct for "S3LocationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::Pipeline.S3Location` resource
 *
 * @param properties - the TypeScript properties of a `S3LocationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::Pipeline.S3Location` resource.
 */
// @ts-ignore TS6133
function cfnPipelineS3LocationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPipeline_S3LocationPropertyValidator(properties).assertSuccess();
    return {
        Bucket: cdk.stringToCloudFormation(properties.bucket),
        ETag: cdk.stringToCloudFormation(properties.eTag),
        Key: cdk.stringToCloudFormation(properties.key),
        Version: cdk.stringToCloudFormation(properties.version),
    };
}
// @ts-ignore TS6133
function CfnPipelineS3LocationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('bucket', 'Bucket', cfn_parse.FromCloudFormation.getString(properties.Bucket));
    ret.addPropertyResult('eTag', 'ETag', properties.ETag != null ? cfn_parse.FromCloudFormation.getString(properties.ETag) : undefined);
    ret.addPropertyResult('key', 'Key', cfn_parse.FromCloudFormation.getString(properties.Key));
    ret.addPropertyResult('version', 'Version', properties.Version != null ? cfn_parse.FromCloudFormation.getString(properties.Version) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnProjectProps`
 *
 * @param properties - the TypeScript properties of a `CfnProjectProps`
 *
 * @returns the result of the validation.
 */
function CfnProjectPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('projectDescription', cdk.validateString)(properties.projectDescription));
    errors.collect(cdk.propertyValidator('projectName', cdk.requiredValidator)(properties.projectName));
    errors.collect(cdk.propertyValidator('projectName', cdk.validateString)(properties.projectName));
    errors.collect(cdk.propertyValidator('serviceCatalogProvisioningDetails', cdk.requiredValidator)(properties.serviceCatalogProvisioningDetails));
    errors.collect(cdk.propertyValidator('serviceCatalogProvisioningDetails', cdk.validateObject)(properties.serviceCatalogProvisioningDetails));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnProjectProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::Project` resource
 *
 * @param properties - the TypeScript properties of a `CfnProjectProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::Project` resource.
 */
// @ts-ignore TS6133
function cfnProjectPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnProjectPropsValidator(properties).assertSuccess();
    return {
        ProjectName: cdk.stringToCloudFormation(properties.projectName),
        ServiceCatalogProvisioningDetails: cdk.objectToCloudFormation(properties.serviceCatalogProvisioningDetails),
        ProjectDescription: cdk.stringToCloudFormation(properties.projectDescription),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnProjectPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('projectName', 'ProjectName', cfn_parse.FromCloudFormation.getString(properties.ProjectName));
    ret.addPropertyResult('serviceCatalogProvisioningDetails', 'ServiceCatalogProvisioningDetails', cfn_parse.FromCloudFormation.getAny(properties.ServiceCatalogProvisioningDetails));
    ret.addPropertyResult('projectDescription', 'ProjectDescription', properties.ProjectDescription != null ? cfn_parse.FromCloudFormation.getString(properties.ProjectDescription) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::SageMaker::Project`
 *
 * Creates a machine learning (ML) project that can contain one or more templates that set up an ML pipeline from training to deploying an approved model.
 *
 * @cloudformationResource AWS::SageMaker::Project
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-project.html
 */
class CfnProject extends cdk.CfnResource {
    /**
     * Create a new `AWS::SageMaker::Project`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnProject.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_sagemaker_CfnProjectProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnProject);
            }
            throw error;
        }
        cdk.requireProperty(props, 'projectName', this);
        cdk.requireProperty(props, 'serviceCatalogProvisioningDetails', this);
        this.attrCreationTime = cdk.Token.asString(this.getAtt('CreationTime'));
        this.attrProjectArn = cdk.Token.asString(this.getAtt('ProjectArn'));
        this.attrProjectId = cdk.Token.asString(this.getAtt('ProjectId'));
        this.attrProjectStatus = cdk.Token.asString(this.getAtt('ProjectStatus'));
        this.attrServiceCatalogProvisionedProductDetailsProvisionedProductId = cdk.Token.asString(this.getAtt('ServiceCatalogProvisionedProductDetails.ProvisionedProductId'));
        this.attrServiceCatalogProvisionedProductDetailsProvisionedProductStatusMessage = cdk.Token.asString(this.getAtt('ServiceCatalogProvisionedProductDetails.ProvisionedProductStatusMessage'));
        this.projectName = props.projectName;
        this.serviceCatalogProvisioningDetails = props.serviceCatalogProvisioningDetails;
        this.projectDescription = props.projectDescription;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::SageMaker::Project", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnProjectPropsFromCloudFormation(resourceProperties);
        const ret = new CfnProject(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnProject.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            projectName: this.projectName,
            serviceCatalogProvisioningDetails: this.serviceCatalogProvisioningDetails,
            projectDescription: this.projectDescription,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnProjectPropsToCloudFormation(props);
    }
}
exports.CfnProject = CfnProject;
_y = JSII_RTTI_SYMBOL_1;
CfnProject[_y] = { fqn: "@aws-cdk/aws-sagemaker.CfnProject", version: "1.186.1" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnProject.CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::Project";
/**
 * Determine whether the given properties match those of a `ProvisioningParameterProperty`
 *
 * @param properties - the TypeScript properties of a `ProvisioningParameterProperty`
 *
 * @returns the result of the validation.
 */
function CfnProject_ProvisioningParameterPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('key', cdk.requiredValidator)(properties.key));
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('value', cdk.requiredValidator)(properties.value));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "ProvisioningParameterProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::Project.ProvisioningParameter` resource
 *
 * @param properties - the TypeScript properties of a `ProvisioningParameterProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::Project.ProvisioningParameter` resource.
 */
// @ts-ignore TS6133
function cfnProjectProvisioningParameterPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnProject_ProvisioningParameterPropertyValidator(properties).assertSuccess();
    return {
        Key: cdk.stringToCloudFormation(properties.key),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnProjectProvisioningParameterPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('key', 'Key', cfn_parse.FromCloudFormation.getString(properties.Key));
    ret.addPropertyResult('value', 'Value', cfn_parse.FromCloudFormation.getString(properties.Value));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ServiceCatalogProvisionedProductDetailsProperty`
 *
 * @param properties - the TypeScript properties of a `ServiceCatalogProvisionedProductDetailsProperty`
 *
 * @returns the result of the validation.
 */
function CfnProject_ServiceCatalogProvisionedProductDetailsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('provisionedProductId', cdk.validateString)(properties.provisionedProductId));
    errors.collect(cdk.propertyValidator('provisionedProductStatusMessage', cdk.validateString)(properties.provisionedProductStatusMessage));
    return errors.wrap('supplied properties not correct for "ServiceCatalogProvisionedProductDetailsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::Project.ServiceCatalogProvisionedProductDetails` resource
 *
 * @param properties - the TypeScript properties of a `ServiceCatalogProvisionedProductDetailsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::Project.ServiceCatalogProvisionedProductDetails` resource.
 */
// @ts-ignore TS6133
function cfnProjectServiceCatalogProvisionedProductDetailsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnProject_ServiceCatalogProvisionedProductDetailsPropertyValidator(properties).assertSuccess();
    return {
        ProvisionedProductId: cdk.stringToCloudFormation(properties.provisionedProductId),
        ProvisionedProductStatusMessage: cdk.stringToCloudFormation(properties.provisionedProductStatusMessage),
    };
}
// @ts-ignore TS6133
function CfnProjectServiceCatalogProvisionedProductDetailsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('provisionedProductId', 'ProvisionedProductId', properties.ProvisionedProductId != null ? cfn_parse.FromCloudFormation.getString(properties.ProvisionedProductId) : undefined);
    ret.addPropertyResult('provisionedProductStatusMessage', 'ProvisionedProductStatusMessage', properties.ProvisionedProductStatusMessage != null ? cfn_parse.FromCloudFormation.getString(properties.ProvisionedProductStatusMessage) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ServiceCatalogProvisioningDetailsProperty`
 *
 * @param properties - the TypeScript properties of a `ServiceCatalogProvisioningDetailsProperty`
 *
 * @returns the result of the validation.
 */
function CfnProject_ServiceCatalogProvisioningDetailsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('pathId', cdk.validateString)(properties.pathId));
    errors.collect(cdk.propertyValidator('productId', cdk.requiredValidator)(properties.productId));
    errors.collect(cdk.propertyValidator('productId', cdk.validateString)(properties.productId));
    errors.collect(cdk.propertyValidator('provisioningArtifactId', cdk.validateString)(properties.provisioningArtifactId));
    errors.collect(cdk.propertyValidator('provisioningParameters', cdk.listValidator(CfnProject_ProvisioningParameterPropertyValidator))(properties.provisioningParameters));
    return errors.wrap('supplied properties not correct for "ServiceCatalogProvisioningDetailsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::Project.ServiceCatalogProvisioningDetails` resource
 *
 * @param properties - the TypeScript properties of a `ServiceCatalogProvisioningDetailsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::Project.ServiceCatalogProvisioningDetails` resource.
 */
// @ts-ignore TS6133
function cfnProjectServiceCatalogProvisioningDetailsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnProject_ServiceCatalogProvisioningDetailsPropertyValidator(properties).assertSuccess();
    return {
        PathId: cdk.stringToCloudFormation(properties.pathId),
        ProductId: cdk.stringToCloudFormation(properties.productId),
        ProvisioningArtifactId: cdk.stringToCloudFormation(properties.provisioningArtifactId),
        ProvisioningParameters: cdk.listMapper(cfnProjectProvisioningParameterPropertyToCloudFormation)(properties.provisioningParameters),
    };
}
// @ts-ignore TS6133
function CfnProjectServiceCatalogProvisioningDetailsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('pathId', 'PathId', properties.PathId != null ? cfn_parse.FromCloudFormation.getString(properties.PathId) : undefined);
    ret.addPropertyResult('productId', 'ProductId', cfn_parse.FromCloudFormation.getString(properties.ProductId));
    ret.addPropertyResult('provisioningArtifactId', 'ProvisioningArtifactId', properties.ProvisioningArtifactId != null ? cfn_parse.FromCloudFormation.getString(properties.ProvisioningArtifactId) : undefined);
    ret.addPropertyResult('provisioningParameters', 'ProvisioningParameters', properties.ProvisioningParameters != null ? cfn_parse.FromCloudFormation.getArray(CfnProjectProvisioningParameterPropertyFromCloudFormation)(properties.ProvisioningParameters) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnUserProfileProps`
 *
 * @param properties - the TypeScript properties of a `CfnUserProfileProps`
 *
 * @returns the result of the validation.
 */
function CfnUserProfilePropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('domainId', cdk.requiredValidator)(properties.domainId));
    errors.collect(cdk.propertyValidator('domainId', cdk.validateString)(properties.domainId));
    errors.collect(cdk.propertyValidator('singleSignOnUserIdentifier', cdk.validateString)(properties.singleSignOnUserIdentifier));
    errors.collect(cdk.propertyValidator('singleSignOnUserValue', cdk.validateString)(properties.singleSignOnUserValue));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('userProfileName', cdk.requiredValidator)(properties.userProfileName));
    errors.collect(cdk.propertyValidator('userProfileName', cdk.validateString)(properties.userProfileName));
    errors.collect(cdk.propertyValidator('userSettings', CfnUserProfile_UserSettingsPropertyValidator)(properties.userSettings));
    return errors.wrap('supplied properties not correct for "CfnUserProfileProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::UserProfile` resource
 *
 * @param properties - the TypeScript properties of a `CfnUserProfileProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::UserProfile` resource.
 */
// @ts-ignore TS6133
function cfnUserProfilePropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserProfilePropsValidator(properties).assertSuccess();
    return {
        DomainId: cdk.stringToCloudFormation(properties.domainId),
        UserProfileName: cdk.stringToCloudFormation(properties.userProfileName),
        SingleSignOnUserIdentifier: cdk.stringToCloudFormation(properties.singleSignOnUserIdentifier),
        SingleSignOnUserValue: cdk.stringToCloudFormation(properties.singleSignOnUserValue),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
        UserSettings: cfnUserProfileUserSettingsPropertyToCloudFormation(properties.userSettings),
    };
}
// @ts-ignore TS6133
function CfnUserProfilePropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('domainId', 'DomainId', cfn_parse.FromCloudFormation.getString(properties.DomainId));
    ret.addPropertyResult('userProfileName', 'UserProfileName', cfn_parse.FromCloudFormation.getString(properties.UserProfileName));
    ret.addPropertyResult('singleSignOnUserIdentifier', 'SingleSignOnUserIdentifier', properties.SingleSignOnUserIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.SingleSignOnUserIdentifier) : undefined);
    ret.addPropertyResult('singleSignOnUserValue', 'SingleSignOnUserValue', properties.SingleSignOnUserValue != null ? cfn_parse.FromCloudFormation.getString(properties.SingleSignOnUserValue) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addPropertyResult('userSettings', 'UserSettings', properties.UserSettings != null ? CfnUserProfileUserSettingsPropertyFromCloudFormation(properties.UserSettings) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::SageMaker::UserProfile`
 *
 * Creates a user profile. A user profile represents a single user within a domain, and is the main way to reference a "person" for the purposes of sharing, reporting, and other user-oriented features. This entity is created when a user onboards to Amazon SageMaker Studio. If an administrator invites a person by email or imports them from IAM Identity Center , a user profile is automatically created. A user profile is the primary holder of settings for an individual user and has a reference to the user's private Amazon Elastic File System (EFS) home directory.
 *
 * > If you're using IAM Identity Center authentication, a user in IAM Identity Center , or a group in IAM Identity Center containing that user, must be assigned to the Amazon SageMaker Studio application from the IAM Identity Center Console to create a user profile. For more information about application assignment, see [Assign user access](https://docs.aws.amazon.com/singlesignon/latest/userguide/assignuserstoapp.html) . After assignment is complete, a user profile can be created for that user in IAM Identity Center with AWS CloudFormation.
 *
 * @cloudformationResource AWS::SageMaker::UserProfile
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-userprofile.html
 */
class CfnUserProfile extends cdk.CfnResource {
    /**
     * Create a new `AWS::SageMaker::UserProfile`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnUserProfile.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_sagemaker_CfnUserProfileProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnUserProfile);
            }
            throw error;
        }
        cdk.requireProperty(props, 'domainId', this);
        cdk.requireProperty(props, 'userProfileName', this);
        this.attrUserProfileArn = cdk.Token.asString(this.getAtt('UserProfileArn'));
        this.domainId = props.domainId;
        this.userProfileName = props.userProfileName;
        this.singleSignOnUserIdentifier = props.singleSignOnUserIdentifier;
        this.singleSignOnUserValue = props.singleSignOnUserValue;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::SageMaker::UserProfile", props.tags, { tagPropertyName: 'tags' });
        this.userSettings = props.userSettings;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnUserProfilePropsFromCloudFormation(resourceProperties);
        const ret = new CfnUserProfile(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnUserProfile.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            domainId: this.domainId,
            userProfileName: this.userProfileName,
            singleSignOnUserIdentifier: this.singleSignOnUserIdentifier,
            singleSignOnUserValue: this.singleSignOnUserValue,
            tags: this.tags.renderTags(),
            userSettings: this.userSettings,
        };
    }
    renderProperties(props) {
        return cfnUserProfilePropsToCloudFormation(props);
    }
}
exports.CfnUserProfile = CfnUserProfile;
_z = JSII_RTTI_SYMBOL_1;
CfnUserProfile[_z] = { fqn: "@aws-cdk/aws-sagemaker.CfnUserProfile", version: "1.186.1" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnUserProfile.CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::UserProfile";
/**
 * Determine whether the given properties match those of a `CustomImageProperty`
 *
 * @param properties - the TypeScript properties of a `CustomImageProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserProfile_CustomImagePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('appImageConfigName', cdk.requiredValidator)(properties.appImageConfigName));
    errors.collect(cdk.propertyValidator('appImageConfigName', cdk.validateString)(properties.appImageConfigName));
    errors.collect(cdk.propertyValidator('imageName', cdk.requiredValidator)(properties.imageName));
    errors.collect(cdk.propertyValidator('imageName', cdk.validateString)(properties.imageName));
    errors.collect(cdk.propertyValidator('imageVersionNumber', cdk.validateNumber)(properties.imageVersionNumber));
    return errors.wrap('supplied properties not correct for "CustomImageProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::UserProfile.CustomImage` resource
 *
 * @param properties - the TypeScript properties of a `CustomImageProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::UserProfile.CustomImage` resource.
 */
// @ts-ignore TS6133
function cfnUserProfileCustomImagePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserProfile_CustomImagePropertyValidator(properties).assertSuccess();
    return {
        AppImageConfigName: cdk.stringToCloudFormation(properties.appImageConfigName),
        ImageName: cdk.stringToCloudFormation(properties.imageName),
        ImageVersionNumber: cdk.numberToCloudFormation(properties.imageVersionNumber),
    };
}
// @ts-ignore TS6133
function CfnUserProfileCustomImagePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('appImageConfigName', 'AppImageConfigName', cfn_parse.FromCloudFormation.getString(properties.AppImageConfigName));
    ret.addPropertyResult('imageName', 'ImageName', cfn_parse.FromCloudFormation.getString(properties.ImageName));
    ret.addPropertyResult('imageVersionNumber', 'ImageVersionNumber', properties.ImageVersionNumber != null ? cfn_parse.FromCloudFormation.getNumber(properties.ImageVersionNumber) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `JupyterServerAppSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `JupyterServerAppSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserProfile_JupyterServerAppSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('defaultResourceSpec', CfnUserProfile_ResourceSpecPropertyValidator)(properties.defaultResourceSpec));
    return errors.wrap('supplied properties not correct for "JupyterServerAppSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::UserProfile.JupyterServerAppSettings` resource
 *
 * @param properties - the TypeScript properties of a `JupyterServerAppSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::UserProfile.JupyterServerAppSettings` resource.
 */
// @ts-ignore TS6133
function cfnUserProfileJupyterServerAppSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserProfile_JupyterServerAppSettingsPropertyValidator(properties).assertSuccess();
    return {
        DefaultResourceSpec: cfnUserProfileResourceSpecPropertyToCloudFormation(properties.defaultResourceSpec),
    };
}
// @ts-ignore TS6133
function CfnUserProfileJupyterServerAppSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('defaultResourceSpec', 'DefaultResourceSpec', properties.DefaultResourceSpec != null ? CfnUserProfileResourceSpecPropertyFromCloudFormation(properties.DefaultResourceSpec) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `KernelGatewayAppSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `KernelGatewayAppSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserProfile_KernelGatewayAppSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('customImages', cdk.listValidator(CfnUserProfile_CustomImagePropertyValidator))(properties.customImages));
    errors.collect(cdk.propertyValidator('defaultResourceSpec', CfnUserProfile_ResourceSpecPropertyValidator)(properties.defaultResourceSpec));
    return errors.wrap('supplied properties not correct for "KernelGatewayAppSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::UserProfile.KernelGatewayAppSettings` resource
 *
 * @param properties - the TypeScript properties of a `KernelGatewayAppSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::UserProfile.KernelGatewayAppSettings` resource.
 */
// @ts-ignore TS6133
function cfnUserProfileKernelGatewayAppSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserProfile_KernelGatewayAppSettingsPropertyValidator(properties).assertSuccess();
    return {
        CustomImages: cdk.listMapper(cfnUserProfileCustomImagePropertyToCloudFormation)(properties.customImages),
        DefaultResourceSpec: cfnUserProfileResourceSpecPropertyToCloudFormation(properties.defaultResourceSpec),
    };
}
// @ts-ignore TS6133
function CfnUserProfileKernelGatewayAppSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('customImages', 'CustomImages', properties.CustomImages != null ? cfn_parse.FromCloudFormation.getArray(CfnUserProfileCustomImagePropertyFromCloudFormation)(properties.CustomImages) : undefined);
    ret.addPropertyResult('defaultResourceSpec', 'DefaultResourceSpec', properties.DefaultResourceSpec != null ? CfnUserProfileResourceSpecPropertyFromCloudFormation(properties.DefaultResourceSpec) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `RStudioServerProAppSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `RStudioServerProAppSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserProfile_RStudioServerProAppSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('accessStatus', cdk.validateString)(properties.accessStatus));
    errors.collect(cdk.propertyValidator('userGroup', cdk.validateString)(properties.userGroup));
    return errors.wrap('supplied properties not correct for "RStudioServerProAppSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::UserProfile.RStudioServerProAppSettings` resource
 *
 * @param properties - the TypeScript properties of a `RStudioServerProAppSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::UserProfile.RStudioServerProAppSettings` resource.
 */
// @ts-ignore TS6133
function cfnUserProfileRStudioServerProAppSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserProfile_RStudioServerProAppSettingsPropertyValidator(properties).assertSuccess();
    return {
        AccessStatus: cdk.stringToCloudFormation(properties.accessStatus),
        UserGroup: cdk.stringToCloudFormation(properties.userGroup),
    };
}
// @ts-ignore TS6133
function CfnUserProfileRStudioServerProAppSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('accessStatus', 'AccessStatus', properties.AccessStatus != null ? cfn_parse.FromCloudFormation.getString(properties.AccessStatus) : undefined);
    ret.addPropertyResult('userGroup', 'UserGroup', properties.UserGroup != null ? cfn_parse.FromCloudFormation.getString(properties.UserGroup) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ResourceSpecProperty`
 *
 * @param properties - the TypeScript properties of a `ResourceSpecProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserProfile_ResourceSpecPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('instanceType', cdk.validateString)(properties.instanceType));
    errors.collect(cdk.propertyValidator('sageMakerImageArn', cdk.validateString)(properties.sageMakerImageArn));
    errors.collect(cdk.propertyValidator('sageMakerImageVersionArn', cdk.validateString)(properties.sageMakerImageVersionArn));
    return errors.wrap('supplied properties not correct for "ResourceSpecProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::UserProfile.ResourceSpec` resource
 *
 * @param properties - the TypeScript properties of a `ResourceSpecProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::UserProfile.ResourceSpec` resource.
 */
// @ts-ignore TS6133
function cfnUserProfileResourceSpecPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserProfile_ResourceSpecPropertyValidator(properties).assertSuccess();
    return {
        InstanceType: cdk.stringToCloudFormation(properties.instanceType),
        SageMakerImageArn: cdk.stringToCloudFormation(properties.sageMakerImageArn),
        SageMakerImageVersionArn: cdk.stringToCloudFormation(properties.sageMakerImageVersionArn),
    };
}
// @ts-ignore TS6133
function CfnUserProfileResourceSpecPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('instanceType', 'InstanceType', properties.InstanceType != null ? cfn_parse.FromCloudFormation.getString(properties.InstanceType) : undefined);
    ret.addPropertyResult('sageMakerImageArn', 'SageMakerImageArn', properties.SageMakerImageArn != null ? cfn_parse.FromCloudFormation.getString(properties.SageMakerImageArn) : undefined);
    ret.addPropertyResult('sageMakerImageVersionArn', 'SageMakerImageVersionArn', properties.SageMakerImageVersionArn != null ? cfn_parse.FromCloudFormation.getString(properties.SageMakerImageVersionArn) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `SharingSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `SharingSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserProfile_SharingSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('notebookOutputOption', cdk.validateString)(properties.notebookOutputOption));
    errors.collect(cdk.propertyValidator('s3KmsKeyId', cdk.validateString)(properties.s3KmsKeyId));
    errors.collect(cdk.propertyValidator('s3OutputPath', cdk.validateString)(properties.s3OutputPath));
    return errors.wrap('supplied properties not correct for "SharingSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::UserProfile.SharingSettings` resource
 *
 * @param properties - the TypeScript properties of a `SharingSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::UserProfile.SharingSettings` resource.
 */
// @ts-ignore TS6133
function cfnUserProfileSharingSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserProfile_SharingSettingsPropertyValidator(properties).assertSuccess();
    return {
        NotebookOutputOption: cdk.stringToCloudFormation(properties.notebookOutputOption),
        S3KmsKeyId: cdk.stringToCloudFormation(properties.s3KmsKeyId),
        S3OutputPath: cdk.stringToCloudFormation(properties.s3OutputPath),
    };
}
// @ts-ignore TS6133
function CfnUserProfileSharingSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('notebookOutputOption', 'NotebookOutputOption', properties.NotebookOutputOption != null ? cfn_parse.FromCloudFormation.getString(properties.NotebookOutputOption) : undefined);
    ret.addPropertyResult('s3KmsKeyId', 'S3KmsKeyId', properties.S3KmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.S3KmsKeyId) : undefined);
    ret.addPropertyResult('s3OutputPath', 'S3OutputPath', properties.S3OutputPath != null ? cfn_parse.FromCloudFormation.getString(properties.S3OutputPath) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `UserSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `UserSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserProfile_UserSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('executionRole', cdk.validateString)(properties.executionRole));
    errors.collect(cdk.propertyValidator('jupyterServerAppSettings', CfnUserProfile_JupyterServerAppSettingsPropertyValidator)(properties.jupyterServerAppSettings));
    errors.collect(cdk.propertyValidator('kernelGatewayAppSettings', CfnUserProfile_KernelGatewayAppSettingsPropertyValidator)(properties.kernelGatewayAppSettings));
    errors.collect(cdk.propertyValidator('rStudioServerProAppSettings', CfnUserProfile_RStudioServerProAppSettingsPropertyValidator)(properties.rStudioServerProAppSettings));
    errors.collect(cdk.propertyValidator('securityGroups', cdk.listValidator(cdk.validateString))(properties.securityGroups));
    errors.collect(cdk.propertyValidator('sharingSettings', CfnUserProfile_SharingSettingsPropertyValidator)(properties.sharingSettings));
    return errors.wrap('supplied properties not correct for "UserSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::UserProfile.UserSettings` resource
 *
 * @param properties - the TypeScript properties of a `UserSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::UserProfile.UserSettings` resource.
 */
// @ts-ignore TS6133
function cfnUserProfileUserSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserProfile_UserSettingsPropertyValidator(properties).assertSuccess();
    return {
        ExecutionRole: cdk.stringToCloudFormation(properties.executionRole),
        JupyterServerAppSettings: cfnUserProfileJupyterServerAppSettingsPropertyToCloudFormation(properties.jupyterServerAppSettings),
        KernelGatewayAppSettings: cfnUserProfileKernelGatewayAppSettingsPropertyToCloudFormation(properties.kernelGatewayAppSettings),
        RStudioServerProAppSettings: cfnUserProfileRStudioServerProAppSettingsPropertyToCloudFormation(properties.rStudioServerProAppSettings),
        SecurityGroups: cdk.listMapper(cdk.stringToCloudFormation)(properties.securityGroups),
        SharingSettings: cfnUserProfileSharingSettingsPropertyToCloudFormation(properties.sharingSettings),
    };
}
// @ts-ignore TS6133
function CfnUserProfileUserSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('executionRole', 'ExecutionRole', properties.ExecutionRole != null ? cfn_parse.FromCloudFormation.getString(properties.ExecutionRole) : undefined);
    ret.addPropertyResult('jupyterServerAppSettings', 'JupyterServerAppSettings', properties.JupyterServerAppSettings != null ? CfnUserProfileJupyterServerAppSettingsPropertyFromCloudFormation(properties.JupyterServerAppSettings) : undefined);
    ret.addPropertyResult('kernelGatewayAppSettings', 'KernelGatewayAppSettings', properties.KernelGatewayAppSettings != null ? CfnUserProfileKernelGatewayAppSettingsPropertyFromCloudFormation(properties.KernelGatewayAppSettings) : undefined);
    ret.addPropertyResult('rStudioServerProAppSettings', 'RStudioServerProAppSettings', properties.RStudioServerProAppSettings != null ? CfnUserProfileRStudioServerProAppSettingsPropertyFromCloudFormation(properties.RStudioServerProAppSettings) : undefined);
    ret.addPropertyResult('securityGroups', 'SecurityGroups', properties.SecurityGroups != null ? cfn_parse.FromCloudFormation.getStringArray(properties.SecurityGroups) : undefined);
    ret.addPropertyResult('sharingSettings', 'SharingSettings', properties.SharingSettings != null ? CfnUserProfileSharingSettingsPropertyFromCloudFormation(properties.SharingSettings) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnWorkteamProps`
 *
 * @param properties - the TypeScript properties of a `CfnWorkteamProps`
 *
 * @returns the result of the validation.
 */
function CfnWorkteamPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('memberDefinitions', cdk.listValidator(CfnWorkteam_MemberDefinitionPropertyValidator))(properties.memberDefinitions));
    errors.collect(cdk.propertyValidator('notificationConfiguration', CfnWorkteam_NotificationConfigurationPropertyValidator)(properties.notificationConfiguration));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('workforceName', cdk.validateString)(properties.workforceName));
    errors.collect(cdk.propertyValidator('workteamName', cdk.validateString)(properties.workteamName));
    return errors.wrap('supplied properties not correct for "CfnWorkteamProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::Workteam` resource
 *
 * @param properties - the TypeScript properties of a `CfnWorkteamProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::Workteam` resource.
 */
// @ts-ignore TS6133
function cfnWorkteamPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnWorkteamPropsValidator(properties).assertSuccess();
    return {
        Description: cdk.stringToCloudFormation(properties.description),
        MemberDefinitions: cdk.listMapper(cfnWorkteamMemberDefinitionPropertyToCloudFormation)(properties.memberDefinitions),
        NotificationConfiguration: cfnWorkteamNotificationConfigurationPropertyToCloudFormation(properties.notificationConfiguration),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
        WorkforceName: cdk.stringToCloudFormation(properties.workforceName),
        WorkteamName: cdk.stringToCloudFormation(properties.workteamName),
    };
}
// @ts-ignore TS6133
function CfnWorkteamPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('description', 'Description', properties.Description != null ? cfn_parse.FromCloudFormation.getString(properties.Description) : undefined);
    ret.addPropertyResult('memberDefinitions', 'MemberDefinitions', properties.MemberDefinitions != null ? cfn_parse.FromCloudFormation.getArray(CfnWorkteamMemberDefinitionPropertyFromCloudFormation)(properties.MemberDefinitions) : undefined);
    ret.addPropertyResult('notificationConfiguration', 'NotificationConfiguration', properties.NotificationConfiguration != null ? CfnWorkteamNotificationConfigurationPropertyFromCloudFormation(properties.NotificationConfiguration) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addPropertyResult('workforceName', 'WorkforceName', properties.WorkforceName != null ? cfn_parse.FromCloudFormation.getString(properties.WorkforceName) : undefined);
    ret.addPropertyResult('workteamName', 'WorkteamName', properties.WorkteamName != null ? cfn_parse.FromCloudFormation.getString(properties.WorkteamName) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::SageMaker::Workteam`
 *
 * Creates a new work team for labeling your data. A work team is defined by one or more Amazon Cognito user pools. You must first create the user pools before you can create a work team.
 *
 * You cannot create more than 25 work teams in an account and region.
 *
 * @cloudformationResource AWS::SageMaker::Workteam
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html
 */
class CfnWorkteam extends cdk.CfnResource {
    /**
     * Create a new `AWS::SageMaker::Workteam`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}) {
        super(scope, id, { type: CfnWorkteam.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_sagemaker_CfnWorkteamProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnWorkteam);
            }
            throw error;
        }
        this.attrWorkteamName = cdk.Token.asString(this.getAtt('WorkteamName'));
        this.description = props.description;
        this.memberDefinitions = props.memberDefinitions;
        this.notificationConfiguration = props.notificationConfiguration;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::SageMaker::Workteam", props.tags, { tagPropertyName: 'tags' });
        this.workforceName = props.workforceName;
        this.workteamName = props.workteamName;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnWorkteamPropsFromCloudFormation(resourceProperties);
        const ret = new CfnWorkteam(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnWorkteam.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            description: this.description,
            memberDefinitions: this.memberDefinitions,
            notificationConfiguration: this.notificationConfiguration,
            tags: this.tags.renderTags(),
            workforceName: this.workforceName,
            workteamName: this.workteamName,
        };
    }
    renderProperties(props) {
        return cfnWorkteamPropsToCloudFormation(props);
    }
}
exports.CfnWorkteam = CfnWorkteam;
_0 = JSII_RTTI_SYMBOL_1;
CfnWorkteam[_0] = { fqn: "@aws-cdk/aws-sagemaker.CfnWorkteam", version: "1.186.1" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnWorkteam.CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::Workteam";
/**
 * Determine whether the given properties match those of a `CognitoMemberDefinitionProperty`
 *
 * @param properties - the TypeScript properties of a `CognitoMemberDefinitionProperty`
 *
 * @returns the result of the validation.
 */
function CfnWorkteam_CognitoMemberDefinitionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('cognitoClientId', cdk.requiredValidator)(properties.cognitoClientId));
    errors.collect(cdk.propertyValidator('cognitoClientId', cdk.validateString)(properties.cognitoClientId));
    errors.collect(cdk.propertyValidator('cognitoUserGroup', cdk.requiredValidator)(properties.cognitoUserGroup));
    errors.collect(cdk.propertyValidator('cognitoUserGroup', cdk.validateString)(properties.cognitoUserGroup));
    errors.collect(cdk.propertyValidator('cognitoUserPool', cdk.requiredValidator)(properties.cognitoUserPool));
    errors.collect(cdk.propertyValidator('cognitoUserPool', cdk.validateString)(properties.cognitoUserPool));
    return errors.wrap('supplied properties not correct for "CognitoMemberDefinitionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::Workteam.CognitoMemberDefinition` resource
 *
 * @param properties - the TypeScript properties of a `CognitoMemberDefinitionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::Workteam.CognitoMemberDefinition` resource.
 */
// @ts-ignore TS6133
function cfnWorkteamCognitoMemberDefinitionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnWorkteam_CognitoMemberDefinitionPropertyValidator(properties).assertSuccess();
    return {
        CognitoClientId: cdk.stringToCloudFormation(properties.cognitoClientId),
        CognitoUserGroup: cdk.stringToCloudFormation(properties.cognitoUserGroup),
        CognitoUserPool: cdk.stringToCloudFormation(properties.cognitoUserPool),
    };
}
// @ts-ignore TS6133
function CfnWorkteamCognitoMemberDefinitionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('cognitoClientId', 'CognitoClientId', cfn_parse.FromCloudFormation.getString(properties.CognitoClientId));
    ret.addPropertyResult('cognitoUserGroup', 'CognitoUserGroup', cfn_parse.FromCloudFormation.getString(properties.CognitoUserGroup));
    ret.addPropertyResult('cognitoUserPool', 'CognitoUserPool', cfn_parse.FromCloudFormation.getString(properties.CognitoUserPool));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MemberDefinitionProperty`
 *
 * @param properties - the TypeScript properties of a `MemberDefinitionProperty`
 *
 * @returns the result of the validation.
 */
function CfnWorkteam_MemberDefinitionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('cognitoMemberDefinition', CfnWorkteam_CognitoMemberDefinitionPropertyValidator)(properties.cognitoMemberDefinition));
    errors.collect(cdk.propertyValidator('oidcMemberDefinition', CfnWorkteam_OidcMemberDefinitionPropertyValidator)(properties.oidcMemberDefinition));
    return errors.wrap('supplied properties not correct for "MemberDefinitionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::Workteam.MemberDefinition` resource
 *
 * @param properties - the TypeScript properties of a `MemberDefinitionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::Workteam.MemberDefinition` resource.
 */
// @ts-ignore TS6133
function cfnWorkteamMemberDefinitionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnWorkteam_MemberDefinitionPropertyValidator(properties).assertSuccess();
    return {
        CognitoMemberDefinition: cfnWorkteamCognitoMemberDefinitionPropertyToCloudFormation(properties.cognitoMemberDefinition),
        OidcMemberDefinition: cfnWorkteamOidcMemberDefinitionPropertyToCloudFormation(properties.oidcMemberDefinition),
    };
}
// @ts-ignore TS6133
function CfnWorkteamMemberDefinitionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('cognitoMemberDefinition', 'CognitoMemberDefinition', properties.CognitoMemberDefinition != null ? CfnWorkteamCognitoMemberDefinitionPropertyFromCloudFormation(properties.CognitoMemberDefinition) : undefined);
    ret.addPropertyResult('oidcMemberDefinition', 'OidcMemberDefinition', properties.OidcMemberDefinition != null ? CfnWorkteamOidcMemberDefinitionPropertyFromCloudFormation(properties.OidcMemberDefinition) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `NotificationConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `NotificationConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnWorkteam_NotificationConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('notificationTopicArn', cdk.requiredValidator)(properties.notificationTopicArn));
    errors.collect(cdk.propertyValidator('notificationTopicArn', cdk.validateString)(properties.notificationTopicArn));
    return errors.wrap('supplied properties not correct for "NotificationConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::Workteam.NotificationConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `NotificationConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::Workteam.NotificationConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnWorkteamNotificationConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnWorkteam_NotificationConfigurationPropertyValidator(properties).assertSuccess();
    return {
        NotificationTopicArn: cdk.stringToCloudFormation(properties.notificationTopicArn),
    };
}
// @ts-ignore TS6133
function CfnWorkteamNotificationConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('notificationTopicArn', 'NotificationTopicArn', cfn_parse.FromCloudFormation.getString(properties.NotificationTopicArn));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `OidcMemberDefinitionProperty`
 *
 * @param properties - the TypeScript properties of a `OidcMemberDefinitionProperty`
 *
 * @returns the result of the validation.
 */
function CfnWorkteam_OidcMemberDefinitionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('oidcGroups', cdk.requiredValidator)(properties.oidcGroups));
    errors.collect(cdk.propertyValidator('oidcGroups', cdk.listValidator(cdk.validateString))(properties.oidcGroups));
    return errors.wrap('supplied properties not correct for "OidcMemberDefinitionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::SageMaker::Workteam.OidcMemberDefinition` resource
 *
 * @param properties - the TypeScript properties of a `OidcMemberDefinitionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::SageMaker::Workteam.OidcMemberDefinition` resource.
 */
// @ts-ignore TS6133
function cfnWorkteamOidcMemberDefinitionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnWorkteam_OidcMemberDefinitionPropertyValidator(properties).assertSuccess();
    return {
        OidcGroups: cdk.listMapper(cdk.stringToCloudFormation)(properties.oidcGroups),
    };
}
// @ts-ignore TS6133
function CfnWorkteamOidcMemberDefinitionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('oidcGroups', 'OidcGroups', cfn_parse.FromCloudFormation.getStringArray(properties.OidcGroups));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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