# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['console_debugger',
 'console_debugger.gui',
 'console_debugger.helpful',
 'console_debugger.logic',
 'console_debugger.test',
 'console_debugger.tui']

package_data = \
{'': ['*'], 'console_debugger.gui': ['static/icons.ico']}

install_requires = \
['urwid>=2.1.2,<3.0.0']

setup_kwargs = {
    'name': 'console-debugger',
    'version': '0.1.8.1',
    'description': 'Это подключаемая библиотека, для удобного вывода отладочной информации.',
    'long_description': '# Что это?\n\nЭто подключаемая библиотека, для удобного вывода\nотладочной информации.\n\n---\n\n# Как использовать ?\n\n## 1 Сначала нужно создать экземпляры класса Debugger\n\nМожно вручную указать параметры экземпляра\n\n- `Debug_Name = Debugger(active: bool,,title_name: str, consoleOutput: bool = True, fileConfig: Optional[Dict] = None style_text: Optional[dstyle] = None)`\n\n     - `active` = on/off жизни экземпляра, Если `False` экземпляр \n    будет игнорировать вызов, а также будет добавлен в массив `Debugger.AllCountSleepInstance`.  \n       \n    - `title_name` = Уникальное имя экземпляра которое будет отображаться в выводе.  \n    \n    - `consoleOutput` = on/off отображения в консоль или другие\n    визуальные выходы, **не влияет на запись в файл!**.  \n    \n    - `fileConfig` = Конфигурация записи в файл, входные параметры такие же как и у стандартной функции `open()`  \n        передавать в формате `Dict{"file":"test.log", ... }`. Для удобного формирования параметров можно  \n         пользоваться функцией `dopen()`.  \n    \n    - `style_text` = Стиль отображения текста. Для удобного формирования параметров можно  \n        пользоваться функцией `dstyle`.  \n\n\nИли использовать готовые параметры\n\n- `Debug_Name = Debugger(**dDEBUG)`\n    - dDEBUG\n    - dINFO\n    - dWARNING\n    - dEXCEPTION\n\n## 2 Установить глобальный стиль для всех экземпляров\n\nЭта команда влияет на все экземпляры `Debugger`\n\n- `Debugger.GlobalManager(global_status=None, typePrint: Optional[str] = "grid"):`\n    - `global_status` = Вы можете on/off все экземпляры разом\n    - `typePrint=` = Глобальный стиль отображения данных\n        - `"grid"` = Стиль таблица \n        \n        ![](https://i.imgur.com/Kif40aB.png)\n        \n        - `"socket"` = Данные будут отправляться по сокету, в данный момент есть два варианта прослушивания сокета.\n        Через GUI [Tkinter](#про-режим-отображения-tkinter) `console_debugger/main.py gui` или через TUI [Urwid](#про-режим-отображения-urwid) \n        `console_debugger/main.py tui`.\n        Если в процессе отправки данных через сокет возникнут ошибки, данные будут сохранены в файл.\n             \n        - `None` = Без стиля \n        \n        ![](https://i.imgur.com/byg84id.png)\n\n## 3 Использовать в коде\n\nИспользовать стандартную функцию `print`.\n- `print(text, file= Debug_Name)`\n    - `text` = Строка\n    - `Debug_Name` = Имя экземпляра `Debugger`\n\nИспользовать функцию `printD`. Преимущество в том что может принимать несколько переменных и соеденять их.\n\n- `printD(Debug_Name, text, *args, sep=\' \', end=\'\\n\')`\n    - `Debug_Name` = Имя экземпляра `Debugger`\n    - `text` = Строка\n    - `*args` = Данные преобразуются в тип `str`\n    - `sep=\' \', end=\'\\n\'` = такие же, как и у встроенной функции `print()`\n\n---\n\n# Примеры\n\n## Использовать свои стили, вызывать экземпляры напрямую\n\n\nДля наглядности создадим функцию для генерации случайного слово\n```python\nimport random\nimport string             \n# Сгенерировать случайное слово\nrandom_word = lambda: "".join(random.choice(string.ascii_letters) for j in range(random.randint(1, 40)))\n```\n\n```python\nfrom console_debugger import *\n\nDebug = Debugger(True,title_name="[DEBUG]",\n\n                 fileConfig=dopen(file="debug.log",\n                                  mode="a",\n                                  encoding="utf-8"),\n\n                 style_text=dstyle(bg_color="bg_blue",\n                                   len_word=21)\n                 )\nInfo = Debugger(True,title_name="[INFO]",\n\n                fileConfig={"file": "info.log",\n                            "mode": "a", "encoding": "utf-8"},\n                style_text=dstyle(len_word=25),\n\n                consoleOutput=False\n                )\nWarning = Debugger(True,"[WARNING]", style_text=dstyle(len_word=25))\n\nDebugger.GlobalManager(typePrint="grid")\n\nif __name__ == \'__main__\':\n    for i in range(10):\n        printD(Debug, random_word())\n        printD(Warning, random_word())\n        printD(Info, random_word())\n```\n\n## Использовать готовые стили, вызывать `printD`\n\n```python\nfrom console_debugger import *\n\nDebug = Debugger(**dDEBUG)\nInfo = Debugger(**dINFO)\nWarning = Debugger(**dWARNING)\n\nDebugger.GlobalManager(typePrint="grid")\n\nif __name__ == \'__main__\':\n    for i in range(10):\n        printD(Debug, random_word())\n        printD(Warning, random_word())\n        printD(Info, random_word())\n```\n\n## Использовать готовые стили, вызывать `print`\n```python\nfrom console_debugger import *\n\nDebug = Debugger(**dDEBUG)\nInfo = Debugger(**dINFO)\nWarning = Debugger(**dWARNING)\n\nDebugger.GlobalManager(typePrint="socket")\n\nif __name__ == \'__main__\':\n    for i in range(10):\n\tprint(random_word(), file=Debug)\n\tprint(random_word(), file=Info)\n\tprint(random_word(), file=Warning)\n```\n\n## Использовать `soket`\n```python\nfrom console_debugger import *\n\n\nDebug = Debugger(**dDEBUG)\nInfo = Debugger(**dINFO)\nWarning = Debugger(**dWARNING)\nTEST = Debugger(True,"TEST")\n\nDebugger.GlobalManager(typePrint="socket")\n\n\nfor i in range(10):\n    printD(Debug, random_word())\n    printD(Info, random_word())\n    printD(Warning, random_word())\n    printD(TEST, random_word())\n```\n\n## Использование Глобального режима on/off \nСоздать два режима запуска Debug/Release\n![](https://i.imgur.com/guFWf3O.png)\n\n`main.pyw`\n```python\nimport sys\nfrom console_debugger import Debugger\nfrom app.viwe import Windows # При импорте должны быть созданы все экземпляры\n\nif __name__ == \'__main__\':\n    for param in set(sys.argv):\n        if param == "--d":\n            Debugger.GlobalManager(typePrint="grid") # Задать глобальный стиль всем экземпляром\n            break\n    else:\n        Debugger.GlobalManager(global_status=False) # Если нет параметров отключаем все экземпляры \n    Windows()\n```\nВ других модулях создаем необходимые экземпляры\n```python\nfrom console_debugger import *\nHotKeyD = Debugger(True, "[HotKey]")\nPressKeyD = Debugger(True, "[PressKey]")\nInfoD = Debugger(**dINFO)\nResD = Debugger(True, "[Result]", style_text=dstyle(len_word=25, height=4))\n\nprintD(HotKeyD,"Crtl+c")\n```\n\n# Пример трассировки переменных\n\n```python\nimport random\nimport string\n\nrandom_word = lambda: "".join(random.choice(string.ascii_letters) for j in range(random.randint(1, 40)))\n\nfrom console_debugger import *\n\nif __name__ == \'__main__\':\n\ta = Debugger(**dDEBUG)\n\tb = Debugger(**dINFO)\n\tc = Debugger(**dEXCEPTION)\n\n\tDebugger.GlobalManager(typePrint="socket")\n\n\tTracingName1 = "1"\n\tTracingName2 = ["1"]\n\tTracingName3 = "1",\n\n\tfor x in range(10):\n\t\tprintD(a, TracingName1)\n\t\tprintD(b, TracingName2)\n\t\tprintD(c, TracingName3)\n```\n![](https://i.imgur.com/8ctYa9G.png)\n\n\n## Использование во `Flask`\n\nПоместить `Debugger.GlobalManager` в `@app.before_first_request`\n```python\nfrom console_debugger import *\nfrom flask import * \n\nSECRET_KEY = "123_very_hard_password"\napp = Flask(__name__)\n\n # Экземпляры в глобальной области видимости\ncookDeb = Debugger(True, "[Cook]")\nsessionDeb = Debugger(True, "[Session]")\n\n@app.before_first_request\ndef deb():\n    # Tkinter будет перезапускаться при каждом обновление сервера\n    Debugger.GlobalManager(typePrint="socket")\n\n@app.route("/login", methods=[\'POST\', \'GET\'])\ndef login():\n    global data, cookDeb, sessionDeb\n    cook = "no"\n    ses = "no"\n\n    # Получить куки если есть\n    if request.cookies.get("logged"):\n        cook = request.cookies.get("logged")\n\n    # Получить данные из сессии если есть\n    if "SessioN" in session:\n        ses = session.get("SessioN")\n\n    printD(cookDeb, cook)\n    printD(sessionDeb, ses)\n\n    res = make_response(render_template("login.html", cook=cook, session=ses))\n    res.set_cookie(key="logged", value="yes", max_age=3)\n    session["SessioN"] = "yes"\n    return res\n\nif __name__ == \'__main__\':\n    app.run(debug=True)\n```\n`"login.html"`\n```html\n<script>\n    document.cookie = "ex=1;";\n    if (!document.cookie) {\n        alert("Этот сайт требует включение cookie");\n    }\n</script>\nCook: {{ cook }}\n<p></p>\nSession: {{ session }}\n<form action="/login" method="post" class="form-contact">\n    <p><label>Name </label><input type="text" name="username" value="" required/>\n    <p><label>Passwortitled </label><input type="text" name="password" value="" required/>\n    <p><input type="submit" value="Send"/>\n</form>\n```\n\n## Использование в `Django`\n```python\nimport os\nfrom console_debugger import Debugger\n\n\nif not os.environ.get(\'console_debugger\', False):\n    os.environ[\'console_debugger\'] = "True"\n    print("1")\nelse:\n    print("2")\n    Debugger.GlobalManager(typePrint="socket")\n```\n# Советы\n\n\n## Вы можете использовать шаблон для комментирования `printD`\nТак как входные параметры функции являются не изменяемыми обметками, \nто они копируются в функцию `printD`, чтобы н тратить лишении наносекунды\nна эту операцию, вы можете закомментировать все вызовы этой функции.\n \n ```cmd\n\\s{4}printD+ \n#none: printD\n```\n \n![Замена](https://i.imgur.com/cmzsU24.png)\n\nА потом раскомментировать\n\n ```cmd\n#none: printD \n    printD\n```\n![Замена](https://i.imgur.com/P0nugCD.png)\n\n \n\n## Про режим отображения Tkinter\n\n![](https://i.imgur.com/YJFYv57.png)\n- Если нажать на заголовок консоли, то они выполнят команду из нижней консоли\n- Если нажать нижнею кнопку `save geometry` то вы\nсохраните положение окна для следующих запусках, размеры сохранять в  `console_debugger/gui/static/config.txt`\n- Если закрыть окно `Tkinter`, до завершения главного потока, то данные будут отправляться в консоль `typePrint=None"`\n- Можно сохранить весь текст из консоли в файл. Для этого нужно ввести в нижнею консоль `save <NAME_FILE> <PATH>` и нажать `Enter`\n- Можно получить глобальную информацию о сокете написав в любую нижнею консоль `g info` и нажать `Enter`\n- Можно отчистить консоль вывода если написать в нижнею консоль `clear` и нажать `Enter`\n\n### Установка Tkinter на Linux\nArchLinux\n```bush\nsudo pacman -S tk\n\nxrdb -load /dev/null  \nxrdb -query \n```\n\n## Про режим отображения Urwid\n\n![](https://i.imgur.com/EQ8MLhG.png)\nРаботает также в терминале Pycharm\n![](https://i.imgur.com/hJlPVZn.png)\n\n\nЭтот режим поддерживается в терминалах Linux. Программа находиться в `console_debugger/tui/main.py`.\n\n- Можно сохранить весь текст из консоли в файл. Для этого нужно ввести `save <NAME_FILE> <PATH>` \n- Горячие клавиши\n    - `f1` = Влево\n    - `f3` = Верх\n    - `f2` = Вниз\n    - `f4` = Вправо\n    - `Tab`= Вправо\n    - `shif + ЛКМ` = Выделить текст\n    - `shif + ctrl + C` = Копировать выделенный текст\n    - `shif + ctrl + V` = Вставить текст\n\n\n  \n- Можно отчистить консоль вывода если написать в нижнею консоль `clear` и нажать `Enter`\n\n## Про доступную информации об экземпляре `Debugger`\n- public set:\n    + `consoleOutput` = Переключить on/off вывод в консоль\n    + `style_text` = Задать другой стиль текста\n    + `active()` = Включить дебагер\n    + `deactivate()` = Отключить дебагер\n    \n- public get:\n    + `title_name` = Уникальное имя дебагера\n    + `fileConfig` = Конфигурация для файла\n    + `AllCountActiveInstance()` = Все активные дебагеры\n    + `AllCountSleepInstance()` = Все приостановленный дебагиры\n    + `AllUseFileName()` = Все используемые имена файлов\n    + `AllInstance()` = Все экземпляры дебагеров\n\n\n',
    'author': 'Denis Kustov',
    'author_email': 'denis-kustov@rambler.ru',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/denisxab/console_debugger',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.5,<4.0',
}


setup(**setup_kwargs)
