#######################################################
# 
# User.py
# Python implementation of the Class User
# Generated by Enterprise Architect
# Created on:      07-Dec-2021 12:27:58 PM
# Original author: natha
# 
#######################################################
from FreeTAKServer.model.Connection import Connection
from FreeTAKServer.model.SpecificCoT.Presence import Presence
from FreeTAKServer.model.Enumerations.connectionTypes import ConnectionTypes

class User:
    """ this class defines a User object which represents a connected device within the TAK ecosystem
    a user may have multiple connections however must have at least one at any given time
    """

    def __init__(self, connection: Connection, m_presence: Presence = None):
        self.connections = {connection.connection_type: connection}
        self.m_presence = m_presence
        self.user_id = m_presence.modelObject.uid

    def get_connection(self, connection_type: ConnectionTypes) -> Connection or None:
        """get a specific connection from the user based on connectionType passed
        """
        if connection_type in self.connections:
            return self.connections[connection_type]
        else:
            return None

    def get_connections(self) -> dict:
        """get all connections associated with a user
        """
        return self.connections

    def delete_connection(self, connection_type: ConnectionTypes)-> None:
        """ delete a specific connection from the connections list

        Args:
            connection_type: the connection type to be deleted

        Returns:
            None
        """
        del self.connections[connection_type]
        return None
