import consul
import cachetools
import os
from grpclib.client import Channel
from typing import Optional,List
from syncer import sync

# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: grpc_service.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import List
import betterproto
import logging
logging.basicConfig(level=logging.INFO)

class DataType(betterproto.Enum):
    INT8 = 0
    INT32 = 1
    FP32 = 2


class DataFormat(betterproto.Enum):
    RGB = 0
    BGR = 1
    GRAY = 2
    NCHW = 3
    RAW = 4


class OutputResultType(betterproto.Enum):
    TENSOR = 0
    VECTOR = 1
    BOX = 2


@dataclass
class InferTensorData(betterproto.Message):
    byte_data: bytes = betterproto.bytes_field(1)
    int32_data: List[int] = betterproto.int32_field(2)
    fp32_data: List[float] = betterproto.float_field(3)


@dataclass
class Box(betterproto.Message):
    x1: float = betterproto.float_field(1)
    x2: float = betterproto.float_field(2)
    y1: float = betterproto.float_field(3)
    y2: float = betterproto.float_field(4)
    score: float = betterproto.float_field(5)
    type: int = betterproto.int32_field(6)


@dataclass
class VecVals(betterproto.Message):
    vals: List[float] = betterproto.float_field(1)


@dataclass
class InferRequest(betterproto.Message):
    model_name: str = betterproto.string_field(1)
    model_version: str = betterproto.string_field(2)
    backend: str = betterproto.string_field(3)
    inputs: List["InferRequestInferInputTensor"] = betterproto.message_field(4)
    return_raw_tensor: bool = betterproto.bool_field(5)
    request_id: str = betterproto.string_field(6)
    use_device_image_process: bool = betterproto.bool_field(7)


@dataclass
class InferRequestInferInputTensor(betterproto.Message):
    # / tensor name
    name: str = betterproto.string_field(1)
    data_type: "DataType" = betterproto.enum_field(2)
    data_format: "DataFormat" = betterproto.enum_field(3)
    shape: List[int] = betterproto.int64_field(4)
    box: "Box" = betterproto.message_field(5)
    landmarks: "VecVals" = betterproto.message_field(6)
    tensor_data: "InferTensorData" = betterproto.message_field(7)


@dataclass
class InferResponse(betterproto.Message):
    model_name: str = betterproto.string_field(1)
    model_version: str = betterproto.string_field(2)
    backend: str = betterproto.string_field(3)
    request_id: str = betterproto.string_field(4)
    output_tensors: List["InferResponseInferOutputTensor"] = betterproto.message_field(
        5
    )
    output_results: List["InferResponseInferOutputResult"] = betterproto.message_field(
        6
    )
    status_code: str = betterproto.string_field(7)
    status_msg: str = betterproto.string_field(8)


@dataclass
class InferResponseInferOutputTensor(betterproto.Message):
    name: str = betterproto.string_field(1)
    data_type: "DataType" = betterproto.enum_field(2)
    shape: List[int] = betterproto.int64_field(3)
    tensor_data: "InferTensorData" = betterproto.message_field(4)


@dataclass
class InferResponseInferOutputResult(betterproto.Message):
    tensors: List["InferResponseInferOutputTensor"] = betterproto.message_field(1)
    boxes: List["Box"] = betterproto.message_field(2)
    vals: List["VecVals"] = betterproto.message_field(3)
    result_type: "OutputResultType" = betterproto.enum_field(4)
    name: List[str] = betterproto.string_field(5)


@dataclass
class ModelInfoRequest(betterproto.Message):
    model_name: str = betterproto.string_field(1)
    model_version: str = betterproto.string_field(2)
    backend: str = betterproto.string_field(3)
    request_id: str = betterproto.string_field(4)


@dataclass
class ModelInfoResponse(betterproto.Message):
    model_name: str = betterproto.string_field(1)
    model_version: str = betterproto.string_field(2)
    backend: str = betterproto.string_field(3)
    request_id: str = betterproto.string_field(4)
    model_config: str = betterproto.string_field(5)
    status_code: str = betterproto.string_field(6)
    status_msg: str = betterproto.string_field(7)


@dataclass
class ModelSpeedTestRequest(betterproto.Message):
    model_name: str = betterproto.string_field(1)
    model_version: str = betterproto.string_field(2)
    backend: str = betterproto.string_field(3)
    request_id: str = betterproto.string_field(4)
    run_times: int = betterproto.uint32_field(5)
    batch: int = betterproto.uint32_field(6)


@dataclass
class ModelSpeedTestResponse(betterproto.Message):
    model_name: str = betterproto.string_field(1)
    model_version: str = betterproto.string_field(2)
    backend: str = betterproto.string_field(3)
    request_id: str = betterproto.string_field(4)
    min_time: int = betterproto.uint32_field(5)
    avg_time: int = betterproto.uint32_field(6)
    max_time: int = betterproto.uint32_field(7)
    status_code: str = betterproto.string_field(8)
    status_msg: str = betterproto.string_field(9)


class GRPCInferenceServiceStub(betterproto.ServiceStub):
    async def model_infer(
        self,
        *,
        model_name: str = "",
        model_version: str = "",
        backend: str = "",
        inputs: List["InferRequestInferInputTensor"] = [],
        return_raw_tensor: bool = False,
        request_id: str = "",
        use_device_image_process: bool = False,
    ) -> InferResponse:
        request = InferRequest()
        request.model_name = model_name
        request.model_version = model_version
        request.backend = backend
        if inputs is not None:
            request.inputs = inputs
        request.return_raw_tensor = return_raw_tensor
        request.request_id = request_id
        request.use_device_image_process = use_device_image_process

        return await self._unary_unary(
            "/inference.GRPCInferenceService/ModelInfer",
            request,
            InferResponse,
        )

    async def model_info(
        self,
        *,
        model_name: str = "",
        model_version: str = "",
        backend: str = "",
        request_id: str = "",
    ) -> ModelInfoResponse:
        request = ModelInfoRequest()
        request.model_name = model_name
        request.model_version = model_version
        request.backend = backend
        request.request_id = request_id

        return await self._unary_unary(
            "/inference.GRPCInferenceService/ModelInfo",
            request,
            ModelInfoResponse,
        )

    async def model_speed_test(
        self,
        *,
        model_name: str = "",
        model_version: str = "",
        backend: str = "",
        request_id: str = "",
        run_times: int = 0,
        batch: int = 0,
    ) -> ModelSpeedTestResponse:
        request = ModelSpeedTestRequest()
        request.model_name = model_name
        request.model_version = model_version
        request.backend = backend
        request.request_id = request_id
        request.run_times = run_times
        request.batch = batch

        return await self._unary_unary(
            "/inference.GRPCInferenceService/ModelSpeedTest",
            request,
            ModelSpeedTestResponse,
        )


class InferenceChannel(Channel):
    def __init__(self, host: Optional[str] = None, port: Optional[int] = None):
        super(InferenceChannel, self).__init__(host=host,port=port)
    def __del__(self):
        try:
            logging.info("channel close: {0}:{1}".format(self.__getattribute__("_host"),self.__getattribute__("_port")))
            self.close()
        except Exception:
            pass

class InferenceStub:
    def __init__(self, ip: str = "127.0.0.1", port: int =8500):
        self.consul_c=consul.Consul(host=ip,port=port)
        ### get cache time
        interval_res = self.consul_c.kv.get("settings/interval")
        if interval_res[1] is None:
            self.interval_time=30
        else:
            self.interval_time=(int)(interval_res[1]["Value"])
        self.cache = cachetools.TTLCache(maxsize=10,ttl=self.interval_time)
        self.channel_cache = cachetools.Cache(maxsize=10)

    def __get_stub(self,model_name: str="",model_version: str="",backend: str=""):
        model_key = os.path.join(model_name, model_version, backend)
        model_key = model_key.replace("\\","/")
        stub = self.cache.get(model_key)
        if stub is None:  ### get it from consul
            keys = self.consul_c.kv.get(key=model_key, keys=True, recurse=True)
            if keys[1] is None or len(keys[1]) == 0:
                return None
            model_full_key = keys[1][0]
            server_info = os.path.split(model_full_key)[-1]
            server_host, port = (server_info.split("_")[-1]).split(":")
            cached_channel=self.channel_cache.get(server_info)
            if cached_channel is None:
                port = int(port)
                cached_channel = InferenceChannel(host=server_host, port=port)
                self.channel_cache[server_info] = cached_channel

            self.cache.expire()
            stub = GRPCInferenceServiceStub(channel=cached_channel)
            self.cache[model_key] = stub

        logging.info("running at {0}:{1}".format(stub.channel.__getattribute__("_host"),stub.channel.__getattribute__("_port")))
        return stub

    @sync
    async def model_infer(self,model_name: str = "",
        model_version: str = "",
        backend: str = "",
        inputs: List["InferRequestInferInputTensor"] = [],
        return_raw_tensor: bool = False,
        request_id: str = "",
        use_device_image_process: bool = False,
    ) -> InferResponse:
        ### get from cache
        try:
            stub = self.__get_stub(model_name,model_version,backend)
        except Exception:
            stub = None
        if stub is None: ### get it from consul
            return InferResponse(model_name=model_name,model_version=model_version,backend=backend,
                                                   request_id=request_id,status_code="E_MODEL_NOF_FOUND",status_msg="model not found")

        return await stub.model_infer(model_name=model_name,model_version=model_version,backend=backend,inputs=inputs,return_raw_tensor=return_raw_tensor,
                                request_id=request_id,use_device_image_process=use_device_image_process)

    def model_infer_sync(self, model_name: str = "",
                          model_version: str = "",
                          backend: str = "",
                          inputs: List["InferRequestInferInputTensor"] = [],
                          return_raw_tensor: bool = False,
                          request_id: str = "",
                          use_device_image_process: bool = False,
                          ) -> InferResponse:
        return self.model_infer(model_name=model_name,model_version=model_version,backend=backend,inputs=inputs,
                                return_raw_tensor=return_raw_tensor,request_id=request_id,use_device_image_process=use_device_image_process)

    @sync
    async def model_speed_test(
        self,
        model_name: str = "",
        model_version: str = "",
        backend: str = "",
        request_id: str = "",
        run_times: int = 1,
        batch: int = 1,
    ) -> ModelSpeedTestResponse:

        stub = self.__get_stub(model_name, model_version, backend)
        if stub is None:  ### get it from consul
            return ModelSpeedTestResponse(model_name=model_name, model_version=model_version, backend=backend,
                                           request_id=request_id, status_code="E_MODEL_NOF_FOUND",
                                           status_msg="model not found")

        request = ModelSpeedTestRequest()
        request.model_name = model_name
        request.model_version = model_version
        request.backend = backend
        request.request_id = request_id
        request.run_times = run_times
        request.batch = batch
        return await stub.model_speed_test(model_name=model_name,model_version=model_version,backend=backend,request_id=request_id,
                                           run_times=run_times,batch=batch)
    def model_speed_test_sync(
        self,
        model_name: str = "",
        model_version: str = "",
        backend: str = "",
        request_id: str = "",
        run_times: int = 1,
        batch: int = 1,
    ) -> ModelSpeedTestResponse:

        return self.model_speed_test(model_name=model_name,model_version=model_version,backend=backend,request_id=request_id,
                                           run_times=run_times,batch=batch)