# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class ReportingTurnKnowledgeDocument(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ReportingTurnKnowledgeDocument - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'question': 'str',
            'answer': 'str',
            'confidence': 'float'
        }

        self.attribute_map = {
            'id': 'id',
            'question': 'question',
            'answer': 'answer',
            'confidence': 'confidence'
        }

        self._id = None
        self._question = None
        self._answer = None
        self._confidence = None

    @property
    def id(self):
        """
        Gets the id of this ReportingTurnKnowledgeDocument.
        The ID of the knowledge document.

        :return: The id of this ReportingTurnKnowledgeDocument.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ReportingTurnKnowledgeDocument.
        The ID of the knowledge document.

        :param id: The id of this ReportingTurnKnowledgeDocument.
        :type: str
        """
        

        self._id = id

    @property
    def question(self):
        """
        Gets the question of this ReportingTurnKnowledgeDocument.
        The the question that was used to match against the search query.

        :return: The question of this ReportingTurnKnowledgeDocument.
        :rtype: str
        """
        return self._question

    @question.setter
    def question(self, question):
        """
        Sets the question of this ReportingTurnKnowledgeDocument.
        The the question that was used to match against the search query.

        :param question: The question of this ReportingTurnKnowledgeDocument.
        :type: str
        """
        

        self._question = question

    @property
    def answer(self):
        """
        Gets the answer of this ReportingTurnKnowledgeDocument.
        The corresponding answer to the question.

        :return: The answer of this ReportingTurnKnowledgeDocument.
        :rtype: str
        """
        return self._answer

    @answer.setter
    def answer(self, answer):
        """
        Sets the answer of this ReportingTurnKnowledgeDocument.
        The corresponding answer to the question.

        :param answer: The answer of this ReportingTurnKnowledgeDocument.
        :type: str
        """
        

        self._answer = answer

    @property
    def confidence(self):
        """
        Gets the confidence of this ReportingTurnKnowledgeDocument.
        The confidence score of how well the question matched the search query.

        :return: The confidence of this ReportingTurnKnowledgeDocument.
        :rtype: float
        """
        return self._confidence

    @confidence.setter
    def confidence(self, confidence):
        """
        Sets the confidence of this ReportingTurnKnowledgeDocument.
        The confidence score of how well the question matched the search query.

        :param confidence: The confidence of this ReportingTurnKnowledgeDocument.
        :type: float
        """
        

        self._confidence = confidence

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

