# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class GamificationScorecardChangeTopicPunctualityEvent(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        GamificationScorecardChangeTopicPunctualityEvent - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'date_start': 'str',
            'date_schedule_start': 'str',
            'activity_code': 'str',
            'points': 'int'
        }

        self.attribute_map = {
            'date_start': 'dateStart',
            'date_schedule_start': 'dateScheduleStart',
            'activity_code': 'activityCode',
            'points': 'points'
        }

        self._date_start = None
        self._date_schedule_start = None
        self._activity_code = None
        self._points = None

    @property
    def date_start(self):
        """
        Gets the date_start of this GamificationScorecardChangeTopicPunctualityEvent.


        :return: The date_start of this GamificationScorecardChangeTopicPunctualityEvent.
        :rtype: str
        """
        return self._date_start

    @date_start.setter
    def date_start(self, date_start):
        """
        Sets the date_start of this GamificationScorecardChangeTopicPunctualityEvent.


        :param date_start: The date_start of this GamificationScorecardChangeTopicPunctualityEvent.
        :type: str
        """
        

        self._date_start = date_start

    @property
    def date_schedule_start(self):
        """
        Gets the date_schedule_start of this GamificationScorecardChangeTopicPunctualityEvent.


        :return: The date_schedule_start of this GamificationScorecardChangeTopicPunctualityEvent.
        :rtype: str
        """
        return self._date_schedule_start

    @date_schedule_start.setter
    def date_schedule_start(self, date_schedule_start):
        """
        Sets the date_schedule_start of this GamificationScorecardChangeTopicPunctualityEvent.


        :param date_schedule_start: The date_schedule_start of this GamificationScorecardChangeTopicPunctualityEvent.
        :type: str
        """
        

        self._date_schedule_start = date_schedule_start

    @property
    def activity_code(self):
        """
        Gets the activity_code of this GamificationScorecardChangeTopicPunctualityEvent.


        :return: The activity_code of this GamificationScorecardChangeTopicPunctualityEvent.
        :rtype: str
        """
        return self._activity_code

    @activity_code.setter
    def activity_code(self, activity_code):
        """
        Sets the activity_code of this GamificationScorecardChangeTopicPunctualityEvent.


        :param activity_code: The activity_code of this GamificationScorecardChangeTopicPunctualityEvent.
        :type: str
        """
        

        self._activity_code = activity_code

    @property
    def points(self):
        """
        Gets the points of this GamificationScorecardChangeTopicPunctualityEvent.


        :return: The points of this GamificationScorecardChangeTopicPunctualityEvent.
        :rtype: int
        """
        return self._points

    @points.setter
    def points(self, points):
        """
        Sets the points of this GamificationScorecardChangeTopicPunctualityEvent.


        :param points: The points of this GamificationScorecardChangeTopicPunctualityEvent.
        :type: int
        """
        

        self._points = points

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

