# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class BatchConversationEventRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        BatchConversationEventRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'end_transfer_events': 'list[EndTransferEvent]',
            'phone_transfer_events': 'list[PhoneTransferEvent]',
            'progress_transfer_events': 'list[ProgressTransferEvent]',
            'routing_transfer_events': 'list[RoutingTransferEvent]',
            'user_transfer_events': 'list[UserTransferEvent]',
            'communication_answered_events': 'list[CommunicationAnsweredEvent]',
            'communication_disposition_applied_events': 'list[CommunicationDispositionAppliedEvent]',
            'hold_updated_events': 'list[HoldUpdatedEvent]',
            'external_established_events': 'list[ExternalEstablishedEvent]',
            'ivr_established_events': 'list[IvrEstablishedEvent]',
            'phone_established_events': 'list[PhoneEstablishedEvent]',
            'routing_established_events': 'list[RoutingEstablishedEvent]',
            'user_established_events': 'list[UserEstablishedEvent]',
            'audio_updated_events': 'list[AudioUpdatedEvent]',
            'communication_ended_events': 'list[CommunicationEndedEvent]',
            'consult_transfer_events': 'list[ConsultTransferEvent]',
            'progress_consult_transfer_events': 'list[ProgressConsultTransferEvent]',
            'end_consult_transfer_events': 'list[EndConsultTransferEvent]'
        }

        self.attribute_map = {
            'end_transfer_events': 'endTransferEvents',
            'phone_transfer_events': 'phoneTransferEvents',
            'progress_transfer_events': 'progressTransferEvents',
            'routing_transfer_events': 'routingTransferEvents',
            'user_transfer_events': 'userTransferEvents',
            'communication_answered_events': 'communicationAnsweredEvents',
            'communication_disposition_applied_events': 'communicationDispositionAppliedEvents',
            'hold_updated_events': 'holdUpdatedEvents',
            'external_established_events': 'externalEstablishedEvents',
            'ivr_established_events': 'ivrEstablishedEvents',
            'phone_established_events': 'phoneEstablishedEvents',
            'routing_established_events': 'routingEstablishedEvents',
            'user_established_events': 'userEstablishedEvents',
            'audio_updated_events': 'audioUpdatedEvents',
            'communication_ended_events': 'communicationEndedEvents',
            'consult_transfer_events': 'consultTransferEvents',
            'progress_consult_transfer_events': 'progressConsultTransferEvents',
            'end_consult_transfer_events': 'endConsultTransferEvents'
        }

        self._end_transfer_events = None
        self._phone_transfer_events = None
        self._progress_transfer_events = None
        self._routing_transfer_events = None
        self._user_transfer_events = None
        self._communication_answered_events = None
        self._communication_disposition_applied_events = None
        self._hold_updated_events = None
        self._external_established_events = None
        self._ivr_established_events = None
        self._phone_established_events = None
        self._routing_established_events = None
        self._user_established_events = None
        self._audio_updated_events = None
        self._communication_ended_events = None
        self._consult_transfer_events = None
        self._progress_consult_transfer_events = None
        self._end_consult_transfer_events = None

    @property
    def end_transfer_events(self):
        """
        Gets the end_transfer_events of this BatchConversationEventRequest.
        EndTransfer events for this batch

        :return: The end_transfer_events of this BatchConversationEventRequest.
        :rtype: list[EndTransferEvent]
        """
        return self._end_transfer_events

    @end_transfer_events.setter
    def end_transfer_events(self, end_transfer_events):
        """
        Sets the end_transfer_events of this BatchConversationEventRequest.
        EndTransfer events for this batch

        :param end_transfer_events: The end_transfer_events of this BatchConversationEventRequest.
        :type: list[EndTransferEvent]
        """
        

        self._end_transfer_events = end_transfer_events

    @property
    def phone_transfer_events(self):
        """
        Gets the phone_transfer_events of this BatchConversationEventRequest.
        PhoneTransfer events for this batch

        :return: The phone_transfer_events of this BatchConversationEventRequest.
        :rtype: list[PhoneTransferEvent]
        """
        return self._phone_transfer_events

    @phone_transfer_events.setter
    def phone_transfer_events(self, phone_transfer_events):
        """
        Sets the phone_transfer_events of this BatchConversationEventRequest.
        PhoneTransfer events for this batch

        :param phone_transfer_events: The phone_transfer_events of this BatchConversationEventRequest.
        :type: list[PhoneTransferEvent]
        """
        

        self._phone_transfer_events = phone_transfer_events

    @property
    def progress_transfer_events(self):
        """
        Gets the progress_transfer_events of this BatchConversationEventRequest.
        ProgressTransfer events for this batch

        :return: The progress_transfer_events of this BatchConversationEventRequest.
        :rtype: list[ProgressTransferEvent]
        """
        return self._progress_transfer_events

    @progress_transfer_events.setter
    def progress_transfer_events(self, progress_transfer_events):
        """
        Sets the progress_transfer_events of this BatchConversationEventRequest.
        ProgressTransfer events for this batch

        :param progress_transfer_events: The progress_transfer_events of this BatchConversationEventRequest.
        :type: list[ProgressTransferEvent]
        """
        

        self._progress_transfer_events = progress_transfer_events

    @property
    def routing_transfer_events(self):
        """
        Gets the routing_transfer_events of this BatchConversationEventRequest.
        RoutingTransfer events for this batch

        :return: The routing_transfer_events of this BatchConversationEventRequest.
        :rtype: list[RoutingTransferEvent]
        """
        return self._routing_transfer_events

    @routing_transfer_events.setter
    def routing_transfer_events(self, routing_transfer_events):
        """
        Sets the routing_transfer_events of this BatchConversationEventRequest.
        RoutingTransfer events for this batch

        :param routing_transfer_events: The routing_transfer_events of this BatchConversationEventRequest.
        :type: list[RoutingTransferEvent]
        """
        

        self._routing_transfer_events = routing_transfer_events

    @property
    def user_transfer_events(self):
        """
        Gets the user_transfer_events of this BatchConversationEventRequest.
        UserTransfer events for this batch

        :return: The user_transfer_events of this BatchConversationEventRequest.
        :rtype: list[UserTransferEvent]
        """
        return self._user_transfer_events

    @user_transfer_events.setter
    def user_transfer_events(self, user_transfer_events):
        """
        Sets the user_transfer_events of this BatchConversationEventRequest.
        UserTransfer events for this batch

        :param user_transfer_events: The user_transfer_events of this BatchConversationEventRequest.
        :type: list[UserTransferEvent]
        """
        

        self._user_transfer_events = user_transfer_events

    @property
    def communication_answered_events(self):
        """
        Gets the communication_answered_events of this BatchConversationEventRequest.
        CommunicationAnswered events for this batch

        :return: The communication_answered_events of this BatchConversationEventRequest.
        :rtype: list[CommunicationAnsweredEvent]
        """
        return self._communication_answered_events

    @communication_answered_events.setter
    def communication_answered_events(self, communication_answered_events):
        """
        Sets the communication_answered_events of this BatchConversationEventRequest.
        CommunicationAnswered events for this batch

        :param communication_answered_events: The communication_answered_events of this BatchConversationEventRequest.
        :type: list[CommunicationAnsweredEvent]
        """
        

        self._communication_answered_events = communication_answered_events

    @property
    def communication_disposition_applied_events(self):
        """
        Gets the communication_disposition_applied_events of this BatchConversationEventRequest.
        CommunicationDispositionApplied events for this batch

        :return: The communication_disposition_applied_events of this BatchConversationEventRequest.
        :rtype: list[CommunicationDispositionAppliedEvent]
        """
        return self._communication_disposition_applied_events

    @communication_disposition_applied_events.setter
    def communication_disposition_applied_events(self, communication_disposition_applied_events):
        """
        Sets the communication_disposition_applied_events of this BatchConversationEventRequest.
        CommunicationDispositionApplied events for this batch

        :param communication_disposition_applied_events: The communication_disposition_applied_events of this BatchConversationEventRequest.
        :type: list[CommunicationDispositionAppliedEvent]
        """
        

        self._communication_disposition_applied_events = communication_disposition_applied_events

    @property
    def hold_updated_events(self):
        """
        Gets the hold_updated_events of this BatchConversationEventRequest.
        HoldUpdated events for this batch

        :return: The hold_updated_events of this BatchConversationEventRequest.
        :rtype: list[HoldUpdatedEvent]
        """
        return self._hold_updated_events

    @hold_updated_events.setter
    def hold_updated_events(self, hold_updated_events):
        """
        Sets the hold_updated_events of this BatchConversationEventRequest.
        HoldUpdated events for this batch

        :param hold_updated_events: The hold_updated_events of this BatchConversationEventRequest.
        :type: list[HoldUpdatedEvent]
        """
        

        self._hold_updated_events = hold_updated_events

    @property
    def external_established_events(self):
        """
        Gets the external_established_events of this BatchConversationEventRequest.
        ExternalEstablished events for this batch

        :return: The external_established_events of this BatchConversationEventRequest.
        :rtype: list[ExternalEstablishedEvent]
        """
        return self._external_established_events

    @external_established_events.setter
    def external_established_events(self, external_established_events):
        """
        Sets the external_established_events of this BatchConversationEventRequest.
        ExternalEstablished events for this batch

        :param external_established_events: The external_established_events of this BatchConversationEventRequest.
        :type: list[ExternalEstablishedEvent]
        """
        

        self._external_established_events = external_established_events

    @property
    def ivr_established_events(self):
        """
        Gets the ivr_established_events of this BatchConversationEventRequest.
        IvrEstablished events for this batch

        :return: The ivr_established_events of this BatchConversationEventRequest.
        :rtype: list[IvrEstablishedEvent]
        """
        return self._ivr_established_events

    @ivr_established_events.setter
    def ivr_established_events(self, ivr_established_events):
        """
        Sets the ivr_established_events of this BatchConversationEventRequest.
        IvrEstablished events for this batch

        :param ivr_established_events: The ivr_established_events of this BatchConversationEventRequest.
        :type: list[IvrEstablishedEvent]
        """
        

        self._ivr_established_events = ivr_established_events

    @property
    def phone_established_events(self):
        """
        Gets the phone_established_events of this BatchConversationEventRequest.
        PhoneEstablished events for this batch

        :return: The phone_established_events of this BatchConversationEventRequest.
        :rtype: list[PhoneEstablishedEvent]
        """
        return self._phone_established_events

    @phone_established_events.setter
    def phone_established_events(self, phone_established_events):
        """
        Sets the phone_established_events of this BatchConversationEventRequest.
        PhoneEstablished events for this batch

        :param phone_established_events: The phone_established_events of this BatchConversationEventRequest.
        :type: list[PhoneEstablishedEvent]
        """
        

        self._phone_established_events = phone_established_events

    @property
    def routing_established_events(self):
        """
        Gets the routing_established_events of this BatchConversationEventRequest.
        RoutingEstablished events for this batch

        :return: The routing_established_events of this BatchConversationEventRequest.
        :rtype: list[RoutingEstablishedEvent]
        """
        return self._routing_established_events

    @routing_established_events.setter
    def routing_established_events(self, routing_established_events):
        """
        Sets the routing_established_events of this BatchConversationEventRequest.
        RoutingEstablished events for this batch

        :param routing_established_events: The routing_established_events of this BatchConversationEventRequest.
        :type: list[RoutingEstablishedEvent]
        """
        

        self._routing_established_events = routing_established_events

    @property
    def user_established_events(self):
        """
        Gets the user_established_events of this BatchConversationEventRequest.
        UserEstablished events for this batch

        :return: The user_established_events of this BatchConversationEventRequest.
        :rtype: list[UserEstablishedEvent]
        """
        return self._user_established_events

    @user_established_events.setter
    def user_established_events(self, user_established_events):
        """
        Sets the user_established_events of this BatchConversationEventRequest.
        UserEstablished events for this batch

        :param user_established_events: The user_established_events of this BatchConversationEventRequest.
        :type: list[UserEstablishedEvent]
        """
        

        self._user_established_events = user_established_events

    @property
    def audio_updated_events(self):
        """
        Gets the audio_updated_events of this BatchConversationEventRequest.
        AudioUpdated events for this batch

        :return: The audio_updated_events of this BatchConversationEventRequest.
        :rtype: list[AudioUpdatedEvent]
        """
        return self._audio_updated_events

    @audio_updated_events.setter
    def audio_updated_events(self, audio_updated_events):
        """
        Sets the audio_updated_events of this BatchConversationEventRequest.
        AudioUpdated events for this batch

        :param audio_updated_events: The audio_updated_events of this BatchConversationEventRequest.
        :type: list[AudioUpdatedEvent]
        """
        

        self._audio_updated_events = audio_updated_events

    @property
    def communication_ended_events(self):
        """
        Gets the communication_ended_events of this BatchConversationEventRequest.
        CommunicationEnded events for this batch

        :return: The communication_ended_events of this BatchConversationEventRequest.
        :rtype: list[CommunicationEndedEvent]
        """
        return self._communication_ended_events

    @communication_ended_events.setter
    def communication_ended_events(self, communication_ended_events):
        """
        Sets the communication_ended_events of this BatchConversationEventRequest.
        CommunicationEnded events for this batch

        :param communication_ended_events: The communication_ended_events of this BatchConversationEventRequest.
        :type: list[CommunicationEndedEvent]
        """
        

        self._communication_ended_events = communication_ended_events

    @property
    def consult_transfer_events(self):
        """
        Gets the consult_transfer_events of this BatchConversationEventRequest.
        ConsultTransfer events for this batch

        :return: The consult_transfer_events of this BatchConversationEventRequest.
        :rtype: list[ConsultTransferEvent]
        """
        return self._consult_transfer_events

    @consult_transfer_events.setter
    def consult_transfer_events(self, consult_transfer_events):
        """
        Sets the consult_transfer_events of this BatchConversationEventRequest.
        ConsultTransfer events for this batch

        :param consult_transfer_events: The consult_transfer_events of this BatchConversationEventRequest.
        :type: list[ConsultTransferEvent]
        """
        

        self._consult_transfer_events = consult_transfer_events

    @property
    def progress_consult_transfer_events(self):
        """
        Gets the progress_consult_transfer_events of this BatchConversationEventRequest.
        ProgressConsultTransfer events for this batch

        :return: The progress_consult_transfer_events of this BatchConversationEventRequest.
        :rtype: list[ProgressConsultTransferEvent]
        """
        return self._progress_consult_transfer_events

    @progress_consult_transfer_events.setter
    def progress_consult_transfer_events(self, progress_consult_transfer_events):
        """
        Sets the progress_consult_transfer_events of this BatchConversationEventRequest.
        ProgressConsultTransfer events for this batch

        :param progress_consult_transfer_events: The progress_consult_transfer_events of this BatchConversationEventRequest.
        :type: list[ProgressConsultTransferEvent]
        """
        

        self._progress_consult_transfer_events = progress_consult_transfer_events

    @property
    def end_consult_transfer_events(self):
        """
        Gets the end_consult_transfer_events of this BatchConversationEventRequest.
        EndConsultTransfer events for this batch

        :return: The end_consult_transfer_events of this BatchConversationEventRequest.
        :rtype: list[EndConsultTransferEvent]
        """
        return self._end_consult_transfer_events

    @end_consult_transfer_events.setter
    def end_consult_transfer_events(self, end_consult_transfer_events):
        """
        Sets the end_consult_transfer_events of this BatchConversationEventRequest.
        EndConsultTransfer events for this batch

        :param end_consult_transfer_events: The end_consult_transfer_events of this BatchConversationEventRequest.
        :type: list[EndConsultTransferEvent]
        """
        

        self._end_consult_transfer_events = end_consult_transfer_events

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

