# coding: utf-8

"""
CoachingApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class CoachingApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def delete_coaching_appointment(self, appointment_id, **kwargs):
        """
        Delete an existing appointment
        Permission not required if you are the creator of the appointment

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_coaching_appointment(appointment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str appointment_id: The ID of the coaching appointment. (required)
        :return: CoachingAppointmentReference
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['appointment_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_coaching_appointment" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'appointment_id' is set
        if ('appointment_id' not in params) or (params['appointment_id'] is None):
            raise ValueError("Missing the required parameter `appointment_id` when calling `delete_coaching_appointment`")


        resource_path = '/api/v2/coaching/appointments/{appointmentId}'.replace('{format}', 'json')
        path_params = {}
        if 'appointment_id' in params:
            path_params['appointmentId'] = params['appointment_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CoachingAppointmentReference',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_coaching_appointment_annotation(self, appointment_id, annotation_id, **kwargs):
        """
        Delete an existing annotation
        You must have the appropriate permission for the type of annotation you are updating. Permission not required if you are the creator or facilitator of the appointment

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_coaching_appointment_annotation(appointment_id, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str appointment_id: The ID of the coaching appointment. (required)
        :param str annotation_id: The ID of the annotation. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['appointment_id', 'annotation_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_coaching_appointment_annotation" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'appointment_id' is set
        if ('appointment_id' not in params) or (params['appointment_id'] is None):
            raise ValueError("Missing the required parameter `appointment_id` when calling `delete_coaching_appointment_annotation`")
        # verify the required parameter 'annotation_id' is set
        if ('annotation_id' not in params) or (params['annotation_id'] is None):
            raise ValueError("Missing the required parameter `annotation_id` when calling `delete_coaching_appointment_annotation`")


        resource_path = '/api/v2/coaching/appointments/{appointmentId}/annotations/{annotationId}'.replace('{format}', 'json')
        path_params = {}
        if 'appointment_id' in params:
            path_params['appointmentId'] = params['appointment_id']
        if 'annotation_id' in params:
            path_params['annotationId'] = params['annotation_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_coaching_appointment(self, appointment_id, **kwargs):
        """
        Retrieve an appointment
        Permission not required if you are the attendee, creator or facilitator of the appointment

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_coaching_appointment(appointment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str appointment_id: The ID of the coaching appointment. (required)
        :return: CoachingAppointmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['appointment_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_coaching_appointment" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'appointment_id' is set
        if ('appointment_id' not in params) or (params['appointment_id'] is None):
            raise ValueError("Missing the required parameter `appointment_id` when calling `get_coaching_appointment`")


        resource_path = '/api/v2/coaching/appointments/{appointmentId}'.replace('{format}', 'json')
        path_params = {}
        if 'appointment_id' in params:
            path_params['appointmentId'] = params['appointment_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CoachingAppointmentResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_coaching_appointment_annotation(self, appointment_id, annotation_id, **kwargs):
        """
        Retrieve an annotation.
        You must have the appropriate permission for the type of annotation you are creating. Permission not required if you are related to the appointment (only the creator or facilitator can view private annotations).

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_coaching_appointment_annotation(appointment_id, annotation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str appointment_id: The ID of the coaching appointment. (required)
        :param str annotation_id: The ID of the annotation. (required)
        :return: CoachingAnnotation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['appointment_id', 'annotation_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_coaching_appointment_annotation" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'appointment_id' is set
        if ('appointment_id' not in params) or (params['appointment_id'] is None):
            raise ValueError("Missing the required parameter `appointment_id` when calling `get_coaching_appointment_annotation`")
        # verify the required parameter 'annotation_id' is set
        if ('annotation_id' not in params) or (params['annotation_id'] is None):
            raise ValueError("Missing the required parameter `annotation_id` when calling `get_coaching_appointment_annotation`")


        resource_path = '/api/v2/coaching/appointments/{appointmentId}/annotations/{annotationId}'.replace('{format}', 'json')
        path_params = {}
        if 'appointment_id' in params:
            path_params['appointmentId'] = params['appointment_id']
        if 'annotation_id' in params:
            path_params['annotationId'] = params['annotation_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CoachingAnnotation',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_coaching_appointment_annotations(self, appointment_id, **kwargs):
        """
        Get a list of annotations.
        You must have the appropriate permission for the type of annotation you are creating. Permission not required if you are related to the appointment (only the creator or facilitator can view private annotations).

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_coaching_appointment_annotations(appointment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str appointment_id: The ID of the coaching appointment. (required)
        :param int page_number: Page number
        :param int page_size: Page size
        :return: CoachingAnnotationList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['appointment_id', 'page_number', 'page_size']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_coaching_appointment_annotations" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'appointment_id' is set
        if ('appointment_id' not in params) or (params['appointment_id'] is None):
            raise ValueError("Missing the required parameter `appointment_id` when calling `get_coaching_appointment_annotations`")


        resource_path = '/api/v2/coaching/appointments/{appointmentId}/annotations'.replace('{format}', 'json')
        path_params = {}
        if 'appointment_id' in params:
            path_params['appointmentId'] = params['appointment_id']

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CoachingAnnotationList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_coaching_appointment_statuses(self, appointment_id, **kwargs):
        """
        Get the list of status changes for a coaching appointment.
        Permission not required if you are an attendee, creator or facilitator of the appointment

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_coaching_appointment_statuses(appointment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str appointment_id: The ID of the coaching appointment. (required)
        :param int page_number: Page number
        :param int page_size: Page size
        :return: CoachingAppointmentStatusResponseList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['appointment_id', 'page_number', 'page_size']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_coaching_appointment_statuses" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'appointment_id' is set
        if ('appointment_id' not in params) or (params['appointment_id'] is None):
            raise ValueError("Missing the required parameter `appointment_id` when calling `get_coaching_appointment_statuses`")


        resource_path = '/api/v2/coaching/appointments/{appointmentId}/statuses'.replace('{format}', 'json')
        path_params = {}
        if 'appointment_id' in params:
            path_params['appointmentId'] = params['appointment_id']

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CoachingAppointmentStatusResponseList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_coaching_appointments(self, user_ids, **kwargs):
        """
        Get appointments for users and optional date range
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_coaching_appointments(user_ids, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] user_ids: The user IDs for which to retrieve appointments (required)
        :param str interval: Interval to filter data by. End date is not inclusive. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss
        :param int page_number: Page number
        :param int page_size: Page size
        :param list[str] statuses: Appointment Statuses to filter by
        :param list[str] facilitator_ids: The facilitator IDs for which to retrieve appointments
        :param str sort_order: Sort (by due date) either Asc or Desc
        :param list[str] relationships: Relationships to filter by
        :param str completion_interval: Appointment completion start and end to filter by. End date is not inclusive. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss
        :param str overdue: Overdue status to filter by
        :param str interval_condition: Filter condition for interval
        :return: CoachingAppointmentResponseList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_ids', 'interval', 'page_number', 'page_size', 'statuses', 'facilitator_ids', 'sort_order', 'relationships', 'completion_interval', 'overdue', 'interval_condition']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_coaching_appointments" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_ids' is set
        if ('user_ids' not in params) or (params['user_ids'] is None):
            raise ValueError("Missing the required parameter `user_ids` when calling `get_coaching_appointments`")


        resource_path = '/api/v2/coaching/appointments'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'user_ids' in params:
            query_params['userIds'] = params['user_ids']
        if 'interval' in params:
            query_params['interval'] = params['interval']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'statuses' in params:
            query_params['statuses'] = params['statuses']
        if 'facilitator_ids' in params:
            query_params['facilitatorIds'] = params['facilitator_ids']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'relationships' in params:
            query_params['relationships'] = params['relationships']
        if 'completion_interval' in params:
            query_params['completionInterval'] = params['completion_interval']
        if 'overdue' in params:
            query_params['overdue'] = params['overdue']
        if 'interval_condition' in params:
            query_params['intervalCondition'] = params['interval_condition']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CoachingAppointmentResponseList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_coaching_appointments_me(self, **kwargs):
        """
        Get my appointments for a given date range
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_coaching_appointments_me(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str interval: Interval to filter data by. End date is not inclusive. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss
        :param int page_number: Page number
        :param int page_size: Page size
        :param list[str] statuses: Appointment Statuses to filter by
        :param list[str] facilitator_ids: The facilitator IDs for which to retrieve appointments
        :param str sort_order: Sort (by due date) either Asc or Desc
        :param list[str] relationships: Relationships to filter by
        :param str completion_interval: Appointment completion start and end to filter by. End date is not inclusive. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss
        :param str overdue: Overdue status to filter by
        :param str interval_condition: Filter condition for interval
        :return: CoachingAppointmentResponseList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['interval', 'page_number', 'page_size', 'statuses', 'facilitator_ids', 'sort_order', 'relationships', 'completion_interval', 'overdue', 'interval_condition']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_coaching_appointments_me" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/coaching/appointments/me'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'interval' in params:
            query_params['interval'] = params['interval']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'statuses' in params:
            query_params['statuses'] = params['statuses']
        if 'facilitator_ids' in params:
            query_params['facilitatorIds'] = params['facilitator_ids']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'relationships' in params:
            query_params['relationships'] = params['relationships']
        if 'completion_interval' in params:
            query_params['completionInterval'] = params['completion_interval']
        if 'overdue' in params:
            query_params['overdue'] = params['overdue']
        if 'interval_condition' in params:
            query_params['intervalCondition'] = params['interval_condition']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CoachingAppointmentResponseList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_coaching_notification(self, notification_id, **kwargs):
        """
        Get an existing notification
        Permission not required if you are the owner of the notification.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_coaching_notification(notification_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str notification_id: The ID of the notification. (required)
        :param list[str] expand: Indicates a field in the response which should be expanded.
        :return: CoachingNotification
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['notification_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_coaching_notification" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'notification_id' is set
        if ('notification_id' not in params) or (params['notification_id'] is None):
            raise ValueError("Missing the required parameter `notification_id` when calling `get_coaching_notification`")


        resource_path = '/api/v2/coaching/notifications/{notificationId}'.replace('{format}', 'json')
        path_params = {}
        if 'notification_id' in params:
            path_params['notificationId'] = params['notification_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CoachingNotification',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_coaching_notifications(self, **kwargs):
        """
        Retrieve the list of your notifications.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_coaching_notifications(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: Page number
        :param int page_size: Page size
        :param list[str] expand: Indicates a field in the response which should be expanded.
        :return: CoachingNotificationList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_coaching_notifications" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/coaching/notifications'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CoachingNotificationList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_coaching_appointment(self, appointment_id, body, **kwargs):
        """
        Update an existing appointment
        Permission not required if you are the creator or facilitator of the appointment

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_coaching_appointment(appointment_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str appointment_id: The ID of the coaching appointment. (required)
        :param UpdateCoachingAppointmentRequest body: The new version of the appointment (required)
        :return: CoachingAppointmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['appointment_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_coaching_appointment" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'appointment_id' is set
        if ('appointment_id' not in params) or (params['appointment_id'] is None):
            raise ValueError("Missing the required parameter `appointment_id` when calling `patch_coaching_appointment`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_coaching_appointment`")


        resource_path = '/api/v2/coaching/appointments/{appointmentId}'.replace('{format}', 'json')
        path_params = {}
        if 'appointment_id' in params:
            path_params['appointmentId'] = params['appointment_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CoachingAppointmentResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_coaching_appointment_annotation(self, appointment_id, annotation_id, body, **kwargs):
        """
        Update an existing annotation.
        You must have the appropriate permission for the type of annotation you are updating. Permission not required if you are the creator or facilitator of the appointment

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_coaching_appointment_annotation(appointment_id, annotation_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str appointment_id: The ID of the coaching appointment. (required)
        :param str annotation_id: The ID of the annotation. (required)
        :param CoachingAnnotation body: The new version of the annotation (required)
        :return: CoachingAnnotation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['appointment_id', 'annotation_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_coaching_appointment_annotation" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'appointment_id' is set
        if ('appointment_id' not in params) or (params['appointment_id'] is None):
            raise ValueError("Missing the required parameter `appointment_id` when calling `patch_coaching_appointment_annotation`")
        # verify the required parameter 'annotation_id' is set
        if ('annotation_id' not in params) or (params['annotation_id'] is None):
            raise ValueError("Missing the required parameter `annotation_id` when calling `patch_coaching_appointment_annotation`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_coaching_appointment_annotation`")


        resource_path = '/api/v2/coaching/appointments/{appointmentId}/annotations/{annotationId}'.replace('{format}', 'json')
        path_params = {}
        if 'appointment_id' in params:
            path_params['appointmentId'] = params['appointment_id']
        if 'annotation_id' in params:
            path_params['annotationId'] = params['annotation_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CoachingAnnotation',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_coaching_appointment_status(self, appointment_id, body, **kwargs):
        """
        Update the status of a coaching appointment
        Permission not required if you are an attendee, creator or facilitator of the appointment

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_coaching_appointment_status(appointment_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str appointment_id: The ID of the coaching appointment. (required)
        :param CoachingAppointmentStatusRequest body: Updated status of the coaching appointment (required)
        :return: CoachingAppointmentStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['appointment_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_coaching_appointment_status" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'appointment_id' is set
        if ('appointment_id' not in params) or (params['appointment_id'] is None):
            raise ValueError("Missing the required parameter `appointment_id` when calling `patch_coaching_appointment_status`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_coaching_appointment_status`")


        resource_path = '/api/v2/coaching/appointments/{appointmentId}/status'.replace('{format}', 'json')
        path_params = {}
        if 'appointment_id' in params:
            path_params['appointmentId'] = params['appointment_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CoachingAppointmentStatusResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_coaching_notification(self, notification_id, body, **kwargs):
        """
        Update an existing notification.
        Can only update your own notifications.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_coaching_notification(notification_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str notification_id: The ID of the notification. (required)
        :param CoachingNotification body: Change the read state of a notification (required)
        :return: CoachingNotification
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['notification_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_coaching_notification" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'notification_id' is set
        if ('notification_id' not in params) or (params['notification_id'] is None):
            raise ValueError("Missing the required parameter `notification_id` when calling `patch_coaching_notification`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_coaching_notification`")


        resource_path = '/api/v2/coaching/notifications/{notificationId}'.replace('{format}', 'json')
        path_params = {}
        if 'notification_id' in params:
            path_params['notificationId'] = params['notification_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CoachingNotification',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_coaching_appointment_annotations(self, appointment_id, body, **kwargs):
        """
        Create a new annotation.
        You must have the appropriate permission for the type of annotation you are creating. Permission not required if you are related to the appointment (only the creator or facilitator can create private annotations).

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_coaching_appointment_annotations(appointment_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str appointment_id: The ID of the coaching appointment. (required)
        :param CoachingAnnotationCreateRequest body: The annotation to add (required)
        :return: CoachingAnnotation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['appointment_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_coaching_appointment_annotations" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'appointment_id' is set
        if ('appointment_id' not in params) or (params['appointment_id'] is None):
            raise ValueError("Missing the required parameter `appointment_id` when calling `post_coaching_appointment_annotations`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_coaching_appointment_annotations`")


        resource_path = '/api/v2/coaching/appointments/{appointmentId}/annotations'.replace('{format}', 'json')
        path_params = {}
        if 'appointment_id' in params:
            path_params['appointmentId'] = params['appointment_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CoachingAnnotation',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_coaching_appointment_conversations(self, appointment_id, body, **kwargs):
        """
        Add a conversation to an appointment
        Permission not required if you are the creator or facilitator of the appointment

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_coaching_appointment_conversations(appointment_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str appointment_id: The ID of the coaching appointment. (required)
        :param AddConversationRequest body: body (required)
        :return: AddConversationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['appointment_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_coaching_appointment_conversations" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'appointment_id' is set
        if ('appointment_id' not in params) or (params['appointment_id'] is None):
            raise ValueError("Missing the required parameter `appointment_id` when calling `post_coaching_appointment_conversations`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_coaching_appointment_conversations`")


        resource_path = '/api/v2/coaching/appointments/{appointmentId}/conversations'.replace('{format}', 'json')
        path_params = {}
        if 'appointment_id' in params:
            path_params['appointmentId'] = params['appointment_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AddConversationResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_coaching_appointments(self, body, **kwargs):
        """
        Create a new appointment
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_coaching_appointments(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CreateCoachingAppointmentRequest body: The appointment to add (required)
        :return: CoachingAppointmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_coaching_appointments" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_coaching_appointments`")


        resource_path = '/api/v2/coaching/appointments'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CoachingAppointmentResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_coaching_appointments_aggregates_query(self, body, **kwargs):
        """
        Retrieve aggregated appointment data
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_coaching_appointments_aggregates_query(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CoachingAppointmentAggregateRequest body: Aggregate Request (required)
        :return: CoachingAppointmentAggregateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_coaching_appointments_aggregates_query" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_coaching_appointments_aggregates_query`")


        resource_path = '/api/v2/coaching/appointments/aggregates/query'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CoachingAppointmentAggregateResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_coaching_scheduleslots_query(self, body, **kwargs):
        """
        Get list of possible slots where a coaching appointment can be scheduled.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_coaching_scheduleslots_query(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CoachingSlotsRequest body: The slot search request (required)
        :return: CoachingSlotsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_coaching_scheduleslots_query" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_coaching_scheduleslots_query`")


        resource_path = '/api/v2/coaching/scheduleslots/query'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CoachingSlotsResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
