# coding: utf-8

"""
    convertapi

    Convert API lets you effortlessly convert file formats and types.  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class ConvertedJpgPage(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'page_number': 'int',
        'content': 'str'
    }

    attribute_map = {
        'page_number': 'PageNumber',
        'content': 'Content'
    }

    def __init__(self, page_number=None, content=None):  # noqa: E501
        """ConvertedJpgPage - a model defined in Swagger"""  # noqa: E501

        self._page_number = None
        self._content = None
        self.discriminator = None

        if page_number is not None:
            self.page_number = page_number
        if content is not None:
            self.content = content

    @property
    def page_number(self):
        """Gets the page_number of this ConvertedJpgPage.  # noqa: E501

        Page number of the converted page, starting with 1  # noqa: E501

        :return: The page_number of this ConvertedJpgPage.  # noqa: E501
        :rtype: int
        """
        return self._page_number

    @page_number.setter
    def page_number(self, page_number):
        """Sets the page_number of this ConvertedJpgPage.

        Page number of the converted page, starting with 1  # noqa: E501

        :param page_number: The page_number of this ConvertedJpgPage.  # noqa: E501
        :type: int
        """

        self._page_number = page_number

    @property
    def content(self):
        """Gets the content of this ConvertedJpgPage.  # noqa: E501

        The JPG file of this page as a byte array  # noqa: E501

        :return: The content of this ConvertedJpgPage.  # noqa: E501
        :rtype: str
        """
        return self._content

    @content.setter
    def content(self, content):
        """Sets the content of this ConvertedJpgPage.

        The JPG file of this page as a byte array  # noqa: E501

        :param content: The content of this ConvertedJpgPage.  # noqa: E501
        :type: str
        """
        if content is not None and not re.search(r'^(?:[A-Za-z0-9+\/]{4})*(?:[A-Za-z0-9+\/]{2}==|[A-Za-z0-9+\/]{3}=)?$', content):  # noqa: E501
            raise ValueError(r"Invalid value for `content`, must be a follow pattern or equal to `/^(?:[A-Za-z0-9+\/]{4})*(?:[A-Za-z0-9+\/]{2}==|[A-Za-z0-9+\/]{3}=)?$/`")  # noqa: E501

        self._content = content

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ConvertedJpgPage, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ConvertedJpgPage):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
