# AUTOGENERATED! DO NOT EDIT! File to edit: 02_data_process.ipynb (unless otherwise specified).

__all__ = ['get_tokenizer', 'convert_text_to_tensor', 'load_text_from_file']

# Cell
import torch
import torch.nn as nn
import torch.nn.functional as F

# Cell
def get_tokenizer(max_tokens=512):
    from tokenizers import ByteLevelBPETokenizer
    from tokenizers.processors import BertProcessing
    # add error checking
    voc_file = "tokenizer/vocab.json"
    merg_file = "tokenizer/merges.txt"

    import os.path
    if not os.path.isfile(voc_file) or not os.path.isfile(merg_file):
        from .model_api import setup_tokenizer
        setup_tokenizer()

    t = ByteLevelBPETokenizer(
        voc_file,
        merg_file
    )
    t._tokenizer.post_processor = BertProcessing(
        ("</s>", t.token_to_id("</s>")),
        ("<s>", t.token_to_id("<s>")),
    )
    t.enable_truncation(max_tokens)
    t.enable_padding(length=max_tokens, pad_id=t.token_to_id("<pad>"))
    return t

# Cell
def convert_text_to_tensor(text, tokenizer=None):
    if tokenizer is None:
        tokenizer = get_tokenizer()
    enc = tokenizer.encode(text)
    X = torch.tensor(enc.ids).unsqueeze(0)
    Attn = torch.tensor(enc.attention_mask).unsqueeze(0)
    return (X, Attn)

# Cell
def load_text_from_file(file, use_iter=False, mode="r"):
    """change 'r' to read non-regular files, e.g., change to 'rb' to read byte files"""
    # TODO: figure out how to make this an iterator (e.g., use Dataset class in torch?)
    # since it'll save much RAM space
    if mode != 'r':
        print("attention, you're using not regular read mode\n the returning type is not guaranteed to work")
    ret = []
    with open(file, mode) as f:
        for line in f:
            ret.append(line)
    return ret